/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.util.task;

import gov.nasa.giss.util.task.TaskEvent;
import gov.nasa.giss.util.task.TaskListener;
import java.util.ArrayList;
import javax.swing.SwingWorker;

public class Task
extends SwingWorker<Object, Object> {
    private final String description_;
    private final ArrayList<TaskListener> listeners_ = new ArrayList(24);

    public Task() {
        this("");
    }

    public Task(String description) {
        this.description_ = description;
    }

    public String getDescription() {
        return this.description_;
    }

    public boolean isBusy() {
        SwingWorker.StateValue state = this.getState();
        return state == SwingWorker.StateValue.PENDING || state == SwingWorker.StateValue.STARTED;
    }

    protected Object beginTask() {
        return null;
    }

    protected void finishTask() {
    }

    @Override
    public final Object doInBackground() {
        if (this.isCancelled()) {
            return null;
        }
        return this.beginTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void done() {
        boolean cancelled = this.isCancelled();
        if (!cancelled) {
            this.finishTask();
        }
        TaskEvent te = new TaskEvent(this);
        ArrayList<TaskListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            int isize = this.listeners_.size();
            if (isize > 0) {
                for (int i = isize - 1; i >= 0; --i) {
                    if (cancelled) {
                        this.listeners_.get(i).taskCanceled(te);
                        continue;
                    }
                    this.listeners_.get(i).taskCompleted(te);
                }
            }
        }
        this.removeTaskListeners();
        super.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskListener(TaskListener ll) {
        ArrayList<TaskListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            this.listeners_.add(ll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskListener(TaskListener ll) {
        ArrayList<TaskListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            this.listeners_.remove(ll);
        }
    }

    public synchronized void removeTaskListeners() {
        this.listeners_.clear();
    }
}

