/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.bittorrent.peer;

import com.ghostchu.peerbanhelper.bittorrent.peer.PeerFlag;
import com.ghostchu.peerbanhelper.wrapper.PeerAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Peer
extends Comparable<Peer> {
    @NotNull
    public PeerAddress getPeerAddress();

    @Nullable
    public String getPeerId();

    @Nullable
    public String getClientName();

    public long getDownloadSpeed();

    public long getDownloaded();

    public long getUploadSpeed();

    public long getUploaded();

    public double getProgress();

    @Nullable
    public PeerFlag getFlags();

    public boolean isHandshaking();

    @Override
    default public int compareTo(Peer o) {
        return this.getPeerAddress().compareTo(o.getPeerAddress());
    }

    @NotNull
    default public String getCacheKey() {
        return this.getPeerAddress().getIp() + ":" + this.getPeerAddress().getPort();
    }
}

