/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.gui.impl.swing.renderer;

import com.ghostchu.peerbanhelper.util.logger.LogEntry;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;

public class LogEntryRenderer
extends JTextArea
implements ListCellRenderer<LogEntry> {
    private static final Color errorBackground = new Color(255, 204, 187);
    private static final Color warnBackground = new Color(255, 238, 204);
    private static final Color debugBackground = new Color(204, 255, 204);

    public LogEntryRenderer() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends LogEntry> list, LogEntry value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setText(value.content().trim());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            switch (value.level()) {
                case ERROR: {
                    this.setBackground(errorBackground);
                    this.setForeground(Color.BLACK);
                    break;
                }
                case WARN: {
                    this.setBackground(warnBackground);
                    this.setForeground(Color.BLACK);
                    break;
                }
                case DEBUG: {
                    this.setBackground(debugBackground);
                    this.setForeground(Color.BLACK);
                }
            }
        }
        this.setFont(list.getFont());
        this.setSize(list.getWidth(), (int)this.getPreferredSize().getHeight());
        return this;
    }
}

