# SPDX-License-Identifier: MIT
# Copyright (C) 2018-present iced project and contributors

# ⚠️This file was generated by GENERATOR!🦹‍♂️

# pylint: disable=invalid-name
# pylint: disable=line-too-long
# pylint: disable=too-many-lines

"""
x86 instruction code
"""

import typing
if typing.TYPE_CHECKING:
	from ._iced_x86_py import Code
else:
	Code = int

INVALID: Code = 0 # type: ignore
"""
It's an invalid instruction, eg. it's a new unknown instruction, garbage or there's not enough bytes to decode the instruction etc.
"""
DECLAREBYTE: Code = 1 # type: ignore
"""
A ``db``/``.byte`` asm directive that can store 1-16 bytes
"""
DECLAREWORD: Code = 2 # type: ignore
"""
A ``dw``/``.word`` asm directive that can store 1-8 words
"""
DECLAREDWORD: Code = 3 # type: ignore
"""
A ``dd``/``.int`` asm directive that can store 1-4 dwords
"""
DECLAREQWORD: Code = 4 # type: ignore
"""
A ``dq``/``.quad`` asm directive that can store 1-2 qwords
"""
ADD_RM8_R8: Code = 5 # type: ignore
"""
``ADD r/m8, r8``

``00 /r``

``8086+``

``16/32/64-bit``
"""
ADD_RM16_R16: Code = 6 # type: ignore
"""
``ADD r/m16, r16``

``o16 01 /r``

``8086+``

``16/32/64-bit``
"""
ADD_RM32_R32: Code = 7 # type: ignore
"""
``ADD r/m32, r32``

``o32 01 /r``

``386+``

``16/32/64-bit``
"""
ADD_RM64_R64: Code = 8 # type: ignore
"""
``ADD r/m64, r64``

``o64 01 /r``

``X64``

``64-bit``
"""
ADD_R8_RM8: Code = 9 # type: ignore
"""
``ADD r8, r/m8``

``02 /r``

``8086+``

``16/32/64-bit``
"""
ADD_R16_RM16: Code = 10 # type: ignore
"""
``ADD r16, r/m16``

``o16 03 /r``

``8086+``

``16/32/64-bit``
"""
ADD_R32_RM32: Code = 11 # type: ignore
"""
``ADD r32, r/m32``

``o32 03 /r``

``386+``

``16/32/64-bit``
"""
ADD_R64_RM64: Code = 12 # type: ignore
"""
``ADD r64, r/m64``

``o64 03 /r``

``X64``

``64-bit``
"""
ADD_AL_IMM8: Code = 13 # type: ignore
"""
``ADD AL, imm8``

``04 ib``

``8086+``

``16/32/64-bit``
"""
ADD_AX_IMM16: Code = 14 # type: ignore
"""
``ADD AX, imm16``

``o16 05 iw``

``8086+``

``16/32/64-bit``
"""
ADD_EAX_IMM32: Code = 15 # type: ignore
"""
``ADD EAX, imm32``

``o32 05 id``

``386+``

``16/32/64-bit``
"""
ADD_RAX_IMM32: Code = 16 # type: ignore
"""
``ADD RAX, imm32``

``o64 05 id``

``X64``

``64-bit``
"""
PUSHW_ES: Code = 17 # type: ignore
"""
``PUSH ES``

``o16 06``

``8086+``

``16/32-bit``
"""
PUSHD_ES: Code = 18 # type: ignore
"""
``PUSH ES``

``o32 06``

``386+``

``16/32-bit``
"""
POPW_ES: Code = 19 # type: ignore
"""
``POP ES``

``o16 07``

``8086+``

``16/32-bit``
"""
POPD_ES: Code = 20 # type: ignore
"""
``POP ES``

``o32 07``

``386+``

``16/32-bit``
"""
OR_RM8_R8: Code = 21 # type: ignore
"""
``OR r/m8, r8``

``08 /r``

``8086+``

``16/32/64-bit``
"""
OR_RM16_R16: Code = 22 # type: ignore
"""
``OR r/m16, r16``

``o16 09 /r``

``8086+``

``16/32/64-bit``
"""
OR_RM32_R32: Code = 23 # type: ignore
"""
``OR r/m32, r32``

``o32 09 /r``

``386+``

``16/32/64-bit``
"""
OR_RM64_R64: Code = 24 # type: ignore
"""
``OR r/m64, r64``

``o64 09 /r``

``X64``

``64-bit``
"""
OR_R8_RM8: Code = 25 # type: ignore
"""
``OR r8, r/m8``

``0A /r``

``8086+``

``16/32/64-bit``
"""
OR_R16_RM16: Code = 26 # type: ignore
"""
``OR r16, r/m16``

``o16 0B /r``

``8086+``

``16/32/64-bit``
"""
OR_R32_RM32: Code = 27 # type: ignore
"""
``OR r32, r/m32``

``o32 0B /r``

``386+``

``16/32/64-bit``
"""
OR_R64_RM64: Code = 28 # type: ignore
"""
``OR r64, r/m64``

``o64 0B /r``

``X64``

``64-bit``
"""
OR_AL_IMM8: Code = 29 # type: ignore
"""
``OR AL, imm8``

``0C ib``

``8086+``

``16/32/64-bit``
"""
OR_AX_IMM16: Code = 30 # type: ignore
"""
``OR AX, imm16``

``o16 0D iw``

``8086+``

``16/32/64-bit``
"""
OR_EAX_IMM32: Code = 31 # type: ignore
"""
``OR EAX, imm32``

``o32 0D id``

``386+``

``16/32/64-bit``
"""
OR_RAX_IMM32: Code = 32 # type: ignore
"""
``OR RAX, imm32``

``o64 0D id``

``X64``

``64-bit``
"""
PUSHW_CS: Code = 33 # type: ignore
"""
``PUSH CS``

``o16 0E``

``8086+``

``16/32-bit``
"""
PUSHD_CS: Code = 34 # type: ignore
"""
``PUSH CS``

``o32 0E``

``386+``

``16/32-bit``
"""
POPW_CS: Code = 35 # type: ignore
"""
``POP CS``

``o16 0F``

``8086``

``16-bit``
"""
ADC_RM8_R8: Code = 36 # type: ignore
"""
``ADC r/m8, r8``

``10 /r``

``8086+``

``16/32/64-bit``
"""
ADC_RM16_R16: Code = 37 # type: ignore
"""
``ADC r/m16, r16``

``o16 11 /r``

``8086+``

``16/32/64-bit``
"""
ADC_RM32_R32: Code = 38 # type: ignore
"""
``ADC r/m32, r32``

``o32 11 /r``

``386+``

``16/32/64-bit``
"""
ADC_RM64_R64: Code = 39 # type: ignore
"""
``ADC r/m64, r64``

``o64 11 /r``

``X64``

``64-bit``
"""
ADC_R8_RM8: Code = 40 # type: ignore
"""
``ADC r8, r/m8``

``12 /r``

``8086+``

``16/32/64-bit``
"""
ADC_R16_RM16: Code = 41 # type: ignore
"""
``ADC r16, r/m16``

``o16 13 /r``

``8086+``

``16/32/64-bit``
"""
ADC_R32_RM32: Code = 42 # type: ignore
"""
``ADC r32, r/m32``

``o32 13 /r``

``386+``

``16/32/64-bit``
"""
ADC_R64_RM64: Code = 43 # type: ignore
"""
``ADC r64, r/m64``

``o64 13 /r``

``X64``

``64-bit``
"""
ADC_AL_IMM8: Code = 44 # type: ignore
"""
``ADC AL, imm8``

``14 ib``

``8086+``

``16/32/64-bit``
"""
ADC_AX_IMM16: Code = 45 # type: ignore
"""
``ADC AX, imm16``

``o16 15 iw``

``8086+``

``16/32/64-bit``
"""
ADC_EAX_IMM32: Code = 46 # type: ignore
"""
``ADC EAX, imm32``

``o32 15 id``

``386+``

``16/32/64-bit``
"""
ADC_RAX_IMM32: Code = 47 # type: ignore
"""
``ADC RAX, imm32``

``o64 15 id``

``X64``

``64-bit``
"""
PUSHW_SS: Code = 48 # type: ignore
"""
``PUSH SS``

``o16 16``

``8086+``

``16/32-bit``
"""
PUSHD_SS: Code = 49 # type: ignore
"""
``PUSH SS``

``o32 16``

``386+``

``16/32-bit``
"""
POPW_SS: Code = 50 # type: ignore
"""
``POP SS``

``o16 17``

``8086+``

``16/32-bit``
"""
POPD_SS: Code = 51 # type: ignore
"""
``POP SS``

``o32 17``

``386+``

``16/32-bit``
"""
SBB_RM8_R8: Code = 52 # type: ignore
"""
``SBB r/m8, r8``

``18 /r``

``8086+``

``16/32/64-bit``
"""
SBB_RM16_R16: Code = 53 # type: ignore
"""
``SBB r/m16, r16``

``o16 19 /r``

``8086+``

``16/32/64-bit``
"""
SBB_RM32_R32: Code = 54 # type: ignore
"""
``SBB r/m32, r32``

``o32 19 /r``

``386+``

``16/32/64-bit``
"""
SBB_RM64_R64: Code = 55 # type: ignore
"""
``SBB r/m64, r64``

``o64 19 /r``

``X64``

``64-bit``
"""
SBB_R8_RM8: Code = 56 # type: ignore
"""
``SBB r8, r/m8``

``1A /r``

``8086+``

``16/32/64-bit``
"""
SBB_R16_RM16: Code = 57 # type: ignore
"""
``SBB r16, r/m16``

``o16 1B /r``

``8086+``

``16/32/64-bit``
"""
SBB_R32_RM32: Code = 58 # type: ignore
"""
``SBB r32, r/m32``

``o32 1B /r``

``386+``

``16/32/64-bit``
"""
SBB_R64_RM64: Code = 59 # type: ignore
"""
``SBB r64, r/m64``

``o64 1B /r``

``X64``

``64-bit``
"""
SBB_AL_IMM8: Code = 60 # type: ignore
"""
``SBB AL, imm8``

``1C ib``

``8086+``

``16/32/64-bit``
"""
SBB_AX_IMM16: Code = 61 # type: ignore
"""
``SBB AX, imm16``

``o16 1D iw``

``8086+``

``16/32/64-bit``
"""
SBB_EAX_IMM32: Code = 62 # type: ignore
"""
``SBB EAX, imm32``

``o32 1D id``

``386+``

``16/32/64-bit``
"""
SBB_RAX_IMM32: Code = 63 # type: ignore
"""
``SBB RAX, imm32``

``o64 1D id``

``X64``

``64-bit``
"""
PUSHW_DS: Code = 64 # type: ignore
"""
``PUSH DS``

``o16 1E``

``8086+``

``16/32-bit``
"""
PUSHD_DS: Code = 65 # type: ignore
"""
``PUSH DS``

``o32 1E``

``386+``

``16/32-bit``
"""
POPW_DS: Code = 66 # type: ignore
"""
``POP DS``

``o16 1F``

``8086+``

``16/32-bit``
"""
POPD_DS: Code = 67 # type: ignore
"""
``POP DS``

``o32 1F``

``386+``

``16/32-bit``
"""
AND_RM8_R8: Code = 68 # type: ignore
"""
``AND r/m8, r8``

``20 /r``

``8086+``

``16/32/64-bit``
"""
AND_RM16_R16: Code = 69 # type: ignore
"""
``AND r/m16, r16``

``o16 21 /r``

``8086+``

``16/32/64-bit``
"""
AND_RM32_R32: Code = 70 # type: ignore
"""
``AND r/m32, r32``

``o32 21 /r``

``386+``

``16/32/64-bit``
"""
AND_RM64_R64: Code = 71 # type: ignore
"""
``AND r/m64, r64``

``o64 21 /r``

``X64``

``64-bit``
"""
AND_R8_RM8: Code = 72 # type: ignore
"""
``AND r8, r/m8``

``22 /r``

``8086+``

``16/32/64-bit``
"""
AND_R16_RM16: Code = 73 # type: ignore
"""
``AND r16, r/m16``

``o16 23 /r``

``8086+``

``16/32/64-bit``
"""
AND_R32_RM32: Code = 74 # type: ignore
"""
``AND r32, r/m32``

``o32 23 /r``

``386+``

``16/32/64-bit``
"""
AND_R64_RM64: Code = 75 # type: ignore
"""
``AND r64, r/m64``

``o64 23 /r``

``X64``

``64-bit``
"""
AND_AL_IMM8: Code = 76 # type: ignore
"""
``AND AL, imm8``

``24 ib``

``8086+``

``16/32/64-bit``
"""
AND_AX_IMM16: Code = 77 # type: ignore
"""
``AND AX, imm16``

``o16 25 iw``

``8086+``

``16/32/64-bit``
"""
AND_EAX_IMM32: Code = 78 # type: ignore
"""
``AND EAX, imm32``

``o32 25 id``

``386+``

``16/32/64-bit``
"""
AND_RAX_IMM32: Code = 79 # type: ignore
"""
``AND RAX, imm32``

``o64 25 id``

``X64``

``64-bit``
"""
DAA: Code = 80 # type: ignore
"""
``DAA``

``27``

``8086+``

``16/32-bit``
"""
SUB_RM8_R8: Code = 81 # type: ignore
"""
``SUB r/m8, r8``

``28 /r``

``8086+``

``16/32/64-bit``
"""
SUB_RM16_R16: Code = 82 # type: ignore
"""
``SUB r/m16, r16``

``o16 29 /r``

``8086+``

``16/32/64-bit``
"""
SUB_RM32_R32: Code = 83 # type: ignore
"""
``SUB r/m32, r32``

``o32 29 /r``

``386+``

``16/32/64-bit``
"""
SUB_RM64_R64: Code = 84 # type: ignore
"""
``SUB r/m64, r64``

``o64 29 /r``

``X64``

``64-bit``
"""
SUB_R8_RM8: Code = 85 # type: ignore
"""
``SUB r8, r/m8``

``2A /r``

``8086+``

``16/32/64-bit``
"""
SUB_R16_RM16: Code = 86 # type: ignore
"""
``SUB r16, r/m16``

``o16 2B /r``

``8086+``

``16/32/64-bit``
"""
SUB_R32_RM32: Code = 87 # type: ignore
"""
``SUB r32, r/m32``

``o32 2B /r``

``386+``

``16/32/64-bit``
"""
SUB_R64_RM64: Code = 88 # type: ignore
"""
``SUB r64, r/m64``

``o64 2B /r``

``X64``

``64-bit``
"""
SUB_AL_IMM8: Code = 89 # type: ignore
"""
``SUB AL, imm8``

``2C ib``

``8086+``

``16/32/64-bit``
"""
SUB_AX_IMM16: Code = 90 # type: ignore
"""
``SUB AX, imm16``

``o16 2D iw``

``8086+``

``16/32/64-bit``
"""
SUB_EAX_IMM32: Code = 91 # type: ignore
"""
``SUB EAX, imm32``

``o32 2D id``

``386+``

``16/32/64-bit``
"""
SUB_RAX_IMM32: Code = 92 # type: ignore
"""
``SUB RAX, imm32``

``o64 2D id``

``X64``

``64-bit``
"""
DAS: Code = 93 # type: ignore
"""
``DAS``

``2F``

``8086+``

``16/32-bit``
"""
XOR_RM8_R8: Code = 94 # type: ignore
"""
``XOR r/m8, r8``

``30 /r``

``8086+``

``16/32/64-bit``
"""
XOR_RM16_R16: Code = 95 # type: ignore
"""
``XOR r/m16, r16``

``o16 31 /r``

``8086+``

``16/32/64-bit``
"""
XOR_RM32_R32: Code = 96 # type: ignore
"""
``XOR r/m32, r32``

``o32 31 /r``

``386+``

``16/32/64-bit``
"""
XOR_RM64_R64: Code = 97 # type: ignore
"""
``XOR r/m64, r64``

``o64 31 /r``

``X64``

``64-bit``
"""
XOR_R8_RM8: Code = 98 # type: ignore
"""
``XOR r8, r/m8``

``32 /r``

``8086+``

``16/32/64-bit``
"""
XOR_R16_RM16: Code = 99 # type: ignore
"""
``XOR r16, r/m16``

``o16 33 /r``

``8086+``

``16/32/64-bit``
"""
XOR_R32_RM32: Code = 100 # type: ignore
"""
``XOR r32, r/m32``

``o32 33 /r``

``386+``

``16/32/64-bit``
"""
XOR_R64_RM64: Code = 101 # type: ignore
"""
``XOR r64, r/m64``

``o64 33 /r``

``X64``

``64-bit``
"""
XOR_AL_IMM8: Code = 102 # type: ignore
"""
``XOR AL, imm8``

``34 ib``

``8086+``

``16/32/64-bit``
"""
XOR_AX_IMM16: Code = 103 # type: ignore
"""
``XOR AX, imm16``

``o16 35 iw``

``8086+``

``16/32/64-bit``
"""
XOR_EAX_IMM32: Code = 104 # type: ignore
"""
``XOR EAX, imm32``

``o32 35 id``

``386+``

``16/32/64-bit``
"""
XOR_RAX_IMM32: Code = 105 # type: ignore
"""
``XOR RAX, imm32``

``o64 35 id``

``X64``

``64-bit``
"""
AAA: Code = 106 # type: ignore
"""
``AAA``

``37``

``8086+``

``16/32-bit``
"""
CMP_RM8_R8: Code = 107 # type: ignore
"""
``CMP r/m8, r8``

``38 /r``

``8086+``

``16/32/64-bit``
"""
CMP_RM16_R16: Code = 108 # type: ignore
"""
``CMP r/m16, r16``

``o16 39 /r``

``8086+``

``16/32/64-bit``
"""
CMP_RM32_R32: Code = 109 # type: ignore
"""
``CMP r/m32, r32``

``o32 39 /r``

``386+``

``16/32/64-bit``
"""
CMP_RM64_R64: Code = 110 # type: ignore
"""
``CMP r/m64, r64``

``o64 39 /r``

``X64``

``64-bit``
"""
CMP_R8_RM8: Code = 111 # type: ignore
"""
``CMP r8, r/m8``

``3A /r``

``8086+``

``16/32/64-bit``
"""
CMP_R16_RM16: Code = 112 # type: ignore
"""
``CMP r16, r/m16``

``o16 3B /r``

``8086+``

``16/32/64-bit``
"""
CMP_R32_RM32: Code = 113 # type: ignore
"""
``CMP r32, r/m32``

``o32 3B /r``

``386+``

``16/32/64-bit``
"""
CMP_R64_RM64: Code = 114 # type: ignore
"""
``CMP r64, r/m64``

``o64 3B /r``

``X64``

``64-bit``
"""
CMP_AL_IMM8: Code = 115 # type: ignore
"""
``CMP AL, imm8``

``3C ib``

``8086+``

``16/32/64-bit``
"""
CMP_AX_IMM16: Code = 116 # type: ignore
"""
``CMP AX, imm16``

``o16 3D iw``

``8086+``

``16/32/64-bit``
"""
CMP_EAX_IMM32: Code = 117 # type: ignore
"""
``CMP EAX, imm32``

``o32 3D id``

``386+``

``16/32/64-bit``
"""
CMP_RAX_IMM32: Code = 118 # type: ignore
"""
``CMP RAX, imm32``

``o64 3D id``

``X64``

``64-bit``
"""
AAS: Code = 119 # type: ignore
"""
``AAS``

``3F``

``8086+``

``16/32-bit``
"""
INC_R16: Code = 120 # type: ignore
"""
``INC r16``

``o16 40+rw``

``8086+``

``16/32-bit``
"""
INC_R32: Code = 121 # type: ignore
"""
``INC r32``

``o32 40+rd``

``386+``

``16/32-bit``
"""
DEC_R16: Code = 122 # type: ignore
"""
``DEC r16``

``o16 48+rw``

``8086+``

``16/32-bit``
"""
DEC_R32: Code = 123 # type: ignore
"""
``DEC r32``

``o32 48+rd``

``386+``

``16/32-bit``
"""
PUSH_R16: Code = 124 # type: ignore
"""
``PUSH r16``

``o16 50+rw``

``8086+``

``16/32/64-bit``
"""
PUSH_R32: Code = 125 # type: ignore
"""
``PUSH r32``

``o32 50+rd``

``386+``

``16/32-bit``
"""
PUSH_R64: Code = 126 # type: ignore
"""
``PUSH r64``

``o64 50+ro``

``X64``

``64-bit``
"""
POP_R16: Code = 127 # type: ignore
"""
``POP r16``

``o16 58+rw``

``8086+``

``16/32/64-bit``
"""
POP_R32: Code = 128 # type: ignore
"""
``POP r32``

``o32 58+rd``

``386+``

``16/32-bit``
"""
POP_R64: Code = 129 # type: ignore
"""
``POP r64``

``o64 58+ro``

``X64``

``64-bit``
"""
PUSHAW: Code = 130 # type: ignore
"""
``PUSHA``

``o16 60``

``186+``

``16/32-bit``
"""
PUSHAD: Code = 131 # type: ignore
"""
``PUSHAD``

``o32 60``

``386+``

``16/32-bit``
"""
POPAW: Code = 132 # type: ignore
"""
``POPA``

``o16 61``

``186+``

``16/32-bit``
"""
POPAD: Code = 133 # type: ignore
"""
``POPAD``

``o32 61``

``386+``

``16/32-bit``
"""
BOUND_R16_M1616: Code = 134 # type: ignore
"""
``BOUND r16, m16&16``

``o16 62 /r``

``186+``

``16/32-bit``
"""
BOUND_R32_M3232: Code = 135 # type: ignore
"""
``BOUND r32, m32&32``

``o32 62 /r``

``386+``

``16/32-bit``
"""
ARPL_RM16_R16: Code = 136 # type: ignore
"""
``ARPL r/m16, r16``

``o16 63 /r``

``286+``

``16/32-bit``
"""
ARPL_R32M16_R32: Code = 137 # type: ignore
"""
``ARPL r32/m16, r32``

``o32 63 /r``

``386+``

``16/32-bit``
"""
MOVSXD_R16_RM16: Code = 138 # type: ignore
"""
``MOVSXD r16, r/m16``

``o16 63 /r``

``X64``

``64-bit``
"""
MOVSXD_R32_RM32: Code = 139 # type: ignore
"""
``MOVSXD r32, r/m32``

``o32 63 /r``

``X64``

``64-bit``
"""
MOVSXD_R64_RM32: Code = 140 # type: ignore
"""
``MOVSXD r64, r/m32``

``o64 63 /r``

``X64``

``64-bit``
"""
PUSH_IMM16: Code = 141 # type: ignore
"""
``PUSH imm16``

``o16 68 iw``

``186+``

``16/32/64-bit``
"""
PUSHD_IMM32: Code = 142 # type: ignore
"""
``PUSH imm32``

``o32 68 id``

``386+``

``16/32-bit``
"""
PUSHQ_IMM32: Code = 143 # type: ignore
"""
``PUSH imm32``

``o64 68 id``

``X64``

``64-bit``
"""
IMUL_R16_RM16_IMM16: Code = 144 # type: ignore
"""
``IMUL r16, r/m16, imm16``

``o16 69 /r iw``

``186+``

``16/32/64-bit``
"""
IMUL_R32_RM32_IMM32: Code = 145 # type: ignore
"""
``IMUL r32, r/m32, imm32``

``o32 69 /r id``

``386+``

``16/32/64-bit``
"""
IMUL_R64_RM64_IMM32: Code = 146 # type: ignore
"""
``IMUL r64, r/m64, imm32``

``o64 69 /r id``

``X64``

``64-bit``
"""
PUSHW_IMM8: Code = 147 # type: ignore
"""
``PUSH imm8``

``o16 6A ib``

``186+``

``16/32/64-bit``
"""
PUSHD_IMM8: Code = 148 # type: ignore
"""
``PUSH imm8``

``o32 6A ib``

``386+``

``16/32-bit``
"""
PUSHQ_IMM8: Code = 149 # type: ignore
"""
``PUSH imm8``

``o64 6A ib``

``X64``

``64-bit``
"""
IMUL_R16_RM16_IMM8: Code = 150 # type: ignore
"""
``IMUL r16, r/m16, imm8``

``o16 6B /r ib``

``186+``

``16/32/64-bit``
"""
IMUL_R32_RM32_IMM8: Code = 151 # type: ignore
"""
``IMUL r32, r/m32, imm8``

``o32 6B /r ib``

``386+``

``16/32/64-bit``
"""
IMUL_R64_RM64_IMM8: Code = 152 # type: ignore
"""
``IMUL r64, r/m64, imm8``

``o64 6B /r ib``

``X64``

``64-bit``
"""
INSB_M8_DX: Code = 153 # type: ignore
"""
``INSB``

``6C``

``186+``

``16/32/64-bit``
"""
INSW_M16_DX: Code = 154 # type: ignore
"""
``INSW``

``o16 6D``

``186+``

``16/32/64-bit``
"""
INSD_M32_DX: Code = 155 # type: ignore
"""
``INSD``

``o32 6D``

``386+``

``16/32/64-bit``
"""
OUTSB_DX_M8: Code = 156 # type: ignore
"""
``OUTSB``

``6E``

``186+``

``16/32/64-bit``
"""
OUTSW_DX_M16: Code = 157 # type: ignore
"""
``OUTSW``

``o16 6F``

``186+``

``16/32/64-bit``
"""
OUTSD_DX_M32: Code = 158 # type: ignore
"""
``OUTSD``

``o32 6F``

``386+``

``16/32/64-bit``
"""
JO_REL8_16: Code = 159 # type: ignore
"""
``JO rel8``

``o16 70 cb``

``8086+``

``16/32/64-bit``
"""
JO_REL8_32: Code = 160 # type: ignore
"""
``JO rel8``

``o32 70 cb``

``386+``

``16/32-bit``
"""
JO_REL8_64: Code = 161 # type: ignore
"""
``JO rel8``

``o64 70 cb``

``X64``

``64-bit``
"""
JNO_REL8_16: Code = 162 # type: ignore
"""
``JNO rel8``

``o16 71 cb``

``8086+``

``16/32/64-bit``
"""
JNO_REL8_32: Code = 163 # type: ignore
"""
``JNO rel8``

``o32 71 cb``

``386+``

``16/32-bit``
"""
JNO_REL8_64: Code = 164 # type: ignore
"""
``JNO rel8``

``o64 71 cb``

``X64``

``64-bit``
"""
JB_REL8_16: Code = 165 # type: ignore
"""
``JB rel8``

``o16 72 cb``

``8086+``

``16/32/64-bit``
"""
JB_REL8_32: Code = 166 # type: ignore
"""
``JB rel8``

``o32 72 cb``

``386+``

``16/32-bit``
"""
JB_REL8_64: Code = 167 # type: ignore
"""
``JB rel8``

``o64 72 cb``

``X64``

``64-bit``
"""
JAE_REL8_16: Code = 168 # type: ignore
"""
``JAE rel8``

``o16 73 cb``

``8086+``

``16/32/64-bit``
"""
JAE_REL8_32: Code = 169 # type: ignore
"""
``JAE rel8``

``o32 73 cb``

``386+``

``16/32-bit``
"""
JAE_REL8_64: Code = 170 # type: ignore
"""
``JAE rel8``

``o64 73 cb``

``X64``

``64-bit``
"""
JE_REL8_16: Code = 171 # type: ignore
"""
``JE rel8``

``o16 74 cb``

``8086+``

``16/32/64-bit``
"""
JE_REL8_32: Code = 172 # type: ignore
"""
``JE rel8``

``o32 74 cb``

``386+``

``16/32-bit``
"""
JE_REL8_64: Code = 173 # type: ignore
"""
``JE rel8``

``o64 74 cb``

``X64``

``64-bit``
"""
JNE_REL8_16: Code = 174 # type: ignore
"""
``JNE rel8``

``o16 75 cb``

``8086+``

``16/32/64-bit``
"""
JNE_REL8_32: Code = 175 # type: ignore
"""
``JNE rel8``

``o32 75 cb``

``386+``

``16/32-bit``
"""
JNE_REL8_64: Code = 176 # type: ignore
"""
``JNE rel8``

``o64 75 cb``

``X64``

``64-bit``
"""
JBE_REL8_16: Code = 177 # type: ignore
"""
``JBE rel8``

``o16 76 cb``

``8086+``

``16/32/64-bit``
"""
JBE_REL8_32: Code = 178 # type: ignore
"""
``JBE rel8``

``o32 76 cb``

``386+``

``16/32-bit``
"""
JBE_REL8_64: Code = 179 # type: ignore
"""
``JBE rel8``

``o64 76 cb``

``X64``

``64-bit``
"""
JA_REL8_16: Code = 180 # type: ignore
"""
``JA rel8``

``o16 77 cb``

``8086+``

``16/32/64-bit``
"""
JA_REL8_32: Code = 181 # type: ignore
"""
``JA rel8``

``o32 77 cb``

``386+``

``16/32-bit``
"""
JA_REL8_64: Code = 182 # type: ignore
"""
``JA rel8``

``o64 77 cb``

``X64``

``64-bit``
"""
JS_REL8_16: Code = 183 # type: ignore
"""
``JS rel8``

``o16 78 cb``

``8086+``

``16/32/64-bit``
"""
JS_REL8_32: Code = 184 # type: ignore
"""
``JS rel8``

``o32 78 cb``

``386+``

``16/32-bit``
"""
JS_REL8_64: Code = 185 # type: ignore
"""
``JS rel8``

``o64 78 cb``

``X64``

``64-bit``
"""
JNS_REL8_16: Code = 186 # type: ignore
"""
``JNS rel8``

``o16 79 cb``

``8086+``

``16/32/64-bit``
"""
JNS_REL8_32: Code = 187 # type: ignore
"""
``JNS rel8``

``o32 79 cb``

``386+``

``16/32-bit``
"""
JNS_REL8_64: Code = 188 # type: ignore
"""
``JNS rel8``

``o64 79 cb``

``X64``

``64-bit``
"""
JP_REL8_16: Code = 189 # type: ignore
"""
``JP rel8``

``o16 7A cb``

``8086+``

``16/32/64-bit``
"""
JP_REL8_32: Code = 190 # type: ignore
"""
``JP rel8``

``o32 7A cb``

``386+``

``16/32-bit``
"""
JP_REL8_64: Code = 191 # type: ignore
"""
``JP rel8``

``o64 7A cb``

``X64``

``64-bit``
"""
JNP_REL8_16: Code = 192 # type: ignore
"""
``JNP rel8``

``o16 7B cb``

``8086+``

``16/32/64-bit``
"""
JNP_REL8_32: Code = 193 # type: ignore
"""
``JNP rel8``

``o32 7B cb``

``386+``

``16/32-bit``
"""
JNP_REL8_64: Code = 194 # type: ignore
"""
``JNP rel8``

``o64 7B cb``

``X64``

``64-bit``
"""
JL_REL8_16: Code = 195 # type: ignore
"""
``JL rel8``

``o16 7C cb``

``8086+``

``16/32/64-bit``
"""
JL_REL8_32: Code = 196 # type: ignore
"""
``JL rel8``

``o32 7C cb``

``386+``

``16/32-bit``
"""
JL_REL8_64: Code = 197 # type: ignore
"""
``JL rel8``

``o64 7C cb``

``X64``

``64-bit``
"""
JGE_REL8_16: Code = 198 # type: ignore
"""
``JGE rel8``

``o16 7D cb``

``8086+``

``16/32/64-bit``
"""
JGE_REL8_32: Code = 199 # type: ignore
"""
``JGE rel8``

``o32 7D cb``

``386+``

``16/32-bit``
"""
JGE_REL8_64: Code = 200 # type: ignore
"""
``JGE rel8``

``o64 7D cb``

``X64``

``64-bit``
"""
JLE_REL8_16: Code = 201 # type: ignore
"""
``JLE rel8``

``o16 7E cb``

``8086+``

``16/32/64-bit``
"""
JLE_REL8_32: Code = 202 # type: ignore
"""
``JLE rel8``

``o32 7E cb``

``386+``

``16/32-bit``
"""
JLE_REL8_64: Code = 203 # type: ignore
"""
``JLE rel8``

``o64 7E cb``

``X64``

``64-bit``
"""
JG_REL8_16: Code = 204 # type: ignore
"""
``JG rel8``

``o16 7F cb``

``8086+``

``16/32/64-bit``
"""
JG_REL8_32: Code = 205 # type: ignore
"""
``JG rel8``

``o32 7F cb``

``386+``

``16/32-bit``
"""
JG_REL8_64: Code = 206 # type: ignore
"""
``JG rel8``

``o64 7F cb``

``X64``

``64-bit``
"""
ADD_RM8_IMM8: Code = 207 # type: ignore
"""
``ADD r/m8, imm8``

``80 /0 ib``

``8086+``

``16/32/64-bit``
"""
OR_RM8_IMM8: Code = 208 # type: ignore
"""
``OR r/m8, imm8``

``80 /1 ib``

``8086+``

``16/32/64-bit``
"""
ADC_RM8_IMM8: Code = 209 # type: ignore
"""
``ADC r/m8, imm8``

``80 /2 ib``

``8086+``

``16/32/64-bit``
"""
SBB_RM8_IMM8: Code = 210 # type: ignore
"""
``SBB r/m8, imm8``

``80 /3 ib``

``8086+``

``16/32/64-bit``
"""
AND_RM8_IMM8: Code = 211 # type: ignore
"""
``AND r/m8, imm8``

``80 /4 ib``

``8086+``

``16/32/64-bit``
"""
SUB_RM8_IMM8: Code = 212 # type: ignore
"""
``SUB r/m8, imm8``

``80 /5 ib``

``8086+``

``16/32/64-bit``
"""
XOR_RM8_IMM8: Code = 213 # type: ignore
"""
``XOR r/m8, imm8``

``80 /6 ib``

``8086+``

``16/32/64-bit``
"""
CMP_RM8_IMM8: Code = 214 # type: ignore
"""
``CMP r/m8, imm8``

``80 /7 ib``

``8086+``

``16/32/64-bit``
"""
ADD_RM16_IMM16: Code = 215 # type: ignore
"""
``ADD r/m16, imm16``

``o16 81 /0 iw``

``8086+``

``16/32/64-bit``
"""
ADD_RM32_IMM32: Code = 216 # type: ignore
"""
``ADD r/m32, imm32``

``o32 81 /0 id``

``386+``

``16/32/64-bit``
"""
ADD_RM64_IMM32: Code = 217 # type: ignore
"""
``ADD r/m64, imm32``

``o64 81 /0 id``

``X64``

``64-bit``
"""
OR_RM16_IMM16: Code = 218 # type: ignore
"""
``OR r/m16, imm16``

``o16 81 /1 iw``

``8086+``

``16/32/64-bit``
"""
OR_RM32_IMM32: Code = 219 # type: ignore
"""
``OR r/m32, imm32``

``o32 81 /1 id``

``386+``

``16/32/64-bit``
"""
OR_RM64_IMM32: Code = 220 # type: ignore
"""
``OR r/m64, imm32``

``o64 81 /1 id``

``X64``

``64-bit``
"""
ADC_RM16_IMM16: Code = 221 # type: ignore
"""
``ADC r/m16, imm16``

``o16 81 /2 iw``

``8086+``

``16/32/64-bit``
"""
ADC_RM32_IMM32: Code = 222 # type: ignore
"""
``ADC r/m32, imm32``

``o32 81 /2 id``

``386+``

``16/32/64-bit``
"""
ADC_RM64_IMM32: Code = 223 # type: ignore
"""
``ADC r/m64, imm32``

``o64 81 /2 id``

``X64``

``64-bit``
"""
SBB_RM16_IMM16: Code = 224 # type: ignore
"""
``SBB r/m16, imm16``

``o16 81 /3 iw``

``8086+``

``16/32/64-bit``
"""
SBB_RM32_IMM32: Code = 225 # type: ignore
"""
``SBB r/m32, imm32``

``o32 81 /3 id``

``386+``

``16/32/64-bit``
"""
SBB_RM64_IMM32: Code = 226 # type: ignore
"""
``SBB r/m64, imm32``

``o64 81 /3 id``

``X64``

``64-bit``
"""
AND_RM16_IMM16: Code = 227 # type: ignore
"""
``AND r/m16, imm16``

``o16 81 /4 iw``

``8086+``

``16/32/64-bit``
"""
AND_RM32_IMM32: Code = 228 # type: ignore
"""
``AND r/m32, imm32``

``o32 81 /4 id``

``386+``

``16/32/64-bit``
"""
AND_RM64_IMM32: Code = 229 # type: ignore
"""
``AND r/m64, imm32``

``o64 81 /4 id``

``X64``

``64-bit``
"""
SUB_RM16_IMM16: Code = 230 # type: ignore
"""
``SUB r/m16, imm16``

``o16 81 /5 iw``

``8086+``

``16/32/64-bit``
"""
SUB_RM32_IMM32: Code = 231 # type: ignore
"""
``SUB r/m32, imm32``

``o32 81 /5 id``

``386+``

``16/32/64-bit``
"""
SUB_RM64_IMM32: Code = 232 # type: ignore
"""
``SUB r/m64, imm32``

``o64 81 /5 id``

``X64``

``64-bit``
"""
XOR_RM16_IMM16: Code = 233 # type: ignore
"""
``XOR r/m16, imm16``

``o16 81 /6 iw``

``8086+``

``16/32/64-bit``
"""
XOR_RM32_IMM32: Code = 234 # type: ignore
"""
``XOR r/m32, imm32``

``o32 81 /6 id``

``386+``

``16/32/64-bit``
"""
XOR_RM64_IMM32: Code = 235 # type: ignore
"""
``XOR r/m64, imm32``

``o64 81 /6 id``

``X64``

``64-bit``
"""
CMP_RM16_IMM16: Code = 236 # type: ignore
"""
``CMP r/m16, imm16``

``o16 81 /7 iw``

``8086+``

``16/32/64-bit``
"""
CMP_RM32_IMM32: Code = 237 # type: ignore
"""
``CMP r/m32, imm32``

``o32 81 /7 id``

``386+``

``16/32/64-bit``
"""
CMP_RM64_IMM32: Code = 238 # type: ignore
"""
``CMP r/m64, imm32``

``o64 81 /7 id``

``X64``

``64-bit``
"""
ADD_RM8_IMM8_82: Code = 239 # type: ignore
"""
``ADD r/m8, imm8``

``82 /0 ib``

``8086+``

``16/32-bit``
"""
OR_RM8_IMM8_82: Code = 240 # type: ignore
"""
``OR r/m8, imm8``

``82 /1 ib``

``8086+``

``16/32-bit``
"""
ADC_RM8_IMM8_82: Code = 241 # type: ignore
"""
``ADC r/m8, imm8``

``82 /2 ib``

``8086+``

``16/32-bit``
"""
SBB_RM8_IMM8_82: Code = 242 # type: ignore
"""
``SBB r/m8, imm8``

``82 /3 ib``

``8086+``

``16/32-bit``
"""
AND_RM8_IMM8_82: Code = 243 # type: ignore
"""
``AND r/m8, imm8``

``82 /4 ib``

``8086+``

``16/32-bit``
"""
SUB_RM8_IMM8_82: Code = 244 # type: ignore
"""
``SUB r/m8, imm8``

``82 /5 ib``

``8086+``

``16/32-bit``
"""
XOR_RM8_IMM8_82: Code = 245 # type: ignore
"""
``XOR r/m8, imm8``

``82 /6 ib``

``8086+``

``16/32-bit``
"""
CMP_RM8_IMM8_82: Code = 246 # type: ignore
"""
``CMP r/m8, imm8``

``82 /7 ib``

``8086+``

``16/32-bit``
"""
ADD_RM16_IMM8: Code = 247 # type: ignore
"""
``ADD r/m16, imm8``

``o16 83 /0 ib``

``8086+``

``16/32/64-bit``
"""
ADD_RM32_IMM8: Code = 248 # type: ignore
"""
``ADD r/m32, imm8``

``o32 83 /0 ib``

``386+``

``16/32/64-bit``
"""
ADD_RM64_IMM8: Code = 249 # type: ignore
"""
``ADD r/m64, imm8``

``o64 83 /0 ib``

``X64``

``64-bit``
"""
OR_RM16_IMM8: Code = 250 # type: ignore
"""
``OR r/m16, imm8``

``o16 83 /1 ib``

``8086+``

``16/32/64-bit``
"""
OR_RM32_IMM8: Code = 251 # type: ignore
"""
``OR r/m32, imm8``

``o32 83 /1 ib``

``386+``

``16/32/64-bit``
"""
OR_RM64_IMM8: Code = 252 # type: ignore
"""
``OR r/m64, imm8``

``o64 83 /1 ib``

``X64``

``64-bit``
"""
ADC_RM16_IMM8: Code = 253 # type: ignore
"""
``ADC r/m16, imm8``

``o16 83 /2 ib``

``8086+``

``16/32/64-bit``
"""
ADC_RM32_IMM8: Code = 254 # type: ignore
"""
``ADC r/m32, imm8``

``o32 83 /2 ib``

``386+``

``16/32/64-bit``
"""
ADC_RM64_IMM8: Code = 255 # type: ignore
"""
``ADC r/m64, imm8``

``o64 83 /2 ib``

``X64``

``64-bit``
"""
SBB_RM16_IMM8: Code = 256 # type: ignore
"""
``SBB r/m16, imm8``

``o16 83 /3 ib``

``8086+``

``16/32/64-bit``
"""
SBB_RM32_IMM8: Code = 257 # type: ignore
"""
``SBB r/m32, imm8``

``o32 83 /3 ib``

``386+``

``16/32/64-bit``
"""
SBB_RM64_IMM8: Code = 258 # type: ignore
"""
``SBB r/m64, imm8``

``o64 83 /3 ib``

``X64``

``64-bit``
"""
AND_RM16_IMM8: Code = 259 # type: ignore
"""
``AND r/m16, imm8``

``o16 83 /4 ib``

``8086+``

``16/32/64-bit``
"""
AND_RM32_IMM8: Code = 260 # type: ignore
"""
``AND r/m32, imm8``

``o32 83 /4 ib``

``386+``

``16/32/64-bit``
"""
AND_RM64_IMM8: Code = 261 # type: ignore
"""
``AND r/m64, imm8``

``o64 83 /4 ib``

``X64``

``64-bit``
"""
SUB_RM16_IMM8: Code = 262 # type: ignore
"""
``SUB r/m16, imm8``

``o16 83 /5 ib``

``8086+``

``16/32/64-bit``
"""
SUB_RM32_IMM8: Code = 263 # type: ignore
"""
``SUB r/m32, imm8``

``o32 83 /5 ib``

``386+``

``16/32/64-bit``
"""
SUB_RM64_IMM8: Code = 264 # type: ignore
"""
``SUB r/m64, imm8``

``o64 83 /5 ib``

``X64``

``64-bit``
"""
XOR_RM16_IMM8: Code = 265 # type: ignore
"""
``XOR r/m16, imm8``

``o16 83 /6 ib``

``8086+``

``16/32/64-bit``
"""
XOR_RM32_IMM8: Code = 266 # type: ignore
"""
``XOR r/m32, imm8``

``o32 83 /6 ib``

``386+``

``16/32/64-bit``
"""
XOR_RM64_IMM8: Code = 267 # type: ignore
"""
``XOR r/m64, imm8``

``o64 83 /6 ib``

``X64``

``64-bit``
"""
CMP_RM16_IMM8: Code = 268 # type: ignore
"""
``CMP r/m16, imm8``

``o16 83 /7 ib``

``8086+``

``16/32/64-bit``
"""
CMP_RM32_IMM8: Code = 269 # type: ignore
"""
``CMP r/m32, imm8``

``o32 83 /7 ib``

``386+``

``16/32/64-bit``
"""
CMP_RM64_IMM8: Code = 270 # type: ignore
"""
``CMP r/m64, imm8``

``o64 83 /7 ib``

``X64``

``64-bit``
"""
TEST_RM8_R8: Code = 271 # type: ignore
"""
``TEST r/m8, r8``

``84 /r``

``8086+``

``16/32/64-bit``
"""
TEST_RM16_R16: Code = 272 # type: ignore
"""
``TEST r/m16, r16``

``o16 85 /r``

``8086+``

``16/32/64-bit``
"""
TEST_RM32_R32: Code = 273 # type: ignore
"""
``TEST r/m32, r32``

``o32 85 /r``

``386+``

``16/32/64-bit``
"""
TEST_RM64_R64: Code = 274 # type: ignore
"""
``TEST r/m64, r64``

``o64 85 /r``

``X64``

``64-bit``
"""
XCHG_RM8_R8: Code = 275 # type: ignore
"""
``XCHG r/m8, r8``

``86 /r``

``8086+``

``16/32/64-bit``
"""
XCHG_RM16_R16: Code = 276 # type: ignore
"""
``XCHG r/m16, r16``

``o16 87 /r``

``8086+``

``16/32/64-bit``
"""
XCHG_RM32_R32: Code = 277 # type: ignore
"""
``XCHG r/m32, r32``

``o32 87 /r``

``386+``

``16/32/64-bit``
"""
XCHG_RM64_R64: Code = 278 # type: ignore
"""
``XCHG r/m64, r64``

``o64 87 /r``

``X64``

``64-bit``
"""
MOV_RM8_R8: Code = 279 # type: ignore
"""
``MOV r/m8, r8``

``88 /r``

``8086+``

``16/32/64-bit``
"""
MOV_RM16_R16: Code = 280 # type: ignore
"""
``MOV r/m16, r16``

``o16 89 /r``

``8086+``

``16/32/64-bit``
"""
MOV_RM32_R32: Code = 281 # type: ignore
"""
``MOV r/m32, r32``

``o32 89 /r``

``386+``

``16/32/64-bit``
"""
MOV_RM64_R64: Code = 282 # type: ignore
"""
``MOV r/m64, r64``

``o64 89 /r``

``X64``

``64-bit``
"""
MOV_R8_RM8: Code = 283 # type: ignore
"""
``MOV r8, r/m8``

``8A /r``

``8086+``

``16/32/64-bit``
"""
MOV_R16_RM16: Code = 284 # type: ignore
"""
``MOV r16, r/m16``

``o16 8B /r``

``8086+``

``16/32/64-bit``
"""
MOV_R32_RM32: Code = 285 # type: ignore
"""
``MOV r32, r/m32``

``o32 8B /r``

``386+``

``16/32/64-bit``
"""
MOV_R64_RM64: Code = 286 # type: ignore
"""
``MOV r64, r/m64``

``o64 8B /r``

``X64``

``64-bit``
"""
MOV_RM16_SREG: Code = 287 # type: ignore
"""
``MOV r/m16, Sreg``

``o16 8C /r``

``8086+``

``16/32/64-bit``
"""
MOV_R32M16_SREG: Code = 288 # type: ignore
"""
``MOV r32/m16, Sreg``

``o32 8C /r``

``386+``

``16/32/64-bit``
"""
MOV_R64M16_SREG: Code = 289 # type: ignore
"""
``MOV r64/m16, Sreg``

``o64 8C /r``

``X64``

``64-bit``
"""
LEA_R16_M: Code = 290 # type: ignore
"""
``LEA r16, m``

``o16 8D /r``

``8086+``

``16/32/64-bit``
"""
LEA_R32_M: Code = 291 # type: ignore
"""
``LEA r32, m``

``o32 8D /r``

``386+``

``16/32/64-bit``
"""
LEA_R64_M: Code = 292 # type: ignore
"""
``LEA r64, m``

``o64 8D /r``

``X64``

``64-bit``
"""
MOV_SREG_RM16: Code = 293 # type: ignore
"""
``MOV Sreg, r/m16``

``o16 8E /r``

``8086+``

``16/32/64-bit``
"""
MOV_SREG_R32M16: Code = 294 # type: ignore
"""
``MOV Sreg, r32/m16``

``o32 8E /r``

``386+``

``16/32/64-bit``
"""
MOV_SREG_R64M16: Code = 295 # type: ignore
"""
``MOV Sreg, r64/m16``

``o64 8E /r``

``X64``

``64-bit``
"""
POP_RM16: Code = 296 # type: ignore
"""
``POP r/m16``

``o16 8F /0``

``8086+``

``16/32/64-bit``
"""
POP_RM32: Code = 297 # type: ignore
"""
``POP r/m32``

``o32 8F /0``

``386+``

``16/32-bit``
"""
POP_RM64: Code = 298 # type: ignore
"""
``POP r/m64``

``o64 8F /0``

``X64``

``64-bit``
"""
NOPW: Code = 299 # type: ignore
"""
``NOP``

``o16 90``

``8086+``

``16/32/64-bit``
"""
NOPD: Code = 300 # type: ignore
"""
``NOP``

``o32 90``

``8086+``

``16/32/64-bit``
"""
NOPQ: Code = 301 # type: ignore
"""
``NOP``

``o64 90``

``8086+``

``64-bit``
"""
XCHG_R16_AX: Code = 302 # type: ignore
"""
``XCHG r16, AX``

``o16 90+rw``

``8086+``

``16/32/64-bit``
"""
XCHG_R32_EAX: Code = 303 # type: ignore
"""
``XCHG r32, EAX``

``o32 90+rd``

``386+``

``16/32/64-bit``
"""
XCHG_R64_RAX: Code = 304 # type: ignore
"""
``XCHG r64, RAX``

``o64 90+ro``

``X64``

``64-bit``
"""
PAUSE: Code = 305 # type: ignore
"""
``PAUSE``

``F3 90``

``Pentium 4 or later``

``16/32/64-bit``
"""
CBW: Code = 306 # type: ignore
"""
``CBW``

``o16 98``

``8086+``

``16/32/64-bit``
"""
CWDE: Code = 307 # type: ignore
"""
``CWDE``

``o32 98``

``386+``

``16/32/64-bit``
"""
CDQE: Code = 308 # type: ignore
"""
``CDQE``

``o64 98``

``X64``

``64-bit``
"""
CWD: Code = 309 # type: ignore
"""
``CWD``

``o16 99``

``8086+``

``16/32/64-bit``
"""
CDQ: Code = 310 # type: ignore
"""
``CDQ``

``o32 99``

``386+``

``16/32/64-bit``
"""
CQO: Code = 311 # type: ignore
"""
``CQO``

``o64 99``

``X64``

``64-bit``
"""
CALL_PTR1616: Code = 312 # type: ignore
"""
``CALL ptr16:16``

``o16 9A cd``

``8086+``

``16/32-bit``
"""
CALL_PTR1632: Code = 313 # type: ignore
"""
``CALL ptr16:32``

``o32 9A cp``

``386+``

``16/32-bit``
"""
WAIT: Code = 314 # type: ignore
"""
``WAIT``

``9B``

``8086+``

``16/32/64-bit``
"""
PUSHFW: Code = 315 # type: ignore
"""
``PUSHF``

``o16 9C``

``8086+``

``16/32/64-bit``
"""
PUSHFD: Code = 316 # type: ignore
"""
``PUSHFD``

``o32 9C``

``386+``

``16/32-bit``
"""
PUSHFQ: Code = 317 # type: ignore
"""
``PUSHFQ``

``o64 9C``

``X64``

``64-bit``
"""
POPFW: Code = 318 # type: ignore
"""
``POPF``

``o16 9D``

``8086+``

``16/32/64-bit``
"""
POPFD: Code = 319 # type: ignore
"""
``POPFD``

``o32 9D``

``386+``

``16/32-bit``
"""
POPFQ: Code = 320 # type: ignore
"""
``POPFQ``

``o64 9D``

``X64``

``64-bit``
"""
SAHF: Code = 321 # type: ignore
"""
``SAHF``

``9E``

``8086+``

``16/32/64-bit``
"""
LAHF: Code = 322 # type: ignore
"""
``LAHF``

``9F``

``8086+``

``16/32/64-bit``
"""
MOV_AL_MOFFS8: Code = 323 # type: ignore
"""
``MOV AL, moffs8``

``A0 mo``

``8086+``

``16/32/64-bit``
"""
MOV_AX_MOFFS16: Code = 324 # type: ignore
"""
``MOV AX, moffs16``

``o16 A1 mo``

``8086+``

``16/32/64-bit``
"""
MOV_EAX_MOFFS32: Code = 325 # type: ignore
"""
``MOV EAX, moffs32``

``o32 A1 mo``

``386+``

``16/32/64-bit``
"""
MOV_RAX_MOFFS64: Code = 326 # type: ignore
"""
``MOV RAX, moffs64``

``o64 A1 mo``

``X64``

``64-bit``
"""
MOV_MOFFS8_AL: Code = 327 # type: ignore
"""
``MOV moffs8, AL``

``A2 mo``

``8086+``

``16/32/64-bit``
"""
MOV_MOFFS16_AX: Code = 328 # type: ignore
"""
``MOV moffs16, AX``

``o16 A3 mo``

``8086+``

``16/32/64-bit``
"""
MOV_MOFFS32_EAX: Code = 329 # type: ignore
"""
``MOV moffs32, EAX``

``o32 A3 mo``

``386+``

``16/32/64-bit``
"""
MOV_MOFFS64_RAX: Code = 330 # type: ignore
"""
``MOV moffs64, RAX``

``o64 A3 mo``

``X64``

``64-bit``
"""
MOVSB_M8_M8: Code = 331 # type: ignore
"""
``MOVSB``

``A4``

``8086+``

``16/32/64-bit``
"""
MOVSW_M16_M16: Code = 332 # type: ignore
"""
``MOVSW``

``o16 A5``

``8086+``

``16/32/64-bit``
"""
MOVSD_M32_M32: Code = 333 # type: ignore
"""
``MOVSD``

``o32 A5``

``386+``

``16/32/64-bit``
"""
MOVSQ_M64_M64: Code = 334 # type: ignore
"""
``MOVSQ``

``o64 A5``

``X64``

``64-bit``
"""
CMPSB_M8_M8: Code = 335 # type: ignore
"""
``CMPSB``

``A6``

``8086+``

``16/32/64-bit``
"""
CMPSW_M16_M16: Code = 336 # type: ignore
"""
``CMPSW``

``o16 A7``

``8086+``

``16/32/64-bit``
"""
CMPSD_M32_M32: Code = 337 # type: ignore
"""
``CMPSD``

``o32 A7``

``386+``

``16/32/64-bit``
"""
CMPSQ_M64_M64: Code = 338 # type: ignore
"""
``CMPSQ``

``o64 A7``

``X64``

``64-bit``
"""
TEST_AL_IMM8: Code = 339 # type: ignore
"""
``TEST AL, imm8``

``A8 ib``

``8086+``

``16/32/64-bit``
"""
TEST_AX_IMM16: Code = 340 # type: ignore
"""
``TEST AX, imm16``

``o16 A9 iw``

``8086+``

``16/32/64-bit``
"""
TEST_EAX_IMM32: Code = 341 # type: ignore
"""
``TEST EAX, imm32``

``o32 A9 id``

``386+``

``16/32/64-bit``
"""
TEST_RAX_IMM32: Code = 342 # type: ignore
"""
``TEST RAX, imm32``

``o64 A9 id``

``X64``

``64-bit``
"""
STOSB_M8_AL: Code = 343 # type: ignore
"""
``STOSB``

``AA``

``8086+``

``16/32/64-bit``
"""
STOSW_M16_AX: Code = 344 # type: ignore
"""
``STOSW``

``o16 AB``

``8086+``

``16/32/64-bit``
"""
STOSD_M32_EAX: Code = 345 # type: ignore
"""
``STOSD``

``o32 AB``

``386+``

``16/32/64-bit``
"""
STOSQ_M64_RAX: Code = 346 # type: ignore
"""
``STOSQ``

``o64 AB``

``X64``

``64-bit``
"""
LODSB_AL_M8: Code = 347 # type: ignore
"""
``LODSB``

``AC``

``8086+``

``16/32/64-bit``
"""
LODSW_AX_M16: Code = 348 # type: ignore
"""
``LODSW``

``o16 AD``

``8086+``

``16/32/64-bit``
"""
LODSD_EAX_M32: Code = 349 # type: ignore
"""
``LODSD``

``o32 AD``

``386+``

``16/32/64-bit``
"""
LODSQ_RAX_M64: Code = 350 # type: ignore
"""
``LODSQ``

``o64 AD``

``X64``

``64-bit``
"""
SCASB_AL_M8: Code = 351 # type: ignore
"""
``SCASB``

``AE``

``8086+``

``16/32/64-bit``
"""
SCASW_AX_M16: Code = 352 # type: ignore
"""
``SCASW``

``o16 AF``

``8086+``

``16/32/64-bit``
"""
SCASD_EAX_M32: Code = 353 # type: ignore
"""
``SCASD``

``o32 AF``

``386+``

``16/32/64-bit``
"""
SCASQ_RAX_M64: Code = 354 # type: ignore
"""
``SCASQ``

``o64 AF``

``X64``

``64-bit``
"""
MOV_R8_IMM8: Code = 355 # type: ignore
"""
``MOV r8, imm8``

``B0+rb ib``

``8086+``

``16/32/64-bit``
"""
MOV_R16_IMM16: Code = 356 # type: ignore
"""
``MOV r16, imm16``

``o16 B8+rw iw``

``8086+``

``16/32/64-bit``
"""
MOV_R32_IMM32: Code = 357 # type: ignore
"""
``MOV r32, imm32``

``o32 B8+rd id``

``386+``

``16/32/64-bit``
"""
MOV_R64_IMM64: Code = 358 # type: ignore
"""
``MOV r64, imm64``

``o64 B8+ro io``

``X64``

``64-bit``
"""
ROL_RM8_IMM8: Code = 359 # type: ignore
"""
``ROL r/m8, imm8``

``C0 /0 ib``

``186+``

``16/32/64-bit``
"""
ROR_RM8_IMM8: Code = 360 # type: ignore
"""
``ROR r/m8, imm8``

``C0 /1 ib``

``186+``

``16/32/64-bit``
"""
RCL_RM8_IMM8: Code = 361 # type: ignore
"""
``RCL r/m8, imm8``

``C0 /2 ib``

``186+``

``16/32/64-bit``
"""
RCR_RM8_IMM8: Code = 362 # type: ignore
"""
``RCR r/m8, imm8``

``C0 /3 ib``

``186+``

``16/32/64-bit``
"""
SHL_RM8_IMM8: Code = 363 # type: ignore
"""
``SHL r/m8, imm8``

``C0 /4 ib``

``186+``

``16/32/64-bit``
"""
SHR_RM8_IMM8: Code = 364 # type: ignore
"""
``SHR r/m8, imm8``

``C0 /5 ib``

``186+``

``16/32/64-bit``
"""
SAL_RM8_IMM8: Code = 365 # type: ignore
"""
``SAL r/m8, imm8``

``C0 /6 ib``

``186+``

``16/32/64-bit``
"""
SAR_RM8_IMM8: Code = 366 # type: ignore
"""
``SAR r/m8, imm8``

``C0 /7 ib``

``186+``

``16/32/64-bit``
"""
ROL_RM16_IMM8: Code = 367 # type: ignore
"""
``ROL r/m16, imm8``

``o16 C1 /0 ib``

``186+``

``16/32/64-bit``
"""
ROL_RM32_IMM8: Code = 368 # type: ignore
"""
``ROL r/m32, imm8``

``o32 C1 /0 ib``

``386+``

``16/32/64-bit``
"""
ROL_RM64_IMM8: Code = 369 # type: ignore
"""
``ROL r/m64, imm8``

``o64 C1 /0 ib``

``X64``

``64-bit``
"""
ROR_RM16_IMM8: Code = 370 # type: ignore
"""
``ROR r/m16, imm8``

``o16 C1 /1 ib``

``186+``

``16/32/64-bit``
"""
ROR_RM32_IMM8: Code = 371 # type: ignore
"""
``ROR r/m32, imm8``

``o32 C1 /1 ib``

``386+``

``16/32/64-bit``
"""
ROR_RM64_IMM8: Code = 372 # type: ignore
"""
``ROR r/m64, imm8``

``o64 C1 /1 ib``

``X64``

``64-bit``
"""
RCL_RM16_IMM8: Code = 373 # type: ignore
"""
``RCL r/m16, imm8``

``o16 C1 /2 ib``

``186+``

``16/32/64-bit``
"""
RCL_RM32_IMM8: Code = 374 # type: ignore
"""
``RCL r/m32, imm8``

``o32 C1 /2 ib``

``386+``

``16/32/64-bit``
"""
RCL_RM64_IMM8: Code = 375 # type: ignore
"""
``RCL r/m64, imm8``

``o64 C1 /2 ib``

``X64``

``64-bit``
"""
RCR_RM16_IMM8: Code = 376 # type: ignore
"""
``RCR r/m16, imm8``

``o16 C1 /3 ib``

``186+``

``16/32/64-bit``
"""
RCR_RM32_IMM8: Code = 377 # type: ignore
"""
``RCR r/m32, imm8``

``o32 C1 /3 ib``

``386+``

``16/32/64-bit``
"""
RCR_RM64_IMM8: Code = 378 # type: ignore
"""
``RCR r/m64, imm8``

``o64 C1 /3 ib``

``X64``

``64-bit``
"""
SHL_RM16_IMM8: Code = 379 # type: ignore
"""
``SHL r/m16, imm8``

``o16 C1 /4 ib``

``186+``

``16/32/64-bit``
"""
SHL_RM32_IMM8: Code = 380 # type: ignore
"""
``SHL r/m32, imm8``

``o32 C1 /4 ib``

``386+``

``16/32/64-bit``
"""
SHL_RM64_IMM8: Code = 381 # type: ignore
"""
``SHL r/m64, imm8``

``o64 C1 /4 ib``

``X64``

``64-bit``
"""
SHR_RM16_IMM8: Code = 382 # type: ignore
"""
``SHR r/m16, imm8``

``o16 C1 /5 ib``

``186+``

``16/32/64-bit``
"""
SHR_RM32_IMM8: Code = 383 # type: ignore
"""
``SHR r/m32, imm8``

``o32 C1 /5 ib``

``386+``

``16/32/64-bit``
"""
SHR_RM64_IMM8: Code = 384 # type: ignore
"""
``SHR r/m64, imm8``

``o64 C1 /5 ib``

``X64``

``64-bit``
"""
SAL_RM16_IMM8: Code = 385 # type: ignore
"""
``SAL r/m16, imm8``

``o16 C1 /6 ib``

``186+``

``16/32/64-bit``
"""
SAL_RM32_IMM8: Code = 386 # type: ignore
"""
``SAL r/m32, imm8``

``o32 C1 /6 ib``

``386+``

``16/32/64-bit``
"""
SAL_RM64_IMM8: Code = 387 # type: ignore
"""
``SAL r/m64, imm8``

``o64 C1 /6 ib``

``X64``

``64-bit``
"""
SAR_RM16_IMM8: Code = 388 # type: ignore
"""
``SAR r/m16, imm8``

``o16 C1 /7 ib``

``186+``

``16/32/64-bit``
"""
SAR_RM32_IMM8: Code = 389 # type: ignore
"""
``SAR r/m32, imm8``

``o32 C1 /7 ib``

``386+``

``16/32/64-bit``
"""
SAR_RM64_IMM8: Code = 390 # type: ignore
"""
``SAR r/m64, imm8``

``o64 C1 /7 ib``

``X64``

``64-bit``
"""
RETNW_IMM16: Code = 391 # type: ignore
"""
``RET imm16``

``o16 C2 iw``

``8086+``

``16/32/64-bit``
"""
RETND_IMM16: Code = 392 # type: ignore
"""
``RET imm16``

``o32 C2 iw``

``386+``

``16/32-bit``
"""
RETNQ_IMM16: Code = 393 # type: ignore
"""
``RET imm16``

``o64 C2 iw``

``X64``

``64-bit``
"""
RETNW: Code = 394 # type: ignore
"""
``RET``

``o16 C3``

``8086+``

``16/32/64-bit``
"""
RETND: Code = 395 # type: ignore
"""
``RET``

``o32 C3``

``386+``

``16/32-bit``
"""
RETNQ: Code = 396 # type: ignore
"""
``RET``

``o64 C3``

``X64``

``64-bit``
"""
LES_R16_M1616: Code = 397 # type: ignore
"""
``LES r16, m16:16``

``o16 C4 /r``

``8086+``

``16/32-bit``
"""
LES_R32_M1632: Code = 398 # type: ignore
"""
``LES r32, m16:32``

``o32 C4 /r``

``386+``

``16/32-bit``
"""
LDS_R16_M1616: Code = 399 # type: ignore
"""
``LDS r16, m16:16``

``o16 C5 /r``

``8086+``

``16/32-bit``
"""
LDS_R32_M1632: Code = 400 # type: ignore
"""
``LDS r32, m16:32``

``o32 C5 /r``

``386+``

``16/32-bit``
"""
MOV_RM8_IMM8: Code = 401 # type: ignore
"""
``MOV r/m8, imm8``

``C6 /0 ib``

``8086+``

``16/32/64-bit``
"""
XABORT_IMM8: Code = 402 # type: ignore
"""
``XABORT imm8``

``C6 F8 ib``

``RTM``

``16/32/64-bit``
"""
MOV_RM16_IMM16: Code = 403 # type: ignore
"""
``MOV r/m16, imm16``

``o16 C7 /0 iw``

``8086+``

``16/32/64-bit``
"""
MOV_RM32_IMM32: Code = 404 # type: ignore
"""
``MOV r/m32, imm32``

``o32 C7 /0 id``

``386+``

``16/32/64-bit``
"""
MOV_RM64_IMM32: Code = 405 # type: ignore
"""
``MOV r/m64, imm32``

``o64 C7 /0 id``

``X64``

``64-bit``
"""
XBEGIN_REL16: Code = 406 # type: ignore
"""
``XBEGIN rel16``

``o16 C7 F8 cw``

``RTM``

``16/32/64-bit``
"""
XBEGIN_REL32: Code = 407 # type: ignore
"""
``XBEGIN rel32``

``o32 C7 F8 cd``

``RTM``

``16/32/64-bit``
"""
ENTERW_IMM16_IMM8: Code = 408 # type: ignore
"""
``ENTER imm16, imm8``

``o16 C8 iw ib``

``186+``

``16/32/64-bit``
"""
ENTERD_IMM16_IMM8: Code = 409 # type: ignore
"""
``ENTER imm16, imm8``

``o32 C8 iw ib``

``386+``

``16/32-bit``
"""
ENTERQ_IMM16_IMM8: Code = 410 # type: ignore
"""
``ENTER imm16, imm8``

``o64 C8 iw ib``

``X64``

``64-bit``
"""
LEAVEW: Code = 411 # type: ignore
"""
``LEAVE``

``o16 C9``

``186+``

``16/32/64-bit``
"""
LEAVED: Code = 412 # type: ignore
"""
``LEAVE``

``o32 C9``

``386+``

``16/32-bit``
"""
LEAVEQ: Code = 413 # type: ignore
"""
``LEAVE``

``o64 C9``

``X64``

``64-bit``
"""
RETFW_IMM16: Code = 414 # type: ignore
"""
``RETF imm16``

``o16 CA iw``

``8086+``

``16/32/64-bit``
"""
RETFD_IMM16: Code = 415 # type: ignore
"""
``RETF imm16``

``o32 CA iw``

``386+``

``16/32/64-bit``
"""
RETFQ_IMM16: Code = 416 # type: ignore
"""
``RETF imm16``

``o64 CA iw``

``X64``

``64-bit``
"""
RETFW: Code = 417 # type: ignore
"""
``RETF``

``o16 CB``

``8086+``

``16/32/64-bit``
"""
RETFD: Code = 418 # type: ignore
"""
``RETF``

``o32 CB``

``386+``

``16/32/64-bit``
"""
RETFQ: Code = 419 # type: ignore
"""
``RETF``

``o64 CB``

``X64``

``64-bit``
"""
INT3: Code = 420 # type: ignore
"""
``INT3``

``CC``

``8086+``

``16/32/64-bit``
"""
INT_IMM8: Code = 421 # type: ignore
"""
``INT imm8``

``CD ib``

``8086+``

``16/32/64-bit``
"""
INTO: Code = 422 # type: ignore
"""
``INTO``

``CE``

``8086+``

``16/32-bit``
"""
IRETW: Code = 423 # type: ignore
"""
``IRET``

``o16 CF``

``8086+``

``16/32/64-bit``
"""
IRETD: Code = 424 # type: ignore
"""
``IRETD``

``o32 CF``

``386+``

``16/32/64-bit``
"""
IRETQ: Code = 425 # type: ignore
"""
``IRETQ``

``o64 CF``

``X64``

``64-bit``
"""
ROL_RM8_1: Code = 426 # type: ignore
"""
``ROL r/m8, 1``

``D0 /0``

``8086+``

``16/32/64-bit``
"""
ROR_RM8_1: Code = 427 # type: ignore
"""
``ROR r/m8, 1``

``D0 /1``

``8086+``

``16/32/64-bit``
"""
RCL_RM8_1: Code = 428 # type: ignore
"""
``RCL r/m8, 1``

``D0 /2``

``8086+``

``16/32/64-bit``
"""
RCR_RM8_1: Code = 429 # type: ignore
"""
``RCR r/m8, 1``

``D0 /3``

``8086+``

``16/32/64-bit``
"""
SHL_RM8_1: Code = 430 # type: ignore
"""
``SHL r/m8, 1``

``D0 /4``

``8086+``

``16/32/64-bit``
"""
SHR_RM8_1: Code = 431 # type: ignore
"""
``SHR r/m8, 1``

``D0 /5``

``8086+``

``16/32/64-bit``
"""
SAL_RM8_1: Code = 432 # type: ignore
"""
``SAL r/m8, 1``

``D0 /6``

``8086+``

``16/32/64-bit``
"""
SAR_RM8_1: Code = 433 # type: ignore
"""
``SAR r/m8, 1``

``D0 /7``

``8086+``

``16/32/64-bit``
"""
ROL_RM16_1: Code = 434 # type: ignore
"""
``ROL r/m16, 1``

``o16 D1 /0``

``8086+``

``16/32/64-bit``
"""
ROL_RM32_1: Code = 435 # type: ignore
"""
``ROL r/m32, 1``

``o32 D1 /0``

``386+``

``16/32/64-bit``
"""
ROL_RM64_1: Code = 436 # type: ignore
"""
``ROL r/m64, 1``

``o64 D1 /0``

``X64``

``64-bit``
"""
ROR_RM16_1: Code = 437 # type: ignore
"""
``ROR r/m16, 1``

``o16 D1 /1``

``8086+``

``16/32/64-bit``
"""
ROR_RM32_1: Code = 438 # type: ignore
"""
``ROR r/m32, 1``

``o32 D1 /1``

``386+``

``16/32/64-bit``
"""
ROR_RM64_1: Code = 439 # type: ignore
"""
``ROR r/m64, 1``

``o64 D1 /1``

``X64``

``64-bit``
"""
RCL_RM16_1: Code = 440 # type: ignore
"""
``RCL r/m16, 1``

``o16 D1 /2``

``8086+``

``16/32/64-bit``
"""
RCL_RM32_1: Code = 441 # type: ignore
"""
``RCL r/m32, 1``

``o32 D1 /2``

``386+``

``16/32/64-bit``
"""
RCL_RM64_1: Code = 442 # type: ignore
"""
``RCL r/m64, 1``

``o64 D1 /2``

``X64``

``64-bit``
"""
RCR_RM16_1: Code = 443 # type: ignore
"""
``RCR r/m16, 1``

``o16 D1 /3``

``8086+``

``16/32/64-bit``
"""
RCR_RM32_1: Code = 444 # type: ignore
"""
``RCR r/m32, 1``

``o32 D1 /3``

``386+``

``16/32/64-bit``
"""
RCR_RM64_1: Code = 445 # type: ignore
"""
``RCR r/m64, 1``

``o64 D1 /3``

``X64``

``64-bit``
"""
SHL_RM16_1: Code = 446 # type: ignore
"""
``SHL r/m16, 1``

``o16 D1 /4``

``8086+``

``16/32/64-bit``
"""
SHL_RM32_1: Code = 447 # type: ignore
"""
``SHL r/m32, 1``

``o32 D1 /4``

``386+``

``16/32/64-bit``
"""
SHL_RM64_1: Code = 448 # type: ignore
"""
``SHL r/m64, 1``

``o64 D1 /4``

``X64``

``64-bit``
"""
SHR_RM16_1: Code = 449 # type: ignore
"""
``SHR r/m16, 1``

``o16 D1 /5``

``8086+``

``16/32/64-bit``
"""
SHR_RM32_1: Code = 450 # type: ignore
"""
``SHR r/m32, 1``

``o32 D1 /5``

``386+``

``16/32/64-bit``
"""
SHR_RM64_1: Code = 451 # type: ignore
"""
``SHR r/m64, 1``

``o64 D1 /5``

``X64``

``64-bit``
"""
SAL_RM16_1: Code = 452 # type: ignore
"""
``SAL r/m16, 1``

``o16 D1 /6``

``8086+``

``16/32/64-bit``
"""
SAL_RM32_1: Code = 453 # type: ignore
"""
``SAL r/m32, 1``

``o32 D1 /6``

``386+``

``16/32/64-bit``
"""
SAL_RM64_1: Code = 454 # type: ignore
"""
``SAL r/m64, 1``

``o64 D1 /6``

``X64``

``64-bit``
"""
SAR_RM16_1: Code = 455 # type: ignore
"""
``SAR r/m16, 1``

``o16 D1 /7``

``8086+``

``16/32/64-bit``
"""
SAR_RM32_1: Code = 456 # type: ignore
"""
``SAR r/m32, 1``

``o32 D1 /7``

``386+``

``16/32/64-bit``
"""
SAR_RM64_1: Code = 457 # type: ignore
"""
``SAR r/m64, 1``

``o64 D1 /7``

``X64``

``64-bit``
"""
ROL_RM8_CL: Code = 458 # type: ignore
"""
``ROL r/m8, CL``

``D2 /0``

``8086+``

``16/32/64-bit``
"""
ROR_RM8_CL: Code = 459 # type: ignore
"""
``ROR r/m8, CL``

``D2 /1``

``8086+``

``16/32/64-bit``
"""
RCL_RM8_CL: Code = 460 # type: ignore
"""
``RCL r/m8, CL``

``D2 /2``

``8086+``

``16/32/64-bit``
"""
RCR_RM8_CL: Code = 461 # type: ignore
"""
``RCR r/m8, CL``

``D2 /3``

``8086+``

``16/32/64-bit``
"""
SHL_RM8_CL: Code = 462 # type: ignore
"""
``SHL r/m8, CL``

``D2 /4``

``8086+``

``16/32/64-bit``
"""
SHR_RM8_CL: Code = 463 # type: ignore
"""
``SHR r/m8, CL``

``D2 /5``

``8086+``

``16/32/64-bit``
"""
SAL_RM8_CL: Code = 464 # type: ignore
"""
``SAL r/m8, CL``

``D2 /6``

``8086+``

``16/32/64-bit``
"""
SAR_RM8_CL: Code = 465 # type: ignore
"""
``SAR r/m8, CL``

``D2 /7``

``8086+``

``16/32/64-bit``
"""
ROL_RM16_CL: Code = 466 # type: ignore
"""
``ROL r/m16, CL``

``o16 D3 /0``

``8086+``

``16/32/64-bit``
"""
ROL_RM32_CL: Code = 467 # type: ignore
"""
``ROL r/m32, CL``

``o32 D3 /0``

``386+``

``16/32/64-bit``
"""
ROL_RM64_CL: Code = 468 # type: ignore
"""
``ROL r/m64, CL``

``o64 D3 /0``

``X64``

``64-bit``
"""
ROR_RM16_CL: Code = 469 # type: ignore
"""
``ROR r/m16, CL``

``o16 D3 /1``

``8086+``

``16/32/64-bit``
"""
ROR_RM32_CL: Code = 470 # type: ignore
"""
``ROR r/m32, CL``

``o32 D3 /1``

``386+``

``16/32/64-bit``
"""
ROR_RM64_CL: Code = 471 # type: ignore
"""
``ROR r/m64, CL``

``o64 D3 /1``

``X64``

``64-bit``
"""
RCL_RM16_CL: Code = 472 # type: ignore
"""
``RCL r/m16, CL``

``o16 D3 /2``

``8086+``

``16/32/64-bit``
"""
RCL_RM32_CL: Code = 473 # type: ignore
"""
``RCL r/m32, CL``

``o32 D3 /2``

``386+``

``16/32/64-bit``
"""
RCL_RM64_CL: Code = 474 # type: ignore
"""
``RCL r/m64, CL``

``o64 D3 /2``

``X64``

``64-bit``
"""
RCR_RM16_CL: Code = 475 # type: ignore
"""
``RCR r/m16, CL``

``o16 D3 /3``

``8086+``

``16/32/64-bit``
"""
RCR_RM32_CL: Code = 476 # type: ignore
"""
``RCR r/m32, CL``

``o32 D3 /3``

``386+``

``16/32/64-bit``
"""
RCR_RM64_CL: Code = 477 # type: ignore
"""
``RCR r/m64, CL``

``o64 D3 /3``

``X64``

``64-bit``
"""
SHL_RM16_CL: Code = 478 # type: ignore
"""
``SHL r/m16, CL``

``o16 D3 /4``

``8086+``

``16/32/64-bit``
"""
SHL_RM32_CL: Code = 479 # type: ignore
"""
``SHL r/m32, CL``

``o32 D3 /4``

``386+``

``16/32/64-bit``
"""
SHL_RM64_CL: Code = 480 # type: ignore
"""
``SHL r/m64, CL``

``o64 D3 /4``

``X64``

``64-bit``
"""
SHR_RM16_CL: Code = 481 # type: ignore
"""
``SHR r/m16, CL``

``o16 D3 /5``

``8086+``

``16/32/64-bit``
"""
SHR_RM32_CL: Code = 482 # type: ignore
"""
``SHR r/m32, CL``

``o32 D3 /5``

``386+``

``16/32/64-bit``
"""
SHR_RM64_CL: Code = 483 # type: ignore
"""
``SHR r/m64, CL``

``o64 D3 /5``

``X64``

``64-bit``
"""
SAL_RM16_CL: Code = 484 # type: ignore
"""
``SAL r/m16, CL``

``o16 D3 /6``

``8086+``

``16/32/64-bit``
"""
SAL_RM32_CL: Code = 485 # type: ignore
"""
``SAL r/m32, CL``

``o32 D3 /6``

``386+``

``16/32/64-bit``
"""
SAL_RM64_CL: Code = 486 # type: ignore
"""
``SAL r/m64, CL``

``o64 D3 /6``

``X64``

``64-bit``
"""
SAR_RM16_CL: Code = 487 # type: ignore
"""
``SAR r/m16, CL``

``o16 D3 /7``

``8086+``

``16/32/64-bit``
"""
SAR_RM32_CL: Code = 488 # type: ignore
"""
``SAR r/m32, CL``

``o32 D3 /7``

``386+``

``16/32/64-bit``
"""
SAR_RM64_CL: Code = 489 # type: ignore
"""
``SAR r/m64, CL``

``o64 D3 /7``

``X64``

``64-bit``
"""
AAM_IMM8: Code = 490 # type: ignore
"""
``AAM imm8``

``D4 ib``

``8086+``

``16/32-bit``
"""
AAD_IMM8: Code = 491 # type: ignore
"""
``AAD imm8``

``D5 ib``

``8086+``

``16/32-bit``
"""
SALC: Code = 492 # type: ignore
"""
``SALC``

``D6``

``8086+``

``16/32-bit``
"""
XLAT_M8: Code = 493 # type: ignore
"""
``XLATB``

``D7``

``8086+``

``16/32/64-bit``
"""
FADD_M32FP: Code = 494 # type: ignore
"""
``FADD m32fp``

``D8 /0``

``8087+``

``16/32/64-bit``
"""
FMUL_M32FP: Code = 495 # type: ignore
"""
``FMUL m32fp``

``D8 /1``

``8087+``

``16/32/64-bit``
"""
FCOM_M32FP: Code = 496 # type: ignore
"""
``FCOM m32fp``

``D8 /2``

``8087+``

``16/32/64-bit``
"""
FCOMP_M32FP: Code = 497 # type: ignore
"""
``FCOMP m32fp``

``D8 /3``

``8087+``

``16/32/64-bit``
"""
FSUB_M32FP: Code = 498 # type: ignore
"""
``FSUB m32fp``

``D8 /4``

``8087+``

``16/32/64-bit``
"""
FSUBR_M32FP: Code = 499 # type: ignore
"""
``FSUBR m32fp``

``D8 /5``

``8087+``

``16/32/64-bit``
"""
FDIV_M32FP: Code = 500 # type: ignore
"""
``FDIV m32fp``

``D8 /6``

``8087+``

``16/32/64-bit``
"""
FDIVR_M32FP: Code = 501 # type: ignore
"""
``FDIVR m32fp``

``D8 /7``

``8087+``

``16/32/64-bit``
"""
FADD_ST0_STI: Code = 502 # type: ignore
"""
``FADD ST(0), ST(i)``

``D8 C0+i``

``8087+``

``16/32/64-bit``
"""
FMUL_ST0_STI: Code = 503 # type: ignore
"""
``FMUL ST(0), ST(i)``

``D8 C8+i``

``8087+``

``16/32/64-bit``
"""
FCOM_ST0_STI: Code = 504 # type: ignore
"""
``FCOM ST(i)``

``D8 D0+i``

``8087+``

``16/32/64-bit``
"""
FCOMP_ST0_STI: Code = 505 # type: ignore
"""
``FCOMP ST(i)``

``D8 D8+i``

``8087+``

``16/32/64-bit``
"""
FSUB_ST0_STI: Code = 506 # type: ignore
"""
``FSUB ST(0), ST(i)``

``D8 E0+i``

``8087+``

``16/32/64-bit``
"""
FSUBR_ST0_STI: Code = 507 # type: ignore
"""
``FSUBR ST(0), ST(i)``

``D8 E8+i``

``8087+``

``16/32/64-bit``
"""
FDIV_ST0_STI: Code = 508 # type: ignore
"""
``FDIV ST(0), ST(i)``

``D8 F0+i``

``8087+``

``16/32/64-bit``
"""
FDIVR_ST0_STI: Code = 509 # type: ignore
"""
``FDIVR ST(0), ST(i)``

``D8 F8+i``

``8087+``

``16/32/64-bit``
"""
FLD_M32FP: Code = 510 # type: ignore
"""
``FLD m32fp``

``D9 /0``

``8087+``

``16/32/64-bit``
"""
FST_M32FP: Code = 511 # type: ignore
"""
``FST m32fp``

``D9 /2``

``8087+``

``16/32/64-bit``
"""
FSTP_M32FP: Code = 512 # type: ignore
"""
``FSTP m32fp``

``D9 /3``

``8087+``

``16/32/64-bit``
"""
FLDENV_M14BYTE: Code = 513 # type: ignore
"""
``FLDENV m14byte``

``o16 D9 /4``

``8087+``

``16/32/64-bit``
"""
FLDENV_M28BYTE: Code = 514 # type: ignore
"""
``FLDENV m28byte``

``o32 D9 /4``

``387+``

``16/32/64-bit``
"""
FLDCW_M2BYTE: Code = 515 # type: ignore
"""
``FLDCW m2byte``

``D9 /5``

``8087+``

``16/32/64-bit``
"""
FNSTENV_M14BYTE: Code = 516 # type: ignore
"""
``FNSTENV m14byte``

``o16 D9 /6``

``8087+``

``16/32/64-bit``
"""
FSTENV_M14BYTE: Code = 517 # type: ignore
"""
``FSTENV m14byte``

``9B o16 D9 /6``

``8087+``

``16/32/64-bit``
"""
FNSTENV_M28BYTE: Code = 518 # type: ignore
"""
``FNSTENV m28byte``

``o32 D9 /6``

``387+``

``16/32/64-bit``
"""
FSTENV_M28BYTE: Code = 519 # type: ignore
"""
``FSTENV m28byte``

``9B o32 D9 /6``

``387+``

``16/32/64-bit``
"""
FNSTCW_M2BYTE: Code = 520 # type: ignore
"""
``FNSTCW m2byte``

``D9 /7``

``8087+``

``16/32/64-bit``
"""
FSTCW_M2BYTE: Code = 521 # type: ignore
"""
``FSTCW m2byte``

``9B D9 /7``

``8087+``

``16/32/64-bit``
"""
FLD_STI: Code = 522 # type: ignore
"""
``FLD ST(i)``

``D9 C0+i``

``8087+``

``16/32/64-bit``
"""
FXCH_ST0_STI: Code = 523 # type: ignore
"""
``FXCH ST(i)``

``D9 C8+i``

``8087+``

``16/32/64-bit``
"""
FNOP: Code = 524 # type: ignore
"""
``FNOP``

``D9 D0``

``8087+``

``16/32/64-bit``
"""
FSTPNCE_STI: Code = 525 # type: ignore
"""
``FSTPNCE ST(i)``

``D9 D8+i``

``8087+``

``16/32/64-bit``
"""
FCHS: Code = 526 # type: ignore
"""
``FCHS``

``D9 E0``

``8087+``

``16/32/64-bit``
"""
FABS: Code = 527 # type: ignore
"""
``FABS``

``D9 E1``

``8087+``

``16/32/64-bit``
"""
FTST: Code = 528 # type: ignore
"""
``FTST``

``D9 E4``

``8087+``

``16/32/64-bit``
"""
FXAM: Code = 529 # type: ignore
"""
``FXAM``

``D9 E5``

``8087+``

``16/32/64-bit``
"""
FLD1: Code = 530 # type: ignore
"""
``FLD1``

``D9 E8``

``8087+``

``16/32/64-bit``
"""
FLDL2T: Code = 531 # type: ignore
"""
``FLDL2T``

``D9 E9``

``8087+``

``16/32/64-bit``
"""
FLDL2E: Code = 532 # type: ignore
"""
``FLDL2E``

``D9 EA``

``8087+``

``16/32/64-bit``
"""
FLDPI: Code = 533 # type: ignore
"""
``FLDPI``

``D9 EB``

``8087+``

``16/32/64-bit``
"""
FLDLG2: Code = 534 # type: ignore
"""
``FLDLG2``

``D9 EC``

``8087+``

``16/32/64-bit``
"""
FLDLN2: Code = 535 # type: ignore
"""
``FLDLN2``

``D9 ED``

``8087+``

``16/32/64-bit``
"""
FLDZ: Code = 536 # type: ignore
"""
``FLDZ``

``D9 EE``

``8087+``

``16/32/64-bit``
"""
F2XM1: Code = 537 # type: ignore
"""
``F2XM1``

``D9 F0``

``8087+``

``16/32/64-bit``
"""
FYL2X: Code = 538 # type: ignore
"""
``FYL2X``

``D9 F1``

``8087+``

``16/32/64-bit``
"""
FPTAN: Code = 539 # type: ignore
"""
``FPTAN``

``D9 F2``

``8087+``

``16/32/64-bit``
"""
FPATAN: Code = 540 # type: ignore
"""
``FPATAN``

``D9 F3``

``8087+``

``16/32/64-bit``
"""
FXTRACT: Code = 541 # type: ignore
"""
``FXTRACT``

``D9 F4``

``8087+``

``16/32/64-bit``
"""
FPREM1: Code = 542 # type: ignore
"""
``FPREM1``

``D9 F5``

``387+``

``16/32/64-bit``
"""
FDECSTP: Code = 543 # type: ignore
"""
``FDECSTP``

``D9 F6``

``8087+``

``16/32/64-bit``
"""
FINCSTP: Code = 544 # type: ignore
"""
``FINCSTP``

``D9 F7``

``8087+``

``16/32/64-bit``
"""
FPREM: Code = 545 # type: ignore
"""
``FPREM``

``D9 F8``

``8087+``

``16/32/64-bit``
"""
FYL2XP1: Code = 546 # type: ignore
"""
``FYL2XP1``

``D9 F9``

``8087+``

``16/32/64-bit``
"""
FSQRT: Code = 547 # type: ignore
"""
``FSQRT``

``D9 FA``

``8087+``

``16/32/64-bit``
"""
FSINCOS: Code = 548 # type: ignore
"""
``FSINCOS``

``D9 FB``

``387+``

``16/32/64-bit``
"""
FRNDINT: Code = 549 # type: ignore
"""
``FRNDINT``

``D9 FC``

``8087+``

``16/32/64-bit``
"""
FSCALE: Code = 550 # type: ignore
"""
``FSCALE``

``D9 FD``

``8087+``

``16/32/64-bit``
"""
FSIN: Code = 551 # type: ignore
"""
``FSIN``

``D9 FE``

``387+``

``16/32/64-bit``
"""
FCOS: Code = 552 # type: ignore
"""
``FCOS``

``D9 FF``

``387+``

``16/32/64-bit``
"""
FIADD_M32INT: Code = 553 # type: ignore
"""
``FIADD m32int``

``DA /0``

``8087+``

``16/32/64-bit``
"""
FIMUL_M32INT: Code = 554 # type: ignore
"""
``FIMUL m32int``

``DA /1``

``8087+``

``16/32/64-bit``
"""
FICOM_M32INT: Code = 555 # type: ignore
"""
``FICOM m32int``

``DA /2``

``8087+``

``16/32/64-bit``
"""
FICOMP_M32INT: Code = 556 # type: ignore
"""
``FICOMP m32int``

``DA /3``

``8087+``

``16/32/64-bit``
"""
FISUB_M32INT: Code = 557 # type: ignore
"""
``FISUB m32int``

``DA /4``

``8087+``

``16/32/64-bit``
"""
FISUBR_M32INT: Code = 558 # type: ignore
"""
``FISUBR m32int``

``DA /5``

``8087+``

``16/32/64-bit``
"""
FIDIV_M32INT: Code = 559 # type: ignore
"""
``FIDIV m32int``

``DA /6``

``8087+``

``16/32/64-bit``
"""
FIDIVR_M32INT: Code = 560 # type: ignore
"""
``FIDIVR m32int``

``DA /7``

``8087+``

``16/32/64-bit``
"""
FCMOVB_ST0_STI: Code = 561 # type: ignore
"""
``FCMOVB ST(0), ST(i)``

``DA C0+i``

``8087+ and CMOV``

``16/32/64-bit``
"""
FCMOVE_ST0_STI: Code = 562 # type: ignore
"""
``FCMOVE ST(0), ST(i)``

``DA C8+i``

``8087+ and CMOV``

``16/32/64-bit``
"""
FCMOVBE_ST0_STI: Code = 563 # type: ignore
"""
``FCMOVBE ST(0), ST(i)``

``DA D0+i``

``8087+ and CMOV``

``16/32/64-bit``
"""
FCMOVU_ST0_STI: Code = 564 # type: ignore
"""
``FCMOVU ST(0), ST(i)``

``DA D8+i``

``8087+ and CMOV``

``16/32/64-bit``
"""
FUCOMPP: Code = 565 # type: ignore
"""
``FUCOMPP``

``DA E9``

``387+``

``16/32/64-bit``
"""
FILD_M32INT: Code = 566 # type: ignore
"""
``FILD m32int``

``DB /0``

``8087+``

``16/32/64-bit``
"""
FISTTP_M32INT: Code = 567 # type: ignore
"""
``FISTTP m32int``

``DB /1``

``8087+ and SSE3``

``16/32/64-bit``
"""
FIST_M32INT: Code = 568 # type: ignore
"""
``FIST m32int``

``DB /2``

``8087+``

``16/32/64-bit``
"""
FISTP_M32INT: Code = 569 # type: ignore
"""
``FISTP m32int``

``DB /3``

``8087+``

``16/32/64-bit``
"""
FLD_M80FP: Code = 570 # type: ignore
"""
``FLD m80fp``

``DB /5``

``8087+``

``16/32/64-bit``
"""
FSTP_M80FP: Code = 571 # type: ignore
"""
``FSTP m80fp``

``DB /7``

``8087+``

``16/32/64-bit``
"""
FCMOVNB_ST0_STI: Code = 572 # type: ignore
"""
``FCMOVNB ST(0), ST(i)``

``DB C0+i``

``8087+ and CMOV``

``16/32/64-bit``
"""
FCMOVNE_ST0_STI: Code = 573 # type: ignore
"""
``FCMOVNE ST(0), ST(i)``

``DB C8+i``

``8087+ and CMOV``

``16/32/64-bit``
"""
FCMOVNBE_ST0_STI: Code = 574 # type: ignore
"""
``FCMOVNBE ST(0), ST(i)``

``DB D0+i``

``8087+ and CMOV``

``16/32/64-bit``
"""
FCMOVNU_ST0_STI: Code = 575 # type: ignore
"""
``FCMOVNU ST(0), ST(i)``

``DB D8+i``

``8087+ and CMOV``

``16/32/64-bit``
"""
FNENI: Code = 576 # type: ignore
"""
``FNENI``

``DB E0``

``8087+``

``16/32/64-bit``
"""
FENI: Code = 577 # type: ignore
"""
``FENI``

``9B DB E0``

``8087+``

``16/32/64-bit``
"""
FNDISI: Code = 578 # type: ignore
"""
``FNDISI``

``DB E1``

``8087+``

``16/32/64-bit``
"""
FDISI: Code = 579 # type: ignore
"""
``FDISI``

``9B DB E1``

``8087+``

``16/32/64-bit``
"""
FNCLEX: Code = 580 # type: ignore
"""
``FNCLEX``

``DB E2``

``8087+``

``16/32/64-bit``
"""
FCLEX: Code = 581 # type: ignore
"""
``FCLEX``

``9B DB E2``

``8087+``

``16/32/64-bit``
"""
FNINIT: Code = 582 # type: ignore
"""
``FNINIT``

``DB E3``

``8087+``

``16/32/64-bit``
"""
FINIT: Code = 583 # type: ignore
"""
``FINIT``

``9B DB E3``

``8087+``

``16/32/64-bit``
"""
FNSETPM: Code = 584 # type: ignore
"""
``FNSETPM``

``DB E4``

``287+``

``16/32/64-bit``
"""
FSETPM: Code = 585 # type: ignore
"""
``FSETPM``

``9B DB E4``

``287+``

``16/32/64-bit``
"""
FRSTPM: Code = 586 # type: ignore
"""
``FRSTPM``

``DB E5``

``287 XL``

``16/32-bit``
"""
FUCOMI_ST0_STI: Code = 587 # type: ignore
"""
``FUCOMI ST, ST(i)``

``DB E8+i``

``8087+ and CMOV``

``16/32/64-bit``
"""
FCOMI_ST0_STI: Code = 588 # type: ignore
"""
``FCOMI ST, ST(i)``

``DB F0+i``

``8087+ and CMOV``

``16/32/64-bit``
"""
FADD_M64FP: Code = 589 # type: ignore
"""
``FADD m64fp``

``DC /0``

``8087+``

``16/32/64-bit``
"""
FMUL_M64FP: Code = 590 # type: ignore
"""
``FMUL m64fp``

``DC /1``

``8087+``

``16/32/64-bit``
"""
FCOM_M64FP: Code = 591 # type: ignore
"""
``FCOM m64fp``

``DC /2``

``8087+``

``16/32/64-bit``
"""
FCOMP_M64FP: Code = 592 # type: ignore
"""
``FCOMP m64fp``

``DC /3``

``8087+``

``16/32/64-bit``
"""
FSUB_M64FP: Code = 593 # type: ignore
"""
``FSUB m64fp``

``DC /4``

``8087+``

``16/32/64-bit``
"""
FSUBR_M64FP: Code = 594 # type: ignore
"""
``FSUBR m64fp``

``DC /5``

``8087+``

``16/32/64-bit``
"""
FDIV_M64FP: Code = 595 # type: ignore
"""
``FDIV m64fp``

``DC /6``

``8087+``

``16/32/64-bit``
"""
FDIVR_M64FP: Code = 596 # type: ignore
"""
``FDIVR m64fp``

``DC /7``

``8087+``

``16/32/64-bit``
"""
FADD_STI_ST0: Code = 597 # type: ignore
"""
``FADD ST(i), ST(0)``

``DC C0+i``

``8087+``

``16/32/64-bit``
"""
FMUL_STI_ST0: Code = 598 # type: ignore
"""
``FMUL ST(i), ST(0)``

``DC C8+i``

``8087+``

``16/32/64-bit``
"""
FCOM_ST0_STI_DCD0: Code = 599 # type: ignore
"""
``FCOM ST(i)``

``DC D0+i``

``8087+``

``16/32/64-bit``
"""
FCOMP_ST0_STI_DCD8: Code = 600 # type: ignore
"""
``FCOMP ST(i)``

``DC D8+i``

``8087+``

``16/32/64-bit``
"""
FSUBR_STI_ST0: Code = 601 # type: ignore
"""
``FSUBR ST(i), ST(0)``

``DC E0+i``

``8087+``

``16/32/64-bit``
"""
FSUB_STI_ST0: Code = 602 # type: ignore
"""
``FSUB ST(i), ST(0)``

``DC E8+i``

``8087+``

``16/32/64-bit``
"""
FDIVR_STI_ST0: Code = 603 # type: ignore
"""
``FDIVR ST(i), ST(0)``

``DC F0+i``

``8087+``

``16/32/64-bit``
"""
FDIV_STI_ST0: Code = 604 # type: ignore
"""
``FDIV ST(i), ST(0)``

``DC F8+i``

``8087+``

``16/32/64-bit``
"""
FLD_M64FP: Code = 605 # type: ignore
"""
``FLD m64fp``

``DD /0``

``8087+``

``16/32/64-bit``
"""
FISTTP_M64INT: Code = 606 # type: ignore
"""
``FISTTP m64int``

``DD /1``

``8087+ and SSE3``

``16/32/64-bit``
"""
FST_M64FP: Code = 607 # type: ignore
"""
``FST m64fp``

``DD /2``

``8087+``

``16/32/64-bit``
"""
FSTP_M64FP: Code = 608 # type: ignore
"""
``FSTP m64fp``

``DD /3``

``8087+``

``16/32/64-bit``
"""
FRSTOR_M94BYTE: Code = 609 # type: ignore
"""
``FRSTOR m94byte``

``o16 DD /4``

``8087+``

``16/32/64-bit``
"""
FRSTOR_M108BYTE: Code = 610 # type: ignore
"""
``FRSTOR m108byte``

``o32 DD /4``

``387+``

``16/32/64-bit``
"""
FNSAVE_M94BYTE: Code = 611 # type: ignore
"""
``FNSAVE m94byte``

``o16 DD /6``

``8087+``

``16/32/64-bit``
"""
FSAVE_M94BYTE: Code = 612 # type: ignore
"""
``FSAVE m94byte``

``9B o16 DD /6``

``8087+``

``16/32/64-bit``
"""
FNSAVE_M108BYTE: Code = 613 # type: ignore
"""
``FNSAVE m108byte``

``o32 DD /6``

``387+``

``16/32/64-bit``
"""
FSAVE_M108BYTE: Code = 614 # type: ignore
"""
``FSAVE m108byte``

``9B o32 DD /6``

``387+``

``16/32/64-bit``
"""
FNSTSW_M2BYTE: Code = 615 # type: ignore
"""
``FNSTSW m2byte``

``DD /7``

``8087+``

``16/32/64-bit``
"""
FSTSW_M2BYTE: Code = 616 # type: ignore
"""
``FSTSW m2byte``

``9B DD /7``

``8087+``

``16/32/64-bit``
"""
FFREE_STI: Code = 617 # type: ignore
"""
``FFREE ST(i)``

``DD C0+i``

``8087+``

``16/32/64-bit``
"""
FXCH_ST0_STI_DDC8: Code = 618 # type: ignore
"""
``FXCH ST(i)``

``DD C8+i``

``8087+``

``16/32/64-bit``
"""
FST_STI: Code = 619 # type: ignore
"""
``FST ST(i)``

``DD D0+i``

``8087+``

``16/32/64-bit``
"""
FSTP_STI: Code = 620 # type: ignore
"""
``FSTP ST(i)``

``DD D8+i``

``8087+``

``16/32/64-bit``
"""
FUCOM_ST0_STI: Code = 621 # type: ignore
"""
``FUCOM ST(i)``

``DD E0+i``

``8087+``

``16/32/64-bit``
"""
FUCOMP_ST0_STI: Code = 622 # type: ignore
"""
``FUCOMP ST(i)``

``DD E8+i``

``8087+``

``16/32/64-bit``
"""
FIADD_M16INT: Code = 623 # type: ignore
"""
``FIADD m16int``

``DE /0``

``8087+``

``16/32/64-bit``
"""
FIMUL_M16INT: Code = 624 # type: ignore
"""
``FIMUL m16int``

``DE /1``

``8087+``

``16/32/64-bit``
"""
FICOM_M16INT: Code = 625 # type: ignore
"""
``FICOM m16int``

``DE /2``

``8087+``

``16/32/64-bit``
"""
FICOMP_M16INT: Code = 626 # type: ignore
"""
``FICOMP m16int``

``DE /3``

``8087+``

``16/32/64-bit``
"""
FISUB_M16INT: Code = 627 # type: ignore
"""
``FISUB m16int``

``DE /4``

``8087+``

``16/32/64-bit``
"""
FISUBR_M16INT: Code = 628 # type: ignore
"""
``FISUBR m16int``

``DE /5``

``8087+``

``16/32/64-bit``
"""
FIDIV_M16INT: Code = 629 # type: ignore
"""
``FIDIV m16int``

``DE /6``

``8087+``

``16/32/64-bit``
"""
FIDIVR_M16INT: Code = 630 # type: ignore
"""
``FIDIVR m16int``

``DE /7``

``8087+``

``16/32/64-bit``
"""
FADDP_STI_ST0: Code = 631 # type: ignore
"""
``FADDP ST(i), ST(0)``

``DE C0+i``

``8087+``

``16/32/64-bit``
"""
FMULP_STI_ST0: Code = 632 # type: ignore
"""
``FMULP ST(i), ST(0)``

``DE C8+i``

``8087+``

``16/32/64-bit``
"""
FCOMP_ST0_STI_DED0: Code = 633 # type: ignore
"""
``FCOMP ST(i)``

``DE D0+i``

``8087+``

``16/32/64-bit``
"""
FCOMPP: Code = 634 # type: ignore
"""
``FCOMPP``

``DE D9``

``8087+``

``16/32/64-bit``
"""
FSUBRP_STI_ST0: Code = 635 # type: ignore
"""
``FSUBRP ST(i), ST(0)``

``DE E0+i``

``8087+``

``16/32/64-bit``
"""
FSUBP_STI_ST0: Code = 636 # type: ignore
"""
``FSUBP ST(i), ST(0)``

``DE E8+i``

``8087+``

``16/32/64-bit``
"""
FDIVRP_STI_ST0: Code = 637 # type: ignore
"""
``FDIVRP ST(i), ST(0)``

``DE F0+i``

``8087+``

``16/32/64-bit``
"""
FDIVP_STI_ST0: Code = 638 # type: ignore
"""
``FDIVP ST(i), ST(0)``

``DE F8+i``

``8087+``

``16/32/64-bit``
"""
FILD_M16INT: Code = 639 # type: ignore
"""
``FILD m16int``

``DF /0``

``8087+``

``16/32/64-bit``
"""
FISTTP_M16INT: Code = 640 # type: ignore
"""
``FISTTP m16int``

``DF /1``

``8087+ and SSE3``

``16/32/64-bit``
"""
FIST_M16INT: Code = 641 # type: ignore
"""
``FIST m16int``

``DF /2``

``8087+``

``16/32/64-bit``
"""
FISTP_M16INT: Code = 642 # type: ignore
"""
``FISTP m16int``

``DF /3``

``8087+``

``16/32/64-bit``
"""
FBLD_M80BCD: Code = 643 # type: ignore
"""
``FBLD m80bcd``

``DF /4``

``8087+``

``16/32/64-bit``
"""
FILD_M64INT: Code = 644 # type: ignore
"""
``FILD m64int``

``DF /5``

``8087+``

``16/32/64-bit``
"""
FBSTP_M80BCD: Code = 645 # type: ignore
"""
``FBSTP m80bcd``

``DF /6``

``8087+``

``16/32/64-bit``
"""
FISTP_M64INT: Code = 646 # type: ignore
"""
``FISTP m64int``

``DF /7``

``8087+``

``16/32/64-bit``
"""
FFREEP_STI: Code = 647 # type: ignore
"""
``FFREEP ST(i)``

``DF C0+i``

``8087+``

``16/32/64-bit``
"""
FXCH_ST0_STI_DFC8: Code = 648 # type: ignore
"""
``FXCH ST(i)``

``DF C8+i``

``8087+``

``16/32/64-bit``
"""
FSTP_STI_DFD0: Code = 649 # type: ignore
"""
``FSTP ST(i)``

``DF D0+i``

``8087+``

``16/32/64-bit``
"""
FSTP_STI_DFD8: Code = 650 # type: ignore
"""
``FSTP ST(i)``

``DF D8+i``

``8087+``

``16/32/64-bit``
"""
FNSTSW_AX: Code = 651 # type: ignore
"""
``FNSTSW AX``

``DF E0``

``287+``

``16/32/64-bit``
"""
FSTSW_AX: Code = 652 # type: ignore
"""
``FSTSW AX``

``9B DF E0``

``287+``

``16/32/64-bit``
"""
FSTDW_AX: Code = 653 # type: ignore
"""
``FSTDW AX``

``9B DF E1``

``387 SL``

``16/32-bit``
"""
FSTSG_AX: Code = 654 # type: ignore
"""
``FSTSG AX``

``9B DF E2``

``387 SL``

``16/32-bit``
"""
FUCOMIP_ST0_STI: Code = 655 # type: ignore
"""
``FUCOMIP ST, ST(i)``

``DF E8+i``

``8087+ and CMOV``

``16/32/64-bit``
"""
FCOMIP_ST0_STI: Code = 656 # type: ignore
"""
``FCOMIP ST, ST(i)``

``DF F0+i``

``8087+ and CMOV``

``16/32/64-bit``
"""
LOOPNE_REL8_16_CX: Code = 657 # type: ignore
"""
``LOOPNE rel8``

``a16 o16 E0 cb``

``8086+``

``16/32-bit``
"""
LOOPNE_REL8_32_CX: Code = 658 # type: ignore
"""
``LOOPNE rel8``

``a16 o32 E0 cb``

``386+``

``16/32-bit``
"""
LOOPNE_REL8_16_ECX: Code = 659 # type: ignore
"""
``LOOPNE rel8``

``a32 o16 E0 cb``

``386+``

``16/32/64-bit``
"""
LOOPNE_REL8_32_ECX: Code = 660 # type: ignore
"""
``LOOPNE rel8``

``a32 o32 E0 cb``

``386+``

``16/32-bit``
"""
LOOPNE_REL8_64_ECX: Code = 661 # type: ignore
"""
``LOOPNE rel8``

``a32 o64 E0 cb``

``X64``

``64-bit``
"""
LOOPNE_REL8_16_RCX: Code = 662 # type: ignore
"""
``LOOPNE rel8``

``a64 o16 E0 cb``

``X64``

``64-bit``
"""
LOOPNE_REL8_64_RCX: Code = 663 # type: ignore
"""
``LOOPNE rel8``

``a64 o64 E0 cb``

``X64``

``64-bit``
"""
LOOPE_REL8_16_CX: Code = 664 # type: ignore
"""
``LOOPE rel8``

``a16 o16 E1 cb``

``8086+``

``16/32-bit``
"""
LOOPE_REL8_32_CX: Code = 665 # type: ignore
"""
``LOOPE rel8``

``a16 o32 E1 cb``

``386+``

``16/32-bit``
"""
LOOPE_REL8_16_ECX: Code = 666 # type: ignore
"""
``LOOPE rel8``

``a32 o16 E1 cb``

``386+``

``16/32/64-bit``
"""
LOOPE_REL8_32_ECX: Code = 667 # type: ignore
"""
``LOOPE rel8``

``a32 o32 E1 cb``

``386+``

``16/32-bit``
"""
LOOPE_REL8_64_ECX: Code = 668 # type: ignore
"""
``LOOPE rel8``

``a32 o64 E1 cb``

``X64``

``64-bit``
"""
LOOPE_REL8_16_RCX: Code = 669 # type: ignore
"""
``LOOPE rel8``

``a64 o16 E1 cb``

``X64``

``64-bit``
"""
LOOPE_REL8_64_RCX: Code = 670 # type: ignore
"""
``LOOPE rel8``

``a64 o64 E1 cb``

``X64``

``64-bit``
"""
LOOP_REL8_16_CX: Code = 671 # type: ignore
"""
``LOOP rel8``

``a16 o16 E2 cb``

``8086+``

``16/32-bit``
"""
LOOP_REL8_32_CX: Code = 672 # type: ignore
"""
``LOOP rel8``

``a16 o32 E2 cb``

``386+``

``16/32-bit``
"""
LOOP_REL8_16_ECX: Code = 673 # type: ignore
"""
``LOOP rel8``

``a32 o16 E2 cb``

``386+``

``16/32/64-bit``
"""
LOOP_REL8_32_ECX: Code = 674 # type: ignore
"""
``LOOP rel8``

``a32 o32 E2 cb``

``386+``

``16/32-bit``
"""
LOOP_REL8_64_ECX: Code = 675 # type: ignore
"""
``LOOP rel8``

``a32 o64 E2 cb``

``X64``

``64-bit``
"""
LOOP_REL8_16_RCX: Code = 676 # type: ignore
"""
``LOOP rel8``

``a64 o16 E2 cb``

``X64``

``64-bit``
"""
LOOP_REL8_64_RCX: Code = 677 # type: ignore
"""
``LOOP rel8``

``a64 o64 E2 cb``

``X64``

``64-bit``
"""
JCXZ_REL8_16: Code = 678 # type: ignore
"""
``JCXZ rel8``

``a16 o16 E3 cb``

``8086+``

``16/32-bit``
"""
JCXZ_REL8_32: Code = 679 # type: ignore
"""
``JCXZ rel8``

``a16 o32 E3 cb``

``386+``

``16/32-bit``
"""
JECXZ_REL8_16: Code = 680 # type: ignore
"""
``JECXZ rel8``

``a32 o16 E3 cb``

``386+``

``16/32/64-bit``
"""
JECXZ_REL8_32: Code = 681 # type: ignore
"""
``JECXZ rel8``

``a32 o32 E3 cb``

``386+``

``16/32-bit``
"""
JECXZ_REL8_64: Code = 682 # type: ignore
"""
``JECXZ rel8``

``a32 o64 E3 cb``

``X64``

``64-bit``
"""
JRCXZ_REL8_16: Code = 683 # type: ignore
"""
``JRCXZ rel8``

``a64 o16 E3 cb``

``X64``

``64-bit``
"""
JRCXZ_REL8_64: Code = 684 # type: ignore
"""
``JRCXZ rel8``

``a64 o64 E3 cb``

``X64``

``64-bit``
"""
IN_AL_IMM8: Code = 685 # type: ignore
"""
``IN AL, imm8``

``E4 ib``

``8086+``

``16/32/64-bit``
"""
IN_AX_IMM8: Code = 686 # type: ignore
"""
``IN AX, imm8``

``o16 E5 ib``

``8086+``

``16/32/64-bit``
"""
IN_EAX_IMM8: Code = 687 # type: ignore
"""
``IN EAX, imm8``

``o32 E5 ib``

``386+``

``16/32/64-bit``
"""
OUT_IMM8_AL: Code = 688 # type: ignore
"""
``OUT imm8, AL``

``E6 ib``

``8086+``

``16/32/64-bit``
"""
OUT_IMM8_AX: Code = 689 # type: ignore
"""
``OUT imm8, AX``

``o16 E7 ib``

``8086+``

``16/32/64-bit``
"""
OUT_IMM8_EAX: Code = 690 # type: ignore
"""
``OUT imm8, EAX``

``o32 E7 ib``

``386+``

``16/32/64-bit``
"""
CALL_REL16: Code = 691 # type: ignore
"""
``CALL rel16``

``o16 E8 cw``

``8086+``

``16/32/64-bit``
"""
CALL_REL32_32: Code = 692 # type: ignore
"""
``CALL rel32``

``o32 E8 cd``

``386+``

``16/32-bit``
"""
CALL_REL32_64: Code = 693 # type: ignore
"""
``CALL rel32``

``o64 E8 cd``

``X64``

``64-bit``
"""
JMP_REL16: Code = 694 # type: ignore
"""
``JMP rel16``

``o16 E9 cw``

``8086+``

``16/32/64-bit``
"""
JMP_REL32_32: Code = 695 # type: ignore
"""
``JMP rel32``

``o32 E9 cd``

``386+``

``16/32-bit``
"""
JMP_REL32_64: Code = 696 # type: ignore
"""
``JMP rel32``

``o64 E9 cd``

``X64``

``64-bit``
"""
JMP_PTR1616: Code = 697 # type: ignore
"""
``JMP ptr16:16``

``o16 EA cd``

``8086+``

``16/32-bit``
"""
JMP_PTR1632: Code = 698 # type: ignore
"""
``JMP ptr16:32``

``o32 EA cp``

``386+``

``16/32-bit``
"""
JMP_REL8_16: Code = 699 # type: ignore
"""
``JMP rel8``

``o16 EB cb``

``8086+``

``16/32/64-bit``
"""
JMP_REL8_32: Code = 700 # type: ignore
"""
``JMP rel8``

``o32 EB cb``

``386+``

``16/32-bit``
"""
JMP_REL8_64: Code = 701 # type: ignore
"""
``JMP rel8``

``o64 EB cb``

``X64``

``64-bit``
"""
IN_AL_DX: Code = 702 # type: ignore
"""
``IN AL, DX``

``EC``

``8086+``

``16/32/64-bit``
"""
IN_AX_DX: Code = 703 # type: ignore
"""
``IN AX, DX``

``o16 ED``

``8086+``

``16/32/64-bit``
"""
IN_EAX_DX: Code = 704 # type: ignore
"""
``IN EAX, DX``

``o32 ED``

``386+``

``16/32/64-bit``
"""
OUT_DX_AL: Code = 705 # type: ignore
"""
``OUT DX, AL``

``EE``

``8086+``

``16/32/64-bit``
"""
OUT_DX_AX: Code = 706 # type: ignore
"""
``OUT DX, AX``

``o16 EF``

``8086+``

``16/32/64-bit``
"""
OUT_DX_EAX: Code = 707 # type: ignore
"""
``OUT DX, EAX``

``o32 EF``

``386+``

``16/32/64-bit``
"""
INT1: Code = 708 # type: ignore
"""
``INT1``

``F1``

``386+``

``16/32/64-bit``
"""
HLT: Code = 709 # type: ignore
"""
``HLT``

``F4``

``8086+``

``16/32/64-bit``
"""
CMC: Code = 710 # type: ignore
"""
``CMC``

``F5``

``8086+``

``16/32/64-bit``
"""
TEST_RM8_IMM8: Code = 711 # type: ignore
"""
``TEST r/m8, imm8``

``F6 /0 ib``

``8086+``

``16/32/64-bit``
"""
TEST_RM8_IMM8_F6R1: Code = 712 # type: ignore
"""
``TEST r/m8, imm8``

``F6 /1 ib``

``8086+``

``16/32/64-bit``
"""
NOT_RM8: Code = 713 # type: ignore
"""
``NOT r/m8``

``F6 /2``

``8086+``

``16/32/64-bit``
"""
NEG_RM8: Code = 714 # type: ignore
"""
``NEG r/m8``

``F6 /3``

``8086+``

``16/32/64-bit``
"""
MUL_RM8: Code = 715 # type: ignore
"""
``MUL r/m8``

``F6 /4``

``8086+``

``16/32/64-bit``
"""
IMUL_RM8: Code = 716 # type: ignore
"""
``IMUL r/m8``

``F6 /5``

``8086+``

``16/32/64-bit``
"""
DIV_RM8: Code = 717 # type: ignore
"""
``DIV r/m8``

``F6 /6``

``8086+``

``16/32/64-bit``
"""
IDIV_RM8: Code = 718 # type: ignore
"""
``IDIV r/m8``

``F6 /7``

``8086+``

``16/32/64-bit``
"""
TEST_RM16_IMM16: Code = 719 # type: ignore
"""
``TEST r/m16, imm16``

``o16 F7 /0 iw``

``8086+``

``16/32/64-bit``
"""
TEST_RM32_IMM32: Code = 720 # type: ignore
"""
``TEST r/m32, imm32``

``o32 F7 /0 id``

``386+``

``16/32/64-bit``
"""
TEST_RM64_IMM32: Code = 721 # type: ignore
"""
``TEST r/m64, imm32``

``o64 F7 /0 id``

``X64``

``64-bit``
"""
TEST_RM16_IMM16_F7R1: Code = 722 # type: ignore
"""
``TEST r/m16, imm16``

``o16 F7 /1 iw``

``8086+``

``16/32/64-bit``
"""
TEST_RM32_IMM32_F7R1: Code = 723 # type: ignore
"""
``TEST r/m32, imm32``

``o32 F7 /1 id``

``386+``

``16/32/64-bit``
"""
TEST_RM64_IMM32_F7R1: Code = 724 # type: ignore
"""
``TEST r/m64, imm32``

``o64 F7 /1 id``

``X64``

``64-bit``
"""
NOT_RM16: Code = 725 # type: ignore
"""
``NOT r/m16``

``o16 F7 /2``

``8086+``

``16/32/64-bit``
"""
NOT_RM32: Code = 726 # type: ignore
"""
``NOT r/m32``

``o32 F7 /2``

``386+``

``16/32/64-bit``
"""
NOT_RM64: Code = 727 # type: ignore
"""
``NOT r/m64``

``o64 F7 /2``

``X64``

``64-bit``
"""
NEG_RM16: Code = 728 # type: ignore
"""
``NEG r/m16``

``o16 F7 /3``

``8086+``

``16/32/64-bit``
"""
NEG_RM32: Code = 729 # type: ignore
"""
``NEG r/m32``

``o32 F7 /3``

``386+``

``16/32/64-bit``
"""
NEG_RM64: Code = 730 # type: ignore
"""
``NEG r/m64``

``o64 F7 /3``

``X64``

``64-bit``
"""
MUL_RM16: Code = 731 # type: ignore
"""
``MUL r/m16``

``o16 F7 /4``

``8086+``

``16/32/64-bit``
"""
MUL_RM32: Code = 732 # type: ignore
"""
``MUL r/m32``

``o32 F7 /4``

``386+``

``16/32/64-bit``
"""
MUL_RM64: Code = 733 # type: ignore
"""
``MUL r/m64``

``o64 F7 /4``

``X64``

``64-bit``
"""
IMUL_RM16: Code = 734 # type: ignore
"""
``IMUL r/m16``

``o16 F7 /5``

``8086+``

``16/32/64-bit``
"""
IMUL_RM32: Code = 735 # type: ignore
"""
``IMUL r/m32``

``o32 F7 /5``

``386+``

``16/32/64-bit``
"""
IMUL_RM64: Code = 736 # type: ignore
"""
``IMUL r/m64``

``o64 F7 /5``

``X64``

``64-bit``
"""
DIV_RM16: Code = 737 # type: ignore
"""
``DIV r/m16``

``o16 F7 /6``

``8086+``

``16/32/64-bit``
"""
DIV_RM32: Code = 738 # type: ignore
"""
``DIV r/m32``

``o32 F7 /6``

``386+``

``16/32/64-bit``
"""
DIV_RM64: Code = 739 # type: ignore
"""
``DIV r/m64``

``o64 F7 /6``

``X64``

``64-bit``
"""
IDIV_RM16: Code = 740 # type: ignore
"""
``IDIV r/m16``

``o16 F7 /7``

``8086+``

``16/32/64-bit``
"""
IDIV_RM32: Code = 741 # type: ignore
"""
``IDIV r/m32``

``o32 F7 /7``

``386+``

``16/32/64-bit``
"""
IDIV_RM64: Code = 742 # type: ignore
"""
``IDIV r/m64``

``o64 F7 /7``

``X64``

``64-bit``
"""
CLC: Code = 743 # type: ignore
"""
``CLC``

``F8``

``8086+``

``16/32/64-bit``
"""
STC: Code = 744 # type: ignore
"""
``STC``

``F9``

``8086+``

``16/32/64-bit``
"""
CLI: Code = 745 # type: ignore
"""
``CLI``

``FA``

``8086+``

``16/32/64-bit``
"""
STI: Code = 746 # type: ignore
"""
``STI``

``FB``

``8086+``

``16/32/64-bit``
"""
CLD: Code = 747 # type: ignore
"""
``CLD``

``FC``

``8086+``

``16/32/64-bit``
"""
STD: Code = 748 # type: ignore
"""
``STD``

``FD``

``8086+``

``16/32/64-bit``
"""
INC_RM8: Code = 749 # type: ignore
"""
``INC r/m8``

``FE /0``

``8086+``

``16/32/64-bit``
"""
DEC_RM8: Code = 750 # type: ignore
"""
``DEC r/m8``

``FE /1``

``8086+``

``16/32/64-bit``
"""
INC_RM16: Code = 751 # type: ignore
"""
``INC r/m16``

``o16 FF /0``

``8086+``

``16/32/64-bit``
"""
INC_RM32: Code = 752 # type: ignore
"""
``INC r/m32``

``o32 FF /0``

``386+``

``16/32/64-bit``
"""
INC_RM64: Code = 753 # type: ignore
"""
``INC r/m64``

``o64 FF /0``

``X64``

``64-bit``
"""
DEC_RM16: Code = 754 # type: ignore
"""
``DEC r/m16``

``o16 FF /1``

``8086+``

``16/32/64-bit``
"""
DEC_RM32: Code = 755 # type: ignore
"""
``DEC r/m32``

``o32 FF /1``

``386+``

``16/32/64-bit``
"""
DEC_RM64: Code = 756 # type: ignore
"""
``DEC r/m64``

``o64 FF /1``

``X64``

``64-bit``
"""
CALL_RM16: Code = 757 # type: ignore
"""
``CALL r/m16``

``o16 FF /2``

``8086+``

``16/32/64-bit``
"""
CALL_RM32: Code = 758 # type: ignore
"""
``CALL r/m32``

``o32 FF /2``

``386+``

``16/32-bit``
"""
CALL_RM64: Code = 759 # type: ignore
"""
``CALL r/m64``

``o64 FF /2``

``X64``

``64-bit``
"""
CALL_M1616: Code = 760 # type: ignore
"""
``CALL m16:16``

``o16 FF /3``

``8086+``

``16/32/64-bit``
"""
CALL_M1632: Code = 761 # type: ignore
"""
``CALL m16:32``

``o32 FF /3``

``386+``

``16/32/64-bit``
"""
CALL_M1664: Code = 762 # type: ignore
"""
``CALL m16:64``

``o64 FF /3``

``X64``

``64-bit``
"""
JMP_RM16: Code = 763 # type: ignore
"""
``JMP r/m16``

``o16 FF /4``

``8086+``

``16/32/64-bit``
"""
JMP_RM32: Code = 764 # type: ignore
"""
``JMP r/m32``

``o32 FF /4``

``386+``

``16/32-bit``
"""
JMP_RM64: Code = 765 # type: ignore
"""
``JMP r/m64``

``o64 FF /4``

``X64``

``64-bit``
"""
JMP_M1616: Code = 766 # type: ignore
"""
``JMP m16:16``

``o16 FF /5``

``8086+``

``16/32/64-bit``
"""
JMP_M1632: Code = 767 # type: ignore
"""
``JMP m16:32``

``o32 FF /5``

``386+``

``16/32/64-bit``
"""
JMP_M1664: Code = 768 # type: ignore
"""
``JMP m16:64``

``o64 FF /5``

``X64``

``64-bit``
"""
PUSH_RM16: Code = 769 # type: ignore
"""
``PUSH r/m16``

``o16 FF /6``

``8086+``

``16/32/64-bit``
"""
PUSH_RM32: Code = 770 # type: ignore
"""
``PUSH r/m32``

``o32 FF /6``

``386+``

``16/32-bit``
"""
PUSH_RM64: Code = 771 # type: ignore
"""
``PUSH r/m64``

``o64 FF /6``

``X64``

``64-bit``
"""
SLDT_RM16: Code = 772 # type: ignore
"""
``SLDT r/m16``

``o16 0F 00 /0``

``286+``

``16/32/64-bit``
"""
SLDT_R32M16: Code = 773 # type: ignore
"""
``SLDT r32/m16``

``o32 0F 00 /0``

``386+``

``16/32/64-bit``
"""
SLDT_R64M16: Code = 774 # type: ignore
"""
``SLDT r64/m16``

``o64 0F 00 /0``

``X64``

``64-bit``
"""
STR_RM16: Code = 775 # type: ignore
"""
``STR r/m16``

``o16 0F 00 /1``

``286+``

``16/32/64-bit``
"""
STR_R32M16: Code = 776 # type: ignore
"""
``STR r32/m16``

``o32 0F 00 /1``

``386+``

``16/32/64-bit``
"""
STR_R64M16: Code = 777 # type: ignore
"""
``STR r64/m16``

``o64 0F 00 /1``

``X64``

``64-bit``
"""
LLDT_RM16: Code = 778 # type: ignore
"""
``LLDT r/m16``

``o16 0F 00 /2``

``286+``

``16/32/64-bit``
"""
LLDT_R32M16: Code = 779 # type: ignore
"""
``LLDT r32/m16``

``o32 0F 00 /2``

``386+``

``16/32/64-bit``
"""
LLDT_R64M16: Code = 780 # type: ignore
"""
``LLDT r64/m16``

``o64 0F 00 /2``

``X64``

``64-bit``
"""
LTR_RM16: Code = 781 # type: ignore
"""
``LTR r/m16``

``o16 0F 00 /3``

``286+``

``16/32/64-bit``
"""
LTR_R32M16: Code = 782 # type: ignore
"""
``LTR r32/m16``

``o32 0F 00 /3``

``386+``

``16/32/64-bit``
"""
LTR_R64M16: Code = 783 # type: ignore
"""
``LTR r64/m16``

``o64 0F 00 /3``

``X64``

``64-bit``
"""
VERR_RM16: Code = 784 # type: ignore
"""
``VERR r/m16``

``o16 0F 00 /4``

``286+``

``16/32/64-bit``
"""
VERR_R32M16: Code = 785 # type: ignore
"""
``VERR r32/m16``

``o32 0F 00 /4``

``386+``

``16/32/64-bit``
"""
VERR_R64M16: Code = 786 # type: ignore
"""
``VERR r64/m16``

``o64 0F 00 /4``

``X64``

``64-bit``
"""
VERW_RM16: Code = 787 # type: ignore
"""
``VERW r/m16``

``o16 0F 00 /5``

``286+``

``16/32/64-bit``
"""
VERW_R32M16: Code = 788 # type: ignore
"""
``VERW r32/m16``

``o32 0F 00 /5``

``386+``

``16/32/64-bit``
"""
VERW_R64M16: Code = 789 # type: ignore
"""
``VERW r64/m16``

``o64 0F 00 /5``

``X64``

``64-bit``
"""
JMPE_RM16: Code = 790 # type: ignore
"""
``JMPE r/m16``

``o16 0F 00 /6``

``IA-64``

``16/32-bit``
"""
JMPE_RM32: Code = 791 # type: ignore
"""
``JMPE r/m32``

``o32 0F 00 /6``

``IA-64``

``16/32-bit``
"""
SGDT_M1632_16: Code = 792 # type: ignore
"""
``SGDT m``

``o16 0F 01 /0``

``286+``

``16/32-bit``
"""
SGDT_M1632: Code = 793 # type: ignore
"""
``SGDT m``

``o32 0F 01 /0``

``386+``

``16/32-bit``
"""
SGDT_M1664: Code = 794 # type: ignore
"""
``SGDT m``

``0F 01 /0``

``X64``

``64-bit``
"""
SIDT_M1632_16: Code = 795 # type: ignore
"""
``SIDT m``

``o16 0F 01 /1``

``286+``

``16/32-bit``
"""
SIDT_M1632: Code = 796 # type: ignore
"""
``SIDT m``

``o32 0F 01 /1``

``386+``

``16/32-bit``
"""
SIDT_M1664: Code = 797 # type: ignore
"""
``SIDT m``

``0F 01 /1``

``X64``

``64-bit``
"""
LGDT_M1632_16: Code = 798 # type: ignore
"""
``LGDT m16&32``

``o16 0F 01 /2``

``286+``

``16/32-bit``
"""
LGDT_M1632: Code = 799 # type: ignore
"""
``LGDT m16&32``

``o32 0F 01 /2``

``386+``

``16/32-bit``
"""
LGDT_M1664: Code = 800 # type: ignore
"""
``LGDT m16&64``

``0F 01 /2``

``X64``

``64-bit``
"""
LIDT_M1632_16: Code = 801 # type: ignore
"""
``LIDT m16&32``

``o16 0F 01 /3``

``286+``

``16/32-bit``
"""
LIDT_M1632: Code = 802 # type: ignore
"""
``LIDT m16&32``

``o32 0F 01 /3``

``386+``

``16/32-bit``
"""
LIDT_M1664: Code = 803 # type: ignore
"""
``LIDT m16&64``

``0F 01 /3``

``X64``

``64-bit``
"""
SMSW_RM16: Code = 804 # type: ignore
"""
``SMSW r/m16``

``o16 0F 01 /4``

``286+``

``16/32/64-bit``
"""
SMSW_R32M16: Code = 805 # type: ignore
"""
``SMSW r32/m16``

``o32 0F 01 /4``

``386+``

``16/32/64-bit``
"""
SMSW_R64M16: Code = 806 # type: ignore
"""
``SMSW r64/m16``

``o64 0F 01 /4``

``X64``

``64-bit``
"""
RSTORSSP_M64: Code = 807 # type: ignore
"""
``RSTORSSP m64``

``F3 0F 01 /5``

``CET_SS``

``16/32/64-bit``
"""
LMSW_RM16: Code = 808 # type: ignore
"""
``LMSW r/m16``

``o16 0F 01 /6``

``286+``

``16/32/64-bit``
"""
LMSW_R32M16: Code = 809 # type: ignore
"""
``LMSW r32/m16``

``o32 0F 01 /6``

``386+``

``16/32/64-bit``
"""
LMSW_R64M16: Code = 810 # type: ignore
"""
``LMSW r64/m16``

``o64 0F 01 /6``

``X64``

``64-bit``
"""
INVLPG_M: Code = 811 # type: ignore
"""
``INVLPG m``

``0F 01 /7``

``486+``

``16/32/64-bit``
"""
ENCLV: Code = 812 # type: ignore
"""
``ENCLV``

``NP 0F 01 C0``

``OSS``

``16/32/64-bit``
"""
VMCALL: Code = 813 # type: ignore
"""
``VMCALL``

``NP 0F 01 C1``

``VMX``

``16/32/64-bit``
"""
VMLAUNCH: Code = 814 # type: ignore
"""
``VMLAUNCH``

``NP 0F 01 C2``

``VMX``

``16/32/64-bit``
"""
VMRESUME: Code = 815 # type: ignore
"""
``VMRESUME``

``NP 0F 01 C3``

``VMX``

``16/32/64-bit``
"""
VMXOFF: Code = 816 # type: ignore
"""
``VMXOFF``

``NP 0F 01 C4``

``VMX``

``16/32/64-bit``
"""
PCONFIG: Code = 817 # type: ignore
"""
``PCONFIG``

``NP 0F 01 C5``

``PCONFIG``

``16/32/64-bit``
"""
MONITORW: Code = 818 # type: ignore
"""
``MONITOR``

``a16 NP 0F 01 C8``

``MONITOR``

``16/32-bit``
"""
MONITORD: Code = 819 # type: ignore
"""
``MONITOR``

``a32 NP 0F 01 C8``

``MONITOR``

``16/32/64-bit``
"""
MONITORQ: Code = 820 # type: ignore
"""
``MONITOR``

``a64 NP 0F 01 C8``

``MONITOR``

``64-bit``
"""
MWAIT: Code = 821 # type: ignore
"""
``MWAIT``

``NP 0F 01 C9``

``MONITOR``

``16/32/64-bit``
"""
CLAC: Code = 822 # type: ignore
"""
``CLAC``

``NP 0F 01 CA``

``SMAP``

``16/32/64-bit``
"""
STAC: Code = 823 # type: ignore
"""
``STAC``

``NP 0F 01 CB``

``SMAP``

``16/32/64-bit``
"""
ENCLS: Code = 824 # type: ignore
"""
``ENCLS``

``NP 0F 01 CF``

``SGX1``

``16/32/64-bit``
"""
XGETBV: Code = 825 # type: ignore
"""
``XGETBV``

``NP 0F 01 D0``

``XSAVE``

``16/32/64-bit``
"""
XSETBV: Code = 826 # type: ignore
"""
``XSETBV``

``NP 0F 01 D1``

``XSAVE``

``16/32/64-bit``
"""
VMFUNC: Code = 827 # type: ignore
"""
``VMFUNC``

``NP 0F 01 D4``

``VMX``

``16/32/64-bit``
"""
XEND: Code = 828 # type: ignore
"""
``XEND``

``NP 0F 01 D5``

``RTM``

``16/32/64-bit``
"""
XTEST: Code = 829 # type: ignore
"""
``XTEST``

``NP 0F 01 D6``

``HLE or RTM``

``16/32/64-bit``
"""
ENCLU: Code = 830 # type: ignore
"""
``ENCLU``

``NP 0F 01 D7``

``SGX1``

``16/32/64-bit``
"""
VMRUNW: Code = 831 # type: ignore
"""
``VMRUN``

``a16 0F 01 D8``

``SVM``

``16/32-bit``
"""
VMRUND: Code = 832 # type: ignore
"""
``VMRUN``

``a32 0F 01 D8``

``SVM``

``16/32/64-bit``
"""
VMRUNQ: Code = 833 # type: ignore
"""
``VMRUN``

``a64 0F 01 D8``

``SVM``

``64-bit``
"""
VMMCALL: Code = 834 # type: ignore
"""
``VMMCALL``

``0F 01 D9``

``SVM``

``16/32/64-bit``
"""
VMLOADW: Code = 835 # type: ignore
"""
``VMLOAD``

``a16 0F 01 DA``

``SVM``

``16/32-bit``
"""
VMLOADD: Code = 836 # type: ignore
"""
``VMLOAD``

``a32 0F 01 DA``

``SVM``

``16/32/64-bit``
"""
VMLOADQ: Code = 837 # type: ignore
"""
``VMLOAD``

``a64 0F 01 DA``

``SVM``

``64-bit``
"""
VMSAVEW: Code = 838 # type: ignore
"""
``VMSAVE``

``a16 0F 01 DB``

``SVM``

``16/32-bit``
"""
VMSAVED: Code = 839 # type: ignore
"""
``VMSAVE``

``a32 0F 01 DB``

``SVM``

``16/32/64-bit``
"""
VMSAVEQ: Code = 840 # type: ignore
"""
``VMSAVE``

``a64 0F 01 DB``

``SVM``

``64-bit``
"""
STGI: Code = 841 # type: ignore
"""
``STGI``

``0F 01 DC``

``SKINIT or SVM``

``16/32/64-bit``
"""
CLGI: Code = 842 # type: ignore
"""
``CLGI``

``0F 01 DD``

``SVM``

``16/32/64-bit``
"""
SKINIT: Code = 843 # type: ignore
"""
``SKINIT``

``0F 01 DE``

``SKINIT or SVM``

``16/32/64-bit``
"""
INVLPGAW: Code = 844 # type: ignore
"""
``INVLPGA``

``a16 0F 01 DF``

``SVM``

``16/32-bit``
"""
INVLPGAD: Code = 845 # type: ignore
"""
``INVLPGA``

``a32 0F 01 DF``

``SVM``

``16/32/64-bit``
"""
INVLPGAQ: Code = 846 # type: ignore
"""
``INVLPGA``

``a64 0F 01 DF``

``SVM``

``64-bit``
"""
SETSSBSY: Code = 847 # type: ignore
"""
``SETSSBSY``

``F3 0F 01 E8``

``CET_SS``

``16/32/64-bit``
"""
SAVEPREVSSP: Code = 848 # type: ignore
"""
``SAVEPREVSSP``

``F3 0F 01 EA``

``CET_SS``

``16/32/64-bit``
"""
RDPKRU: Code = 849 # type: ignore
"""
``RDPKRU``

``NP 0F 01 EE``

``PKU``

``16/32/64-bit``
"""
WRPKRU: Code = 850 # type: ignore
"""
``WRPKRU``

``NP 0F 01 EF``

``PKU``

``16/32/64-bit``
"""
SWAPGS: Code = 851 # type: ignore
"""
``SWAPGS``

``0F 01 F8``

``X64``

``64-bit``
"""
RDTSCP: Code = 852 # type: ignore
"""
``RDTSCP``

``0F 01 F9``

``RDTSCP``

``16/32/64-bit``
"""
MONITORXW: Code = 853 # type: ignore
"""
``MONITORX``

``a16 NP 0F 01 FA``

``MONITORX``

``16/32-bit``
"""
MONITORXD: Code = 854 # type: ignore
"""
``MONITORX``

``a32 NP 0F 01 FA``

``MONITORX``

``16/32/64-bit``
"""
MONITORXQ: Code = 855 # type: ignore
"""
``MONITORX``

``a64 NP 0F 01 FA``

``MONITORX``

``64-bit``
"""
MCOMMIT: Code = 856 # type: ignore
"""
``MCOMMIT``

``F3 0F 01 FA``

``MCOMMIT``

``16/32/64-bit``
"""
MWAITX: Code = 857 # type: ignore
"""
``MWAITX``

``NP 0F 01 FB``

``MONITORX``

``16/32/64-bit``
"""
CLZEROW: Code = 858 # type: ignore
"""
``CLZERO``

``a16 0F 01 FC``

``CLZERO``

``16/32-bit``
"""
CLZEROD: Code = 859 # type: ignore
"""
``CLZERO``

``a32 0F 01 FC``

``CLZERO``

``16/32/64-bit``
"""
CLZEROQ: Code = 860 # type: ignore
"""
``CLZERO``

``a64 0F 01 FC``

``CLZERO``

``64-bit``
"""
RDPRU: Code = 861 # type: ignore
"""
``RDPRU``

``NP 0F 01 FD``

``RDPRU``

``16/32/64-bit``
"""
LAR_R16_RM16: Code = 862 # type: ignore
"""
``LAR r16, r/m16``

``o16 0F 02 /r``

``286+``

``16/32/64-bit``
"""
LAR_R32_R32M16: Code = 863 # type: ignore
"""
``LAR r32, r32/m16``

``o32 0F 02 /r``

``386+``

``16/32/64-bit``
"""
LAR_R64_R64M16: Code = 864 # type: ignore
"""
``LAR r64, r64/m16``

``o64 0F 02 /r``

``X64``

``64-bit``
"""
LSL_R16_RM16: Code = 865 # type: ignore
"""
``LSL r16, r/m16``

``o16 0F 03 /r``

``286+``

``16/32/64-bit``
"""
LSL_R32_R32M16: Code = 866 # type: ignore
"""
``LSL r32, r32/m16``

``o32 0F 03 /r``

``386+``

``16/32/64-bit``
"""
LSL_R64_R64M16: Code = 867 # type: ignore
"""
``LSL r64, r64/m16``

``o64 0F 03 /r``

``X64``

``64-bit``
"""
STOREALL: Code = 868 # type: ignore
"""
``STOREALL``

``0F 04``

``286``

``16/32-bit``
"""
LOADALL286: Code = 869 # type: ignore
"""
``LOADALL``

``0F 05``

``286``

``16/32-bit``
"""
SYSCALL: Code = 870 # type: ignore
"""
``SYSCALL``

``0F 05``

``SYSCALL``

``16/32/64-bit``
"""
CLTS: Code = 871 # type: ignore
"""
``CLTS``

``0F 06``

``286+``

``16/32/64-bit``
"""
LOADALL386: Code = 872 # type: ignore
"""
``LOADALL``

``0F 07``

``386``

``16/32-bit``
"""
SYSRETD: Code = 873 # type: ignore
"""
``SYSRET``

``0F 07``

``SYSCALL``

``16/32/64-bit``
"""
SYSRETQ: Code = 874 # type: ignore
"""
``SYSRETQ``

``o64 0F 07``

``SYSCALL``

``64-bit``
"""
INVD: Code = 875 # type: ignore
"""
``INVD``

``0F 08``

``486+``

``16/32/64-bit``
"""
WBINVD: Code = 876 # type: ignore
"""
``WBINVD``

``0F 09``

``486+``

``16/32/64-bit``
"""
WBNOINVD: Code = 877 # type: ignore
"""
``WBNOINVD``

``F3 0F 09``

``WBNOINVD``

``16/32/64-bit``
"""
CL1INVMB: Code = 878 # type: ignore
"""
``CL1INVMB``

``0F 0A``

``CL1INVMB``

``16/32-bit``
"""
UD2: Code = 879 # type: ignore
"""
``UD2``

``0F 0B``

``286+``

``16/32/64-bit``
"""
RESERVEDNOP_RM16_R16_0F0D: Code = 880 # type: ignore
"""
``RESERVEDNOP r/m16, r16``

``o16 0F 0D /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM32_R32_0F0D: Code = 881 # type: ignore
"""
``RESERVEDNOP r/m32, r32``

``o32 0F 0D /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM64_R64_0F0D: Code = 882 # type: ignore
"""
``RESERVEDNOP r/m64, r64``

``o64 0F 0D /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``64-bit``
"""
PREFETCH_M8: Code = 883 # type: ignore
"""
``PREFETCH m8``

``0F 0D /0``

``PREFETCHW``

``16/32/64-bit``
"""
PREFETCHW_M8: Code = 884 # type: ignore
"""
``PREFETCHW m8``

``0F 0D /1``

``PREFETCHW``

``16/32/64-bit``
"""
PREFETCHWT1_M8: Code = 885 # type: ignore
"""
``PREFETCHWT1 m8``

``0F 0D /2``

``PREFETCHWT1``

``16/32/64-bit``
"""
FEMMS: Code = 886 # type: ignore
"""
``FEMMS``

``0F 0E``

``3DNOW``

``16/32/64-bit``
"""
UMOV_RM8_R8: Code = 887 # type: ignore
"""
``UMOV r/m8, r8``

``0F 10 /r``

``386/486``

``16/32-bit``
"""
UMOV_RM16_R16: Code = 888 # type: ignore
"""
``UMOV r/m16, r16``

``o16 0F 11 /r``

``386/486``

``16/32-bit``
"""
UMOV_RM32_R32: Code = 889 # type: ignore
"""
``UMOV r/m32, r32``

``o32 0F 11 /r``

``386/486``

``16/32-bit``
"""
UMOV_R8_RM8: Code = 890 # type: ignore
"""
``UMOV r8, r/m8``

``0F 12 /r``

``386/486``

``16/32-bit``
"""
UMOV_R16_RM16: Code = 891 # type: ignore
"""
``UMOV r16, r/m16``

``o16 0F 13 /r``

``386/486``

``16/32-bit``
"""
UMOV_R32_RM32: Code = 892 # type: ignore
"""
``UMOV r32, r/m32``

``o32 0F 13 /r``

``386/486``

``16/32-bit``
"""
MOVUPS_XMM_XMMM128: Code = 893 # type: ignore
"""
``MOVUPS xmm1, xmm2/m128``

``NP 0F 10 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMOVUPS_XMM_XMMM128: Code = 894 # type: ignore
"""
``VMOVUPS xmm1, xmm2/m128``

``VEX.128.0F.WIG 10 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVUPS_YMM_YMMM256: Code = 895 # type: ignore
"""
``VMOVUPS ymm1, ymm2/m256``

``VEX.256.0F.WIG 10 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVUPS_XMM_K1Z_XMMM128: Code = 896 # type: ignore
"""
``VMOVUPS xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.0F.W0 10 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVUPS_YMM_K1Z_YMMM256: Code = 897 # type: ignore
"""
``VMOVUPS ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.0F.W0 10 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVUPS_ZMM_K1Z_ZMMM512: Code = 898 # type: ignore
"""
``VMOVUPS zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.0F.W0 10 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVUPD_XMM_XMMM128: Code = 899 # type: ignore
"""
``MOVUPD xmm1, xmm2/m128``

``66 0F 10 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVUPD_XMM_XMMM128: Code = 900 # type: ignore
"""
``VMOVUPD xmm1, xmm2/m128``

``VEX.128.66.0F.WIG 10 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVUPD_YMM_YMMM256: Code = 901 # type: ignore
"""
``VMOVUPD ymm1, ymm2/m256``

``VEX.256.66.0F.WIG 10 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVUPD_XMM_K1Z_XMMM128: Code = 902 # type: ignore
"""
``VMOVUPD xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.66.0F.W1 10 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVUPD_YMM_K1Z_YMMM256: Code = 903 # type: ignore
"""
``VMOVUPD ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.66.0F.W1 10 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVUPD_ZMM_K1Z_ZMMM512: Code = 904 # type: ignore
"""
``VMOVUPD zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.66.0F.W1 10 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVSS_XMM_XMMM32: Code = 905 # type: ignore
"""
``MOVSS xmm1, xmm2/m32``

``F3 0F 10 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMOVSS_XMM_XMM_XMM: Code = 906 # type: ignore
"""
``VMOVSS xmm1, xmm2, xmm3``

``VEX.LIG.F3.0F.WIG 10 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVSS_XMM_M32: Code = 907 # type: ignore
"""
``VMOVSS xmm1, m32``

``VEX.LIG.F3.0F.WIG 10 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVSS_XMM_K1Z_XMM_XMM: Code = 908 # type: ignore
"""
``VMOVSS xmm1 {k1}{z}, xmm2, xmm3``

``EVEX.LIG.F3.0F.W0 10 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVSS_XMM_K1Z_M32: Code = 909 # type: ignore
"""
``VMOVSS xmm1 {k1}{z}, m32``

``EVEX.LIG.F3.0F.W0 10 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVSD_XMM_XMMM64: Code = 910 # type: ignore
"""
``MOVSD xmm1, xmm2/m64``

``F2 0F 10 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVSD_XMM_XMM_XMM: Code = 911 # type: ignore
"""
``VMOVSD xmm1, xmm2, xmm3``

``VEX.LIG.F2.0F.WIG 10 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVSD_XMM_M64: Code = 912 # type: ignore
"""
``VMOVSD xmm1, m64``

``VEX.LIG.F2.0F.WIG 10 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVSD_XMM_K1Z_XMM_XMM: Code = 913 # type: ignore
"""
``VMOVSD xmm1 {k1}{z}, xmm2, xmm3``

``EVEX.LIG.F2.0F.W1 10 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVSD_XMM_K1Z_M64: Code = 914 # type: ignore
"""
``VMOVSD xmm1 {k1}{z}, m64``

``EVEX.LIG.F2.0F.W1 10 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVUPS_XMMM128_XMM: Code = 915 # type: ignore
"""
``MOVUPS xmm2/m128, xmm1``

``NP 0F 11 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMOVUPS_XMMM128_XMM: Code = 916 # type: ignore
"""
``VMOVUPS xmm2/m128, xmm1``

``VEX.128.0F.WIG 11 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVUPS_YMMM256_YMM: Code = 917 # type: ignore
"""
``VMOVUPS ymm2/m256, ymm1``

``VEX.256.0F.WIG 11 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVUPS_XMMM128_K1Z_XMM: Code = 918 # type: ignore
"""
``VMOVUPS xmm2/m128 {k1}{z}, xmm1``

``EVEX.128.0F.W0 11 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVUPS_YMMM256_K1Z_YMM: Code = 919 # type: ignore
"""
``VMOVUPS ymm2/m256 {k1}{z}, ymm1``

``EVEX.256.0F.W0 11 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVUPS_ZMMM512_K1Z_ZMM: Code = 920 # type: ignore
"""
``VMOVUPS zmm2/m512 {k1}{z}, zmm1``

``EVEX.512.0F.W0 11 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVUPD_XMMM128_XMM: Code = 921 # type: ignore
"""
``MOVUPD xmm2/m128, xmm1``

``66 0F 11 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVUPD_XMMM128_XMM: Code = 922 # type: ignore
"""
``VMOVUPD xmm2/m128, xmm1``

``VEX.128.66.0F.WIG 11 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVUPD_YMMM256_YMM: Code = 923 # type: ignore
"""
``VMOVUPD ymm2/m256, ymm1``

``VEX.256.66.0F.WIG 11 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVUPD_XMMM128_K1Z_XMM: Code = 924 # type: ignore
"""
``VMOVUPD xmm2/m128 {k1}{z}, xmm1``

``EVEX.128.66.0F.W1 11 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVUPD_YMMM256_K1Z_YMM: Code = 925 # type: ignore
"""
``VMOVUPD ymm2/m256 {k1}{z}, ymm1``

``EVEX.256.66.0F.W1 11 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVUPD_ZMMM512_K1Z_ZMM: Code = 926 # type: ignore
"""
``VMOVUPD zmm2/m512 {k1}{z}, zmm1``

``EVEX.512.66.0F.W1 11 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVSS_XMMM32_XMM: Code = 927 # type: ignore
"""
``MOVSS xmm2/m32, xmm1``

``F3 0F 11 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMOVSS_XMM_XMM_XMM_0F11: Code = 928 # type: ignore
"""
``VMOVSS xmm1, xmm2, xmm3``

``VEX.LIG.F3.0F.WIG 11 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVSS_M32_XMM: Code = 929 # type: ignore
"""
``VMOVSS m32, xmm1``

``VEX.LIG.F3.0F.WIG 11 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVSS_XMM_K1Z_XMM_XMM_0F11: Code = 930 # type: ignore
"""
``VMOVSS xmm1 {k1}{z}, xmm2, xmm3``

``EVEX.LIG.F3.0F.W0 11 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVSS_M32_K1_XMM: Code = 931 # type: ignore
"""
``VMOVSS m32 {k1}, xmm1``

``EVEX.LIG.F3.0F.W0 11 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVSD_XMMM64_XMM: Code = 932 # type: ignore
"""
``MOVSD xmm1/m64, xmm2``

``F2 0F 11 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVSD_XMM_XMM_XMM_0F11: Code = 933 # type: ignore
"""
``VMOVSD xmm1, xmm2, xmm3``

``VEX.LIG.F2.0F.WIG 11 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVSD_M64_XMM: Code = 934 # type: ignore
"""
``VMOVSD m64, xmm1``

``VEX.LIG.F2.0F.WIG 11 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVSD_XMM_K1Z_XMM_XMM_0F11: Code = 935 # type: ignore
"""
``VMOVSD xmm1 {k1}{z}, xmm2, xmm3``

``EVEX.LIG.F2.0F.W1 11 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVSD_M64_K1_XMM: Code = 936 # type: ignore
"""
``VMOVSD m64 {k1}, xmm1``

``EVEX.LIG.F2.0F.W1 11 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVHLPS_XMM_XMM: Code = 937 # type: ignore
"""
``MOVHLPS xmm1, xmm2``

``NP 0F 12 /r``

``SSE``

``16/32/64-bit``
"""
MOVLPS_XMM_M64: Code = 938 # type: ignore
"""
``MOVLPS xmm1, m64``

``NP 0F 12 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMOVHLPS_XMM_XMM_XMM: Code = 939 # type: ignore
"""
``VMOVHLPS xmm1, xmm2, xmm3``

``VEX.128.0F.WIG 12 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVLPS_XMM_XMM_M64: Code = 940 # type: ignore
"""
``VMOVLPS xmm2, xmm1, m64``

``VEX.128.0F.WIG 12 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVHLPS_XMM_XMM_XMM: Code = 941 # type: ignore
"""
``VMOVHLPS xmm1, xmm2, xmm3``

``EVEX.128.0F.W0 12 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVLPS_XMM_XMM_M64: Code = 942 # type: ignore
"""
``VMOVLPS xmm2, xmm1, m64``

``EVEX.128.0F.W0 12 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVLPD_XMM_M64: Code = 943 # type: ignore
"""
``MOVLPD xmm1, m64``

``66 0F 12 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVLPD_XMM_XMM_M64: Code = 944 # type: ignore
"""
``VMOVLPD xmm2, xmm1, m64``

``VEX.128.66.0F.WIG 12 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVLPD_XMM_XMM_M64: Code = 945 # type: ignore
"""
``VMOVLPD xmm2, xmm1, m64``

``EVEX.128.66.0F.W1 12 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVSLDUP_XMM_XMMM128: Code = 946 # type: ignore
"""
``MOVSLDUP xmm1, xmm2/m128``

``F3 0F 12 /r``

``SSE3``

``16/32/64-bit``
"""
VEX_VMOVSLDUP_XMM_XMMM128: Code = 947 # type: ignore
"""
``VMOVSLDUP xmm1, xmm2/m128``

``VEX.128.F3.0F.WIG 12 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVSLDUP_YMM_YMMM256: Code = 948 # type: ignore
"""
``VMOVSLDUP ymm1, ymm2/m256``

``VEX.256.F3.0F.WIG 12 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVSLDUP_XMM_K1Z_XMMM128: Code = 949 # type: ignore
"""
``VMOVSLDUP xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.F3.0F.W0 12 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVSLDUP_YMM_K1Z_YMMM256: Code = 950 # type: ignore
"""
``VMOVSLDUP ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.F3.0F.W0 12 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVSLDUP_ZMM_K1Z_ZMMM512: Code = 951 # type: ignore
"""
``VMOVSLDUP zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.F3.0F.W0 12 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVDDUP_XMM_XMMM64: Code = 952 # type: ignore
"""
``MOVDDUP xmm1, xmm2/m64``

``F2 0F 12 /r``

``SSE3``

``16/32/64-bit``
"""
VEX_VMOVDDUP_XMM_XMMM64: Code = 953 # type: ignore
"""
``VMOVDDUP xmm1, xmm2/m64``

``VEX.128.F2.0F.WIG 12 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVDDUP_YMM_YMMM256: Code = 954 # type: ignore
"""
``VMOVDDUP ymm1, ymm2/m256``

``VEX.256.F2.0F.WIG 12 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVDDUP_XMM_K1Z_XMMM64: Code = 955 # type: ignore
"""
``VMOVDDUP xmm1 {k1}{z}, xmm2/m64``

``EVEX.128.F2.0F.W1 12 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDDUP_YMM_K1Z_YMMM256: Code = 956 # type: ignore
"""
``VMOVDDUP ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.F2.0F.W1 12 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDDUP_ZMM_K1Z_ZMMM512: Code = 957 # type: ignore
"""
``VMOVDDUP zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.F2.0F.W1 12 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVLPS_M64_XMM: Code = 958 # type: ignore
"""
``MOVLPS m64, xmm1``

``NP 0F 13 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMOVLPS_M64_XMM: Code = 959 # type: ignore
"""
``VMOVLPS m64, xmm1``

``VEX.128.0F.WIG 13 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVLPS_M64_XMM: Code = 960 # type: ignore
"""
``VMOVLPS m64, xmm1``

``EVEX.128.0F.W0 13 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVLPD_M64_XMM: Code = 961 # type: ignore
"""
``MOVLPD m64, xmm1``

``66 0F 13 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVLPD_M64_XMM: Code = 962 # type: ignore
"""
``VMOVLPD m64, xmm1``

``VEX.128.66.0F.WIG 13 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVLPD_M64_XMM: Code = 963 # type: ignore
"""
``VMOVLPD m64, xmm1``

``EVEX.128.66.0F.W1 13 /r``

``AVX512F``

``16/32/64-bit``
"""
UNPCKLPS_XMM_XMMM128: Code = 964 # type: ignore
"""
``UNPCKLPS xmm1, xmm2/m128``

``NP 0F 14 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VUNPCKLPS_XMM_XMM_XMMM128: Code = 965 # type: ignore
"""
``VUNPCKLPS xmm1, xmm2, xmm3/m128``

``VEX.128.0F.WIG 14 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VUNPCKLPS_YMM_YMM_YMMM256: Code = 966 # type: ignore
"""
``VUNPCKLPS ymm1, ymm2, ymm3/m256``

``VEX.256.0F.WIG 14 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VUNPCKLPS_XMM_K1Z_XMM_XMMM128B32: Code = 967 # type: ignore
"""
``VUNPCKLPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.0F.W0 14 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VUNPCKLPS_YMM_K1Z_YMM_YMMM256B32: Code = 968 # type: ignore
"""
``VUNPCKLPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.0F.W0 14 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VUNPCKLPS_ZMM_K1Z_ZMM_ZMMM512B32: Code = 969 # type: ignore
"""
``VUNPCKLPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.0F.W0 14 /r``

``AVX512F``

``16/32/64-bit``
"""
UNPCKLPD_XMM_XMMM128: Code = 970 # type: ignore
"""
``UNPCKLPD xmm1, xmm2/m128``

``66 0F 14 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VUNPCKLPD_XMM_XMM_XMMM128: Code = 971 # type: ignore
"""
``VUNPCKLPD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 14 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VUNPCKLPD_YMM_YMM_YMMM256: Code = 972 # type: ignore
"""
``VUNPCKLPD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 14 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VUNPCKLPD_XMM_K1Z_XMM_XMMM128B64: Code = 973 # type: ignore
"""
``VUNPCKLPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 14 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VUNPCKLPD_YMM_K1Z_YMM_YMMM256B64: Code = 974 # type: ignore
"""
``VUNPCKLPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 14 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VUNPCKLPD_ZMM_K1Z_ZMM_ZMMM512B64: Code = 975 # type: ignore
"""
``VUNPCKLPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F.W1 14 /r``

``AVX512F``

``16/32/64-bit``
"""
UNPCKHPS_XMM_XMMM128: Code = 976 # type: ignore
"""
``UNPCKHPS xmm1, xmm2/m128``

``NP 0F 15 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VUNPCKHPS_XMM_XMM_XMMM128: Code = 977 # type: ignore
"""
``VUNPCKHPS xmm1, xmm2, xmm3/m128``

``VEX.128.0F.WIG 15 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VUNPCKHPS_YMM_YMM_YMMM256: Code = 978 # type: ignore
"""
``VUNPCKHPS ymm1, ymm2, ymm3/m256``

``VEX.256.0F.WIG 15 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VUNPCKHPS_XMM_K1Z_XMM_XMMM128B32: Code = 979 # type: ignore
"""
``VUNPCKHPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.0F.W0 15 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VUNPCKHPS_YMM_K1Z_YMM_YMMM256B32: Code = 980 # type: ignore
"""
``VUNPCKHPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.0F.W0 15 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VUNPCKHPS_ZMM_K1Z_ZMM_ZMMM512B32: Code = 981 # type: ignore
"""
``VUNPCKHPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.0F.W0 15 /r``

``AVX512F``

``16/32/64-bit``
"""
UNPCKHPD_XMM_XMMM128: Code = 982 # type: ignore
"""
``UNPCKHPD xmm1, xmm2/m128``

``66 0F 15 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VUNPCKHPD_XMM_XMM_XMMM128: Code = 983 # type: ignore
"""
``VUNPCKHPD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 15 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VUNPCKHPD_YMM_YMM_YMMM256: Code = 984 # type: ignore
"""
``VUNPCKHPD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 15 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VUNPCKHPD_XMM_K1Z_XMM_XMMM128B64: Code = 985 # type: ignore
"""
``VUNPCKHPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 15 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VUNPCKHPD_YMM_K1Z_YMM_YMMM256B64: Code = 986 # type: ignore
"""
``VUNPCKHPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 15 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VUNPCKHPD_ZMM_K1Z_ZMM_ZMMM512B64: Code = 987 # type: ignore
"""
``VUNPCKHPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F.W1 15 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVLHPS_XMM_XMM: Code = 988 # type: ignore
"""
``MOVLHPS xmm1, xmm2``

``NP 0F 16 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMOVLHPS_XMM_XMM_XMM: Code = 989 # type: ignore
"""
``VMOVLHPS xmm1, xmm2, xmm3``

``VEX.128.0F.WIG 16 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVLHPS_XMM_XMM_XMM: Code = 990 # type: ignore
"""
``VMOVLHPS xmm1, xmm2, xmm3``

``EVEX.128.0F.W0 16 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVHPS_XMM_M64: Code = 991 # type: ignore
"""
``MOVHPS xmm1, m64``

``NP 0F 16 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMOVHPS_XMM_XMM_M64: Code = 992 # type: ignore
"""
``VMOVHPS xmm2, xmm1, m64``

``VEX.128.0F.WIG 16 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVHPS_XMM_XMM_M64: Code = 993 # type: ignore
"""
``VMOVHPS xmm2, xmm1, m64``

``EVEX.128.0F.W0 16 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVHPD_XMM_M64: Code = 994 # type: ignore
"""
``MOVHPD xmm1, m64``

``66 0F 16 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVHPD_XMM_XMM_M64: Code = 995 # type: ignore
"""
``VMOVHPD xmm2, xmm1, m64``

``VEX.128.66.0F.WIG 16 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVHPD_XMM_XMM_M64: Code = 996 # type: ignore
"""
``VMOVHPD xmm2, xmm1, m64``

``EVEX.128.66.0F.W1 16 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVSHDUP_XMM_XMMM128: Code = 997 # type: ignore
"""
``MOVSHDUP xmm1, xmm2/m128``

``F3 0F 16 /r``

``SSE3``

``16/32/64-bit``
"""
VEX_VMOVSHDUP_XMM_XMMM128: Code = 998 # type: ignore
"""
``VMOVSHDUP xmm1, xmm2/m128``

``VEX.128.F3.0F.WIG 16 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVSHDUP_YMM_YMMM256: Code = 999 # type: ignore
"""
``VMOVSHDUP ymm1, ymm2/m256``

``VEX.256.F3.0F.WIG 16 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVSHDUP_XMM_K1Z_XMMM128: Code = 1000 # type: ignore
"""
``VMOVSHDUP xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.F3.0F.W0 16 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVSHDUP_YMM_K1Z_YMMM256: Code = 1001 # type: ignore
"""
``VMOVSHDUP ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.F3.0F.W0 16 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVSHDUP_ZMM_K1Z_ZMMM512: Code = 1002 # type: ignore
"""
``VMOVSHDUP zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.F3.0F.W0 16 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVHPS_M64_XMM: Code = 1003 # type: ignore
"""
``MOVHPS m64, xmm1``

``NP 0F 17 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMOVHPS_M64_XMM: Code = 1004 # type: ignore
"""
``VMOVHPS m64, xmm1``

``VEX.128.0F.WIG 17 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVHPS_M64_XMM: Code = 1005 # type: ignore
"""
``VMOVHPS m64, xmm1``

``EVEX.128.0F.W0 17 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVHPD_M64_XMM: Code = 1006 # type: ignore
"""
``MOVHPD m64, xmm1``

``66 0F 17 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVHPD_M64_XMM: Code = 1007 # type: ignore
"""
``VMOVHPD m64, xmm1``

``VEX.128.66.0F.WIG 17 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVHPD_M64_XMM: Code = 1008 # type: ignore
"""
``VMOVHPD m64, xmm1``

``EVEX.128.66.0F.W1 17 /r``

``AVX512F``

``16/32/64-bit``
"""
RESERVEDNOP_RM16_R16_0F18: Code = 1009 # type: ignore
"""
``RESERVEDNOP r/m16, r16``

``o16 0F 18 /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM32_R32_0F18: Code = 1010 # type: ignore
"""
``RESERVEDNOP r/m32, r32``

``o32 0F 18 /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM64_R64_0F18: Code = 1011 # type: ignore
"""
``RESERVEDNOP r/m64, r64``

``o64 0F 18 /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``64-bit``
"""
RESERVEDNOP_RM16_R16_0F19: Code = 1012 # type: ignore
"""
``RESERVEDNOP r/m16, r16``

``o16 0F 19 /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM32_R32_0F19: Code = 1013 # type: ignore
"""
``RESERVEDNOP r/m32, r32``

``o32 0F 19 /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM64_R64_0F19: Code = 1014 # type: ignore
"""
``RESERVEDNOP r/m64, r64``

``o64 0F 19 /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``64-bit``
"""
RESERVEDNOP_RM16_R16_0F1A: Code = 1015 # type: ignore
"""
``RESERVEDNOP r/m16, r16``

``o16 0F 1A /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM32_R32_0F1A: Code = 1016 # type: ignore
"""
``RESERVEDNOP r/m32, r32``

``o32 0F 1A /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM64_R64_0F1A: Code = 1017 # type: ignore
"""
``RESERVEDNOP r/m64, r64``

``o64 0F 1A /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``64-bit``
"""
RESERVEDNOP_RM16_R16_0F1B: Code = 1018 # type: ignore
"""
``RESERVEDNOP r/m16, r16``

``o16 0F 1B /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM32_R32_0F1B: Code = 1019 # type: ignore
"""
``RESERVEDNOP r/m32, r32``

``o32 0F 1B /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM64_R64_0F1B: Code = 1020 # type: ignore
"""
``RESERVEDNOP r/m64, r64``

``o64 0F 1B /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``64-bit``
"""
RESERVEDNOP_RM16_R16_0F1C: Code = 1021 # type: ignore
"""
``RESERVEDNOP r/m16, r16``

``o16 0F 1C /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM32_R32_0F1C: Code = 1022 # type: ignore
"""
``RESERVEDNOP r/m32, r32``

``o32 0F 1C /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM64_R64_0F1C: Code = 1023 # type: ignore
"""
``RESERVEDNOP r/m64, r64``

``o64 0F 1C /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``64-bit``
"""
RESERVEDNOP_RM16_R16_0F1D: Code = 1024 # type: ignore
"""
``RESERVEDNOP r/m16, r16``

``o16 0F 1D /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM32_R32_0F1D: Code = 1025 # type: ignore
"""
``RESERVEDNOP r/m32, r32``

``o32 0F 1D /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM64_R64_0F1D: Code = 1026 # type: ignore
"""
``RESERVEDNOP r/m64, r64``

``o64 0F 1D /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``64-bit``
"""
RESERVEDNOP_RM16_R16_0F1E: Code = 1027 # type: ignore
"""
``RESERVEDNOP r/m16, r16``

``o16 0F 1E /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM32_R32_0F1E: Code = 1028 # type: ignore
"""
``RESERVEDNOP r/m32, r32``

``o32 0F 1E /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM64_R64_0F1E: Code = 1029 # type: ignore
"""
``RESERVEDNOP r/m64, r64``

``o64 0F 1E /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``64-bit``
"""
RESERVEDNOP_RM16_R16_0F1F: Code = 1030 # type: ignore
"""
``RESERVEDNOP r/m16, r16``

``o16 0F 1F /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM32_R32_0F1F: Code = 1031 # type: ignore
"""
``RESERVEDNOP r/m32, r32``

``o32 0F 1F /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
RESERVEDNOP_RM64_R64_0F1F: Code = 1032 # type: ignore
"""
``RESERVEDNOP r/m64, r64``

``o64 0F 1F /r``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``64-bit``
"""
PREFETCHNTA_M8: Code = 1033 # type: ignore
"""
``PREFETCHNTA m8``

``0F 18 /0``

``SSE``

``16/32/64-bit``
"""
PREFETCHT0_M8: Code = 1034 # type: ignore
"""
``PREFETCHT0 m8``

``0F 18 /1``

``SSE``

``16/32/64-bit``
"""
PREFETCHT1_M8: Code = 1035 # type: ignore
"""
``PREFETCHT1 m8``

``0F 18 /2``

``SSE``

``16/32/64-bit``
"""
PREFETCHT2_M8: Code = 1036 # type: ignore
"""
``PREFETCHT2 m8``

``0F 18 /3``

``SSE``

``16/32/64-bit``
"""
BNDLDX_BND_MIB: Code = 1037 # type: ignore
"""
``BNDLDX bnd, mib``

``NP 0F 1A /r``

``MPX``

``16/32/64-bit``
"""
BNDMOV_BND_BNDM64: Code = 1038 # type: ignore
"""
``BNDMOV bnd1, bnd2/m64``

``66 0F 1A /r``

``MPX``

``16/32-bit``
"""
BNDMOV_BND_BNDM128: Code = 1039 # type: ignore
"""
``BNDMOV bnd1, bnd2/m128``

``66 0F 1A /r``

``MPX``

``64-bit``
"""
BNDCL_BND_RM32: Code = 1040 # type: ignore
"""
``BNDCL bnd, r/m32``

``F3 0F 1A /r``

``MPX``

``16/32-bit``
"""
BNDCL_BND_RM64: Code = 1041 # type: ignore
"""
``BNDCL bnd, r/m64``

``F3 0F 1A /r``

``MPX``

``64-bit``
"""
BNDCU_BND_RM32: Code = 1042 # type: ignore
"""
``BNDCU bnd, r/m32``

``F2 0F 1A /r``

``MPX``

``16/32-bit``
"""
BNDCU_BND_RM64: Code = 1043 # type: ignore
"""
``BNDCU bnd, r/m64``

``F2 0F 1A /r``

``MPX``

``64-bit``
"""
BNDSTX_MIB_BND: Code = 1044 # type: ignore
"""
``BNDSTX mib, bnd``

``NP 0F 1B /r``

``MPX``

``16/32/64-bit``
"""
BNDMOV_BNDM64_BND: Code = 1045 # type: ignore
"""
``BNDMOV bnd1/m64, bnd2``

``66 0F 1B /r``

``MPX``

``16/32-bit``
"""
BNDMOV_BNDM128_BND: Code = 1046 # type: ignore
"""
``BNDMOV bnd1/m128, bnd2``

``66 0F 1B /r``

``MPX``

``64-bit``
"""
BNDMK_BND_M32: Code = 1047 # type: ignore
"""
``BNDMK bnd, m32``

``F3 0F 1B /r``

``MPX``

``16/32-bit``
"""
BNDMK_BND_M64: Code = 1048 # type: ignore
"""
``BNDMK bnd, m64``

``F3 0F 1B /r``

``MPX``

``64-bit``
"""
BNDCN_BND_RM32: Code = 1049 # type: ignore
"""
``BNDCN bnd, r/m32``

``F2 0F 1B /r``

``MPX``

``16/32-bit``
"""
BNDCN_BND_RM64: Code = 1050 # type: ignore
"""
``BNDCN bnd, r/m64``

``F2 0F 1B /r``

``MPX``

``64-bit``
"""
CLDEMOTE_M8: Code = 1051 # type: ignore
"""
``CLDEMOTE m8``

``NP 0F 1C /0``

``CLDEMOTE``

``16/32/64-bit``
"""
RDSSPD_R32: Code = 1052 # type: ignore
"""
``RDSSPD r32``

``F3 0F 1E /1``

``CET_SS``

``16/32/64-bit``
"""
RDSSPQ_R64: Code = 1053 # type: ignore
"""
``RDSSPQ r64``

``F3 o64 0F 1E /1``

``CET_SS``

``64-bit``
"""
ENDBR64: Code = 1054 # type: ignore
"""
``ENDBR64``

``F3 0F 1E FA``

``CET_IBT``

``16/32/64-bit``
"""
ENDBR32: Code = 1055 # type: ignore
"""
``ENDBR32``

``F3 0F 1E FB``

``CET_IBT``

``16/32/64-bit``
"""
NOP_RM16: Code = 1056 # type: ignore
"""
``NOP r/m16``

``o16 0F 1F /0``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
NOP_RM32: Code = 1057 # type: ignore
"""
``NOP r/m32``

``o32 0F 1F /0``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``16/32/64-bit``
"""
NOP_RM64: Code = 1058 # type: ignore
"""
``NOP r/m64``

``o64 0F 1F /0``

``CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B``

``64-bit``
"""
MOV_R32_CR: Code = 1059 # type: ignore
"""
``MOV r32, cr``

``0F 20 /r``

``386+``

``16/32-bit``
"""
MOV_R64_CR: Code = 1060 # type: ignore
"""
``MOV r64, cr``

``0F 20 /r``

``X64``

``64-bit``
"""
MOV_R32_DR: Code = 1061 # type: ignore
"""
``MOV r32, dr``

``0F 21 /r``

``386+``

``16/32-bit``
"""
MOV_R64_DR: Code = 1062 # type: ignore
"""
``MOV r64, dr``

``0F 21 /r``

``X64``

``64-bit``
"""
MOV_CR_R32: Code = 1063 # type: ignore
"""
``MOV cr, r32``

``0F 22 /r``

``386+``

``16/32-bit``
"""
MOV_CR_R64: Code = 1064 # type: ignore
"""
``MOV cr, r64``

``0F 22 /r``

``X64``

``64-bit``
"""
MOV_DR_R32: Code = 1065 # type: ignore
"""
``MOV dr, r32``

``0F 23 /r``

``386+``

``16/32-bit``
"""
MOV_DR_R64: Code = 1066 # type: ignore
"""
``MOV dr, r64``

``0F 23 /r``

``X64``

``64-bit``
"""
MOV_R32_TR: Code = 1067 # type: ignore
"""
``MOV r32, tr``

``0F 24 /r``

``386/486/Cyrix/Geode``

``16/32-bit``
"""
MOV_TR_R32: Code = 1068 # type: ignore
"""
``MOV tr, r32``

``0F 26 /r``

``386/486/Cyrix/Geode``

``16/32-bit``
"""
MOVAPS_XMM_XMMM128: Code = 1069 # type: ignore
"""
``MOVAPS xmm1, xmm2/m128``

``NP 0F 28 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMOVAPS_XMM_XMMM128: Code = 1070 # type: ignore
"""
``VMOVAPS xmm1, xmm2/m128``

``VEX.128.0F.WIG 28 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVAPS_YMM_YMMM256: Code = 1071 # type: ignore
"""
``VMOVAPS ymm1, ymm2/m256``

``VEX.256.0F.WIG 28 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVAPS_XMM_K1Z_XMMM128: Code = 1072 # type: ignore
"""
``VMOVAPS xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.0F.W0 28 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVAPS_YMM_K1Z_YMMM256: Code = 1073 # type: ignore
"""
``VMOVAPS ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.0F.W0 28 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVAPS_ZMM_K1Z_ZMMM512: Code = 1074 # type: ignore
"""
``VMOVAPS zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.0F.W0 28 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVAPD_XMM_XMMM128: Code = 1075 # type: ignore
"""
``MOVAPD xmm1, xmm2/m128``

``66 0F 28 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVAPD_XMM_XMMM128: Code = 1076 # type: ignore
"""
``VMOVAPD xmm1, xmm2/m128``

``VEX.128.66.0F.WIG 28 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVAPD_YMM_YMMM256: Code = 1077 # type: ignore
"""
``VMOVAPD ymm1, ymm2/m256``

``VEX.256.66.0F.WIG 28 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVAPD_XMM_K1Z_XMMM128: Code = 1078 # type: ignore
"""
``VMOVAPD xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.66.0F.W1 28 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVAPD_YMM_K1Z_YMMM256: Code = 1079 # type: ignore
"""
``VMOVAPD ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.66.0F.W1 28 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVAPD_ZMM_K1Z_ZMMM512: Code = 1080 # type: ignore
"""
``VMOVAPD zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.66.0F.W1 28 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVAPS_XMMM128_XMM: Code = 1081 # type: ignore
"""
``MOVAPS xmm2/m128, xmm1``

``NP 0F 29 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMOVAPS_XMMM128_XMM: Code = 1082 # type: ignore
"""
``VMOVAPS xmm2/m128, xmm1``

``VEX.128.0F.WIG 29 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVAPS_YMMM256_YMM: Code = 1083 # type: ignore
"""
``VMOVAPS ymm2/m256, ymm1``

``VEX.256.0F.WIG 29 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVAPS_XMMM128_K1Z_XMM: Code = 1084 # type: ignore
"""
``VMOVAPS xmm2/m128 {k1}{z}, xmm1``

``EVEX.128.0F.W0 29 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVAPS_YMMM256_K1Z_YMM: Code = 1085 # type: ignore
"""
``VMOVAPS ymm2/m256 {k1}{z}, ymm1``

``EVEX.256.0F.W0 29 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVAPS_ZMMM512_K1Z_ZMM: Code = 1086 # type: ignore
"""
``VMOVAPS zmm2/m512 {k1}{z}, zmm1``

``EVEX.512.0F.W0 29 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVAPD_XMMM128_XMM: Code = 1087 # type: ignore
"""
``MOVAPD xmm2/m128, xmm1``

``66 0F 29 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVAPD_XMMM128_XMM: Code = 1088 # type: ignore
"""
``VMOVAPD xmm2/m128, xmm1``

``VEX.128.66.0F.WIG 29 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVAPD_YMMM256_YMM: Code = 1089 # type: ignore
"""
``VMOVAPD ymm2/m256, ymm1``

``VEX.256.66.0F.WIG 29 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVAPD_XMMM128_K1Z_XMM: Code = 1090 # type: ignore
"""
``VMOVAPD xmm2/m128 {k1}{z}, xmm1``

``EVEX.128.66.0F.W1 29 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVAPD_YMMM256_K1Z_YMM: Code = 1091 # type: ignore
"""
``VMOVAPD ymm2/m256 {k1}{z}, ymm1``

``EVEX.256.66.0F.W1 29 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVAPD_ZMMM512_K1Z_ZMM: Code = 1092 # type: ignore
"""
``VMOVAPD zmm2/m512 {k1}{z}, zmm1``

``EVEX.512.66.0F.W1 29 /r``

``AVX512F``

``16/32/64-bit``
"""
CVTPI2PS_XMM_MMM64: Code = 1093 # type: ignore
"""
``CVTPI2PS xmm, mm/m64``

``NP 0F 2A /r``

``SSE``

``16/32/64-bit``
"""
CVTPI2PD_XMM_MMM64: Code = 1094 # type: ignore
"""
``CVTPI2PD xmm, mm/m64``

``66 0F 2A /r``

``SSE2``

``16/32/64-bit``
"""
CVTSI2SS_XMM_RM32: Code = 1095 # type: ignore
"""
``CVTSI2SS xmm1, r/m32``

``F3 0F 2A /r``

``SSE``

``16/32/64-bit``
"""
CVTSI2SS_XMM_RM64: Code = 1096 # type: ignore
"""
``CVTSI2SS xmm1, r/m64``

``F3 o64 0F 2A /r``

``SSE``

``64-bit``
"""
VEX_VCVTSI2SS_XMM_XMM_RM32: Code = 1097 # type: ignore
"""
``VCVTSI2SS xmm1, xmm2, r/m32``

``VEX.LIG.F3.0F.W0 2A /r``

``AVX``

``16/32/64-bit``
"""
VEX_VCVTSI2SS_XMM_XMM_RM64: Code = 1098 # type: ignore
"""
``VCVTSI2SS xmm1, xmm2, r/m64``

``VEX.LIG.F3.0F.W1 2A /r``

``AVX``

``64-bit``
"""
EVEX_VCVTSI2SS_XMM_XMM_RM32_ER: Code = 1099 # type: ignore
"""
``VCVTSI2SS xmm1, xmm2, r/m32{er}``

``EVEX.LIG.F3.0F.W0 2A /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTSI2SS_XMM_XMM_RM64_ER: Code = 1100 # type: ignore
"""
``VCVTSI2SS xmm1, xmm2, r/m64{er}``

``EVEX.LIG.F3.0F.W1 2A /r``

``AVX512F``

``64-bit``
"""
CVTSI2SD_XMM_RM32: Code = 1101 # type: ignore
"""
``CVTSI2SD xmm1, r/m32``

``F2 0F 2A /r``

``SSE2``

``16/32/64-bit``
"""
CVTSI2SD_XMM_RM64: Code = 1102 # type: ignore
"""
``CVTSI2SD xmm1, r/m64``

``F2 o64 0F 2A /r``

``SSE2``

``64-bit``
"""
VEX_VCVTSI2SD_XMM_XMM_RM32: Code = 1103 # type: ignore
"""
``VCVTSI2SD xmm1, xmm2, r/m32``

``VEX.LIG.F2.0F.W0 2A /r``

``AVX``

``16/32/64-bit``
"""
VEX_VCVTSI2SD_XMM_XMM_RM64: Code = 1104 # type: ignore
"""
``VCVTSI2SD xmm1, xmm2, r/m64``

``VEX.LIG.F2.0F.W1 2A /r``

``AVX``

``64-bit``
"""
EVEX_VCVTSI2SD_XMM_XMM_RM32_ER: Code = 1105 # type: ignore
"""
``VCVTSI2SD xmm1, xmm2, r/m32{er}``

``EVEX.LIG.F2.0F.W0 2A /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTSI2SD_XMM_XMM_RM64_ER: Code = 1106 # type: ignore
"""
``VCVTSI2SD xmm1, xmm2, r/m64{er}``

``EVEX.LIG.F2.0F.W1 2A /r``

``AVX512F``

``64-bit``
"""
MOVNTPS_M128_XMM: Code = 1107 # type: ignore
"""
``MOVNTPS m128, xmm1``

``NP 0F 2B /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMOVNTPS_M128_XMM: Code = 1108 # type: ignore
"""
``VMOVNTPS m128, xmm1``

``VEX.128.0F.WIG 2B /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVNTPS_M256_YMM: Code = 1109 # type: ignore
"""
``VMOVNTPS m256, ymm1``

``VEX.256.0F.WIG 2B /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVNTPS_M128_XMM: Code = 1110 # type: ignore
"""
``VMOVNTPS m128, xmm1``

``EVEX.128.0F.W0 2B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVNTPS_M256_YMM: Code = 1111 # type: ignore
"""
``VMOVNTPS m256, ymm1``

``EVEX.256.0F.W0 2B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVNTPS_M512_ZMM: Code = 1112 # type: ignore
"""
``VMOVNTPS m512, zmm1``

``EVEX.512.0F.W0 2B /r``

``AVX512F``

``16/32/64-bit``
"""
MOVNTPD_M128_XMM: Code = 1113 # type: ignore
"""
``MOVNTPD m128, xmm1``

``66 0F 2B /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVNTPD_M128_XMM: Code = 1114 # type: ignore
"""
``VMOVNTPD m128, xmm1``

``VEX.128.66.0F.WIG 2B /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVNTPD_M256_YMM: Code = 1115 # type: ignore
"""
``VMOVNTPD m256, ymm1``

``VEX.256.66.0F.WIG 2B /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVNTPD_M128_XMM: Code = 1116 # type: ignore
"""
``VMOVNTPD m128, xmm1``

``EVEX.128.66.0F.W1 2B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVNTPD_M256_YMM: Code = 1117 # type: ignore
"""
``VMOVNTPD m256, ymm1``

``EVEX.256.66.0F.W1 2B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVNTPD_M512_ZMM: Code = 1118 # type: ignore
"""
``VMOVNTPD m512, zmm1``

``EVEX.512.66.0F.W1 2B /r``

``AVX512F``

``16/32/64-bit``
"""
MOVNTSS_M32_XMM: Code = 1119 # type: ignore
"""
``MOVNTSS m32, xmm1``

``F3 0F 2B /r``

``SSE4A``

``16/32/64-bit``
"""
MOVNTSD_M64_XMM: Code = 1120 # type: ignore
"""
``MOVNTSD m64, xmm1``

``F2 0F 2B /r``

``SSE4A``

``16/32/64-bit``
"""
CVTTPS2PI_MM_XMMM64: Code = 1121 # type: ignore
"""
``CVTTPS2PI mm, xmm/m64``

``NP 0F 2C /r``

``SSE``

``16/32/64-bit``
"""
CVTTPD2PI_MM_XMMM128: Code = 1122 # type: ignore
"""
``CVTTPD2PI mm, xmm/m128``

``66 0F 2C /r``

``SSE2``

``16/32/64-bit``
"""
CVTTSS2SI_R32_XMMM32: Code = 1123 # type: ignore
"""
``CVTTSS2SI r32, xmm1/m32``

``F3 0F 2C /r``

``SSE``

``16/32/64-bit``
"""
CVTTSS2SI_R64_XMMM32: Code = 1124 # type: ignore
"""
``CVTTSS2SI r64, xmm1/m32``

``F3 o64 0F 2C /r``

``SSE``

``64-bit``
"""
VEX_VCVTTSS2SI_R32_XMMM32: Code = 1125 # type: ignore
"""
``VCVTTSS2SI r32, xmm1/m32``

``VEX.LIG.F3.0F.W0 2C /r``

``AVX``

``16/32/64-bit``
"""
VEX_VCVTTSS2SI_R64_XMMM32: Code = 1126 # type: ignore
"""
``VCVTTSS2SI r64, xmm1/m32``

``VEX.LIG.F3.0F.W1 2C /r``

``AVX``

``64-bit``
"""
EVEX_VCVTTSS2SI_R32_XMMM32_SAE: Code = 1127 # type: ignore
"""
``VCVTTSS2SI r32, xmm1/m32{sae}``

``EVEX.LIG.F3.0F.W0 2C /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTTSS2SI_R64_XMMM32_SAE: Code = 1128 # type: ignore
"""
``VCVTTSS2SI r64, xmm1/m32{sae}``

``EVEX.LIG.F3.0F.W1 2C /r``

``AVX512F``

``64-bit``
"""
CVTTSD2SI_R32_XMMM64: Code = 1129 # type: ignore
"""
``CVTTSD2SI r32, xmm1/m64``

``F2 0F 2C /r``

``SSE2``

``16/32/64-bit``
"""
CVTTSD2SI_R64_XMMM64: Code = 1130 # type: ignore
"""
``CVTTSD2SI r64, xmm1/m64``

``F2 o64 0F 2C /r``

``SSE2``

``64-bit``
"""
VEX_VCVTTSD2SI_R32_XMMM64: Code = 1131 # type: ignore
"""
``VCVTTSD2SI r32, xmm1/m64``

``VEX.LIG.F2.0F.W0 2C /r``

``AVX``

``16/32/64-bit``
"""
VEX_VCVTTSD2SI_R64_XMMM64: Code = 1132 # type: ignore
"""
``VCVTTSD2SI r64, xmm1/m64``

``VEX.LIG.F2.0F.W1 2C /r``

``AVX``

``64-bit``
"""
EVEX_VCVTTSD2SI_R32_XMMM64_SAE: Code = 1133 # type: ignore
"""
``VCVTTSD2SI r32, xmm1/m64{sae}``

``EVEX.LIG.F2.0F.W0 2C /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTTSD2SI_R64_XMMM64_SAE: Code = 1134 # type: ignore
"""
``VCVTTSD2SI r64, xmm1/m64{sae}``

``EVEX.LIG.F2.0F.W1 2C /r``

``AVX512F``

``64-bit``
"""
CVTPS2PI_MM_XMMM64: Code = 1135 # type: ignore
"""
``CVTPS2PI mm, xmm/m64``

``NP 0F 2D /r``

``SSE``

``16/32/64-bit``
"""
CVTPD2PI_MM_XMMM128: Code = 1136 # type: ignore
"""
``CVTPD2PI mm, xmm/m128``

``66 0F 2D /r``

``SSE2``

``16/32/64-bit``
"""
CVTSS2SI_R32_XMMM32: Code = 1137 # type: ignore
"""
``CVTSS2SI r32, xmm1/m32``

``F3 0F 2D /r``

``SSE``

``16/32/64-bit``
"""
CVTSS2SI_R64_XMMM32: Code = 1138 # type: ignore
"""
``CVTSS2SI r64, xmm1/m32``

``F3 o64 0F 2D /r``

``SSE``

``64-bit``
"""
VEX_VCVTSS2SI_R32_XMMM32: Code = 1139 # type: ignore
"""
``VCVTSS2SI r32, xmm1/m32``

``VEX.LIG.F3.0F.W0 2D /r``

``AVX``

``16/32/64-bit``
"""
VEX_VCVTSS2SI_R64_XMMM32: Code = 1140 # type: ignore
"""
``VCVTSS2SI r64, xmm1/m32``

``VEX.LIG.F3.0F.W1 2D /r``

``AVX``

``64-bit``
"""
EVEX_VCVTSS2SI_R32_XMMM32_ER: Code = 1141 # type: ignore
"""
``VCVTSS2SI r32, xmm1/m32{er}``

``EVEX.LIG.F3.0F.W0 2D /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTSS2SI_R64_XMMM32_ER: Code = 1142 # type: ignore
"""
``VCVTSS2SI r64, xmm1/m32{er}``

``EVEX.LIG.F3.0F.W1 2D /r``

``AVX512F``

``64-bit``
"""
CVTSD2SI_R32_XMMM64: Code = 1143 # type: ignore
"""
``CVTSD2SI r32, xmm1/m64``

``F2 0F 2D /r``

``SSE2``

``16/32/64-bit``
"""
CVTSD2SI_R64_XMMM64: Code = 1144 # type: ignore
"""
``CVTSD2SI r64, xmm1/m64``

``F2 o64 0F 2D /r``

``SSE2``

``64-bit``
"""
VEX_VCVTSD2SI_R32_XMMM64: Code = 1145 # type: ignore
"""
``VCVTSD2SI r32, xmm1/m64``

``VEX.LIG.F2.0F.W0 2D /r``

``AVX``

``16/32/64-bit``
"""
VEX_VCVTSD2SI_R64_XMMM64: Code = 1146 # type: ignore
"""
``VCVTSD2SI r64, xmm1/m64``

``VEX.LIG.F2.0F.W1 2D /r``

``AVX``

``64-bit``
"""
EVEX_VCVTSD2SI_R32_XMMM64_ER: Code = 1147 # type: ignore
"""
``VCVTSD2SI r32, xmm1/m64{er}``

``EVEX.LIG.F2.0F.W0 2D /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTSD2SI_R64_XMMM64_ER: Code = 1148 # type: ignore
"""
``VCVTSD2SI r64, xmm1/m64{er}``

``EVEX.LIG.F2.0F.W1 2D /r``

``AVX512F``

``64-bit``
"""
UCOMISS_XMM_XMMM32: Code = 1149 # type: ignore
"""
``UCOMISS xmm1, xmm2/m32``

``NP 0F 2E /r``

``SSE``

``16/32/64-bit``
"""
VEX_VUCOMISS_XMM_XMMM32: Code = 1150 # type: ignore
"""
``VUCOMISS xmm1, xmm2/m32``

``VEX.LIG.0F.WIG 2E /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VUCOMISS_XMM_XMMM32_SAE: Code = 1151 # type: ignore
"""
``VUCOMISS xmm1, xmm2/m32{sae}``

``EVEX.LIG.0F.W0 2E /r``

``AVX512F``

``16/32/64-bit``
"""
UCOMISD_XMM_XMMM64: Code = 1152 # type: ignore
"""
``UCOMISD xmm1, xmm2/m64``

``66 0F 2E /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VUCOMISD_XMM_XMMM64: Code = 1153 # type: ignore
"""
``VUCOMISD xmm1, xmm2/m64``

``VEX.LIG.66.0F.WIG 2E /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VUCOMISD_XMM_XMMM64_SAE: Code = 1154 # type: ignore
"""
``VUCOMISD xmm1, xmm2/m64{sae}``

``EVEX.LIG.66.0F.W1 2E /r``

``AVX512F``

``16/32/64-bit``
"""
COMISS_XMM_XMMM32: Code = 1155 # type: ignore
"""
``COMISS xmm1, xmm2/m32``

``NP 0F 2F /r``

``SSE``

``16/32/64-bit``
"""
COMISD_XMM_XMMM64: Code = 1156 # type: ignore
"""
``COMISD xmm1, xmm2/m64``

``66 0F 2F /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VCOMISS_XMM_XMMM32: Code = 1157 # type: ignore
"""
``VCOMISS xmm1, xmm2/m32``

``VEX.LIG.0F.WIG 2F /r``

``AVX``

``16/32/64-bit``
"""
VEX_VCOMISD_XMM_XMMM64: Code = 1158 # type: ignore
"""
``VCOMISD xmm1, xmm2/m64``

``VEX.LIG.66.0F.WIG 2F /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VCOMISS_XMM_XMMM32_SAE: Code = 1159 # type: ignore
"""
``VCOMISS xmm1, xmm2/m32{sae}``

``EVEX.LIG.0F.W0 2F /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCOMISD_XMM_XMMM64_SAE: Code = 1160 # type: ignore
"""
``VCOMISD xmm1, xmm2/m64{sae}``

``EVEX.LIG.66.0F.W1 2F /r``

``AVX512F``

``16/32/64-bit``
"""
WRMSR: Code = 1161 # type: ignore
"""
``WRMSR``

``0F 30``

``MSR``

``16/32/64-bit``
"""
RDTSC: Code = 1162 # type: ignore
"""
``RDTSC``

``0F 31``

``TSC``

``16/32/64-bit``
"""
RDMSR: Code = 1163 # type: ignore
"""
``RDMSR``

``0F 32``

``MSR``

``16/32/64-bit``
"""
RDPMC: Code = 1164 # type: ignore
"""
``RDPMC``

``0F 33``

``Pentium MMX or later, or Pentium Pro or later``

``16/32/64-bit``
"""
SYSENTER: Code = 1165 # type: ignore
"""
``SYSENTER``

``0F 34``

``SEP``

``16/32/64-bit``
"""
SYSEXITD: Code = 1166 # type: ignore
"""
``SYSEXIT``

``0F 35``

``SEP``

``16/32/64-bit``
"""
SYSEXITQ: Code = 1167 # type: ignore
"""
``SYSEXITQ``

``o64 0F 35``

``SEP``

``64-bit``
"""
GETSECD: Code = 1168 # type: ignore
"""
``GETSEC``

``NP 0F 37``

``SMX``

``16/32/64-bit``
"""
CMOVO_R16_RM16: Code = 1169 # type: ignore
"""
``CMOVO r16, r/m16``

``o16 0F 40 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVO_R32_RM32: Code = 1170 # type: ignore
"""
``CMOVO r32, r/m32``

``o32 0F 40 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVO_R64_RM64: Code = 1171 # type: ignore
"""
``CMOVO r64, r/m64``

``o64 0F 40 /r``

``CMOV``

``64-bit``
"""
CMOVNO_R16_RM16: Code = 1172 # type: ignore
"""
``CMOVNO r16, r/m16``

``o16 0F 41 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVNO_R32_RM32: Code = 1173 # type: ignore
"""
``CMOVNO r32, r/m32``

``o32 0F 41 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVNO_R64_RM64: Code = 1174 # type: ignore
"""
``CMOVNO r64, r/m64``

``o64 0F 41 /r``

``CMOV``

``64-bit``
"""
CMOVB_R16_RM16: Code = 1175 # type: ignore
"""
``CMOVB r16, r/m16``

``o16 0F 42 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVB_R32_RM32: Code = 1176 # type: ignore
"""
``CMOVB r32, r/m32``

``o32 0F 42 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVB_R64_RM64: Code = 1177 # type: ignore
"""
``CMOVB r64, r/m64``

``o64 0F 42 /r``

``CMOV``

``64-bit``
"""
CMOVAE_R16_RM16: Code = 1178 # type: ignore
"""
``CMOVAE r16, r/m16``

``o16 0F 43 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVAE_R32_RM32: Code = 1179 # type: ignore
"""
``CMOVAE r32, r/m32``

``o32 0F 43 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVAE_R64_RM64: Code = 1180 # type: ignore
"""
``CMOVAE r64, r/m64``

``o64 0F 43 /r``

``CMOV``

``64-bit``
"""
CMOVE_R16_RM16: Code = 1181 # type: ignore
"""
``CMOVE r16, r/m16``

``o16 0F 44 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVE_R32_RM32: Code = 1182 # type: ignore
"""
``CMOVE r32, r/m32``

``o32 0F 44 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVE_R64_RM64: Code = 1183 # type: ignore
"""
``CMOVE r64, r/m64``

``o64 0F 44 /r``

``CMOV``

``64-bit``
"""
CMOVNE_R16_RM16: Code = 1184 # type: ignore
"""
``CMOVNE r16, r/m16``

``o16 0F 45 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVNE_R32_RM32: Code = 1185 # type: ignore
"""
``CMOVNE r32, r/m32``

``o32 0F 45 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVNE_R64_RM64: Code = 1186 # type: ignore
"""
``CMOVNE r64, r/m64``

``o64 0F 45 /r``

``CMOV``

``64-bit``
"""
CMOVBE_R16_RM16: Code = 1187 # type: ignore
"""
``CMOVBE r16, r/m16``

``o16 0F 46 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVBE_R32_RM32: Code = 1188 # type: ignore
"""
``CMOVBE r32, r/m32``

``o32 0F 46 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVBE_R64_RM64: Code = 1189 # type: ignore
"""
``CMOVBE r64, r/m64``

``o64 0F 46 /r``

``CMOV``

``64-bit``
"""
CMOVA_R16_RM16: Code = 1190 # type: ignore
"""
``CMOVA r16, r/m16``

``o16 0F 47 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVA_R32_RM32: Code = 1191 # type: ignore
"""
``CMOVA r32, r/m32``

``o32 0F 47 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVA_R64_RM64: Code = 1192 # type: ignore
"""
``CMOVA r64, r/m64``

``o64 0F 47 /r``

``CMOV``

``64-bit``
"""
CMOVS_R16_RM16: Code = 1193 # type: ignore
"""
``CMOVS r16, r/m16``

``o16 0F 48 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVS_R32_RM32: Code = 1194 # type: ignore
"""
``CMOVS r32, r/m32``

``o32 0F 48 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVS_R64_RM64: Code = 1195 # type: ignore
"""
``CMOVS r64, r/m64``

``o64 0F 48 /r``

``CMOV``

``64-bit``
"""
CMOVNS_R16_RM16: Code = 1196 # type: ignore
"""
``CMOVNS r16, r/m16``

``o16 0F 49 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVNS_R32_RM32: Code = 1197 # type: ignore
"""
``CMOVNS r32, r/m32``

``o32 0F 49 /r``

``CMOV``

``16/32/64-bit``
"""
CMOVNS_R64_RM64: Code = 1198 # type: ignore
"""
``CMOVNS r64, r/m64``

``o64 0F 49 /r``

``CMOV``

``64-bit``
"""
CMOVP_R16_RM16: Code = 1199 # type: ignore
"""
``CMOVP r16, r/m16``

``o16 0F 4A /r``

``CMOV``

``16/32/64-bit``
"""
CMOVP_R32_RM32: Code = 1200 # type: ignore
"""
``CMOVP r32, r/m32``

``o32 0F 4A /r``

``CMOV``

``16/32/64-bit``
"""
CMOVP_R64_RM64: Code = 1201 # type: ignore
"""
``CMOVP r64, r/m64``

``o64 0F 4A /r``

``CMOV``

``64-bit``
"""
CMOVNP_R16_RM16: Code = 1202 # type: ignore
"""
``CMOVNP r16, r/m16``

``o16 0F 4B /r``

``CMOV``

``16/32/64-bit``
"""
CMOVNP_R32_RM32: Code = 1203 # type: ignore
"""
``CMOVNP r32, r/m32``

``o32 0F 4B /r``

``CMOV``

``16/32/64-bit``
"""
CMOVNP_R64_RM64: Code = 1204 # type: ignore
"""
``CMOVNP r64, r/m64``

``o64 0F 4B /r``

``CMOV``

``64-bit``
"""
CMOVL_R16_RM16: Code = 1205 # type: ignore
"""
``CMOVL r16, r/m16``

``o16 0F 4C /r``

``CMOV``

``16/32/64-bit``
"""
CMOVL_R32_RM32: Code = 1206 # type: ignore
"""
``CMOVL r32, r/m32``

``o32 0F 4C /r``

``CMOV``

``16/32/64-bit``
"""
CMOVL_R64_RM64: Code = 1207 # type: ignore
"""
``CMOVL r64, r/m64``

``o64 0F 4C /r``

``CMOV``

``64-bit``
"""
CMOVGE_R16_RM16: Code = 1208 # type: ignore
"""
``CMOVGE r16, r/m16``

``o16 0F 4D /r``

``CMOV``

``16/32/64-bit``
"""
CMOVGE_R32_RM32: Code = 1209 # type: ignore
"""
``CMOVGE r32, r/m32``

``o32 0F 4D /r``

``CMOV``

``16/32/64-bit``
"""
CMOVGE_R64_RM64: Code = 1210 # type: ignore
"""
``CMOVGE r64, r/m64``

``o64 0F 4D /r``

``CMOV``

``64-bit``
"""
CMOVLE_R16_RM16: Code = 1211 # type: ignore
"""
``CMOVLE r16, r/m16``

``o16 0F 4E /r``

``CMOV``

``16/32/64-bit``
"""
CMOVLE_R32_RM32: Code = 1212 # type: ignore
"""
``CMOVLE r32, r/m32``

``o32 0F 4E /r``

``CMOV``

``16/32/64-bit``
"""
CMOVLE_R64_RM64: Code = 1213 # type: ignore
"""
``CMOVLE r64, r/m64``

``o64 0F 4E /r``

``CMOV``

``64-bit``
"""
CMOVG_R16_RM16: Code = 1214 # type: ignore
"""
``CMOVG r16, r/m16``

``o16 0F 4F /r``

``CMOV``

``16/32/64-bit``
"""
CMOVG_R32_RM32: Code = 1215 # type: ignore
"""
``CMOVG r32, r/m32``

``o32 0F 4F /r``

``CMOV``

``16/32/64-bit``
"""
CMOVG_R64_RM64: Code = 1216 # type: ignore
"""
``CMOVG r64, r/m64``

``o64 0F 4F /r``

``CMOV``

``64-bit``
"""
VEX_KANDW_KR_KR_KR: Code = 1217 # type: ignore
"""
``KANDW k1, k2, k3``

``VEX.L1.0F.W0 41 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_KANDQ_KR_KR_KR: Code = 1218 # type: ignore
"""
``KANDQ k1, k2, k3``

``VEX.L1.0F.W1 41 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KANDB_KR_KR_KR: Code = 1219 # type: ignore
"""
``KANDB k1, k2, k3``

``VEX.L1.66.0F.W0 41 /r``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_KANDD_KR_KR_KR: Code = 1220 # type: ignore
"""
``KANDD k1, k2, k3``

``VEX.L1.66.0F.W1 41 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KANDNW_KR_KR_KR: Code = 1221 # type: ignore
"""
``KANDNW k1, k2, k3``

``VEX.L1.0F.W0 42 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_KANDNQ_KR_KR_KR: Code = 1222 # type: ignore
"""
``KANDNQ k1, k2, k3``

``VEX.L1.0F.W1 42 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KANDNB_KR_KR_KR: Code = 1223 # type: ignore
"""
``KANDNB k1, k2, k3``

``VEX.L1.66.0F.W0 42 /r``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_KANDND_KR_KR_KR: Code = 1224 # type: ignore
"""
``KANDND k1, k2, k3``

``VEX.L1.66.0F.W1 42 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KNOTW_KR_KR: Code = 1225 # type: ignore
"""
``KNOTW k1, k2``

``VEX.L0.0F.W0 44 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_KNOTQ_KR_KR: Code = 1226 # type: ignore
"""
``KNOTQ k1, k2``

``VEX.L0.0F.W1 44 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KNOTB_KR_KR: Code = 1227 # type: ignore
"""
``KNOTB k1, k2``

``VEX.L0.66.0F.W0 44 /r``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_KNOTD_KR_KR: Code = 1228 # type: ignore
"""
``KNOTD k1, k2``

``VEX.L0.66.0F.W1 44 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KORW_KR_KR_KR: Code = 1229 # type: ignore
"""
``KORW k1, k2, k3``

``VEX.L1.0F.W0 45 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_KORQ_KR_KR_KR: Code = 1230 # type: ignore
"""
``KORQ k1, k2, k3``

``VEX.L1.0F.W1 45 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KORB_KR_KR_KR: Code = 1231 # type: ignore
"""
``KORB k1, k2, k3``

``VEX.L1.66.0F.W0 45 /r``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_KORD_KR_KR_KR: Code = 1232 # type: ignore
"""
``KORD k1, k2, k3``

``VEX.L1.66.0F.W1 45 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KXNORW_KR_KR_KR: Code = 1233 # type: ignore
"""
``KXNORW k1, k2, k3``

``VEX.L1.0F.W0 46 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_KXNORQ_KR_KR_KR: Code = 1234 # type: ignore
"""
``KXNORQ k1, k2, k3``

``VEX.L1.0F.W1 46 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KXNORB_KR_KR_KR: Code = 1235 # type: ignore
"""
``KXNORB k1, k2, k3``

``VEX.L1.66.0F.W0 46 /r``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_KXNORD_KR_KR_KR: Code = 1236 # type: ignore
"""
``KXNORD k1, k2, k3``

``VEX.L1.66.0F.W1 46 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KXORW_KR_KR_KR: Code = 1237 # type: ignore
"""
``KXORW k1, k2, k3``

``VEX.L1.0F.W0 47 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_KXORQ_KR_KR_KR: Code = 1238 # type: ignore
"""
``KXORQ k1, k2, k3``

``VEX.L1.0F.W1 47 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KXORB_KR_KR_KR: Code = 1239 # type: ignore
"""
``KXORB k1, k2, k3``

``VEX.L1.66.0F.W0 47 /r``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_KXORD_KR_KR_KR: Code = 1240 # type: ignore
"""
``KXORD k1, k2, k3``

``VEX.L1.66.0F.W1 47 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KADDW_KR_KR_KR: Code = 1241 # type: ignore
"""
``KADDW k1, k2, k3``

``VEX.L1.0F.W0 4A /r``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_KADDQ_KR_KR_KR: Code = 1242 # type: ignore
"""
``KADDQ k1, k2, k3``

``VEX.L1.0F.W1 4A /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KADDB_KR_KR_KR: Code = 1243 # type: ignore
"""
``KADDB k1, k2, k3``

``VEX.L1.66.0F.W0 4A /r``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_KADDD_KR_KR_KR: Code = 1244 # type: ignore
"""
``KADDD k1, k2, k3``

``VEX.L1.66.0F.W1 4A /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KUNPCKWD_KR_KR_KR: Code = 1245 # type: ignore
"""
``KUNPCKWD k1, k2, k3``

``VEX.L1.0F.W0 4B /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KUNPCKDQ_KR_KR_KR: Code = 1246 # type: ignore
"""
``KUNPCKDQ k1, k2, k3``

``VEX.L1.0F.W1 4B /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KUNPCKBW_KR_KR_KR: Code = 1247 # type: ignore
"""
``KUNPCKBW k1, k2, k3``

``VEX.L1.66.0F.W0 4B /r``

``AVX512F``

``16/32/64-bit``
"""
MOVMSKPS_R32_XMM: Code = 1248 # type: ignore
"""
``MOVMSKPS r32, xmm``

``NP 0F 50 /r``

``SSE``

``16/32/64-bit``
"""
MOVMSKPS_R64_XMM: Code = 1249 # type: ignore
"""
``MOVMSKPS r64, xmm``

``NP o64 0F 50 /r``

``SSE``

``64-bit``
"""
VEX_VMOVMSKPS_R32_XMM: Code = 1250 # type: ignore
"""
``VMOVMSKPS r32, xmm2``

``VEX.128.0F.W0 50 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVMSKPS_R64_XMM: Code = 1251 # type: ignore
"""
``VMOVMSKPS r64, xmm2``

``VEX.128.0F.W1 50 /r``

``AVX``

``64-bit``
"""
VEX_VMOVMSKPS_R32_YMM: Code = 1252 # type: ignore
"""
``VMOVMSKPS r32, ymm2``

``VEX.256.0F.W0 50 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVMSKPS_R64_YMM: Code = 1253 # type: ignore
"""
``VMOVMSKPS r64, ymm2``

``VEX.256.0F.W1 50 /r``

``AVX``

``64-bit``
"""
MOVMSKPD_R32_XMM: Code = 1254 # type: ignore
"""
``MOVMSKPD r32, xmm``

``66 0F 50 /r``

``SSE2``

``16/32/64-bit``
"""
MOVMSKPD_R64_XMM: Code = 1255 # type: ignore
"""
``MOVMSKPD r64, xmm``

``66 o64 0F 50 /r``

``SSE2``

``64-bit``
"""
VEX_VMOVMSKPD_R32_XMM: Code = 1256 # type: ignore
"""
``VMOVMSKPD r32, xmm2``

``VEX.128.66.0F.W0 50 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVMSKPD_R64_XMM: Code = 1257 # type: ignore
"""
``VMOVMSKPD r64, xmm2``

``VEX.128.66.0F.W1 50 /r``

``AVX``

``64-bit``
"""
VEX_VMOVMSKPD_R32_YMM: Code = 1258 # type: ignore
"""
``VMOVMSKPD r32, ymm2``

``VEX.256.66.0F.W0 50 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVMSKPD_R64_YMM: Code = 1259 # type: ignore
"""
``VMOVMSKPD r64, ymm2``

``VEX.256.66.0F.W1 50 /r``

``AVX``

``64-bit``
"""
SQRTPS_XMM_XMMM128: Code = 1260 # type: ignore
"""
``SQRTPS xmm1, xmm2/m128``

``NP 0F 51 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VSQRTPS_XMM_XMMM128: Code = 1261 # type: ignore
"""
``VSQRTPS xmm1, xmm2/m128``

``VEX.128.0F.WIG 51 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VSQRTPS_YMM_YMMM256: Code = 1262 # type: ignore
"""
``VSQRTPS ymm1, ymm2/m256``

``VEX.256.0F.WIG 51 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VSQRTPS_XMM_K1Z_XMMM128B32: Code = 1263 # type: ignore
"""
``VSQRTPS xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.0F.W0 51 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSQRTPS_YMM_K1Z_YMMM256B32: Code = 1264 # type: ignore
"""
``VSQRTPS ymm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.0F.W0 51 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSQRTPS_ZMM_K1Z_ZMMM512B32_ER: Code = 1265 # type: ignore
"""
``VSQRTPS zmm1 {k1}{z}, zmm2/m512/m32bcst{er}``

``EVEX.512.0F.W0 51 /r``

``AVX512F``

``16/32/64-bit``
"""
SQRTPD_XMM_XMMM128: Code = 1266 # type: ignore
"""
``SQRTPD xmm1, xmm2/m128``

``66 0F 51 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VSQRTPD_XMM_XMMM128: Code = 1267 # type: ignore
"""
``VSQRTPD xmm1, xmm2/m128``

``VEX.128.66.0F.WIG 51 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VSQRTPD_YMM_YMMM256: Code = 1268 # type: ignore
"""
``VSQRTPD ymm1, ymm2/m256``

``VEX.256.66.0F.WIG 51 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VSQRTPD_XMM_K1Z_XMMM128B64: Code = 1269 # type: ignore
"""
``VSQRTPD xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.66.0F.W1 51 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSQRTPD_YMM_K1Z_YMMM256B64: Code = 1270 # type: ignore
"""
``VSQRTPD ymm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.66.0F.W1 51 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSQRTPD_ZMM_K1Z_ZMMM512B64_ER: Code = 1271 # type: ignore
"""
``VSQRTPD zmm1 {k1}{z}, zmm2/m512/m64bcst{er}``

``EVEX.512.66.0F.W1 51 /r``

``AVX512F``

``16/32/64-bit``
"""
SQRTSS_XMM_XMMM32: Code = 1272 # type: ignore
"""
``SQRTSS xmm1, xmm2/m32``

``F3 0F 51 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VSQRTSS_XMM_XMM_XMMM32: Code = 1273 # type: ignore
"""
``VSQRTSS xmm1, xmm2, xmm3/m32``

``VEX.LIG.F3.0F.WIG 51 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VSQRTSS_XMM_K1Z_XMM_XMMM32_ER: Code = 1274 # type: ignore
"""
``VSQRTSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.F3.0F.W0 51 /r``

``AVX512F``

``16/32/64-bit``
"""
SQRTSD_XMM_XMMM64: Code = 1275 # type: ignore
"""
``SQRTSD xmm1, xmm2/m64``

``F2 0F 51 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VSQRTSD_XMM_XMM_XMMM64: Code = 1276 # type: ignore
"""
``VSQRTSD xmm1, xmm2, xmm3/m64``

``VEX.LIG.F2.0F.WIG 51 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VSQRTSD_XMM_K1Z_XMM_XMMM64_ER: Code = 1277 # type: ignore
"""
``VSQRTSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.F2.0F.W1 51 /r``

``AVX512F``

``16/32/64-bit``
"""
RSQRTPS_XMM_XMMM128: Code = 1278 # type: ignore
"""
``RSQRTPS xmm1, xmm2/m128``

``NP 0F 52 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VRSQRTPS_XMM_XMMM128: Code = 1279 # type: ignore
"""
``VRSQRTPS xmm1, xmm2/m128``

``VEX.128.0F.WIG 52 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VRSQRTPS_YMM_YMMM256: Code = 1280 # type: ignore
"""
``VRSQRTPS ymm1, ymm2/m256``

``VEX.256.0F.WIG 52 /r``

``AVX``

``16/32/64-bit``
"""
RSQRTSS_XMM_XMMM32: Code = 1281 # type: ignore
"""
``RSQRTSS xmm1, xmm2/m32``

``F3 0F 52 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VRSQRTSS_XMM_XMM_XMMM32: Code = 1282 # type: ignore
"""
``VRSQRTSS xmm1, xmm2, xmm3/m32``

``VEX.LIG.F3.0F.WIG 52 /r``

``AVX``

``16/32/64-bit``
"""
RCPPS_XMM_XMMM128: Code = 1283 # type: ignore
"""
``RCPPS xmm1, xmm2/m128``

``NP 0F 53 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VRCPPS_XMM_XMMM128: Code = 1284 # type: ignore
"""
``VRCPPS xmm1, xmm2/m128``

``VEX.128.0F.WIG 53 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VRCPPS_YMM_YMMM256: Code = 1285 # type: ignore
"""
``VRCPPS ymm1, ymm2/m256``

``VEX.256.0F.WIG 53 /r``

``AVX``

``16/32/64-bit``
"""
RCPSS_XMM_XMMM32: Code = 1286 # type: ignore
"""
``RCPSS xmm1, xmm2/m32``

``F3 0F 53 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VRCPSS_XMM_XMM_XMMM32: Code = 1287 # type: ignore
"""
``VRCPSS xmm1, xmm2, xmm3/m32``

``VEX.LIG.F3.0F.WIG 53 /r``

``AVX``

``16/32/64-bit``
"""
ANDPS_XMM_XMMM128: Code = 1288 # type: ignore
"""
``ANDPS xmm1, xmm2/m128``

``NP 0F 54 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VANDPS_XMM_XMM_XMMM128: Code = 1289 # type: ignore
"""
``VANDPS xmm1, xmm2, xmm3/m128``

``VEX.128.0F.WIG 54 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VANDPS_YMM_YMM_YMMM256: Code = 1290 # type: ignore
"""
``VANDPS ymm1, ymm2, ymm3/m256``

``VEX.256.0F.WIG 54 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VANDPS_XMM_K1Z_XMM_XMMM128B32: Code = 1291 # type: ignore
"""
``VANDPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.0F.W0 54 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VANDPS_YMM_K1Z_YMM_YMMM256B32: Code = 1292 # type: ignore
"""
``VANDPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.0F.W0 54 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VANDPS_ZMM_K1Z_ZMM_ZMMM512B32: Code = 1293 # type: ignore
"""
``VANDPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.0F.W0 54 /r``

``AVX512DQ``

``16/32/64-bit``
"""
ANDPD_XMM_XMMM128: Code = 1294 # type: ignore
"""
``ANDPD xmm1, xmm2/m128``

``66 0F 54 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VANDPD_XMM_XMM_XMMM128: Code = 1295 # type: ignore
"""
``VANDPD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 54 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VANDPD_YMM_YMM_YMMM256: Code = 1296 # type: ignore
"""
``VANDPD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 54 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VANDPD_XMM_K1Z_XMM_XMMM128B64: Code = 1297 # type: ignore
"""
``VANDPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 54 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VANDPD_YMM_K1Z_YMM_YMMM256B64: Code = 1298 # type: ignore
"""
``VANDPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 54 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VANDPD_ZMM_K1Z_ZMM_ZMMM512B64: Code = 1299 # type: ignore
"""
``VANDPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F.W1 54 /r``

``AVX512DQ``

``16/32/64-bit``
"""
ANDNPS_XMM_XMMM128: Code = 1300 # type: ignore
"""
``ANDNPS xmm1, xmm2/m128``

``NP 0F 55 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VANDNPS_XMM_XMM_XMMM128: Code = 1301 # type: ignore
"""
``VANDNPS xmm1, xmm2, xmm3/m128``

``VEX.128.0F.WIG 55 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VANDNPS_YMM_YMM_YMMM256: Code = 1302 # type: ignore
"""
``VANDNPS ymm1, ymm2, ymm3/m256``

``VEX.256.0F.WIG 55 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VANDNPS_XMM_K1Z_XMM_XMMM128B32: Code = 1303 # type: ignore
"""
``VANDNPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.0F.W0 55 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VANDNPS_YMM_K1Z_YMM_YMMM256B32: Code = 1304 # type: ignore
"""
``VANDNPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.0F.W0 55 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VANDNPS_ZMM_K1Z_ZMM_ZMMM512B32: Code = 1305 # type: ignore
"""
``VANDNPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.0F.W0 55 /r``

``AVX512DQ``

``16/32/64-bit``
"""
ANDNPD_XMM_XMMM128: Code = 1306 # type: ignore
"""
``ANDNPD xmm1, xmm2/m128``

``66 0F 55 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VANDNPD_XMM_XMM_XMMM128: Code = 1307 # type: ignore
"""
``VANDNPD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 55 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VANDNPD_YMM_YMM_YMMM256: Code = 1308 # type: ignore
"""
``VANDNPD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 55 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VANDNPD_XMM_K1Z_XMM_XMMM128B64: Code = 1309 # type: ignore
"""
``VANDNPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 55 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VANDNPD_YMM_K1Z_YMM_YMMM256B64: Code = 1310 # type: ignore
"""
``VANDNPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 55 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VANDNPD_ZMM_K1Z_ZMM_ZMMM512B64: Code = 1311 # type: ignore
"""
``VANDNPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F.W1 55 /r``

``AVX512DQ``

``16/32/64-bit``
"""
ORPS_XMM_XMMM128: Code = 1312 # type: ignore
"""
``ORPS xmm1, xmm2/m128``

``NP 0F 56 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VORPS_XMM_XMM_XMMM128: Code = 1313 # type: ignore
"""
``VORPS xmm1, xmm2, xmm3/m128``

``VEX.128.0F.WIG 56 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VORPS_YMM_YMM_YMMM256: Code = 1314 # type: ignore
"""
``VORPS ymm1, ymm2, ymm3/m256``

``VEX.256.0F.WIG 56 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VORPS_XMM_K1Z_XMM_XMMM128B32: Code = 1315 # type: ignore
"""
``VORPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.0F.W0 56 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VORPS_YMM_K1Z_YMM_YMMM256B32: Code = 1316 # type: ignore
"""
``VORPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.0F.W0 56 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VORPS_ZMM_K1Z_ZMM_ZMMM512B32: Code = 1317 # type: ignore
"""
``VORPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.0F.W0 56 /r``

``AVX512DQ``

``16/32/64-bit``
"""
ORPD_XMM_XMMM128: Code = 1318 # type: ignore
"""
``ORPD xmm1, xmm2/m128``

``66 0F 56 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VORPD_XMM_XMM_XMMM128: Code = 1319 # type: ignore
"""
``VORPD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 56 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VORPD_YMM_YMM_YMMM256: Code = 1320 # type: ignore
"""
``VORPD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 56 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VORPD_XMM_K1Z_XMM_XMMM128B64: Code = 1321 # type: ignore
"""
``VORPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 56 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VORPD_YMM_K1Z_YMM_YMMM256B64: Code = 1322 # type: ignore
"""
``VORPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 56 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VORPD_ZMM_K1Z_ZMM_ZMMM512B64: Code = 1323 # type: ignore
"""
``VORPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F.W1 56 /r``

``AVX512DQ``

``16/32/64-bit``
"""
XORPS_XMM_XMMM128: Code = 1324 # type: ignore
"""
``XORPS xmm1, xmm2/m128``

``NP 0F 57 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VXORPS_XMM_XMM_XMMM128: Code = 1325 # type: ignore
"""
``VXORPS xmm1, xmm2, xmm3/m128``

``VEX.128.0F.WIG 57 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VXORPS_YMM_YMM_YMMM256: Code = 1326 # type: ignore
"""
``VXORPS ymm1, ymm2, ymm3/m256``

``VEX.256.0F.WIG 57 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VXORPS_XMM_K1Z_XMM_XMMM128B32: Code = 1327 # type: ignore
"""
``VXORPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.0F.W0 57 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VXORPS_YMM_K1Z_YMM_YMMM256B32: Code = 1328 # type: ignore
"""
``VXORPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.0F.W0 57 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VXORPS_ZMM_K1Z_ZMM_ZMMM512B32: Code = 1329 # type: ignore
"""
``VXORPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.0F.W0 57 /r``

``AVX512DQ``

``16/32/64-bit``
"""
XORPD_XMM_XMMM128: Code = 1330 # type: ignore
"""
``XORPD xmm1, xmm2/m128``

``66 0F 57 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VXORPD_XMM_XMM_XMMM128: Code = 1331 # type: ignore
"""
``VXORPD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 57 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VXORPD_YMM_YMM_YMMM256: Code = 1332 # type: ignore
"""
``VXORPD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 57 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VXORPD_XMM_K1Z_XMM_XMMM128B64: Code = 1333 # type: ignore
"""
``VXORPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 57 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VXORPD_YMM_K1Z_YMM_YMMM256B64: Code = 1334 # type: ignore
"""
``VXORPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 57 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VXORPD_ZMM_K1Z_ZMM_ZMMM512B64: Code = 1335 # type: ignore
"""
``VXORPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F.W1 57 /r``

``AVX512DQ``

``16/32/64-bit``
"""
ADDPS_XMM_XMMM128: Code = 1336 # type: ignore
"""
``ADDPS xmm1, xmm2/m128``

``NP 0F 58 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VADDPS_XMM_XMM_XMMM128: Code = 1337 # type: ignore
"""
``VADDPS xmm1, xmm2, xmm3/m128``

``VEX.128.0F.WIG 58 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VADDPS_YMM_YMM_YMMM256: Code = 1338 # type: ignore
"""
``VADDPS ymm1, ymm2, ymm3/m256``

``VEX.256.0F.WIG 58 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VADDPS_XMM_K1Z_XMM_XMMM128B32: Code = 1339 # type: ignore
"""
``VADDPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.0F.W0 58 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VADDPS_YMM_K1Z_YMM_YMMM256B32: Code = 1340 # type: ignore
"""
``VADDPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.0F.W0 58 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VADDPS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 1341 # type: ignore
"""
``VADDPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.0F.W0 58 /r``

``AVX512F``

``16/32/64-bit``
"""
ADDPD_XMM_XMMM128: Code = 1342 # type: ignore
"""
``ADDPD xmm1, xmm2/m128``

``66 0F 58 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VADDPD_XMM_XMM_XMMM128: Code = 1343 # type: ignore
"""
``VADDPD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 58 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VADDPD_YMM_YMM_YMMM256: Code = 1344 # type: ignore
"""
``VADDPD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 58 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VADDPD_XMM_K1Z_XMM_XMMM128B64: Code = 1345 # type: ignore
"""
``VADDPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 58 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VADDPD_YMM_K1Z_YMM_YMMM256B64: Code = 1346 # type: ignore
"""
``VADDPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 58 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VADDPD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 1347 # type: ignore
"""
``VADDPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F.W1 58 /r``

``AVX512F``

``16/32/64-bit``
"""
ADDSS_XMM_XMMM32: Code = 1348 # type: ignore
"""
``ADDSS xmm1, xmm2/m32``

``F3 0F 58 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VADDSS_XMM_XMM_XMMM32: Code = 1349 # type: ignore
"""
``VADDSS xmm1, xmm2, xmm3/m32``

``VEX.LIG.F3.0F.WIG 58 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VADDSS_XMM_K1Z_XMM_XMMM32_ER: Code = 1350 # type: ignore
"""
``VADDSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.F3.0F.W0 58 /r``

``AVX512F``

``16/32/64-bit``
"""
ADDSD_XMM_XMMM64: Code = 1351 # type: ignore
"""
``ADDSD xmm1, xmm2/m64``

``F2 0F 58 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VADDSD_XMM_XMM_XMMM64: Code = 1352 # type: ignore
"""
``VADDSD xmm1, xmm2, xmm3/m64``

``VEX.LIG.F2.0F.WIG 58 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VADDSD_XMM_K1Z_XMM_XMMM64_ER: Code = 1353 # type: ignore
"""
``VADDSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.F2.0F.W1 58 /r``

``AVX512F``

``16/32/64-bit``
"""
MULPS_XMM_XMMM128: Code = 1354 # type: ignore
"""
``MULPS xmm1, xmm2/m128``

``NP 0F 59 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMULPS_XMM_XMM_XMMM128: Code = 1355 # type: ignore
"""
``VMULPS xmm1, xmm2, xmm3/m128``

``VEX.128.0F.WIG 59 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMULPS_YMM_YMM_YMMM256: Code = 1356 # type: ignore
"""
``VMULPS ymm1, ymm2, ymm3/m256``

``VEX.256.0F.WIG 59 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMULPS_XMM_K1Z_XMM_XMMM128B32: Code = 1357 # type: ignore
"""
``VMULPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.0F.W0 59 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMULPS_YMM_K1Z_YMM_YMMM256B32: Code = 1358 # type: ignore
"""
``VMULPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.0F.W0 59 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMULPS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 1359 # type: ignore
"""
``VMULPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.0F.W0 59 /r``

``AVX512F``

``16/32/64-bit``
"""
MULPD_XMM_XMMM128: Code = 1360 # type: ignore
"""
``MULPD xmm1, xmm2/m128``

``66 0F 59 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMULPD_XMM_XMM_XMMM128: Code = 1361 # type: ignore
"""
``VMULPD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 59 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMULPD_YMM_YMM_YMMM256: Code = 1362 # type: ignore
"""
``VMULPD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 59 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMULPD_XMM_K1Z_XMM_XMMM128B64: Code = 1363 # type: ignore
"""
``VMULPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 59 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMULPD_YMM_K1Z_YMM_YMMM256B64: Code = 1364 # type: ignore
"""
``VMULPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 59 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMULPD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 1365 # type: ignore
"""
``VMULPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F.W1 59 /r``

``AVX512F``

``16/32/64-bit``
"""
MULSS_XMM_XMMM32: Code = 1366 # type: ignore
"""
``MULSS xmm1, xmm2/m32``

``F3 0F 59 /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMULSS_XMM_XMM_XMMM32: Code = 1367 # type: ignore
"""
``VMULSS xmm1, xmm2, xmm3/m32``

``VEX.LIG.F3.0F.WIG 59 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMULSS_XMM_K1Z_XMM_XMMM32_ER: Code = 1368 # type: ignore
"""
``VMULSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.F3.0F.W0 59 /r``

``AVX512F``

``16/32/64-bit``
"""
MULSD_XMM_XMMM64: Code = 1369 # type: ignore
"""
``MULSD xmm1, xmm2/m64``

``F2 0F 59 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMULSD_XMM_XMM_XMMM64: Code = 1370 # type: ignore
"""
``VMULSD xmm1, xmm2, xmm3/m64``

``VEX.LIG.F2.0F.WIG 59 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMULSD_XMM_K1Z_XMM_XMMM64_ER: Code = 1371 # type: ignore
"""
``VMULSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.F2.0F.W1 59 /r``

``AVX512F``

``16/32/64-bit``
"""
CVTPS2PD_XMM_XMMM64: Code = 1372 # type: ignore
"""
``CVTPS2PD xmm1, xmm2/m64``

``NP 0F 5A /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VCVTPS2PD_XMM_XMMM64: Code = 1373 # type: ignore
"""
``VCVTPS2PD xmm1, xmm2/m64``

``VEX.128.0F.WIG 5A /r``

``AVX``

``16/32/64-bit``
"""
VEX_VCVTPS2PD_YMM_XMMM128: Code = 1374 # type: ignore
"""
``VCVTPS2PD ymm1, xmm2/m128``

``VEX.256.0F.WIG 5A /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VCVTPS2PD_XMM_K1Z_XMMM64B32: Code = 1375 # type: ignore
"""
``VCVTPS2PD xmm1 {k1}{z}, xmm2/m64/m32bcst``

``EVEX.128.0F.W0 5A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTPS2PD_YMM_K1Z_XMMM128B32: Code = 1376 # type: ignore
"""
``VCVTPS2PD ymm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.256.0F.W0 5A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTPS2PD_ZMM_K1Z_YMMM256B32_SAE: Code = 1377 # type: ignore
"""
``VCVTPS2PD zmm1 {k1}{z}, ymm2/m256/m32bcst{sae}``

``EVEX.512.0F.W0 5A /r``

``AVX512F``

``16/32/64-bit``
"""
CVTPD2PS_XMM_XMMM128: Code = 1378 # type: ignore
"""
``CVTPD2PS xmm1, xmm2/m128``

``66 0F 5A /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VCVTPD2PS_XMM_XMMM128: Code = 1379 # type: ignore
"""
``VCVTPD2PS xmm1, xmm2/m128``

``VEX.128.66.0F.WIG 5A /r``

``AVX``

``16/32/64-bit``
"""
VEX_VCVTPD2PS_XMM_YMMM256: Code = 1380 # type: ignore
"""
``VCVTPD2PS xmm1, ymm2/m256``

``VEX.256.66.0F.WIG 5A /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VCVTPD2PS_XMM_K1Z_XMMM128B64: Code = 1381 # type: ignore
"""
``VCVTPD2PS xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.66.0F.W1 5A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTPD2PS_XMM_K1Z_YMMM256B64: Code = 1382 # type: ignore
"""
``VCVTPD2PS xmm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.66.0F.W1 5A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTPD2PS_YMM_K1Z_ZMMM512B64_ER: Code = 1383 # type: ignore
"""
``VCVTPD2PS ymm1 {k1}{z}, zmm2/m512/m64bcst{er}``

``EVEX.512.66.0F.W1 5A /r``

``AVX512F``

``16/32/64-bit``
"""
CVTSS2SD_XMM_XMMM32: Code = 1384 # type: ignore
"""
``CVTSS2SD xmm1, xmm2/m32``

``F3 0F 5A /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VCVTSS2SD_XMM_XMM_XMMM32: Code = 1385 # type: ignore
"""
``VCVTSS2SD xmm1, xmm2, xmm3/m32``

``VEX.LIG.F3.0F.WIG 5A /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VCVTSS2SD_XMM_K1Z_XMM_XMMM32_SAE: Code = 1386 # type: ignore
"""
``VCVTSS2SD xmm1 {k1}{z}, xmm2, xmm3/m32{sae}``

``EVEX.LIG.F3.0F.W0 5A /r``

``AVX512F``

``16/32/64-bit``
"""
CVTSD2SS_XMM_XMMM64: Code = 1387 # type: ignore
"""
``CVTSD2SS xmm1, xmm2/m64``

``F2 0F 5A /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VCVTSD2SS_XMM_XMM_XMMM64: Code = 1388 # type: ignore
"""
``VCVTSD2SS xmm1, xmm2, xmm3/m64``

``VEX.LIG.F2.0F.WIG 5A /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VCVTSD2SS_XMM_K1Z_XMM_XMMM64_ER: Code = 1389 # type: ignore
"""
``VCVTSD2SS xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.F2.0F.W1 5A /r``

``AVX512F``

``16/32/64-bit``
"""
CVTDQ2PS_XMM_XMMM128: Code = 1390 # type: ignore
"""
``CVTDQ2PS xmm1, xmm2/m128``

``NP 0F 5B /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VCVTDQ2PS_XMM_XMMM128: Code = 1391 # type: ignore
"""
``VCVTDQ2PS xmm1, xmm2/m128``

``VEX.128.0F.WIG 5B /r``

``AVX``

``16/32/64-bit``
"""
VEX_VCVTDQ2PS_YMM_YMMM256: Code = 1392 # type: ignore
"""
``VCVTDQ2PS ymm1, ymm2/m256``

``VEX.256.0F.WIG 5B /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VCVTDQ2PS_XMM_K1Z_XMMM128B32: Code = 1393 # type: ignore
"""
``VCVTDQ2PS xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.0F.W0 5B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTDQ2PS_YMM_K1Z_YMMM256B32: Code = 1394 # type: ignore
"""
``VCVTDQ2PS ymm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.0F.W0 5B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTDQ2PS_ZMM_K1Z_ZMMM512B32_ER: Code = 1395 # type: ignore
"""
``VCVTDQ2PS zmm1 {k1}{z}, zmm2/m512/m32bcst{er}``

``EVEX.512.0F.W0 5B /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTQQ2PS_XMM_K1Z_XMMM128B64: Code = 1396 # type: ignore
"""
``VCVTQQ2PS xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.0F.W1 5B /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTQQ2PS_XMM_K1Z_YMMM256B64: Code = 1397 # type: ignore
"""
``VCVTQQ2PS xmm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.0F.W1 5B /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTQQ2PS_YMM_K1Z_ZMMM512B64_ER: Code = 1398 # type: ignore
"""
``VCVTQQ2PS ymm1 {k1}{z}, zmm2/m512/m64bcst{er}``

``EVEX.512.0F.W1 5B /r``

``AVX512DQ``

``16/32/64-bit``
"""
CVTPS2DQ_XMM_XMMM128: Code = 1399 # type: ignore
"""
``CVTPS2DQ xmm1, xmm2/m128``

``66 0F 5B /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VCVTPS2DQ_XMM_XMMM128: Code = 1400 # type: ignore
"""
``VCVTPS2DQ xmm1, xmm2/m128``

``VEX.128.66.0F.WIG 5B /r``

``AVX``

``16/32/64-bit``
"""
VEX_VCVTPS2DQ_YMM_YMMM256: Code = 1401 # type: ignore
"""
``VCVTPS2DQ ymm1, ymm2/m256``

``VEX.256.66.0F.WIG 5B /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VCVTPS2DQ_XMM_K1Z_XMMM128B32: Code = 1402 # type: ignore
"""
``VCVTPS2DQ xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.66.0F.W0 5B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTPS2DQ_YMM_K1Z_YMMM256B32: Code = 1403 # type: ignore
"""
``VCVTPS2DQ ymm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.66.0F.W0 5B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTPS2DQ_ZMM_K1Z_ZMMM512B32_ER: Code = 1404 # type: ignore
"""
``VCVTPS2DQ zmm1 {k1}{z}, zmm2/m512/m32bcst{er}``

``EVEX.512.66.0F.W0 5B /r``

``AVX512F``

``16/32/64-bit``
"""
CVTTPS2DQ_XMM_XMMM128: Code = 1405 # type: ignore
"""
``CVTTPS2DQ xmm1, xmm2/m128``

``F3 0F 5B /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VCVTTPS2DQ_XMM_XMMM128: Code = 1406 # type: ignore
"""
``VCVTTPS2DQ xmm1, xmm2/m128``

``VEX.128.F3.0F.WIG 5B /r``

``AVX``

``16/32/64-bit``
"""
VEX_VCVTTPS2DQ_YMM_YMMM256: Code = 1407 # type: ignore
"""
``VCVTTPS2DQ ymm1, ymm2/m256``

``VEX.256.F3.0F.WIG 5B /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VCVTTPS2DQ_XMM_K1Z_XMMM128B32: Code = 1408 # type: ignore
"""
``VCVTTPS2DQ xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.F3.0F.W0 5B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTTPS2DQ_YMM_K1Z_YMMM256B32: Code = 1409 # type: ignore
"""
``VCVTTPS2DQ ymm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.F3.0F.W0 5B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTTPS2DQ_ZMM_K1Z_ZMMM512B32_SAE: Code = 1410 # type: ignore
"""
``VCVTTPS2DQ zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}``

``EVEX.512.F3.0F.W0 5B /r``

``AVX512F``

``16/32/64-bit``
"""
SUBPS_XMM_XMMM128: Code = 1411 # type: ignore
"""
``SUBPS xmm1, xmm2/m128``

``NP 0F 5C /r``

``SSE``

``16/32/64-bit``
"""
VEX_VSUBPS_XMM_XMM_XMMM128: Code = 1412 # type: ignore
"""
``VSUBPS xmm1, xmm2, xmm3/m128``

``VEX.128.0F.WIG 5C /r``

``AVX``

``16/32/64-bit``
"""
VEX_VSUBPS_YMM_YMM_YMMM256: Code = 1413 # type: ignore
"""
``VSUBPS ymm1, ymm2, ymm3/m256``

``VEX.256.0F.WIG 5C /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VSUBPS_XMM_K1Z_XMM_XMMM128B32: Code = 1414 # type: ignore
"""
``VSUBPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.0F.W0 5C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSUBPS_YMM_K1Z_YMM_YMMM256B32: Code = 1415 # type: ignore
"""
``VSUBPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.0F.W0 5C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSUBPS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 1416 # type: ignore
"""
``VSUBPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.0F.W0 5C /r``

``AVX512F``

``16/32/64-bit``
"""
SUBPD_XMM_XMMM128: Code = 1417 # type: ignore
"""
``SUBPD xmm1, xmm2/m128``

``66 0F 5C /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VSUBPD_XMM_XMM_XMMM128: Code = 1418 # type: ignore
"""
``VSUBPD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 5C /r``

``AVX``

``16/32/64-bit``
"""
VEX_VSUBPD_YMM_YMM_YMMM256: Code = 1419 # type: ignore
"""
``VSUBPD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 5C /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VSUBPD_XMM_K1Z_XMM_XMMM128B64: Code = 1420 # type: ignore
"""
``VSUBPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 5C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSUBPD_YMM_K1Z_YMM_YMMM256B64: Code = 1421 # type: ignore
"""
``VSUBPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 5C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSUBPD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 1422 # type: ignore
"""
``VSUBPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F.W1 5C /r``

``AVX512F``

``16/32/64-bit``
"""
SUBSS_XMM_XMMM32: Code = 1423 # type: ignore
"""
``SUBSS xmm1, xmm2/m32``

``F3 0F 5C /r``

``SSE``

``16/32/64-bit``
"""
VEX_VSUBSS_XMM_XMM_XMMM32: Code = 1424 # type: ignore
"""
``VSUBSS xmm1, xmm2, xmm3/m32``

``VEX.LIG.F3.0F.WIG 5C /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VSUBSS_XMM_K1Z_XMM_XMMM32_ER: Code = 1425 # type: ignore
"""
``VSUBSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.F3.0F.W0 5C /r``

``AVX512F``

``16/32/64-bit``
"""
SUBSD_XMM_XMMM64: Code = 1426 # type: ignore
"""
``SUBSD xmm1, xmm2/m64``

``F2 0F 5C /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VSUBSD_XMM_XMM_XMMM64: Code = 1427 # type: ignore
"""
``VSUBSD xmm1, xmm2, xmm3/m64``

``VEX.LIG.F2.0F.WIG 5C /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VSUBSD_XMM_K1Z_XMM_XMMM64_ER: Code = 1428 # type: ignore
"""
``VSUBSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.F2.0F.W1 5C /r``

``AVX512F``

``16/32/64-bit``
"""
MINPS_XMM_XMMM128: Code = 1429 # type: ignore
"""
``MINPS xmm1, xmm2/m128``

``NP 0F 5D /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMINPS_XMM_XMM_XMMM128: Code = 1430 # type: ignore
"""
``VMINPS xmm1, xmm2, xmm3/m128``

``VEX.128.0F.WIG 5D /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMINPS_YMM_YMM_YMMM256: Code = 1431 # type: ignore
"""
``VMINPS ymm1, ymm2, ymm3/m256``

``VEX.256.0F.WIG 5D /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMINPS_XMM_K1Z_XMM_XMMM128B32: Code = 1432 # type: ignore
"""
``VMINPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.0F.W0 5D /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMINPS_YMM_K1Z_YMM_YMMM256B32: Code = 1433 # type: ignore
"""
``VMINPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.0F.W0 5D /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMINPS_ZMM_K1Z_ZMM_ZMMM512B32_SAE: Code = 1434 # type: ignore
"""
``VMINPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{sae}``

``EVEX.512.0F.W0 5D /r``

``AVX512F``

``16/32/64-bit``
"""
MINPD_XMM_XMMM128: Code = 1435 # type: ignore
"""
``MINPD xmm1, xmm2/m128``

``66 0F 5D /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMINPD_XMM_XMM_XMMM128: Code = 1436 # type: ignore
"""
``VMINPD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 5D /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMINPD_YMM_YMM_YMMM256: Code = 1437 # type: ignore
"""
``VMINPD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 5D /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMINPD_XMM_K1Z_XMM_XMMM128B64: Code = 1438 # type: ignore
"""
``VMINPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 5D /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMINPD_YMM_K1Z_YMM_YMMM256B64: Code = 1439 # type: ignore
"""
``VMINPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 5D /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMINPD_ZMM_K1Z_ZMM_ZMMM512B64_SAE: Code = 1440 # type: ignore
"""
``VMINPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{sae}``

``EVEX.512.66.0F.W1 5D /r``

``AVX512F``

``16/32/64-bit``
"""
MINSS_XMM_XMMM32: Code = 1441 # type: ignore
"""
``MINSS xmm1, xmm2/m32``

``F3 0F 5D /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMINSS_XMM_XMM_XMMM32: Code = 1442 # type: ignore
"""
``VMINSS xmm1, xmm2, xmm3/m32``

``VEX.LIG.F3.0F.WIG 5D /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMINSS_XMM_K1Z_XMM_XMMM32_SAE: Code = 1443 # type: ignore
"""
``VMINSS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}``

``EVEX.LIG.F3.0F.W0 5D /r``

``AVX512F``

``16/32/64-bit``
"""
MINSD_XMM_XMMM64: Code = 1444 # type: ignore
"""
``MINSD xmm1, xmm2/m64``

``F2 0F 5D /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMINSD_XMM_XMM_XMMM64: Code = 1445 # type: ignore
"""
``VMINSD xmm1, xmm2, xmm3/m64``

``VEX.LIG.F2.0F.WIG 5D /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMINSD_XMM_K1Z_XMM_XMMM64_SAE: Code = 1446 # type: ignore
"""
``VMINSD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}``

``EVEX.LIG.F2.0F.W1 5D /r``

``AVX512F``

``16/32/64-bit``
"""
DIVPS_XMM_XMMM128: Code = 1447 # type: ignore
"""
``DIVPS xmm1, xmm2/m128``

``NP 0F 5E /r``

``SSE``

``16/32/64-bit``
"""
VEX_VDIVPS_XMM_XMM_XMMM128: Code = 1448 # type: ignore
"""
``VDIVPS xmm1, xmm2, xmm3/m128``

``VEX.128.0F.WIG 5E /r``

``AVX``

``16/32/64-bit``
"""
VEX_VDIVPS_YMM_YMM_YMMM256: Code = 1449 # type: ignore
"""
``VDIVPS ymm1, ymm2, ymm3/m256``

``VEX.256.0F.WIG 5E /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VDIVPS_XMM_K1Z_XMM_XMMM128B32: Code = 1450 # type: ignore
"""
``VDIVPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.0F.W0 5E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VDIVPS_YMM_K1Z_YMM_YMMM256B32: Code = 1451 # type: ignore
"""
``VDIVPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.0F.W0 5E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VDIVPS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 1452 # type: ignore
"""
``VDIVPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.0F.W0 5E /r``

``AVX512F``

``16/32/64-bit``
"""
DIVPD_XMM_XMMM128: Code = 1453 # type: ignore
"""
``DIVPD xmm1, xmm2/m128``

``66 0F 5E /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VDIVPD_XMM_XMM_XMMM128: Code = 1454 # type: ignore
"""
``VDIVPD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 5E /r``

``AVX``

``16/32/64-bit``
"""
VEX_VDIVPD_YMM_YMM_YMMM256: Code = 1455 # type: ignore
"""
``VDIVPD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 5E /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VDIVPD_XMM_K1Z_XMM_XMMM128B64: Code = 1456 # type: ignore
"""
``VDIVPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 5E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VDIVPD_YMM_K1Z_YMM_YMMM256B64: Code = 1457 # type: ignore
"""
``VDIVPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 5E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VDIVPD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 1458 # type: ignore
"""
``VDIVPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F.W1 5E /r``

``AVX512F``

``16/32/64-bit``
"""
DIVSS_XMM_XMMM32: Code = 1459 # type: ignore
"""
``DIVSS xmm1, xmm2/m32``

``F3 0F 5E /r``

``SSE``

``16/32/64-bit``
"""
VEX_VDIVSS_XMM_XMM_XMMM32: Code = 1460 # type: ignore
"""
``VDIVSS xmm1, xmm2, xmm3/m32``

``VEX.LIG.F3.0F.WIG 5E /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VDIVSS_XMM_K1Z_XMM_XMMM32_ER: Code = 1461 # type: ignore
"""
``VDIVSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.F3.0F.W0 5E /r``

``AVX512F``

``16/32/64-bit``
"""
DIVSD_XMM_XMMM64: Code = 1462 # type: ignore
"""
``DIVSD xmm1, xmm2/m64``

``F2 0F 5E /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VDIVSD_XMM_XMM_XMMM64: Code = 1463 # type: ignore
"""
``VDIVSD xmm1, xmm2, xmm3/m64``

``VEX.LIG.F2.0F.WIG 5E /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VDIVSD_XMM_K1Z_XMM_XMMM64_ER: Code = 1464 # type: ignore
"""
``VDIVSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.F2.0F.W1 5E /r``

``AVX512F``

``16/32/64-bit``
"""
MAXPS_XMM_XMMM128: Code = 1465 # type: ignore
"""
``MAXPS xmm1, xmm2/m128``

``NP 0F 5F /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMAXPS_XMM_XMM_XMMM128: Code = 1466 # type: ignore
"""
``VMAXPS xmm1, xmm2, xmm3/m128``

``VEX.128.0F.WIG 5F /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMAXPS_YMM_YMM_YMMM256: Code = 1467 # type: ignore
"""
``VMAXPS ymm1, ymm2, ymm3/m256``

``VEX.256.0F.WIG 5F /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMAXPS_XMM_K1Z_XMM_XMMM128B32: Code = 1468 # type: ignore
"""
``VMAXPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.0F.W0 5F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMAXPS_YMM_K1Z_YMM_YMMM256B32: Code = 1469 # type: ignore
"""
``VMAXPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.0F.W0 5F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMAXPS_ZMM_K1Z_ZMM_ZMMM512B32_SAE: Code = 1470 # type: ignore
"""
``VMAXPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{sae}``

``EVEX.512.0F.W0 5F /r``

``AVX512F``

``16/32/64-bit``
"""
MAXPD_XMM_XMMM128: Code = 1471 # type: ignore
"""
``MAXPD xmm1, xmm2/m128``

``66 0F 5F /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMAXPD_XMM_XMM_XMMM128: Code = 1472 # type: ignore
"""
``VMAXPD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 5F /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMAXPD_YMM_YMM_YMMM256: Code = 1473 # type: ignore
"""
``VMAXPD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 5F /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMAXPD_XMM_K1Z_XMM_XMMM128B64: Code = 1474 # type: ignore
"""
``VMAXPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 5F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMAXPD_YMM_K1Z_YMM_YMMM256B64: Code = 1475 # type: ignore
"""
``VMAXPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 5F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMAXPD_ZMM_K1Z_ZMM_ZMMM512B64_SAE: Code = 1476 # type: ignore
"""
``VMAXPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{sae}``

``EVEX.512.66.0F.W1 5F /r``

``AVX512F``

``16/32/64-bit``
"""
MAXSS_XMM_XMMM32: Code = 1477 # type: ignore
"""
``MAXSS xmm1, xmm2/m32``

``F3 0F 5F /r``

``SSE``

``16/32/64-bit``
"""
VEX_VMAXSS_XMM_XMM_XMMM32: Code = 1478 # type: ignore
"""
``VMAXSS xmm1, xmm2, xmm3/m32``

``VEX.LIG.F3.0F.WIG 5F /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMAXSS_XMM_K1Z_XMM_XMMM32_SAE: Code = 1479 # type: ignore
"""
``VMAXSS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}``

``EVEX.LIG.F3.0F.W0 5F /r``

``AVX512F``

``16/32/64-bit``
"""
MAXSD_XMM_XMMM64: Code = 1480 # type: ignore
"""
``MAXSD xmm1, xmm2/m64``

``F2 0F 5F /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMAXSD_XMM_XMM_XMMM64: Code = 1481 # type: ignore
"""
``VMAXSD xmm1, xmm2, xmm3/m64``

``VEX.LIG.F2.0F.WIG 5F /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMAXSD_XMM_K1Z_XMM_XMMM64_SAE: Code = 1482 # type: ignore
"""
``VMAXSD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}``

``EVEX.LIG.F2.0F.W1 5F /r``

``AVX512F``

``16/32/64-bit``
"""
PUNPCKLBW_MM_MMM32: Code = 1483 # type: ignore
"""
``PUNPCKLBW mm, mm/m32``

``NP 0F 60 /r``

``MMX``

``16/32/64-bit``
"""
PUNPCKLBW_XMM_XMMM128: Code = 1484 # type: ignore
"""
``PUNPCKLBW xmm1, xmm2/m128``

``66 0F 60 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPUNPCKLBW_XMM_XMM_XMMM128: Code = 1485 # type: ignore
"""
``VPUNPCKLBW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 60 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPUNPCKLBW_YMM_YMM_YMMM256: Code = 1486 # type: ignore
"""
``VPUNPCKLBW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 60 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPUNPCKLBW_XMM_K1Z_XMM_XMMM128: Code = 1487 # type: ignore
"""
``VPUNPCKLBW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG 60 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPUNPCKLBW_YMM_K1Z_YMM_YMMM256: Code = 1488 # type: ignore
"""
``VPUNPCKLBW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG 60 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPUNPCKLBW_ZMM_K1Z_ZMM_ZMMM512: Code = 1489 # type: ignore
"""
``VPUNPCKLBW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG 60 /r``

``AVX512BW``

``16/32/64-bit``
"""
PUNPCKLWD_MM_MMM32: Code = 1490 # type: ignore
"""
``PUNPCKLWD mm, mm/m32``

``NP 0F 61 /r``

``MMX``

``16/32/64-bit``
"""
PUNPCKLWD_XMM_XMMM128: Code = 1491 # type: ignore
"""
``PUNPCKLWD xmm1, xmm2/m128``

``66 0F 61 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPUNPCKLWD_XMM_XMM_XMMM128: Code = 1492 # type: ignore
"""
``VPUNPCKLWD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 61 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPUNPCKLWD_YMM_YMM_YMMM256: Code = 1493 # type: ignore
"""
``VPUNPCKLWD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 61 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPUNPCKLWD_XMM_K1Z_XMM_XMMM128: Code = 1494 # type: ignore
"""
``VPUNPCKLWD xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG 61 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPUNPCKLWD_YMM_K1Z_YMM_YMMM256: Code = 1495 # type: ignore
"""
``VPUNPCKLWD ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG 61 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPUNPCKLWD_ZMM_K1Z_ZMM_ZMMM512: Code = 1496 # type: ignore
"""
``VPUNPCKLWD zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG 61 /r``

``AVX512BW``

``16/32/64-bit``
"""
PUNPCKLDQ_MM_MMM32: Code = 1497 # type: ignore
"""
``PUNPCKLDQ mm, mm/m32``

``NP 0F 62 /r``

``MMX``

``16/32/64-bit``
"""
PUNPCKLDQ_XMM_XMMM128: Code = 1498 # type: ignore
"""
``PUNPCKLDQ xmm1, xmm2/m128``

``66 0F 62 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPUNPCKLDQ_XMM_XMM_XMMM128: Code = 1499 # type: ignore
"""
``VPUNPCKLDQ xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 62 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPUNPCKLDQ_YMM_YMM_YMMM256: Code = 1500 # type: ignore
"""
``VPUNPCKLDQ ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 62 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPUNPCKLDQ_XMM_K1Z_XMM_XMMM128B32: Code = 1501 # type: ignore
"""
``VPUNPCKLDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F.W0 62 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPUNPCKLDQ_YMM_K1Z_YMM_YMMM256B32: Code = 1502 # type: ignore
"""
``VPUNPCKLDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F.W0 62 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPUNPCKLDQ_ZMM_K1Z_ZMM_ZMMM512B32: Code = 1503 # type: ignore
"""
``VPUNPCKLDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F.W0 62 /r``

``AVX512F``

``16/32/64-bit``
"""
PACKSSWB_MM_MMM64: Code = 1504 # type: ignore
"""
``PACKSSWB mm1, mm2/m64``

``NP 0F 63 /r``

``MMX``

``16/32/64-bit``
"""
PACKSSWB_XMM_XMMM128: Code = 1505 # type: ignore
"""
``PACKSSWB xmm1, xmm2/m128``

``66 0F 63 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPACKSSWB_XMM_XMM_XMMM128: Code = 1506 # type: ignore
"""
``VPACKSSWB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 63 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPACKSSWB_YMM_YMM_YMMM256: Code = 1507 # type: ignore
"""
``VPACKSSWB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 63 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPACKSSWB_XMM_K1Z_XMM_XMMM128: Code = 1508 # type: ignore
"""
``VPACKSSWB xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG 63 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPACKSSWB_YMM_K1Z_YMM_YMMM256: Code = 1509 # type: ignore
"""
``VPACKSSWB ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG 63 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPACKSSWB_ZMM_K1Z_ZMM_ZMMM512: Code = 1510 # type: ignore
"""
``VPACKSSWB zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG 63 /r``

``AVX512BW``

``16/32/64-bit``
"""
PCMPGTB_MM_MMM64: Code = 1511 # type: ignore
"""
``PCMPGTB mm, mm/m64``

``NP 0F 64 /r``

``MMX``

``16/32/64-bit``
"""
PCMPGTB_XMM_XMMM128: Code = 1512 # type: ignore
"""
``PCMPGTB xmm1, xmm2/m128``

``66 0F 64 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPCMPGTB_XMM_XMM_XMMM128: Code = 1513 # type: ignore
"""
``VPCMPGTB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 64 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPCMPGTB_YMM_YMM_YMMM256: Code = 1514 # type: ignore
"""
``VPCMPGTB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 64 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPCMPGTB_KR_K1_XMM_XMMM128: Code = 1515 # type: ignore
"""
``VPCMPGTB k1 {k2}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG 64 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPGTB_KR_K1_YMM_YMMM256: Code = 1516 # type: ignore
"""
``VPCMPGTB k1 {k2}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG 64 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPGTB_KR_K1_ZMM_ZMMM512: Code = 1517 # type: ignore
"""
``VPCMPGTB k1 {k2}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG 64 /r``

``AVX512BW``

``16/32/64-bit``
"""
PCMPGTW_MM_MMM64: Code = 1518 # type: ignore
"""
``PCMPGTW mm, mm/m64``

``NP 0F 65 /r``

``MMX``

``16/32/64-bit``
"""
PCMPGTW_XMM_XMMM128: Code = 1519 # type: ignore
"""
``PCMPGTW xmm1, xmm2/m128``

``66 0F 65 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPCMPGTW_XMM_XMM_XMMM128: Code = 1520 # type: ignore
"""
``VPCMPGTW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 65 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPCMPGTW_YMM_YMM_YMMM256: Code = 1521 # type: ignore
"""
``VPCMPGTW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 65 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPCMPGTW_KR_K1_XMM_XMMM128: Code = 1522 # type: ignore
"""
``VPCMPGTW k1 {k2}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG 65 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPGTW_KR_K1_YMM_YMMM256: Code = 1523 # type: ignore
"""
``VPCMPGTW k1 {k2}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG 65 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPGTW_KR_K1_ZMM_ZMMM512: Code = 1524 # type: ignore
"""
``VPCMPGTW k1 {k2}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG 65 /r``

``AVX512BW``

``16/32/64-bit``
"""
PCMPGTD_MM_MMM64: Code = 1525 # type: ignore
"""
``PCMPGTD mm, mm/m64``

``NP 0F 66 /r``

``MMX``

``16/32/64-bit``
"""
PCMPGTD_XMM_XMMM128: Code = 1526 # type: ignore
"""
``PCMPGTD xmm1, xmm2/m128``

``66 0F 66 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPCMPGTD_XMM_XMM_XMMM128: Code = 1527 # type: ignore
"""
``VPCMPGTD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 66 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPCMPGTD_YMM_YMM_YMMM256: Code = 1528 # type: ignore
"""
``VPCMPGTD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 66 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPCMPGTD_KR_K1_XMM_XMMM128B32: Code = 1529 # type: ignore
"""
``VPCMPGTD k1 {k2}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F.W0 66 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPGTD_KR_K1_YMM_YMMM256B32: Code = 1530 # type: ignore
"""
``VPCMPGTD k1 {k2}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F.W0 66 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPGTD_KR_K1_ZMM_ZMMM512B32: Code = 1531 # type: ignore
"""
``VPCMPGTD k1 {k2}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F.W0 66 /r``

``AVX512F``

``16/32/64-bit``
"""
PACKUSWB_MM_MMM64: Code = 1532 # type: ignore
"""
``PACKUSWB mm, mm/m64``

``NP 0F 67 /r``

``MMX``

``16/32/64-bit``
"""
PACKUSWB_XMM_XMMM128: Code = 1533 # type: ignore
"""
``PACKUSWB xmm1, xmm2/m128``

``66 0F 67 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPACKUSWB_XMM_XMM_XMMM128: Code = 1534 # type: ignore
"""
``VPACKUSWB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 67 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPACKUSWB_YMM_YMM_YMMM256: Code = 1535 # type: ignore
"""
``VPACKUSWB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 67 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPACKUSWB_XMM_K1Z_XMM_XMMM128: Code = 1536 # type: ignore
"""
``VPACKUSWB xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG 67 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPACKUSWB_YMM_K1Z_YMM_YMMM256: Code = 1537 # type: ignore
"""
``VPACKUSWB ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG 67 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPACKUSWB_ZMM_K1Z_ZMM_ZMMM512: Code = 1538 # type: ignore
"""
``VPACKUSWB zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG 67 /r``

``AVX512BW``

``16/32/64-bit``
"""
PUNPCKHBW_MM_MMM64: Code = 1539 # type: ignore
"""
``PUNPCKHBW mm, mm/m64``

``NP 0F 68 /r``

``MMX``

``16/32/64-bit``
"""
PUNPCKHBW_XMM_XMMM128: Code = 1540 # type: ignore
"""
``PUNPCKHBW xmm1, xmm2/m128``

``66 0F 68 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPUNPCKHBW_XMM_XMM_XMMM128: Code = 1541 # type: ignore
"""
``VPUNPCKHBW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 68 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPUNPCKHBW_YMM_YMM_YMMM256: Code = 1542 # type: ignore
"""
``VPUNPCKHBW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 68 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPUNPCKHBW_XMM_K1Z_XMM_XMMM128: Code = 1543 # type: ignore
"""
``VPUNPCKHBW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG 68 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPUNPCKHBW_YMM_K1Z_YMM_YMMM256: Code = 1544 # type: ignore
"""
``VPUNPCKHBW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG 68 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPUNPCKHBW_ZMM_K1Z_ZMM_ZMMM512: Code = 1545 # type: ignore
"""
``VPUNPCKHBW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG 68 /r``

``AVX512BW``

``16/32/64-bit``
"""
PUNPCKHWD_MM_MMM64: Code = 1546 # type: ignore
"""
``PUNPCKHWD mm, mm/m64``

``NP 0F 69 /r``

``MMX``

``16/32/64-bit``
"""
PUNPCKHWD_XMM_XMMM128: Code = 1547 # type: ignore
"""
``PUNPCKHWD xmm1, xmm2/m128``

``66 0F 69 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPUNPCKHWD_XMM_XMM_XMMM128: Code = 1548 # type: ignore
"""
``VPUNPCKHWD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 69 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPUNPCKHWD_YMM_YMM_YMMM256: Code = 1549 # type: ignore
"""
``VPUNPCKHWD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 69 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPUNPCKHWD_XMM_K1Z_XMM_XMMM128: Code = 1550 # type: ignore
"""
``VPUNPCKHWD xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG 69 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPUNPCKHWD_YMM_K1Z_YMM_YMMM256: Code = 1551 # type: ignore
"""
``VPUNPCKHWD ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG 69 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPUNPCKHWD_ZMM_K1Z_ZMM_ZMMM512: Code = 1552 # type: ignore
"""
``VPUNPCKHWD zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG 69 /r``

``AVX512BW``

``16/32/64-bit``
"""
PUNPCKHDQ_MM_MMM64: Code = 1553 # type: ignore
"""
``PUNPCKHDQ mm, mm/m64``

``NP 0F 6A /r``

``MMX``

``16/32/64-bit``
"""
PUNPCKHDQ_XMM_XMMM128: Code = 1554 # type: ignore
"""
``PUNPCKHDQ xmm1, xmm2/m128``

``66 0F 6A /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPUNPCKHDQ_XMM_XMM_XMMM128: Code = 1555 # type: ignore
"""
``VPUNPCKHDQ xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 6A /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPUNPCKHDQ_YMM_YMM_YMMM256: Code = 1556 # type: ignore
"""
``VPUNPCKHDQ ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 6A /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPUNPCKHDQ_XMM_K1Z_XMM_XMMM128B32: Code = 1557 # type: ignore
"""
``VPUNPCKHDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F.W0 6A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPUNPCKHDQ_YMM_K1Z_YMM_YMMM256B32: Code = 1558 # type: ignore
"""
``VPUNPCKHDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F.W0 6A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPUNPCKHDQ_ZMM_K1Z_ZMM_ZMMM512B32: Code = 1559 # type: ignore
"""
``VPUNPCKHDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F.W0 6A /r``

``AVX512F``

``16/32/64-bit``
"""
PACKSSDW_MM_MMM64: Code = 1560 # type: ignore
"""
``PACKSSDW mm1, mm2/m64``

``NP 0F 6B /r``

``MMX``

``16/32/64-bit``
"""
PACKSSDW_XMM_XMMM128: Code = 1561 # type: ignore
"""
``PACKSSDW xmm1, xmm2/m128``

``66 0F 6B /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPACKSSDW_XMM_XMM_XMMM128: Code = 1562 # type: ignore
"""
``VPACKSSDW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 6B /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPACKSSDW_YMM_YMM_YMMM256: Code = 1563 # type: ignore
"""
``VPACKSSDW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 6B /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPACKSSDW_XMM_K1Z_XMM_XMMM128B32: Code = 1564 # type: ignore
"""
``VPACKSSDW xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F.W0 6B /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPACKSSDW_YMM_K1Z_YMM_YMMM256B32: Code = 1565 # type: ignore
"""
``VPACKSSDW ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F.W0 6B /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPACKSSDW_ZMM_K1Z_ZMM_ZMMM512B32: Code = 1566 # type: ignore
"""
``VPACKSSDW zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F.W0 6B /r``

``AVX512BW``

``16/32/64-bit``
"""
PUNPCKLQDQ_XMM_XMMM128: Code = 1567 # type: ignore
"""
``PUNPCKLQDQ xmm1, xmm2/m128``

``66 0F 6C /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPUNPCKLQDQ_XMM_XMM_XMMM128: Code = 1568 # type: ignore
"""
``VPUNPCKLQDQ xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 6C /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPUNPCKLQDQ_YMM_YMM_YMMM256: Code = 1569 # type: ignore
"""
``VPUNPCKLQDQ ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 6C /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPUNPCKLQDQ_XMM_K1Z_XMM_XMMM128B64: Code = 1570 # type: ignore
"""
``VPUNPCKLQDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 6C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPUNPCKLQDQ_YMM_K1Z_YMM_YMMM256B64: Code = 1571 # type: ignore
"""
``VPUNPCKLQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 6C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPUNPCKLQDQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 1572 # type: ignore
"""
``VPUNPCKLQDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F.W1 6C /r``

``AVX512F``

``16/32/64-bit``
"""
PUNPCKHQDQ_XMM_XMMM128: Code = 1573 # type: ignore
"""
``PUNPCKHQDQ xmm1, xmm2/m128``

``66 0F 6D /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPUNPCKHQDQ_XMM_XMM_XMMM128: Code = 1574 # type: ignore
"""
``VPUNPCKHQDQ xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 6D /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPUNPCKHQDQ_YMM_YMM_YMMM256: Code = 1575 # type: ignore
"""
``VPUNPCKHQDQ ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 6D /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPUNPCKHQDQ_XMM_K1Z_XMM_XMMM128B64: Code = 1576 # type: ignore
"""
``VPUNPCKHQDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 6D /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPUNPCKHQDQ_YMM_K1Z_YMM_YMMM256B64: Code = 1577 # type: ignore
"""
``VPUNPCKHQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 6D /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPUNPCKHQDQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 1578 # type: ignore
"""
``VPUNPCKHQDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F.W1 6D /r``

``AVX512F``

``16/32/64-bit``
"""
MOVD_MM_RM32: Code = 1579 # type: ignore
"""
``MOVD mm, r/m32``

``NP 0F 6E /r``

``MMX``

``16/32/64-bit``
"""
MOVQ_MM_RM64: Code = 1580 # type: ignore
"""
``MOVQ mm, r/m64``

``NP o64 0F 6E /r``

``MMX``

``64-bit``
"""
MOVD_XMM_RM32: Code = 1581 # type: ignore
"""
``MOVD xmm, r/m32``

``66 0F 6E /r``

``SSE2``

``16/32/64-bit``
"""
MOVQ_XMM_RM64: Code = 1582 # type: ignore
"""
``MOVQ xmm, r/m64``

``66 o64 0F 6E /r``

``SSE2``

``64-bit``
"""
VEX_VMOVD_XMM_RM32: Code = 1583 # type: ignore
"""
``VMOVD xmm1, r/m32``

``VEX.128.66.0F.W0 6E /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVQ_XMM_RM64: Code = 1584 # type: ignore
"""
``VMOVQ xmm1, r/m64``

``VEX.128.66.0F.W1 6E /r``

``AVX``

``64-bit``
"""
EVEX_VMOVD_XMM_RM32: Code = 1585 # type: ignore
"""
``VMOVD xmm1, r/m32``

``EVEX.128.66.0F.W0 6E /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVQ_XMM_RM64: Code = 1586 # type: ignore
"""
``VMOVQ xmm1, r/m64``

``EVEX.128.66.0F.W1 6E /r``

``AVX512F``

``64-bit``
"""
MOVQ_MM_MMM64: Code = 1587 # type: ignore
"""
``MOVQ mm, mm/m64``

``NP 0F 6F /r``

``MMX``

``16/32/64-bit``
"""
MOVDQA_XMM_XMMM128: Code = 1588 # type: ignore
"""
``MOVDQA xmm1, xmm2/m128``

``66 0F 6F /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVDQA_XMM_XMMM128: Code = 1589 # type: ignore
"""
``VMOVDQA xmm1, xmm2/m128``

``VEX.128.66.0F.WIG 6F /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVDQA_YMM_YMMM256: Code = 1590 # type: ignore
"""
``VMOVDQA ymm1, ymm2/m256``

``VEX.256.66.0F.WIG 6F /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVDQA32_XMM_K1Z_XMMM128: Code = 1591 # type: ignore
"""
``VMOVDQA32 xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.66.0F.W0 6F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQA32_YMM_K1Z_YMMM256: Code = 1592 # type: ignore
"""
``VMOVDQA32 ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.66.0F.W0 6F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQA32_ZMM_K1Z_ZMMM512: Code = 1593 # type: ignore
"""
``VMOVDQA32 zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.66.0F.W0 6F /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQA64_XMM_K1Z_XMMM128: Code = 1594 # type: ignore
"""
``VMOVDQA64 xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.66.0F.W1 6F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQA64_YMM_K1Z_YMMM256: Code = 1595 # type: ignore
"""
``VMOVDQA64 ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.66.0F.W1 6F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQA64_ZMM_K1Z_ZMMM512: Code = 1596 # type: ignore
"""
``VMOVDQA64 zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.66.0F.W1 6F /r``

``AVX512F``

``16/32/64-bit``
"""
MOVDQU_XMM_XMMM128: Code = 1597 # type: ignore
"""
``MOVDQU xmm1, xmm2/m128``

``F3 0F 6F /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVDQU_XMM_XMMM128: Code = 1598 # type: ignore
"""
``VMOVDQU xmm1, xmm2/m128``

``VEX.128.F3.0F.WIG 6F /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVDQU_YMM_YMMM256: Code = 1599 # type: ignore
"""
``VMOVDQU ymm1, ymm2/m256``

``VEX.256.F3.0F.WIG 6F /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVDQU32_XMM_K1Z_XMMM128: Code = 1600 # type: ignore
"""
``VMOVDQU32 xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.F3.0F.W0 6F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQU32_YMM_K1Z_YMMM256: Code = 1601 # type: ignore
"""
``VMOVDQU32 ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.F3.0F.W0 6F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQU32_ZMM_K1Z_ZMMM512: Code = 1602 # type: ignore
"""
``VMOVDQU32 zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.F3.0F.W0 6F /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQU64_XMM_K1Z_XMMM128: Code = 1603 # type: ignore
"""
``VMOVDQU64 xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.F3.0F.W1 6F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQU64_YMM_K1Z_YMMM256: Code = 1604 # type: ignore
"""
``VMOVDQU64 ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.F3.0F.W1 6F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQU64_ZMM_K1Z_ZMMM512: Code = 1605 # type: ignore
"""
``VMOVDQU64 zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.F3.0F.W1 6F /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQU8_XMM_K1Z_XMMM128: Code = 1606 # type: ignore
"""
``VMOVDQU8 xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.F2.0F.W0 6F /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VMOVDQU8_YMM_K1Z_YMMM256: Code = 1607 # type: ignore
"""
``VMOVDQU8 ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.F2.0F.W0 6F /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VMOVDQU8_ZMM_K1Z_ZMMM512: Code = 1608 # type: ignore
"""
``VMOVDQU8 zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.F2.0F.W0 6F /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VMOVDQU16_XMM_K1Z_XMMM128: Code = 1609 # type: ignore
"""
``VMOVDQU16 xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.F2.0F.W1 6F /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VMOVDQU16_YMM_K1Z_YMMM256: Code = 1610 # type: ignore
"""
``VMOVDQU16 ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.F2.0F.W1 6F /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VMOVDQU16_ZMM_K1Z_ZMMM512: Code = 1611 # type: ignore
"""
``VMOVDQU16 zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.F2.0F.W1 6F /r``

``AVX512BW``

``16/32/64-bit``
"""
PSHUFW_MM_MMM64_IMM8: Code = 1612 # type: ignore
"""
``PSHUFW mm1, mm2/m64, imm8``

``NP 0F 70 /r ib``

``SSE``

``16/32/64-bit``
"""
PSHUFD_XMM_XMMM128_IMM8: Code = 1613 # type: ignore
"""
``PSHUFD xmm1, xmm2/m128, imm8``

``66 0F 70 /r ib``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSHUFD_XMM_XMMM128_IMM8: Code = 1614 # type: ignore
"""
``VPSHUFD xmm1, xmm2/m128, imm8``

``VEX.128.66.0F.WIG 70 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPSHUFD_YMM_YMMM256_IMM8: Code = 1615 # type: ignore
"""
``VPSHUFD ymm1, ymm2/m256, imm8``

``VEX.256.66.0F.WIG 70 /r ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSHUFD_XMM_K1Z_XMMM128B32_IMM8: Code = 1616 # type: ignore
"""
``VPSHUFD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8``

``EVEX.128.66.0F.W0 70 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSHUFD_YMM_K1Z_YMMM256B32_IMM8: Code = 1617 # type: ignore
"""
``VPSHUFD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8``

``EVEX.256.66.0F.W0 70 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSHUFD_ZMM_K1Z_ZMMM512B32_IMM8: Code = 1618 # type: ignore
"""
``VPSHUFD zmm1 {k1}{z}, zmm2/m512/m32bcst, imm8``

``EVEX.512.66.0F.W0 70 /r ib``

``AVX512F``

``16/32/64-bit``
"""
PSHUFHW_XMM_XMMM128_IMM8: Code = 1619 # type: ignore
"""
``PSHUFHW xmm1, xmm2/m128, imm8``

``F3 0F 70 /r ib``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSHUFHW_XMM_XMMM128_IMM8: Code = 1620 # type: ignore
"""
``VPSHUFHW xmm1, xmm2/m128, imm8``

``VEX.128.F3.0F.WIG 70 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPSHUFHW_YMM_YMMM256_IMM8: Code = 1621 # type: ignore
"""
``VPSHUFHW ymm1, ymm2/m256, imm8``

``VEX.256.F3.0F.WIG 70 /r ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSHUFHW_XMM_K1Z_XMMM128_IMM8: Code = 1622 # type: ignore
"""
``VPSHUFHW xmm1 {k1}{z}, xmm2/m128, imm8``

``EVEX.128.F3.0F.WIG 70 /r ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSHUFHW_YMM_K1Z_YMMM256_IMM8: Code = 1623 # type: ignore
"""
``VPSHUFHW ymm1 {k1}{z}, ymm2/m256, imm8``

``EVEX.256.F3.0F.WIG 70 /r ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSHUFHW_ZMM_K1Z_ZMMM512_IMM8: Code = 1624 # type: ignore
"""
``VPSHUFHW zmm1 {k1}{z}, zmm2/m512, imm8``

``EVEX.512.F3.0F.WIG 70 /r ib``

``AVX512BW``

``16/32/64-bit``
"""
PSHUFLW_XMM_XMMM128_IMM8: Code = 1625 # type: ignore
"""
``PSHUFLW xmm1, xmm2/m128, imm8``

``F2 0F 70 /r ib``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSHUFLW_XMM_XMMM128_IMM8: Code = 1626 # type: ignore
"""
``VPSHUFLW xmm1, xmm2/m128, imm8``

``VEX.128.F2.0F.WIG 70 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPSHUFLW_YMM_YMMM256_IMM8: Code = 1627 # type: ignore
"""
``VPSHUFLW ymm1, ymm2/m256, imm8``

``VEX.256.F2.0F.WIG 70 /r ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSHUFLW_XMM_K1Z_XMMM128_IMM8: Code = 1628 # type: ignore
"""
``VPSHUFLW xmm1 {k1}{z}, xmm2/m128, imm8``

``EVEX.128.F2.0F.WIG 70 /r ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSHUFLW_YMM_K1Z_YMMM256_IMM8: Code = 1629 # type: ignore
"""
``VPSHUFLW ymm1 {k1}{z}, ymm2/m256, imm8``

``EVEX.256.F2.0F.WIG 70 /r ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSHUFLW_ZMM_K1Z_ZMMM512_IMM8: Code = 1630 # type: ignore
"""
``VPSHUFLW zmm1 {k1}{z}, zmm2/m512, imm8``

``EVEX.512.F2.0F.WIG 70 /r ib``

``AVX512BW``

``16/32/64-bit``
"""
PSRLW_MM_IMM8: Code = 1631 # type: ignore
"""
``PSRLW mm, imm8``

``NP 0F 71 /2 ib``

``MMX``

``16/32/64-bit``
"""
PSRLW_XMM_IMM8: Code = 1632 # type: ignore
"""
``PSRLW xmm1, imm8``

``66 0F 71 /2 ib``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSRLW_XMM_XMM_IMM8: Code = 1633 # type: ignore
"""
``VPSRLW xmm1, xmm2, imm8``

``VEX.128.66.0F.WIG 71 /2 ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPSRLW_YMM_YMM_IMM8: Code = 1634 # type: ignore
"""
``VPSRLW ymm1, ymm2, imm8``

``VEX.256.66.0F.WIG 71 /2 ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSRLW_XMM_K1Z_XMMM128_IMM8: Code = 1635 # type: ignore
"""
``VPSRLW xmm1 {k1}{z}, xmm2/m128, imm8``

``EVEX.128.66.0F.WIG 71 /2 ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSRLW_YMM_K1Z_YMMM256_IMM8: Code = 1636 # type: ignore
"""
``VPSRLW ymm1 {k1}{z}, ymm2/m256, imm8``

``EVEX.256.66.0F.WIG 71 /2 ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSRLW_ZMM_K1Z_ZMMM512_IMM8: Code = 1637 # type: ignore
"""
``VPSRLW zmm1 {k1}{z}, zmm2/m512, imm8``

``EVEX.512.66.0F.WIG 71 /2 ib``

``AVX512BW``

``16/32/64-bit``
"""
PSRAW_MM_IMM8: Code = 1638 # type: ignore
"""
``PSRAW mm, imm8``

``NP 0F 71 /4 ib``

``MMX``

``16/32/64-bit``
"""
PSRAW_XMM_IMM8: Code = 1639 # type: ignore
"""
``PSRAW xmm1, imm8``

``66 0F 71 /4 ib``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSRAW_XMM_XMM_IMM8: Code = 1640 # type: ignore
"""
``VPSRAW xmm1, xmm2, imm8``

``VEX.128.66.0F.WIG 71 /4 ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPSRAW_YMM_YMM_IMM8: Code = 1641 # type: ignore
"""
``VPSRAW ymm1, ymm2, imm8``

``VEX.256.66.0F.WIG 71 /4 ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSRAW_XMM_K1Z_XMMM128_IMM8: Code = 1642 # type: ignore
"""
``VPSRAW xmm1 {k1}{z}, xmm2/m128, imm8``

``EVEX.128.66.0F.WIG 71 /4 ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSRAW_YMM_K1Z_YMMM256_IMM8: Code = 1643 # type: ignore
"""
``VPSRAW ymm1 {k1}{z}, ymm2/m256, imm8``

``EVEX.256.66.0F.WIG 71 /4 ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSRAW_ZMM_K1Z_ZMMM512_IMM8: Code = 1644 # type: ignore
"""
``VPSRAW zmm1 {k1}{z}, zmm2/m512, imm8``

``EVEX.512.66.0F.WIG 71 /4 ib``

``AVX512BW``

``16/32/64-bit``
"""
PSLLW_MM_IMM8: Code = 1645 # type: ignore
"""
``PSLLW mm1, imm8``

``NP 0F 71 /6 ib``

``MMX``

``16/32/64-bit``
"""
PSLLW_XMM_IMM8: Code = 1646 # type: ignore
"""
``PSLLW xmm1, imm8``

``66 0F 71 /6 ib``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSLLW_XMM_XMM_IMM8: Code = 1647 # type: ignore
"""
``VPSLLW xmm1, xmm2, imm8``

``VEX.128.66.0F.WIG 71 /6 ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPSLLW_YMM_YMM_IMM8: Code = 1648 # type: ignore
"""
``VPSLLW ymm1, ymm2, imm8``

``VEX.256.66.0F.WIG 71 /6 ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSLLW_XMM_K1Z_XMMM128_IMM8: Code = 1649 # type: ignore
"""
``VPSLLW xmm1 {k1}{z}, xmm2/m128, imm8``

``EVEX.128.66.0F.WIG 71 /6 ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSLLW_YMM_K1Z_YMMM256_IMM8: Code = 1650 # type: ignore
"""
``VPSLLW ymm1 {k1}{z}, ymm2/m256, imm8``

``EVEX.256.66.0F.WIG 71 /6 ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSLLW_ZMM_K1Z_ZMMM512_IMM8: Code = 1651 # type: ignore
"""
``VPSLLW zmm1 {k1}{z}, zmm2/m512, imm8``

``EVEX.512.66.0F.WIG 71 /6 ib``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPRORD_XMM_K1Z_XMMM128B32_IMM8: Code = 1652 # type: ignore
"""
``VPRORD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8``

``EVEX.128.66.0F.W0 72 /0 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPRORD_YMM_K1Z_YMMM256B32_IMM8: Code = 1653 # type: ignore
"""
``VPRORD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8``

``EVEX.256.66.0F.W0 72 /0 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPRORD_ZMM_K1Z_ZMMM512B32_IMM8: Code = 1654 # type: ignore
"""
``VPRORD zmm1 {k1}{z}, zmm2/m512/m32bcst, imm8``

``EVEX.512.66.0F.W0 72 /0 ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPRORQ_XMM_K1Z_XMMM128B64_IMM8: Code = 1655 # type: ignore
"""
``VPRORQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8``

``EVEX.128.66.0F.W1 72 /0 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPRORQ_YMM_K1Z_YMMM256B64_IMM8: Code = 1656 # type: ignore
"""
``VPRORQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8``

``EVEX.256.66.0F.W1 72 /0 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPRORQ_ZMM_K1Z_ZMMM512B64_IMM8: Code = 1657 # type: ignore
"""
``VPRORQ zmm1 {k1}{z}, zmm2/m512/m64bcst, imm8``

``EVEX.512.66.0F.W1 72 /0 ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPROLD_XMM_K1Z_XMMM128B32_IMM8: Code = 1658 # type: ignore
"""
``VPROLD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8``

``EVEX.128.66.0F.W0 72 /1 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPROLD_YMM_K1Z_YMMM256B32_IMM8: Code = 1659 # type: ignore
"""
``VPROLD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8``

``EVEX.256.66.0F.W0 72 /1 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPROLD_ZMM_K1Z_ZMMM512B32_IMM8: Code = 1660 # type: ignore
"""
``VPROLD zmm1 {k1}{z}, zmm2/m512/m32bcst, imm8``

``EVEX.512.66.0F.W0 72 /1 ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPROLQ_XMM_K1Z_XMMM128B64_IMM8: Code = 1661 # type: ignore
"""
``VPROLQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8``

``EVEX.128.66.0F.W1 72 /1 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPROLQ_YMM_K1Z_YMMM256B64_IMM8: Code = 1662 # type: ignore
"""
``VPROLQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8``

``EVEX.256.66.0F.W1 72 /1 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPROLQ_ZMM_K1Z_ZMMM512B64_IMM8: Code = 1663 # type: ignore
"""
``VPROLQ zmm1 {k1}{z}, zmm2/m512/m64bcst, imm8``

``EVEX.512.66.0F.W1 72 /1 ib``

``AVX512F``

``16/32/64-bit``
"""
PSRLD_MM_IMM8: Code = 1664 # type: ignore
"""
``PSRLD mm, imm8``

``NP 0F 72 /2 ib``

``MMX``

``16/32/64-bit``
"""
PSRLD_XMM_IMM8: Code = 1665 # type: ignore
"""
``PSRLD xmm1, imm8``

``66 0F 72 /2 ib``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSRLD_XMM_XMM_IMM8: Code = 1666 # type: ignore
"""
``VPSRLD xmm1, xmm2, imm8``

``VEX.128.66.0F.WIG 72 /2 ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPSRLD_YMM_YMM_IMM8: Code = 1667 # type: ignore
"""
``VPSRLD ymm1, ymm2, imm8``

``VEX.256.66.0F.WIG 72 /2 ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSRLD_XMM_K1Z_XMMM128B32_IMM8: Code = 1668 # type: ignore
"""
``VPSRLD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8``

``EVEX.128.66.0F.W0 72 /2 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRLD_YMM_K1Z_YMMM256B32_IMM8: Code = 1669 # type: ignore
"""
``VPSRLD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8``

``EVEX.256.66.0F.W0 72 /2 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRLD_ZMM_K1Z_ZMMM512B32_IMM8: Code = 1670 # type: ignore
"""
``VPSRLD zmm1 {k1}{z}, zmm2/m512/m32bcst, imm8``

``EVEX.512.66.0F.W0 72 /2 ib``

``AVX512F``

``16/32/64-bit``
"""
PSRAD_MM_IMM8: Code = 1671 # type: ignore
"""
``PSRAD mm, imm8``

``NP 0F 72 /4 ib``

``MMX``

``16/32/64-bit``
"""
PSRAD_XMM_IMM8: Code = 1672 # type: ignore
"""
``PSRAD xmm1, imm8``

``66 0F 72 /4 ib``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSRAD_XMM_XMM_IMM8: Code = 1673 # type: ignore
"""
``VPSRAD xmm1, xmm2, imm8``

``VEX.128.66.0F.WIG 72 /4 ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPSRAD_YMM_YMM_IMM8: Code = 1674 # type: ignore
"""
``VPSRAD ymm1, ymm2, imm8``

``VEX.256.66.0F.WIG 72 /4 ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSRAD_XMM_K1Z_XMMM128B32_IMM8: Code = 1675 # type: ignore
"""
``VPSRAD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8``

``EVEX.128.66.0F.W0 72 /4 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRAD_YMM_K1Z_YMMM256B32_IMM8: Code = 1676 # type: ignore
"""
``VPSRAD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8``

``EVEX.256.66.0F.W0 72 /4 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRAD_ZMM_K1Z_ZMMM512B32_IMM8: Code = 1677 # type: ignore
"""
``VPSRAD zmm1 {k1}{z}, zmm2/m512/m32bcst, imm8``

``EVEX.512.66.0F.W0 72 /4 ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRAQ_XMM_K1Z_XMMM128B64_IMM8: Code = 1678 # type: ignore
"""
``VPSRAQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8``

``EVEX.128.66.0F.W1 72 /4 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRAQ_YMM_K1Z_YMMM256B64_IMM8: Code = 1679 # type: ignore
"""
``VPSRAQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8``

``EVEX.256.66.0F.W1 72 /4 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRAQ_ZMM_K1Z_ZMMM512B64_IMM8: Code = 1680 # type: ignore
"""
``VPSRAQ zmm1 {k1}{z}, zmm2/m512/m64bcst, imm8``

``EVEX.512.66.0F.W1 72 /4 ib``

``AVX512F``

``16/32/64-bit``
"""
PSLLD_MM_IMM8: Code = 1681 # type: ignore
"""
``PSLLD mm, imm8``

``NP 0F 72 /6 ib``

``MMX``

``16/32/64-bit``
"""
PSLLD_XMM_IMM8: Code = 1682 # type: ignore
"""
``PSLLD xmm1, imm8``

``66 0F 72 /6 ib``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSLLD_XMM_XMM_IMM8: Code = 1683 # type: ignore
"""
``VPSLLD xmm1, xmm2, imm8``

``VEX.128.66.0F.WIG 72 /6 ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPSLLD_YMM_YMM_IMM8: Code = 1684 # type: ignore
"""
``VPSLLD ymm1, ymm2, imm8``

``VEX.256.66.0F.WIG 72 /6 ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSLLD_XMM_K1Z_XMMM128B32_IMM8: Code = 1685 # type: ignore
"""
``VPSLLD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8``

``EVEX.128.66.0F.W0 72 /6 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSLLD_YMM_K1Z_YMMM256B32_IMM8: Code = 1686 # type: ignore
"""
``VPSLLD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8``

``EVEX.256.66.0F.W0 72 /6 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSLLD_ZMM_K1Z_ZMMM512B32_IMM8: Code = 1687 # type: ignore
"""
``VPSLLD zmm1 {k1}{z}, zmm2/m512/m32bcst, imm8``

``EVEX.512.66.0F.W0 72 /6 ib``

``AVX512F``

``16/32/64-bit``
"""
PSRLQ_MM_IMM8: Code = 1688 # type: ignore
"""
``PSRLQ mm, imm8``

``NP 0F 73 /2 ib``

``MMX``

``16/32/64-bit``
"""
PSRLQ_XMM_IMM8: Code = 1689 # type: ignore
"""
``PSRLQ xmm1, imm8``

``66 0F 73 /2 ib``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSRLQ_XMM_XMM_IMM8: Code = 1690 # type: ignore
"""
``VPSRLQ xmm1, xmm2, imm8``

``VEX.128.66.0F.WIG 73 /2 ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPSRLQ_YMM_YMM_IMM8: Code = 1691 # type: ignore
"""
``VPSRLQ ymm1, ymm2, imm8``

``VEX.256.66.0F.WIG 73 /2 ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSRLQ_XMM_K1Z_XMMM128B64_IMM8: Code = 1692 # type: ignore
"""
``VPSRLQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8``

``EVEX.128.66.0F.W1 73 /2 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRLQ_YMM_K1Z_YMMM256B64_IMM8: Code = 1693 # type: ignore
"""
``VPSRLQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8``

``EVEX.256.66.0F.W1 73 /2 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRLQ_ZMM_K1Z_ZMMM512B64_IMM8: Code = 1694 # type: ignore
"""
``VPSRLQ zmm1 {k1}{z}, zmm2/m512/m64bcst, imm8``

``EVEX.512.66.0F.W1 73 /2 ib``

``AVX512F``

``16/32/64-bit``
"""
PSRLDQ_XMM_IMM8: Code = 1695 # type: ignore
"""
``PSRLDQ xmm1, imm8``

``66 0F 73 /3 ib``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSRLDQ_XMM_XMM_IMM8: Code = 1696 # type: ignore
"""
``VPSRLDQ xmm1, xmm2, imm8``

``VEX.128.66.0F.WIG 73 /3 ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPSRLDQ_YMM_YMM_IMM8: Code = 1697 # type: ignore
"""
``VPSRLDQ ymm1, ymm2, imm8``

``VEX.256.66.0F.WIG 73 /3 ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSRLDQ_XMM_XMMM128_IMM8: Code = 1698 # type: ignore
"""
``VPSRLDQ xmm1, xmm2/m128, imm8``

``EVEX.128.66.0F.WIG 73 /3 ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSRLDQ_YMM_YMMM256_IMM8: Code = 1699 # type: ignore
"""
``VPSRLDQ ymm1, ymm2/m256, imm8``

``EVEX.256.66.0F.WIG 73 /3 ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSRLDQ_ZMM_ZMMM512_IMM8: Code = 1700 # type: ignore
"""
``VPSRLDQ zmm1, zmm2/m512, imm8``

``EVEX.512.66.0F.WIG 73 /3 ib``

``AVX512BW``

``16/32/64-bit``
"""
PSLLQ_MM_IMM8: Code = 1701 # type: ignore
"""
``PSLLQ mm, imm8``

``NP 0F 73 /6 ib``

``MMX``

``16/32/64-bit``
"""
PSLLQ_XMM_IMM8: Code = 1702 # type: ignore
"""
``PSLLQ xmm1, imm8``

``66 0F 73 /6 ib``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSLLQ_XMM_XMM_IMM8: Code = 1703 # type: ignore
"""
``VPSLLQ xmm1, xmm2, imm8``

``VEX.128.66.0F.WIG 73 /6 ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPSLLQ_YMM_YMM_IMM8: Code = 1704 # type: ignore
"""
``VPSLLQ ymm1, ymm2, imm8``

``VEX.256.66.0F.WIG 73 /6 ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSLLQ_XMM_K1Z_XMMM128B64_IMM8: Code = 1705 # type: ignore
"""
``VPSLLQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8``

``EVEX.128.66.0F.W1 73 /6 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSLLQ_YMM_K1Z_YMMM256B64_IMM8: Code = 1706 # type: ignore
"""
``VPSLLQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8``

``EVEX.256.66.0F.W1 73 /6 ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSLLQ_ZMM_K1Z_ZMMM512B64_IMM8: Code = 1707 # type: ignore
"""
``VPSLLQ zmm1 {k1}{z}, zmm2/m512/m64bcst, imm8``

``EVEX.512.66.0F.W1 73 /6 ib``

``AVX512F``

``16/32/64-bit``
"""
PSLLDQ_XMM_IMM8: Code = 1708 # type: ignore
"""
``PSLLDQ xmm1, imm8``

``66 0F 73 /7 ib``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSLLDQ_XMM_XMM_IMM8: Code = 1709 # type: ignore
"""
``VPSLLDQ xmm1, xmm2, imm8``

``VEX.128.66.0F.WIG 73 /7 ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPSLLDQ_YMM_YMM_IMM8: Code = 1710 # type: ignore
"""
``VPSLLDQ ymm1, ymm2, imm8``

``VEX.256.66.0F.WIG 73 /7 ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSLLDQ_XMM_XMMM128_IMM8: Code = 1711 # type: ignore
"""
``VPSLLDQ xmm1, xmm2/m128, imm8``

``EVEX.128.66.0F.WIG 73 /7 ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSLLDQ_YMM_YMMM256_IMM8: Code = 1712 # type: ignore
"""
``VPSLLDQ ymm1, ymm2/m256, imm8``

``EVEX.256.66.0F.WIG 73 /7 ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSLLDQ_ZMM_ZMMM512_IMM8: Code = 1713 # type: ignore
"""
``VPSLLDQ zmm1, zmm2/m512, imm8``

``EVEX.512.66.0F.WIG 73 /7 ib``

``AVX512BW``

``16/32/64-bit``
"""
PCMPEQB_MM_MMM64: Code = 1714 # type: ignore
"""
``PCMPEQB mm, mm/m64``

``NP 0F 74 /r``

``MMX``

``16/32/64-bit``
"""
PCMPEQB_XMM_XMMM128: Code = 1715 # type: ignore
"""
``PCMPEQB xmm1, xmm2/m128``

``66 0F 74 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPCMPEQB_XMM_XMM_XMMM128: Code = 1716 # type: ignore
"""
``VPCMPEQB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 74 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPCMPEQB_YMM_YMM_YMMM256: Code = 1717 # type: ignore
"""
``VPCMPEQB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 74 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPCMPEQB_KR_K1_XMM_XMMM128: Code = 1718 # type: ignore
"""
``VPCMPEQB k1 {k2}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG 74 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPEQB_KR_K1_YMM_YMMM256: Code = 1719 # type: ignore
"""
``VPCMPEQB k1 {k2}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG 74 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPEQB_KR_K1_ZMM_ZMMM512: Code = 1720 # type: ignore
"""
``VPCMPEQB k1 {k2}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG 74 /r``

``AVX512BW``

``16/32/64-bit``
"""
PCMPEQW_MM_MMM64: Code = 1721 # type: ignore
"""
``PCMPEQW mm, mm/m64``

``NP 0F 75 /r``

``MMX``

``16/32/64-bit``
"""
PCMPEQW_XMM_XMMM128: Code = 1722 # type: ignore
"""
``PCMPEQW xmm1, xmm2/m128``

``66 0F 75 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPCMPEQW_XMM_XMM_XMMM128: Code = 1723 # type: ignore
"""
``VPCMPEQW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 75 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPCMPEQW_YMM_YMM_YMMM256: Code = 1724 # type: ignore
"""
``VPCMPEQW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 75 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPCMPEQW_KR_K1_XMM_XMMM128: Code = 1725 # type: ignore
"""
``VPCMPEQW k1 {k2}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG 75 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPEQW_KR_K1_YMM_YMMM256: Code = 1726 # type: ignore
"""
``VPCMPEQW k1 {k2}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG 75 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPEQW_KR_K1_ZMM_ZMMM512: Code = 1727 # type: ignore
"""
``VPCMPEQW k1 {k2}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG 75 /r``

``AVX512BW``

``16/32/64-bit``
"""
PCMPEQD_MM_MMM64: Code = 1728 # type: ignore
"""
``PCMPEQD mm, mm/m64``

``NP 0F 76 /r``

``MMX``

``16/32/64-bit``
"""
PCMPEQD_XMM_XMMM128: Code = 1729 # type: ignore
"""
``PCMPEQD xmm1, xmm2/m128``

``66 0F 76 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPCMPEQD_XMM_XMM_XMMM128: Code = 1730 # type: ignore
"""
``VPCMPEQD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 76 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPCMPEQD_YMM_YMM_YMMM256: Code = 1731 # type: ignore
"""
``VPCMPEQD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 76 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPCMPEQD_KR_K1_XMM_XMMM128B32: Code = 1732 # type: ignore
"""
``VPCMPEQD k1 {k2}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F.W0 76 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPEQD_KR_K1_YMM_YMMM256B32: Code = 1733 # type: ignore
"""
``VPCMPEQD k1 {k2}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F.W0 76 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPEQD_KR_K1_ZMM_ZMMM512B32: Code = 1734 # type: ignore
"""
``VPCMPEQD k1 {k2}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F.W0 76 /r``

``AVX512F``

``16/32/64-bit``
"""
EMMS: Code = 1735 # type: ignore
"""
``EMMS``

``NP 0F 77``

``MMX``

``16/32/64-bit``
"""
VEX_VZEROUPPER: Code = 1736 # type: ignore
"""
``VZEROUPPER``

``VEX.128.0F.WIG 77``

``AVX``

``16/32/64-bit``
"""
VEX_VZEROALL: Code = 1737 # type: ignore
"""
``VZEROALL``

``VEX.256.0F.WIG 77``

``AVX``

``16/32/64-bit``
"""
VMREAD_RM32_R32: Code = 1738 # type: ignore
"""
``VMREAD r/m32, r32``

``NP 0F 78 /r``

``VMX``

``16/32-bit``
"""
VMREAD_RM64_R64: Code = 1739 # type: ignore
"""
``VMREAD r/m64, r64``

``NP 0F 78 /r``

``VMX``

``64-bit``
"""
EVEX_VCVTTPS2UDQ_XMM_K1Z_XMMM128B32: Code = 1740 # type: ignore
"""
``VCVTTPS2UDQ xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.0F.W0 78 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTTPS2UDQ_YMM_K1Z_YMMM256B32: Code = 1741 # type: ignore
"""
``VCVTTPS2UDQ ymm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.0F.W0 78 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTTPS2UDQ_ZMM_K1Z_ZMMM512B32_SAE: Code = 1742 # type: ignore
"""
``VCVTTPS2UDQ zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}``

``EVEX.512.0F.W0 78 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTTPD2UDQ_XMM_K1Z_XMMM128B64: Code = 1743 # type: ignore
"""
``VCVTTPD2UDQ xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.0F.W1 78 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTTPD2UDQ_XMM_K1Z_YMMM256B64: Code = 1744 # type: ignore
"""
``VCVTTPD2UDQ xmm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.0F.W1 78 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTTPD2UDQ_YMM_K1Z_ZMMM512B64_SAE: Code = 1745 # type: ignore
"""
``VCVTTPD2UDQ ymm1 {k1}{z}, zmm2/m512/m64bcst{sae}``

``EVEX.512.0F.W1 78 /r``

``AVX512F``

``16/32/64-bit``
"""
EXTRQ_XMM_IMM8_IMM8: Code = 1746 # type: ignore
"""
``EXTRQ xmm1, imm8, imm8``

``66 0F 78 /0 ib ib``

``SSE4A``

``16/32/64-bit``
"""
EVEX_VCVTTPS2UQQ_XMM_K1Z_XMMM64B32: Code = 1747 # type: ignore
"""
``VCVTTPS2UQQ xmm1 {k1}{z}, xmm2/m64/m32bcst``

``EVEX.128.66.0F.W0 78 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTTPS2UQQ_YMM_K1Z_XMMM128B32: Code = 1748 # type: ignore
"""
``VCVTTPS2UQQ ymm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.256.66.0F.W0 78 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTTPS2UQQ_ZMM_K1Z_YMMM256B32_SAE: Code = 1749 # type: ignore
"""
``VCVTTPS2UQQ zmm1 {k1}{z}, ymm2/m256/m32bcst{sae}``

``EVEX.512.66.0F.W0 78 /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTTPD2UQQ_XMM_K1Z_XMMM128B64: Code = 1750 # type: ignore
"""
``VCVTTPD2UQQ xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.66.0F.W1 78 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTTPD2UQQ_YMM_K1Z_YMMM256B64: Code = 1751 # type: ignore
"""
``VCVTTPD2UQQ ymm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.66.0F.W1 78 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTTPD2UQQ_ZMM_K1Z_ZMMM512B64_SAE: Code = 1752 # type: ignore
"""
``VCVTTPD2UQQ zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}``

``EVEX.512.66.0F.W1 78 /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTTSS2USI_R32_XMMM32_SAE: Code = 1753 # type: ignore
"""
``VCVTTSS2USI r32, xmm1/m32{sae}``

``EVEX.LIG.F3.0F.W0 78 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTTSS2USI_R64_XMMM32_SAE: Code = 1754 # type: ignore
"""
``VCVTTSS2USI r64, xmm1/m32{sae}``

``EVEX.LIG.F3.0F.W1 78 /r``

``AVX512F``

``64-bit``
"""
INSERTQ_XMM_XMM_IMM8_IMM8: Code = 1755 # type: ignore
"""
``INSERTQ xmm1, xmm2, imm8, imm8``

``F2 0F 78 /r ib ib``

``SSE4A``

``16/32/64-bit``
"""
EVEX_VCVTTSD2USI_R32_XMMM64_SAE: Code = 1756 # type: ignore
"""
``VCVTTSD2USI r32, xmm1/m64{sae}``

``EVEX.LIG.F2.0F.W0 78 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTTSD2USI_R64_XMMM64_SAE: Code = 1757 # type: ignore
"""
``VCVTTSD2USI r64, xmm1/m64{sae}``

``EVEX.LIG.F2.0F.W1 78 /r``

``AVX512F``

``64-bit``
"""
VMWRITE_R32_RM32: Code = 1758 # type: ignore
"""
``VMWRITE r32, r/m32``

``NP 0F 79 /r``

``VMX``

``16/32-bit``
"""
VMWRITE_R64_RM64: Code = 1759 # type: ignore
"""
``VMWRITE r64, r/m64``

``NP 0F 79 /r``

``VMX``

``64-bit``
"""
EVEX_VCVTPS2UDQ_XMM_K1Z_XMMM128B32: Code = 1760 # type: ignore
"""
``VCVTPS2UDQ xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.0F.W0 79 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTPS2UDQ_YMM_K1Z_YMMM256B32: Code = 1761 # type: ignore
"""
``VCVTPS2UDQ ymm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.0F.W0 79 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTPS2UDQ_ZMM_K1Z_ZMMM512B32_ER: Code = 1762 # type: ignore
"""
``VCVTPS2UDQ zmm1 {k1}{z}, zmm2/m512/m32bcst{er}``

``EVEX.512.0F.W0 79 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTPD2UDQ_XMM_K1Z_XMMM128B64: Code = 1763 # type: ignore
"""
``VCVTPD2UDQ xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.0F.W1 79 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTPD2UDQ_XMM_K1Z_YMMM256B64: Code = 1764 # type: ignore
"""
``VCVTPD2UDQ xmm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.0F.W1 79 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTPD2UDQ_YMM_K1Z_ZMMM512B64_ER: Code = 1765 # type: ignore
"""
``VCVTPD2UDQ ymm1 {k1}{z}, zmm2/m512/m64bcst{er}``

``EVEX.512.0F.W1 79 /r``

``AVX512F``

``16/32/64-bit``
"""
EXTRQ_XMM_XMM: Code = 1766 # type: ignore
"""
``EXTRQ xmm1, xmm2``

``66 0F 79 /r``

``SSE4A``

``16/32/64-bit``
"""
EVEX_VCVTPS2UQQ_XMM_K1Z_XMMM64B32: Code = 1767 # type: ignore
"""
``VCVTPS2UQQ xmm1 {k1}{z}, xmm2/m64/m32bcst``

``EVEX.128.66.0F.W0 79 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTPS2UQQ_YMM_K1Z_XMMM128B32: Code = 1768 # type: ignore
"""
``VCVTPS2UQQ ymm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.256.66.0F.W0 79 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTPS2UQQ_ZMM_K1Z_YMMM256B32_ER: Code = 1769 # type: ignore
"""
``VCVTPS2UQQ zmm1 {k1}{z}, ymm2/m256/m32bcst{er}``

``EVEX.512.66.0F.W0 79 /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTPD2UQQ_XMM_K1Z_XMMM128B64: Code = 1770 # type: ignore
"""
``VCVTPD2UQQ xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.66.0F.W1 79 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTPD2UQQ_YMM_K1Z_YMMM256B64: Code = 1771 # type: ignore
"""
``VCVTPD2UQQ ymm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.66.0F.W1 79 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTPD2UQQ_ZMM_K1Z_ZMMM512B64_ER: Code = 1772 # type: ignore
"""
``VCVTPD2UQQ zmm1 {k1}{z}, zmm2/m512/m64bcst{er}``

``EVEX.512.66.0F.W1 79 /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTSS2USI_R32_XMMM32_ER: Code = 1773 # type: ignore
"""
``VCVTSS2USI r32, xmm1/m32{er}``

``EVEX.LIG.F3.0F.W0 79 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTSS2USI_R64_XMMM32_ER: Code = 1774 # type: ignore
"""
``VCVTSS2USI r64, xmm1/m32{er}``

``EVEX.LIG.F3.0F.W1 79 /r``

``AVX512F``

``64-bit``
"""
INSERTQ_XMM_XMM: Code = 1775 # type: ignore
"""
``INSERTQ xmm1, xmm2``

``F2 0F 79 /r``

``SSE4A``

``16/32/64-bit``
"""
EVEX_VCVTSD2USI_R32_XMMM64_ER: Code = 1776 # type: ignore
"""
``VCVTSD2USI r32, xmm1/m64{er}``

``EVEX.LIG.F2.0F.W0 79 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTSD2USI_R64_XMMM64_ER: Code = 1777 # type: ignore
"""
``VCVTSD2USI r64, xmm1/m64{er}``

``EVEX.LIG.F2.0F.W1 79 /r``

``AVX512F``

``64-bit``
"""
EVEX_VCVTTPS2QQ_XMM_K1Z_XMMM64B32: Code = 1778 # type: ignore
"""
``VCVTTPS2QQ xmm1 {k1}{z}, xmm2/m64/m32bcst``

``EVEX.128.66.0F.W0 7A /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTTPS2QQ_YMM_K1Z_XMMM128B32: Code = 1779 # type: ignore
"""
``VCVTTPS2QQ ymm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.256.66.0F.W0 7A /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTTPS2QQ_ZMM_K1Z_YMMM256B32_SAE: Code = 1780 # type: ignore
"""
``VCVTTPS2QQ zmm1 {k1}{z}, ymm2/m256/m32bcst{sae}``

``EVEX.512.66.0F.W0 7A /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTTPD2QQ_XMM_K1Z_XMMM128B64: Code = 1781 # type: ignore
"""
``VCVTTPD2QQ xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.66.0F.W1 7A /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTTPD2QQ_YMM_K1Z_YMMM256B64: Code = 1782 # type: ignore
"""
``VCVTTPD2QQ ymm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.66.0F.W1 7A /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTTPD2QQ_ZMM_K1Z_ZMMM512B64_SAE: Code = 1783 # type: ignore
"""
``VCVTTPD2QQ zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}``

``EVEX.512.66.0F.W1 7A /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTUDQ2PD_XMM_K1Z_XMMM64B32: Code = 1784 # type: ignore
"""
``VCVTUDQ2PD xmm1 {k1}{z}, xmm2/m64/m32bcst``

``EVEX.128.F3.0F.W0 7A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTUDQ2PD_YMM_K1Z_XMMM128B32: Code = 1785 # type: ignore
"""
``VCVTUDQ2PD ymm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.256.F3.0F.W0 7A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTUDQ2PD_ZMM_K1Z_YMMM256B32_ER: Code = 1786 # type: ignore
"""
``VCVTUDQ2PD zmm1 {k1}{z}, ymm2/m256/m32bcst{er}``

``EVEX.512.F3.0F.W0 7A /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTUQQ2PD_XMM_K1Z_XMMM128B64: Code = 1787 # type: ignore
"""
``VCVTUQQ2PD xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.F3.0F.W1 7A /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTUQQ2PD_YMM_K1Z_YMMM256B64: Code = 1788 # type: ignore
"""
``VCVTUQQ2PD ymm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.F3.0F.W1 7A /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTUQQ2PD_ZMM_K1Z_ZMMM512B64_ER: Code = 1789 # type: ignore
"""
``VCVTUQQ2PD zmm1 {k1}{z}, zmm2/m512/m64bcst{er}``

``EVEX.512.F3.0F.W1 7A /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTUDQ2PS_XMM_K1Z_XMMM128B32: Code = 1790 # type: ignore
"""
``VCVTUDQ2PS xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.F2.0F.W0 7A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTUDQ2PS_YMM_K1Z_YMMM256B32: Code = 1791 # type: ignore
"""
``VCVTUDQ2PS ymm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.F2.0F.W0 7A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTUDQ2PS_ZMM_K1Z_ZMMM512B32_ER: Code = 1792 # type: ignore
"""
``VCVTUDQ2PS zmm1 {k1}{z}, zmm2/m512/m32bcst{er}``

``EVEX.512.F2.0F.W0 7A /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTUQQ2PS_XMM_K1Z_XMMM128B64: Code = 1793 # type: ignore
"""
``VCVTUQQ2PS xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.F2.0F.W1 7A /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTUQQ2PS_XMM_K1Z_YMMM256B64: Code = 1794 # type: ignore
"""
``VCVTUQQ2PS xmm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.F2.0F.W1 7A /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTUQQ2PS_YMM_K1Z_ZMMM512B64_ER: Code = 1795 # type: ignore
"""
``VCVTUQQ2PS ymm1 {k1}{z}, zmm2/m512/m64bcst{er}``

``EVEX.512.F2.0F.W1 7A /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTPS2QQ_XMM_K1Z_XMMM64B32: Code = 1796 # type: ignore
"""
``VCVTPS2QQ xmm1 {k1}{z}, xmm2/m64/m32bcst``

``EVEX.128.66.0F.W0 7B /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTPS2QQ_YMM_K1Z_XMMM128B32: Code = 1797 # type: ignore
"""
``VCVTPS2QQ ymm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.256.66.0F.W0 7B /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTPS2QQ_ZMM_K1Z_YMMM256B32_ER: Code = 1798 # type: ignore
"""
``VCVTPS2QQ zmm1 {k1}{z}, ymm2/m256/m32bcst{er}``

``EVEX.512.66.0F.W0 7B /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTPD2QQ_XMM_K1Z_XMMM128B64: Code = 1799 # type: ignore
"""
``VCVTPD2QQ xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.66.0F.W1 7B /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTPD2QQ_YMM_K1Z_YMMM256B64: Code = 1800 # type: ignore
"""
``VCVTPD2QQ ymm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.66.0F.W1 7B /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTPD2QQ_ZMM_K1Z_ZMMM512B64_ER: Code = 1801 # type: ignore
"""
``VCVTPD2QQ zmm1 {k1}{z}, zmm2/m512/m64bcst{er}``

``EVEX.512.66.0F.W1 7B /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTUSI2SS_XMM_XMM_RM32_ER: Code = 1802 # type: ignore
"""
``VCVTUSI2SS xmm1, xmm2, r/m32{er}``

``EVEX.LIG.F3.0F.W0 7B /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTUSI2SS_XMM_XMM_RM64_ER: Code = 1803 # type: ignore
"""
``VCVTUSI2SS xmm1, xmm2, r/m64{er}``

``EVEX.LIG.F3.0F.W1 7B /r``

``AVX512F``

``64-bit``
"""
EVEX_VCVTUSI2SD_XMM_XMM_RM32_ER: Code = 1804 # type: ignore
"""
``VCVTUSI2SD xmm1, xmm2, r/m32{er}``

``EVEX.LIG.F2.0F.W0 7B /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTUSI2SD_XMM_XMM_RM64_ER: Code = 1805 # type: ignore
"""
``VCVTUSI2SD xmm1, xmm2, r/m64{er}``

``EVEX.LIG.F2.0F.W1 7B /r``

``AVX512F``

``64-bit``
"""
HADDPD_XMM_XMMM128: Code = 1806 # type: ignore
"""
``HADDPD xmm1, xmm2/m128``

``66 0F 7C /r``

``SSE3``

``16/32/64-bit``
"""
VEX_VHADDPD_XMM_XMM_XMMM128: Code = 1807 # type: ignore
"""
``VHADDPD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 7C /r``

``AVX``

``16/32/64-bit``
"""
VEX_VHADDPD_YMM_YMM_YMMM256: Code = 1808 # type: ignore
"""
``VHADDPD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 7C /r``

``AVX``

``16/32/64-bit``
"""
HADDPS_XMM_XMMM128: Code = 1809 # type: ignore
"""
``HADDPS xmm1, xmm2/m128``

``F2 0F 7C /r``

``SSE3``

``16/32/64-bit``
"""
VEX_VHADDPS_XMM_XMM_XMMM128: Code = 1810 # type: ignore
"""
``VHADDPS xmm1, xmm2, xmm3/m128``

``VEX.128.F2.0F.WIG 7C /r``

``AVX``

``16/32/64-bit``
"""
VEX_VHADDPS_YMM_YMM_YMMM256: Code = 1811 # type: ignore
"""
``VHADDPS ymm1, ymm2, ymm3/m256``

``VEX.256.F2.0F.WIG 7C /r``

``AVX``

``16/32/64-bit``
"""
HSUBPD_XMM_XMMM128: Code = 1812 # type: ignore
"""
``HSUBPD xmm1, xmm2/m128``

``66 0F 7D /r``

``SSE3``

``16/32/64-bit``
"""
VEX_VHSUBPD_XMM_XMM_XMMM128: Code = 1813 # type: ignore
"""
``VHSUBPD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG 7D /r``

``AVX``

``16/32/64-bit``
"""
VEX_VHSUBPD_YMM_YMM_YMMM256: Code = 1814 # type: ignore
"""
``VHSUBPD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG 7D /r``

``AVX``

``16/32/64-bit``
"""
HSUBPS_XMM_XMMM128: Code = 1815 # type: ignore
"""
``HSUBPS xmm1, xmm2/m128``

``F2 0F 7D /r``

``SSE3``

``16/32/64-bit``
"""
VEX_VHSUBPS_XMM_XMM_XMMM128: Code = 1816 # type: ignore
"""
``VHSUBPS xmm1, xmm2, xmm3/m128``

``VEX.128.F2.0F.WIG 7D /r``

``AVX``

``16/32/64-bit``
"""
VEX_VHSUBPS_YMM_YMM_YMMM256: Code = 1817 # type: ignore
"""
``VHSUBPS ymm1, ymm2, ymm3/m256``

``VEX.256.F2.0F.WIG 7D /r``

``AVX``

``16/32/64-bit``
"""
MOVD_RM32_MM: Code = 1818 # type: ignore
"""
``MOVD r/m32, mm``

``NP 0F 7E /r``

``MMX``

``16/32/64-bit``
"""
MOVQ_RM64_MM: Code = 1819 # type: ignore
"""
``MOVQ r/m64, mm``

``NP o64 0F 7E /r``

``MMX``

``64-bit``
"""
MOVD_RM32_XMM: Code = 1820 # type: ignore
"""
``MOVD r/m32, xmm``

``66 0F 7E /r``

``SSE2``

``16/32/64-bit``
"""
MOVQ_RM64_XMM: Code = 1821 # type: ignore
"""
``MOVQ r/m64, xmm``

``66 o64 0F 7E /r``

``SSE2``

``64-bit``
"""
VEX_VMOVD_RM32_XMM: Code = 1822 # type: ignore
"""
``VMOVD r/m32, xmm1``

``VEX.128.66.0F.W0 7E /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVQ_RM64_XMM: Code = 1823 # type: ignore
"""
``VMOVQ r/m64, xmm1``

``VEX.128.66.0F.W1 7E /r``

``AVX``

``64-bit``
"""
EVEX_VMOVD_RM32_XMM: Code = 1824 # type: ignore
"""
``VMOVD r/m32, xmm1``

``EVEX.128.66.0F.W0 7E /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVQ_RM64_XMM: Code = 1825 # type: ignore
"""
``VMOVQ r/m64, xmm1``

``EVEX.128.66.0F.W1 7E /r``

``AVX512F``

``64-bit``
"""
MOVQ_XMM_XMMM64: Code = 1826 # type: ignore
"""
``MOVQ xmm1, xmm2/m64``

``F3 0F 7E /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVQ_XMM_XMMM64: Code = 1827 # type: ignore
"""
``VMOVQ xmm1, xmm2/m64``

``VEX.128.F3.0F.WIG 7E /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVQ_XMM_XMMM64: Code = 1828 # type: ignore
"""
``VMOVQ xmm1, xmm2/m64``

``EVEX.128.F3.0F.W1 7E /r``

``AVX512F``

``16/32/64-bit``
"""
MOVQ_MMM64_MM: Code = 1829 # type: ignore
"""
``MOVQ mm/m64, mm``

``NP 0F 7F /r``

``MMX``

``16/32/64-bit``
"""
MOVDQA_XMMM128_XMM: Code = 1830 # type: ignore
"""
``MOVDQA xmm2/m128, xmm1``

``66 0F 7F /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVDQA_XMMM128_XMM: Code = 1831 # type: ignore
"""
``VMOVDQA xmm2/m128, xmm1``

``VEX.128.66.0F.WIG 7F /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVDQA_YMMM256_YMM: Code = 1832 # type: ignore
"""
``VMOVDQA ymm2/m256, ymm1``

``VEX.256.66.0F.WIG 7F /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVDQA32_XMMM128_K1Z_XMM: Code = 1833 # type: ignore
"""
``VMOVDQA32 xmm2/m128 {k1}{z}, xmm1``

``EVEX.128.66.0F.W0 7F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQA32_YMMM256_K1Z_YMM: Code = 1834 # type: ignore
"""
``VMOVDQA32 ymm2/m256 {k1}{z}, ymm1``

``EVEX.256.66.0F.W0 7F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQA32_ZMMM512_K1Z_ZMM: Code = 1835 # type: ignore
"""
``VMOVDQA32 zmm2/m512 {k1}{z}, zmm1``

``EVEX.512.66.0F.W0 7F /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQA64_XMMM128_K1Z_XMM: Code = 1836 # type: ignore
"""
``VMOVDQA64 xmm2/m128 {k1}{z}, xmm1``

``EVEX.128.66.0F.W1 7F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQA64_YMMM256_K1Z_YMM: Code = 1837 # type: ignore
"""
``VMOVDQA64 ymm2/m256 {k1}{z}, ymm1``

``EVEX.256.66.0F.W1 7F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQA64_ZMMM512_K1Z_ZMM: Code = 1838 # type: ignore
"""
``VMOVDQA64 zmm2/m512 {k1}{z}, zmm1``

``EVEX.512.66.0F.W1 7F /r``

``AVX512F``

``16/32/64-bit``
"""
MOVDQU_XMMM128_XMM: Code = 1839 # type: ignore
"""
``MOVDQU xmm2/m128, xmm1``

``F3 0F 7F /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVDQU_XMMM128_XMM: Code = 1840 # type: ignore
"""
``VMOVDQU xmm2/m128, xmm1``

``VEX.128.F3.0F.WIG 7F /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVDQU_YMMM256_YMM: Code = 1841 # type: ignore
"""
``VMOVDQU ymm2/m256, ymm1``

``VEX.256.F3.0F.WIG 7F /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVDQU32_XMMM128_K1Z_XMM: Code = 1842 # type: ignore
"""
``VMOVDQU32 xmm2/m128 {k1}{z}, xmm1``

``EVEX.128.F3.0F.W0 7F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQU32_YMMM256_K1Z_YMM: Code = 1843 # type: ignore
"""
``VMOVDQU32 ymm2/m256 {k1}{z}, ymm1``

``EVEX.256.F3.0F.W0 7F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQU32_ZMMM512_K1Z_ZMM: Code = 1844 # type: ignore
"""
``VMOVDQU32 zmm2/m512 {k1}{z}, zmm1``

``EVEX.512.F3.0F.W0 7F /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQU64_XMMM128_K1Z_XMM: Code = 1845 # type: ignore
"""
``VMOVDQU64 xmm2/m128 {k1}{z}, xmm1``

``EVEX.128.F3.0F.W1 7F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQU64_YMMM256_K1Z_YMM: Code = 1846 # type: ignore
"""
``VMOVDQU64 ymm2/m256 {k1}{z}, ymm1``

``EVEX.256.F3.0F.W1 7F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQU64_ZMMM512_K1Z_ZMM: Code = 1847 # type: ignore
"""
``VMOVDQU64 zmm2/m512 {k1}{z}, zmm1``

``EVEX.512.F3.0F.W1 7F /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVDQU8_XMMM128_K1Z_XMM: Code = 1848 # type: ignore
"""
``VMOVDQU8 xmm2/m128 {k1}{z}, xmm1``

``EVEX.128.F2.0F.W0 7F /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VMOVDQU8_YMMM256_K1Z_YMM: Code = 1849 # type: ignore
"""
``VMOVDQU8 ymm2/m256 {k1}{z}, ymm1``

``EVEX.256.F2.0F.W0 7F /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VMOVDQU8_ZMMM512_K1Z_ZMM: Code = 1850 # type: ignore
"""
``VMOVDQU8 zmm2/m512 {k1}{z}, zmm1``

``EVEX.512.F2.0F.W0 7F /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VMOVDQU16_XMMM128_K1Z_XMM: Code = 1851 # type: ignore
"""
``VMOVDQU16 xmm2/m128 {k1}{z}, xmm1``

``EVEX.128.F2.0F.W1 7F /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VMOVDQU16_YMMM256_K1Z_YMM: Code = 1852 # type: ignore
"""
``VMOVDQU16 ymm2/m256 {k1}{z}, ymm1``

``EVEX.256.F2.0F.W1 7F /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VMOVDQU16_ZMMM512_K1Z_ZMM: Code = 1853 # type: ignore
"""
``VMOVDQU16 zmm2/m512 {k1}{z}, zmm1``

``EVEX.512.F2.0F.W1 7F /r``

``AVX512BW``

``16/32/64-bit``
"""
JO_REL16: Code = 1854 # type: ignore
"""
``JO rel16``

``o16 0F 80 cw``

``386+``

``16/32/64-bit``
"""
JO_REL32_32: Code = 1855 # type: ignore
"""
``JO rel32``

``o32 0F 80 cd``

``386+``

``16/32-bit``
"""
JO_REL32_64: Code = 1856 # type: ignore
"""
``JO rel32``

``o64 0F 80 cd``

``X64``

``64-bit``
"""
JNO_REL16: Code = 1857 # type: ignore
"""
``JNO rel16``

``o16 0F 81 cw``

``386+``

``16/32/64-bit``
"""
JNO_REL32_32: Code = 1858 # type: ignore
"""
``JNO rel32``

``o32 0F 81 cd``

``386+``

``16/32-bit``
"""
JNO_REL32_64: Code = 1859 # type: ignore
"""
``JNO rel32``

``o64 0F 81 cd``

``X64``

``64-bit``
"""
JB_REL16: Code = 1860 # type: ignore
"""
``JB rel16``

``o16 0F 82 cw``

``386+``

``16/32/64-bit``
"""
JB_REL32_32: Code = 1861 # type: ignore
"""
``JB rel32``

``o32 0F 82 cd``

``386+``

``16/32-bit``
"""
JB_REL32_64: Code = 1862 # type: ignore
"""
``JB rel32``

``o64 0F 82 cd``

``X64``

``64-bit``
"""
JAE_REL16: Code = 1863 # type: ignore
"""
``JAE rel16``

``o16 0F 83 cw``

``386+``

``16/32/64-bit``
"""
JAE_REL32_32: Code = 1864 # type: ignore
"""
``JAE rel32``

``o32 0F 83 cd``

``386+``

``16/32-bit``
"""
JAE_REL32_64: Code = 1865 # type: ignore
"""
``JAE rel32``

``o64 0F 83 cd``

``X64``

``64-bit``
"""
JE_REL16: Code = 1866 # type: ignore
"""
``JE rel16``

``o16 0F 84 cw``

``386+``

``16/32/64-bit``
"""
JE_REL32_32: Code = 1867 # type: ignore
"""
``JE rel32``

``o32 0F 84 cd``

``386+``

``16/32-bit``
"""
JE_REL32_64: Code = 1868 # type: ignore
"""
``JE rel32``

``o64 0F 84 cd``

``X64``

``64-bit``
"""
JNE_REL16: Code = 1869 # type: ignore
"""
``JNE rel16``

``o16 0F 85 cw``

``386+``

``16/32/64-bit``
"""
JNE_REL32_32: Code = 1870 # type: ignore
"""
``JNE rel32``

``o32 0F 85 cd``

``386+``

``16/32-bit``
"""
JNE_REL32_64: Code = 1871 # type: ignore
"""
``JNE rel32``

``o64 0F 85 cd``

``X64``

``64-bit``
"""
JBE_REL16: Code = 1872 # type: ignore
"""
``JBE rel16``

``o16 0F 86 cw``

``386+``

``16/32/64-bit``
"""
JBE_REL32_32: Code = 1873 # type: ignore
"""
``JBE rel32``

``o32 0F 86 cd``

``386+``

``16/32-bit``
"""
JBE_REL32_64: Code = 1874 # type: ignore
"""
``JBE rel32``

``o64 0F 86 cd``

``X64``

``64-bit``
"""
JA_REL16: Code = 1875 # type: ignore
"""
``JA rel16``

``o16 0F 87 cw``

``386+``

``16/32/64-bit``
"""
JA_REL32_32: Code = 1876 # type: ignore
"""
``JA rel32``

``o32 0F 87 cd``

``386+``

``16/32-bit``
"""
JA_REL32_64: Code = 1877 # type: ignore
"""
``JA rel32``

``o64 0F 87 cd``

``X64``

``64-bit``
"""
JS_REL16: Code = 1878 # type: ignore
"""
``JS rel16``

``o16 0F 88 cw``

``386+``

``16/32/64-bit``
"""
JS_REL32_32: Code = 1879 # type: ignore
"""
``JS rel32``

``o32 0F 88 cd``

``386+``

``16/32-bit``
"""
JS_REL32_64: Code = 1880 # type: ignore
"""
``JS rel32``

``o64 0F 88 cd``

``X64``

``64-bit``
"""
JNS_REL16: Code = 1881 # type: ignore
"""
``JNS rel16``

``o16 0F 89 cw``

``386+``

``16/32/64-bit``
"""
JNS_REL32_32: Code = 1882 # type: ignore
"""
``JNS rel32``

``o32 0F 89 cd``

``386+``

``16/32-bit``
"""
JNS_REL32_64: Code = 1883 # type: ignore
"""
``JNS rel32``

``o64 0F 89 cd``

``X64``

``64-bit``
"""
JP_REL16: Code = 1884 # type: ignore
"""
``JP rel16``

``o16 0F 8A cw``

``386+``

``16/32/64-bit``
"""
JP_REL32_32: Code = 1885 # type: ignore
"""
``JP rel32``

``o32 0F 8A cd``

``386+``

``16/32-bit``
"""
JP_REL32_64: Code = 1886 # type: ignore
"""
``JP rel32``

``o64 0F 8A cd``

``X64``

``64-bit``
"""
JNP_REL16: Code = 1887 # type: ignore
"""
``JNP rel16``

``o16 0F 8B cw``

``386+``

``16/32/64-bit``
"""
JNP_REL32_32: Code = 1888 # type: ignore
"""
``JNP rel32``

``o32 0F 8B cd``

``386+``

``16/32-bit``
"""
JNP_REL32_64: Code = 1889 # type: ignore
"""
``JNP rel32``

``o64 0F 8B cd``

``X64``

``64-bit``
"""
JL_REL16: Code = 1890 # type: ignore
"""
``JL rel16``

``o16 0F 8C cw``

``386+``

``16/32/64-bit``
"""
JL_REL32_32: Code = 1891 # type: ignore
"""
``JL rel32``

``o32 0F 8C cd``

``386+``

``16/32-bit``
"""
JL_REL32_64: Code = 1892 # type: ignore
"""
``JL rel32``

``o64 0F 8C cd``

``X64``

``64-bit``
"""
JGE_REL16: Code = 1893 # type: ignore
"""
``JGE rel16``

``o16 0F 8D cw``

``386+``

``16/32/64-bit``
"""
JGE_REL32_32: Code = 1894 # type: ignore
"""
``JGE rel32``

``o32 0F 8D cd``

``386+``

``16/32-bit``
"""
JGE_REL32_64: Code = 1895 # type: ignore
"""
``JGE rel32``

``o64 0F 8D cd``

``X64``

``64-bit``
"""
JLE_REL16: Code = 1896 # type: ignore
"""
``JLE rel16``

``o16 0F 8E cw``

``386+``

``16/32/64-bit``
"""
JLE_REL32_32: Code = 1897 # type: ignore
"""
``JLE rel32``

``o32 0F 8E cd``

``386+``

``16/32-bit``
"""
JLE_REL32_64: Code = 1898 # type: ignore
"""
``JLE rel32``

``o64 0F 8E cd``

``X64``

``64-bit``
"""
JG_REL16: Code = 1899 # type: ignore
"""
``JG rel16``

``o16 0F 8F cw``

``386+``

``16/32/64-bit``
"""
JG_REL32_32: Code = 1900 # type: ignore
"""
``JG rel32``

``o32 0F 8F cd``

``386+``

``16/32-bit``
"""
JG_REL32_64: Code = 1901 # type: ignore
"""
``JG rel32``

``o64 0F 8F cd``

``X64``

``64-bit``
"""
SETO_RM8: Code = 1902 # type: ignore
"""
``SETO r/m8``

``0F 90 /r``

``386+``

``16/32/64-bit``
"""
SETNO_RM8: Code = 1903 # type: ignore
"""
``SETNO r/m8``

``0F 91 /r``

``386+``

``16/32/64-bit``
"""
SETB_RM8: Code = 1904 # type: ignore
"""
``SETB r/m8``

``0F 92 /r``

``386+``

``16/32/64-bit``
"""
SETAE_RM8: Code = 1905 # type: ignore
"""
``SETAE r/m8``

``0F 93 /r``

``386+``

``16/32/64-bit``
"""
SETE_RM8: Code = 1906 # type: ignore
"""
``SETE r/m8``

``0F 94 /r``

``386+``

``16/32/64-bit``
"""
SETNE_RM8: Code = 1907 # type: ignore
"""
``SETNE r/m8``

``0F 95 /r``

``386+``

``16/32/64-bit``
"""
SETBE_RM8: Code = 1908 # type: ignore
"""
``SETBE r/m8``

``0F 96 /r``

``386+``

``16/32/64-bit``
"""
SETA_RM8: Code = 1909 # type: ignore
"""
``SETA r/m8``

``0F 97 /r``

``386+``

``16/32/64-bit``
"""
SETS_RM8: Code = 1910 # type: ignore
"""
``SETS r/m8``

``0F 98 /r``

``386+``

``16/32/64-bit``
"""
SETNS_RM8: Code = 1911 # type: ignore
"""
``SETNS r/m8``

``0F 99 /r``

``386+``

``16/32/64-bit``
"""
SETP_RM8: Code = 1912 # type: ignore
"""
``SETP r/m8``

``0F 9A /r``

``386+``

``16/32/64-bit``
"""
SETNP_RM8: Code = 1913 # type: ignore
"""
``SETNP r/m8``

``0F 9B /r``

``386+``

``16/32/64-bit``
"""
SETL_RM8: Code = 1914 # type: ignore
"""
``SETL r/m8``

``0F 9C /r``

``386+``

``16/32/64-bit``
"""
SETGE_RM8: Code = 1915 # type: ignore
"""
``SETGE r/m8``

``0F 9D /r``

``386+``

``16/32/64-bit``
"""
SETLE_RM8: Code = 1916 # type: ignore
"""
``SETLE r/m8``

``0F 9E /r``

``386+``

``16/32/64-bit``
"""
SETG_RM8: Code = 1917 # type: ignore
"""
``SETG r/m8``

``0F 9F /r``

``386+``

``16/32/64-bit``
"""
VEX_KMOVW_KR_KM16: Code = 1918 # type: ignore
"""
``KMOVW k1, k2/m16``

``VEX.L0.0F.W0 90 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_KMOVQ_KR_KM64: Code = 1919 # type: ignore
"""
``KMOVQ k1, k2/m64``

``VEX.L0.0F.W1 90 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KMOVB_KR_KM8: Code = 1920 # type: ignore
"""
``KMOVB k1, k2/m8``

``VEX.L0.66.0F.W0 90 /r``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_KMOVD_KR_KM32: Code = 1921 # type: ignore
"""
``KMOVD k1, k2/m32``

``VEX.L0.66.0F.W1 90 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KMOVW_M16_KR: Code = 1922 # type: ignore
"""
``KMOVW m16, k1``

``VEX.L0.0F.W0 91 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_KMOVQ_M64_KR: Code = 1923 # type: ignore
"""
``KMOVQ m64, k1``

``VEX.L0.0F.W1 91 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KMOVB_M8_KR: Code = 1924 # type: ignore
"""
``KMOVB m8, k1``

``VEX.L0.66.0F.W0 91 /r``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_KMOVD_M32_KR: Code = 1925 # type: ignore
"""
``KMOVD m32, k1``

``VEX.L0.66.0F.W1 91 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KMOVW_KR_R32: Code = 1926 # type: ignore
"""
``KMOVW k1, r32``

``VEX.L0.0F.W0 92 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_KMOVB_KR_R32: Code = 1927 # type: ignore
"""
``KMOVB k1, r32``

``VEX.L0.66.0F.W0 92 /r``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_KMOVD_KR_R32: Code = 1928 # type: ignore
"""
``KMOVD k1, r32``

``VEX.L0.F2.0F.W0 92 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KMOVQ_KR_R64: Code = 1929 # type: ignore
"""
``KMOVQ k1, r64``

``VEX.L0.F2.0F.W1 92 /r``

``AVX512BW``

``64-bit``
"""
VEX_KMOVW_R32_KR: Code = 1930 # type: ignore
"""
``KMOVW r32, k1``

``VEX.L0.0F.W0 93 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_KMOVB_R32_KR: Code = 1931 # type: ignore
"""
``KMOVB r32, k1``

``VEX.L0.66.0F.W0 93 /r``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_KMOVD_R32_KR: Code = 1932 # type: ignore
"""
``KMOVD r32, k1``

``VEX.L0.F2.0F.W0 93 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KMOVQ_R64_KR: Code = 1933 # type: ignore
"""
``KMOVQ r64, k1``

``VEX.L0.F2.0F.W1 93 /r``

``AVX512BW``

``64-bit``
"""
VEX_KORTESTW_KR_KR: Code = 1934 # type: ignore
"""
``KORTESTW k1, k2``

``VEX.L0.0F.W0 98 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_KORTESTQ_KR_KR: Code = 1935 # type: ignore
"""
``KORTESTQ k1, k2``

``VEX.L0.0F.W1 98 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KORTESTB_KR_KR: Code = 1936 # type: ignore
"""
``KORTESTB k1, k2``

``VEX.L0.66.0F.W0 98 /r``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_KORTESTD_KR_KR: Code = 1937 # type: ignore
"""
``KORTESTD k1, k2``

``VEX.L0.66.0F.W1 98 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KTESTW_KR_KR: Code = 1938 # type: ignore
"""
``KTESTW k1, k2``

``VEX.L0.0F.W0 99 /r``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_KTESTQ_KR_KR: Code = 1939 # type: ignore
"""
``KTESTQ k1, k2``

``VEX.L0.0F.W1 99 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KTESTB_KR_KR: Code = 1940 # type: ignore
"""
``KTESTB k1, k2``

``VEX.L0.66.0F.W0 99 /r``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_KTESTD_KR_KR: Code = 1941 # type: ignore
"""
``KTESTD k1, k2``

``VEX.L0.66.0F.W1 99 /r``

``AVX512BW``

``16/32/64-bit``
"""
PUSHW_FS: Code = 1942 # type: ignore
"""
``PUSH FS``

``o16 0F A0``

``386+``

``16/32/64-bit``
"""
PUSHD_FS: Code = 1943 # type: ignore
"""
``PUSH FS``

``o32 0F A0``

``386+``

``16/32-bit``
"""
PUSHQ_FS: Code = 1944 # type: ignore
"""
``PUSH FS``

``o64 0F A0``

``X64``

``64-bit``
"""
POPW_FS: Code = 1945 # type: ignore
"""
``POP FS``

``o16 0F A1``

``386+``

``16/32/64-bit``
"""
POPD_FS: Code = 1946 # type: ignore
"""
``POP FS``

``o32 0F A1``

``386+``

``16/32-bit``
"""
POPQ_FS: Code = 1947 # type: ignore
"""
``POP FS``

``o64 0F A1``

``X64``

``64-bit``
"""
CPUID: Code = 1948 # type: ignore
"""
``CPUID``

``0F A2``

``CPUID``

``16/32/64-bit``
"""
BT_RM16_R16: Code = 1949 # type: ignore
"""
``BT r/m16, r16``

``o16 0F A3 /r``

``386+``

``16/32/64-bit``
"""
BT_RM32_R32: Code = 1950 # type: ignore
"""
``BT r/m32, r32``

``o32 0F A3 /r``

``386+``

``16/32/64-bit``
"""
BT_RM64_R64: Code = 1951 # type: ignore
"""
``BT r/m64, r64``

``o64 0F A3 /r``

``X64``

``64-bit``
"""
SHLD_RM16_R16_IMM8: Code = 1952 # type: ignore
"""
``SHLD r/m16, r16, imm8``

``o16 0F A4 /r ib``

``386+``

``16/32/64-bit``
"""
SHLD_RM32_R32_IMM8: Code = 1953 # type: ignore
"""
``SHLD r/m32, r32, imm8``

``o32 0F A4 /r ib``

``386+``

``16/32/64-bit``
"""
SHLD_RM64_R64_IMM8: Code = 1954 # type: ignore
"""
``SHLD r/m64, r64, imm8``

``o64 0F A4 /r ib``

``X64``

``64-bit``
"""
SHLD_RM16_R16_CL: Code = 1955 # type: ignore
"""
``SHLD r/m16, r16, CL``

``o16 0F A5 /r``

``386+``

``16/32/64-bit``
"""
SHLD_RM32_R32_CL: Code = 1956 # type: ignore
"""
``SHLD r/m32, r32, CL``

``o32 0F A5 /r``

``386+``

``16/32/64-bit``
"""
SHLD_RM64_R64_CL: Code = 1957 # type: ignore
"""
``SHLD r/m64, r64, CL``

``o64 0F A5 /r``

``X64``

``64-bit``
"""
MONTMUL_16: Code = 1958 # type: ignore
"""
``MONTMUL``

``a16 F3 0F A6 C0``

``PADLOCK_PMM``

``16/32-bit``
"""
MONTMUL_32: Code = 1959 # type: ignore
"""
``MONTMUL``

``a32 F3 0F A6 C0``

``PADLOCK_PMM``

``16/32/64-bit``
"""
MONTMUL_64: Code = 1960 # type: ignore
"""
``MONTMUL``

``a64 F3 0F A6 C0``

``PADLOCK_PMM``

``64-bit``
"""
XSHA1_16: Code = 1961 # type: ignore
"""
``XSHA1``

``a16 F3 0F A6 C8``

``PADLOCK_PHE``

``16/32-bit``
"""
XSHA1_32: Code = 1962 # type: ignore
"""
``XSHA1``

``a32 F3 0F A6 C8``

``PADLOCK_PHE``

``16/32/64-bit``
"""
XSHA1_64: Code = 1963 # type: ignore
"""
``XSHA1``

``a64 F3 0F A6 C8``

``PADLOCK_PHE``

``64-bit``
"""
XSHA256_16: Code = 1964 # type: ignore
"""
``XSHA256``

``a16 F3 0F A6 D0``

``PADLOCK_PHE``

``16/32-bit``
"""
XSHA256_32: Code = 1965 # type: ignore
"""
``XSHA256``

``a32 F3 0F A6 D0``

``PADLOCK_PHE``

``16/32/64-bit``
"""
XSHA256_64: Code = 1966 # type: ignore
"""
``XSHA256``

``a64 F3 0F A6 D0``

``PADLOCK_PHE``

``64-bit``
"""
XBTS_R16_RM16: Code = 1967 # type: ignore
"""
``XBTS r16, r/m16``

``o16 0F A6 /r``

``386 A0``

``16/32-bit``
"""
XBTS_R32_RM32: Code = 1968 # type: ignore
"""
``XBTS r32, r/m32``

``o32 0F A6 /r``

``386 A0``

``16/32-bit``
"""
XSTORE_16: Code = 1969 # type: ignore
"""
``XSTORE``

``a16 0F A7 C0``

``PADLOCK_RNG``

``16/32-bit``
"""
XSTORE_32: Code = 1970 # type: ignore
"""
``XSTORE``

``a32 0F A7 C0``

``PADLOCK_RNG``

``16/32/64-bit``
"""
XSTORE_64: Code = 1971 # type: ignore
"""
``XSTORE``

``a64 0F A7 C0``

``PADLOCK_RNG``

``64-bit``
"""
XCRYPTECB_16: Code = 1972 # type: ignore
"""
``XCRYPTECB``

``a16 F3 0F A7 C8``

``PADLOCK_ACE``

``16/32-bit``
"""
XCRYPTECB_32: Code = 1973 # type: ignore
"""
``XCRYPTECB``

``a32 F3 0F A7 C8``

``PADLOCK_ACE``

``16/32/64-bit``
"""
XCRYPTECB_64: Code = 1974 # type: ignore
"""
``XCRYPTECB``

``a64 F3 0F A7 C8``

``PADLOCK_ACE``

``64-bit``
"""
XCRYPTCBC_16: Code = 1975 # type: ignore
"""
``XCRYPTCBC``

``a16 F3 0F A7 D0``

``PADLOCK_ACE``

``16/32-bit``
"""
XCRYPTCBC_32: Code = 1976 # type: ignore
"""
``XCRYPTCBC``

``a32 F3 0F A7 D0``

``PADLOCK_ACE``

``16/32/64-bit``
"""
XCRYPTCBC_64: Code = 1977 # type: ignore
"""
``XCRYPTCBC``

``a64 F3 0F A7 D0``

``PADLOCK_ACE``

``64-bit``
"""
XCRYPTCTR_16: Code = 1978 # type: ignore
"""
``XCRYPTCTR``

``a16 F3 0F A7 D8``

``PADLOCK_ACE``

``16/32-bit``
"""
XCRYPTCTR_32: Code = 1979 # type: ignore
"""
``XCRYPTCTR``

``a32 F3 0F A7 D8``

``PADLOCK_ACE``

``16/32/64-bit``
"""
XCRYPTCTR_64: Code = 1980 # type: ignore
"""
``XCRYPTCTR``

``a64 F3 0F A7 D8``

``PADLOCK_ACE``

``64-bit``
"""
XCRYPTCFB_16: Code = 1981 # type: ignore
"""
``XCRYPTCFB``

``a16 F3 0F A7 E0``

``PADLOCK_ACE``

``16/32-bit``
"""
XCRYPTCFB_32: Code = 1982 # type: ignore
"""
``XCRYPTCFB``

``a32 F3 0F A7 E0``

``PADLOCK_ACE``

``16/32/64-bit``
"""
XCRYPTCFB_64: Code = 1983 # type: ignore
"""
``XCRYPTCFB``

``a64 F3 0F A7 E0``

``PADLOCK_ACE``

``64-bit``
"""
XCRYPTOFB_16: Code = 1984 # type: ignore
"""
``XCRYPTOFB``

``a16 F3 0F A7 E8``

``PADLOCK_ACE``

``16/32-bit``
"""
XCRYPTOFB_32: Code = 1985 # type: ignore
"""
``XCRYPTOFB``

``a32 F3 0F A7 E8``

``PADLOCK_ACE``

``16/32/64-bit``
"""
XCRYPTOFB_64: Code = 1986 # type: ignore
"""
``XCRYPTOFB``

``a64 F3 0F A7 E8``

``PADLOCK_ACE``

``64-bit``
"""
IBTS_RM16_R16: Code = 1987 # type: ignore
"""
``IBTS r/m16, r16``

``o16 0F A7 /r``

``386 A0``

``16/32-bit``
"""
IBTS_RM32_R32: Code = 1988 # type: ignore
"""
``IBTS r/m32, r32``

``o32 0F A7 /r``

``386 A0``

``16/32-bit``
"""
CMPXCHG486_RM8_R8: Code = 1989 # type: ignore
"""
``CMPXCHG r/m8, r8``

``0F A6 /r``

``486 A``

``16/32-bit``
"""
CMPXCHG486_RM16_R16: Code = 1990 # type: ignore
"""
``CMPXCHG r/m16, r16``

``o16 0F A7 /r``

``486 A``

``16/32-bit``
"""
CMPXCHG486_RM32_R32: Code = 1991 # type: ignore
"""
``CMPXCHG r/m32, r32``

``o32 0F A7 /r``

``486 A``

``16/32-bit``
"""
PUSHW_GS: Code = 1992 # type: ignore
"""
``PUSH GS``

``o16 0F A8``

``386+``

``16/32/64-bit``
"""
PUSHD_GS: Code = 1993 # type: ignore
"""
``PUSH GS``

``o32 0F A8``

``386+``

``16/32-bit``
"""
PUSHQ_GS: Code = 1994 # type: ignore
"""
``PUSH GS``

``o64 0F A8``

``X64``

``64-bit``
"""
POPW_GS: Code = 1995 # type: ignore
"""
``POP GS``

``o16 0F A9``

``386+``

``16/32/64-bit``
"""
POPD_GS: Code = 1996 # type: ignore
"""
``POP GS``

``o32 0F A9``

``386+``

``16/32-bit``
"""
POPQ_GS: Code = 1997 # type: ignore
"""
``POP GS``

``o64 0F A9``

``X64``

``64-bit``
"""
RSM: Code = 1998 # type: ignore
"""
``RSM``

``0F AA``

``386+``

``16/32/64-bit``
"""
BTS_RM16_R16: Code = 1999 # type: ignore
"""
``BTS r/m16, r16``

``o16 0F AB /r``

``386+``

``16/32/64-bit``
"""
BTS_RM32_R32: Code = 2000 # type: ignore
"""
``BTS r/m32, r32``

``o32 0F AB /r``

``386+``

``16/32/64-bit``
"""
BTS_RM64_R64: Code = 2001 # type: ignore
"""
``BTS r/m64, r64``

``o64 0F AB /r``

``X64``

``64-bit``
"""
SHRD_RM16_R16_IMM8: Code = 2002 # type: ignore
"""
``SHRD r/m16, r16, imm8``

``o16 0F AC /r ib``

``386+``

``16/32/64-bit``
"""
SHRD_RM32_R32_IMM8: Code = 2003 # type: ignore
"""
``SHRD r/m32, r32, imm8``

``o32 0F AC /r ib``

``386+``

``16/32/64-bit``
"""
SHRD_RM64_R64_IMM8: Code = 2004 # type: ignore
"""
``SHRD r/m64, r64, imm8``

``o64 0F AC /r ib``

``X64``

``64-bit``
"""
SHRD_RM16_R16_CL: Code = 2005 # type: ignore
"""
``SHRD r/m16, r16, CL``

``o16 0F AD /r``

``386+``

``16/32/64-bit``
"""
SHRD_RM32_R32_CL: Code = 2006 # type: ignore
"""
``SHRD r/m32, r32, CL``

``o32 0F AD /r``

``386+``

``16/32/64-bit``
"""
SHRD_RM64_R64_CL: Code = 2007 # type: ignore
"""
``SHRD r/m64, r64, CL``

``o64 0F AD /r``

``X64``

``64-bit``
"""
FXSAVE_M512BYTE: Code = 2008 # type: ignore
"""
``FXSAVE m512byte``

``NP 0F AE /0``

``FXSR``

``16/32/64-bit``
"""
FXSAVE64_M512BYTE: Code = 2009 # type: ignore
"""
``FXSAVE64 m512byte``

``NP o64 0F AE /0``

``FXSR``

``64-bit``
"""
RDFSBASE_R32: Code = 2010 # type: ignore
"""
``RDFSBASE r32``

``F3 0F AE /0``

``FSGSBASE``

``64-bit``
"""
RDFSBASE_R64: Code = 2011 # type: ignore
"""
``RDFSBASE r64``

``F3 o64 0F AE /0``

``FSGSBASE``

``64-bit``
"""
FXRSTOR_M512BYTE: Code = 2012 # type: ignore
"""
``FXRSTOR m512byte``

``NP 0F AE /1``

``FXSR``

``16/32/64-bit``
"""
FXRSTOR64_M512BYTE: Code = 2013 # type: ignore
"""
``FXRSTOR64 m512byte``

``NP o64 0F AE /1``

``FXSR``

``64-bit``
"""
RDGSBASE_R32: Code = 2014 # type: ignore
"""
``RDGSBASE r32``

``F3 0F AE /1``

``FSGSBASE``

``64-bit``
"""
RDGSBASE_R64: Code = 2015 # type: ignore
"""
``RDGSBASE r64``

``F3 o64 0F AE /1``

``FSGSBASE``

``64-bit``
"""
LDMXCSR_M32: Code = 2016 # type: ignore
"""
``LDMXCSR m32``

``NP 0F AE /2``

``SSE``

``16/32/64-bit``
"""
WRFSBASE_R32: Code = 2017 # type: ignore
"""
``WRFSBASE r32``

``F3 0F AE /2``

``FSGSBASE``

``64-bit``
"""
WRFSBASE_R64: Code = 2018 # type: ignore
"""
``WRFSBASE r64``

``F3 o64 0F AE /2``

``FSGSBASE``

``64-bit``
"""
VEX_VLDMXCSR_M32: Code = 2019 # type: ignore
"""
``VLDMXCSR m32``

``VEX.LZ.0F.WIG AE /2``

``AVX``

``16/32/64-bit``
"""
STMXCSR_M32: Code = 2020 # type: ignore
"""
``STMXCSR m32``

``NP 0F AE /3``

``SSE``

``16/32/64-bit``
"""
WRGSBASE_R32: Code = 2021 # type: ignore
"""
``WRGSBASE r32``

``F3 0F AE /3``

``FSGSBASE``

``64-bit``
"""
WRGSBASE_R64: Code = 2022 # type: ignore
"""
``WRGSBASE r64``

``F3 o64 0F AE /3``

``FSGSBASE``

``64-bit``
"""
VEX_VSTMXCSR_M32: Code = 2023 # type: ignore
"""
``VSTMXCSR m32``

``VEX.LZ.0F.WIG AE /3``

``AVX``

``16/32/64-bit``
"""
XSAVE_MEM: Code = 2024 # type: ignore
"""
``XSAVE mem``

``NP 0F AE /4``

``XSAVE``

``16/32/64-bit``
"""
XSAVE64_MEM: Code = 2025 # type: ignore
"""
``XSAVE64 mem``

``NP o64 0F AE /4``

``XSAVE``

``64-bit``
"""
PTWRITE_RM32: Code = 2026 # type: ignore
"""
``PTWRITE r/m32``

``F3 0F AE /4``

``PTWRITE``

``16/32/64-bit``
"""
PTWRITE_RM64: Code = 2027 # type: ignore
"""
``PTWRITE r/m64``

``F3 o64 0F AE /4``

``PTWRITE``

``64-bit``
"""
XRSTOR_MEM: Code = 2028 # type: ignore
"""
``XRSTOR mem``

``NP 0F AE /5``

``XSAVE``

``16/32/64-bit``
"""
XRSTOR64_MEM: Code = 2029 # type: ignore
"""
``XRSTOR64 mem``

``NP o64 0F AE /5``

``XSAVE``

``64-bit``
"""
INCSSPD_R32: Code = 2030 # type: ignore
"""
``INCSSPD r32``

``F3 0F AE /5``

``CET_SS``

``16/32/64-bit``
"""
INCSSPQ_R64: Code = 2031 # type: ignore
"""
``INCSSPQ r64``

``F3 o64 0F AE /5``

``CET_SS``

``64-bit``
"""
XSAVEOPT_MEM: Code = 2032 # type: ignore
"""
``XSAVEOPT mem``

``NP 0F AE /6``

``XSAVEOPT``

``16/32/64-bit``
"""
XSAVEOPT64_MEM: Code = 2033 # type: ignore
"""
``XSAVEOPT64 mem``

``NP o64 0F AE /6``

``XSAVEOPT``

``64-bit``
"""
CLWB_M8: Code = 2034 # type: ignore
"""
``CLWB m8``

``66 0F AE /6``

``CLWB``

``16/32/64-bit``
"""
TPAUSE_R32: Code = 2035 # type: ignore
"""
``TPAUSE r32, <edx>, <eax>``

``66 0F AE /6``

``WAITPKG``

``16/32/64-bit``
"""
TPAUSE_R64: Code = 2036 # type: ignore
"""
``TPAUSE r64, <edx>, <eax>``

``66 o64 0F AE /6``

``WAITPKG``

``64-bit``
"""
CLRSSBSY_M64: Code = 2037 # type: ignore
"""
``CLRSSBSY m64``

``F3 0F AE /6``

``CET_SS``

``16/32/64-bit``
"""
UMONITOR_R16: Code = 2038 # type: ignore
"""
``UMONITOR r16``

``a16 F3 0F AE /6``

``WAITPKG``

``16/32-bit``
"""
UMONITOR_R32: Code = 2039 # type: ignore
"""
``UMONITOR r32``

``a32 F3 0F AE /6``

``WAITPKG``

``16/32/64-bit``
"""
UMONITOR_R64: Code = 2040 # type: ignore
"""
``UMONITOR r64``

``a64 F3 0F AE /6``

``WAITPKG``

``64-bit``
"""
UMWAIT_R32: Code = 2041 # type: ignore
"""
``UMWAIT r32, <edx>, <eax>``

``F2 0F AE /6``

``WAITPKG``

``16/32/64-bit``
"""
UMWAIT_R64: Code = 2042 # type: ignore
"""
``UMWAIT r64, <edx>, <eax>``

``F2 o64 0F AE /6``

``WAITPKG``

``64-bit``
"""
CLFLUSH_M8: Code = 2043 # type: ignore
"""
``CLFLUSH m8``

``NP 0F AE /7``

``CLFSH``

``16/32/64-bit``
"""
CLFLUSHOPT_M8: Code = 2044 # type: ignore
"""
``CLFLUSHOPT m8``

``66 0F AE /7``

``CLFLUSHOPT``

``16/32/64-bit``
"""
LFENCE: Code = 2045 # type: ignore
"""
``LFENCE``

``NP 0F AE E8``

``SSE2``

``16/32/64-bit``
"""
LFENCE_E9: Code = 2046 # type: ignore
"""
``LFENCE``

``NP 0F AE E9``

``SSE2``

``16/32/64-bit``
"""
LFENCE_EA: Code = 2047 # type: ignore
"""
``LFENCE``

``NP 0F AE EA``

``SSE2``

``16/32/64-bit``
"""
LFENCE_EB: Code = 2048 # type: ignore
"""
``LFENCE``

``NP 0F AE EB``

``SSE2``

``16/32/64-bit``
"""
LFENCE_EC: Code = 2049 # type: ignore
"""
``LFENCE``

``NP 0F AE EC``

``SSE2``

``16/32/64-bit``
"""
LFENCE_ED: Code = 2050 # type: ignore
"""
``LFENCE``

``NP 0F AE ED``

``SSE2``

``16/32/64-bit``
"""
LFENCE_EE: Code = 2051 # type: ignore
"""
``LFENCE``

``NP 0F AE EE``

``SSE2``

``16/32/64-bit``
"""
LFENCE_EF: Code = 2052 # type: ignore
"""
``LFENCE``

``NP 0F AE EF``

``SSE2``

``16/32/64-bit``
"""
MFENCE: Code = 2053 # type: ignore
"""
``MFENCE``

``NP 0F AE F0``

``SSE2``

``16/32/64-bit``
"""
MFENCE_F1: Code = 2054 # type: ignore
"""
``MFENCE``

``NP 0F AE F1``

``SSE2``

``16/32/64-bit``
"""
MFENCE_F2: Code = 2055 # type: ignore
"""
``MFENCE``

``NP 0F AE F2``

``SSE2``

``16/32/64-bit``
"""
MFENCE_F3: Code = 2056 # type: ignore
"""
``MFENCE``

``NP 0F AE F3``

``SSE2``

``16/32/64-bit``
"""
MFENCE_F4: Code = 2057 # type: ignore
"""
``MFENCE``

``NP 0F AE F4``

``SSE2``

``16/32/64-bit``
"""
MFENCE_F5: Code = 2058 # type: ignore
"""
``MFENCE``

``NP 0F AE F5``

``SSE2``

``16/32/64-bit``
"""
MFENCE_F6: Code = 2059 # type: ignore
"""
``MFENCE``

``NP 0F AE F6``

``SSE2``

``16/32/64-bit``
"""
MFENCE_F7: Code = 2060 # type: ignore
"""
``MFENCE``

``NP 0F AE F7``

``SSE2``

``16/32/64-bit``
"""
SFENCE: Code = 2061 # type: ignore
"""
``SFENCE``

``NP 0F AE F8``

``SSE``

``16/32/64-bit``
"""
SFENCE_F9: Code = 2062 # type: ignore
"""
``SFENCE``

``NP 0F AE F9``

``SSE``

``16/32/64-bit``
"""
SFENCE_FA: Code = 2063 # type: ignore
"""
``SFENCE``

``NP 0F AE FA``

``SSE``

``16/32/64-bit``
"""
SFENCE_FB: Code = 2064 # type: ignore
"""
``SFENCE``

``NP 0F AE FB``

``SSE``

``16/32/64-bit``
"""
SFENCE_FC: Code = 2065 # type: ignore
"""
``SFENCE``

``NP 0F AE FC``

``SSE``

``16/32/64-bit``
"""
SFENCE_FD: Code = 2066 # type: ignore
"""
``SFENCE``

``NP 0F AE FD``

``SSE``

``16/32/64-bit``
"""
SFENCE_FE: Code = 2067 # type: ignore
"""
``SFENCE``

``NP 0F AE FE``

``SSE``

``16/32/64-bit``
"""
SFENCE_FF: Code = 2068 # type: ignore
"""
``SFENCE``

``NP 0F AE FF``

``SSE``

``16/32/64-bit``
"""
PCOMMIT: Code = 2069 # type: ignore
"""
``PCOMMIT``

``66 0F AE F8``

``PCOMMIT``

``16/32/64-bit``
"""
IMUL_R16_RM16: Code = 2070 # type: ignore
"""
``IMUL r16, r/m16``

``o16 0F AF /r``

``386+``

``16/32/64-bit``
"""
IMUL_R32_RM32: Code = 2071 # type: ignore
"""
``IMUL r32, r/m32``

``o32 0F AF /r``

``386+``

``16/32/64-bit``
"""
IMUL_R64_RM64: Code = 2072 # type: ignore
"""
``IMUL r64, r/m64``

``o64 0F AF /r``

``X64``

``64-bit``
"""
CMPXCHG_RM8_R8: Code = 2073 # type: ignore
"""
``CMPXCHG r/m8, r8``

``0F B0 /r``

``486+``

``16/32/64-bit``
"""
CMPXCHG_RM16_R16: Code = 2074 # type: ignore
"""
``CMPXCHG r/m16, r16``

``o16 0F B1 /r``

``486+``

``16/32/64-bit``
"""
CMPXCHG_RM32_R32: Code = 2075 # type: ignore
"""
``CMPXCHG r/m32, r32``

``o32 0F B1 /r``

``486+``

``16/32/64-bit``
"""
CMPXCHG_RM64_R64: Code = 2076 # type: ignore
"""
``CMPXCHG r/m64, r64``

``o64 0F B1 /r``

``X64``

``64-bit``
"""
LSS_R16_M1616: Code = 2077 # type: ignore
"""
``LSS r16, m16:16``

``o16 0F B2 /r``

``386+``

``16/32/64-bit``
"""
LSS_R32_M1632: Code = 2078 # type: ignore
"""
``LSS r32, m16:32``

``o32 0F B2 /r``

``386+``

``16/32/64-bit``
"""
LSS_R64_M1664: Code = 2079 # type: ignore
"""
``LSS r64, m16:64``

``o64 0F B2 /r``

``X64``

``64-bit``
"""
BTR_RM16_R16: Code = 2080 # type: ignore
"""
``BTR r/m16, r16``

``o16 0F B3 /r``

``386+``

``16/32/64-bit``
"""
BTR_RM32_R32: Code = 2081 # type: ignore
"""
``BTR r/m32, r32``

``o32 0F B3 /r``

``386+``

``16/32/64-bit``
"""
BTR_RM64_R64: Code = 2082 # type: ignore
"""
``BTR r/m64, r64``

``o64 0F B3 /r``

``X64``

``64-bit``
"""
LFS_R16_M1616: Code = 2083 # type: ignore
"""
``LFS r16, m16:16``

``o16 0F B4 /r``

``386+``

``16/32/64-bit``
"""
LFS_R32_M1632: Code = 2084 # type: ignore
"""
``LFS r32, m16:32``

``o32 0F B4 /r``

``386+``

``16/32/64-bit``
"""
LFS_R64_M1664: Code = 2085 # type: ignore
"""
``LFS r64, m16:64``

``o64 0F B4 /r``

``X64``

``64-bit``
"""
LGS_R16_M1616: Code = 2086 # type: ignore
"""
``LGS r16, m16:16``

``o16 0F B5 /r``

``386+``

``16/32/64-bit``
"""
LGS_R32_M1632: Code = 2087 # type: ignore
"""
``LGS r32, m16:32``

``o32 0F B5 /r``

``386+``

``16/32/64-bit``
"""
LGS_R64_M1664: Code = 2088 # type: ignore
"""
``LGS r64, m16:64``

``o64 0F B5 /r``

``X64``

``64-bit``
"""
MOVZX_R16_RM8: Code = 2089 # type: ignore
"""
``MOVZX r16, r/m8``

``o16 0F B6 /r``

``386+``

``16/32/64-bit``
"""
MOVZX_R32_RM8: Code = 2090 # type: ignore
"""
``MOVZX r32, r/m8``

``o32 0F B6 /r``

``386+``

``16/32/64-bit``
"""
MOVZX_R64_RM8: Code = 2091 # type: ignore
"""
``MOVZX r64, r/m8``

``o64 0F B6 /r``

``X64``

``64-bit``
"""
MOVZX_R16_RM16: Code = 2092 # type: ignore
"""
``MOVZX r16, r/m16``

``o16 0F B7 /r``

``386+``

``16/32/64-bit``
"""
MOVZX_R32_RM16: Code = 2093 # type: ignore
"""
``MOVZX r32, r/m16``

``o32 0F B7 /r``

``386+``

``16/32/64-bit``
"""
MOVZX_R64_RM16: Code = 2094 # type: ignore
"""
``MOVZX r64, r/m16``

``o64 0F B7 /r``

``X64``

``64-bit``
"""
JMPE_DISP16: Code = 2095 # type: ignore
"""
``JMPE disp16``

``o16 0F B8 cw``

``IA-64``

``16/32-bit``
"""
JMPE_DISP32: Code = 2096 # type: ignore
"""
``JMPE disp32``

``o32 0F B8 cd``

``IA-64``

``16/32-bit``
"""
POPCNT_R16_RM16: Code = 2097 # type: ignore
"""
``POPCNT r16, r/m16``

``o16 F3 0F B8 /r``

``POPCNT``

``16/32/64-bit``
"""
POPCNT_R32_RM32: Code = 2098 # type: ignore
"""
``POPCNT r32, r/m32``

``o32 F3 0F B8 /r``

``POPCNT``

``16/32/64-bit``
"""
POPCNT_R64_RM64: Code = 2099 # type: ignore
"""
``POPCNT r64, r/m64``

``F3 o64 0F B8 /r``

``POPCNT``

``64-bit``
"""
UD1_R16_RM16: Code = 2100 # type: ignore
"""
``UD1 r16, r/m16``

``o16 0F B9 /r``

``286+``

``16/32/64-bit``
"""
UD1_R32_RM32: Code = 2101 # type: ignore
"""
``UD1 r32, r/m32``

``o32 0F B9 /r``

``386+``

``16/32/64-bit``
"""
UD1_R64_RM64: Code = 2102 # type: ignore
"""
``UD1 r64, r/m64``

``o64 0F B9 /r``

``X64``

``64-bit``
"""
BT_RM16_IMM8: Code = 2103 # type: ignore
"""
``BT r/m16, imm8``

``o16 0F BA /4 ib``

``386+``

``16/32/64-bit``
"""
BT_RM32_IMM8: Code = 2104 # type: ignore
"""
``BT r/m32, imm8``

``o32 0F BA /4 ib``

``386+``

``16/32/64-bit``
"""
BT_RM64_IMM8: Code = 2105 # type: ignore
"""
``BT r/m64, imm8``

``o64 0F BA /4 ib``

``X64``

``64-bit``
"""
BTS_RM16_IMM8: Code = 2106 # type: ignore
"""
``BTS r/m16, imm8``

``o16 0F BA /5 ib``

``386+``

``16/32/64-bit``
"""
BTS_RM32_IMM8: Code = 2107 # type: ignore
"""
``BTS r/m32, imm8``

``o32 0F BA /5 ib``

``386+``

``16/32/64-bit``
"""
BTS_RM64_IMM8: Code = 2108 # type: ignore
"""
``BTS r/m64, imm8``

``o64 0F BA /5 ib``

``X64``

``64-bit``
"""
BTR_RM16_IMM8: Code = 2109 # type: ignore
"""
``BTR r/m16, imm8``

``o16 0F BA /6 ib``

``386+``

``16/32/64-bit``
"""
BTR_RM32_IMM8: Code = 2110 # type: ignore
"""
``BTR r/m32, imm8``

``o32 0F BA /6 ib``

``386+``

``16/32/64-bit``
"""
BTR_RM64_IMM8: Code = 2111 # type: ignore
"""
``BTR r/m64, imm8``

``o64 0F BA /6 ib``

``X64``

``64-bit``
"""
BTC_RM16_IMM8: Code = 2112 # type: ignore
"""
``BTC r/m16, imm8``

``o16 0F BA /7 ib``

``386+``

``16/32/64-bit``
"""
BTC_RM32_IMM8: Code = 2113 # type: ignore
"""
``BTC r/m32, imm8``

``o32 0F BA /7 ib``

``386+``

``16/32/64-bit``
"""
BTC_RM64_IMM8: Code = 2114 # type: ignore
"""
``BTC r/m64, imm8``

``o64 0F BA /7 ib``

``X64``

``64-bit``
"""
BTC_RM16_R16: Code = 2115 # type: ignore
"""
``BTC r/m16, r16``

``o16 0F BB /r``

``386+``

``16/32/64-bit``
"""
BTC_RM32_R32: Code = 2116 # type: ignore
"""
``BTC r/m32, r32``

``o32 0F BB /r``

``386+``

``16/32/64-bit``
"""
BTC_RM64_R64: Code = 2117 # type: ignore
"""
``BTC r/m64, r64``

``o64 0F BB /r``

``X64``

``64-bit``
"""
BSF_R16_RM16: Code = 2118 # type: ignore
"""
``BSF r16, r/m16``

``o16 0F BC /r``

``386+``

``16/32/64-bit``
"""
BSF_R32_RM32: Code = 2119 # type: ignore
"""
``BSF r32, r/m32``

``o32 0F BC /r``

``386+``

``16/32/64-bit``
"""
BSF_R64_RM64: Code = 2120 # type: ignore
"""
``BSF r64, r/m64``

``o64 0F BC /r``

``X64``

``64-bit``
"""
TZCNT_R16_RM16: Code = 2121 # type: ignore
"""
``TZCNT r16, r/m16``

``o16 F3 0F BC /r``

``BMI1``

``16/32/64-bit``
"""
TZCNT_R32_RM32: Code = 2122 # type: ignore
"""
``TZCNT r32, r/m32``

``o32 F3 0F BC /r``

``BMI1``

``16/32/64-bit``
"""
TZCNT_R64_RM64: Code = 2123 # type: ignore
"""
``TZCNT r64, r/m64``

``F3 o64 0F BC /r``

``BMI1``

``64-bit``
"""
BSR_R16_RM16: Code = 2124 # type: ignore
"""
``BSR r16, r/m16``

``o16 0F BD /r``

``386+``

``16/32/64-bit``
"""
BSR_R32_RM32: Code = 2125 # type: ignore
"""
``BSR r32, r/m32``

``o32 0F BD /r``

``386+``

``16/32/64-bit``
"""
BSR_R64_RM64: Code = 2126 # type: ignore
"""
``BSR r64, r/m64``

``o64 0F BD /r``

``X64``

``64-bit``
"""
LZCNT_R16_RM16: Code = 2127 # type: ignore
"""
``LZCNT r16, r/m16``

``o16 F3 0F BD /r``

``LZCNT``

``16/32/64-bit``
"""
LZCNT_R32_RM32: Code = 2128 # type: ignore
"""
``LZCNT r32, r/m32``

``o32 F3 0F BD /r``

``LZCNT``

``16/32/64-bit``
"""
LZCNT_R64_RM64: Code = 2129 # type: ignore
"""
``LZCNT r64, r/m64``

``F3 o64 0F BD /r``

``LZCNT``

``64-bit``
"""
MOVSX_R16_RM8: Code = 2130 # type: ignore
"""
``MOVSX r16, r/m8``

``o16 0F BE /r``

``386+``

``16/32/64-bit``
"""
MOVSX_R32_RM8: Code = 2131 # type: ignore
"""
``MOVSX r32, r/m8``

``o32 0F BE /r``

``386+``

``16/32/64-bit``
"""
MOVSX_R64_RM8: Code = 2132 # type: ignore
"""
``MOVSX r64, r/m8``

``o64 0F BE /r``

``X64``

``64-bit``
"""
MOVSX_R16_RM16: Code = 2133 # type: ignore
"""
``MOVSX r16, r/m16``

``o16 0F BF /r``

``386+``

``16/32/64-bit``
"""
MOVSX_R32_RM16: Code = 2134 # type: ignore
"""
``MOVSX r32, r/m16``

``o32 0F BF /r``

``386+``

``16/32/64-bit``
"""
MOVSX_R64_RM16: Code = 2135 # type: ignore
"""
``MOVSX r64, r/m16``

``o64 0F BF /r``

``X64``

``64-bit``
"""
XADD_RM8_R8: Code = 2136 # type: ignore
"""
``XADD r/m8, r8``

``0F C0 /r``

``486+``

``16/32/64-bit``
"""
XADD_RM16_R16: Code = 2137 # type: ignore
"""
``XADD r/m16, r16``

``o16 0F C1 /r``

``486+``

``16/32/64-bit``
"""
XADD_RM32_R32: Code = 2138 # type: ignore
"""
``XADD r/m32, r32``

``o32 0F C1 /r``

``486+``

``16/32/64-bit``
"""
XADD_RM64_R64: Code = 2139 # type: ignore
"""
``XADD r/m64, r64``

``o64 0F C1 /r``

``X64``

``64-bit``
"""
CMPPS_XMM_XMMM128_IMM8: Code = 2140 # type: ignore
"""
``CMPPS xmm1, xmm2/m128, imm8``

``NP 0F C2 /r ib``

``SSE``

``16/32/64-bit``
"""
VEX_VCMPPS_XMM_XMM_XMMM128_IMM8: Code = 2141 # type: ignore
"""
``VCMPPS xmm1, xmm2, xmm3/m128, imm8``

``VEX.128.0F.WIG C2 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VCMPPS_YMM_YMM_YMMM256_IMM8: Code = 2142 # type: ignore
"""
``VCMPPS ymm1, ymm2, ymm3/m256, imm8``

``VEX.256.0F.WIG C2 /r ib``

``AVX``

``16/32/64-bit``
"""
EVEX_VCMPPS_KR_K1_XMM_XMMM128B32_IMM8: Code = 2143 # type: ignore
"""
``VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8``

``EVEX.128.0F.W0 C2 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCMPPS_KR_K1_YMM_YMMM256B32_IMM8: Code = 2144 # type: ignore
"""
``VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8``

``EVEX.256.0F.W0 C2 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCMPPS_KR_K1_ZMM_ZMMM512B32_IMM8_SAE: Code = 2145 # type: ignore
"""
``VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8``

``EVEX.512.0F.W0 C2 /r ib``

``AVX512F``

``16/32/64-bit``
"""
CMPPD_XMM_XMMM128_IMM8: Code = 2146 # type: ignore
"""
``CMPPD xmm1, xmm2/m128, imm8``

``66 0F C2 /r ib``

``SSE2``

``16/32/64-bit``
"""
VEX_VCMPPD_XMM_XMM_XMMM128_IMM8: Code = 2147 # type: ignore
"""
``VCMPPD xmm1, xmm2, xmm3/m128, imm8``

``VEX.128.66.0F.WIG C2 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VCMPPD_YMM_YMM_YMMM256_IMM8: Code = 2148 # type: ignore
"""
``VCMPPD ymm1, ymm2, ymm3/m256, imm8``

``VEX.256.66.0F.WIG C2 /r ib``

``AVX``

``16/32/64-bit``
"""
EVEX_VCMPPD_KR_K1_XMM_XMMM128B64_IMM8: Code = 2149 # type: ignore
"""
``VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8``

``EVEX.128.66.0F.W1 C2 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCMPPD_KR_K1_YMM_YMMM256B64_IMM8: Code = 2150 # type: ignore
"""
``VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8``

``EVEX.256.66.0F.W1 C2 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCMPPD_KR_K1_ZMM_ZMMM512B64_IMM8_SAE: Code = 2151 # type: ignore
"""
``VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8``

``EVEX.512.66.0F.W1 C2 /r ib``

``AVX512F``

``16/32/64-bit``
"""
CMPSS_XMM_XMMM32_IMM8: Code = 2152 # type: ignore
"""
``CMPSS xmm1, xmm2/m32, imm8``

``F3 0F C2 /r ib``

``SSE``

``16/32/64-bit``
"""
VEX_VCMPSS_XMM_XMM_XMMM32_IMM8: Code = 2153 # type: ignore
"""
``VCMPSS xmm1, xmm2, xmm3/m32, imm8``

``VEX.LIG.F3.0F.WIG C2 /r ib``

``AVX``

``16/32/64-bit``
"""
EVEX_VCMPSS_KR_K1_XMM_XMMM32_IMM8_SAE: Code = 2154 # type: ignore
"""
``VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8``

``EVEX.LIG.F3.0F.W0 C2 /r ib``

``AVX512F``

``16/32/64-bit``
"""
CMPSD_XMM_XMMM64_IMM8: Code = 2155 # type: ignore
"""
``CMPSD xmm1, xmm2/m64, imm8``

``F2 0F C2 /r ib``

``SSE2``

``16/32/64-bit``
"""
VEX_VCMPSD_XMM_XMM_XMMM64_IMM8: Code = 2156 # type: ignore
"""
``VCMPSD xmm1, xmm2, xmm3/m64, imm8``

``VEX.LIG.F2.0F.WIG C2 /r ib``

``AVX``

``16/32/64-bit``
"""
EVEX_VCMPSD_KR_K1_XMM_XMMM64_IMM8_SAE: Code = 2157 # type: ignore
"""
``VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8``

``EVEX.LIG.F2.0F.W1 C2 /r ib``

``AVX512F``

``16/32/64-bit``
"""
MOVNTI_M32_R32: Code = 2158 # type: ignore
"""
``MOVNTI m32, r32``

``NP 0F C3 /r``

``SSE2``

``16/32/64-bit``
"""
MOVNTI_M64_R64: Code = 2159 # type: ignore
"""
``MOVNTI m64, r64``

``NP o64 0F C3 /r``

``SSE2``

``64-bit``
"""
PINSRW_MM_R32M16_IMM8: Code = 2160 # type: ignore
"""
``PINSRW mm, r32/m16, imm8``

``NP 0F C4 /r ib``

``SSE``

``16/32/64-bit``
"""
PINSRW_MM_R64M16_IMM8: Code = 2161 # type: ignore
"""
``PINSRW mm, r64/m16, imm8``

``NP o64 0F C4 /r ib``

``SSE``

``64-bit``
"""
PINSRW_XMM_R32M16_IMM8: Code = 2162 # type: ignore
"""
``PINSRW xmm, r32/m16, imm8``

``66 0F C4 /r ib``

``SSE2``

``16/32/64-bit``
"""
PINSRW_XMM_R64M16_IMM8: Code = 2163 # type: ignore
"""
``PINSRW xmm, r64/m16, imm8``

``66 o64 0F C4 /r ib``

``SSE2``

``64-bit``
"""
VEX_VPINSRW_XMM_XMM_R32M16_IMM8: Code = 2164 # type: ignore
"""
``VPINSRW xmm1, xmm2, r32/m16, imm8``

``VEX.128.66.0F.W0 C4 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPINSRW_XMM_XMM_R64M16_IMM8: Code = 2165 # type: ignore
"""
``VPINSRW xmm1, xmm2, r64/m16, imm8``

``VEX.128.66.0F.W1 C4 /r ib``

``AVX``

``64-bit``
"""
EVEX_VPINSRW_XMM_XMM_R32M16_IMM8: Code = 2166 # type: ignore
"""
``VPINSRW xmm1, xmm2, r32/m16, imm8``

``EVEX.128.66.0F.W0 C4 /r ib``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPINSRW_XMM_XMM_R64M16_IMM8: Code = 2167 # type: ignore
"""
``VPINSRW xmm1, xmm2, r64/m16, imm8``

``EVEX.128.66.0F.W1 C4 /r ib``

``AVX512BW``

``64-bit``
"""
PEXTRW_R32_MM_IMM8: Code = 2168 # type: ignore
"""
``PEXTRW r32, mm, imm8``

``NP 0F C5 /r ib``

``SSE``

``16/32/64-bit``
"""
PEXTRW_R64_MM_IMM8: Code = 2169 # type: ignore
"""
``PEXTRW r64, mm, imm8``

``NP o64 0F C5 /r ib``

``SSE``

``64-bit``
"""
PEXTRW_R32_XMM_IMM8: Code = 2170 # type: ignore
"""
``PEXTRW r32, xmm, imm8``

``66 0F C5 /r ib``

``SSE2``

``16/32/64-bit``
"""
PEXTRW_R64_XMM_IMM8: Code = 2171 # type: ignore
"""
``PEXTRW r64, xmm, imm8``

``66 o64 0F C5 /r ib``

``SSE2``

``64-bit``
"""
VEX_VPEXTRW_R32_XMM_IMM8: Code = 2172 # type: ignore
"""
``VPEXTRW r32, xmm1, imm8``

``VEX.128.66.0F.W0 C5 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPEXTRW_R64_XMM_IMM8: Code = 2173 # type: ignore
"""
``VPEXTRW r64, xmm1, imm8``

``VEX.128.66.0F.W1 C5 /r ib``

``AVX``

``64-bit``
"""
EVEX_VPEXTRW_R32_XMM_IMM8: Code = 2174 # type: ignore
"""
``VPEXTRW r32, xmm1, imm8``

``EVEX.128.66.0F.W0 C5 /r ib``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPEXTRW_R64_XMM_IMM8: Code = 2175 # type: ignore
"""
``VPEXTRW r64, xmm1, imm8``

``EVEX.128.66.0F.W1 C5 /r ib``

``AVX512BW``

``64-bit``
"""
SHUFPS_XMM_XMMM128_IMM8: Code = 2176 # type: ignore
"""
``SHUFPS xmm1, xmm2/m128, imm8``

``NP 0F C6 /r ib``

``SSE``

``16/32/64-bit``
"""
VEX_VSHUFPS_XMM_XMM_XMMM128_IMM8: Code = 2177 # type: ignore
"""
``VSHUFPS xmm1, xmm2, xmm3/m128, imm8``

``VEX.128.0F.WIG C6 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VSHUFPS_YMM_YMM_YMMM256_IMM8: Code = 2178 # type: ignore
"""
``VSHUFPS ymm1, ymm2, ymm3/m256, imm8``

``VEX.256.0F.WIG C6 /r ib``

``AVX``

``16/32/64-bit``
"""
EVEX_VSHUFPS_XMM_K1Z_XMM_XMMM128B32_IMM8: Code = 2179 # type: ignore
"""
``VSHUFPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8``

``EVEX.128.0F.W0 C6 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSHUFPS_YMM_K1Z_YMM_YMMM256B32_IMM8: Code = 2180 # type: ignore
"""
``VSHUFPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8``

``EVEX.256.0F.W0 C6 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSHUFPS_ZMM_K1Z_ZMM_ZMMM512B32_IMM8: Code = 2181 # type: ignore
"""
``VSHUFPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst, imm8``

``EVEX.512.0F.W0 C6 /r ib``

``AVX512F``

``16/32/64-bit``
"""
SHUFPD_XMM_XMMM128_IMM8: Code = 2182 # type: ignore
"""
``SHUFPD xmm1, xmm2/m128, imm8``

``66 0F C6 /r ib``

``SSE2``

``16/32/64-bit``
"""
VEX_VSHUFPD_XMM_XMM_XMMM128_IMM8: Code = 2183 # type: ignore
"""
``VSHUFPD xmm1, xmm2, xmm3/m128, imm8``

``VEX.128.66.0F.WIG C6 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VSHUFPD_YMM_YMM_YMMM256_IMM8: Code = 2184 # type: ignore
"""
``VSHUFPD ymm1, ymm2, ymm3/m256, imm8``

``VEX.256.66.0F.WIG C6 /r ib``

``AVX``

``16/32/64-bit``
"""
EVEX_VSHUFPD_XMM_K1Z_XMM_XMMM128B64_IMM8: Code = 2185 # type: ignore
"""
``VSHUFPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8``

``EVEX.128.66.0F.W1 C6 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSHUFPD_YMM_K1Z_YMM_YMMM256B64_IMM8: Code = 2186 # type: ignore
"""
``VSHUFPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8``

``EVEX.256.66.0F.W1 C6 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSHUFPD_ZMM_K1Z_ZMM_ZMMM512B64_IMM8: Code = 2187 # type: ignore
"""
``VSHUFPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8``

``EVEX.512.66.0F.W1 C6 /r ib``

``AVX512F``

``16/32/64-bit``
"""
CMPXCHG8B_M64: Code = 2188 # type: ignore
"""
``CMPXCHG8B m64``

``0F C7 /1``

``CX8``

``16/32/64-bit``
"""
CMPXCHG16B_M128: Code = 2189 # type: ignore
"""
``CMPXCHG16B m128``

``o64 0F C7 /1``

``CMPXCHG16B``

``64-bit``
"""
XRSTORS_MEM: Code = 2190 # type: ignore
"""
``XRSTORS mem``

``NP 0F C7 /3``

``XSAVES``

``16/32/64-bit``
"""
XRSTORS64_MEM: Code = 2191 # type: ignore
"""
``XRSTORS64 mem``

``NP o64 0F C7 /3``

``XSAVES``

``64-bit``
"""
XSAVEC_MEM: Code = 2192 # type: ignore
"""
``XSAVEC mem``

``NP 0F C7 /4``

``XSAVEC``

``16/32/64-bit``
"""
XSAVEC64_MEM: Code = 2193 # type: ignore
"""
``XSAVEC64 mem``

``NP o64 0F C7 /4``

``XSAVEC``

``64-bit``
"""
XSAVES_MEM: Code = 2194 # type: ignore
"""
``XSAVES mem``

``NP 0F C7 /5``

``XSAVES``

``16/32/64-bit``
"""
XSAVES64_MEM: Code = 2195 # type: ignore
"""
``XSAVES64 mem``

``NP o64 0F C7 /5``

``XSAVES``

``64-bit``
"""
VMPTRLD_M64: Code = 2196 # type: ignore
"""
``VMPTRLD m64``

``NP 0F C7 /6``

``VMX``

``16/32/64-bit``
"""
VMCLEAR_M64: Code = 2197 # type: ignore
"""
``VMCLEAR m64``

``66 0F C7 /6``

``VMX``

``16/32/64-bit``
"""
VMXON_M64: Code = 2198 # type: ignore
"""
``VMXON m64``

``F3 0F C7 /6``

``VMX``

``16/32/64-bit``
"""
RDRAND_R16: Code = 2199 # type: ignore
"""
``RDRAND r16``

``o16 0F C7 /6``

``RDRAND``

``16/32/64-bit``
"""
RDRAND_R32: Code = 2200 # type: ignore
"""
``RDRAND r32``

``o32 0F C7 /6``

``RDRAND``

``16/32/64-bit``
"""
RDRAND_R64: Code = 2201 # type: ignore
"""
``RDRAND r64``

``o64 0F C7 /6``

``RDRAND``

``64-bit``
"""
VMPTRST_M64: Code = 2202 # type: ignore
"""
``VMPTRST m64``

``NP 0F C7 /7``

``VMX``

``16/32/64-bit``
"""
RDSEED_R16: Code = 2203 # type: ignore
"""
``RDSEED r16``

``o16 0F C7 /7``

``RDSEED``

``16/32/64-bit``
"""
RDSEED_R32: Code = 2204 # type: ignore
"""
``RDSEED r32``

``o32 0F C7 /7``

``RDSEED``

``16/32/64-bit``
"""
RDSEED_R64: Code = 2205 # type: ignore
"""
``RDSEED r64``

``o64 0F C7 /7``

``RDSEED``

``64-bit``
"""
RDPID_R32: Code = 2206 # type: ignore
"""
``RDPID r32``

``F3 0F C7 /7``

``RDPID``

``16/32-bit``
"""
RDPID_R64: Code = 2207 # type: ignore
"""
``RDPID r64``

``F3 0F C7 /7``

``RDPID``

``64-bit``
"""
BSWAP_R16: Code = 2208 # type: ignore
"""
``BSWAP r16``

``o16 0F C8+rw``

``486+``

``16/32/64-bit``
"""
BSWAP_R32: Code = 2209 # type: ignore
"""
``BSWAP r32``

``o32 0F C8+rd``

``486+``

``16/32/64-bit``
"""
BSWAP_R64: Code = 2210 # type: ignore
"""
``BSWAP r64``

``o64 0F C8+ro``

``X64``

``64-bit``
"""
ADDSUBPD_XMM_XMMM128: Code = 2211 # type: ignore
"""
``ADDSUBPD xmm1, xmm2/m128``

``66 0F D0 /r``

``SSE3``

``16/32/64-bit``
"""
VEX_VADDSUBPD_XMM_XMM_XMMM128: Code = 2212 # type: ignore
"""
``VADDSUBPD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG D0 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VADDSUBPD_YMM_YMM_YMMM256: Code = 2213 # type: ignore
"""
``VADDSUBPD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG D0 /r``

``AVX``

``16/32/64-bit``
"""
ADDSUBPS_XMM_XMMM128: Code = 2214 # type: ignore
"""
``ADDSUBPS xmm1, xmm2/m128``

``F2 0F D0 /r``

``SSE3``

``16/32/64-bit``
"""
VEX_VADDSUBPS_XMM_XMM_XMMM128: Code = 2215 # type: ignore
"""
``VADDSUBPS xmm1, xmm2, xmm3/m128``

``VEX.128.F2.0F.WIG D0 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VADDSUBPS_YMM_YMM_YMMM256: Code = 2216 # type: ignore
"""
``VADDSUBPS ymm1, ymm2, ymm3/m256``

``VEX.256.F2.0F.WIG D0 /r``

``AVX``

``16/32/64-bit``
"""
PSRLW_MM_MMM64: Code = 2217 # type: ignore
"""
``PSRLW mm, mm/m64``

``NP 0F D1 /r``

``MMX``

``16/32/64-bit``
"""
PSRLW_XMM_XMMM128: Code = 2218 # type: ignore
"""
``PSRLW xmm1, xmm2/m128``

``66 0F D1 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSRLW_XMM_XMM_XMMM128: Code = 2219 # type: ignore
"""
``VPSRLW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG D1 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSRLW_YMM_YMM_XMMM128: Code = 2220 # type: ignore
"""
``VPSRLW ymm1, ymm2, xmm3/m128``

``VEX.256.66.0F.WIG D1 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSRLW_XMM_K1Z_XMM_XMMM128: Code = 2221 # type: ignore
"""
``VPSRLW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG D1 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSRLW_YMM_K1Z_YMM_XMMM128: Code = 2222 # type: ignore
"""
``VPSRLW ymm1 {k1}{z}, ymm2, xmm3/m128``

``EVEX.256.66.0F.WIG D1 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSRLW_ZMM_K1Z_ZMM_XMMM128: Code = 2223 # type: ignore
"""
``VPSRLW zmm1 {k1}{z}, zmm2, xmm3/m128``

``EVEX.512.66.0F.WIG D1 /r``

``AVX512BW``

``16/32/64-bit``
"""
PSRLD_MM_MMM64: Code = 2224 # type: ignore
"""
``PSRLD mm, mm/m64``

``NP 0F D2 /r``

``MMX``

``16/32/64-bit``
"""
PSRLD_XMM_XMMM128: Code = 2225 # type: ignore
"""
``PSRLD xmm1, xmm2/m128``

``66 0F D2 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSRLD_XMM_XMM_XMMM128: Code = 2226 # type: ignore
"""
``VPSRLD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG D2 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSRLD_YMM_YMM_XMMM128: Code = 2227 # type: ignore
"""
``VPSRLD ymm1, ymm2, xmm3/m128``

``VEX.256.66.0F.WIG D2 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSRLD_XMM_K1Z_XMM_XMMM128: Code = 2228 # type: ignore
"""
``VPSRLD xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.W0 D2 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRLD_YMM_K1Z_YMM_XMMM128: Code = 2229 # type: ignore
"""
``VPSRLD ymm1 {k1}{z}, ymm2, xmm3/m128``

``EVEX.256.66.0F.W0 D2 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRLD_ZMM_K1Z_ZMM_XMMM128: Code = 2230 # type: ignore
"""
``VPSRLD zmm1 {k1}{z}, zmm2, xmm3/m128``

``EVEX.512.66.0F.W0 D2 /r``

``AVX512F``

``16/32/64-bit``
"""
PSRLQ_MM_MMM64: Code = 2231 # type: ignore
"""
``PSRLQ mm, mm/m64``

``NP 0F D3 /r``

``MMX``

``16/32/64-bit``
"""
PSRLQ_XMM_XMMM128: Code = 2232 # type: ignore
"""
``PSRLQ xmm1, xmm2/m128``

``66 0F D3 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSRLQ_XMM_XMM_XMMM128: Code = 2233 # type: ignore
"""
``VPSRLQ xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG D3 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSRLQ_YMM_YMM_XMMM128: Code = 2234 # type: ignore
"""
``VPSRLQ ymm1, ymm2, xmm3/m128``

``VEX.256.66.0F.WIG D3 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSRLQ_XMM_K1Z_XMM_XMMM128: Code = 2235 # type: ignore
"""
``VPSRLQ xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.W1 D3 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRLQ_YMM_K1Z_YMM_XMMM128: Code = 2236 # type: ignore
"""
``VPSRLQ ymm1 {k1}{z}, ymm2, xmm3/m128``

``EVEX.256.66.0F.W1 D3 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRLQ_ZMM_K1Z_ZMM_XMMM128: Code = 2237 # type: ignore
"""
``VPSRLQ zmm1 {k1}{z}, zmm2, xmm3/m128``

``EVEX.512.66.0F.W1 D3 /r``

``AVX512F``

``16/32/64-bit``
"""
PADDQ_MM_MMM64: Code = 2238 # type: ignore
"""
``PADDQ mm, mm/m64``

``NP 0F D4 /r``

``MMX``

``16/32/64-bit``
"""
PADDQ_XMM_XMMM128: Code = 2239 # type: ignore
"""
``PADDQ xmm1, xmm2/m128``

``66 0F D4 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPADDQ_XMM_XMM_XMMM128: Code = 2240 # type: ignore
"""
``VPADDQ xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG D4 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPADDQ_YMM_YMM_YMMM256: Code = 2241 # type: ignore
"""
``VPADDQ ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG D4 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPADDQ_XMM_K1Z_XMM_XMMM128B64: Code = 2242 # type: ignore
"""
``VPADDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 D4 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPADDQ_YMM_K1Z_YMM_YMMM256B64: Code = 2243 # type: ignore
"""
``VPADDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 D4 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPADDQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 2244 # type: ignore
"""
``VPADDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F.W1 D4 /r``

``AVX512F``

``16/32/64-bit``
"""
PMULLW_MM_MMM64: Code = 2245 # type: ignore
"""
``PMULLW mm, mm/m64``

``NP 0F D5 /r``

``MMX``

``16/32/64-bit``
"""
PMULLW_XMM_XMMM128: Code = 2246 # type: ignore
"""
``PMULLW xmm1, xmm2/m128``

``66 0F D5 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPMULLW_XMM_XMM_XMMM128: Code = 2247 # type: ignore
"""
``VPMULLW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG D5 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMULLW_YMM_YMM_YMMM256: Code = 2248 # type: ignore
"""
``VPMULLW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG D5 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMULLW_XMM_K1Z_XMM_XMMM128: Code = 2249 # type: ignore
"""
``VPMULLW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG D5 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMULLW_YMM_K1Z_YMM_YMMM256: Code = 2250 # type: ignore
"""
``VPMULLW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG D5 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMULLW_ZMM_K1Z_ZMM_ZMMM512: Code = 2251 # type: ignore
"""
``VPMULLW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG D5 /r``

``AVX512BW``

``16/32/64-bit``
"""
MOVQ_XMMM64_XMM: Code = 2252 # type: ignore
"""
``MOVQ xmm2/m64, xmm1``

``66 0F D6 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVQ_XMMM64_XMM: Code = 2253 # type: ignore
"""
``VMOVQ xmm1/m64, xmm2``

``VEX.128.66.0F.WIG D6 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVQ_XMMM64_XMM: Code = 2254 # type: ignore
"""
``VMOVQ xmm1/m64, xmm2``

``EVEX.128.66.0F.W1 D6 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVQ2DQ_XMM_MM: Code = 2255 # type: ignore
"""
``MOVQ2DQ xmm, mm``

``F3 0F D6 /r``

``SSE2``

``16/32/64-bit``
"""
MOVDQ2Q_MM_XMM: Code = 2256 # type: ignore
"""
``MOVDQ2Q mm, xmm``

``F2 0F D6 /r``

``SSE2``

``16/32/64-bit``
"""
PMOVMSKB_R32_MM: Code = 2257 # type: ignore
"""
``PMOVMSKB r32, mm``

``NP 0F D7 /r``

``SSE``

``16/32/64-bit``
"""
PMOVMSKB_R64_MM: Code = 2258 # type: ignore
"""
``PMOVMSKB r64, mm``

``NP o64 0F D7 /r``

``SSE``

``64-bit``
"""
PMOVMSKB_R32_XMM: Code = 2259 # type: ignore
"""
``PMOVMSKB r32, xmm``

``66 0F D7 /r``

``SSE2``

``16/32/64-bit``
"""
PMOVMSKB_R64_XMM: Code = 2260 # type: ignore
"""
``PMOVMSKB r64, xmm``

``66 o64 0F D7 /r``

``SSE2``

``64-bit``
"""
VEX_VPMOVMSKB_R32_XMM: Code = 2261 # type: ignore
"""
``VPMOVMSKB r32, xmm1``

``VEX.128.66.0F.W0 D7 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMOVMSKB_R64_XMM: Code = 2262 # type: ignore
"""
``VPMOVMSKB r64, xmm1``

``VEX.128.66.0F.W1 D7 /r``

``AVX``

``64-bit``
"""
VEX_VPMOVMSKB_R32_YMM: Code = 2263 # type: ignore
"""
``VPMOVMSKB r32, ymm1``

``VEX.256.66.0F.W0 D7 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPMOVMSKB_R64_YMM: Code = 2264 # type: ignore
"""
``VPMOVMSKB r64, ymm1``

``VEX.256.66.0F.W1 D7 /r``

``AVX2``

``64-bit``
"""
PSUBUSB_MM_MMM64: Code = 2265 # type: ignore
"""
``PSUBUSB mm, mm/m64``

``NP 0F D8 /r``

``MMX``

``16/32/64-bit``
"""
PSUBUSB_XMM_XMMM128: Code = 2266 # type: ignore
"""
``PSUBUSB xmm1, xmm2/m128``

``66 0F D8 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSUBUSB_XMM_XMM_XMMM128: Code = 2267 # type: ignore
"""
``VPSUBUSB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG D8 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSUBUSB_YMM_YMM_YMMM256: Code = 2268 # type: ignore
"""
``VPSUBUSB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG D8 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSUBUSB_XMM_K1Z_XMM_XMMM128: Code = 2269 # type: ignore
"""
``VPSUBUSB xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG D8 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSUBUSB_YMM_K1Z_YMM_YMMM256: Code = 2270 # type: ignore
"""
``VPSUBUSB ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG D8 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSUBUSB_ZMM_K1Z_ZMM_ZMMM512: Code = 2271 # type: ignore
"""
``VPSUBUSB zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG D8 /r``

``AVX512BW``

``16/32/64-bit``
"""
PSUBUSW_MM_MMM64: Code = 2272 # type: ignore
"""
``PSUBUSW mm, mm/m64``

``NP 0F D9 /r``

``MMX``

``16/32/64-bit``
"""
PSUBUSW_XMM_XMMM128: Code = 2273 # type: ignore
"""
``PSUBUSW xmm1, xmm2/m128``

``66 0F D9 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSUBUSW_XMM_XMM_XMMM128: Code = 2274 # type: ignore
"""
``VPSUBUSW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG D9 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSUBUSW_YMM_YMM_YMMM256: Code = 2275 # type: ignore
"""
``VPSUBUSW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG D9 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSUBUSW_XMM_K1Z_XMM_XMMM128: Code = 2276 # type: ignore
"""
``VPSUBUSW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG D9 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSUBUSW_YMM_K1Z_YMM_YMMM256: Code = 2277 # type: ignore
"""
``VPSUBUSW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG D9 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSUBUSW_ZMM_K1Z_ZMM_ZMMM512: Code = 2278 # type: ignore
"""
``VPSUBUSW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG D9 /r``

``AVX512BW``

``16/32/64-bit``
"""
PMINUB_MM_MMM64: Code = 2279 # type: ignore
"""
``PMINUB mm1, mm2/m64``

``NP 0F DA /r``

``SSE``

``16/32/64-bit``
"""
PMINUB_XMM_XMMM128: Code = 2280 # type: ignore
"""
``PMINUB xmm1, xmm2/m128``

``66 0F DA /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPMINUB_XMM_XMM_XMMM128: Code = 2281 # type: ignore
"""
``VPMINUB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG DA /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMINUB_YMM_YMM_YMMM256: Code = 2282 # type: ignore
"""
``VPMINUB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG DA /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMINUB_XMM_K1Z_XMM_XMMM128: Code = 2283 # type: ignore
"""
``VPMINUB xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG DA /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMINUB_YMM_K1Z_YMM_YMMM256: Code = 2284 # type: ignore
"""
``VPMINUB ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG DA /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMINUB_ZMM_K1Z_ZMM_ZMMM512: Code = 2285 # type: ignore
"""
``VPMINUB zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG DA /r``

``AVX512BW``

``16/32/64-bit``
"""
PAND_MM_MMM64: Code = 2286 # type: ignore
"""
``PAND mm, mm/m64``

``NP 0F DB /r``

``MMX``

``16/32/64-bit``
"""
PAND_XMM_XMMM128: Code = 2287 # type: ignore
"""
``PAND xmm1, xmm2/m128``

``66 0F DB /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPAND_XMM_XMM_XMMM128: Code = 2288 # type: ignore
"""
``VPAND xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG DB /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPAND_YMM_YMM_YMMM256: Code = 2289 # type: ignore
"""
``VPAND ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG DB /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPANDD_XMM_K1Z_XMM_XMMM128B32: Code = 2290 # type: ignore
"""
``VPANDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F.W0 DB /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPANDD_YMM_K1Z_YMM_YMMM256B32: Code = 2291 # type: ignore
"""
``VPANDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F.W0 DB /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPANDD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 2292 # type: ignore
"""
``VPANDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F.W0 DB /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPANDQ_XMM_K1Z_XMM_XMMM128B64: Code = 2293 # type: ignore
"""
``VPANDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 DB /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPANDQ_YMM_K1Z_YMM_YMMM256B64: Code = 2294 # type: ignore
"""
``VPANDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 DB /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPANDQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 2295 # type: ignore
"""
``VPANDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F.W1 DB /r``

``AVX512F``

``16/32/64-bit``
"""
PADDUSB_MM_MMM64: Code = 2296 # type: ignore
"""
``PADDUSB mm, mm/m64``

``NP 0F DC /r``

``MMX``

``16/32/64-bit``
"""
PADDUSB_XMM_XMMM128: Code = 2297 # type: ignore
"""
``PADDUSB xmm1, xmm2/m128``

``66 0F DC /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPADDUSB_XMM_XMM_XMMM128: Code = 2298 # type: ignore
"""
``VPADDUSB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG DC /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPADDUSB_YMM_YMM_YMMM256: Code = 2299 # type: ignore
"""
``VPADDUSB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG DC /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPADDUSB_XMM_K1Z_XMM_XMMM128: Code = 2300 # type: ignore
"""
``VPADDUSB xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG DC /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPADDUSB_YMM_K1Z_YMM_YMMM256: Code = 2301 # type: ignore
"""
``VPADDUSB ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG DC /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPADDUSB_ZMM_K1Z_ZMM_ZMMM512: Code = 2302 # type: ignore
"""
``VPADDUSB zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG DC /r``

``AVX512BW``

``16/32/64-bit``
"""
PADDUSW_MM_MMM64: Code = 2303 # type: ignore
"""
``PADDUSW mm, mm/m64``

``NP 0F DD /r``

``MMX``

``16/32/64-bit``
"""
PADDUSW_XMM_XMMM128: Code = 2304 # type: ignore
"""
``PADDUSW xmm1, xmm2/m128``

``66 0F DD /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPADDUSW_XMM_XMM_XMMM128: Code = 2305 # type: ignore
"""
``VPADDUSW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG DD /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPADDUSW_YMM_YMM_YMMM256: Code = 2306 # type: ignore
"""
``VPADDUSW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG DD /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPADDUSW_XMM_K1Z_XMM_XMMM128: Code = 2307 # type: ignore
"""
``VPADDUSW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG DD /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPADDUSW_YMM_K1Z_YMM_YMMM256: Code = 2308 # type: ignore
"""
``VPADDUSW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG DD /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPADDUSW_ZMM_K1Z_ZMM_ZMMM512: Code = 2309 # type: ignore
"""
``VPADDUSW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG DD /r``

``AVX512BW``

``16/32/64-bit``
"""
PMAXUB_MM_MMM64: Code = 2310 # type: ignore
"""
``PMAXUB mm1, mm2/m64``

``NP 0F DE /r``

``SSE``

``16/32/64-bit``
"""
PMAXUB_XMM_XMMM128: Code = 2311 # type: ignore
"""
``PMAXUB xmm1, xmm2/m128``

``66 0F DE /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPMAXUB_XMM_XMM_XMMM128: Code = 2312 # type: ignore
"""
``VPMAXUB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG DE /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMAXUB_YMM_YMM_YMMM256: Code = 2313 # type: ignore
"""
``VPMAXUB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG DE /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMAXUB_XMM_K1Z_XMM_XMMM128: Code = 2314 # type: ignore
"""
``VPMAXUB xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG DE /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMAXUB_YMM_K1Z_YMM_YMMM256: Code = 2315 # type: ignore
"""
``VPMAXUB ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG DE /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMAXUB_ZMM_K1Z_ZMM_ZMMM512: Code = 2316 # type: ignore
"""
``VPMAXUB zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG DE /r``

``AVX512BW``

``16/32/64-bit``
"""
PANDN_MM_MMM64: Code = 2317 # type: ignore
"""
``PANDN mm, mm/m64``

``NP 0F DF /r``

``MMX``

``16/32/64-bit``
"""
PANDN_XMM_XMMM128: Code = 2318 # type: ignore
"""
``PANDN xmm1, xmm2/m128``

``66 0F DF /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPANDN_XMM_XMM_XMMM128: Code = 2319 # type: ignore
"""
``VPANDN xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG DF /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPANDN_YMM_YMM_YMMM256: Code = 2320 # type: ignore
"""
``VPANDN ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG DF /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPANDND_XMM_K1Z_XMM_XMMM128B32: Code = 2321 # type: ignore
"""
``VPANDND xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F.W0 DF /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPANDND_YMM_K1Z_YMM_YMMM256B32: Code = 2322 # type: ignore
"""
``VPANDND ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F.W0 DF /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPANDND_ZMM_K1Z_ZMM_ZMMM512B32: Code = 2323 # type: ignore
"""
``VPANDND zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F.W0 DF /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPANDNQ_XMM_K1Z_XMM_XMMM128B64: Code = 2324 # type: ignore
"""
``VPANDNQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 DF /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPANDNQ_YMM_K1Z_YMM_YMMM256B64: Code = 2325 # type: ignore
"""
``VPANDNQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 DF /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPANDNQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 2326 # type: ignore
"""
``VPANDNQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F.W1 DF /r``

``AVX512F``

``16/32/64-bit``
"""
PAVGB_MM_MMM64: Code = 2327 # type: ignore
"""
``PAVGB mm1, mm2/m64``

``NP 0F E0 /r``

``SSE``

``16/32/64-bit``
"""
PAVGB_XMM_XMMM128: Code = 2328 # type: ignore
"""
``PAVGB xmm1, xmm2/m128``

``66 0F E0 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPAVGB_XMM_XMM_XMMM128: Code = 2329 # type: ignore
"""
``VPAVGB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG E0 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPAVGB_YMM_YMM_YMMM256: Code = 2330 # type: ignore
"""
``VPAVGB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG E0 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPAVGB_XMM_K1Z_XMM_XMMM128: Code = 2331 # type: ignore
"""
``VPAVGB xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG E0 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPAVGB_YMM_K1Z_YMM_YMMM256: Code = 2332 # type: ignore
"""
``VPAVGB ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG E0 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPAVGB_ZMM_K1Z_ZMM_ZMMM512: Code = 2333 # type: ignore
"""
``VPAVGB zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG E0 /r``

``AVX512BW``

``16/32/64-bit``
"""
PSRAW_MM_MMM64: Code = 2334 # type: ignore
"""
``PSRAW mm, mm/m64``

``NP 0F E1 /r``

``MMX``

``16/32/64-bit``
"""
PSRAW_XMM_XMMM128: Code = 2335 # type: ignore
"""
``PSRAW xmm1, xmm2/m128``

``66 0F E1 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSRAW_XMM_XMM_XMMM128: Code = 2336 # type: ignore
"""
``VPSRAW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG E1 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSRAW_YMM_YMM_XMMM128: Code = 2337 # type: ignore
"""
``VPSRAW ymm1, ymm2, xmm3/m128``

``VEX.256.66.0F.WIG E1 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSRAW_XMM_K1Z_XMM_XMMM128: Code = 2338 # type: ignore
"""
``VPSRAW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG E1 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSRAW_YMM_K1Z_YMM_XMMM128: Code = 2339 # type: ignore
"""
``VPSRAW ymm1 {k1}{z}, ymm2, xmm3/m128``

``EVEX.256.66.0F.WIG E1 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSRAW_ZMM_K1Z_ZMM_XMMM128: Code = 2340 # type: ignore
"""
``VPSRAW zmm1 {k1}{z}, zmm2, xmm3/m128``

``EVEX.512.66.0F.WIG E1 /r``

``AVX512BW``

``16/32/64-bit``
"""
PSRAD_MM_MMM64: Code = 2341 # type: ignore
"""
``PSRAD mm, mm/m64``

``NP 0F E2 /r``

``MMX``

``16/32/64-bit``
"""
PSRAD_XMM_XMMM128: Code = 2342 # type: ignore
"""
``PSRAD xmm1, xmm2/m128``

``66 0F E2 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSRAD_XMM_XMM_XMMM128: Code = 2343 # type: ignore
"""
``VPSRAD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG E2 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSRAD_YMM_YMM_XMMM128: Code = 2344 # type: ignore
"""
``VPSRAD ymm1, ymm2, xmm3/m128``

``VEX.256.66.0F.WIG E2 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSRAD_XMM_K1Z_XMM_XMMM128: Code = 2345 # type: ignore
"""
``VPSRAD xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.W0 E2 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRAD_YMM_K1Z_YMM_XMMM128: Code = 2346 # type: ignore
"""
``VPSRAD ymm1 {k1}{z}, ymm2, xmm3/m128``

``EVEX.256.66.0F.W0 E2 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRAD_ZMM_K1Z_ZMM_XMMM128: Code = 2347 # type: ignore
"""
``VPSRAD zmm1 {k1}{z}, zmm2, xmm3/m128``

``EVEX.512.66.0F.W0 E2 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRAQ_XMM_K1Z_XMM_XMMM128: Code = 2348 # type: ignore
"""
``VPSRAQ xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.W1 E2 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRAQ_YMM_K1Z_YMM_XMMM128: Code = 2349 # type: ignore
"""
``VPSRAQ ymm1 {k1}{z}, ymm2, xmm3/m128``

``EVEX.256.66.0F.W1 E2 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRAQ_ZMM_K1Z_ZMM_XMMM128: Code = 2350 # type: ignore
"""
``VPSRAQ zmm1 {k1}{z}, zmm2, xmm3/m128``

``EVEX.512.66.0F.W1 E2 /r``

``AVX512F``

``16/32/64-bit``
"""
PAVGW_MM_MMM64: Code = 2351 # type: ignore
"""
``PAVGW mm1, mm2/m64``

``NP 0F E3 /r``

``SSE``

``16/32/64-bit``
"""
PAVGW_XMM_XMMM128: Code = 2352 # type: ignore
"""
``PAVGW xmm1, xmm2/m128``

``66 0F E3 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPAVGW_XMM_XMM_XMMM128: Code = 2353 # type: ignore
"""
``VPAVGW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG E3 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPAVGW_YMM_YMM_YMMM256: Code = 2354 # type: ignore
"""
``VPAVGW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG E3 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPAVGW_XMM_K1Z_XMM_XMMM128: Code = 2355 # type: ignore
"""
``VPAVGW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG E3 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPAVGW_YMM_K1Z_YMM_YMMM256: Code = 2356 # type: ignore
"""
``VPAVGW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG E3 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPAVGW_ZMM_K1Z_ZMM_ZMMM512: Code = 2357 # type: ignore
"""
``VPAVGW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG E3 /r``

``AVX512BW``

``16/32/64-bit``
"""
PMULHUW_MM_MMM64: Code = 2358 # type: ignore
"""
``PMULHUW mm1, mm2/m64``

``NP 0F E4 /r``

``SSE``

``16/32/64-bit``
"""
PMULHUW_XMM_XMMM128: Code = 2359 # type: ignore
"""
``PMULHUW xmm1, xmm2/m128``

``66 0F E4 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPMULHUW_XMM_XMM_XMMM128: Code = 2360 # type: ignore
"""
``VPMULHUW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG E4 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMULHUW_YMM_YMM_YMMM256: Code = 2361 # type: ignore
"""
``VPMULHUW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG E4 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMULHUW_XMM_K1Z_XMM_XMMM128: Code = 2362 # type: ignore
"""
``VPMULHUW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG E4 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMULHUW_YMM_K1Z_YMM_YMMM256: Code = 2363 # type: ignore
"""
``VPMULHUW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG E4 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMULHUW_ZMM_K1Z_ZMM_ZMMM512: Code = 2364 # type: ignore
"""
``VPMULHUW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG E4 /r``

``AVX512BW``

``16/32/64-bit``
"""
PMULHW_MM_MMM64: Code = 2365 # type: ignore
"""
``PMULHW mm, mm/m64``

``NP 0F E5 /r``

``MMX``

``16/32/64-bit``
"""
PMULHW_XMM_XMMM128: Code = 2366 # type: ignore
"""
``PMULHW xmm1, xmm2/m128``

``66 0F E5 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPMULHW_XMM_XMM_XMMM128: Code = 2367 # type: ignore
"""
``VPMULHW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG E5 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMULHW_YMM_YMM_YMMM256: Code = 2368 # type: ignore
"""
``VPMULHW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG E5 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMULHW_XMM_K1Z_XMM_XMMM128: Code = 2369 # type: ignore
"""
``VPMULHW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG E5 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMULHW_YMM_K1Z_YMM_YMMM256: Code = 2370 # type: ignore
"""
``VPMULHW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG E5 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMULHW_ZMM_K1Z_ZMM_ZMMM512: Code = 2371 # type: ignore
"""
``VPMULHW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG E5 /r``

``AVX512BW``

``16/32/64-bit``
"""
CVTTPD2DQ_XMM_XMMM128: Code = 2372 # type: ignore
"""
``CVTTPD2DQ xmm1, xmm2/m128``

``66 0F E6 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VCVTTPD2DQ_XMM_XMMM128: Code = 2373 # type: ignore
"""
``VCVTTPD2DQ xmm1, xmm2/m128``

``VEX.128.66.0F.WIG E6 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VCVTTPD2DQ_XMM_YMMM256: Code = 2374 # type: ignore
"""
``VCVTTPD2DQ xmm1, ymm2/m256``

``VEX.256.66.0F.WIG E6 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VCVTTPD2DQ_XMM_K1Z_XMMM128B64: Code = 2375 # type: ignore
"""
``VCVTTPD2DQ xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.66.0F.W1 E6 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTTPD2DQ_XMM_K1Z_YMMM256B64: Code = 2376 # type: ignore
"""
``VCVTTPD2DQ xmm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.66.0F.W1 E6 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTTPD2DQ_YMM_K1Z_ZMMM512B64_SAE: Code = 2377 # type: ignore
"""
``VCVTTPD2DQ ymm1 {k1}{z}, zmm2/m512/m64bcst{sae}``

``EVEX.512.66.0F.W1 E6 /r``

``AVX512F``

``16/32/64-bit``
"""
CVTDQ2PD_XMM_XMMM64: Code = 2378 # type: ignore
"""
``CVTDQ2PD xmm1, xmm2/m64``

``F3 0F E6 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VCVTDQ2PD_XMM_XMMM64: Code = 2379 # type: ignore
"""
``VCVTDQ2PD xmm1, xmm2/m64``

``VEX.128.F3.0F.WIG E6 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VCVTDQ2PD_YMM_XMMM128: Code = 2380 # type: ignore
"""
``VCVTDQ2PD ymm1, xmm2/m128``

``VEX.256.F3.0F.WIG E6 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VCVTDQ2PD_XMM_K1Z_XMMM64B32: Code = 2381 # type: ignore
"""
``VCVTDQ2PD xmm1 {k1}{z}, xmm2/m64/m32bcst``

``EVEX.128.F3.0F.W0 E6 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTDQ2PD_YMM_K1Z_XMMM128B32: Code = 2382 # type: ignore
"""
``VCVTDQ2PD ymm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.256.F3.0F.W0 E6 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTDQ2PD_ZMM_K1Z_YMMM256B32_ER: Code = 2383 # type: ignore
"""
``VCVTDQ2PD zmm1 {k1}{z}, ymm2/m256/m32bcst{er}``

``EVEX.512.F3.0F.W0 E6 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTQQ2PD_XMM_K1Z_XMMM128B64: Code = 2384 # type: ignore
"""
``VCVTQQ2PD xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.F3.0F.W1 E6 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTQQ2PD_YMM_K1Z_YMMM256B64: Code = 2385 # type: ignore
"""
``VCVTQQ2PD ymm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.F3.0F.W1 E6 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VCVTQQ2PD_ZMM_K1Z_ZMMM512B64_ER: Code = 2386 # type: ignore
"""
``VCVTQQ2PD zmm1 {k1}{z}, zmm2/m512/m64bcst{er}``

``EVEX.512.F3.0F.W1 E6 /r``

``AVX512DQ``

``16/32/64-bit``
"""
CVTPD2DQ_XMM_XMMM128: Code = 2387 # type: ignore
"""
``CVTPD2DQ xmm1, xmm2/m128``

``F2 0F E6 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VCVTPD2DQ_XMM_XMMM128: Code = 2388 # type: ignore
"""
``VCVTPD2DQ xmm1, xmm2/m128``

``VEX.128.F2.0F.WIG E6 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VCVTPD2DQ_XMM_YMMM256: Code = 2389 # type: ignore
"""
``VCVTPD2DQ xmm1, ymm2/m256``

``VEX.256.F2.0F.WIG E6 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VCVTPD2DQ_XMM_K1Z_XMMM128B64: Code = 2390 # type: ignore
"""
``VCVTPD2DQ xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.F2.0F.W1 E6 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTPD2DQ_XMM_K1Z_YMMM256B64: Code = 2391 # type: ignore
"""
``VCVTPD2DQ xmm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.F2.0F.W1 E6 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTPD2DQ_YMM_K1Z_ZMMM512B64_ER: Code = 2392 # type: ignore
"""
``VCVTPD2DQ ymm1 {k1}{z}, zmm2/m512/m64bcst{er}``

``EVEX.512.F2.0F.W1 E6 /r``

``AVX512F``

``16/32/64-bit``
"""
MOVNTQ_M64_MM: Code = 2393 # type: ignore
"""
``MOVNTQ m64, mm``

``NP 0F E7 /r``

``SSE``

``16/32/64-bit``
"""
MOVNTDQ_M128_XMM: Code = 2394 # type: ignore
"""
``MOVNTDQ m128, xmm1``

``66 0F E7 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMOVNTDQ_M128_XMM: Code = 2395 # type: ignore
"""
``VMOVNTDQ m128, xmm1``

``VEX.128.66.0F.WIG E7 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVNTDQ_M256_YMM: Code = 2396 # type: ignore
"""
``VMOVNTDQ m256, ymm1``

``VEX.256.66.0F.WIG E7 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VMOVNTDQ_M128_XMM: Code = 2397 # type: ignore
"""
``VMOVNTDQ m128, xmm1``

``EVEX.128.66.0F.W0 E7 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVNTDQ_M256_YMM: Code = 2398 # type: ignore
"""
``VMOVNTDQ m256, ymm1``

``EVEX.256.66.0F.W0 E7 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVNTDQ_M512_ZMM: Code = 2399 # type: ignore
"""
``VMOVNTDQ m512, zmm1``

``EVEX.512.66.0F.W0 E7 /r``

``AVX512F``

``16/32/64-bit``
"""
PSUBSB_MM_MMM64: Code = 2400 # type: ignore
"""
``PSUBSB mm, mm/m64``

``NP 0F E8 /r``

``MMX``

``16/32/64-bit``
"""
PSUBSB_XMM_XMMM128: Code = 2401 # type: ignore
"""
``PSUBSB xmm1, xmm2/m128``

``66 0F E8 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSUBSB_XMM_XMM_XMMM128: Code = 2402 # type: ignore
"""
``VPSUBSB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG E8 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSUBSB_YMM_YMM_YMMM256: Code = 2403 # type: ignore
"""
``VPSUBSB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG E8 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSUBSB_XMM_K1Z_XMM_XMMM128: Code = 2404 # type: ignore
"""
``VPSUBSB xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG E8 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSUBSB_YMM_K1Z_YMM_YMMM256: Code = 2405 # type: ignore
"""
``VPSUBSB ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG E8 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSUBSB_ZMM_K1Z_ZMM_ZMMM512: Code = 2406 # type: ignore
"""
``VPSUBSB zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG E8 /r``

``AVX512BW``

``16/32/64-bit``
"""
PSUBSW_MM_MMM64: Code = 2407 # type: ignore
"""
``PSUBSW mm, mm/m64``

``NP 0F E9 /r``

``MMX``

``16/32/64-bit``
"""
PSUBSW_XMM_XMMM128: Code = 2408 # type: ignore
"""
``PSUBSW xmm1, xmm2/m128``

``66 0F E9 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSUBSW_XMM_XMM_XMMM128: Code = 2409 # type: ignore
"""
``VPSUBSW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG E9 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSUBSW_YMM_YMM_YMMM256: Code = 2410 # type: ignore
"""
``VPSUBSW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG E9 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSUBSW_XMM_K1Z_XMM_XMMM128: Code = 2411 # type: ignore
"""
``VPSUBSW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG E9 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSUBSW_YMM_K1Z_YMM_YMMM256: Code = 2412 # type: ignore
"""
``VPSUBSW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG E9 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSUBSW_ZMM_K1Z_ZMM_ZMMM512: Code = 2413 # type: ignore
"""
``VPSUBSW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG E9 /r``

``AVX512BW``

``16/32/64-bit``
"""
PMINSW_MM_MMM64: Code = 2414 # type: ignore
"""
``PMINSW mm1, mm2/m64``

``NP 0F EA /r``

``SSE``

``16/32/64-bit``
"""
PMINSW_XMM_XMMM128: Code = 2415 # type: ignore
"""
``PMINSW xmm1, xmm2/m128``

``66 0F EA /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPMINSW_XMM_XMM_XMMM128: Code = 2416 # type: ignore
"""
``VPMINSW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG EA /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMINSW_YMM_YMM_YMMM256: Code = 2417 # type: ignore
"""
``VPMINSW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG EA /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMINSW_XMM_K1Z_XMM_XMMM128: Code = 2418 # type: ignore
"""
``VPMINSW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG EA /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMINSW_YMM_K1Z_YMM_YMMM256: Code = 2419 # type: ignore
"""
``VPMINSW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG EA /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMINSW_ZMM_K1Z_ZMM_ZMMM512: Code = 2420 # type: ignore
"""
``VPMINSW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG EA /r``

``AVX512BW``

``16/32/64-bit``
"""
POR_MM_MMM64: Code = 2421 # type: ignore
"""
``POR mm, mm/m64``

``NP 0F EB /r``

``MMX``

``16/32/64-bit``
"""
POR_XMM_XMMM128: Code = 2422 # type: ignore
"""
``POR xmm1, xmm2/m128``

``66 0F EB /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPOR_XMM_XMM_XMMM128: Code = 2423 # type: ignore
"""
``VPOR xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG EB /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPOR_YMM_YMM_YMMM256: Code = 2424 # type: ignore
"""
``VPOR ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG EB /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPORD_XMM_K1Z_XMM_XMMM128B32: Code = 2425 # type: ignore
"""
``VPORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F.W0 EB /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPORD_YMM_K1Z_YMM_YMMM256B32: Code = 2426 # type: ignore
"""
``VPORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F.W0 EB /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPORD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 2427 # type: ignore
"""
``VPORD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F.W0 EB /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPORQ_XMM_K1Z_XMM_XMMM128B64: Code = 2428 # type: ignore
"""
``VPORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 EB /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPORQ_YMM_K1Z_YMM_YMMM256B64: Code = 2429 # type: ignore
"""
``VPORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 EB /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPORQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 2430 # type: ignore
"""
``VPORQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F.W1 EB /r``

``AVX512F``

``16/32/64-bit``
"""
PADDSB_MM_MMM64: Code = 2431 # type: ignore
"""
``PADDSB mm, mm/m64``

``NP 0F EC /r``

``MMX``

``16/32/64-bit``
"""
PADDSB_XMM_XMMM128: Code = 2432 # type: ignore
"""
``PADDSB xmm1, xmm2/m128``

``66 0F EC /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPADDSB_XMM_XMM_XMMM128: Code = 2433 # type: ignore
"""
``VPADDSB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG EC /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPADDSB_YMM_YMM_YMMM256: Code = 2434 # type: ignore
"""
``VPADDSB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG EC /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPADDSB_XMM_K1Z_XMM_XMMM128: Code = 2435 # type: ignore
"""
``VPADDSB xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG EC /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPADDSB_YMM_K1Z_YMM_YMMM256: Code = 2436 # type: ignore
"""
``VPADDSB ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG EC /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPADDSB_ZMM_K1Z_ZMM_ZMMM512: Code = 2437 # type: ignore
"""
``VPADDSB zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG EC /r``

``AVX512BW``

``16/32/64-bit``
"""
PADDSW_MM_MMM64: Code = 2438 # type: ignore
"""
``PADDSW mm, mm/m64``

``NP 0F ED /r``

``MMX``

``16/32/64-bit``
"""
PADDSW_XMM_XMMM128: Code = 2439 # type: ignore
"""
``PADDSW xmm1, xmm2/m128``

``66 0F ED /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPADDSW_XMM_XMM_XMMM128: Code = 2440 # type: ignore
"""
``VPADDSW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG ED /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPADDSW_YMM_YMM_YMMM256: Code = 2441 # type: ignore
"""
``VPADDSW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG ED /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPADDSW_XMM_K1Z_XMM_XMMM128: Code = 2442 # type: ignore
"""
``VPADDSW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG ED /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPADDSW_YMM_K1Z_YMM_YMMM256: Code = 2443 # type: ignore
"""
``VPADDSW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG ED /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPADDSW_ZMM_K1Z_ZMM_ZMMM512: Code = 2444 # type: ignore
"""
``VPADDSW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG ED /r``

``AVX512BW``

``16/32/64-bit``
"""
PMAXSW_MM_MMM64: Code = 2445 # type: ignore
"""
``PMAXSW mm1, mm2/m64``

``NP 0F EE /r``

``SSE``

``16/32/64-bit``
"""
PMAXSW_XMM_XMMM128: Code = 2446 # type: ignore
"""
``PMAXSW xmm1, xmm2/m128``

``66 0F EE /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPMAXSW_XMM_XMM_XMMM128: Code = 2447 # type: ignore
"""
``VPMAXSW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG EE /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMAXSW_YMM_YMM_YMMM256: Code = 2448 # type: ignore
"""
``VPMAXSW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG EE /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMAXSW_XMM_K1Z_XMM_XMMM128: Code = 2449 # type: ignore
"""
``VPMAXSW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG EE /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMAXSW_YMM_K1Z_YMM_YMMM256: Code = 2450 # type: ignore
"""
``VPMAXSW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG EE /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMAXSW_ZMM_K1Z_ZMM_ZMMM512: Code = 2451 # type: ignore
"""
``VPMAXSW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG EE /r``

``AVX512BW``

``16/32/64-bit``
"""
PXOR_MM_MMM64: Code = 2452 # type: ignore
"""
``PXOR mm, mm/m64``

``NP 0F EF /r``

``MMX``

``16/32/64-bit``
"""
PXOR_XMM_XMMM128: Code = 2453 # type: ignore
"""
``PXOR xmm1, xmm2/m128``

``66 0F EF /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPXOR_XMM_XMM_XMMM128: Code = 2454 # type: ignore
"""
``VPXOR xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG EF /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPXOR_YMM_YMM_YMMM256: Code = 2455 # type: ignore
"""
``VPXOR ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG EF /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPXORD_XMM_K1Z_XMM_XMMM128B32: Code = 2456 # type: ignore
"""
``VPXORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F.W0 EF /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPXORD_YMM_K1Z_YMM_YMMM256B32: Code = 2457 # type: ignore
"""
``VPXORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F.W0 EF /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPXORD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 2458 # type: ignore
"""
``VPXORD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F.W0 EF /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPXORQ_XMM_K1Z_XMM_XMMM128B64: Code = 2459 # type: ignore
"""
``VPXORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 EF /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPXORQ_YMM_K1Z_YMM_YMMM256B64: Code = 2460 # type: ignore
"""
``VPXORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 EF /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPXORQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 2461 # type: ignore
"""
``VPXORQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F.W1 EF /r``

``AVX512F``

``16/32/64-bit``
"""
LDDQU_XMM_M128: Code = 2462 # type: ignore
"""
``LDDQU xmm1, m128``

``F2 0F F0 /r``

``SSE3``

``16/32/64-bit``
"""
VEX_VLDDQU_XMM_M128: Code = 2463 # type: ignore
"""
``VLDDQU xmm1, m128``

``VEX.128.F2.0F.WIG F0 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VLDDQU_YMM_M256: Code = 2464 # type: ignore
"""
``VLDDQU ymm1, m256``

``VEX.256.F2.0F.WIG F0 /r``

``AVX``

``16/32/64-bit``
"""
PSLLW_MM_MMM64: Code = 2465 # type: ignore
"""
``PSLLW mm, mm/m64``

``NP 0F F1 /r``

``MMX``

``16/32/64-bit``
"""
PSLLW_XMM_XMMM128: Code = 2466 # type: ignore
"""
``PSLLW xmm1, xmm2/m128``

``66 0F F1 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSLLW_XMM_XMM_XMMM128: Code = 2467 # type: ignore
"""
``VPSLLW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG F1 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSLLW_YMM_YMM_XMMM128: Code = 2468 # type: ignore
"""
``VPSLLW ymm1, ymm2, xmm3/m128``

``VEX.256.66.0F.WIG F1 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSLLW_XMM_K1Z_XMM_XMMM128: Code = 2469 # type: ignore
"""
``VPSLLW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG F1 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSLLW_YMM_K1Z_YMM_XMMM128: Code = 2470 # type: ignore
"""
``VPSLLW ymm1 {k1}{z}, ymm2, xmm3/m128``

``EVEX.256.66.0F.WIG F1 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSLLW_ZMM_K1Z_ZMM_XMMM128: Code = 2471 # type: ignore
"""
``VPSLLW zmm1 {k1}{z}, zmm2, xmm3/m128``

``EVEX.512.66.0F.WIG F1 /r``

``AVX512BW``

``16/32/64-bit``
"""
PSLLD_MM_MMM64: Code = 2472 # type: ignore
"""
``PSLLD mm, mm/m64``

``NP 0F F2 /r``

``MMX``

``16/32/64-bit``
"""
PSLLD_XMM_XMMM128: Code = 2473 # type: ignore
"""
``PSLLD xmm1, xmm2/m128``

``66 0F F2 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSLLD_XMM_XMM_XMMM128: Code = 2474 # type: ignore
"""
``VPSLLD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG F2 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSLLD_YMM_YMM_XMMM128: Code = 2475 # type: ignore
"""
``VPSLLD ymm1, ymm2, xmm3/m128``

``VEX.256.66.0F.WIG F2 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSLLD_XMM_K1Z_XMM_XMMM128: Code = 2476 # type: ignore
"""
``VPSLLD xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.W0 F2 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSLLD_YMM_K1Z_YMM_XMMM128: Code = 2477 # type: ignore
"""
``VPSLLD ymm1 {k1}{z}, ymm2, xmm3/m128``

``EVEX.256.66.0F.W0 F2 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSLLD_ZMM_K1Z_ZMM_XMMM128: Code = 2478 # type: ignore
"""
``VPSLLD zmm1 {k1}{z}, zmm2, xmm3/m128``

``EVEX.512.66.0F.W0 F2 /r``

``AVX512F``

``16/32/64-bit``
"""
PSLLQ_MM_MMM64: Code = 2479 # type: ignore
"""
``PSLLQ mm, mm/m64``

``NP 0F F3 /r``

``MMX``

``16/32/64-bit``
"""
PSLLQ_XMM_XMMM128: Code = 2480 # type: ignore
"""
``PSLLQ xmm1, xmm2/m128``

``66 0F F3 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSLLQ_XMM_XMM_XMMM128: Code = 2481 # type: ignore
"""
``VPSLLQ xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG F3 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSLLQ_YMM_YMM_XMMM128: Code = 2482 # type: ignore
"""
``VPSLLQ ymm1, ymm2, xmm3/m128``

``VEX.256.66.0F.WIG F3 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSLLQ_XMM_K1Z_XMM_XMMM128: Code = 2483 # type: ignore
"""
``VPSLLQ xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.W1 F3 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSLLQ_YMM_K1Z_YMM_XMMM128: Code = 2484 # type: ignore
"""
``VPSLLQ ymm1 {k1}{z}, ymm2, xmm3/m128``

``EVEX.256.66.0F.W1 F3 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSLLQ_ZMM_K1Z_ZMM_XMMM128: Code = 2485 # type: ignore
"""
``VPSLLQ zmm1 {k1}{z}, zmm2, xmm3/m128``

``EVEX.512.66.0F.W1 F3 /r``

``AVX512F``

``16/32/64-bit``
"""
PMULUDQ_MM_MMM64: Code = 2486 # type: ignore
"""
``PMULUDQ mm1, mm2/m64``

``NP 0F F4 /r``

``SSE2``

``16/32/64-bit``
"""
PMULUDQ_XMM_XMMM128: Code = 2487 # type: ignore
"""
``PMULUDQ xmm1, xmm2/m128``

``66 0F F4 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPMULUDQ_XMM_XMM_XMMM128: Code = 2488 # type: ignore
"""
``VPMULUDQ xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG F4 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMULUDQ_YMM_YMM_YMMM256: Code = 2489 # type: ignore
"""
``VPMULUDQ ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG F4 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMULUDQ_XMM_K1Z_XMM_XMMM128B64: Code = 2490 # type: ignore
"""
``VPMULUDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 F4 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMULUDQ_YMM_K1Z_YMM_YMMM256B64: Code = 2491 # type: ignore
"""
``VPMULUDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 F4 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMULUDQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 2492 # type: ignore
"""
``VPMULUDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F.W1 F4 /r``

``AVX512F``

``16/32/64-bit``
"""
PMADDWD_MM_MMM64: Code = 2493 # type: ignore
"""
``PMADDWD mm, mm/m64``

``NP 0F F5 /r``

``MMX``

``16/32/64-bit``
"""
PMADDWD_XMM_XMMM128: Code = 2494 # type: ignore
"""
``PMADDWD xmm1, xmm2/m128``

``66 0F F5 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPMADDWD_XMM_XMM_XMMM128: Code = 2495 # type: ignore
"""
``VPMADDWD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG F5 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMADDWD_YMM_YMM_YMMM256: Code = 2496 # type: ignore
"""
``VPMADDWD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG F5 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMADDWD_XMM_K1Z_XMM_XMMM128: Code = 2497 # type: ignore
"""
``VPMADDWD xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG F5 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMADDWD_YMM_K1Z_YMM_YMMM256: Code = 2498 # type: ignore
"""
``VPMADDWD ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG F5 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMADDWD_ZMM_K1Z_ZMM_ZMMM512: Code = 2499 # type: ignore
"""
``VPMADDWD zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG F5 /r``

``AVX512BW``

``16/32/64-bit``
"""
PSADBW_MM_MMM64: Code = 2500 # type: ignore
"""
``PSADBW mm1, mm2/m64``

``NP 0F F6 /r``

``SSE``

``16/32/64-bit``
"""
PSADBW_XMM_XMMM128: Code = 2501 # type: ignore
"""
``PSADBW xmm1, xmm2/m128``

``66 0F F6 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSADBW_XMM_XMM_XMMM128: Code = 2502 # type: ignore
"""
``VPSADBW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG F6 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSADBW_YMM_YMM_YMMM256: Code = 2503 # type: ignore
"""
``VPSADBW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG F6 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSADBW_XMM_XMM_XMMM128: Code = 2504 # type: ignore
"""
``VPSADBW xmm1, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG F6 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSADBW_YMM_YMM_YMMM256: Code = 2505 # type: ignore
"""
``VPSADBW ymm1, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG F6 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSADBW_ZMM_ZMM_ZMMM512: Code = 2506 # type: ignore
"""
``VPSADBW zmm1, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG F6 /r``

``AVX512BW``

``16/32/64-bit``
"""
MASKMOVQ_RDI_MM_MM: Code = 2507 # type: ignore
"""
``MASKMOVQ mm1, mm2``

``NP 0F F7 /r``

``SSE``

``16/32/64-bit``
"""
MASKMOVDQU_RDI_XMM_XMM: Code = 2508 # type: ignore
"""
``MASKMOVDQU xmm1, xmm2``

``66 0F F7 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VMASKMOVDQU_RDI_XMM_XMM: Code = 2509 # type: ignore
"""
``VMASKMOVDQU xmm1, xmm2``

``VEX.128.66.0F.WIG F7 /r``

``AVX``

``16/32/64-bit``
"""
PSUBB_MM_MMM64: Code = 2510 # type: ignore
"""
``PSUBB mm, mm/m64``

``NP 0F F8 /r``

``MMX``

``16/32/64-bit``
"""
PSUBB_XMM_XMMM128: Code = 2511 # type: ignore
"""
``PSUBB xmm1, xmm2/m128``

``66 0F F8 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSUBB_XMM_XMM_XMMM128: Code = 2512 # type: ignore
"""
``VPSUBB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG F8 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSUBB_YMM_YMM_YMMM256: Code = 2513 # type: ignore
"""
``VPSUBB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG F8 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSUBB_XMM_K1Z_XMM_XMMM128: Code = 2514 # type: ignore
"""
``VPSUBB xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG F8 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSUBB_YMM_K1Z_YMM_YMMM256: Code = 2515 # type: ignore
"""
``VPSUBB ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG F8 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSUBB_ZMM_K1Z_ZMM_ZMMM512: Code = 2516 # type: ignore
"""
``VPSUBB zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG F8 /r``

``AVX512BW``

``16/32/64-bit``
"""
PSUBW_MM_MMM64: Code = 2517 # type: ignore
"""
``PSUBW mm, mm/m64``

``NP 0F F9 /r``

``MMX``

``16/32/64-bit``
"""
PSUBW_XMM_XMMM128: Code = 2518 # type: ignore
"""
``PSUBW xmm1, xmm2/m128``

``66 0F F9 /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSUBW_XMM_XMM_XMMM128: Code = 2519 # type: ignore
"""
``VPSUBW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG F9 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSUBW_YMM_YMM_YMMM256: Code = 2520 # type: ignore
"""
``VPSUBW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG F9 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSUBW_XMM_K1Z_XMM_XMMM128: Code = 2521 # type: ignore
"""
``VPSUBW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG F9 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSUBW_YMM_K1Z_YMM_YMMM256: Code = 2522 # type: ignore
"""
``VPSUBW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG F9 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSUBW_ZMM_K1Z_ZMM_ZMMM512: Code = 2523 # type: ignore
"""
``VPSUBW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG F9 /r``

``AVX512BW``

``16/32/64-bit``
"""
PSUBD_MM_MMM64: Code = 2524 # type: ignore
"""
``PSUBD mm, mm/m64``

``NP 0F FA /r``

``MMX``

``16/32/64-bit``
"""
PSUBD_XMM_XMMM128: Code = 2525 # type: ignore
"""
``PSUBD xmm1, xmm2/m128``

``66 0F FA /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSUBD_XMM_XMM_XMMM128: Code = 2526 # type: ignore
"""
``VPSUBD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG FA /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSUBD_YMM_YMM_YMMM256: Code = 2527 # type: ignore
"""
``VPSUBD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG FA /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSUBD_XMM_K1Z_XMM_XMMM128B32: Code = 2528 # type: ignore
"""
``VPSUBD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F.W0 FA /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSUBD_YMM_K1Z_YMM_YMMM256B32: Code = 2529 # type: ignore
"""
``VPSUBD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F.W0 FA /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSUBD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 2530 # type: ignore
"""
``VPSUBD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F.W0 FA /r``

``AVX512F``

``16/32/64-bit``
"""
PSUBQ_MM_MMM64: Code = 2531 # type: ignore
"""
``PSUBQ mm1, mm2/m64``

``NP 0F FB /r``

``SSE2``

``16/32/64-bit``
"""
PSUBQ_XMM_XMMM128: Code = 2532 # type: ignore
"""
``PSUBQ xmm1, xmm2/m128``

``66 0F FB /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPSUBQ_XMM_XMM_XMMM128: Code = 2533 # type: ignore
"""
``VPSUBQ xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG FB /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSUBQ_YMM_YMM_YMMM256: Code = 2534 # type: ignore
"""
``VPSUBQ ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG FB /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSUBQ_XMM_K1Z_XMM_XMMM128B64: Code = 2535 # type: ignore
"""
``VPSUBQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F.W1 FB /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSUBQ_YMM_K1Z_YMM_YMMM256B64: Code = 2536 # type: ignore
"""
``VPSUBQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F.W1 FB /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSUBQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 2537 # type: ignore
"""
``VPSUBQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F.W1 FB /r``

``AVX512F``

``16/32/64-bit``
"""
PADDB_MM_MMM64: Code = 2538 # type: ignore
"""
``PADDB mm, mm/m64``

``NP 0F FC /r``

``MMX``

``16/32/64-bit``
"""
PADDB_XMM_XMMM128: Code = 2539 # type: ignore
"""
``PADDB xmm1, xmm2/m128``

``66 0F FC /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPADDB_XMM_XMM_XMMM128: Code = 2540 # type: ignore
"""
``VPADDB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG FC /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPADDB_YMM_YMM_YMMM256: Code = 2541 # type: ignore
"""
``VPADDB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG FC /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPADDB_XMM_K1Z_XMM_XMMM128: Code = 2542 # type: ignore
"""
``VPADDB xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG FC /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPADDB_YMM_K1Z_YMM_YMMM256: Code = 2543 # type: ignore
"""
``VPADDB ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG FC /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPADDB_ZMM_K1Z_ZMM_ZMMM512: Code = 2544 # type: ignore
"""
``VPADDB zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG FC /r``

``AVX512BW``

``16/32/64-bit``
"""
PADDW_MM_MMM64: Code = 2545 # type: ignore
"""
``PADDW mm, mm/m64``

``NP 0F FD /r``

``MMX``

``16/32/64-bit``
"""
PADDW_XMM_XMMM128: Code = 2546 # type: ignore
"""
``PADDW xmm1, xmm2/m128``

``66 0F FD /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPADDW_XMM_XMM_XMMM128: Code = 2547 # type: ignore
"""
``VPADDW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG FD /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPADDW_YMM_YMM_YMMM256: Code = 2548 # type: ignore
"""
``VPADDW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG FD /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPADDW_XMM_K1Z_XMM_XMMM128: Code = 2549 # type: ignore
"""
``VPADDW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F.WIG FD /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPADDW_YMM_K1Z_YMM_YMMM256: Code = 2550 # type: ignore
"""
``VPADDW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F.WIG FD /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPADDW_ZMM_K1Z_ZMM_ZMMM512: Code = 2551 # type: ignore
"""
``VPADDW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F.WIG FD /r``

``AVX512BW``

``16/32/64-bit``
"""
PADDD_MM_MMM64: Code = 2552 # type: ignore
"""
``PADDD mm, mm/m64``

``NP 0F FE /r``

``MMX``

``16/32/64-bit``
"""
PADDD_XMM_XMMM128: Code = 2553 # type: ignore
"""
``PADDD xmm1, xmm2/m128``

``66 0F FE /r``

``SSE2``

``16/32/64-bit``
"""
VEX_VPADDD_XMM_XMM_XMMM128: Code = 2554 # type: ignore
"""
``VPADDD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F.WIG FE /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPADDD_YMM_YMM_YMMM256: Code = 2555 # type: ignore
"""
``VPADDD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F.WIG FE /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPADDD_XMM_K1Z_XMM_XMMM128B32: Code = 2556 # type: ignore
"""
``VPADDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F.W0 FE /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPADDD_YMM_K1Z_YMM_YMMM256B32: Code = 2557 # type: ignore
"""
``VPADDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F.W0 FE /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPADDD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 2558 # type: ignore
"""
``VPADDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F.W0 FE /r``

``AVX512F``

``16/32/64-bit``
"""
UD0_R16_RM16: Code = 2559 # type: ignore
"""
``UD0 r16, r/m16``

``o16 0F FF /r``

``286+``

``16/32/64-bit``
"""
UD0_R32_RM32: Code = 2560 # type: ignore
"""
``UD0 r32, r/m32``

``o32 0F FF /r``

``386+``

``16/32/64-bit``
"""
UD0_R64_RM64: Code = 2561 # type: ignore
"""
``UD0 r64, r/m64``

``o64 0F FF /r``

``X64``

``64-bit``
"""
PSHUFB_MM_MMM64: Code = 2562 # type: ignore
"""
``PSHUFB mm1, mm2/m64``

``NP 0F 38 00 /r``

``SSSE3``

``16/32/64-bit``
"""
PSHUFB_XMM_XMMM128: Code = 2563 # type: ignore
"""
``PSHUFB xmm1, xmm2/m128``

``66 0F 38 00 /r``

``SSSE3``

``16/32/64-bit``
"""
VEX_VPSHUFB_XMM_XMM_XMMM128: Code = 2564 # type: ignore
"""
``VPSHUFB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 00 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSHUFB_YMM_YMM_YMMM256: Code = 2565 # type: ignore
"""
``VPSHUFB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 00 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSHUFB_XMM_K1Z_XMM_XMMM128: Code = 2566 # type: ignore
"""
``VPSHUFB xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.WIG 00 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSHUFB_YMM_K1Z_YMM_YMMM256: Code = 2567 # type: ignore
"""
``VPSHUFB ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.WIG 00 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSHUFB_ZMM_K1Z_ZMM_ZMMM512: Code = 2568 # type: ignore
"""
``VPSHUFB zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.WIG 00 /r``

``AVX512BW``

``16/32/64-bit``
"""
PHADDW_MM_MMM64: Code = 2569 # type: ignore
"""
``PHADDW mm1, mm2/m64``

``NP 0F 38 01 /r``

``SSSE3``

``16/32/64-bit``
"""
PHADDW_XMM_XMMM128: Code = 2570 # type: ignore
"""
``PHADDW xmm1, xmm2/m128``

``66 0F 38 01 /r``

``SSSE3``

``16/32/64-bit``
"""
VEX_VPHADDW_XMM_XMM_XMMM128: Code = 2571 # type: ignore
"""
``VPHADDW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 01 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPHADDW_YMM_YMM_YMMM256: Code = 2572 # type: ignore
"""
``VPHADDW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 01 /r``

``AVX2``

``16/32/64-bit``
"""
PHADDD_MM_MMM64: Code = 2573 # type: ignore
"""
``PHADDD mm1, mm2/m64``

``NP 0F 38 02 /r``

``SSSE3``

``16/32/64-bit``
"""
PHADDD_XMM_XMMM128: Code = 2574 # type: ignore
"""
``PHADDD xmm1, xmm2/m128``

``66 0F 38 02 /r``

``SSSE3``

``16/32/64-bit``
"""
VEX_VPHADDD_XMM_XMM_XMMM128: Code = 2575 # type: ignore
"""
``VPHADDD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 02 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPHADDD_YMM_YMM_YMMM256: Code = 2576 # type: ignore
"""
``VPHADDD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 02 /r``

``AVX2``

``16/32/64-bit``
"""
PHADDSW_MM_MMM64: Code = 2577 # type: ignore
"""
``PHADDSW mm1, mm2/m64``

``NP 0F 38 03 /r``

``SSSE3``

``16/32/64-bit``
"""
PHADDSW_XMM_XMMM128: Code = 2578 # type: ignore
"""
``PHADDSW xmm1, xmm2/m128``

``66 0F 38 03 /r``

``SSSE3``

``16/32/64-bit``
"""
VEX_VPHADDSW_XMM_XMM_XMMM128: Code = 2579 # type: ignore
"""
``VPHADDSW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 03 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPHADDSW_YMM_YMM_YMMM256: Code = 2580 # type: ignore
"""
``VPHADDSW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 03 /r``

``AVX2``

``16/32/64-bit``
"""
PMADDUBSW_MM_MMM64: Code = 2581 # type: ignore
"""
``PMADDUBSW mm1, mm2/m64``

``NP 0F 38 04 /r``

``SSSE3``

``16/32/64-bit``
"""
PMADDUBSW_XMM_XMMM128: Code = 2582 # type: ignore
"""
``PMADDUBSW xmm1, xmm2/m128``

``66 0F 38 04 /r``

``SSSE3``

``16/32/64-bit``
"""
VEX_VPMADDUBSW_XMM_XMM_XMMM128: Code = 2583 # type: ignore
"""
``VPMADDUBSW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 04 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMADDUBSW_YMM_YMM_YMMM256: Code = 2584 # type: ignore
"""
``VPMADDUBSW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 04 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMADDUBSW_XMM_K1Z_XMM_XMMM128: Code = 2585 # type: ignore
"""
``VPMADDUBSW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.WIG 04 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMADDUBSW_YMM_K1Z_YMM_YMMM256: Code = 2586 # type: ignore
"""
``VPMADDUBSW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.WIG 04 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMADDUBSW_ZMM_K1Z_ZMM_ZMMM512: Code = 2587 # type: ignore
"""
``VPMADDUBSW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.WIG 04 /r``

``AVX512BW``

``16/32/64-bit``
"""
PHSUBW_MM_MMM64: Code = 2588 # type: ignore
"""
``PHSUBW mm1, mm2/m64``

``NP 0F 38 05 /r``

``SSSE3``

``16/32/64-bit``
"""
PHSUBW_XMM_XMMM128: Code = 2589 # type: ignore
"""
``PHSUBW xmm1, xmm2/m128``

``66 0F 38 05 /r``

``SSSE3``

``16/32/64-bit``
"""
VEX_VPHSUBW_XMM_XMM_XMMM128: Code = 2590 # type: ignore
"""
``VPHSUBW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 05 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPHSUBW_YMM_YMM_YMMM256: Code = 2591 # type: ignore
"""
``VPHSUBW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 05 /r``

``AVX2``

``16/32/64-bit``
"""
PHSUBD_MM_MMM64: Code = 2592 # type: ignore
"""
``PHSUBD mm1, mm2/m64``

``NP 0F 38 06 /r``

``SSSE3``

``16/32/64-bit``
"""
PHSUBD_XMM_XMMM128: Code = 2593 # type: ignore
"""
``PHSUBD xmm1, xmm2/m128``

``66 0F 38 06 /r``

``SSSE3``

``16/32/64-bit``
"""
VEX_VPHSUBD_XMM_XMM_XMMM128: Code = 2594 # type: ignore
"""
``VPHSUBD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 06 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPHSUBD_YMM_YMM_YMMM256: Code = 2595 # type: ignore
"""
``VPHSUBD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 06 /r``

``AVX2``

``16/32/64-bit``
"""
PHSUBSW_MM_MMM64: Code = 2596 # type: ignore
"""
``PHSUBSW mm1, mm2/m64``

``NP 0F 38 07 /r``

``SSSE3``

``16/32/64-bit``
"""
PHSUBSW_XMM_XMMM128: Code = 2597 # type: ignore
"""
``PHSUBSW xmm1, xmm2/m128``

``66 0F 38 07 /r``

``SSSE3``

``16/32/64-bit``
"""
VEX_VPHSUBSW_XMM_XMM_XMMM128: Code = 2598 # type: ignore
"""
``VPHSUBSW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 07 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPHSUBSW_YMM_YMM_YMMM256: Code = 2599 # type: ignore
"""
``VPHSUBSW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 07 /r``

``AVX2``

``16/32/64-bit``
"""
PSIGNB_MM_MMM64: Code = 2600 # type: ignore
"""
``PSIGNB mm1, mm2/m64``

``NP 0F 38 08 /r``

``SSSE3``

``16/32/64-bit``
"""
PSIGNB_XMM_XMMM128: Code = 2601 # type: ignore
"""
``PSIGNB xmm1, xmm2/m128``

``66 0F 38 08 /r``

``SSSE3``

``16/32/64-bit``
"""
VEX_VPSIGNB_XMM_XMM_XMMM128: Code = 2602 # type: ignore
"""
``VPSIGNB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 08 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSIGNB_YMM_YMM_YMMM256: Code = 2603 # type: ignore
"""
``VPSIGNB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 08 /r``

``AVX2``

``16/32/64-bit``
"""
PSIGNW_MM_MMM64: Code = 2604 # type: ignore
"""
``PSIGNW mm1, mm2/m64``

``NP 0F 38 09 /r``

``SSSE3``

``16/32/64-bit``
"""
PSIGNW_XMM_XMMM128: Code = 2605 # type: ignore
"""
``PSIGNW xmm1, xmm2/m128``

``66 0F 38 09 /r``

``SSSE3``

``16/32/64-bit``
"""
VEX_VPSIGNW_XMM_XMM_XMMM128: Code = 2606 # type: ignore
"""
``VPSIGNW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 09 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSIGNW_YMM_YMM_YMMM256: Code = 2607 # type: ignore
"""
``VPSIGNW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 09 /r``

``AVX2``

``16/32/64-bit``
"""
PSIGND_MM_MMM64: Code = 2608 # type: ignore
"""
``PSIGND mm1, mm2/m64``

``NP 0F 38 0A /r``

``SSSE3``

``16/32/64-bit``
"""
PSIGND_XMM_XMMM128: Code = 2609 # type: ignore
"""
``PSIGND xmm1, xmm2/m128``

``66 0F 38 0A /r``

``SSSE3``

``16/32/64-bit``
"""
VEX_VPSIGND_XMM_XMM_XMMM128: Code = 2610 # type: ignore
"""
``VPSIGND xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 0A /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPSIGND_YMM_YMM_YMMM256: Code = 2611 # type: ignore
"""
``VPSIGND ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 0A /r``

``AVX2``

``16/32/64-bit``
"""
PMULHRSW_MM_MMM64: Code = 2612 # type: ignore
"""
``PMULHRSW mm1, mm2/m64``

``NP 0F 38 0B /r``

``SSSE3``

``16/32/64-bit``
"""
PMULHRSW_XMM_XMMM128: Code = 2613 # type: ignore
"""
``PMULHRSW xmm1, xmm2/m128``

``66 0F 38 0B /r``

``SSSE3``

``16/32/64-bit``
"""
VEX_VPMULHRSW_XMM_XMM_XMMM128: Code = 2614 # type: ignore
"""
``VPMULHRSW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 0B /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMULHRSW_YMM_YMM_YMMM256: Code = 2615 # type: ignore
"""
``VPMULHRSW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 0B /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMULHRSW_XMM_K1Z_XMM_XMMM128: Code = 2616 # type: ignore
"""
``VPMULHRSW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.WIG 0B /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMULHRSW_YMM_K1Z_YMM_YMMM256: Code = 2617 # type: ignore
"""
``VPMULHRSW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.WIG 0B /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMULHRSW_ZMM_K1Z_ZMM_ZMMM512: Code = 2618 # type: ignore
"""
``VPMULHRSW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.WIG 0B /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_VPERMILPS_XMM_XMM_XMMM128: Code = 2619 # type: ignore
"""
``VPERMILPS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 0C /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPERMILPS_YMM_YMM_YMMM256: Code = 2620 # type: ignore
"""
``VPERMILPS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 0C /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VPERMILPS_XMM_K1Z_XMM_XMMM128B32: Code = 2621 # type: ignore
"""
``VPERMILPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 0C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMILPS_YMM_K1Z_YMM_YMMM256B32: Code = 2622 # type: ignore
"""
``VPERMILPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 0C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMILPS_ZMM_K1Z_ZMM_ZMMM512B32: Code = 2623 # type: ignore
"""
``VPERMILPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 0C /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VPERMILPD_XMM_XMM_XMMM128: Code = 2624 # type: ignore
"""
``VPERMILPD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 0D /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPERMILPD_YMM_YMM_YMMM256: Code = 2625 # type: ignore
"""
``VPERMILPD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 0D /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VPERMILPD_XMM_K1Z_XMM_XMMM128B64: Code = 2626 # type: ignore
"""
``VPERMILPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 0D /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMILPD_YMM_K1Z_YMM_YMMM256B64: Code = 2627 # type: ignore
"""
``VPERMILPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 0D /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMILPD_ZMM_K1Z_ZMM_ZMMM512B64: Code = 2628 # type: ignore
"""
``VPERMILPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 0D /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VTESTPS_XMM_XMMM128: Code = 2629 # type: ignore
"""
``VTESTPS xmm1, xmm2/m128``

``VEX.128.66.0F38.W0 0E /r``

``AVX``

``16/32/64-bit``
"""
VEX_VTESTPS_YMM_YMMM256: Code = 2630 # type: ignore
"""
``VTESTPS ymm1, ymm2/m256``

``VEX.256.66.0F38.W0 0E /r``

``AVX``

``16/32/64-bit``
"""
VEX_VTESTPD_XMM_XMMM128: Code = 2631 # type: ignore
"""
``VTESTPD xmm1, xmm2/m128``

``VEX.128.66.0F38.W0 0F /r``

``AVX``

``16/32/64-bit``
"""
VEX_VTESTPD_YMM_YMMM256: Code = 2632 # type: ignore
"""
``VTESTPD ymm1, ymm2/m256``

``VEX.256.66.0F38.W0 0F /r``

``AVX``

``16/32/64-bit``
"""
PBLENDVB_XMM_XMMM128: Code = 2633 # type: ignore
"""
``PBLENDVB xmm1, xmm2/m128, <XMM0>``

``66 0F 38 10 /r``

``SSE4.1``

``16/32/64-bit``
"""
EVEX_VPSRLVW_XMM_K1Z_XMM_XMMM128: Code = 2634 # type: ignore
"""
``VPSRLVW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.W1 10 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSRLVW_YMM_K1Z_YMM_YMMM256: Code = 2635 # type: ignore
"""
``VPSRLVW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.W1 10 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSRLVW_ZMM_K1Z_ZMM_ZMMM512: Code = 2636 # type: ignore
"""
``VPSRLVW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.W1 10 /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVUSWB_XMMM64_K1Z_XMM: Code = 2637 # type: ignore
"""
``VPMOVUSWB xmm1/m64 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 10 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVUSWB_XMMM128_K1Z_YMM: Code = 2638 # type: ignore
"""
``VPMOVUSWB xmm1/m128 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 10 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVUSWB_YMMM256_K1Z_ZMM: Code = 2639 # type: ignore
"""
``VPMOVUSWB ymm1/m256 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 10 /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSRAVW_XMM_K1Z_XMM_XMMM128: Code = 2640 # type: ignore
"""
``VPSRAVW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.W1 11 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSRAVW_YMM_K1Z_YMM_YMMM256: Code = 2641 # type: ignore
"""
``VPSRAVW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.W1 11 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSRAVW_ZMM_K1Z_ZMM_ZMMM512: Code = 2642 # type: ignore
"""
``VPSRAVW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.W1 11 /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVUSDB_XMMM32_K1Z_XMM: Code = 2643 # type: ignore
"""
``VPMOVUSDB xmm1/m32 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 11 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVUSDB_XMMM64_K1Z_YMM: Code = 2644 # type: ignore
"""
``VPMOVUSDB xmm1/m64 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 11 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVUSDB_XMMM128_K1Z_ZMM: Code = 2645 # type: ignore
"""
``VPMOVUSDB xmm1/m128 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 11 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPSLLVW_XMM_K1Z_XMM_XMMM128: Code = 2646 # type: ignore
"""
``VPSLLVW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.W1 12 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSLLVW_YMM_K1Z_YMM_YMMM256: Code = 2647 # type: ignore
"""
``VPSLLVW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.W1 12 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPSLLVW_ZMM_K1Z_ZMM_ZMMM512: Code = 2648 # type: ignore
"""
``VPSLLVW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.W1 12 /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVUSQB_XMMM16_K1Z_XMM: Code = 2649 # type: ignore
"""
``VPMOVUSQB xmm1/m16 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 12 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVUSQB_XMMM32_K1Z_YMM: Code = 2650 # type: ignore
"""
``VPMOVUSQB xmm1/m32 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 12 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVUSQB_XMMM64_K1Z_ZMM: Code = 2651 # type: ignore
"""
``VPMOVUSQB xmm1/m64 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 12 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VCVTPH2PS_XMM_XMMM64: Code = 2652 # type: ignore
"""
``VCVTPH2PS xmm1, xmm2/m64``

``VEX.128.66.0F38.W0 13 /r``

``F16C``

``16/32/64-bit``
"""
VEX_VCVTPH2PS_YMM_XMMM128: Code = 2653 # type: ignore
"""
``VCVTPH2PS ymm1, xmm2/m128``

``VEX.256.66.0F38.W0 13 /r``

``F16C``

``16/32/64-bit``
"""
EVEX_VCVTPH2PS_XMM_K1Z_XMMM64: Code = 2654 # type: ignore
"""
``VCVTPH2PS xmm1 {k1}{z}, xmm2/m64``

``EVEX.128.66.0F38.W0 13 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTPH2PS_YMM_K1Z_XMMM128: Code = 2655 # type: ignore
"""
``VCVTPH2PS ymm1 {k1}{z}, xmm2/m128``

``EVEX.256.66.0F38.W0 13 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTPH2PS_ZMM_K1Z_YMMM256_SAE: Code = 2656 # type: ignore
"""
``VCVTPH2PS zmm1 {k1}{z}, ymm2/m256{sae}``

``EVEX.512.66.0F38.W0 13 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVUSDW_XMMM64_K1Z_XMM: Code = 2657 # type: ignore
"""
``VPMOVUSDW xmm1/m64 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 13 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVUSDW_XMMM128_K1Z_YMM: Code = 2658 # type: ignore
"""
``VPMOVUSDW xmm1/m128 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 13 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVUSDW_YMMM256_K1Z_ZMM: Code = 2659 # type: ignore
"""
``VPMOVUSDW ymm1/m256 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 13 /r``

``AVX512F``

``16/32/64-bit``
"""
BLENDVPS_XMM_XMMM128: Code = 2660 # type: ignore
"""
``BLENDVPS xmm1, xmm2/m128, <XMM0>``

``66 0F 38 14 /r``

``SSE4.1``

``16/32/64-bit``
"""
EVEX_VPRORVD_XMM_K1Z_XMM_XMMM128B32: Code = 2661 # type: ignore
"""
``VPRORVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 14 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPRORVD_YMM_K1Z_YMM_YMMM256B32: Code = 2662 # type: ignore
"""
``VPRORVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 14 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPRORVD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 2663 # type: ignore
"""
``VPRORVD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 14 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPRORVQ_XMM_K1Z_XMM_XMMM128B64: Code = 2664 # type: ignore
"""
``VPRORVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 14 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPRORVQ_YMM_K1Z_YMM_YMMM256B64: Code = 2665 # type: ignore
"""
``VPRORVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 14 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPRORVQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 2666 # type: ignore
"""
``VPRORVQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 14 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVUSQW_XMMM32_K1Z_XMM: Code = 2667 # type: ignore
"""
``VPMOVUSQW xmm1/m32 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 14 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVUSQW_XMMM64_K1Z_YMM: Code = 2668 # type: ignore
"""
``VPMOVUSQW xmm1/m64 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 14 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVUSQW_XMMM128_K1Z_ZMM: Code = 2669 # type: ignore
"""
``VPMOVUSQW xmm1/m128 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 14 /r``

``AVX512F``

``16/32/64-bit``
"""
BLENDVPD_XMM_XMMM128: Code = 2670 # type: ignore
"""
``BLENDVPD xmm1, xmm2/m128, <XMM0>``

``66 0F 38 15 /r``

``SSE4.1``

``16/32/64-bit``
"""
EVEX_VPROLVD_XMM_K1Z_XMM_XMMM128B32: Code = 2671 # type: ignore
"""
``VPROLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 15 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPROLVD_YMM_K1Z_YMM_YMMM256B32: Code = 2672 # type: ignore
"""
``VPROLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 15 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPROLVD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 2673 # type: ignore
"""
``VPROLVD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 15 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPROLVQ_XMM_K1Z_XMM_XMMM128B64: Code = 2674 # type: ignore
"""
``VPROLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 15 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPROLVQ_YMM_K1Z_YMM_YMMM256B64: Code = 2675 # type: ignore
"""
``VPROLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 15 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPROLVQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 2676 # type: ignore
"""
``VPROLVQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 15 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVUSQD_XMMM64_K1Z_XMM: Code = 2677 # type: ignore
"""
``VPMOVUSQD xmm1/m64 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 15 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVUSQD_XMMM128_K1Z_YMM: Code = 2678 # type: ignore
"""
``VPMOVUSQD xmm1/m128 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 15 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVUSQD_YMMM256_K1Z_ZMM: Code = 2679 # type: ignore
"""
``VPMOVUSQD ymm1/m256 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 15 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VPERMPS_YMM_YMM_YMMM256: Code = 2680 # type: ignore
"""
``VPERMPS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 16 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPERMPS_YMM_K1Z_YMM_YMMM256B32: Code = 2681 # type: ignore
"""
``VPERMPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 16 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMPS_ZMM_K1Z_ZMM_ZMMM512B32: Code = 2682 # type: ignore
"""
``VPERMPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 16 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMPD_YMM_K1Z_YMM_YMMM256B64: Code = 2683 # type: ignore
"""
``VPERMPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 16 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMPD_ZMM_K1Z_ZMM_ZMMM512B64: Code = 2684 # type: ignore
"""
``VPERMPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 16 /r``

``AVX512F``

``16/32/64-bit``
"""
PTEST_XMM_XMMM128: Code = 2685 # type: ignore
"""
``PTEST xmm1, xmm2/m128``

``66 0F 38 17 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPTEST_XMM_XMMM128: Code = 2686 # type: ignore
"""
``VPTEST xmm1, xmm2/m128``

``VEX.128.66.0F38.WIG 17 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPTEST_YMM_YMMM256: Code = 2687 # type: ignore
"""
``VPTEST ymm1, ymm2/m256``

``VEX.256.66.0F38.WIG 17 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VBROADCASTSS_XMM_M32: Code = 2688 # type: ignore
"""
``VBROADCASTSS xmm1, m32``

``VEX.128.66.0F38.W0 18 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VBROADCASTSS_YMM_M32: Code = 2689 # type: ignore
"""
``VBROADCASTSS ymm1, m32``

``VEX.256.66.0F38.W0 18 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VBROADCASTSS_XMM_K1Z_XMMM32: Code = 2690 # type: ignore
"""
``VBROADCASTSS xmm1 {k1}{z}, xmm2/m32``

``EVEX.128.66.0F38.W0 18 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VBROADCASTSS_YMM_K1Z_XMMM32: Code = 2691 # type: ignore
"""
``VBROADCASTSS ymm1 {k1}{z}, xmm2/m32``

``EVEX.256.66.0F38.W0 18 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VBROADCASTSS_ZMM_K1Z_XMMM32: Code = 2692 # type: ignore
"""
``VBROADCASTSS zmm1 {k1}{z}, xmm2/m32``

``EVEX.512.66.0F38.W0 18 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VBROADCASTSD_YMM_M64: Code = 2693 # type: ignore
"""
``VBROADCASTSD ymm1, m64``

``VEX.256.66.0F38.W0 19 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VBROADCASTF32X2_YMM_K1Z_XMMM64: Code = 2694 # type: ignore
"""
``VBROADCASTF32X2 ymm1 {k1}{z}, xmm2/m64``

``EVEX.256.66.0F38.W0 19 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VBROADCASTF32X2_ZMM_K1Z_XMMM64: Code = 2695 # type: ignore
"""
``VBROADCASTF32X2 zmm1 {k1}{z}, xmm2/m64``

``EVEX.512.66.0F38.W0 19 /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VBROADCASTSD_YMM_K1Z_XMMM64: Code = 2696 # type: ignore
"""
``VBROADCASTSD ymm1 {k1}{z}, xmm2/m64``

``EVEX.256.66.0F38.W1 19 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VBROADCASTSD_ZMM_K1Z_XMMM64: Code = 2697 # type: ignore
"""
``VBROADCASTSD zmm1 {k1}{z}, xmm2/m64``

``EVEX.512.66.0F38.W1 19 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VBROADCASTF128_YMM_M128: Code = 2698 # type: ignore
"""
``VBROADCASTF128 ymm1, m128``

``VEX.256.66.0F38.W0 1A /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VBROADCASTF32X4_YMM_K1Z_M128: Code = 2699 # type: ignore
"""
``VBROADCASTF32X4 ymm1 {k1}{z}, m128``

``EVEX.256.66.0F38.W0 1A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VBROADCASTF32X4_ZMM_K1Z_M128: Code = 2700 # type: ignore
"""
``VBROADCASTF32X4 zmm1 {k1}{z}, m128``

``EVEX.512.66.0F38.W0 1A /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VBROADCASTF64X2_YMM_K1Z_M128: Code = 2701 # type: ignore
"""
``VBROADCASTF64X2 ymm1 {k1}{z}, m128``

``EVEX.256.66.0F38.W1 1A /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VBROADCASTF64X2_ZMM_K1Z_M128: Code = 2702 # type: ignore
"""
``VBROADCASTF64X2 zmm1 {k1}{z}, m128``

``EVEX.512.66.0F38.W1 1A /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VBROADCASTF32X8_ZMM_K1Z_M256: Code = 2703 # type: ignore
"""
``VBROADCASTF32X8 zmm1 {k1}{z}, m256``

``EVEX.512.66.0F38.W0 1B /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VBROADCASTF64X4_ZMM_K1Z_M256: Code = 2704 # type: ignore
"""
``VBROADCASTF64X4 zmm1 {k1}{z}, m256``

``EVEX.512.66.0F38.W1 1B /r``

``AVX512F``

``16/32/64-bit``
"""
PABSB_MM_MMM64: Code = 2705 # type: ignore
"""
``PABSB mm1, mm2/m64``

``NP 0F 38 1C /r``

``SSSE3``

``16/32/64-bit``
"""
PABSB_XMM_XMMM128: Code = 2706 # type: ignore
"""
``PABSB xmm1, xmm2/m128``

``66 0F 38 1C /r``

``SSSE3``

``16/32/64-bit``
"""
VEX_VPABSB_XMM_XMMM128: Code = 2707 # type: ignore
"""
``VPABSB xmm1, xmm2/m128``

``VEX.128.66.0F38.WIG 1C /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPABSB_YMM_YMMM256: Code = 2708 # type: ignore
"""
``VPABSB ymm1, ymm2/m256``

``VEX.256.66.0F38.WIG 1C /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPABSB_XMM_K1Z_XMMM128: Code = 2709 # type: ignore
"""
``VPABSB xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.66.0F38.WIG 1C /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPABSB_YMM_K1Z_YMMM256: Code = 2710 # type: ignore
"""
``VPABSB ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.66.0F38.WIG 1C /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPABSB_ZMM_K1Z_ZMMM512: Code = 2711 # type: ignore
"""
``VPABSB zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.66.0F38.WIG 1C /r``

``AVX512BW``

``16/32/64-bit``
"""
PABSW_MM_MMM64: Code = 2712 # type: ignore
"""
``PABSW mm1, mm2/m64``

``NP 0F 38 1D /r``

``SSSE3``

``16/32/64-bit``
"""
PABSW_XMM_XMMM128: Code = 2713 # type: ignore
"""
``PABSW xmm1, xmm2/m128``

``66 0F 38 1D /r``

``SSSE3``

``16/32/64-bit``
"""
VEX_VPABSW_XMM_XMMM128: Code = 2714 # type: ignore
"""
``VPABSW xmm1, xmm2/m128``

``VEX.128.66.0F38.WIG 1D /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPABSW_YMM_YMMM256: Code = 2715 # type: ignore
"""
``VPABSW ymm1, ymm2/m256``

``VEX.256.66.0F38.WIG 1D /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPABSW_XMM_K1Z_XMMM128: Code = 2716 # type: ignore
"""
``VPABSW xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.66.0F38.WIG 1D /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPABSW_YMM_K1Z_YMMM256: Code = 2717 # type: ignore
"""
``VPABSW ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.66.0F38.WIG 1D /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPABSW_ZMM_K1Z_ZMMM512: Code = 2718 # type: ignore
"""
``VPABSW zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.66.0F38.WIG 1D /r``

``AVX512BW``

``16/32/64-bit``
"""
PABSD_MM_MMM64: Code = 2719 # type: ignore
"""
``PABSD mm1, mm2/m64``

``NP 0F 38 1E /r``

``SSSE3``

``16/32/64-bit``
"""
PABSD_XMM_XMMM128: Code = 2720 # type: ignore
"""
``PABSD xmm1, xmm2/m128``

``66 0F 38 1E /r``

``SSSE3``

``16/32/64-bit``
"""
VEX_VPABSD_XMM_XMMM128: Code = 2721 # type: ignore
"""
``VPABSD xmm1, xmm2/m128``

``VEX.128.66.0F38.WIG 1E /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPABSD_YMM_YMMM256: Code = 2722 # type: ignore
"""
``VPABSD ymm1, ymm2/m256``

``VEX.256.66.0F38.WIG 1E /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPABSD_XMM_K1Z_XMMM128B32: Code = 2723 # type: ignore
"""
``VPABSD xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.66.0F38.W0 1E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPABSD_YMM_K1Z_YMMM256B32: Code = 2724 # type: ignore
"""
``VPABSD ymm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.66.0F38.W0 1E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPABSD_ZMM_K1Z_ZMMM512B32: Code = 2725 # type: ignore
"""
``VPABSD zmm1 {k1}{z}, zmm2/m512/m32bcst``

``EVEX.512.66.0F38.W0 1E /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPABSQ_XMM_K1Z_XMMM128B64: Code = 2726 # type: ignore
"""
``VPABSQ xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.66.0F38.W1 1F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPABSQ_YMM_K1Z_YMMM256B64: Code = 2727 # type: ignore
"""
``VPABSQ ymm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.66.0F38.W1 1F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPABSQ_ZMM_K1Z_ZMMM512B64: Code = 2728 # type: ignore
"""
``VPABSQ zmm1 {k1}{z}, zmm2/m512/m64bcst``

``EVEX.512.66.0F38.W1 1F /r``

``AVX512F``

``16/32/64-bit``
"""
PMOVSXBW_XMM_XMMM64: Code = 2729 # type: ignore
"""
``PMOVSXBW xmm1, xmm2/m64``

``66 0F 38 20 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMOVSXBW_XMM_XMMM64: Code = 2730 # type: ignore
"""
``VPMOVSXBW xmm1, xmm2/m64``

``VEX.128.66.0F38.WIG 20 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMOVSXBW_YMM_XMMM128: Code = 2731 # type: ignore
"""
``VPMOVSXBW ymm1, xmm2/m128``

``VEX.256.66.0F38.WIG 20 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMOVSXBW_XMM_K1Z_XMMM64: Code = 2732 # type: ignore
"""
``VPMOVSXBW xmm1 {k1}{z}, xmm2/m64``

``EVEX.128.66.0F38.WIG 20 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVSXBW_YMM_K1Z_XMMM128: Code = 2733 # type: ignore
"""
``VPMOVSXBW ymm1 {k1}{z}, xmm2/m128``

``EVEX.256.66.0F38.WIG 20 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVSXBW_ZMM_K1Z_YMMM256: Code = 2734 # type: ignore
"""
``VPMOVSXBW zmm1 {k1}{z}, ymm2/m256``

``EVEX.512.66.0F38.WIG 20 /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVSWB_XMMM64_K1Z_XMM: Code = 2735 # type: ignore
"""
``VPMOVSWB xmm1/m64 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 20 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVSWB_XMMM128_K1Z_YMM: Code = 2736 # type: ignore
"""
``VPMOVSWB xmm1/m128 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 20 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVSWB_YMMM256_K1Z_ZMM: Code = 2737 # type: ignore
"""
``VPMOVSWB ymm1/m256 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 20 /r``

``AVX512BW``

``16/32/64-bit``
"""
PMOVSXBD_XMM_XMMM32: Code = 2738 # type: ignore
"""
``PMOVSXBD xmm1, xmm2/m32``

``66 0F 38 21 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMOVSXBD_XMM_XMMM32: Code = 2739 # type: ignore
"""
``VPMOVSXBD xmm1, xmm2/m32``

``VEX.128.66.0F38.WIG 21 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMOVSXBD_YMM_XMMM64: Code = 2740 # type: ignore
"""
``VPMOVSXBD ymm1, xmm2/m64``

``VEX.256.66.0F38.WIG 21 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMOVSXBD_XMM_K1Z_XMMM32: Code = 2741 # type: ignore
"""
``VPMOVSXBD xmm1 {k1}{z}, xmm2/m32``

``EVEX.128.66.0F38.WIG 21 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSXBD_YMM_K1Z_XMMM64: Code = 2742 # type: ignore
"""
``VPMOVSXBD ymm1 {k1}{z}, xmm2/m64``

``EVEX.256.66.0F38.WIG 21 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSXBD_ZMM_K1Z_XMMM128: Code = 2743 # type: ignore
"""
``VPMOVSXBD zmm1 {k1}{z}, xmm2/m128``

``EVEX.512.66.0F38.WIG 21 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSDB_XMMM32_K1Z_XMM: Code = 2744 # type: ignore
"""
``VPMOVSDB xmm1/m32 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 21 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSDB_XMMM64_K1Z_YMM: Code = 2745 # type: ignore
"""
``VPMOVSDB xmm1/m64 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 21 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSDB_XMMM128_K1Z_ZMM: Code = 2746 # type: ignore
"""
``VPMOVSDB xmm1/m128 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 21 /r``

``AVX512F``

``16/32/64-bit``
"""
PMOVSXBQ_XMM_XMMM16: Code = 2747 # type: ignore
"""
``PMOVSXBQ xmm1, xmm2/m16``

``66 0F 38 22 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMOVSXBQ_XMM_XMMM16: Code = 2748 # type: ignore
"""
``VPMOVSXBQ xmm1, xmm2/m16``

``VEX.128.66.0F38.WIG 22 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMOVSXBQ_YMM_XMMM32: Code = 2749 # type: ignore
"""
``VPMOVSXBQ ymm1, xmm2/m32``

``VEX.256.66.0F38.WIG 22 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMOVSXBQ_XMM_K1Z_XMMM16: Code = 2750 # type: ignore
"""
``VPMOVSXBQ xmm1 {k1}{z}, xmm2/m16``

``EVEX.128.66.0F38.WIG 22 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSXBQ_YMM_K1Z_XMMM32: Code = 2751 # type: ignore
"""
``VPMOVSXBQ ymm1 {k1}{z}, xmm2/m32``

``EVEX.256.66.0F38.WIG 22 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSXBQ_ZMM_K1Z_XMMM64: Code = 2752 # type: ignore
"""
``VPMOVSXBQ zmm1 {k1}{z}, xmm2/m64``

``EVEX.512.66.0F38.WIG 22 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSQB_XMMM16_K1Z_XMM: Code = 2753 # type: ignore
"""
``VPMOVSQB xmm1/m16 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 22 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSQB_XMMM32_K1Z_YMM: Code = 2754 # type: ignore
"""
``VPMOVSQB xmm1/m32 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 22 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSQB_XMMM64_K1Z_ZMM: Code = 2755 # type: ignore
"""
``VPMOVSQB xmm1/m64 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 22 /r``

``AVX512F``

``16/32/64-bit``
"""
PMOVSXWD_XMM_XMMM64: Code = 2756 # type: ignore
"""
``PMOVSXWD xmm1, xmm2/m64``

``66 0F 38 23 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMOVSXWD_XMM_XMMM64: Code = 2757 # type: ignore
"""
``VPMOVSXWD xmm1, xmm2/m64``

``VEX.128.66.0F38.WIG 23 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMOVSXWD_YMM_XMMM128: Code = 2758 # type: ignore
"""
``VPMOVSXWD ymm1, xmm2/m128``

``VEX.256.66.0F38.WIG 23 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMOVSXWD_XMM_K1Z_XMMM64: Code = 2759 # type: ignore
"""
``VPMOVSXWD xmm1 {k1}{z}, xmm2/m64``

``EVEX.128.66.0F38.WIG 23 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSXWD_YMM_K1Z_XMMM128: Code = 2760 # type: ignore
"""
``VPMOVSXWD ymm1 {k1}{z}, xmm2/m128``

``EVEX.256.66.0F38.WIG 23 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSXWD_ZMM_K1Z_YMMM256: Code = 2761 # type: ignore
"""
``VPMOVSXWD zmm1 {k1}{z}, ymm2/m256``

``EVEX.512.66.0F38.WIG 23 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSDW_XMMM64_K1Z_XMM: Code = 2762 # type: ignore
"""
``VPMOVSDW xmm1/m64 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 23 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSDW_XMMM128_K1Z_YMM: Code = 2763 # type: ignore
"""
``VPMOVSDW xmm1/m128 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 23 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSDW_YMMM256_K1Z_ZMM: Code = 2764 # type: ignore
"""
``VPMOVSDW ymm1/m256 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 23 /r``

``AVX512F``

``16/32/64-bit``
"""
PMOVSXWQ_XMM_XMMM32: Code = 2765 # type: ignore
"""
``PMOVSXWQ xmm1, xmm2/m32``

``66 0F 38 24 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMOVSXWQ_XMM_XMMM32: Code = 2766 # type: ignore
"""
``VPMOVSXWQ xmm1, xmm2/m32``

``VEX.128.66.0F38.WIG 24 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMOVSXWQ_YMM_XMMM64: Code = 2767 # type: ignore
"""
``VPMOVSXWQ ymm1, xmm2/m64``

``VEX.256.66.0F38.WIG 24 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMOVSXWQ_XMM_K1Z_XMMM32: Code = 2768 # type: ignore
"""
``VPMOVSXWQ xmm1 {k1}{z}, xmm2/m32``

``EVEX.128.66.0F38.WIG 24 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSXWQ_YMM_K1Z_XMMM64: Code = 2769 # type: ignore
"""
``VPMOVSXWQ ymm1 {k1}{z}, xmm2/m64``

``EVEX.256.66.0F38.WIG 24 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSXWQ_ZMM_K1Z_XMMM128: Code = 2770 # type: ignore
"""
``VPMOVSXWQ zmm1 {k1}{z}, xmm2/m128``

``EVEX.512.66.0F38.WIG 24 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSQW_XMMM32_K1Z_XMM: Code = 2771 # type: ignore
"""
``VPMOVSQW xmm1/m32 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 24 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSQW_XMMM64_K1Z_YMM: Code = 2772 # type: ignore
"""
``VPMOVSQW xmm1/m64 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 24 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSQW_XMMM128_K1Z_ZMM: Code = 2773 # type: ignore
"""
``VPMOVSQW xmm1/m128 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 24 /r``

``AVX512F``

``16/32/64-bit``
"""
PMOVSXDQ_XMM_XMMM64: Code = 2774 # type: ignore
"""
``PMOVSXDQ xmm1, xmm2/m64``

``66 0F 38 25 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMOVSXDQ_XMM_XMMM64: Code = 2775 # type: ignore
"""
``VPMOVSXDQ xmm1, xmm2/m64``

``VEX.128.66.0F38.WIG 25 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMOVSXDQ_YMM_XMMM128: Code = 2776 # type: ignore
"""
``VPMOVSXDQ ymm1, xmm2/m128``

``VEX.256.66.0F38.WIG 25 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMOVSXDQ_XMM_K1Z_XMMM64: Code = 2777 # type: ignore
"""
``VPMOVSXDQ xmm1 {k1}{z}, xmm2/m64``

``EVEX.128.66.0F38.W0 25 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSXDQ_YMM_K1Z_XMMM128: Code = 2778 # type: ignore
"""
``VPMOVSXDQ ymm1 {k1}{z}, xmm2/m128``

``EVEX.256.66.0F38.W0 25 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSXDQ_ZMM_K1Z_YMMM256: Code = 2779 # type: ignore
"""
``VPMOVSXDQ zmm1 {k1}{z}, ymm2/m256``

``EVEX.512.66.0F38.W0 25 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSQD_XMMM64_K1Z_XMM: Code = 2780 # type: ignore
"""
``VPMOVSQD xmm1/m64 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 25 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSQD_XMMM128_K1Z_YMM: Code = 2781 # type: ignore
"""
``VPMOVSQD xmm1/m128 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 25 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVSQD_YMMM256_K1Z_ZMM: Code = 2782 # type: ignore
"""
``VPMOVSQD ymm1/m256 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 25 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPTESTMB_KR_K1_XMM_XMMM128: Code = 2783 # type: ignore
"""
``VPTESTMB k2 {k1}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.W0 26 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPTESTMB_KR_K1_YMM_YMMM256: Code = 2784 # type: ignore
"""
``VPTESTMB k2 {k1}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.W0 26 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPTESTMB_KR_K1_ZMM_ZMMM512: Code = 2785 # type: ignore
"""
``VPTESTMB k2 {k1}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.W0 26 /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPTESTMW_KR_K1_XMM_XMMM128: Code = 2786 # type: ignore
"""
``VPTESTMW k2 {k1}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.W1 26 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPTESTMW_KR_K1_YMM_YMMM256: Code = 2787 # type: ignore
"""
``VPTESTMW k2 {k1}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.W1 26 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPTESTMW_KR_K1_ZMM_ZMMM512: Code = 2788 # type: ignore
"""
``VPTESTMW k2 {k1}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.W1 26 /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPTESTNMB_KR_K1_XMM_XMMM128: Code = 2789 # type: ignore
"""
``VPTESTNMB k2 {k1}, xmm2, xmm3/m128``

``EVEX.128.F3.0F38.W0 26 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPTESTNMB_KR_K1_YMM_YMMM256: Code = 2790 # type: ignore
"""
``VPTESTNMB k2 {k1}, ymm2, ymm3/m256``

``EVEX.256.F3.0F38.W0 26 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPTESTNMB_KR_K1_ZMM_ZMMM512: Code = 2791 # type: ignore
"""
``VPTESTNMB k2 {k1}, zmm2, zmm3/m512``

``EVEX.512.F3.0F38.W0 26 /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPTESTNMW_KR_K1_XMM_XMMM128: Code = 2792 # type: ignore
"""
``VPTESTNMW k2 {k1}, xmm2, xmm3/m128``

``EVEX.128.F3.0F38.W1 26 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPTESTNMW_KR_K1_YMM_YMMM256: Code = 2793 # type: ignore
"""
``VPTESTNMW k2 {k1}, ymm2, ymm3/m256``

``EVEX.256.F3.0F38.W1 26 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPTESTNMW_KR_K1_ZMM_ZMMM512: Code = 2794 # type: ignore
"""
``VPTESTNMW k2 {k1}, zmm2, zmm3/m512``

``EVEX.512.F3.0F38.W1 26 /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPTESTMD_KR_K1_XMM_XMMM128B32: Code = 2795 # type: ignore
"""
``VPTESTMD k2 {k1}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 27 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPTESTMD_KR_K1_YMM_YMMM256B32: Code = 2796 # type: ignore
"""
``VPTESTMD k2 {k1}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 27 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPTESTMD_KR_K1_ZMM_ZMMM512B32: Code = 2797 # type: ignore
"""
``VPTESTMD k2 {k1}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 27 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPTESTMQ_KR_K1_XMM_XMMM128B64: Code = 2798 # type: ignore
"""
``VPTESTMQ k2 {k1}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 27 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPTESTMQ_KR_K1_YMM_YMMM256B64: Code = 2799 # type: ignore
"""
``VPTESTMQ k2 {k1}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 27 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPTESTMQ_KR_K1_ZMM_ZMMM512B64: Code = 2800 # type: ignore
"""
``VPTESTMQ k2 {k1}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 27 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPTESTNMD_KR_K1_XMM_XMMM128B32: Code = 2801 # type: ignore
"""
``VPTESTNMD k2 {k1}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.F3.0F38.W0 27 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPTESTNMD_KR_K1_YMM_YMMM256B32: Code = 2802 # type: ignore
"""
``VPTESTNMD k2 {k1}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.F3.0F38.W0 27 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPTESTNMD_KR_K1_ZMM_ZMMM512B32: Code = 2803 # type: ignore
"""
``VPTESTNMD k2 {k1}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.F3.0F38.W0 27 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPTESTNMQ_KR_K1_XMM_XMMM128B64: Code = 2804 # type: ignore
"""
``VPTESTNMQ k2 {k1}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.F3.0F38.W1 27 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPTESTNMQ_KR_K1_YMM_YMMM256B64: Code = 2805 # type: ignore
"""
``VPTESTNMQ k2 {k1}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.F3.0F38.W1 27 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPTESTNMQ_KR_K1_ZMM_ZMMM512B64: Code = 2806 # type: ignore
"""
``VPTESTNMQ k2 {k1}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.F3.0F38.W1 27 /r``

``AVX512F``

``16/32/64-bit``
"""
PMULDQ_XMM_XMMM128: Code = 2807 # type: ignore
"""
``PMULDQ xmm1, xmm2/m128``

``66 0F 38 28 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMULDQ_XMM_XMM_XMMM128: Code = 2808 # type: ignore
"""
``VPMULDQ xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 28 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMULDQ_YMM_YMM_YMMM256: Code = 2809 # type: ignore
"""
``VPMULDQ ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 28 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMULDQ_XMM_K1Z_XMM_XMMM128B64: Code = 2810 # type: ignore
"""
``VPMULDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 28 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMULDQ_YMM_K1Z_YMM_YMMM256B64: Code = 2811 # type: ignore
"""
``VPMULDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 28 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMULDQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 2812 # type: ignore
"""
``VPMULDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 28 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVM2B_XMM_KR: Code = 2813 # type: ignore
"""
``VPMOVM2B xmm1, k1``

``EVEX.128.F3.0F38.W0 28 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVM2B_YMM_KR: Code = 2814 # type: ignore
"""
``VPMOVM2B ymm1, k1``

``EVEX.256.F3.0F38.W0 28 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVM2B_ZMM_KR: Code = 2815 # type: ignore
"""
``VPMOVM2B zmm1, k1``

``EVEX.512.F3.0F38.W0 28 /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVM2W_XMM_KR: Code = 2816 # type: ignore
"""
``VPMOVM2W xmm1, k1``

``EVEX.128.F3.0F38.W1 28 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVM2W_YMM_KR: Code = 2817 # type: ignore
"""
``VPMOVM2W ymm1, k1``

``EVEX.256.F3.0F38.W1 28 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVM2W_ZMM_KR: Code = 2818 # type: ignore
"""
``VPMOVM2W zmm1, k1``

``EVEX.512.F3.0F38.W1 28 /r``

``AVX512BW``

``16/32/64-bit``
"""
PCMPEQQ_XMM_XMMM128: Code = 2819 # type: ignore
"""
``PCMPEQQ xmm1, xmm2/m128``

``66 0F 38 29 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPCMPEQQ_XMM_XMM_XMMM128: Code = 2820 # type: ignore
"""
``VPCMPEQQ xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 29 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPCMPEQQ_YMM_YMM_YMMM256: Code = 2821 # type: ignore
"""
``VPCMPEQQ ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 29 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPCMPEQQ_KR_K1_XMM_XMMM128B64: Code = 2822 # type: ignore
"""
``VPCMPEQQ k1 {k2}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 29 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPEQQ_KR_K1_YMM_YMMM256B64: Code = 2823 # type: ignore
"""
``VPCMPEQQ k1 {k2}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 29 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPEQQ_KR_K1_ZMM_ZMMM512B64: Code = 2824 # type: ignore
"""
``VPCMPEQQ k1 {k2}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 29 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVB2M_KR_XMM: Code = 2825 # type: ignore
"""
``VPMOVB2M k1, xmm1``

``EVEX.128.F3.0F38.W0 29 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVB2M_KR_YMM: Code = 2826 # type: ignore
"""
``VPMOVB2M k1, ymm1``

``EVEX.256.F3.0F38.W0 29 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVB2M_KR_ZMM: Code = 2827 # type: ignore
"""
``VPMOVB2M k1, zmm1``

``EVEX.512.F3.0F38.W0 29 /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVW2M_KR_XMM: Code = 2828 # type: ignore
"""
``VPMOVW2M k1, xmm1``

``EVEX.128.F3.0F38.W1 29 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVW2M_KR_YMM: Code = 2829 # type: ignore
"""
``VPMOVW2M k1, ymm1``

``EVEX.256.F3.0F38.W1 29 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVW2M_KR_ZMM: Code = 2830 # type: ignore
"""
``VPMOVW2M k1, zmm1``

``EVEX.512.F3.0F38.W1 29 /r``

``AVX512BW``

``16/32/64-bit``
"""
MOVNTDQA_XMM_M128: Code = 2831 # type: ignore
"""
``MOVNTDQA xmm1, m128``

``66 0F 38 2A /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VMOVNTDQA_XMM_M128: Code = 2832 # type: ignore
"""
``VMOVNTDQA xmm1, m128``

``VEX.128.66.0F38.WIG 2A /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMOVNTDQA_YMM_M256: Code = 2833 # type: ignore
"""
``VMOVNTDQA ymm1, m256``

``VEX.256.66.0F38.WIG 2A /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VMOVNTDQA_XMM_M128: Code = 2834 # type: ignore
"""
``VMOVNTDQA xmm1, m128``

``EVEX.128.66.0F38.W0 2A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVNTDQA_YMM_M256: Code = 2835 # type: ignore
"""
``VMOVNTDQA ymm1, m256``

``EVEX.256.66.0F38.W0 2A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VMOVNTDQA_ZMM_M512: Code = 2836 # type: ignore
"""
``VMOVNTDQA zmm1, m512``

``EVEX.512.66.0F38.W0 2A /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPBROADCASTMB2Q_XMM_KR: Code = 2837 # type: ignore
"""
``VPBROADCASTMB2Q xmm1, k1``

``EVEX.128.F3.0F38.W1 2A /r``

``AVX512VL and AVX512CD``

``16/32/64-bit``
"""
EVEX_VPBROADCASTMB2Q_YMM_KR: Code = 2838 # type: ignore
"""
``VPBROADCASTMB2Q ymm1, k1``

``EVEX.256.F3.0F38.W1 2A /r``

``AVX512VL and AVX512CD``

``16/32/64-bit``
"""
EVEX_VPBROADCASTMB2Q_ZMM_KR: Code = 2839 # type: ignore
"""
``VPBROADCASTMB2Q zmm1, k1``

``EVEX.512.F3.0F38.W1 2A /r``

``AVX512CD``

``16/32/64-bit``
"""
PACKUSDW_XMM_XMMM128: Code = 2840 # type: ignore
"""
``PACKUSDW xmm1, xmm2/m128``

``66 0F 38 2B /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPACKUSDW_XMM_XMM_XMMM128: Code = 2841 # type: ignore
"""
``VPACKUSDW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 2B /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPACKUSDW_YMM_YMM_YMMM256: Code = 2842 # type: ignore
"""
``VPACKUSDW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 2B /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPACKUSDW_XMM_K1Z_XMM_XMMM128B32: Code = 2843 # type: ignore
"""
``VPACKUSDW xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 2B /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPACKUSDW_YMM_K1Z_YMM_YMMM256B32: Code = 2844 # type: ignore
"""
``VPACKUSDW ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 2B /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPACKUSDW_ZMM_K1Z_ZMM_ZMMM512B32: Code = 2845 # type: ignore
"""
``VPACKUSDW zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 2B /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_VMASKMOVPS_XMM_XMM_M128: Code = 2846 # type: ignore
"""
``VMASKMOVPS xmm1, xmm2, m128``

``VEX.128.66.0F38.W0 2C /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMASKMOVPS_YMM_YMM_M256: Code = 2847 # type: ignore
"""
``VMASKMOVPS ymm1, ymm2, m256``

``VEX.256.66.0F38.W0 2C /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VSCALEFPS_XMM_K1Z_XMM_XMMM128B32: Code = 2848 # type: ignore
"""
``VSCALEFPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 2C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSCALEFPS_YMM_K1Z_YMM_YMMM256B32: Code = 2849 # type: ignore
"""
``VSCALEFPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 2C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSCALEFPS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 2850 # type: ignore
"""
``VSCALEFPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 2C /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VSCALEFPD_XMM_K1Z_XMM_XMMM128B64: Code = 2851 # type: ignore
"""
``VSCALEFPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 2C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSCALEFPD_YMM_K1Z_YMM_YMMM256B64: Code = 2852 # type: ignore
"""
``VSCALEFPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 2C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSCALEFPD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 2853 # type: ignore
"""
``VSCALEFPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 2C /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VMASKMOVPD_XMM_XMM_M128: Code = 2854 # type: ignore
"""
``VMASKMOVPD xmm1, xmm2, m128``

``VEX.128.66.0F38.W0 2D /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMASKMOVPD_YMM_YMM_M256: Code = 2855 # type: ignore
"""
``VMASKMOVPD ymm1, ymm2, m256``

``VEX.256.66.0F38.W0 2D /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VSCALEFSS_XMM_K1Z_XMM_XMMM32_ER: Code = 2856 # type: ignore
"""
``VSCALEFSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.66.0F38.W0 2D /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VSCALEFSD_XMM_K1Z_XMM_XMMM64_ER: Code = 2857 # type: ignore
"""
``VSCALEFSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.66.0F38.W1 2D /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VMASKMOVPS_M128_XMM_XMM: Code = 2858 # type: ignore
"""
``VMASKMOVPS m128, xmm1, xmm2``

``VEX.128.66.0F38.W0 2E /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMASKMOVPS_M256_YMM_YMM: Code = 2859 # type: ignore
"""
``VMASKMOVPS m256, ymm1, ymm2``

``VEX.256.66.0F38.W0 2E /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMASKMOVPD_M128_XMM_XMM: Code = 2860 # type: ignore
"""
``VMASKMOVPD m128, xmm1, xmm2``

``VEX.128.66.0F38.W0 2F /r``

``AVX``

``16/32/64-bit``
"""
VEX_VMASKMOVPD_M256_YMM_YMM: Code = 2861 # type: ignore
"""
``VMASKMOVPD m256, ymm1, ymm2``

``VEX.256.66.0F38.W0 2F /r``

``AVX``

``16/32/64-bit``
"""
PMOVZXBW_XMM_XMMM64: Code = 2862 # type: ignore
"""
``PMOVZXBW xmm1, xmm2/m64``

``66 0F 38 30 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMOVZXBW_XMM_XMMM64: Code = 2863 # type: ignore
"""
``VPMOVZXBW xmm1, xmm2/m64``

``VEX.128.66.0F38.WIG 30 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMOVZXBW_YMM_XMMM128: Code = 2864 # type: ignore
"""
``VPMOVZXBW ymm1, xmm2/m128``

``VEX.256.66.0F38.WIG 30 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMOVZXBW_XMM_K1Z_XMMM64: Code = 2865 # type: ignore
"""
``VPMOVZXBW xmm1 {k1}{z}, xmm2/m64``

``EVEX.128.66.0F38.WIG 30 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVZXBW_YMM_K1Z_XMMM128: Code = 2866 # type: ignore
"""
``VPMOVZXBW ymm1 {k1}{z}, xmm2/m128``

``EVEX.256.66.0F38.WIG 30 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVZXBW_ZMM_K1Z_YMMM256: Code = 2867 # type: ignore
"""
``VPMOVZXBW zmm1 {k1}{z}, ymm2/m256``

``EVEX.512.66.0F38.WIG 30 /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVWB_XMMM64_K1Z_XMM: Code = 2868 # type: ignore
"""
``VPMOVWB xmm1/m64 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 30 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVWB_XMMM128_K1Z_YMM: Code = 2869 # type: ignore
"""
``VPMOVWB xmm1/m128 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 30 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVWB_YMMM256_K1Z_ZMM: Code = 2870 # type: ignore
"""
``VPMOVWB ymm1/m256 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 30 /r``

``AVX512BW``

``16/32/64-bit``
"""
PMOVZXBD_XMM_XMMM32: Code = 2871 # type: ignore
"""
``PMOVZXBD xmm1, xmm2/m32``

``66 0F 38 31 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMOVZXBD_XMM_XMMM32: Code = 2872 # type: ignore
"""
``VPMOVZXBD xmm1, xmm2/m32``

``VEX.128.66.0F38.WIG 31 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMOVZXBD_YMM_XMMM64: Code = 2873 # type: ignore
"""
``VPMOVZXBD ymm1, xmm2/m64``

``VEX.256.66.0F38.WIG 31 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMOVZXBD_XMM_K1Z_XMMM32: Code = 2874 # type: ignore
"""
``VPMOVZXBD xmm1 {k1}{z}, xmm2/m32``

``EVEX.128.66.0F38.WIG 31 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVZXBD_YMM_K1Z_XMMM64: Code = 2875 # type: ignore
"""
``VPMOVZXBD ymm1 {k1}{z}, xmm2/m64``

``EVEX.256.66.0F38.WIG 31 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVZXBD_ZMM_K1Z_XMMM128: Code = 2876 # type: ignore
"""
``VPMOVZXBD zmm1 {k1}{z}, xmm2/m128``

``EVEX.512.66.0F38.WIG 31 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVDB_XMMM32_K1Z_XMM: Code = 2877 # type: ignore
"""
``VPMOVDB xmm1/m32 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 31 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVDB_XMMM64_K1Z_YMM: Code = 2878 # type: ignore
"""
``VPMOVDB xmm1/m64 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 31 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVDB_XMMM128_K1Z_ZMM: Code = 2879 # type: ignore
"""
``VPMOVDB xmm1/m128 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 31 /r``

``AVX512F``

``16/32/64-bit``
"""
PMOVZXBQ_XMM_XMMM16: Code = 2880 # type: ignore
"""
``PMOVZXBQ xmm1, xmm2/m16``

``66 0F 38 32 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMOVZXBQ_XMM_XMMM16: Code = 2881 # type: ignore
"""
``VPMOVZXBQ xmm1, xmm2/m16``

``VEX.128.66.0F38.WIG 32 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMOVZXBQ_YMM_XMMM32: Code = 2882 # type: ignore
"""
``VPMOVZXBQ ymm1, xmm2/m32``

``VEX.256.66.0F38.WIG 32 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMOVZXBQ_XMM_K1Z_XMMM16: Code = 2883 # type: ignore
"""
``VPMOVZXBQ xmm1 {k1}{z}, xmm2/m16``

``EVEX.128.66.0F38.WIG 32 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVZXBQ_YMM_K1Z_XMMM32: Code = 2884 # type: ignore
"""
``VPMOVZXBQ ymm1 {k1}{z}, xmm2/m32``

``EVEX.256.66.0F38.WIG 32 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVZXBQ_ZMM_K1Z_XMMM64: Code = 2885 # type: ignore
"""
``VPMOVZXBQ zmm1 {k1}{z}, xmm2/m64``

``EVEX.512.66.0F38.WIG 32 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVQB_XMMM16_K1Z_XMM: Code = 2886 # type: ignore
"""
``VPMOVQB xmm1/m16 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 32 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVQB_XMMM32_K1Z_YMM: Code = 2887 # type: ignore
"""
``VPMOVQB xmm1/m32 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 32 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVQB_XMMM64_K1Z_ZMM: Code = 2888 # type: ignore
"""
``VPMOVQB xmm1/m64 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 32 /r``

``AVX512F``

``16/32/64-bit``
"""
PMOVZXWD_XMM_XMMM64: Code = 2889 # type: ignore
"""
``PMOVZXWD xmm1, xmm2/m64``

``66 0F 38 33 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMOVZXWD_XMM_XMMM64: Code = 2890 # type: ignore
"""
``VPMOVZXWD xmm1, xmm2/m64``

``VEX.128.66.0F38.WIG 33 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMOVZXWD_YMM_XMMM128: Code = 2891 # type: ignore
"""
``VPMOVZXWD ymm1, xmm2/m128``

``VEX.256.66.0F38.WIG 33 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMOVZXWD_XMM_K1Z_XMMM64: Code = 2892 # type: ignore
"""
``VPMOVZXWD xmm1 {k1}{z}, xmm2/m64``

``EVEX.128.66.0F38.WIG 33 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVZXWD_YMM_K1Z_XMMM128: Code = 2893 # type: ignore
"""
``VPMOVZXWD ymm1 {k1}{z}, xmm2/m128``

``EVEX.256.66.0F38.WIG 33 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVZXWD_ZMM_K1Z_YMMM256: Code = 2894 # type: ignore
"""
``VPMOVZXWD zmm1 {k1}{z}, ymm2/m256``

``EVEX.512.66.0F38.WIG 33 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVDW_XMMM64_K1Z_XMM: Code = 2895 # type: ignore
"""
``VPMOVDW xmm1/m64 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 33 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVDW_XMMM128_K1Z_YMM: Code = 2896 # type: ignore
"""
``VPMOVDW xmm1/m128 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 33 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVDW_YMMM256_K1Z_ZMM: Code = 2897 # type: ignore
"""
``VPMOVDW ymm1/m256 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 33 /r``

``AVX512F``

``16/32/64-bit``
"""
PMOVZXWQ_XMM_XMMM32: Code = 2898 # type: ignore
"""
``PMOVZXWQ xmm1, xmm2/m32``

``66 0F 38 34 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMOVZXWQ_XMM_XMMM32: Code = 2899 # type: ignore
"""
``VPMOVZXWQ xmm1, xmm2/m32``

``VEX.128.66.0F38.WIG 34 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMOVZXWQ_YMM_XMMM64: Code = 2900 # type: ignore
"""
``VPMOVZXWQ ymm1, xmm2/m64``

``VEX.256.66.0F38.WIG 34 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMOVZXWQ_XMM_K1Z_XMMM32: Code = 2901 # type: ignore
"""
``VPMOVZXWQ xmm1 {k1}{z}, xmm2/m32``

``EVEX.128.66.0F38.WIG 34 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVZXWQ_YMM_K1Z_XMMM64: Code = 2902 # type: ignore
"""
``VPMOVZXWQ ymm1 {k1}{z}, xmm2/m64``

``EVEX.256.66.0F38.WIG 34 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVZXWQ_ZMM_K1Z_XMMM128: Code = 2903 # type: ignore
"""
``VPMOVZXWQ zmm1 {k1}{z}, xmm2/m128``

``EVEX.512.66.0F38.WIG 34 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVQW_XMMM32_K1Z_XMM: Code = 2904 # type: ignore
"""
``VPMOVQW xmm1/m32 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 34 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVQW_XMMM64_K1Z_YMM: Code = 2905 # type: ignore
"""
``VPMOVQW xmm1/m64 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 34 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVQW_XMMM128_K1Z_ZMM: Code = 2906 # type: ignore
"""
``VPMOVQW xmm1/m128 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 34 /r``

``AVX512F``

``16/32/64-bit``
"""
PMOVZXDQ_XMM_XMMM64: Code = 2907 # type: ignore
"""
``PMOVZXDQ xmm1, xmm2/m64``

``66 0F 38 35 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMOVZXDQ_XMM_XMMM64: Code = 2908 # type: ignore
"""
``VPMOVZXDQ xmm1, xmm2/m64``

``VEX.128.66.0F38.WIG 35 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMOVZXDQ_YMM_XMMM128: Code = 2909 # type: ignore
"""
``VPMOVZXDQ ymm1, xmm2/m128``

``VEX.256.66.0F38.WIG 35 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMOVZXDQ_XMM_K1Z_XMMM64: Code = 2910 # type: ignore
"""
``VPMOVZXDQ xmm1 {k1}{z}, xmm2/m64``

``EVEX.128.66.0F38.W0 35 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVZXDQ_YMM_K1Z_XMMM128: Code = 2911 # type: ignore
"""
``VPMOVZXDQ ymm1 {k1}{z}, xmm2/m128``

``EVEX.256.66.0F38.W0 35 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVZXDQ_ZMM_K1Z_YMMM256: Code = 2912 # type: ignore
"""
``VPMOVZXDQ zmm1 {k1}{z}, ymm2/m256``

``EVEX.512.66.0F38.W0 35 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVQD_XMMM64_K1Z_XMM: Code = 2913 # type: ignore
"""
``VPMOVQD xmm1/m64 {k1}{z}, xmm2``

``EVEX.128.F3.0F38.W0 35 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVQD_XMMM128_K1Z_YMM: Code = 2914 # type: ignore
"""
``VPMOVQD xmm1/m128 {k1}{z}, ymm2``

``EVEX.256.F3.0F38.W0 35 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVQD_YMMM256_K1Z_ZMM: Code = 2915 # type: ignore
"""
``VPMOVQD ymm1/m256 {k1}{z}, zmm2``

``EVEX.512.F3.0F38.W0 35 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VPERMD_YMM_YMM_YMMM256: Code = 2916 # type: ignore
"""
``VPERMD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 36 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPERMD_YMM_K1Z_YMM_YMMM256B32: Code = 2917 # type: ignore
"""
``VPERMD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 36 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 2918 # type: ignore
"""
``VPERMD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 36 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMQ_YMM_K1Z_YMM_YMMM256B64: Code = 2919 # type: ignore
"""
``VPERMQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 36 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 2920 # type: ignore
"""
``VPERMQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 36 /r``

``AVX512F``

``16/32/64-bit``
"""
PCMPGTQ_XMM_XMMM128: Code = 2921 # type: ignore
"""
``PCMPGTQ xmm1, xmm2/m128``

``66 0F 38 37 /r``

``SSE4.2``

``16/32/64-bit``
"""
VEX_VPCMPGTQ_XMM_XMM_XMMM128: Code = 2922 # type: ignore
"""
``VPCMPGTQ xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 37 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPCMPGTQ_YMM_YMM_YMMM256: Code = 2923 # type: ignore
"""
``VPCMPGTQ ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 37 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPCMPGTQ_KR_K1_XMM_XMMM128B64: Code = 2924 # type: ignore
"""
``VPCMPGTQ k1 {k2}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 37 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPGTQ_KR_K1_YMM_YMMM256B64: Code = 2925 # type: ignore
"""
``VPCMPGTQ k1 {k2}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 37 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPGTQ_KR_K1_ZMM_ZMMM512B64: Code = 2926 # type: ignore
"""
``VPCMPGTQ k1 {k2}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 37 /r``

``AVX512F``

``16/32/64-bit``
"""
PMINSB_XMM_XMMM128: Code = 2927 # type: ignore
"""
``PMINSB xmm1, xmm2/m128``

``66 0F 38 38 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMINSB_XMM_XMM_XMMM128: Code = 2928 # type: ignore
"""
``VPMINSB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 38 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMINSB_YMM_YMM_YMMM256: Code = 2929 # type: ignore
"""
``VPMINSB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 38 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMINSB_XMM_K1Z_XMM_XMMM128: Code = 2930 # type: ignore
"""
``VPMINSB xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.WIG 38 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMINSB_YMM_K1Z_YMM_YMMM256: Code = 2931 # type: ignore
"""
``VPMINSB ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.WIG 38 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMINSB_ZMM_K1Z_ZMM_ZMMM512: Code = 2932 # type: ignore
"""
``VPMINSB zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.WIG 38 /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMOVM2D_XMM_KR: Code = 2933 # type: ignore
"""
``VPMOVM2D xmm1, k1``

``EVEX.128.F3.0F38.W0 38 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VPMOVM2D_YMM_KR: Code = 2934 # type: ignore
"""
``VPMOVM2D ymm1, k1``

``EVEX.256.F3.0F38.W0 38 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VPMOVM2D_ZMM_KR: Code = 2935 # type: ignore
"""
``VPMOVM2D zmm1, k1``

``EVEX.512.F3.0F38.W0 38 /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VPMOVM2Q_XMM_KR: Code = 2936 # type: ignore
"""
``VPMOVM2Q xmm1, k1``

``EVEX.128.F3.0F38.W1 38 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VPMOVM2Q_YMM_KR: Code = 2937 # type: ignore
"""
``VPMOVM2Q ymm1, k1``

``EVEX.256.F3.0F38.W1 38 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VPMOVM2Q_ZMM_KR: Code = 2938 # type: ignore
"""
``VPMOVM2Q zmm1, k1``

``EVEX.512.F3.0F38.W1 38 /r``

``AVX512DQ``

``16/32/64-bit``
"""
PMINSD_XMM_XMMM128: Code = 2939 # type: ignore
"""
``PMINSD xmm1, xmm2/m128``

``66 0F 38 39 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMINSD_XMM_XMM_XMMM128: Code = 2940 # type: ignore
"""
``VPMINSD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 39 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMINSD_YMM_YMM_YMMM256: Code = 2941 # type: ignore
"""
``VPMINSD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 39 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMINSD_XMM_K1Z_XMM_XMMM128B32: Code = 2942 # type: ignore
"""
``VPMINSD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 39 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMINSD_YMM_K1Z_YMM_YMMM256B32: Code = 2943 # type: ignore
"""
``VPMINSD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 39 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMINSD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 2944 # type: ignore
"""
``VPMINSD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 39 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMINSQ_XMM_K1Z_XMM_XMMM128B64: Code = 2945 # type: ignore
"""
``VPMINSQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 39 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMINSQ_YMM_K1Z_YMM_YMMM256B64: Code = 2946 # type: ignore
"""
``VPMINSQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 39 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMINSQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 2947 # type: ignore
"""
``VPMINSQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 39 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMOVD2M_KR_XMM: Code = 2948 # type: ignore
"""
``VPMOVD2M k1, xmm1``

``EVEX.128.F3.0F38.W0 39 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VPMOVD2M_KR_YMM: Code = 2949 # type: ignore
"""
``VPMOVD2M k1, ymm1``

``EVEX.256.F3.0F38.W0 39 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VPMOVD2M_KR_ZMM: Code = 2950 # type: ignore
"""
``VPMOVD2M k1, zmm1``

``EVEX.512.F3.0F38.W0 39 /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VPMOVQ2M_KR_XMM: Code = 2951 # type: ignore
"""
``VPMOVQ2M k1, xmm1``

``EVEX.128.F3.0F38.W1 39 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VPMOVQ2M_KR_YMM: Code = 2952 # type: ignore
"""
``VPMOVQ2M k1, ymm1``

``EVEX.256.F3.0F38.W1 39 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VPMOVQ2M_KR_ZMM: Code = 2953 # type: ignore
"""
``VPMOVQ2M k1, zmm1``

``EVEX.512.F3.0F38.W1 39 /r``

``AVX512DQ``

``16/32/64-bit``
"""
PMINUW_XMM_XMMM128: Code = 2954 # type: ignore
"""
``PMINUW xmm1, xmm2/m128``

``66 0F 38 3A /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMINUW_XMM_XMM_XMMM128: Code = 2955 # type: ignore
"""
``VPMINUW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 3A /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMINUW_YMM_YMM_YMMM256: Code = 2956 # type: ignore
"""
``VPMINUW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 3A /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMINUW_XMM_K1Z_XMM_XMMM128: Code = 2957 # type: ignore
"""
``VPMINUW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.WIG 3A /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMINUW_YMM_K1Z_YMM_YMMM256: Code = 2958 # type: ignore
"""
``VPMINUW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.WIG 3A /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMINUW_ZMM_K1Z_ZMM_ZMMM512: Code = 2959 # type: ignore
"""
``VPMINUW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.WIG 3A /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPBROADCASTMW2D_XMM_KR: Code = 2960 # type: ignore
"""
``VPBROADCASTMW2D xmm1, k1``

``EVEX.128.F3.0F38.W0 3A /r``

``AVX512VL and AVX512CD``

``16/32/64-bit``
"""
EVEX_VPBROADCASTMW2D_YMM_KR: Code = 2961 # type: ignore
"""
``VPBROADCASTMW2D ymm1, k1``

``EVEX.256.F3.0F38.W0 3A /r``

``AVX512VL and AVX512CD``

``16/32/64-bit``
"""
EVEX_VPBROADCASTMW2D_ZMM_KR: Code = 2962 # type: ignore
"""
``VPBROADCASTMW2D zmm1, k1``

``EVEX.512.F3.0F38.W0 3A /r``

``AVX512CD``

``16/32/64-bit``
"""
PMINUD_XMM_XMMM128: Code = 2963 # type: ignore
"""
``PMINUD xmm1, xmm2/m128``

``66 0F 38 3B /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMINUD_XMM_XMM_XMMM128: Code = 2964 # type: ignore
"""
``VPMINUD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 3B /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMINUD_YMM_YMM_YMMM256: Code = 2965 # type: ignore
"""
``VPMINUD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 3B /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMINUD_XMM_K1Z_XMM_XMMM128B32: Code = 2966 # type: ignore
"""
``VPMINUD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 3B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMINUD_YMM_K1Z_YMM_YMMM256B32: Code = 2967 # type: ignore
"""
``VPMINUD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 3B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMINUD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 2968 # type: ignore
"""
``VPMINUD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 3B /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMINUQ_XMM_K1Z_XMM_XMMM128B64: Code = 2969 # type: ignore
"""
``VPMINUQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 3B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMINUQ_YMM_K1Z_YMM_YMMM256B64: Code = 2970 # type: ignore
"""
``VPMINUQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 3B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMINUQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 2971 # type: ignore
"""
``VPMINUQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 3B /r``

``AVX512F``

``16/32/64-bit``
"""
PMAXSB_XMM_XMMM128: Code = 2972 # type: ignore
"""
``PMAXSB xmm1, xmm2/m128``

``66 0F 38 3C /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMAXSB_XMM_XMM_XMMM128: Code = 2973 # type: ignore
"""
``VPMAXSB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 3C /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMAXSB_YMM_YMM_YMMM256: Code = 2974 # type: ignore
"""
``VPMAXSB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 3C /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMAXSB_XMM_K1Z_XMM_XMMM128: Code = 2975 # type: ignore
"""
``VPMAXSB xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.WIG 3C /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMAXSB_YMM_K1Z_YMM_YMMM256: Code = 2976 # type: ignore
"""
``VPMAXSB ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.WIG 3C /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMAXSB_ZMM_K1Z_ZMM_ZMMM512: Code = 2977 # type: ignore
"""
``VPMAXSB zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.WIG 3C /r``

``AVX512BW``

``16/32/64-bit``
"""
PMAXSD_XMM_XMMM128: Code = 2978 # type: ignore
"""
``PMAXSD xmm1, xmm2/m128``

``66 0F 38 3D /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMAXSD_XMM_XMM_XMMM128: Code = 2979 # type: ignore
"""
``VPMAXSD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 3D /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMAXSD_YMM_YMM_YMMM256: Code = 2980 # type: ignore
"""
``VPMAXSD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 3D /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMAXSD_XMM_K1Z_XMM_XMMM128B32: Code = 2981 # type: ignore
"""
``VPMAXSD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 3D /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMAXSD_YMM_K1Z_YMM_YMMM256B32: Code = 2982 # type: ignore
"""
``VPMAXSD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 3D /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMAXSD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 2983 # type: ignore
"""
``VPMAXSD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 3D /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMAXSQ_XMM_K1Z_XMM_XMMM128B64: Code = 2984 # type: ignore
"""
``VPMAXSQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 3D /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMAXSQ_YMM_K1Z_YMM_YMMM256B64: Code = 2985 # type: ignore
"""
``VPMAXSQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 3D /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMAXSQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 2986 # type: ignore
"""
``VPMAXSQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 3D /r``

``AVX512F``

``16/32/64-bit``
"""
PMAXUW_XMM_XMMM128: Code = 2987 # type: ignore
"""
``PMAXUW xmm1, xmm2/m128``

``66 0F 38 3E /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMAXUW_XMM_XMM_XMMM128: Code = 2988 # type: ignore
"""
``VPMAXUW xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 3E /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMAXUW_YMM_YMM_YMMM256: Code = 2989 # type: ignore
"""
``VPMAXUW ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 3E /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMAXUW_XMM_K1Z_XMM_XMMM128: Code = 2990 # type: ignore
"""
``VPMAXUW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.WIG 3E /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMAXUW_YMM_K1Z_YMM_YMMM256: Code = 2991 # type: ignore
"""
``VPMAXUW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.WIG 3E /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPMAXUW_ZMM_K1Z_ZMM_ZMMM512: Code = 2992 # type: ignore
"""
``VPMAXUW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.WIG 3E /r``

``AVX512BW``

``16/32/64-bit``
"""
PMAXUD_XMM_XMMM128: Code = 2993 # type: ignore
"""
``PMAXUD xmm1, xmm2/m128``

``66 0F 38 3F /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMAXUD_XMM_XMM_XMMM128: Code = 2994 # type: ignore
"""
``VPMAXUD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 3F /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMAXUD_YMM_YMM_YMMM256: Code = 2995 # type: ignore
"""
``VPMAXUD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 3F /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMAXUD_XMM_K1Z_XMM_XMMM128B32: Code = 2996 # type: ignore
"""
``VPMAXUD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 3F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMAXUD_YMM_K1Z_YMM_YMMM256B32: Code = 2997 # type: ignore
"""
``VPMAXUD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 3F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMAXUD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 2998 # type: ignore
"""
``VPMAXUD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 3F /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMAXUQ_XMM_K1Z_XMM_XMMM128B64: Code = 2999 # type: ignore
"""
``VPMAXUQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 3F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMAXUQ_YMM_K1Z_YMM_YMMM256B64: Code = 3000 # type: ignore
"""
``VPMAXUQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 3F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMAXUQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 3001 # type: ignore
"""
``VPMAXUQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 3F /r``

``AVX512F``

``16/32/64-bit``
"""
PMULLD_XMM_XMMM128: Code = 3002 # type: ignore
"""
``PMULLD xmm1, xmm2/m128``

``66 0F 38 40 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPMULLD_XMM_XMM_XMMM128: Code = 3003 # type: ignore
"""
``VPMULLD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG 40 /r``

``AVX``

``16/32/64-bit``
"""
VEX_VPMULLD_YMM_YMM_YMMM256: Code = 3004 # type: ignore
"""
``VPMULLD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG 40 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPMULLD_XMM_K1Z_XMM_XMMM128B32: Code = 3005 # type: ignore
"""
``VPMULLD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 40 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMULLD_YMM_K1Z_YMM_YMMM256B32: Code = 3006 # type: ignore
"""
``VPMULLD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 40 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPMULLD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3007 # type: ignore
"""
``VPMULLD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 40 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMULLQ_XMM_K1Z_XMM_XMMM128B64: Code = 3008 # type: ignore
"""
``VPMULLQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 40 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VPMULLQ_YMM_K1Z_YMM_YMMM256B64: Code = 3009 # type: ignore
"""
``VPMULLQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 40 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VPMULLQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 3010 # type: ignore
"""
``VPMULLQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 40 /r``

``AVX512DQ``

``16/32/64-bit``
"""
PHMINPOSUW_XMM_XMMM128: Code = 3011 # type: ignore
"""
``PHMINPOSUW xmm1, xmm2/m128``

``66 0F 38 41 /r``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPHMINPOSUW_XMM_XMMM128: Code = 3012 # type: ignore
"""
``VPHMINPOSUW xmm1, xmm2/m128``

``VEX.128.66.0F38.WIG 41 /r``

``AVX``

``16/32/64-bit``
"""
EVEX_VGETEXPPS_XMM_K1Z_XMMM128B32: Code = 3013 # type: ignore
"""
``VGETEXPPS xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.66.0F38.W0 42 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VGETEXPPS_YMM_K1Z_YMMM256B32: Code = 3014 # type: ignore
"""
``VGETEXPPS ymm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.66.0F38.W0 42 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VGETEXPPS_ZMM_K1Z_ZMMM512B32_SAE: Code = 3015 # type: ignore
"""
``VGETEXPPS zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}``

``EVEX.512.66.0F38.W0 42 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VGETEXPPD_XMM_K1Z_XMMM128B64: Code = 3016 # type: ignore
"""
``VGETEXPPD xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.66.0F38.W1 42 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VGETEXPPD_YMM_K1Z_YMMM256B64: Code = 3017 # type: ignore
"""
``VGETEXPPD ymm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.66.0F38.W1 42 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VGETEXPPD_ZMM_K1Z_ZMMM512B64_SAE: Code = 3018 # type: ignore
"""
``VGETEXPPD zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}``

``EVEX.512.66.0F38.W1 42 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VGETEXPSS_XMM_K1Z_XMM_XMMM32_SAE: Code = 3019 # type: ignore
"""
``VGETEXPSS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}``

``EVEX.LIG.66.0F38.W0 43 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VGETEXPSD_XMM_K1Z_XMM_XMMM64_SAE: Code = 3020 # type: ignore
"""
``VGETEXPSD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}``

``EVEX.LIG.66.0F38.W1 43 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPLZCNTD_XMM_K1Z_XMMM128B32: Code = 3021 # type: ignore
"""
``VPLZCNTD xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.66.0F38.W0 44 /r``

``AVX512VL and AVX512CD``

``16/32/64-bit``
"""
EVEX_VPLZCNTD_YMM_K1Z_YMMM256B32: Code = 3022 # type: ignore
"""
``VPLZCNTD ymm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.66.0F38.W0 44 /r``

``AVX512VL and AVX512CD``

``16/32/64-bit``
"""
EVEX_VPLZCNTD_ZMM_K1Z_ZMMM512B32: Code = 3023 # type: ignore
"""
``VPLZCNTD zmm1 {k1}{z}, zmm2/m512/m32bcst``

``EVEX.512.66.0F38.W0 44 /r``

``AVX512CD``

``16/32/64-bit``
"""
EVEX_VPLZCNTQ_XMM_K1Z_XMMM128B64: Code = 3024 # type: ignore
"""
``VPLZCNTQ xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.66.0F38.W1 44 /r``

``AVX512VL and AVX512CD``

``16/32/64-bit``
"""
EVEX_VPLZCNTQ_YMM_K1Z_YMMM256B64: Code = 3025 # type: ignore
"""
``VPLZCNTQ ymm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.66.0F38.W1 44 /r``

``AVX512VL and AVX512CD``

``16/32/64-bit``
"""
EVEX_VPLZCNTQ_ZMM_K1Z_ZMMM512B64: Code = 3026 # type: ignore
"""
``VPLZCNTQ zmm1 {k1}{z}, zmm2/m512/m64bcst``

``EVEX.512.66.0F38.W1 44 /r``

``AVX512CD``

``16/32/64-bit``
"""
VEX_VPSRLVD_XMM_XMM_XMMM128: Code = 3027 # type: ignore
"""
``VPSRLVD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 45 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPSRLVD_YMM_YMM_YMMM256: Code = 3028 # type: ignore
"""
``VPSRLVD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 45 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPSRLVQ_XMM_XMM_XMMM128: Code = 3029 # type: ignore
"""
``VPSRLVQ xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 45 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPSRLVQ_YMM_YMM_YMMM256: Code = 3030 # type: ignore
"""
``VPSRLVQ ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 45 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSRLVD_XMM_K1Z_XMM_XMMM128B32: Code = 3031 # type: ignore
"""
``VPSRLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 45 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRLVD_YMM_K1Z_YMM_YMMM256B32: Code = 3032 # type: ignore
"""
``VPSRLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 45 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRLVD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3033 # type: ignore
"""
``VPSRLVD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 45 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRLVQ_XMM_K1Z_XMM_XMMM128B64: Code = 3034 # type: ignore
"""
``VPSRLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 45 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRLVQ_YMM_K1Z_YMM_YMMM256B64: Code = 3035 # type: ignore
"""
``VPSRLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 45 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRLVQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 3036 # type: ignore
"""
``VPSRLVQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 45 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VPSRAVD_XMM_XMM_XMMM128: Code = 3037 # type: ignore
"""
``VPSRAVD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 46 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPSRAVD_YMM_YMM_YMMM256: Code = 3038 # type: ignore
"""
``VPSRAVD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 46 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSRAVD_XMM_K1Z_XMM_XMMM128B32: Code = 3039 # type: ignore
"""
``VPSRAVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 46 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRAVD_YMM_K1Z_YMM_YMMM256B32: Code = 3040 # type: ignore
"""
``VPSRAVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 46 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRAVD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3041 # type: ignore
"""
``VPSRAVD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 46 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRAVQ_XMM_K1Z_XMM_XMMM128B64: Code = 3042 # type: ignore
"""
``VPSRAVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 46 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRAVQ_YMM_K1Z_YMM_YMMM256B64: Code = 3043 # type: ignore
"""
``VPSRAVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 46 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSRAVQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 3044 # type: ignore
"""
``VPSRAVQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 46 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VPSLLVD_XMM_XMM_XMMM128: Code = 3045 # type: ignore
"""
``VPSLLVD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 47 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPSLLVD_YMM_YMM_YMMM256: Code = 3046 # type: ignore
"""
``VPSLLVD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 47 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPSLLVQ_XMM_XMM_XMMM128: Code = 3047 # type: ignore
"""
``VPSLLVQ xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 47 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPSLLVQ_YMM_YMM_YMMM256: Code = 3048 # type: ignore
"""
``VPSLLVQ ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 47 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSLLVD_XMM_K1Z_XMM_XMMM128B32: Code = 3049 # type: ignore
"""
``VPSLLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 47 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSLLVD_YMM_K1Z_YMM_YMMM256B32: Code = 3050 # type: ignore
"""
``VPSLLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 47 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSLLVD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3051 # type: ignore
"""
``VPSLLVD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 47 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPSLLVQ_XMM_K1Z_XMM_XMMM128B64: Code = 3052 # type: ignore
"""
``VPSLLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 47 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSLLVQ_YMM_K1Z_YMM_YMMM256B64: Code = 3053 # type: ignore
"""
``VPSLLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 47 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSLLVQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 3054 # type: ignore
"""
``VPSLLVQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 47 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VRCP14PS_XMM_K1Z_XMMM128B32: Code = 3055 # type: ignore
"""
``VRCP14PS xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.66.0F38.W0 4C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VRCP14PS_YMM_K1Z_YMMM256B32: Code = 3056 # type: ignore
"""
``VRCP14PS ymm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.66.0F38.W0 4C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VRCP14PS_ZMM_K1Z_ZMMM512B32: Code = 3057 # type: ignore
"""
``VRCP14PS zmm1 {k1}{z}, zmm2/m512/m32bcst``

``EVEX.512.66.0F38.W0 4C /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VRCP14PD_XMM_K1Z_XMMM128B64: Code = 3058 # type: ignore
"""
``VRCP14PD xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.66.0F38.W1 4C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VRCP14PD_YMM_K1Z_YMMM256B64: Code = 3059 # type: ignore
"""
``VRCP14PD ymm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.66.0F38.W1 4C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VRCP14PD_ZMM_K1Z_ZMMM512B64: Code = 3060 # type: ignore
"""
``VRCP14PD zmm1 {k1}{z}, zmm2/m512/m64bcst``

``EVEX.512.66.0F38.W1 4C /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VRCP14SS_XMM_K1Z_XMM_XMMM32: Code = 3061 # type: ignore
"""
``VRCP14SS xmm1 {k1}{z}, xmm2, xmm3/m32``

``EVEX.LIG.66.0F38.W0 4D /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VRCP14SD_XMM_K1Z_XMM_XMMM64: Code = 3062 # type: ignore
"""
``VRCP14SD xmm1 {k1}{z}, xmm2, xmm3/m64``

``EVEX.LIG.66.0F38.W1 4D /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VRSQRT14PS_XMM_K1Z_XMMM128B32: Code = 3063 # type: ignore
"""
``VRSQRT14PS xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.66.0F38.W0 4E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VRSQRT14PS_YMM_K1Z_YMMM256B32: Code = 3064 # type: ignore
"""
``VRSQRT14PS ymm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.66.0F38.W0 4E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VRSQRT14PS_ZMM_K1Z_ZMMM512B32: Code = 3065 # type: ignore
"""
``VRSQRT14PS zmm1 {k1}{z}, zmm2/m512/m32bcst``

``EVEX.512.66.0F38.W0 4E /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VRSQRT14PD_XMM_K1Z_XMMM128B64: Code = 3066 # type: ignore
"""
``VRSQRT14PD xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.66.0F38.W1 4E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VRSQRT14PD_YMM_K1Z_YMMM256B64: Code = 3067 # type: ignore
"""
``VRSQRT14PD ymm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.66.0F38.W1 4E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VRSQRT14PD_ZMM_K1Z_ZMMM512B64: Code = 3068 # type: ignore
"""
``VRSQRT14PD zmm1 {k1}{z}, zmm2/m512/m64bcst``

``EVEX.512.66.0F38.W1 4E /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VRSQRT14SS_XMM_K1Z_XMM_XMMM32: Code = 3069 # type: ignore
"""
``VRSQRT14SS xmm1 {k1}{z}, xmm2, xmm3/m32``

``EVEX.LIG.66.0F38.W0 4F /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VRSQRT14SD_XMM_K1Z_XMM_XMMM64: Code = 3070 # type: ignore
"""
``VRSQRT14SD xmm1 {k1}{z}, xmm2, xmm3/m64``

``EVEX.LIG.66.0F38.W1 4F /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPDPBUSD_XMM_K1Z_XMM_XMMM128B32: Code = 3071 # type: ignore
"""
``VPDPBUSD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 50 /r``

``AVX512VL and AVX512_VNNI``

``16/32/64-bit``
"""
EVEX_VPDPBUSD_YMM_K1Z_YMM_YMMM256B32: Code = 3072 # type: ignore
"""
``VPDPBUSD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 50 /r``

``AVX512VL and AVX512_VNNI``

``16/32/64-bit``
"""
EVEX_VPDPBUSD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3073 # type: ignore
"""
``VPDPBUSD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 50 /r``

``AVX512_VNNI``

``16/32/64-bit``
"""
EVEX_VPDPBUSDS_XMM_K1Z_XMM_XMMM128B32: Code = 3074 # type: ignore
"""
``VPDPBUSDS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 51 /r``

``AVX512VL and AVX512_VNNI``

``16/32/64-bit``
"""
EVEX_VPDPBUSDS_YMM_K1Z_YMM_YMMM256B32: Code = 3075 # type: ignore
"""
``VPDPBUSDS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 51 /r``

``AVX512VL and AVX512_VNNI``

``16/32/64-bit``
"""
EVEX_VPDPBUSDS_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3076 # type: ignore
"""
``VPDPBUSDS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 51 /r``

``AVX512_VNNI``

``16/32/64-bit``
"""
EVEX_VPDPWSSD_XMM_K1Z_XMM_XMMM128B32: Code = 3077 # type: ignore
"""
``VPDPWSSD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 52 /r``

``AVX512VL and AVX512_VNNI``

``16/32/64-bit``
"""
EVEX_VPDPWSSD_YMM_K1Z_YMM_YMMM256B32: Code = 3078 # type: ignore
"""
``VPDPWSSD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 52 /r``

``AVX512VL and AVX512_VNNI``

``16/32/64-bit``
"""
EVEX_VPDPWSSD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3079 # type: ignore
"""
``VPDPWSSD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 52 /r``

``AVX512_VNNI``

``16/32/64-bit``
"""
EVEX_VDPBF16PS_XMM_K1Z_XMM_XMMM128B32: Code = 3080 # type: ignore
"""
``VDPBF16PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.F3.0F38.W0 52 /r``

``AVX512VL and AVX512_BF16``

``16/32/64-bit``
"""
EVEX_VDPBF16PS_YMM_K1Z_YMM_YMMM256B32: Code = 3081 # type: ignore
"""
``VDPBF16PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.F3.0F38.W0 52 /r``

``AVX512VL and AVX512_BF16``

``16/32/64-bit``
"""
EVEX_VDPBF16PS_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3082 # type: ignore
"""
``VDPBF16PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.F3.0F38.W0 52 /r``

``AVX512F and AVX512_BF16``

``16/32/64-bit``
"""
EVEX_VP4DPWSSD_ZMM_K1Z_ZMMP3_M128: Code = 3083 # type: ignore
"""
``VP4DPWSSD zmm1 {k1}{z}, zmm2+3, m128``

``EVEX.512.F2.0F38.W0 52 /r``

``AVX512_4VNNIW``

``16/32/64-bit``
"""
EVEX_VPDPWSSDS_XMM_K1Z_XMM_XMMM128B32: Code = 3084 # type: ignore
"""
``VPDPWSSDS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 53 /r``

``AVX512VL and AVX512_VNNI``

``16/32/64-bit``
"""
EVEX_VPDPWSSDS_YMM_K1Z_YMM_YMMM256B32: Code = 3085 # type: ignore
"""
``VPDPWSSDS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 53 /r``

``AVX512VL and AVX512_VNNI``

``16/32/64-bit``
"""
EVEX_VPDPWSSDS_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3086 # type: ignore
"""
``VPDPWSSDS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 53 /r``

``AVX512_VNNI``

``16/32/64-bit``
"""
EVEX_VP4DPWSSDS_ZMM_K1Z_ZMMP3_M128: Code = 3087 # type: ignore
"""
``VP4DPWSSDS zmm1 {k1}{z}, zmm2+3, m128``

``EVEX.512.F2.0F38.W0 53 /r``

``AVX512_4VNNIW``

``16/32/64-bit``
"""
EVEX_VPOPCNTB_XMM_K1Z_XMMM128: Code = 3088 # type: ignore
"""
``VPOPCNTB xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.66.0F38.W0 54 /r``

``AVX512VL and AVX512_BITALG``

``16/32/64-bit``
"""
EVEX_VPOPCNTB_YMM_K1Z_YMMM256: Code = 3089 # type: ignore
"""
``VPOPCNTB ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.66.0F38.W0 54 /r``

``AVX512VL and AVX512_BITALG``

``16/32/64-bit``
"""
EVEX_VPOPCNTB_ZMM_K1Z_ZMMM512: Code = 3090 # type: ignore
"""
``VPOPCNTB zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.66.0F38.W0 54 /r``

``AVX512_BITALG``

``16/32/64-bit``
"""
EVEX_VPOPCNTW_XMM_K1Z_XMMM128: Code = 3091 # type: ignore
"""
``VPOPCNTW xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.66.0F38.W1 54 /r``

``AVX512VL and AVX512_BITALG``

``16/32/64-bit``
"""
EVEX_VPOPCNTW_YMM_K1Z_YMMM256: Code = 3092 # type: ignore
"""
``VPOPCNTW ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.66.0F38.W1 54 /r``

``AVX512VL and AVX512_BITALG``

``16/32/64-bit``
"""
EVEX_VPOPCNTW_ZMM_K1Z_ZMMM512: Code = 3093 # type: ignore
"""
``VPOPCNTW zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.66.0F38.W1 54 /r``

``AVX512_BITALG``

``16/32/64-bit``
"""
EVEX_VPOPCNTD_XMM_K1Z_XMMM128B32: Code = 3094 # type: ignore
"""
``VPOPCNTD xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.66.0F38.W0 55 /r``

``AVX512VL and AVX512_VPOPCNTDQ``

``16/32/64-bit``
"""
EVEX_VPOPCNTD_YMM_K1Z_YMMM256B32: Code = 3095 # type: ignore
"""
``VPOPCNTD ymm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.66.0F38.W0 55 /r``

``AVX512VL and AVX512_VPOPCNTDQ``

``16/32/64-bit``
"""
EVEX_VPOPCNTD_ZMM_K1Z_ZMMM512B32: Code = 3096 # type: ignore
"""
``VPOPCNTD zmm1 {k1}{z}, zmm2/m512/m32bcst``

``EVEX.512.66.0F38.W0 55 /r``

``AVX512_VPOPCNTDQ``

``16/32/64-bit``
"""
EVEX_VPOPCNTQ_XMM_K1Z_XMMM128B64: Code = 3097 # type: ignore
"""
``VPOPCNTQ xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.66.0F38.W1 55 /r``

``AVX512VL and AVX512_VPOPCNTDQ``

``16/32/64-bit``
"""
EVEX_VPOPCNTQ_YMM_K1Z_YMMM256B64: Code = 3098 # type: ignore
"""
``VPOPCNTQ ymm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.66.0F38.W1 55 /r``

``AVX512VL and AVX512_VPOPCNTDQ``

``16/32/64-bit``
"""
EVEX_VPOPCNTQ_ZMM_K1Z_ZMMM512B64: Code = 3099 # type: ignore
"""
``VPOPCNTQ zmm1 {k1}{z}, zmm2/m512/m64bcst``

``EVEX.512.66.0F38.W1 55 /r``

``AVX512_VPOPCNTDQ``

``16/32/64-bit``
"""
VEX_VPBROADCASTD_XMM_XMMM32: Code = 3100 # type: ignore
"""
``VPBROADCASTD xmm1, xmm2/m32``

``VEX.128.66.0F38.W0 58 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPBROADCASTD_YMM_XMMM32: Code = 3101 # type: ignore
"""
``VPBROADCASTD ymm1, xmm2/m32``

``VEX.256.66.0F38.W0 58 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPBROADCASTD_XMM_K1Z_XMMM32: Code = 3102 # type: ignore
"""
``VPBROADCASTD xmm1 {k1}{z}, xmm2/m32``

``EVEX.128.66.0F38.W0 58 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPBROADCASTD_YMM_K1Z_XMMM32: Code = 3103 # type: ignore
"""
``VPBROADCASTD ymm1 {k1}{z}, xmm2/m32``

``EVEX.256.66.0F38.W0 58 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPBROADCASTD_ZMM_K1Z_XMMM32: Code = 3104 # type: ignore
"""
``VPBROADCASTD zmm1 {k1}{z}, xmm2/m32``

``EVEX.512.66.0F38.W0 58 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VPBROADCASTQ_XMM_XMMM64: Code = 3105 # type: ignore
"""
``VPBROADCASTQ xmm1, xmm2/m64``

``VEX.128.66.0F38.W0 59 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPBROADCASTQ_YMM_XMMM64: Code = 3106 # type: ignore
"""
``VPBROADCASTQ ymm1, xmm2/m64``

``VEX.256.66.0F38.W0 59 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VBROADCASTI32X2_XMM_K1Z_XMMM64: Code = 3107 # type: ignore
"""
``VBROADCASTI32X2 xmm1 {k1}{z}, xmm2/m64``

``EVEX.128.66.0F38.W0 59 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VBROADCASTI32X2_YMM_K1Z_XMMM64: Code = 3108 # type: ignore
"""
``VBROADCASTI32X2 ymm1 {k1}{z}, xmm2/m64``

``EVEX.256.66.0F38.W0 59 /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VBROADCASTI32X2_ZMM_K1Z_XMMM64: Code = 3109 # type: ignore
"""
``VBROADCASTI32X2 zmm1 {k1}{z}, xmm2/m64``

``EVEX.512.66.0F38.W0 59 /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VPBROADCASTQ_XMM_K1Z_XMMM64: Code = 3110 # type: ignore
"""
``VPBROADCASTQ xmm1 {k1}{z}, xmm2/m64``

``EVEX.128.66.0F38.W1 59 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPBROADCASTQ_YMM_K1Z_XMMM64: Code = 3111 # type: ignore
"""
``VPBROADCASTQ ymm1 {k1}{z}, xmm2/m64``

``EVEX.256.66.0F38.W1 59 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPBROADCASTQ_ZMM_K1Z_XMMM64: Code = 3112 # type: ignore
"""
``VPBROADCASTQ zmm1 {k1}{z}, xmm2/m64``

``EVEX.512.66.0F38.W1 59 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VBROADCASTI128_YMM_M128: Code = 3113 # type: ignore
"""
``VBROADCASTI128 ymm1, m128``

``VEX.256.66.0F38.W0 5A /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VBROADCASTI32X4_YMM_K1Z_M128: Code = 3114 # type: ignore
"""
``VBROADCASTI32X4 ymm1 {k1}{z}, m128``

``EVEX.256.66.0F38.W0 5A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VBROADCASTI32X4_ZMM_K1Z_M128: Code = 3115 # type: ignore
"""
``VBROADCASTI32X4 zmm1 {k1}{z}, m128``

``EVEX.512.66.0F38.W0 5A /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VBROADCASTI64X2_YMM_K1Z_M128: Code = 3116 # type: ignore
"""
``VBROADCASTI64X2 ymm1 {k1}{z}, m128``

``EVEX.256.66.0F38.W1 5A /r``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VBROADCASTI64X2_ZMM_K1Z_M128: Code = 3117 # type: ignore
"""
``VBROADCASTI64X2 zmm1 {k1}{z}, m128``

``EVEX.512.66.0F38.W1 5A /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VBROADCASTI32X8_ZMM_K1Z_M256: Code = 3118 # type: ignore
"""
``VBROADCASTI32X8 zmm1 {k1}{z}, m256``

``EVEX.512.66.0F38.W0 5B /r``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VBROADCASTI64X4_ZMM_K1Z_M256: Code = 3119 # type: ignore
"""
``VBROADCASTI64X4 zmm1 {k1}{z}, m256``

``EVEX.512.66.0F38.W1 5B /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPEXPANDB_XMM_K1Z_XMMM128: Code = 3120 # type: ignore
"""
``VPEXPANDB xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.66.0F38.W0 62 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPEXPANDB_YMM_K1Z_YMMM256: Code = 3121 # type: ignore
"""
``VPEXPANDB ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.66.0F38.W0 62 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPEXPANDB_ZMM_K1Z_ZMMM512: Code = 3122 # type: ignore
"""
``VPEXPANDB zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.66.0F38.W0 62 /r``

``AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPEXPANDW_XMM_K1Z_XMMM128: Code = 3123 # type: ignore
"""
``VPEXPANDW xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.66.0F38.W1 62 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPEXPANDW_YMM_K1Z_YMMM256: Code = 3124 # type: ignore
"""
``VPEXPANDW ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.66.0F38.W1 62 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPEXPANDW_ZMM_K1Z_ZMMM512: Code = 3125 # type: ignore
"""
``VPEXPANDW zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.66.0F38.W1 62 /r``

``AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPCOMPRESSB_XMMM128_K1Z_XMM: Code = 3126 # type: ignore
"""
``VPCOMPRESSB xmm1/m128 {k1}{z}, xmm2``

``EVEX.128.66.0F38.W0 63 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPCOMPRESSB_YMMM256_K1Z_YMM: Code = 3127 # type: ignore
"""
``VPCOMPRESSB ymm1/m256 {k1}{z}, ymm2``

``EVEX.256.66.0F38.W0 63 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPCOMPRESSB_ZMMM512_K1Z_ZMM: Code = 3128 # type: ignore
"""
``VPCOMPRESSB zmm1/m512 {k1}{z}, zmm2``

``EVEX.512.66.0F38.W0 63 /r``

``AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPCOMPRESSW_XMMM128_K1Z_XMM: Code = 3129 # type: ignore
"""
``VPCOMPRESSW xmm1/m128 {k1}{z}, xmm2``

``EVEX.128.66.0F38.W1 63 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPCOMPRESSW_YMMM256_K1Z_YMM: Code = 3130 # type: ignore
"""
``VPCOMPRESSW ymm1/m256 {k1}{z}, ymm2``

``EVEX.256.66.0F38.W1 63 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPCOMPRESSW_ZMMM512_K1Z_ZMM: Code = 3131 # type: ignore
"""
``VPCOMPRESSW zmm1/m512 {k1}{z}, zmm2``

``EVEX.512.66.0F38.W1 63 /r``

``AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPBLENDMD_XMM_K1Z_XMM_XMMM128B32: Code = 3132 # type: ignore
"""
``VPBLENDMD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 64 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPBLENDMD_YMM_K1Z_YMM_YMMM256B32: Code = 3133 # type: ignore
"""
``VPBLENDMD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 64 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPBLENDMD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3134 # type: ignore
"""
``VPBLENDMD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 64 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPBLENDMQ_XMM_K1Z_XMM_XMMM128B64: Code = 3135 # type: ignore
"""
``VPBLENDMQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 64 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPBLENDMQ_YMM_K1Z_YMM_YMMM256B64: Code = 3136 # type: ignore
"""
``VPBLENDMQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 64 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPBLENDMQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 3137 # type: ignore
"""
``VPBLENDMQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 64 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VBLENDMPS_XMM_K1Z_XMM_XMMM128B32: Code = 3138 # type: ignore
"""
``VBLENDMPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 65 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VBLENDMPS_YMM_K1Z_YMM_YMMM256B32: Code = 3139 # type: ignore
"""
``VBLENDMPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 65 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VBLENDMPS_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3140 # type: ignore
"""
``VBLENDMPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 65 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VBLENDMPD_XMM_K1Z_XMM_XMMM128B64: Code = 3141 # type: ignore
"""
``VBLENDMPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 65 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VBLENDMPD_YMM_K1Z_YMM_YMMM256B64: Code = 3142 # type: ignore
"""
``VBLENDMPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 65 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VBLENDMPD_ZMM_K1Z_ZMM_ZMMM512B64: Code = 3143 # type: ignore
"""
``VBLENDMPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 65 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPBLENDMB_XMM_K1Z_XMM_XMMM128: Code = 3144 # type: ignore
"""
``VPBLENDMB xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.W0 66 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPBLENDMB_YMM_K1Z_YMM_YMMM256: Code = 3145 # type: ignore
"""
``VPBLENDMB ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.W0 66 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPBLENDMB_ZMM_K1Z_ZMM_ZMMM512: Code = 3146 # type: ignore
"""
``VPBLENDMB zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.W0 66 /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPBLENDMW_XMM_K1Z_XMM_XMMM128: Code = 3147 # type: ignore
"""
``VPBLENDMW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.W1 66 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPBLENDMW_YMM_K1Z_YMM_YMMM256: Code = 3148 # type: ignore
"""
``VPBLENDMW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.W1 66 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPBLENDMW_ZMM_K1Z_ZMM_ZMMM512: Code = 3149 # type: ignore
"""
``VPBLENDMW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.W1 66 /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VP2INTERSECTD_KP1_XMM_XMMM128B32: Code = 3150 # type: ignore
"""
``VP2INTERSECTD k1+1, xmm2, xmm3/m128/m32bcst``

``EVEX.128.F2.0F38.W0 68 /r``

``AVX512VL and AVX512_VP2INTERSECT``

``16/32/64-bit``
"""
EVEX_VP2INTERSECTD_KP1_YMM_YMMM256B32: Code = 3151 # type: ignore
"""
``VP2INTERSECTD k1+1, ymm2, ymm3/m256/m32bcst``

``EVEX.256.F2.0F38.W0 68 /r``

``AVX512VL and AVX512_VP2INTERSECT``

``16/32/64-bit``
"""
EVEX_VP2INTERSECTD_KP1_ZMM_ZMMM512B32: Code = 3152 # type: ignore
"""
``VP2INTERSECTD k1+1, zmm2, zmm3/m512/m32bcst``

``EVEX.512.F2.0F38.W0 68 /r``

``AVX512F and AVX512_VP2INTERSECT``

``16/32/64-bit``
"""
EVEX_VP2INTERSECTQ_KP1_XMM_XMMM128B64: Code = 3153 # type: ignore
"""
``VP2INTERSECTQ k1+1, xmm2, xmm3/m128/m64bcst``

``EVEX.128.F2.0F38.W1 68 /r``

``AVX512VL and AVX512_VP2INTERSECT``

``16/32/64-bit``
"""
EVEX_VP2INTERSECTQ_KP1_YMM_YMMM256B64: Code = 3154 # type: ignore
"""
``VP2INTERSECTQ k1+1, ymm2, ymm3/m256/m64bcst``

``EVEX.256.F2.0F38.W1 68 /r``

``AVX512VL and AVX512_VP2INTERSECT``

``16/32/64-bit``
"""
EVEX_VP2INTERSECTQ_KP1_ZMM_ZMMM512B64: Code = 3155 # type: ignore
"""
``VP2INTERSECTQ k1+1, zmm2, zmm3/m512/m64bcst``

``EVEX.512.F2.0F38.W1 68 /r``

``AVX512F and AVX512_VP2INTERSECT``

``16/32/64-bit``
"""
EVEX_VPSHLDVW_XMM_K1Z_XMM_XMMM128: Code = 3156 # type: ignore
"""
``VPSHLDVW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.W1 70 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHLDVW_YMM_K1Z_YMM_YMMM256: Code = 3157 # type: ignore
"""
``VPSHLDVW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.W1 70 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHLDVW_ZMM_K1Z_ZMM_ZMMM512: Code = 3158 # type: ignore
"""
``VPSHLDVW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.W1 70 /r``

``AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHLDVD_XMM_K1Z_XMM_XMMM128B32: Code = 3159 # type: ignore
"""
``VPSHLDVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 71 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHLDVD_YMM_K1Z_YMM_YMMM256B32: Code = 3160 # type: ignore
"""
``VPSHLDVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 71 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHLDVD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3161 # type: ignore
"""
``VPSHLDVD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 71 /r``

``AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHLDVQ_XMM_K1Z_XMM_XMMM128B64: Code = 3162 # type: ignore
"""
``VPSHLDVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 71 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHLDVQ_YMM_K1Z_YMM_YMMM256B64: Code = 3163 # type: ignore
"""
``VPSHLDVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 71 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHLDVQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 3164 # type: ignore
"""
``VPSHLDVQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 71 /r``

``AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHRDVW_XMM_K1Z_XMM_XMMM128: Code = 3165 # type: ignore
"""
``VPSHRDVW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.W1 72 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHRDVW_YMM_K1Z_YMM_YMMM256: Code = 3166 # type: ignore
"""
``VPSHRDVW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.W1 72 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHRDVW_ZMM_K1Z_ZMM_ZMMM512: Code = 3167 # type: ignore
"""
``VPSHRDVW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.W1 72 /r``

``AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VCVTNEPS2BF16_XMM_K1Z_XMMM128B32: Code = 3168 # type: ignore
"""
``VCVTNEPS2BF16 xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.F3.0F38.W0 72 /r``

``AVX512VL and AVX512_BF16``

``16/32/64-bit``
"""
EVEX_VCVTNEPS2BF16_XMM_K1Z_YMMM256B32: Code = 3169 # type: ignore
"""
``VCVTNEPS2BF16 xmm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.F3.0F38.W0 72 /r``

``AVX512VL and AVX512_BF16``

``16/32/64-bit``
"""
EVEX_VCVTNEPS2BF16_YMM_K1Z_ZMMM512B32: Code = 3170 # type: ignore
"""
``VCVTNEPS2BF16 ymm1 {k1}{z}, zmm2/m512/m32bcst``

``EVEX.512.F3.0F38.W0 72 /r``

``AVX512F and AVX512_BF16``

``16/32/64-bit``
"""
EVEX_VCVTNE2PS2BF16_XMM_K1Z_XMM_XMMM128B32: Code = 3171 # type: ignore
"""
``VCVTNE2PS2BF16 xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.F2.0F38.W0 72 /r``

``AVX512VL and AVX512_BF16``

``16/32/64-bit``
"""
EVEX_VCVTNE2PS2BF16_YMM_K1Z_YMM_YMMM256B32: Code = 3172 # type: ignore
"""
``VCVTNE2PS2BF16 ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.F2.0F38.W0 72 /r``

``AVX512VL and AVX512_BF16``

``16/32/64-bit``
"""
EVEX_VCVTNE2PS2BF16_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3173 # type: ignore
"""
``VCVTNE2PS2BF16 zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.F2.0F38.W0 72 /r``

``AVX512F and AVX512_BF16``

``16/32/64-bit``
"""
EVEX_VPSHRDVD_XMM_K1Z_XMM_XMMM128B32: Code = 3174 # type: ignore
"""
``VPSHRDVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 73 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHRDVD_YMM_K1Z_YMM_YMMM256B32: Code = 3175 # type: ignore
"""
``VPSHRDVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 73 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHRDVD_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3176 # type: ignore
"""
``VPSHRDVD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 73 /r``

``AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHRDVQ_XMM_K1Z_XMM_XMMM128B64: Code = 3177 # type: ignore
"""
``VPSHRDVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 73 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHRDVQ_YMM_K1Z_YMM_YMMM256B64: Code = 3178 # type: ignore
"""
``VPSHRDVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 73 /r``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHRDVQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 3179 # type: ignore
"""
``VPSHRDVQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 73 /r``

``AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPERMI2B_XMM_K1Z_XMM_XMMM128: Code = 3180 # type: ignore
"""
``VPERMI2B xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.W0 75 /r``

``AVX512VL and AVX512_VBMI``

``16/32/64-bit``
"""
EVEX_VPERMI2B_YMM_K1Z_YMM_YMMM256: Code = 3181 # type: ignore
"""
``VPERMI2B ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.W0 75 /r``

``AVX512VL and AVX512_VBMI``

``16/32/64-bit``
"""
EVEX_VPERMI2B_ZMM_K1Z_ZMM_ZMMM512: Code = 3182 # type: ignore
"""
``VPERMI2B zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.W0 75 /r``

``AVX512_VBMI``

``16/32/64-bit``
"""
EVEX_VPERMI2W_XMM_K1Z_XMM_XMMM128: Code = 3183 # type: ignore
"""
``VPERMI2W xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.W1 75 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPERMI2W_YMM_K1Z_YMM_YMMM256: Code = 3184 # type: ignore
"""
``VPERMI2W ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.W1 75 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPERMI2W_ZMM_K1Z_ZMM_ZMMM512: Code = 3185 # type: ignore
"""
``VPERMI2W zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.W1 75 /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPERMI2D_XMM_K1Z_XMM_XMMM128B32: Code = 3186 # type: ignore
"""
``VPERMI2D xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 76 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMI2D_YMM_K1Z_YMM_YMMM256B32: Code = 3187 # type: ignore
"""
``VPERMI2D ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 76 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMI2D_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3188 # type: ignore
"""
``VPERMI2D zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 76 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMI2Q_XMM_K1Z_XMM_XMMM128B64: Code = 3189 # type: ignore
"""
``VPERMI2Q xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 76 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMI2Q_YMM_K1Z_YMM_YMMM256B64: Code = 3190 # type: ignore
"""
``VPERMI2Q ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 76 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMI2Q_ZMM_K1Z_ZMM_ZMMM512B64: Code = 3191 # type: ignore
"""
``VPERMI2Q zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 76 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMI2PS_XMM_K1Z_XMM_XMMM128B32: Code = 3192 # type: ignore
"""
``VPERMI2PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 77 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMI2PS_YMM_K1Z_YMM_YMMM256B32: Code = 3193 # type: ignore
"""
``VPERMI2PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 77 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMI2PS_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3194 # type: ignore
"""
``VPERMI2PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 77 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMI2PD_XMM_K1Z_XMM_XMMM128B64: Code = 3195 # type: ignore
"""
``VPERMI2PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 77 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMI2PD_YMM_K1Z_YMM_YMMM256B64: Code = 3196 # type: ignore
"""
``VPERMI2PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 77 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMI2PD_ZMM_K1Z_ZMM_ZMMM512B64: Code = 3197 # type: ignore
"""
``VPERMI2PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 77 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VPBROADCASTB_XMM_XMMM8: Code = 3198 # type: ignore
"""
``VPBROADCASTB xmm1, xmm2/m8``

``VEX.128.66.0F38.W0 78 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPBROADCASTB_YMM_XMMM8: Code = 3199 # type: ignore
"""
``VPBROADCASTB ymm1, xmm2/m8``

``VEX.256.66.0F38.W0 78 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPBROADCASTB_XMM_K1Z_XMMM8: Code = 3200 # type: ignore
"""
``VPBROADCASTB xmm1 {k1}{z}, xmm2/m8``

``EVEX.128.66.0F38.W0 78 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPBROADCASTB_YMM_K1Z_XMMM8: Code = 3201 # type: ignore
"""
``VPBROADCASTB ymm1 {k1}{z}, xmm2/m8``

``EVEX.256.66.0F38.W0 78 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPBROADCASTB_ZMM_K1Z_XMMM8: Code = 3202 # type: ignore
"""
``VPBROADCASTB zmm1 {k1}{z}, xmm2/m8``

``EVEX.512.66.0F38.W0 78 /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_VPBROADCASTW_XMM_XMMM16: Code = 3203 # type: ignore
"""
``VPBROADCASTW xmm1, xmm2/m16``

``VEX.128.66.0F38.W0 79 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPBROADCASTW_YMM_XMMM16: Code = 3204 # type: ignore
"""
``VPBROADCASTW ymm1, xmm2/m16``

``VEX.256.66.0F38.W0 79 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPBROADCASTW_XMM_K1Z_XMMM16: Code = 3205 # type: ignore
"""
``VPBROADCASTW xmm1 {k1}{z}, xmm2/m16``

``EVEX.128.66.0F38.W0 79 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPBROADCASTW_YMM_K1Z_XMMM16: Code = 3206 # type: ignore
"""
``VPBROADCASTW ymm1 {k1}{z}, xmm2/m16``

``EVEX.256.66.0F38.W0 79 /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPBROADCASTW_ZMM_K1Z_XMMM16: Code = 3207 # type: ignore
"""
``VPBROADCASTW zmm1 {k1}{z}, xmm2/m16``

``EVEX.512.66.0F38.W0 79 /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPBROADCASTB_XMM_K1Z_R32: Code = 3208 # type: ignore
"""
``VPBROADCASTB xmm1 {k1}{z}, r32``

``EVEX.128.66.0F38.W0 7A /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPBROADCASTB_YMM_K1Z_R32: Code = 3209 # type: ignore
"""
``VPBROADCASTB ymm1 {k1}{z}, r32``

``EVEX.256.66.0F38.W0 7A /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPBROADCASTB_ZMM_K1Z_R32: Code = 3210 # type: ignore
"""
``VPBROADCASTB zmm1 {k1}{z}, r32``

``EVEX.512.66.0F38.W0 7A /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPBROADCASTW_XMM_K1Z_R32: Code = 3211 # type: ignore
"""
``VPBROADCASTW xmm1 {k1}{z}, r32``

``EVEX.128.66.0F38.W0 7B /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPBROADCASTW_YMM_K1Z_R32: Code = 3212 # type: ignore
"""
``VPBROADCASTW ymm1 {k1}{z}, r32``

``EVEX.256.66.0F38.W0 7B /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPBROADCASTW_ZMM_K1Z_R32: Code = 3213 # type: ignore
"""
``VPBROADCASTW zmm1 {k1}{z}, r32``

``EVEX.512.66.0F38.W0 7B /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPBROADCASTD_XMM_K1Z_R32: Code = 3214 # type: ignore
"""
``VPBROADCASTD xmm1 {k1}{z}, r32``

``EVEX.128.66.0F38.W0 7C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPBROADCASTD_YMM_K1Z_R32: Code = 3215 # type: ignore
"""
``VPBROADCASTD ymm1 {k1}{z}, r32``

``EVEX.256.66.0F38.W0 7C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPBROADCASTD_ZMM_K1Z_R32: Code = 3216 # type: ignore
"""
``VPBROADCASTD zmm1 {k1}{z}, r32``

``EVEX.512.66.0F38.W0 7C /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPBROADCASTQ_XMM_K1Z_R64: Code = 3217 # type: ignore
"""
``VPBROADCASTQ xmm1 {k1}{z}, r64``

``EVEX.128.66.0F38.W1 7C /r``

``AVX512VL and AVX512F``

``64-bit``
"""
EVEX_VPBROADCASTQ_YMM_K1Z_R64: Code = 3218 # type: ignore
"""
``VPBROADCASTQ ymm1 {k1}{z}, r64``

``EVEX.256.66.0F38.W1 7C /r``

``AVX512VL and AVX512F``

``64-bit``
"""
EVEX_VPBROADCASTQ_ZMM_K1Z_R64: Code = 3219 # type: ignore
"""
``VPBROADCASTQ zmm1 {k1}{z}, r64``

``EVEX.512.66.0F38.W1 7C /r``

``AVX512F``

``64-bit``
"""
EVEX_VPERMT2B_XMM_K1Z_XMM_XMMM128: Code = 3220 # type: ignore
"""
``VPERMT2B xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.W0 7D /r``

``AVX512VL and AVX512_VBMI``

``16/32/64-bit``
"""
EVEX_VPERMT2B_YMM_K1Z_YMM_YMMM256: Code = 3221 # type: ignore
"""
``VPERMT2B ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.W0 7D /r``

``AVX512VL and AVX512_VBMI``

``16/32/64-bit``
"""
EVEX_VPERMT2B_ZMM_K1Z_ZMM_ZMMM512: Code = 3222 # type: ignore
"""
``VPERMT2B zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.W0 7D /r``

``AVX512_VBMI``

``16/32/64-bit``
"""
EVEX_VPERMT2W_XMM_K1Z_XMM_XMMM128: Code = 3223 # type: ignore
"""
``VPERMT2W xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.W1 7D /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPERMT2W_YMM_K1Z_YMM_YMMM256: Code = 3224 # type: ignore
"""
``VPERMT2W ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.W1 7D /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPERMT2W_ZMM_K1Z_ZMM_ZMMM512: Code = 3225 # type: ignore
"""
``VPERMT2W zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.W1 7D /r``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPERMT2D_XMM_K1Z_XMM_XMMM128B32: Code = 3226 # type: ignore
"""
``VPERMT2D xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 7E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMT2D_YMM_K1Z_YMM_YMMM256B32: Code = 3227 # type: ignore
"""
``VPERMT2D ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 7E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMT2D_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3228 # type: ignore
"""
``VPERMT2D zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 7E /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMT2Q_XMM_K1Z_XMM_XMMM128B64: Code = 3229 # type: ignore
"""
``VPERMT2Q xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 7E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMT2Q_YMM_K1Z_YMM_YMMM256B64: Code = 3230 # type: ignore
"""
``VPERMT2Q ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 7E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMT2Q_ZMM_K1Z_ZMM_ZMMM512B64: Code = 3231 # type: ignore
"""
``VPERMT2Q zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 7E /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMT2PS_XMM_K1Z_XMM_XMMM128B32: Code = 3232 # type: ignore
"""
``VPERMT2PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 7F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMT2PS_YMM_K1Z_YMM_YMMM256B32: Code = 3233 # type: ignore
"""
``VPERMT2PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 7F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMT2PS_ZMM_K1Z_ZMM_ZMMM512B32: Code = 3234 # type: ignore
"""
``VPERMT2PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst``

``EVEX.512.66.0F38.W0 7F /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMT2PD_XMM_K1Z_XMM_XMMM128B64: Code = 3235 # type: ignore
"""
``VPERMT2PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 7F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMT2PD_YMM_K1Z_YMM_YMMM256B64: Code = 3236 # type: ignore
"""
``VPERMT2PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 7F /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMT2PD_ZMM_K1Z_ZMM_ZMMM512B64: Code = 3237 # type: ignore
"""
``VPERMT2PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 7F /r``

``AVX512F``

``16/32/64-bit``
"""
INVEPT_R32_M128: Code = 3238 # type: ignore
"""
``INVEPT r32, m128``

``66 0F 38 80 /r``

``VMX and IA32_VMX_EPT_VPID_CAP[bit 20]``

``16/32-bit``
"""
INVEPT_R64_M128: Code = 3239 # type: ignore
"""
``INVEPT r64, m128``

``66 0F 38 80 /r``

``VMX and IA32_VMX_EPT_VPID_CAP[bit 20]``

``64-bit``
"""
INVVPID_R32_M128: Code = 3240 # type: ignore
"""
``INVVPID r32, m128``

``66 0F 38 81 /r``

``VMX and IA32_VMX_EPT_VPID_CAP[bit 32]``

``16/32-bit``
"""
INVVPID_R64_M128: Code = 3241 # type: ignore
"""
``INVVPID r64, m128``

``66 0F 38 81 /r``

``VMX and IA32_VMX_EPT_VPID_CAP[bit 32]``

``64-bit``
"""
INVPCID_R32_M128: Code = 3242 # type: ignore
"""
``INVPCID r32, m128``

``66 0F 38 82 /r``

``INVPCID``

``16/32-bit``
"""
INVPCID_R64_M128: Code = 3243 # type: ignore
"""
``INVPCID r64, m128``

``66 0F 38 82 /r``

``INVPCID``

``64-bit``
"""
EVEX_VPMULTISHIFTQB_XMM_K1Z_XMM_XMMM128B64: Code = 3244 # type: ignore
"""
``VPMULTISHIFTQB xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 83 /r``

``AVX512VL and AVX512_VBMI``

``16/32/64-bit``
"""
EVEX_VPMULTISHIFTQB_YMM_K1Z_YMM_YMMM256B64: Code = 3245 # type: ignore
"""
``VPMULTISHIFTQB ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 83 /r``

``AVX512VL and AVX512_VBMI``

``16/32/64-bit``
"""
EVEX_VPMULTISHIFTQB_ZMM_K1Z_ZMM_ZMMM512B64: Code = 3246 # type: ignore
"""
``VPMULTISHIFTQB zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 83 /r``

``AVX512_VBMI``

``16/32/64-bit``
"""
EVEX_VEXPANDPS_XMM_K1Z_XMMM128: Code = 3247 # type: ignore
"""
``VEXPANDPS xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.66.0F38.W0 88 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VEXPANDPS_YMM_K1Z_YMMM256: Code = 3248 # type: ignore
"""
``VEXPANDPS ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.66.0F38.W0 88 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VEXPANDPS_ZMM_K1Z_ZMMM512: Code = 3249 # type: ignore
"""
``VEXPANDPS zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.66.0F38.W0 88 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VEXPANDPD_XMM_K1Z_XMMM128: Code = 3250 # type: ignore
"""
``VEXPANDPD xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.66.0F38.W1 88 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VEXPANDPD_YMM_K1Z_YMMM256: Code = 3251 # type: ignore
"""
``VEXPANDPD ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.66.0F38.W1 88 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VEXPANDPD_ZMM_K1Z_ZMMM512: Code = 3252 # type: ignore
"""
``VEXPANDPD zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.66.0F38.W1 88 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPEXPANDD_XMM_K1Z_XMMM128: Code = 3253 # type: ignore
"""
``VPEXPANDD xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.66.0F38.W0 89 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPEXPANDD_YMM_K1Z_YMMM256: Code = 3254 # type: ignore
"""
``VPEXPANDD ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.66.0F38.W0 89 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPEXPANDD_ZMM_K1Z_ZMMM512: Code = 3255 # type: ignore
"""
``VPEXPANDD zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.66.0F38.W0 89 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPEXPANDQ_XMM_K1Z_XMMM128: Code = 3256 # type: ignore
"""
``VPEXPANDQ xmm1 {k1}{z}, xmm2/m128``

``EVEX.128.66.0F38.W1 89 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPEXPANDQ_YMM_K1Z_YMMM256: Code = 3257 # type: ignore
"""
``VPEXPANDQ ymm1 {k1}{z}, ymm2/m256``

``EVEX.256.66.0F38.W1 89 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPEXPANDQ_ZMM_K1Z_ZMMM512: Code = 3258 # type: ignore
"""
``VPEXPANDQ zmm1 {k1}{z}, zmm2/m512``

``EVEX.512.66.0F38.W1 89 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCOMPRESSPS_XMMM128_K1Z_XMM: Code = 3259 # type: ignore
"""
``VCOMPRESSPS xmm1/m128 {k1}{z}, xmm2``

``EVEX.128.66.0F38.W0 8A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCOMPRESSPS_YMMM256_K1Z_YMM: Code = 3260 # type: ignore
"""
``VCOMPRESSPS ymm1/m256 {k1}{z}, ymm2``

``EVEX.256.66.0F38.W0 8A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCOMPRESSPS_ZMMM512_K1Z_ZMM: Code = 3261 # type: ignore
"""
``VCOMPRESSPS zmm1/m512 {k1}{z}, zmm2``

``EVEX.512.66.0F38.W0 8A /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VCOMPRESSPD_XMMM128_K1Z_XMM: Code = 3262 # type: ignore
"""
``VCOMPRESSPD xmm1/m128 {k1}{z}, xmm2``

``EVEX.128.66.0F38.W1 8A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCOMPRESSPD_YMMM256_K1Z_YMM: Code = 3263 # type: ignore
"""
``VCOMPRESSPD ymm1/m256 {k1}{z}, ymm2``

``EVEX.256.66.0F38.W1 8A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCOMPRESSPD_ZMMM512_K1Z_ZMM: Code = 3264 # type: ignore
"""
``VCOMPRESSPD zmm1/m512 {k1}{z}, zmm2``

``EVEX.512.66.0F38.W1 8A /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPCOMPRESSD_XMMM128_K1Z_XMM: Code = 3265 # type: ignore
"""
``VPCOMPRESSD xmm1/m128 {k1}{z}, xmm2``

``EVEX.128.66.0F38.W0 8B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCOMPRESSD_YMMM256_K1Z_YMM: Code = 3266 # type: ignore
"""
``VPCOMPRESSD ymm1/m256 {k1}{z}, ymm2``

``EVEX.256.66.0F38.W0 8B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCOMPRESSD_ZMMM512_K1Z_ZMM: Code = 3267 # type: ignore
"""
``VPCOMPRESSD zmm1/m512 {k1}{z}, zmm2``

``EVEX.512.66.0F38.W0 8B /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPCOMPRESSQ_XMMM128_K1Z_XMM: Code = 3268 # type: ignore
"""
``VPCOMPRESSQ xmm1/m128 {k1}{z}, xmm2``

``EVEX.128.66.0F38.W1 8B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCOMPRESSQ_YMMM256_K1Z_YMM: Code = 3269 # type: ignore
"""
``VPCOMPRESSQ ymm1/m256 {k1}{z}, ymm2``

``EVEX.256.66.0F38.W1 8B /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCOMPRESSQ_ZMMM512_K1Z_ZMM: Code = 3270 # type: ignore
"""
``VPCOMPRESSQ zmm1/m512 {k1}{z}, zmm2``

``EVEX.512.66.0F38.W1 8B /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VPMASKMOVD_XMM_XMM_M128: Code = 3271 # type: ignore
"""
``VPMASKMOVD xmm1, xmm2, m128``

``VEX.128.66.0F38.W0 8C /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPMASKMOVD_YMM_YMM_M256: Code = 3272 # type: ignore
"""
``VPMASKMOVD ymm1, ymm2, m256``

``VEX.256.66.0F38.W0 8C /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPMASKMOVQ_XMM_XMM_M128: Code = 3273 # type: ignore
"""
``VPMASKMOVQ xmm1, xmm2, m128``

``VEX.128.66.0F38.W1 8C /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPMASKMOVQ_YMM_YMM_M256: Code = 3274 # type: ignore
"""
``VPMASKMOVQ ymm1, ymm2, m256``

``VEX.256.66.0F38.W1 8C /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPERMB_XMM_K1Z_XMM_XMMM128: Code = 3275 # type: ignore
"""
``VPERMB xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.W0 8D /r``

``AVX512VL and AVX512_VBMI``

``16/32/64-bit``
"""
EVEX_VPERMB_YMM_K1Z_YMM_YMMM256: Code = 3276 # type: ignore
"""
``VPERMB ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.W0 8D /r``

``AVX512VL and AVX512_VBMI``

``16/32/64-bit``
"""
EVEX_VPERMB_ZMM_K1Z_ZMM_ZMMM512: Code = 3277 # type: ignore
"""
``VPERMB zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.W0 8D /r``

``AVX512_VBMI``

``16/32/64-bit``
"""
EVEX_VPERMW_XMM_K1Z_XMM_XMMM128: Code = 3278 # type: ignore
"""
``VPERMW xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.W1 8D /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPERMW_YMM_K1Z_YMM_YMMM256: Code = 3279 # type: ignore
"""
``VPERMW ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.W1 8D /r``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPERMW_ZMM_K1Z_ZMM_ZMMM512: Code = 3280 # type: ignore
"""
``VPERMW zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.W1 8D /r``

``AVX512BW``

``16/32/64-bit``
"""
VEX_VPMASKMOVD_M128_XMM_XMM: Code = 3281 # type: ignore
"""
``VPMASKMOVD m128, xmm1, xmm2``

``VEX.128.66.0F38.W0 8E /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPMASKMOVD_M256_YMM_YMM: Code = 3282 # type: ignore
"""
``VPMASKMOVD m256, ymm1, ymm2``

``VEX.256.66.0F38.W0 8E /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPMASKMOVQ_M128_XMM_XMM: Code = 3283 # type: ignore
"""
``VPMASKMOVQ m128, xmm1, xmm2``

``VEX.128.66.0F38.W1 8E /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPMASKMOVQ_M256_YMM_YMM: Code = 3284 # type: ignore
"""
``VPMASKMOVQ m256, ymm1, ymm2``

``VEX.256.66.0F38.W1 8E /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPSHUFBITQMB_KR_K1_XMM_XMMM128: Code = 3285 # type: ignore
"""
``VPSHUFBITQMB k1 {k2}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.W0 8F /r``

``AVX512VL and AVX512_BITALG``

``16/32/64-bit``
"""
EVEX_VPSHUFBITQMB_KR_K1_YMM_YMMM256: Code = 3286 # type: ignore
"""
``VPSHUFBITQMB k1 {k2}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.W0 8F /r``

``AVX512VL and AVX512_BITALG``

``16/32/64-bit``
"""
EVEX_VPSHUFBITQMB_KR_K1_ZMM_ZMMM512: Code = 3287 # type: ignore
"""
``VPSHUFBITQMB k1 {k2}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.W0 8F /r``

``AVX512_BITALG``

``16/32/64-bit``
"""
VEX_VPGATHERDD_XMM_VM32X_XMM: Code = 3288 # type: ignore
"""
``VPGATHERDD xmm1, vm32x, xmm2``

``VEX.128.66.0F38.W0 90 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPGATHERDD_YMM_VM32Y_YMM: Code = 3289 # type: ignore
"""
``VPGATHERDD ymm1, vm32y, ymm2``

``VEX.256.66.0F38.W0 90 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPGATHERDQ_XMM_VM32X_XMM: Code = 3290 # type: ignore
"""
``VPGATHERDQ xmm1, vm32x, xmm2``

``VEX.128.66.0F38.W1 90 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPGATHERDQ_YMM_VM32X_YMM: Code = 3291 # type: ignore
"""
``VPGATHERDQ ymm1, vm32x, ymm2``

``VEX.256.66.0F38.W1 90 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPGATHERDD_XMM_K1_VM32X: Code = 3292 # type: ignore
"""
``VPGATHERDD xmm1 {k1}, vm32x``

``EVEX.128.66.0F38.W0 90 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPGATHERDD_YMM_K1_VM32Y: Code = 3293 # type: ignore
"""
``VPGATHERDD ymm1 {k1}, vm32y``

``EVEX.256.66.0F38.W0 90 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPGATHERDD_ZMM_K1_VM32Z: Code = 3294 # type: ignore
"""
``VPGATHERDD zmm1 {k1}, vm32z``

``EVEX.512.66.0F38.W0 90 /vsib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPGATHERDQ_XMM_K1_VM32X: Code = 3295 # type: ignore
"""
``VPGATHERDQ xmm1 {k1}, vm32x``

``EVEX.128.66.0F38.W1 90 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPGATHERDQ_YMM_K1_VM32X: Code = 3296 # type: ignore
"""
``VPGATHERDQ ymm1 {k1}, vm32x``

``EVEX.256.66.0F38.W1 90 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPGATHERDQ_ZMM_K1_VM32Y: Code = 3297 # type: ignore
"""
``VPGATHERDQ zmm1 {k1}, vm32y``

``EVEX.512.66.0F38.W1 90 /vsib``

``AVX512F``

``16/32/64-bit``
"""
VEX_VPGATHERQD_XMM_VM64X_XMM: Code = 3298 # type: ignore
"""
``VPGATHERQD xmm1, vm64x, xmm2``

``VEX.128.66.0F38.W0 91 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPGATHERQD_XMM_VM64Y_XMM: Code = 3299 # type: ignore
"""
``VPGATHERQD xmm1, vm64y, xmm2``

``VEX.256.66.0F38.W0 91 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPGATHERQQ_XMM_VM64X_XMM: Code = 3300 # type: ignore
"""
``VPGATHERQQ xmm1, vm64x, xmm2``

``VEX.128.66.0F38.W1 91 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VPGATHERQQ_YMM_VM64Y_YMM: Code = 3301 # type: ignore
"""
``VPGATHERQQ ymm1, vm64y, ymm2``

``VEX.256.66.0F38.W1 91 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPGATHERQD_XMM_K1_VM64X: Code = 3302 # type: ignore
"""
``VPGATHERQD xmm1 {k1}, vm64x``

``EVEX.128.66.0F38.W0 91 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPGATHERQD_XMM_K1_VM64Y: Code = 3303 # type: ignore
"""
``VPGATHERQD xmm1 {k1}, vm64y``

``EVEX.256.66.0F38.W0 91 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPGATHERQD_YMM_K1_VM64Z: Code = 3304 # type: ignore
"""
``VPGATHERQD ymm1 {k1}, vm64z``

``EVEX.512.66.0F38.W0 91 /vsib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPGATHERQQ_XMM_K1_VM64X: Code = 3305 # type: ignore
"""
``VPGATHERQQ xmm1 {k1}, vm64x``

``EVEX.128.66.0F38.W1 91 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPGATHERQQ_YMM_K1_VM64Y: Code = 3306 # type: ignore
"""
``VPGATHERQQ ymm1 {k1}, vm64y``

``EVEX.256.66.0F38.W1 91 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPGATHERQQ_ZMM_K1_VM64Z: Code = 3307 # type: ignore
"""
``VPGATHERQQ zmm1 {k1}, vm64z``

``EVEX.512.66.0F38.W1 91 /vsib``

``AVX512F``

``16/32/64-bit``
"""
VEX_VGATHERDPS_XMM_VM32X_XMM: Code = 3308 # type: ignore
"""
``VGATHERDPS xmm1, vm32x, xmm2``

``VEX.128.66.0F38.W0 92 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VGATHERDPS_YMM_VM32Y_YMM: Code = 3309 # type: ignore
"""
``VGATHERDPS ymm1, vm32y, ymm2``

``VEX.256.66.0F38.W0 92 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VGATHERDPD_XMM_VM32X_XMM: Code = 3310 # type: ignore
"""
``VGATHERDPD xmm1, vm32x, xmm2``

``VEX.128.66.0F38.W1 92 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VGATHERDPD_YMM_VM32X_YMM: Code = 3311 # type: ignore
"""
``VGATHERDPD ymm1, vm32x, ymm2``

``VEX.256.66.0F38.W1 92 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VGATHERDPS_XMM_K1_VM32X: Code = 3312 # type: ignore
"""
``VGATHERDPS xmm1 {k1}, vm32x``

``EVEX.128.66.0F38.W0 92 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VGATHERDPS_YMM_K1_VM32Y: Code = 3313 # type: ignore
"""
``VGATHERDPS ymm1 {k1}, vm32y``

``EVEX.256.66.0F38.W0 92 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VGATHERDPS_ZMM_K1_VM32Z: Code = 3314 # type: ignore
"""
``VGATHERDPS zmm1 {k1}, vm32z``

``EVEX.512.66.0F38.W0 92 /vsib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VGATHERDPD_XMM_K1_VM32X: Code = 3315 # type: ignore
"""
``VGATHERDPD xmm1 {k1}, vm32x``

``EVEX.128.66.0F38.W1 92 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VGATHERDPD_YMM_K1_VM32X: Code = 3316 # type: ignore
"""
``VGATHERDPD ymm1 {k1}, vm32x``

``EVEX.256.66.0F38.W1 92 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VGATHERDPD_ZMM_K1_VM32Y: Code = 3317 # type: ignore
"""
``VGATHERDPD zmm1 {k1}, vm32y``

``EVEX.512.66.0F38.W1 92 /vsib``

``AVX512F``

``16/32/64-bit``
"""
VEX_VGATHERQPS_XMM_VM64X_XMM: Code = 3318 # type: ignore
"""
``VGATHERQPS xmm1, vm64x, xmm2``

``VEX.128.66.0F38.W0 93 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VGATHERQPS_XMM_VM64Y_XMM: Code = 3319 # type: ignore
"""
``VGATHERQPS xmm1, vm64y, xmm2``

``VEX.256.66.0F38.W0 93 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VGATHERQPD_XMM_VM64X_XMM: Code = 3320 # type: ignore
"""
``VGATHERQPD xmm1, vm64x, xmm2``

``VEX.128.66.0F38.W1 93 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VGATHERQPD_YMM_VM64Y_YMM: Code = 3321 # type: ignore
"""
``VGATHERQPD ymm1, vm64y, ymm2``

``VEX.256.66.0F38.W1 93 /r``

``AVX2``

``16/32/64-bit``
"""
EVEX_VGATHERQPS_XMM_K1_VM64X: Code = 3322 # type: ignore
"""
``VGATHERQPS xmm1 {k1}, vm64x``

``EVEX.128.66.0F38.W0 93 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VGATHERQPS_XMM_K1_VM64Y: Code = 3323 # type: ignore
"""
``VGATHERQPS xmm1 {k1}, vm64y``

``EVEX.256.66.0F38.W0 93 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VGATHERQPS_YMM_K1_VM64Z: Code = 3324 # type: ignore
"""
``VGATHERQPS ymm1 {k1}, vm64z``

``EVEX.512.66.0F38.W0 93 /vsib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VGATHERQPD_XMM_K1_VM64X: Code = 3325 # type: ignore
"""
``VGATHERQPD xmm1 {k1}, vm64x``

``EVEX.128.66.0F38.W1 93 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VGATHERQPD_YMM_K1_VM64Y: Code = 3326 # type: ignore
"""
``VGATHERQPD ymm1 {k1}, vm64y``

``EVEX.256.66.0F38.W1 93 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VGATHERQPD_ZMM_K1_VM64Z: Code = 3327 # type: ignore
"""
``VGATHERQPD zmm1 {k1}, vm64z``

``EVEX.512.66.0F38.W1 93 /vsib``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFMADDSUB132PS_XMM_XMM_XMMM128: Code = 3328 # type: ignore
"""
``VFMADDSUB132PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 96 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADDSUB132PS_YMM_YMM_YMMM256: Code = 3329 # type: ignore
"""
``VFMADDSUB132PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 96 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADDSUB132PD_XMM_XMM_XMMM128: Code = 3330 # type: ignore
"""
``VFMADDSUB132PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 96 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADDSUB132PD_YMM_YMM_YMMM256: Code = 3331 # type: ignore
"""
``VFMADDSUB132PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 96 /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMADDSUB132PS_XMM_K1Z_XMM_XMMM128B32: Code = 3332 # type: ignore
"""
``VFMADDSUB132PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 96 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADDSUB132PS_YMM_K1Z_YMM_YMMM256B32: Code = 3333 # type: ignore
"""
``VFMADDSUB132PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 96 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADDSUB132PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3334 # type: ignore
"""
``VFMADDSUB132PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 96 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADDSUB132PD_XMM_K1Z_XMM_XMMM128B64: Code = 3335 # type: ignore
"""
``VFMADDSUB132PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 96 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADDSUB132PD_YMM_K1Z_YMM_YMMM256B64: Code = 3336 # type: ignore
"""
``VFMADDSUB132PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 96 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADDSUB132PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3337 # type: ignore
"""
``VFMADDSUB132PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 96 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFMSUBADD132PS_XMM_XMM_XMMM128: Code = 3338 # type: ignore
"""
``VFMSUBADD132PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 97 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUBADD132PS_YMM_YMM_YMMM256: Code = 3339 # type: ignore
"""
``VFMSUBADD132PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 97 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUBADD132PD_XMM_XMM_XMMM128: Code = 3340 # type: ignore
"""
``VFMSUBADD132PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 97 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUBADD132PD_YMM_YMM_YMMM256: Code = 3341 # type: ignore
"""
``VFMSUBADD132PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 97 /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMSUBADD132PS_XMM_K1Z_XMM_XMMM128B32: Code = 3342 # type: ignore
"""
``VFMSUBADD132PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 97 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUBADD132PS_YMM_K1Z_YMM_YMMM256B32: Code = 3343 # type: ignore
"""
``VFMSUBADD132PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 97 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUBADD132PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3344 # type: ignore
"""
``VFMSUBADD132PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 97 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUBADD132PD_XMM_K1Z_XMM_XMMM128B64: Code = 3345 # type: ignore
"""
``VFMSUBADD132PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 97 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUBADD132PD_YMM_K1Z_YMM_YMMM256B64: Code = 3346 # type: ignore
"""
``VFMSUBADD132PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 97 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUBADD132PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3347 # type: ignore
"""
``VFMSUBADD132PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 97 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFMADD132PS_XMM_XMM_XMMM128: Code = 3348 # type: ignore
"""
``VFMADD132PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 98 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADD132PS_YMM_YMM_YMMM256: Code = 3349 # type: ignore
"""
``VFMADD132PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 98 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADD132PD_XMM_XMM_XMMM128: Code = 3350 # type: ignore
"""
``VFMADD132PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 98 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADD132PD_YMM_YMM_YMMM256: Code = 3351 # type: ignore
"""
``VFMADD132PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 98 /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMADD132PS_XMM_K1Z_XMM_XMMM128B32: Code = 3352 # type: ignore
"""
``VFMADD132PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 98 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD132PS_YMM_K1Z_YMM_YMMM256B32: Code = 3353 # type: ignore
"""
``VFMADD132PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 98 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD132PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3354 # type: ignore
"""
``VFMADD132PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 98 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD132PD_XMM_K1Z_XMM_XMMM128B64: Code = 3355 # type: ignore
"""
``VFMADD132PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 98 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD132PD_YMM_K1Z_YMM_YMMM256B64: Code = 3356 # type: ignore
"""
``VFMADD132PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 98 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD132PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3357 # type: ignore
"""
``VFMADD132PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 98 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFMADD132SS_XMM_XMM_XMMM32: Code = 3358 # type: ignore
"""
``VFMADD132SS xmm1, xmm2, xmm3/m32``

``VEX.LIG.66.0F38.W0 99 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADD132SD_XMM_XMM_XMMM64: Code = 3359 # type: ignore
"""
``VFMADD132SD xmm1, xmm2, xmm3/m64``

``VEX.LIG.66.0F38.W1 99 /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMADD132SS_XMM_K1Z_XMM_XMMM32_ER: Code = 3360 # type: ignore
"""
``VFMADD132SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.66.0F38.W0 99 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD132SD_XMM_K1Z_XMM_XMMM64_ER: Code = 3361 # type: ignore
"""
``VFMADD132SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.66.0F38.W1 99 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFMSUB132PS_XMM_XMM_XMMM128: Code = 3362 # type: ignore
"""
``VFMSUB132PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 9A /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUB132PS_YMM_YMM_YMMM256: Code = 3363 # type: ignore
"""
``VFMSUB132PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 9A /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUB132PD_XMM_XMM_XMMM128: Code = 3364 # type: ignore
"""
``VFMSUB132PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 9A /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUB132PD_YMM_YMM_YMMM256: Code = 3365 # type: ignore
"""
``VFMSUB132PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 9A /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMSUB132PS_XMM_K1Z_XMM_XMMM128B32: Code = 3366 # type: ignore
"""
``VFMSUB132PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 9A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB132PS_YMM_K1Z_YMM_YMMM256B32: Code = 3367 # type: ignore
"""
``VFMSUB132PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 9A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB132PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3368 # type: ignore
"""
``VFMSUB132PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 9A /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB132PD_XMM_K1Z_XMM_XMMM128B64: Code = 3369 # type: ignore
"""
``VFMSUB132PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 9A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB132PD_YMM_K1Z_YMM_YMMM256B64: Code = 3370 # type: ignore
"""
``VFMSUB132PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 9A /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB132PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3371 # type: ignore
"""
``VFMSUB132PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 9A /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_V4FMADDPS_ZMM_K1Z_ZMMP3_M128: Code = 3372 # type: ignore
"""
``V4FMADDPS zmm1 {k1}{z}, zmm2+3, m128``

``EVEX.512.F2.0F38.W0 9A /r``

``AVX512_4FMAPS``

``16/32/64-bit``
"""
VEX_VFMSUB132SS_XMM_XMM_XMMM32: Code = 3373 # type: ignore
"""
``VFMSUB132SS xmm1, xmm2, xmm3/m32``

``VEX.LIG.66.0F38.W0 9B /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUB132SD_XMM_XMM_XMMM64: Code = 3374 # type: ignore
"""
``VFMSUB132SD xmm1, xmm2, xmm3/m64``

``VEX.LIG.66.0F38.W1 9B /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMSUB132SS_XMM_K1Z_XMM_XMMM32_ER: Code = 3375 # type: ignore
"""
``VFMSUB132SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.66.0F38.W0 9B /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB132SD_XMM_K1Z_XMM_XMMM64_ER: Code = 3376 # type: ignore
"""
``VFMSUB132SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.66.0F38.W1 9B /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_V4FMADDSS_XMM_K1Z_XMMP3_M128: Code = 3377 # type: ignore
"""
``V4FMADDSS xmm1 {k1}{z}, xmm2+3, m128``

``EVEX.LIG.F2.0F38.W0 9B /r``

``AVX512_4FMAPS``

``16/32/64-bit``
"""
VEX_VFNMADD132PS_XMM_XMM_XMMM128: Code = 3378 # type: ignore
"""
``VFNMADD132PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 9C /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMADD132PS_YMM_YMM_YMMM256: Code = 3379 # type: ignore
"""
``VFNMADD132PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 9C /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMADD132PD_XMM_XMM_XMMM128: Code = 3380 # type: ignore
"""
``VFNMADD132PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 9C /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMADD132PD_YMM_YMM_YMMM256: Code = 3381 # type: ignore
"""
``VFNMADD132PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 9C /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFNMADD132PS_XMM_K1Z_XMM_XMMM128B32: Code = 3382 # type: ignore
"""
``VFNMADD132PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 9C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD132PS_YMM_K1Z_YMM_YMMM256B32: Code = 3383 # type: ignore
"""
``VFNMADD132PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 9C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD132PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3384 # type: ignore
"""
``VFNMADD132PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 9C /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD132PD_XMM_K1Z_XMM_XMMM128B64: Code = 3385 # type: ignore
"""
``VFNMADD132PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 9C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD132PD_YMM_K1Z_YMM_YMMM256B64: Code = 3386 # type: ignore
"""
``VFNMADD132PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 9C /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD132PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3387 # type: ignore
"""
``VFNMADD132PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 9C /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFNMADD132SS_XMM_XMM_XMMM32: Code = 3388 # type: ignore
"""
``VFNMADD132SS xmm1, xmm2, xmm3/m32``

``VEX.LIG.66.0F38.W0 9D /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMADD132SD_XMM_XMM_XMMM64: Code = 3389 # type: ignore
"""
``VFNMADD132SD xmm1, xmm2, xmm3/m64``

``VEX.LIG.66.0F38.W1 9D /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFNMADD132SS_XMM_K1Z_XMM_XMMM32_ER: Code = 3390 # type: ignore
"""
``VFNMADD132SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.66.0F38.W0 9D /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD132SD_XMM_K1Z_XMM_XMMM64_ER: Code = 3391 # type: ignore
"""
``VFNMADD132SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.66.0F38.W1 9D /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFNMSUB132PS_XMM_XMM_XMMM128: Code = 3392 # type: ignore
"""
``VFNMSUB132PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 9E /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMSUB132PS_YMM_YMM_YMMM256: Code = 3393 # type: ignore
"""
``VFNMSUB132PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 9E /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMSUB132PD_XMM_XMM_XMMM128: Code = 3394 # type: ignore
"""
``VFNMSUB132PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 9E /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMSUB132PD_YMM_YMM_YMMM256: Code = 3395 # type: ignore
"""
``VFNMSUB132PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 9E /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFNMSUB132PS_XMM_K1Z_XMM_XMMM128B32: Code = 3396 # type: ignore
"""
``VFNMSUB132PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 9E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB132PS_YMM_K1Z_YMM_YMMM256B32: Code = 3397 # type: ignore
"""
``VFNMSUB132PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 9E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB132PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3398 # type: ignore
"""
``VFNMSUB132PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 9E /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB132PD_XMM_K1Z_XMM_XMMM128B64: Code = 3399 # type: ignore
"""
``VFNMSUB132PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 9E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB132PD_YMM_K1Z_YMM_YMMM256B64: Code = 3400 # type: ignore
"""
``VFNMSUB132PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 9E /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB132PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3401 # type: ignore
"""
``VFNMSUB132PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 9E /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFNMSUB132SS_XMM_XMM_XMMM32: Code = 3402 # type: ignore
"""
``VFNMSUB132SS xmm1, xmm2, xmm3/m32``

``VEX.LIG.66.0F38.W0 9F /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMSUB132SD_XMM_XMM_XMMM64: Code = 3403 # type: ignore
"""
``VFNMSUB132SD xmm1, xmm2, xmm3/m64``

``VEX.LIG.66.0F38.W1 9F /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFNMSUB132SS_XMM_K1Z_XMM_XMMM32_ER: Code = 3404 # type: ignore
"""
``VFNMSUB132SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.66.0F38.W0 9F /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB132SD_XMM_K1Z_XMM_XMMM64_ER: Code = 3405 # type: ignore
"""
``VFNMSUB132SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.66.0F38.W1 9F /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPSCATTERDD_VM32X_K1_XMM: Code = 3406 # type: ignore
"""
``VPSCATTERDD vm32x {k1}, xmm1``

``EVEX.128.66.0F38.W0 A0 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSCATTERDD_VM32Y_K1_YMM: Code = 3407 # type: ignore
"""
``VPSCATTERDD vm32y {k1}, ymm1``

``EVEX.256.66.0F38.W0 A0 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSCATTERDD_VM32Z_K1_ZMM: Code = 3408 # type: ignore
"""
``VPSCATTERDD vm32z {k1}, zmm1``

``EVEX.512.66.0F38.W0 A0 /vsib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPSCATTERDQ_VM32X_K1_XMM: Code = 3409 # type: ignore
"""
``VPSCATTERDQ vm32x {k1}, xmm1``

``EVEX.128.66.0F38.W1 A0 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSCATTERDQ_VM32X_K1_YMM: Code = 3410 # type: ignore
"""
``VPSCATTERDQ vm32x {k1}, ymm1``

``EVEX.256.66.0F38.W1 A0 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSCATTERDQ_VM32Y_K1_ZMM: Code = 3411 # type: ignore
"""
``VPSCATTERDQ vm32y {k1}, zmm1``

``EVEX.512.66.0F38.W1 A0 /vsib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPSCATTERQD_VM64X_K1_XMM: Code = 3412 # type: ignore
"""
``VPSCATTERQD vm64x {k1}, xmm1``

``EVEX.128.66.0F38.W0 A1 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSCATTERQD_VM64Y_K1_XMM: Code = 3413 # type: ignore
"""
``VPSCATTERQD vm64y {k1}, xmm1``

``EVEX.256.66.0F38.W0 A1 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSCATTERQD_VM64Z_K1_YMM: Code = 3414 # type: ignore
"""
``VPSCATTERQD vm64z {k1}, ymm1``

``EVEX.512.66.0F38.W0 A1 /vsib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPSCATTERQQ_VM64X_K1_XMM: Code = 3415 # type: ignore
"""
``VPSCATTERQQ vm64x {k1}, xmm1``

``EVEX.128.66.0F38.W1 A1 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSCATTERQQ_VM64Y_K1_YMM: Code = 3416 # type: ignore
"""
``VPSCATTERQQ vm64y {k1}, ymm1``

``EVEX.256.66.0F38.W1 A1 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPSCATTERQQ_VM64Z_K1_ZMM: Code = 3417 # type: ignore
"""
``VPSCATTERQQ vm64z {k1}, zmm1``

``EVEX.512.66.0F38.W1 A1 /vsib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VSCATTERDPS_VM32X_K1_XMM: Code = 3418 # type: ignore
"""
``VSCATTERDPS vm32x {k1}, xmm1``

``EVEX.128.66.0F38.W0 A2 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSCATTERDPS_VM32Y_K1_YMM: Code = 3419 # type: ignore
"""
``VSCATTERDPS vm32y {k1}, ymm1``

``EVEX.256.66.0F38.W0 A2 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSCATTERDPS_VM32Z_K1_ZMM: Code = 3420 # type: ignore
"""
``VSCATTERDPS vm32z {k1}, zmm1``

``EVEX.512.66.0F38.W0 A2 /vsib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VSCATTERDPD_VM32X_K1_XMM: Code = 3421 # type: ignore
"""
``VSCATTERDPD vm32x {k1}, xmm1``

``EVEX.128.66.0F38.W1 A2 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSCATTERDPD_VM32X_K1_YMM: Code = 3422 # type: ignore
"""
``VSCATTERDPD vm32x {k1}, ymm1``

``EVEX.256.66.0F38.W1 A2 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSCATTERDPD_VM32Y_K1_ZMM: Code = 3423 # type: ignore
"""
``VSCATTERDPD vm32y {k1}, zmm1``

``EVEX.512.66.0F38.W1 A2 /vsib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VSCATTERQPS_VM64X_K1_XMM: Code = 3424 # type: ignore
"""
``VSCATTERQPS vm64x {k1}, xmm1``

``EVEX.128.66.0F38.W0 A3 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSCATTERQPS_VM64Y_K1_XMM: Code = 3425 # type: ignore
"""
``VSCATTERQPS vm64y {k1}, xmm1``

``EVEX.256.66.0F38.W0 A3 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSCATTERQPS_VM64Z_K1_YMM: Code = 3426 # type: ignore
"""
``VSCATTERQPS vm64z {k1}, ymm1``

``EVEX.512.66.0F38.W0 A3 /vsib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VSCATTERQPD_VM64X_K1_XMM: Code = 3427 # type: ignore
"""
``VSCATTERQPD vm64x {k1}, xmm1``

``EVEX.128.66.0F38.W1 A3 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSCATTERQPD_VM64Y_K1_YMM: Code = 3428 # type: ignore
"""
``VSCATTERQPD vm64y {k1}, ymm1``

``EVEX.256.66.0F38.W1 A3 /vsib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSCATTERQPD_VM64Z_K1_ZMM: Code = 3429 # type: ignore
"""
``VSCATTERQPD vm64z {k1}, zmm1``

``EVEX.512.66.0F38.W1 A3 /vsib``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFMADDSUB213PS_XMM_XMM_XMMM128: Code = 3430 # type: ignore
"""
``VFMADDSUB213PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 A6 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADDSUB213PS_YMM_YMM_YMMM256: Code = 3431 # type: ignore
"""
``VFMADDSUB213PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 A6 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADDSUB213PD_XMM_XMM_XMMM128: Code = 3432 # type: ignore
"""
``VFMADDSUB213PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 A6 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADDSUB213PD_YMM_YMM_YMMM256: Code = 3433 # type: ignore
"""
``VFMADDSUB213PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 A6 /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMADDSUB213PS_XMM_K1Z_XMM_XMMM128B32: Code = 3434 # type: ignore
"""
``VFMADDSUB213PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 A6 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADDSUB213PS_YMM_K1Z_YMM_YMMM256B32: Code = 3435 # type: ignore
"""
``VFMADDSUB213PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 A6 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADDSUB213PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3436 # type: ignore
"""
``VFMADDSUB213PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 A6 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADDSUB213PD_XMM_K1Z_XMM_XMMM128B64: Code = 3437 # type: ignore
"""
``VFMADDSUB213PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 A6 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADDSUB213PD_YMM_K1Z_YMM_YMMM256B64: Code = 3438 # type: ignore
"""
``VFMADDSUB213PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 A6 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADDSUB213PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3439 # type: ignore
"""
``VFMADDSUB213PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 A6 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFMSUBADD213PS_XMM_XMM_XMMM128: Code = 3440 # type: ignore
"""
``VFMSUBADD213PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 A7 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUBADD213PS_YMM_YMM_YMMM256: Code = 3441 # type: ignore
"""
``VFMSUBADD213PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 A7 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUBADD213PD_XMM_XMM_XMMM128: Code = 3442 # type: ignore
"""
``VFMSUBADD213PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 A7 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUBADD213PD_YMM_YMM_YMMM256: Code = 3443 # type: ignore
"""
``VFMSUBADD213PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 A7 /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMSUBADD213PS_XMM_K1Z_XMM_XMMM128B32: Code = 3444 # type: ignore
"""
``VFMSUBADD213PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 A7 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUBADD213PS_YMM_K1Z_YMM_YMMM256B32: Code = 3445 # type: ignore
"""
``VFMSUBADD213PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 A7 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUBADD213PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3446 # type: ignore
"""
``VFMSUBADD213PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 A7 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUBADD213PD_XMM_K1Z_XMM_XMMM128B64: Code = 3447 # type: ignore
"""
``VFMSUBADD213PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 A7 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUBADD213PD_YMM_K1Z_YMM_YMMM256B64: Code = 3448 # type: ignore
"""
``VFMSUBADD213PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 A7 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUBADD213PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3449 # type: ignore
"""
``VFMSUBADD213PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 A7 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFMADD213PS_XMM_XMM_XMMM128: Code = 3450 # type: ignore
"""
``VFMADD213PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 A8 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADD213PS_YMM_YMM_YMMM256: Code = 3451 # type: ignore
"""
``VFMADD213PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 A8 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADD213PD_XMM_XMM_XMMM128: Code = 3452 # type: ignore
"""
``VFMADD213PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 A8 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADD213PD_YMM_YMM_YMMM256: Code = 3453 # type: ignore
"""
``VFMADD213PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 A8 /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMADD213PS_XMM_K1Z_XMM_XMMM128B32: Code = 3454 # type: ignore
"""
``VFMADD213PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 A8 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD213PS_YMM_K1Z_YMM_YMMM256B32: Code = 3455 # type: ignore
"""
``VFMADD213PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 A8 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD213PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3456 # type: ignore
"""
``VFMADD213PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 A8 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD213PD_XMM_K1Z_XMM_XMMM128B64: Code = 3457 # type: ignore
"""
``VFMADD213PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 A8 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD213PD_YMM_K1Z_YMM_YMMM256B64: Code = 3458 # type: ignore
"""
``VFMADD213PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 A8 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD213PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3459 # type: ignore
"""
``VFMADD213PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 A8 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFMADD213SS_XMM_XMM_XMMM32: Code = 3460 # type: ignore
"""
``VFMADD213SS xmm1, xmm2, xmm3/m32``

``VEX.LIG.66.0F38.W0 A9 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADD213SD_XMM_XMM_XMMM64: Code = 3461 # type: ignore
"""
``VFMADD213SD xmm1, xmm2, xmm3/m64``

``VEX.LIG.66.0F38.W1 A9 /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMADD213SS_XMM_K1Z_XMM_XMMM32_ER: Code = 3462 # type: ignore
"""
``VFMADD213SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.66.0F38.W0 A9 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD213SD_XMM_K1Z_XMM_XMMM64_ER: Code = 3463 # type: ignore
"""
``VFMADD213SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.66.0F38.W1 A9 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFMSUB213PS_XMM_XMM_XMMM128: Code = 3464 # type: ignore
"""
``VFMSUB213PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 AA /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUB213PS_YMM_YMM_YMMM256: Code = 3465 # type: ignore
"""
``VFMSUB213PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 AA /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUB213PD_XMM_XMM_XMMM128: Code = 3466 # type: ignore
"""
``VFMSUB213PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 AA /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUB213PD_YMM_YMM_YMMM256: Code = 3467 # type: ignore
"""
``VFMSUB213PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 AA /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMSUB213PS_XMM_K1Z_XMM_XMMM128B32: Code = 3468 # type: ignore
"""
``VFMSUB213PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 AA /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB213PS_YMM_K1Z_YMM_YMMM256B32: Code = 3469 # type: ignore
"""
``VFMSUB213PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 AA /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB213PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3470 # type: ignore
"""
``VFMSUB213PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 AA /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB213PD_XMM_K1Z_XMM_XMMM128B64: Code = 3471 # type: ignore
"""
``VFMSUB213PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 AA /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB213PD_YMM_K1Z_YMM_YMMM256B64: Code = 3472 # type: ignore
"""
``VFMSUB213PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 AA /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB213PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3473 # type: ignore
"""
``VFMSUB213PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 AA /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_V4FNMADDPS_ZMM_K1Z_ZMMP3_M128: Code = 3474 # type: ignore
"""
``V4FNMADDPS zmm1 {k1}{z}, zmm2+3, m128``

``EVEX.512.F2.0F38.W0 AA /r``

``AVX512_4FMAPS``

``16/32/64-bit``
"""
VEX_VFMSUB213SS_XMM_XMM_XMMM32: Code = 3475 # type: ignore
"""
``VFMSUB213SS xmm1, xmm2, xmm3/m32``

``VEX.LIG.66.0F38.W0 AB /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUB213SD_XMM_XMM_XMMM64: Code = 3476 # type: ignore
"""
``VFMSUB213SD xmm1, xmm2, xmm3/m64``

``VEX.LIG.66.0F38.W1 AB /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMSUB213SS_XMM_K1Z_XMM_XMMM32_ER: Code = 3477 # type: ignore
"""
``VFMSUB213SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.66.0F38.W0 AB /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB213SD_XMM_K1Z_XMM_XMMM64_ER: Code = 3478 # type: ignore
"""
``VFMSUB213SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.66.0F38.W1 AB /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_V4FNMADDSS_XMM_K1Z_XMMP3_M128: Code = 3479 # type: ignore
"""
``V4FNMADDSS xmm1 {k1}{z}, xmm2+3, m128``

``EVEX.LIG.F2.0F38.W0 AB /r``

``AVX512_4FMAPS``

``16/32/64-bit``
"""
VEX_VFNMADD213PS_XMM_XMM_XMMM128: Code = 3480 # type: ignore
"""
``VFNMADD213PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 AC /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMADD213PS_YMM_YMM_YMMM256: Code = 3481 # type: ignore
"""
``VFNMADD213PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 AC /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMADD213PD_XMM_XMM_XMMM128: Code = 3482 # type: ignore
"""
``VFNMADD213PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 AC /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMADD213PD_YMM_YMM_YMMM256: Code = 3483 # type: ignore
"""
``VFNMADD213PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 AC /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFNMADD213PS_XMM_K1Z_XMM_XMMM128B32: Code = 3484 # type: ignore
"""
``VFNMADD213PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 AC /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD213PS_YMM_K1Z_YMM_YMMM256B32: Code = 3485 # type: ignore
"""
``VFNMADD213PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 AC /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD213PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3486 # type: ignore
"""
``VFNMADD213PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 AC /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD213PD_XMM_K1Z_XMM_XMMM128B64: Code = 3487 # type: ignore
"""
``VFNMADD213PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 AC /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD213PD_YMM_K1Z_YMM_YMMM256B64: Code = 3488 # type: ignore
"""
``VFNMADD213PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 AC /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD213PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3489 # type: ignore
"""
``VFNMADD213PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 AC /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFNMADD213SS_XMM_XMM_XMMM32: Code = 3490 # type: ignore
"""
``VFNMADD213SS xmm1, xmm2, xmm3/m32``

``VEX.LIG.66.0F38.W0 AD /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMADD213SD_XMM_XMM_XMMM64: Code = 3491 # type: ignore
"""
``VFNMADD213SD xmm1, xmm2, xmm3/m64``

``VEX.LIG.66.0F38.W1 AD /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFNMADD213SS_XMM_K1Z_XMM_XMMM32_ER: Code = 3492 # type: ignore
"""
``VFNMADD213SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.66.0F38.W0 AD /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD213SD_XMM_K1Z_XMM_XMMM64_ER: Code = 3493 # type: ignore
"""
``VFNMADD213SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.66.0F38.W1 AD /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFNMSUB213PS_XMM_XMM_XMMM128: Code = 3494 # type: ignore
"""
``VFNMSUB213PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 AE /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMSUB213PS_YMM_YMM_YMMM256: Code = 3495 # type: ignore
"""
``VFNMSUB213PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 AE /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMSUB213PD_XMM_XMM_XMMM128: Code = 3496 # type: ignore
"""
``VFNMSUB213PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 AE /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMSUB213PD_YMM_YMM_YMMM256: Code = 3497 # type: ignore
"""
``VFNMSUB213PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 AE /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFNMSUB213PS_XMM_K1Z_XMM_XMMM128B32: Code = 3498 # type: ignore
"""
``VFNMSUB213PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 AE /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB213PS_YMM_K1Z_YMM_YMMM256B32: Code = 3499 # type: ignore
"""
``VFNMSUB213PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 AE /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB213PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3500 # type: ignore
"""
``VFNMSUB213PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 AE /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB213PD_XMM_K1Z_XMM_XMMM128B64: Code = 3501 # type: ignore
"""
``VFNMSUB213PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 AE /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB213PD_YMM_K1Z_YMM_YMMM256B64: Code = 3502 # type: ignore
"""
``VFNMSUB213PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 AE /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB213PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3503 # type: ignore
"""
``VFNMSUB213PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 AE /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFNMSUB213SS_XMM_XMM_XMMM32: Code = 3504 # type: ignore
"""
``VFNMSUB213SS xmm1, xmm2, xmm3/m32``

``VEX.LIG.66.0F38.W0 AF /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMSUB213SD_XMM_XMM_XMMM64: Code = 3505 # type: ignore
"""
``VFNMSUB213SD xmm1, xmm2, xmm3/m64``

``VEX.LIG.66.0F38.W1 AF /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFNMSUB213SS_XMM_K1Z_XMM_XMMM32_ER: Code = 3506 # type: ignore
"""
``VFNMSUB213SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.66.0F38.W0 AF /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB213SD_XMM_K1Z_XMM_XMMM64_ER: Code = 3507 # type: ignore
"""
``VFNMSUB213SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.66.0F38.W1 AF /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPMADD52LUQ_XMM_K1Z_XMM_XMMM128B64: Code = 3508 # type: ignore
"""
``VPMADD52LUQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 B4 /r``

``AVX512VL and AVX512_IFMA``

``16/32/64-bit``
"""
EVEX_VPMADD52LUQ_YMM_K1Z_YMM_YMMM256B64: Code = 3509 # type: ignore
"""
``VPMADD52LUQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 B4 /r``

``AVX512VL and AVX512_IFMA``

``16/32/64-bit``
"""
EVEX_VPMADD52LUQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 3510 # type: ignore
"""
``VPMADD52LUQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 B4 /r``

``AVX512_IFMA``

``16/32/64-bit``
"""
EVEX_VPMADD52HUQ_XMM_K1Z_XMM_XMMM128B64: Code = 3511 # type: ignore
"""
``VPMADD52HUQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 B5 /r``

``AVX512VL and AVX512_IFMA``

``16/32/64-bit``
"""
EVEX_VPMADD52HUQ_YMM_K1Z_YMM_YMMM256B64: Code = 3512 # type: ignore
"""
``VPMADD52HUQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 B5 /r``

``AVX512VL and AVX512_IFMA``

``16/32/64-bit``
"""
EVEX_VPMADD52HUQ_ZMM_K1Z_ZMM_ZMMM512B64: Code = 3513 # type: ignore
"""
``VPMADD52HUQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst``

``EVEX.512.66.0F38.W1 B5 /r``

``AVX512_IFMA``

``16/32/64-bit``
"""
VEX_VFMADDSUB231PS_XMM_XMM_XMMM128: Code = 3514 # type: ignore
"""
``VFMADDSUB231PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 B6 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADDSUB231PS_YMM_YMM_YMMM256: Code = 3515 # type: ignore
"""
``VFMADDSUB231PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 B6 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADDSUB231PD_XMM_XMM_XMMM128: Code = 3516 # type: ignore
"""
``VFMADDSUB231PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 B6 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADDSUB231PD_YMM_YMM_YMMM256: Code = 3517 # type: ignore
"""
``VFMADDSUB231PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 B6 /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMADDSUB231PS_XMM_K1Z_XMM_XMMM128B32: Code = 3518 # type: ignore
"""
``VFMADDSUB231PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 B6 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADDSUB231PS_YMM_K1Z_YMM_YMMM256B32: Code = 3519 # type: ignore
"""
``VFMADDSUB231PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 B6 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADDSUB231PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3520 # type: ignore
"""
``VFMADDSUB231PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 B6 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADDSUB231PD_XMM_K1Z_XMM_XMMM128B64: Code = 3521 # type: ignore
"""
``VFMADDSUB231PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 B6 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADDSUB231PD_YMM_K1Z_YMM_YMMM256B64: Code = 3522 # type: ignore
"""
``VFMADDSUB231PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 B6 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADDSUB231PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3523 # type: ignore
"""
``VFMADDSUB231PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 B6 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFMSUBADD231PS_XMM_XMM_XMMM128: Code = 3524 # type: ignore
"""
``VFMSUBADD231PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 B7 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUBADD231PS_YMM_YMM_YMMM256: Code = 3525 # type: ignore
"""
``VFMSUBADD231PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 B7 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUBADD231PD_XMM_XMM_XMMM128: Code = 3526 # type: ignore
"""
``VFMSUBADD231PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 B7 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUBADD231PD_YMM_YMM_YMMM256: Code = 3527 # type: ignore
"""
``VFMSUBADD231PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 B7 /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMSUBADD231PS_XMM_K1Z_XMM_XMMM128B32: Code = 3528 # type: ignore
"""
``VFMSUBADD231PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 B7 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUBADD231PS_YMM_K1Z_YMM_YMMM256B32: Code = 3529 # type: ignore
"""
``VFMSUBADD231PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 B7 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUBADD231PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3530 # type: ignore
"""
``VFMSUBADD231PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 B7 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUBADD231PD_XMM_K1Z_XMM_XMMM128B64: Code = 3531 # type: ignore
"""
``VFMSUBADD231PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 B7 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUBADD231PD_YMM_K1Z_YMM_YMMM256B64: Code = 3532 # type: ignore
"""
``VFMSUBADD231PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 B7 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUBADD231PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3533 # type: ignore
"""
``VFMSUBADD231PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 B7 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFMADD231PS_XMM_XMM_XMMM128: Code = 3534 # type: ignore
"""
``VFMADD231PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 B8 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADD231PS_YMM_YMM_YMMM256: Code = 3535 # type: ignore
"""
``VFMADD231PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 B8 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADD231PD_XMM_XMM_XMMM128: Code = 3536 # type: ignore
"""
``VFMADD231PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 B8 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADD231PD_YMM_YMM_YMMM256: Code = 3537 # type: ignore
"""
``VFMADD231PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 B8 /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMADD231PS_XMM_K1Z_XMM_XMMM128B32: Code = 3538 # type: ignore
"""
``VFMADD231PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 B8 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD231PS_YMM_K1Z_YMM_YMMM256B32: Code = 3539 # type: ignore
"""
``VFMADD231PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 B8 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD231PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3540 # type: ignore
"""
``VFMADD231PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 B8 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD231PD_XMM_K1Z_XMM_XMMM128B64: Code = 3541 # type: ignore
"""
``VFMADD231PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 B8 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD231PD_YMM_K1Z_YMM_YMMM256B64: Code = 3542 # type: ignore
"""
``VFMADD231PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 B8 /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD231PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3543 # type: ignore
"""
``VFMADD231PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 B8 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFMADD231SS_XMM_XMM_XMMM32: Code = 3544 # type: ignore
"""
``VFMADD231SS xmm1, xmm2, xmm3/m32``

``VEX.LIG.66.0F38.W0 B9 /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMADD231SD_XMM_XMM_XMMM64: Code = 3545 # type: ignore
"""
``VFMADD231SD xmm1, xmm2, xmm3/m64``

``VEX.LIG.66.0F38.W1 B9 /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMADD231SS_XMM_K1Z_XMM_XMMM32_ER: Code = 3546 # type: ignore
"""
``VFMADD231SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.66.0F38.W0 B9 /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMADD231SD_XMM_K1Z_XMM_XMMM64_ER: Code = 3547 # type: ignore
"""
``VFMADD231SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.66.0F38.W1 B9 /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFMSUB231PS_XMM_XMM_XMMM128: Code = 3548 # type: ignore
"""
``VFMSUB231PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 BA /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUB231PS_YMM_YMM_YMMM256: Code = 3549 # type: ignore
"""
``VFMSUB231PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 BA /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUB231PD_XMM_XMM_XMMM128: Code = 3550 # type: ignore
"""
``VFMSUB231PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 BA /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUB231PD_YMM_YMM_YMMM256: Code = 3551 # type: ignore
"""
``VFMSUB231PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 BA /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMSUB231PS_XMM_K1Z_XMM_XMMM128B32: Code = 3552 # type: ignore
"""
``VFMSUB231PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 BA /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB231PS_YMM_K1Z_YMM_YMMM256B32: Code = 3553 # type: ignore
"""
``VFMSUB231PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 BA /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB231PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3554 # type: ignore
"""
``VFMSUB231PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 BA /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB231PD_XMM_K1Z_XMM_XMMM128B64: Code = 3555 # type: ignore
"""
``VFMSUB231PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 BA /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB231PD_YMM_K1Z_YMM_YMMM256B64: Code = 3556 # type: ignore
"""
``VFMSUB231PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 BA /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB231PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3557 # type: ignore
"""
``VFMSUB231PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 BA /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFMSUB231SS_XMM_XMM_XMMM32: Code = 3558 # type: ignore
"""
``VFMSUB231SS xmm1, xmm2, xmm3/m32``

``VEX.LIG.66.0F38.W0 BB /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFMSUB231SD_XMM_XMM_XMMM64: Code = 3559 # type: ignore
"""
``VFMSUB231SD xmm1, xmm2, xmm3/m64``

``VEX.LIG.66.0F38.W1 BB /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFMSUB231SS_XMM_K1Z_XMM_XMMM32_ER: Code = 3560 # type: ignore
"""
``VFMSUB231SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.66.0F38.W0 BB /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFMSUB231SD_XMM_K1Z_XMM_XMMM64_ER: Code = 3561 # type: ignore
"""
``VFMSUB231SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.66.0F38.W1 BB /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFNMADD231PS_XMM_XMM_XMMM128: Code = 3562 # type: ignore
"""
``VFNMADD231PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 BC /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMADD231PS_YMM_YMM_YMMM256: Code = 3563 # type: ignore
"""
``VFNMADD231PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 BC /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMADD231PD_XMM_XMM_XMMM128: Code = 3564 # type: ignore
"""
``VFNMADD231PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 BC /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMADD231PD_YMM_YMM_YMMM256: Code = 3565 # type: ignore
"""
``VFNMADD231PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 BC /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFNMADD231PS_XMM_K1Z_XMM_XMMM128B32: Code = 3566 # type: ignore
"""
``VFNMADD231PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 BC /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD231PS_YMM_K1Z_YMM_YMMM256B32: Code = 3567 # type: ignore
"""
``VFNMADD231PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 BC /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD231PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3568 # type: ignore
"""
``VFNMADD231PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 BC /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD231PD_XMM_K1Z_XMM_XMMM128B64: Code = 3569 # type: ignore
"""
``VFNMADD231PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 BC /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD231PD_YMM_K1Z_YMM_YMMM256B64: Code = 3570 # type: ignore
"""
``VFNMADD231PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 BC /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD231PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3571 # type: ignore
"""
``VFNMADD231PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 BC /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFNMADD231SS_XMM_XMM_XMMM32: Code = 3572 # type: ignore
"""
``VFNMADD231SS xmm1, xmm2, xmm3/m32``

``VEX.LIG.66.0F38.W0 BD /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMADD231SD_XMM_XMM_XMMM64: Code = 3573 # type: ignore
"""
``VFNMADD231SD xmm1, xmm2, xmm3/m64``

``VEX.LIG.66.0F38.W1 BD /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFNMADD231SS_XMM_K1Z_XMM_XMMM32_ER: Code = 3574 # type: ignore
"""
``VFNMADD231SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.66.0F38.W0 BD /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMADD231SD_XMM_K1Z_XMM_XMMM64_ER: Code = 3575 # type: ignore
"""
``VFNMADD231SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.66.0F38.W1 BD /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFNMSUB231PS_XMM_XMM_XMMM128: Code = 3576 # type: ignore
"""
``VFNMSUB231PS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 BE /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMSUB231PS_YMM_YMM_YMMM256: Code = 3577 # type: ignore
"""
``VFNMSUB231PS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 BE /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMSUB231PD_XMM_XMM_XMMM128: Code = 3578 # type: ignore
"""
``VFNMSUB231PD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 BE /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMSUB231PD_YMM_YMM_YMMM256: Code = 3579 # type: ignore
"""
``VFNMSUB231PD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 BE /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFNMSUB231PS_XMM_K1Z_XMM_XMMM128B32: Code = 3580 # type: ignore
"""
``VFNMSUB231PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.66.0F38.W0 BE /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB231PS_YMM_K1Z_YMM_YMMM256B32: Code = 3581 # type: ignore
"""
``VFNMSUB231PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.66.0F38.W0 BE /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB231PS_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 3582 # type: ignore
"""
``VFNMSUB231PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.66.0F38.W0 BE /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB231PD_XMM_K1Z_XMM_XMMM128B64: Code = 3583 # type: ignore
"""
``VFNMSUB231PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst``

``EVEX.128.66.0F38.W1 BE /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB231PD_YMM_K1Z_YMM_YMMM256B64: Code = 3584 # type: ignore
"""
``VFNMSUB231PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst``

``EVEX.256.66.0F38.W1 BE /r``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB231PD_ZMM_K1Z_ZMM_ZMMM512B64_ER: Code = 3585 # type: ignore
"""
``VFNMSUB231PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}``

``EVEX.512.66.0F38.W1 BE /r``

``AVX512F``

``16/32/64-bit``
"""
VEX_VFNMSUB231SS_XMM_XMM_XMMM32: Code = 3586 # type: ignore
"""
``VFNMSUB231SS xmm1, xmm2, xmm3/m32``

``VEX.LIG.66.0F38.W0 BF /r``

``FMA``

``16/32/64-bit``
"""
VEX_VFNMSUB231SD_XMM_XMM_XMMM64: Code = 3587 # type: ignore
"""
``VFNMSUB231SD xmm1, xmm2, xmm3/m64``

``VEX.LIG.66.0F38.W1 BF /r``

``FMA``

``16/32/64-bit``
"""
EVEX_VFNMSUB231SS_XMM_K1Z_XMM_XMMM32_ER: Code = 3588 # type: ignore
"""
``VFNMSUB231SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.66.0F38.W0 BF /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFNMSUB231SD_XMM_K1Z_XMM_XMMM64_ER: Code = 3589 # type: ignore
"""
``VFNMSUB231SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.66.0F38.W1 BF /r``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPCONFLICTD_XMM_K1Z_XMMM128B32: Code = 3590 # type: ignore
"""
``VPCONFLICTD xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.66.0F38.W0 C4 /r``

``AVX512VL and AVX512CD``

``16/32/64-bit``
"""
EVEX_VPCONFLICTD_YMM_K1Z_YMMM256B32: Code = 3591 # type: ignore
"""
``VPCONFLICTD ymm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.66.0F38.W0 C4 /r``

``AVX512VL and AVX512CD``

``16/32/64-bit``
"""
EVEX_VPCONFLICTD_ZMM_K1Z_ZMMM512B32: Code = 3592 # type: ignore
"""
``VPCONFLICTD zmm1 {k1}{z}, zmm2/m512/m32bcst``

``EVEX.512.66.0F38.W0 C4 /r``

``AVX512CD``

``16/32/64-bit``
"""
EVEX_VPCONFLICTQ_XMM_K1Z_XMMM128B64: Code = 3593 # type: ignore
"""
``VPCONFLICTQ xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.66.0F38.W1 C4 /r``

``AVX512VL and AVX512CD``

``16/32/64-bit``
"""
EVEX_VPCONFLICTQ_YMM_K1Z_YMMM256B64: Code = 3594 # type: ignore
"""
``VPCONFLICTQ ymm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.66.0F38.W1 C4 /r``

``AVX512VL and AVX512CD``

``16/32/64-bit``
"""
EVEX_VPCONFLICTQ_ZMM_K1Z_ZMMM512B64: Code = 3595 # type: ignore
"""
``VPCONFLICTQ zmm1 {k1}{z}, zmm2/m512/m64bcst``

``EVEX.512.66.0F38.W1 C4 /r``

``AVX512CD``

``16/32/64-bit``
"""
EVEX_VGATHERPF0DPS_VM32Z_K1: Code = 3596 # type: ignore
"""
``VGATHERPF0DPS vm32z {k1}``

``EVEX.512.66.0F38.W0 C6 /1 /vsib``

``AVX512PF``

``16/32/64-bit``
"""
EVEX_VGATHERPF0DPD_VM32Y_K1: Code = 3597 # type: ignore
"""
``VGATHERPF0DPD vm32y {k1}``

``EVEX.512.66.0F38.W1 C6 /1 /vsib``

``AVX512PF``

``16/32/64-bit``
"""
EVEX_VGATHERPF1DPS_VM32Z_K1: Code = 3598 # type: ignore
"""
``VGATHERPF1DPS vm32z {k1}``

``EVEX.512.66.0F38.W0 C6 /2 /vsib``

``AVX512PF``

``16/32/64-bit``
"""
EVEX_VGATHERPF1DPD_VM32Y_K1: Code = 3599 # type: ignore
"""
``VGATHERPF1DPD vm32y {k1}``

``EVEX.512.66.0F38.W1 C6 /2 /vsib``

``AVX512PF``

``16/32/64-bit``
"""
EVEX_VSCATTERPF0DPS_VM32Z_K1: Code = 3600 # type: ignore
"""
``VSCATTERPF0DPS vm32z {k1}``

``EVEX.512.66.0F38.W0 C6 /5 /vsib``

``AVX512PF``

``16/32/64-bit``
"""
EVEX_VSCATTERPF0DPD_VM32Y_K1: Code = 3601 # type: ignore
"""
``VSCATTERPF0DPD vm32y {k1}``

``EVEX.512.66.0F38.W1 C6 /5 /vsib``

``AVX512PF``

``16/32/64-bit``
"""
EVEX_VSCATTERPF1DPS_VM32Z_K1: Code = 3602 # type: ignore
"""
``VSCATTERPF1DPS vm32z {k1}``

``EVEX.512.66.0F38.W0 C6 /6 /vsib``

``AVX512PF``

``16/32/64-bit``
"""
EVEX_VSCATTERPF1DPD_VM32Y_K1: Code = 3603 # type: ignore
"""
``VSCATTERPF1DPD vm32y {k1}``

``EVEX.512.66.0F38.W1 C6 /6 /vsib``

``AVX512PF``

``16/32/64-bit``
"""
EVEX_VGATHERPF0QPS_VM64Z_K1: Code = 3604 # type: ignore
"""
``VGATHERPF0QPS vm64z {k1}``

``EVEX.512.66.0F38.W0 C7 /1 /vsib``

``AVX512PF``

``16/32/64-bit``
"""
EVEX_VGATHERPF0QPD_VM64Z_K1: Code = 3605 # type: ignore
"""
``VGATHERPF0QPD vm64z {k1}``

``EVEX.512.66.0F38.W1 C7 /1 /vsib``

``AVX512PF``

``16/32/64-bit``
"""
EVEX_VGATHERPF1QPS_VM64Z_K1: Code = 3606 # type: ignore
"""
``VGATHERPF1QPS vm64z {k1}``

``EVEX.512.66.0F38.W0 C7 /2 /vsib``

``AVX512PF``

``16/32/64-bit``
"""
EVEX_VGATHERPF1QPD_VM64Z_K1: Code = 3607 # type: ignore
"""
``VGATHERPF1QPD vm64z {k1}``

``EVEX.512.66.0F38.W1 C7 /2 /vsib``

``AVX512PF``

``16/32/64-bit``
"""
EVEX_VSCATTERPF0QPS_VM64Z_K1: Code = 3608 # type: ignore
"""
``VSCATTERPF0QPS vm64z {k1}``

``EVEX.512.66.0F38.W0 C7 /5 /vsib``

``AVX512PF``

``16/32/64-bit``
"""
EVEX_VSCATTERPF0QPD_VM64Z_K1: Code = 3609 # type: ignore
"""
``VSCATTERPF0QPD vm64z {k1}``

``EVEX.512.66.0F38.W1 C7 /5 /vsib``

``AVX512PF``

``16/32/64-bit``
"""
EVEX_VSCATTERPF1QPS_VM64Z_K1: Code = 3610 # type: ignore
"""
``VSCATTERPF1QPS vm64z {k1}``

``EVEX.512.66.0F38.W0 C7 /6 /vsib``

``AVX512PF``

``16/32/64-bit``
"""
EVEX_VSCATTERPF1QPD_VM64Z_K1: Code = 3611 # type: ignore
"""
``VSCATTERPF1QPD vm64z {k1}``

``EVEX.512.66.0F38.W1 C7 /6 /vsib``

``AVX512PF``

``16/32/64-bit``
"""
SHA1NEXTE_XMM_XMMM128: Code = 3612 # type: ignore
"""
``SHA1NEXTE xmm1, xmm2/m128``

``NP 0F 38 C8 /r``

``SHA``

``16/32/64-bit``
"""
EVEX_VEXP2PS_ZMM_K1Z_ZMMM512B32_SAE: Code = 3613 # type: ignore
"""
``VEXP2PS zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}``

``EVEX.512.66.0F38.W0 C8 /r``

``AVX512ER``

``16/32/64-bit``
"""
EVEX_VEXP2PD_ZMM_K1Z_ZMMM512B64_SAE: Code = 3614 # type: ignore
"""
``VEXP2PD zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}``

``EVEX.512.66.0F38.W1 C8 /r``

``AVX512ER``

``16/32/64-bit``
"""
SHA1MSG1_XMM_XMMM128: Code = 3615 # type: ignore
"""
``SHA1MSG1 xmm1, xmm2/m128``

``NP 0F 38 C9 /r``

``SHA``

``16/32/64-bit``
"""
SHA1MSG2_XMM_XMMM128: Code = 3616 # type: ignore
"""
``SHA1MSG2 xmm1, xmm2/m128``

``NP 0F 38 CA /r``

``SHA``

``16/32/64-bit``
"""
EVEX_VRCP28PS_ZMM_K1Z_ZMMM512B32_SAE: Code = 3617 # type: ignore
"""
``VRCP28PS zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}``

``EVEX.512.66.0F38.W0 CA /r``

``AVX512ER``

``16/32/64-bit``
"""
EVEX_VRCP28PD_ZMM_K1Z_ZMMM512B64_SAE: Code = 3618 # type: ignore
"""
``VRCP28PD zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}``

``EVEX.512.66.0F38.W1 CA /r``

``AVX512ER``

``16/32/64-bit``
"""
SHA256RNDS2_XMM_XMMM128: Code = 3619 # type: ignore
"""
``SHA256RNDS2 xmm1, xmm2/m128, <XMM0>``

``NP 0F 38 CB /r``

``SHA``

``16/32/64-bit``
"""
EVEX_VRCP28SS_XMM_K1Z_XMM_XMMM32_SAE: Code = 3620 # type: ignore
"""
``VRCP28SS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}``

``EVEX.LIG.66.0F38.W0 CB /r``

``AVX512ER``

``16/32/64-bit``
"""
EVEX_VRCP28SD_XMM_K1Z_XMM_XMMM64_SAE: Code = 3621 # type: ignore
"""
``VRCP28SD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}``

``EVEX.LIG.66.0F38.W1 CB /r``

``AVX512ER``

``16/32/64-bit``
"""
SHA256MSG1_XMM_XMMM128: Code = 3622 # type: ignore
"""
``SHA256MSG1 xmm1, xmm2/m128``

``NP 0F 38 CC /r``

``SHA``

``16/32/64-bit``
"""
EVEX_VRSQRT28PS_ZMM_K1Z_ZMMM512B32_SAE: Code = 3623 # type: ignore
"""
``VRSQRT28PS zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}``

``EVEX.512.66.0F38.W0 CC /r``

``AVX512ER``

``16/32/64-bit``
"""
EVEX_VRSQRT28PD_ZMM_K1Z_ZMMM512B64_SAE: Code = 3624 # type: ignore
"""
``VRSQRT28PD zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}``

``EVEX.512.66.0F38.W1 CC /r``

``AVX512ER``

``16/32/64-bit``
"""
SHA256MSG2_XMM_XMMM128: Code = 3625 # type: ignore
"""
``SHA256MSG2 xmm1, xmm2/m128``

``NP 0F 38 CD /r``

``SHA``

``16/32/64-bit``
"""
EVEX_VRSQRT28SS_XMM_K1Z_XMM_XMMM32_SAE: Code = 3626 # type: ignore
"""
``VRSQRT28SS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}``

``EVEX.LIG.66.0F38.W0 CD /r``

``AVX512ER``

``16/32/64-bit``
"""
EVEX_VRSQRT28SD_XMM_K1Z_XMM_XMMM64_SAE: Code = 3627 # type: ignore
"""
``VRSQRT28SD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}``

``EVEX.LIG.66.0F38.W1 CD /r``

``AVX512ER``

``16/32/64-bit``
"""
GF2P8MULB_XMM_XMMM128: Code = 3628 # type: ignore
"""
``GF2P8MULB xmm1, xmm2/m128``

``66 0F 38 CF /r``

``GFNI``

``16/32/64-bit``
"""
VEX_VGF2P8MULB_XMM_XMM_XMMM128: Code = 3629 # type: ignore
"""
``VGF2P8MULB xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 CF /r``

``AVX and GFNI``

``16/32/64-bit``
"""
VEX_VGF2P8MULB_YMM_YMM_YMMM256: Code = 3630 # type: ignore
"""
``VGF2P8MULB ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 CF /r``

``AVX and GFNI``

``16/32/64-bit``
"""
EVEX_VGF2P8MULB_XMM_K1Z_XMM_XMMM128: Code = 3631 # type: ignore
"""
``VGF2P8MULB xmm1 {k1}{z}, xmm2, xmm3/m128``

``EVEX.128.66.0F38.W0 CF /r``

``AVX512VL and GFNI``

``16/32/64-bit``
"""
EVEX_VGF2P8MULB_YMM_K1Z_YMM_YMMM256: Code = 3632 # type: ignore
"""
``VGF2P8MULB ymm1 {k1}{z}, ymm2, ymm3/m256``

``EVEX.256.66.0F38.W0 CF /r``

``AVX512VL and GFNI``

``16/32/64-bit``
"""
EVEX_VGF2P8MULB_ZMM_K1Z_ZMM_ZMMM512: Code = 3633 # type: ignore
"""
``VGF2P8MULB zmm1 {k1}{z}, zmm2, zmm3/m512``

``EVEX.512.66.0F38.W0 CF /r``

``AVX512F and GFNI``

``16/32/64-bit``
"""
AESIMC_XMM_XMMM128: Code = 3634 # type: ignore
"""
``AESIMC xmm1, xmm2/m128``

``66 0F 38 DB /r``

``AES``

``16/32/64-bit``
"""
VEX_VAESIMC_XMM_XMMM128: Code = 3635 # type: ignore
"""
``VAESIMC xmm1, xmm2/m128``

``VEX.128.66.0F38.WIG DB /r``

``AES and AVX``

``16/32/64-bit``
"""
AESENC_XMM_XMMM128: Code = 3636 # type: ignore
"""
``AESENC xmm1, xmm2/m128``

``66 0F 38 DC /r``

``AES``

``16/32/64-bit``
"""
VEX_VAESENC_XMM_XMM_XMMM128: Code = 3637 # type: ignore
"""
``VAESENC xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG DC /r``

``AES and AVX``

``16/32/64-bit``
"""
VEX_VAESENC_YMM_YMM_YMMM256: Code = 3638 # type: ignore
"""
``VAESENC ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG DC /r``

``VAES``

``16/32/64-bit``
"""
EVEX_VAESENC_XMM_XMM_XMMM128: Code = 3639 # type: ignore
"""
``VAESENC xmm1, xmm2, xmm3/m128``

``EVEX.128.66.0F38.WIG DC /r``

``AVX512VL and VAES``

``16/32/64-bit``
"""
EVEX_VAESENC_YMM_YMM_YMMM256: Code = 3640 # type: ignore
"""
``VAESENC ymm1, ymm2, ymm3/m256``

``EVEX.256.66.0F38.WIG DC /r``

``AVX512VL and VAES``

``16/32/64-bit``
"""
EVEX_VAESENC_ZMM_ZMM_ZMMM512: Code = 3641 # type: ignore
"""
``VAESENC zmm1, zmm2, zmm3/m512``

``EVEX.512.66.0F38.WIG DC /r``

``AVX512F and VAES``

``16/32/64-bit``
"""
AESENCLAST_XMM_XMMM128: Code = 3642 # type: ignore
"""
``AESENCLAST xmm1, xmm2/m128``

``66 0F 38 DD /r``

``AES``

``16/32/64-bit``
"""
VEX_VAESENCLAST_XMM_XMM_XMMM128: Code = 3643 # type: ignore
"""
``VAESENCLAST xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG DD /r``

``AES and AVX``

``16/32/64-bit``
"""
VEX_VAESENCLAST_YMM_YMM_YMMM256: Code = 3644 # type: ignore
"""
``VAESENCLAST ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG DD /r``

``VAES``

``16/32/64-bit``
"""
EVEX_VAESENCLAST_XMM_XMM_XMMM128: Code = 3645 # type: ignore
"""
``VAESENCLAST xmm1, xmm2, xmm3/m128``

``EVEX.128.66.0F38.WIG DD /r``

``AVX512VL and VAES``

``16/32/64-bit``
"""
EVEX_VAESENCLAST_YMM_YMM_YMMM256: Code = 3646 # type: ignore
"""
``VAESENCLAST ymm1, ymm2, ymm3/m256``

``EVEX.256.66.0F38.WIG DD /r``

``AVX512VL and VAES``

``16/32/64-bit``
"""
EVEX_VAESENCLAST_ZMM_ZMM_ZMMM512: Code = 3647 # type: ignore
"""
``VAESENCLAST zmm1, zmm2, zmm3/m512``

``EVEX.512.66.0F38.WIG DD /r``

``AVX512F and VAES``

``16/32/64-bit``
"""
AESDEC_XMM_XMMM128: Code = 3648 # type: ignore
"""
``AESDEC xmm1, xmm2/m128``

``66 0F 38 DE /r``

``AES``

``16/32/64-bit``
"""
VEX_VAESDEC_XMM_XMM_XMMM128: Code = 3649 # type: ignore
"""
``VAESDEC xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG DE /r``

``AES and AVX``

``16/32/64-bit``
"""
VEX_VAESDEC_YMM_YMM_YMMM256: Code = 3650 # type: ignore
"""
``VAESDEC ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG DE /r``

``VAES``

``16/32/64-bit``
"""
EVEX_VAESDEC_XMM_XMM_XMMM128: Code = 3651 # type: ignore
"""
``VAESDEC xmm1, xmm2, xmm3/m128``

``EVEX.128.66.0F38.WIG DE /r``

``AVX512VL and VAES``

``16/32/64-bit``
"""
EVEX_VAESDEC_YMM_YMM_YMMM256: Code = 3652 # type: ignore
"""
``VAESDEC ymm1, ymm2, ymm3/m256``

``EVEX.256.66.0F38.WIG DE /r``

``AVX512VL and VAES``

``16/32/64-bit``
"""
EVEX_VAESDEC_ZMM_ZMM_ZMMM512: Code = 3653 # type: ignore
"""
``VAESDEC zmm1, zmm2, zmm3/m512``

``EVEX.512.66.0F38.WIG DE /r``

``AVX512F and VAES``

``16/32/64-bit``
"""
AESDECLAST_XMM_XMMM128: Code = 3654 # type: ignore
"""
``AESDECLAST xmm1, xmm2/m128``

``66 0F 38 DF /r``

``AES``

``16/32/64-bit``
"""
VEX_VAESDECLAST_XMM_XMM_XMMM128: Code = 3655 # type: ignore
"""
``VAESDECLAST xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.WIG DF /r``

``AES and AVX``

``16/32/64-bit``
"""
VEX_VAESDECLAST_YMM_YMM_YMMM256: Code = 3656 # type: ignore
"""
``VAESDECLAST ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.WIG DF /r``

``VAES``

``16/32/64-bit``
"""
EVEX_VAESDECLAST_XMM_XMM_XMMM128: Code = 3657 # type: ignore
"""
``VAESDECLAST xmm1, xmm2, xmm3/m128``

``EVEX.128.66.0F38.WIG DF /r``

``AVX512VL and VAES``

``16/32/64-bit``
"""
EVEX_VAESDECLAST_YMM_YMM_YMMM256: Code = 3658 # type: ignore
"""
``VAESDECLAST ymm1, ymm2, ymm3/m256``

``EVEX.256.66.0F38.WIG DF /r``

``AVX512VL and VAES``

``16/32/64-bit``
"""
EVEX_VAESDECLAST_ZMM_ZMM_ZMMM512: Code = 3659 # type: ignore
"""
``VAESDECLAST zmm1, zmm2, zmm3/m512``

``EVEX.512.66.0F38.WIG DF /r``

``AVX512F and VAES``

``16/32/64-bit``
"""
MOVBE_R16_M16: Code = 3660 # type: ignore
"""
``MOVBE r16, m16``

``o16 0F 38 F0 /r``

``MOVBE``

``16/32/64-bit``
"""
MOVBE_R32_M32: Code = 3661 # type: ignore
"""
``MOVBE r32, m32``

``o32 0F 38 F0 /r``

``MOVBE``

``16/32/64-bit``
"""
MOVBE_R64_M64: Code = 3662 # type: ignore
"""
``MOVBE r64, m64``

``o64 0F 38 F0 /r``

``MOVBE``

``64-bit``
"""
CRC32_R32_RM8: Code = 3663 # type: ignore
"""
``CRC32 r32, r/m8``

``F2 0F 38 F0 /r``

``SSE4.2``

``16/32/64-bit``
"""
CRC32_R64_RM8: Code = 3664 # type: ignore
"""
``CRC32 r64, r/m8``

``F2 o64 0F 38 F0 /r``

``SSE4.2``

``64-bit``
"""
MOVBE_M16_R16: Code = 3665 # type: ignore
"""
``MOVBE m16, r16``

``o16 0F 38 F1 /r``

``MOVBE``

``16/32/64-bit``
"""
MOVBE_M32_R32: Code = 3666 # type: ignore
"""
``MOVBE m32, r32``

``o32 0F 38 F1 /r``

``MOVBE``

``16/32/64-bit``
"""
MOVBE_M64_R64: Code = 3667 # type: ignore
"""
``MOVBE m64, r64``

``o64 0F 38 F1 /r``

``MOVBE``

``64-bit``
"""
CRC32_R32_RM16: Code = 3668 # type: ignore
"""
``CRC32 r32, r/m16``

``o16 F2 0F 38 F1 /r``

``SSE4.2``

``16/32/64-bit``
"""
CRC32_R32_RM32: Code = 3669 # type: ignore
"""
``CRC32 r32, r/m32``

``o32 F2 0F 38 F1 /r``

``SSE4.2``

``16/32/64-bit``
"""
CRC32_R64_RM64: Code = 3670 # type: ignore
"""
``CRC32 r64, r/m64``

``F2 o64 0F 38 F1 /r``

``SSE4.2``

``64-bit``
"""
VEX_ANDN_R32_R32_RM32: Code = 3671 # type: ignore
"""
``ANDN r32a, r32b, r/m32``

``VEX.LZ.0F38.W0 F2 /r``

``BMI1``

``16/32/64-bit``
"""
VEX_ANDN_R64_R64_RM64: Code = 3672 # type: ignore
"""
``ANDN r64a, r64b, r/m64``

``VEX.LZ.0F38.W1 F2 /r``

``BMI1``

``64-bit``
"""
VEX_BLSR_R32_RM32: Code = 3673 # type: ignore
"""
``BLSR r32, r/m32``

``VEX.LZ.0F38.W0 F3 /1``

``BMI1``

``16/32/64-bit``
"""
VEX_BLSR_R64_RM64: Code = 3674 # type: ignore
"""
``BLSR r64, r/m64``

``VEX.LZ.0F38.W1 F3 /1``

``BMI1``

``64-bit``
"""
VEX_BLSMSK_R32_RM32: Code = 3675 # type: ignore
"""
``BLSMSK r32, r/m32``

``VEX.LZ.0F38.W0 F3 /2``

``BMI1``

``16/32/64-bit``
"""
VEX_BLSMSK_R64_RM64: Code = 3676 # type: ignore
"""
``BLSMSK r64, r/m64``

``VEX.LZ.0F38.W1 F3 /2``

``BMI1``

``64-bit``
"""
VEX_BLSI_R32_RM32: Code = 3677 # type: ignore
"""
``BLSI r32, r/m32``

``VEX.LZ.0F38.W0 F3 /3``

``BMI1``

``16/32/64-bit``
"""
VEX_BLSI_R64_RM64: Code = 3678 # type: ignore
"""
``BLSI r64, r/m64``

``VEX.LZ.0F38.W1 F3 /3``

``BMI1``

``64-bit``
"""
VEX_BZHI_R32_RM32_R32: Code = 3679 # type: ignore
"""
``BZHI r32a, r/m32, r32b``

``VEX.LZ.0F38.W0 F5 /r``

``BMI2``

``16/32/64-bit``
"""
VEX_BZHI_R64_RM64_R64: Code = 3680 # type: ignore
"""
``BZHI r64a, r/m64, r64b``

``VEX.LZ.0F38.W1 F5 /r``

``BMI2``

``64-bit``
"""
WRUSSD_M32_R32: Code = 3681 # type: ignore
"""
``WRUSSD m32, r32``

``66 0F 38 F5 /r``

``CET_SS``

``16/32/64-bit``
"""
WRUSSQ_M64_R64: Code = 3682 # type: ignore
"""
``WRUSSQ m64, r64``

``66 o64 0F 38 F5 /r``

``CET_SS``

``64-bit``
"""
VEX_PEXT_R32_R32_RM32: Code = 3683 # type: ignore
"""
``PEXT r32a, r32b, r/m32``

``VEX.LZ.F3.0F38.W0 F5 /r``

``BMI2``

``16/32/64-bit``
"""
VEX_PEXT_R64_R64_RM64: Code = 3684 # type: ignore
"""
``PEXT r64a, r64b, r/m64``

``VEX.LZ.F3.0F38.W1 F5 /r``

``BMI2``

``64-bit``
"""
VEX_PDEP_R32_R32_RM32: Code = 3685 # type: ignore
"""
``PDEP r32a, r32b, r/m32``

``VEX.LZ.F2.0F38.W0 F5 /r``

``BMI2``

``16/32/64-bit``
"""
VEX_PDEP_R64_R64_RM64: Code = 3686 # type: ignore
"""
``PDEP r64a, r64b, r/m64``

``VEX.LZ.F2.0F38.W1 F5 /r``

``BMI2``

``64-bit``
"""
WRSSD_M32_R32: Code = 3687 # type: ignore
"""
``WRSSD m32, r32``

``NP 0F 38 F6 /r``

``CET_SS``

``16/32/64-bit``
"""
WRSSQ_M64_R64: Code = 3688 # type: ignore
"""
``WRSSQ m64, r64``

``NP o64 0F 38 F6 /r``

``CET_SS``

``64-bit``
"""
ADCX_R32_RM32: Code = 3689 # type: ignore
"""
``ADCX r32, r/m32``

``66 0F 38 F6 /r``

``ADX``

``16/32/64-bit``
"""
ADCX_R64_RM64: Code = 3690 # type: ignore
"""
``ADCX r64, r/m64``

``66 o64 0F 38 F6 /r``

``ADX``

``64-bit``
"""
ADOX_R32_RM32: Code = 3691 # type: ignore
"""
``ADOX r32, r/m32``

``F3 0F 38 F6 /r``

``ADX``

``16/32/64-bit``
"""
ADOX_R64_RM64: Code = 3692 # type: ignore
"""
``ADOX r64, r/m64``

``F3 o64 0F 38 F6 /r``

``ADX``

``64-bit``
"""
VEX_MULX_R32_R32_RM32: Code = 3693 # type: ignore
"""
``MULX r32a, r32b, r/m32``

``VEX.LZ.F2.0F38.W0 F6 /r``

``BMI2``

``16/32/64-bit``
"""
VEX_MULX_R64_R64_RM64: Code = 3694 # type: ignore
"""
``MULX r64a, r64b, r/m64``

``VEX.LZ.F2.0F38.W1 F6 /r``

``BMI2``

``64-bit``
"""
VEX_BEXTR_R32_RM32_R32: Code = 3695 # type: ignore
"""
``BEXTR r32a, r/m32, r32b``

``VEX.LZ.0F38.W0 F7 /r``

``BMI1``

``16/32/64-bit``
"""
VEX_BEXTR_R64_RM64_R64: Code = 3696 # type: ignore
"""
``BEXTR r64a, r/m64, r64b``

``VEX.LZ.0F38.W1 F7 /r``

``BMI1``

``64-bit``
"""
VEX_SHLX_R32_RM32_R32: Code = 3697 # type: ignore
"""
``SHLX r32a, r/m32, r32b``

``VEX.LZ.66.0F38.W0 F7 /r``

``BMI2``

``16/32/64-bit``
"""
VEX_SHLX_R64_RM64_R64: Code = 3698 # type: ignore
"""
``SHLX r64a, r/m64, r64b``

``VEX.LZ.66.0F38.W1 F7 /r``

``BMI2``

``64-bit``
"""
VEX_SARX_R32_RM32_R32: Code = 3699 # type: ignore
"""
``SARX r32a, r/m32, r32b``

``VEX.LZ.F3.0F38.W0 F7 /r``

``BMI2``

``16/32/64-bit``
"""
VEX_SARX_R64_RM64_R64: Code = 3700 # type: ignore
"""
``SARX r64a, r/m64, r64b``

``VEX.LZ.F3.0F38.W1 F7 /r``

``BMI2``

``64-bit``
"""
VEX_SHRX_R32_RM32_R32: Code = 3701 # type: ignore
"""
``SHRX r32a, r/m32, r32b``

``VEX.LZ.F2.0F38.W0 F7 /r``

``BMI2``

``16/32/64-bit``
"""
VEX_SHRX_R64_RM64_R64: Code = 3702 # type: ignore
"""
``SHRX r64a, r/m64, r64b``

``VEX.LZ.F2.0F38.W1 F7 /r``

``BMI2``

``64-bit``
"""
MOVDIR64B_R16_M512: Code = 3703 # type: ignore
"""
``MOVDIR64B r16, m512``

``a16 66 0F 38 F8 /r``

``MOVDIR64B``

``16/32-bit``
"""
MOVDIR64B_R32_M512: Code = 3704 # type: ignore
"""
``MOVDIR64B r32, m512``

``a32 66 0F 38 F8 /r``

``MOVDIR64B``

``16/32/64-bit``
"""
MOVDIR64B_R64_M512: Code = 3705 # type: ignore
"""
``MOVDIR64B r64, m512``

``a64 66 0F 38 F8 /r``

``MOVDIR64B``

``64-bit``
"""
ENQCMDS_R16_M512: Code = 3706 # type: ignore
"""
``ENQCMDS r16, m512``

``a16 F3 0F 38 F8 !(11):rrr:bbb``

``ENQCMD``

``16/32-bit``
"""
ENQCMDS_R32_M512: Code = 3707 # type: ignore
"""
``ENQCMDS r32, m512``

``a32 F3 0F 38 F8 !(11):rrr:bbb``

``ENQCMD``

``16/32/64-bit``
"""
ENQCMDS_R64_M512: Code = 3708 # type: ignore
"""
``ENQCMDS r64, m512``

``a64 F3 0F 38 F8 !(11):rrr:bbb``

``ENQCMD``

``64-bit``
"""
ENQCMD_R16_M512: Code = 3709 # type: ignore
"""
``ENQCMD r16, m512``

``a16 F2 0F 38 F8 !(11):rrr:bbb``

``ENQCMD``

``16/32-bit``
"""
ENQCMD_R32_M512: Code = 3710 # type: ignore
"""
``ENQCMD r32, m512``

``a32 F2 0F 38 F8 !(11):rrr:bbb``

``ENQCMD``

``16/32/64-bit``
"""
ENQCMD_R64_M512: Code = 3711 # type: ignore
"""
``ENQCMD r64, m512``

``a64 F2 0F 38 F8 !(11):rrr:bbb``

``ENQCMD``

``64-bit``
"""
MOVDIRI_M32_R32: Code = 3712 # type: ignore
"""
``MOVDIRI m32, r32``

``NP 0F 38 F9 /r``

``MOVDIRI``

``16/32/64-bit``
"""
MOVDIRI_M64_R64: Code = 3713 # type: ignore
"""
``MOVDIRI m64, r64``

``NP o64 0F 38 F9 /r``

``MOVDIRI``

``64-bit``
"""
VEX_VPERMQ_YMM_YMMM256_IMM8: Code = 3714 # type: ignore
"""
``VPERMQ ymm1, ymm2/m256, imm8``

``VEX.256.66.0F3A.W1 00 /r ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPERMQ_YMM_K1Z_YMMM256B64_IMM8: Code = 3715 # type: ignore
"""
``VPERMQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 00 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMQ_ZMM_K1Z_ZMMM512B64_IMM8: Code = 3716 # type: ignore
"""
``VPERMQ zmm1 {k1}{z}, zmm2/m512/m64bcst, imm8``

``EVEX.512.66.0F3A.W1 00 /r ib``

``AVX512F``

``16/32/64-bit``
"""
VEX_VPERMPD_YMM_YMMM256_IMM8: Code = 3717 # type: ignore
"""
``VPERMPD ymm1, ymm2/m256, imm8``

``VEX.256.66.0F3A.W1 01 /r ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPERMPD_YMM_K1Z_YMMM256B64_IMM8: Code = 3718 # type: ignore
"""
``VPERMPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 01 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMPD_ZMM_K1Z_ZMMM512B64_IMM8: Code = 3719 # type: ignore
"""
``VPERMPD zmm1 {k1}{z}, zmm2/m512/m64bcst, imm8``

``EVEX.512.66.0F3A.W1 01 /r ib``

``AVX512F``

``16/32/64-bit``
"""
VEX_VPBLENDD_XMM_XMM_XMMM128_IMM8: Code = 3720 # type: ignore
"""
``VPBLENDD xmm1, xmm2, xmm3/m128, imm8``

``VEX.128.66.0F3A.W0 02 /r ib``

``AVX2``

``16/32/64-bit``
"""
VEX_VPBLENDD_YMM_YMM_YMMM256_IMM8: Code = 3721 # type: ignore
"""
``VPBLENDD ymm1, ymm2, ymm3/m256, imm8``

``VEX.256.66.0F3A.W0 02 /r ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VALIGND_XMM_K1Z_XMM_XMMM128B32_IMM8: Code = 3722 # type: ignore
"""
``VALIGND xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8``

``EVEX.128.66.0F3A.W0 03 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VALIGND_YMM_K1Z_YMM_YMMM256B32_IMM8: Code = 3723 # type: ignore
"""
``VALIGND ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8``

``EVEX.256.66.0F3A.W0 03 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VALIGND_ZMM_K1Z_ZMM_ZMMM512B32_IMM8: Code = 3724 # type: ignore
"""
``VALIGND zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst, imm8``

``EVEX.512.66.0F3A.W0 03 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VALIGNQ_XMM_K1Z_XMM_XMMM128B64_IMM8: Code = 3725 # type: ignore
"""
``VALIGNQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8``

``EVEX.128.66.0F3A.W1 03 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VALIGNQ_YMM_K1Z_YMM_YMMM256B64_IMM8: Code = 3726 # type: ignore
"""
``VALIGNQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 03 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VALIGNQ_ZMM_K1Z_ZMM_ZMMM512B64_IMM8: Code = 3727 # type: ignore
"""
``VALIGNQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8``

``EVEX.512.66.0F3A.W1 03 /r ib``

``AVX512F``

``16/32/64-bit``
"""
VEX_VPERMILPS_XMM_XMMM128_IMM8: Code = 3728 # type: ignore
"""
``VPERMILPS xmm1, xmm2/m128, imm8``

``VEX.128.66.0F3A.W0 04 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPERMILPS_YMM_YMMM256_IMM8: Code = 3729 # type: ignore
"""
``VPERMILPS ymm1, ymm2/m256, imm8``

``VEX.256.66.0F3A.W0 04 /r ib``

``AVX``

``16/32/64-bit``
"""
EVEX_VPERMILPS_XMM_K1Z_XMMM128B32_IMM8: Code = 3730 # type: ignore
"""
``VPERMILPS xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8``

``EVEX.128.66.0F3A.W0 04 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMILPS_YMM_K1Z_YMMM256B32_IMM8: Code = 3731 # type: ignore
"""
``VPERMILPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8``

``EVEX.256.66.0F3A.W0 04 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMILPS_ZMM_K1Z_ZMMM512B32_IMM8: Code = 3732 # type: ignore
"""
``VPERMILPS zmm1 {k1}{z}, zmm2/m512/m32bcst, imm8``

``EVEX.512.66.0F3A.W0 04 /r ib``

``AVX512F``

``16/32/64-bit``
"""
VEX_VPERMILPD_XMM_XMMM128_IMM8: Code = 3733 # type: ignore
"""
``VPERMILPD xmm1, xmm2/m128, imm8``

``VEX.128.66.0F3A.W0 05 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPERMILPD_YMM_YMMM256_IMM8: Code = 3734 # type: ignore
"""
``VPERMILPD ymm1, ymm2/m256, imm8``

``VEX.256.66.0F3A.W0 05 /r ib``

``AVX``

``16/32/64-bit``
"""
EVEX_VPERMILPD_XMM_K1Z_XMMM128B64_IMM8: Code = 3735 # type: ignore
"""
``VPERMILPD xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8``

``EVEX.128.66.0F3A.W1 05 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMILPD_YMM_K1Z_YMMM256B64_IMM8: Code = 3736 # type: ignore
"""
``VPERMILPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 05 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPERMILPD_ZMM_K1Z_ZMMM512B64_IMM8: Code = 3737 # type: ignore
"""
``VPERMILPD zmm1 {k1}{z}, zmm2/m512/m64bcst, imm8``

``EVEX.512.66.0F3A.W1 05 /r ib``

``AVX512F``

``16/32/64-bit``
"""
VEX_VPERM2F128_YMM_YMM_YMMM256_IMM8: Code = 3738 # type: ignore
"""
``VPERM2F128 ymm1, ymm2, ymm3/m256, imm8``

``VEX.256.66.0F3A.W0 06 /r ib``

``AVX``

``16/32/64-bit``
"""
ROUNDPS_XMM_XMMM128_IMM8: Code = 3739 # type: ignore
"""
``ROUNDPS xmm1, xmm2/m128, imm8``

``66 0F 3A 08 /r ib``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VROUNDPS_XMM_XMMM128_IMM8: Code = 3740 # type: ignore
"""
``VROUNDPS xmm1, xmm2/m128, imm8``

``VEX.128.66.0F3A.WIG 08 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VROUNDPS_YMM_YMMM256_IMM8: Code = 3741 # type: ignore
"""
``VROUNDPS ymm1, ymm2/m256, imm8``

``VEX.256.66.0F3A.WIG 08 /r ib``

``AVX``

``16/32/64-bit``
"""
EVEX_VRNDSCALEPS_XMM_K1Z_XMMM128B32_IMM8: Code = 3742 # type: ignore
"""
``VRNDSCALEPS xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8``

``EVEX.128.66.0F3A.W0 08 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VRNDSCALEPS_YMM_K1Z_YMMM256B32_IMM8: Code = 3743 # type: ignore
"""
``VRNDSCALEPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8``

``EVEX.256.66.0F3A.W0 08 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VRNDSCALEPS_ZMM_K1Z_ZMMM512B32_IMM8_SAE: Code = 3744 # type: ignore
"""
``VRNDSCALEPS zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}, imm8``

``EVEX.512.66.0F3A.W0 08 /r ib``

``AVX512F``

``16/32/64-bit``
"""
ROUNDPD_XMM_XMMM128_IMM8: Code = 3745 # type: ignore
"""
``ROUNDPD xmm1, xmm2/m128, imm8``

``66 0F 3A 09 /r ib``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VROUNDPD_XMM_XMMM128_IMM8: Code = 3746 # type: ignore
"""
``VROUNDPD xmm1, xmm2/m128, imm8``

``VEX.128.66.0F3A.WIG 09 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VROUNDPD_YMM_YMMM256_IMM8: Code = 3747 # type: ignore
"""
``VROUNDPD ymm1, ymm2/m256, imm8``

``VEX.256.66.0F3A.WIG 09 /r ib``

``AVX``

``16/32/64-bit``
"""
EVEX_VRNDSCALEPD_XMM_K1Z_XMMM128B64_IMM8: Code = 3748 # type: ignore
"""
``VRNDSCALEPD xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8``

``EVEX.128.66.0F3A.W1 09 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VRNDSCALEPD_YMM_K1Z_YMMM256B64_IMM8: Code = 3749 # type: ignore
"""
``VRNDSCALEPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 09 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VRNDSCALEPD_ZMM_K1Z_ZMMM512B64_IMM8_SAE: Code = 3750 # type: ignore
"""
``VRNDSCALEPD zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}, imm8``

``EVEX.512.66.0F3A.W1 09 /r ib``

``AVX512F``

``16/32/64-bit``
"""
ROUNDSS_XMM_XMMM32_IMM8: Code = 3751 # type: ignore
"""
``ROUNDSS xmm1, xmm2/m32, imm8``

``66 0F 3A 0A /r ib``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VROUNDSS_XMM_XMM_XMMM32_IMM8: Code = 3752 # type: ignore
"""
``VROUNDSS xmm1, xmm2, xmm3/m32, imm8``

``VEX.LIG.66.0F3A.WIG 0A /r ib``

``AVX``

``16/32/64-bit``
"""
EVEX_VRNDSCALESS_XMM_K1Z_XMM_XMMM32_IMM8_SAE: Code = 3753 # type: ignore
"""
``VRNDSCALESS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}, imm8``

``EVEX.LIG.66.0F3A.W0 0A /r ib``

``AVX512F``

``16/32/64-bit``
"""
ROUNDSD_XMM_XMMM64_IMM8: Code = 3754 # type: ignore
"""
``ROUNDSD xmm1, xmm2/m64, imm8``

``66 0F 3A 0B /r ib``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VROUNDSD_XMM_XMM_XMMM64_IMM8: Code = 3755 # type: ignore
"""
``VROUNDSD xmm1, xmm2, xmm3/m64, imm8``

``VEX.LIG.66.0F3A.WIG 0B /r ib``

``AVX``

``16/32/64-bit``
"""
EVEX_VRNDSCALESD_XMM_K1Z_XMM_XMMM64_IMM8_SAE: Code = 3756 # type: ignore
"""
``VRNDSCALESD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}, imm8``

``EVEX.LIG.66.0F3A.W1 0B /r ib``

``AVX512F``

``16/32/64-bit``
"""
BLENDPS_XMM_XMMM128_IMM8: Code = 3757 # type: ignore
"""
``BLENDPS xmm1, xmm2/m128, imm8``

``66 0F 3A 0C /r ib``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VBLENDPS_XMM_XMM_XMMM128_IMM8: Code = 3758 # type: ignore
"""
``VBLENDPS xmm1, xmm2, xmm3/m128, imm8``

``VEX.128.66.0F3A.WIG 0C /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VBLENDPS_YMM_YMM_YMMM256_IMM8: Code = 3759 # type: ignore
"""
``VBLENDPS ymm1, ymm2, ymm3/m256, imm8``

``VEX.256.66.0F3A.WIG 0C /r ib``

``AVX``

``16/32/64-bit``
"""
BLENDPD_XMM_XMMM128_IMM8: Code = 3760 # type: ignore
"""
``BLENDPD xmm1, xmm2/m128, imm8``

``66 0F 3A 0D /r ib``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VBLENDPD_XMM_XMM_XMMM128_IMM8: Code = 3761 # type: ignore
"""
``VBLENDPD xmm1, xmm2, xmm3/m128, imm8``

``VEX.128.66.0F3A.WIG 0D /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VBLENDPD_YMM_YMM_YMMM256_IMM8: Code = 3762 # type: ignore
"""
``VBLENDPD ymm1, ymm2, ymm3/m256, imm8``

``VEX.256.66.0F3A.WIG 0D /r ib``

``AVX``

``16/32/64-bit``
"""
PBLENDW_XMM_XMMM128_IMM8: Code = 3763 # type: ignore
"""
``PBLENDW xmm1, xmm2/m128, imm8``

``66 0F 3A 0E /r ib``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VPBLENDW_XMM_XMM_XMMM128_IMM8: Code = 3764 # type: ignore
"""
``VPBLENDW xmm1, xmm2, xmm3/m128, imm8``

``VEX.128.66.0F3A.WIG 0E /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPBLENDW_YMM_YMM_YMMM256_IMM8: Code = 3765 # type: ignore
"""
``VPBLENDW ymm1, ymm2, ymm3/m256, imm8``

``VEX.256.66.0F3A.WIG 0E /r ib``

``AVX2``

``16/32/64-bit``
"""
PALIGNR_MM_MMM64_IMM8: Code = 3766 # type: ignore
"""
``PALIGNR mm1, mm2/m64, imm8``

``NP 0F 3A 0F /r ib``

``SSSE3``

``16/32/64-bit``
"""
PALIGNR_XMM_XMMM128_IMM8: Code = 3767 # type: ignore
"""
``PALIGNR xmm1, xmm2/m128, imm8``

``66 0F 3A 0F /r ib``

``SSSE3``

``16/32/64-bit``
"""
VEX_VPALIGNR_XMM_XMM_XMMM128_IMM8: Code = 3768 # type: ignore
"""
``VPALIGNR xmm1, xmm2, xmm3/m128, imm8``

``VEX.128.66.0F3A.WIG 0F /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPALIGNR_YMM_YMM_YMMM256_IMM8: Code = 3769 # type: ignore
"""
``VPALIGNR ymm1, ymm2, ymm3/m256, imm8``

``VEX.256.66.0F3A.WIG 0F /r ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VPALIGNR_XMM_K1Z_XMM_XMMM128_IMM8: Code = 3770 # type: ignore
"""
``VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8``

``EVEX.128.66.0F3A.WIG 0F /r ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPALIGNR_YMM_K1Z_YMM_YMMM256_IMM8: Code = 3771 # type: ignore
"""
``VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8``

``EVEX.256.66.0F3A.WIG 0F /r ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPALIGNR_ZMM_K1Z_ZMM_ZMMM512_IMM8: Code = 3772 # type: ignore
"""
``VPALIGNR zmm1 {k1}{z}, zmm2, zmm3/m512, imm8``

``EVEX.512.66.0F3A.WIG 0F /r ib``

``AVX512BW``

``16/32/64-bit``
"""
PEXTRB_R32M8_XMM_IMM8: Code = 3773 # type: ignore
"""
``PEXTRB r32/m8, xmm2, imm8``

``66 0F 3A 14 /r ib``

``SSE4.1``

``16/32/64-bit``
"""
PEXTRB_R64M8_XMM_IMM8: Code = 3774 # type: ignore
"""
``PEXTRB r64/m8, xmm2, imm8``

``66 o64 0F 3A 14 /r ib``

``SSE4.1``

``64-bit``
"""
VEX_VPEXTRB_R32M8_XMM_IMM8: Code = 3775 # type: ignore
"""
``VPEXTRB r32/m8, xmm2, imm8``

``VEX.128.66.0F3A.W0 14 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPEXTRB_R64M8_XMM_IMM8: Code = 3776 # type: ignore
"""
``VPEXTRB r64/m8, xmm2, imm8``

``VEX.128.66.0F3A.W1 14 /r ib``

``AVX``

``64-bit``
"""
EVEX_VPEXTRB_R32M8_XMM_IMM8: Code = 3777 # type: ignore
"""
``VPEXTRB r32/m8, xmm2, imm8``

``EVEX.128.66.0F3A.W0 14 /r ib``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPEXTRB_R64M8_XMM_IMM8: Code = 3778 # type: ignore
"""
``VPEXTRB r64/m8, xmm2, imm8``

``EVEX.128.66.0F3A.W1 14 /r ib``

``AVX512BW``

``64-bit``
"""
PEXTRW_R32M16_XMM_IMM8: Code = 3779 # type: ignore
"""
``PEXTRW r32/m16, xmm, imm8``

``66 0F 3A 15 /r ib``

``SSE4.1``

``16/32/64-bit``
"""
PEXTRW_R64M16_XMM_IMM8: Code = 3780 # type: ignore
"""
``PEXTRW r64/m16, xmm, imm8``

``66 o64 0F 3A 15 /r ib``

``SSE4.1``

``64-bit``
"""
VEX_VPEXTRW_R32M16_XMM_IMM8: Code = 3781 # type: ignore
"""
``VPEXTRW r32/m16, xmm2, imm8``

``VEX.128.66.0F3A.W0 15 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPEXTRW_R64M16_XMM_IMM8: Code = 3782 # type: ignore
"""
``VPEXTRW r64/m16, xmm2, imm8``

``VEX.128.66.0F3A.W1 15 /r ib``

``AVX``

``64-bit``
"""
EVEX_VPEXTRW_R32M16_XMM_IMM8: Code = 3783 # type: ignore
"""
``VPEXTRW r32/m16, xmm2, imm8``

``EVEX.128.66.0F3A.W0 15 /r ib``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPEXTRW_R64M16_XMM_IMM8: Code = 3784 # type: ignore
"""
``VPEXTRW r64/m16, xmm2, imm8``

``EVEX.128.66.0F3A.W1 15 /r ib``

``AVX512BW``

``64-bit``
"""
PEXTRD_RM32_XMM_IMM8: Code = 3785 # type: ignore
"""
``PEXTRD r/m32, xmm2, imm8``

``66 0F 3A 16 /r ib``

``SSE4.1``

``16/32/64-bit``
"""
PEXTRQ_RM64_XMM_IMM8: Code = 3786 # type: ignore
"""
``PEXTRQ r/m64, xmm2, imm8``

``66 o64 0F 3A 16 /r ib``

``SSE4.1``

``64-bit``
"""
VEX_VPEXTRD_RM32_XMM_IMM8: Code = 3787 # type: ignore
"""
``VPEXTRD r/m32, xmm2, imm8``

``VEX.128.66.0F3A.W0 16 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPEXTRQ_RM64_XMM_IMM8: Code = 3788 # type: ignore
"""
``VPEXTRQ r/m64, xmm2, imm8``

``VEX.128.66.0F3A.W1 16 /r ib``

``AVX``

``64-bit``
"""
EVEX_VPEXTRD_RM32_XMM_IMM8: Code = 3789 # type: ignore
"""
``VPEXTRD r/m32, xmm2, imm8``

``EVEX.128.66.0F3A.W0 16 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VPEXTRQ_RM64_XMM_IMM8: Code = 3790 # type: ignore
"""
``VPEXTRQ r/m64, xmm2, imm8``

``EVEX.128.66.0F3A.W1 16 /r ib``

``AVX512DQ``

``64-bit``
"""
EXTRACTPS_RM32_XMM_IMM8: Code = 3791 # type: ignore
"""
``EXTRACTPS r/m32, xmm1, imm8``

``66 0F 3A 17 /r ib``

``SSE4.1``

``16/32/64-bit``
"""
EXTRACTPS_R64M32_XMM_IMM8: Code = 3792 # type: ignore
"""
``EXTRACTPS r64/m32, xmm1, imm8``

``66 o64 0F 3A 17 /r ib``

``SSE4.1``

``64-bit``
"""
VEX_VEXTRACTPS_RM32_XMM_IMM8: Code = 3793 # type: ignore
"""
``VEXTRACTPS r/m32, xmm1, imm8``

``VEX.128.66.0F3A.W0 17 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VEXTRACTPS_R64M32_XMM_IMM8: Code = 3794 # type: ignore
"""
``VEXTRACTPS r64/m32, xmm1, imm8``

``VEX.128.66.0F3A.W1 17 /r ib``

``AVX``

``64-bit``
"""
EVEX_VEXTRACTPS_RM32_XMM_IMM8: Code = 3795 # type: ignore
"""
``VEXTRACTPS r/m32, xmm1, imm8``

``EVEX.128.66.0F3A.W0 17 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VEXTRACTPS_R64M32_XMM_IMM8: Code = 3796 # type: ignore
"""
``VEXTRACTPS r64/m32, xmm1, imm8``

``EVEX.128.66.0F3A.W1 17 /r ib``

``AVX512F``

``64-bit``
"""
VEX_VINSERTF128_YMM_YMM_XMMM128_IMM8: Code = 3797 # type: ignore
"""
``VINSERTF128 ymm1, ymm2, xmm3/m128, imm8``

``VEX.256.66.0F3A.W0 18 /r ib``

``AVX``

``16/32/64-bit``
"""
EVEX_VINSERTF32X4_YMM_K1Z_YMM_XMMM128_IMM8: Code = 3798 # type: ignore
"""
``VINSERTF32X4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8``

``EVEX.256.66.0F3A.W0 18 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VINSERTF32X4_ZMM_K1Z_ZMM_XMMM128_IMM8: Code = 3799 # type: ignore
"""
``VINSERTF32X4 zmm1 {k1}{z}, zmm2, xmm3/m128, imm8``

``EVEX.512.66.0F3A.W0 18 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VINSERTF64X2_YMM_K1Z_YMM_XMMM128_IMM8: Code = 3800 # type: ignore
"""
``VINSERTF64X2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8``

``EVEX.256.66.0F3A.W1 18 /r ib``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VINSERTF64X2_ZMM_K1Z_ZMM_XMMM128_IMM8: Code = 3801 # type: ignore
"""
``VINSERTF64X2 zmm1 {k1}{z}, zmm2, xmm3/m128, imm8``

``EVEX.512.66.0F3A.W1 18 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_VEXTRACTF128_XMMM128_YMM_IMM8: Code = 3802 # type: ignore
"""
``VEXTRACTF128 xmm1/m128, ymm2, imm8``

``VEX.256.66.0F3A.W0 19 /r ib``

``AVX``

``16/32/64-bit``
"""
EVEX_VEXTRACTF32X4_XMMM128_K1Z_YMM_IMM8: Code = 3803 # type: ignore
"""
``VEXTRACTF32X4 xmm1/m128 {k1}{z}, ymm2, imm8``

``EVEX.256.66.0F3A.W0 19 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VEXTRACTF32X4_XMMM128_K1Z_ZMM_IMM8: Code = 3804 # type: ignore
"""
``VEXTRACTF32X4 xmm1/m128 {k1}{z}, zmm2, imm8``

``EVEX.512.66.0F3A.W0 19 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VEXTRACTF64X2_XMMM128_K1Z_YMM_IMM8: Code = 3805 # type: ignore
"""
``VEXTRACTF64X2 xmm1/m128 {k1}{z}, ymm2, imm8``

``EVEX.256.66.0F3A.W1 19 /r ib``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VEXTRACTF64X2_XMMM128_K1Z_ZMM_IMM8: Code = 3806 # type: ignore
"""
``VEXTRACTF64X2 xmm1/m128 {k1}{z}, zmm2, imm8``

``EVEX.512.66.0F3A.W1 19 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VINSERTF32X8_ZMM_K1Z_ZMM_YMMM256_IMM8: Code = 3807 # type: ignore
"""
``VINSERTF32X8 zmm1 {k1}{z}, zmm2, ymm3/m256, imm8``

``EVEX.512.66.0F3A.W0 1A /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VINSERTF64X4_ZMM_K1Z_ZMM_YMMM256_IMM8: Code = 3808 # type: ignore
"""
``VINSERTF64X4 zmm1 {k1}{z}, zmm2, ymm3/m256, imm8``

``EVEX.512.66.0F3A.W1 1A /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VEXTRACTF32X8_YMMM256_K1Z_ZMM_IMM8: Code = 3809 # type: ignore
"""
``VEXTRACTF32X8 ymm1/m256 {k1}{z}, zmm2, imm8``

``EVEX.512.66.0F3A.W0 1B /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VEXTRACTF64X4_YMMM256_K1Z_ZMM_IMM8: Code = 3810 # type: ignore
"""
``VEXTRACTF64X4 ymm1/m256 {k1}{z}, zmm2, imm8``

``EVEX.512.66.0F3A.W1 1B /r ib``

``AVX512F``

``16/32/64-bit``
"""
VEX_VCVTPS2PH_XMMM64_XMM_IMM8: Code = 3811 # type: ignore
"""
``VCVTPS2PH xmm1/m64, xmm2, imm8``

``VEX.128.66.0F3A.W0 1D /r ib``

``F16C``

``16/32/64-bit``
"""
VEX_VCVTPS2PH_XMMM128_YMM_IMM8: Code = 3812 # type: ignore
"""
``VCVTPS2PH xmm1/m128, ymm2, imm8``

``VEX.256.66.0F3A.W0 1D /r ib``

``F16C``

``16/32/64-bit``
"""
EVEX_VCVTPS2PH_XMMM64_K1Z_XMM_IMM8: Code = 3813 # type: ignore
"""
``VCVTPS2PH xmm1/m64 {k1}{z}, xmm2, imm8``

``EVEX.128.66.0F3A.W0 1D /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTPS2PH_XMMM128_K1Z_YMM_IMM8: Code = 3814 # type: ignore
"""
``VCVTPS2PH xmm1/m128 {k1}{z}, ymm2, imm8``

``EVEX.256.66.0F3A.W0 1D /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VCVTPS2PH_YMMM256_K1Z_ZMM_IMM8_SAE: Code = 3815 # type: ignore
"""
``VCVTPS2PH ymm1/m256 {k1}{z}, zmm2{sae}, imm8``

``EVEX.512.66.0F3A.W0 1D /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPUD_KR_K1_XMM_XMMM128B32_IMM8: Code = 3816 # type: ignore
"""
``VPCMPUD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8``

``EVEX.128.66.0F3A.W0 1E /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPUD_KR_K1_YMM_YMMM256B32_IMM8: Code = 3817 # type: ignore
"""
``VPCMPUD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8``

``EVEX.256.66.0F3A.W0 1E /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPUD_KR_K1_ZMM_ZMMM512B32_IMM8: Code = 3818 # type: ignore
"""
``VPCMPUD k1 {k2}, zmm2, zmm3/m512/m32bcst, imm8``

``EVEX.512.66.0F3A.W0 1E /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPUQ_KR_K1_XMM_XMMM128B64_IMM8: Code = 3819 # type: ignore
"""
``VPCMPUQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8``

``EVEX.128.66.0F3A.W1 1E /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPUQ_KR_K1_YMM_YMMM256B64_IMM8: Code = 3820 # type: ignore
"""
``VPCMPUQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 1E /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPUQ_KR_K1_ZMM_ZMMM512B64_IMM8: Code = 3821 # type: ignore
"""
``VPCMPUQ k1 {k2}, zmm2, zmm3/m512/m64bcst, imm8``

``EVEX.512.66.0F3A.W1 1E /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPD_KR_K1_XMM_XMMM128B32_IMM8: Code = 3822 # type: ignore
"""
``VPCMPD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8``

``EVEX.128.66.0F3A.W0 1F /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPD_KR_K1_YMM_YMMM256B32_IMM8: Code = 3823 # type: ignore
"""
``VPCMPD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8``

``EVEX.256.66.0F3A.W0 1F /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPD_KR_K1_ZMM_ZMMM512B32_IMM8: Code = 3824 # type: ignore
"""
``VPCMPD k1 {k2}, zmm2, zmm3/m512/m32bcst, imm8``

``EVEX.512.66.0F3A.W0 1F /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPQ_KR_K1_XMM_XMMM128B64_IMM8: Code = 3825 # type: ignore
"""
``VPCMPQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8``

``EVEX.128.66.0F3A.W1 1F /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPQ_KR_K1_YMM_YMMM256B64_IMM8: Code = 3826 # type: ignore
"""
``VPCMPQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 1F /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPQ_KR_K1_ZMM_ZMMM512B64_IMM8: Code = 3827 # type: ignore
"""
``VPCMPQ k1 {k2}, zmm2, zmm3/m512/m64bcst, imm8``

``EVEX.512.66.0F3A.W1 1F /r ib``

``AVX512F``

``16/32/64-bit``
"""
PINSRB_XMM_R32M8_IMM8: Code = 3828 # type: ignore
"""
``PINSRB xmm1, r32/m8, imm8``

``66 0F 3A 20 /r ib``

``SSE4.1``

``16/32/64-bit``
"""
PINSRB_XMM_R64M8_IMM8: Code = 3829 # type: ignore
"""
``PINSRB xmm1, r64/m8, imm8``

``66 o64 0F 3A 20 /r ib``

``SSE4.1``

``64-bit``
"""
VEX_VPINSRB_XMM_XMM_R32M8_IMM8: Code = 3830 # type: ignore
"""
``VPINSRB xmm1, xmm2, r32/m8, imm8``

``VEX.128.66.0F3A.W0 20 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPINSRB_XMM_XMM_R64M8_IMM8: Code = 3831 # type: ignore
"""
``VPINSRB xmm1, xmm2, r64/m8, imm8``

``VEX.128.66.0F3A.W1 20 /r ib``

``AVX``

``64-bit``
"""
EVEX_VPINSRB_XMM_XMM_R32M8_IMM8: Code = 3832 # type: ignore
"""
``VPINSRB xmm1, xmm2, r32/m8, imm8``

``EVEX.128.66.0F3A.W0 20 /r ib``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPINSRB_XMM_XMM_R64M8_IMM8: Code = 3833 # type: ignore
"""
``VPINSRB xmm1, xmm2, r64/m8, imm8``

``EVEX.128.66.0F3A.W1 20 /r ib``

``AVX512BW``

``64-bit``
"""
INSERTPS_XMM_XMMM32_IMM8: Code = 3834 # type: ignore
"""
``INSERTPS xmm1, xmm2/m32, imm8``

``66 0F 3A 21 /r ib``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VINSERTPS_XMM_XMM_XMMM32_IMM8: Code = 3835 # type: ignore
"""
``VINSERTPS xmm1, xmm2, xmm3/m32, imm8``

``VEX.128.66.0F3A.WIG 21 /r ib``

``AVX``

``16/32/64-bit``
"""
EVEX_VINSERTPS_XMM_XMM_XMMM32_IMM8: Code = 3836 # type: ignore
"""
``VINSERTPS xmm1, xmm2, xmm3/m32, imm8``

``EVEX.128.66.0F3A.W0 21 /r ib``

``AVX512F``

``16/32/64-bit``
"""
PINSRD_XMM_RM32_IMM8: Code = 3837 # type: ignore
"""
``PINSRD xmm1, r/m32, imm8``

``66 0F 3A 22 /r ib``

``SSE4.1``

``16/32/64-bit``
"""
PINSRQ_XMM_RM64_IMM8: Code = 3838 # type: ignore
"""
``PINSRQ xmm1, r/m64, imm8``

``66 o64 0F 3A 22 /r ib``

``SSE4.1``

``64-bit``
"""
VEX_VPINSRD_XMM_XMM_RM32_IMM8: Code = 3839 # type: ignore
"""
``VPINSRD xmm1, xmm2, r/m32, imm8``

``VEX.128.66.0F3A.W0 22 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPINSRQ_XMM_XMM_RM64_IMM8: Code = 3840 # type: ignore
"""
``VPINSRQ xmm1, xmm2, r/m64, imm8``

``VEX.128.66.0F3A.W1 22 /r ib``

``AVX``

``64-bit``
"""
EVEX_VPINSRD_XMM_XMM_RM32_IMM8: Code = 3841 # type: ignore
"""
``VPINSRD xmm1, xmm2, r/m32, imm8``

``EVEX.128.66.0F3A.W0 22 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VPINSRQ_XMM_XMM_RM64_IMM8: Code = 3842 # type: ignore
"""
``VPINSRQ xmm1, xmm2, r/m64, imm8``

``EVEX.128.66.0F3A.W1 22 /r ib``

``AVX512DQ``

``64-bit``
"""
EVEX_VSHUFF32X4_YMM_K1Z_YMM_YMMM256B32_IMM8: Code = 3843 # type: ignore
"""
``VSHUFF32X4 ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8``

``EVEX.256.66.0F3A.W0 23 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSHUFF32X4_ZMM_K1Z_ZMM_ZMMM512B32_IMM8: Code = 3844 # type: ignore
"""
``VSHUFF32X4 zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst, imm8``

``EVEX.512.66.0F3A.W0 23 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VSHUFF64X2_YMM_K1Z_YMM_YMMM256B64_IMM8: Code = 3845 # type: ignore
"""
``VSHUFF64X2 ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 23 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSHUFF64X2_ZMM_K1Z_ZMM_ZMMM512B64_IMM8: Code = 3846 # type: ignore
"""
``VSHUFF64X2 zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8``

``EVEX.512.66.0F3A.W1 23 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPTERNLOGD_XMM_K1Z_XMM_XMMM128B32_IMM8: Code = 3847 # type: ignore
"""
``VPTERNLOGD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8``

``EVEX.128.66.0F3A.W0 25 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPTERNLOGD_YMM_K1Z_YMM_YMMM256B32_IMM8: Code = 3848 # type: ignore
"""
``VPTERNLOGD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8``

``EVEX.256.66.0F3A.W0 25 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPTERNLOGD_ZMM_K1Z_ZMM_ZMMM512B32_IMM8: Code = 3849 # type: ignore
"""
``VPTERNLOGD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst, imm8``

``EVEX.512.66.0F3A.W0 25 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPTERNLOGQ_XMM_K1Z_XMM_XMMM128B64_IMM8: Code = 3850 # type: ignore
"""
``VPTERNLOGQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8``

``EVEX.128.66.0F3A.W1 25 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPTERNLOGQ_YMM_K1Z_YMM_YMMM256B64_IMM8: Code = 3851 # type: ignore
"""
``VPTERNLOGQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 25 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VPTERNLOGQ_ZMM_K1Z_ZMM_ZMMM512B64_IMM8: Code = 3852 # type: ignore
"""
``VPTERNLOGQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8``

``EVEX.512.66.0F3A.W1 25 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VGETMANTPS_XMM_K1Z_XMMM128B32_IMM8: Code = 3853 # type: ignore
"""
``VGETMANTPS xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8``

``EVEX.128.66.0F3A.W0 26 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VGETMANTPS_YMM_K1Z_YMMM256B32_IMM8: Code = 3854 # type: ignore
"""
``VGETMANTPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8``

``EVEX.256.66.0F3A.W0 26 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VGETMANTPS_ZMM_K1Z_ZMMM512B32_IMM8_SAE: Code = 3855 # type: ignore
"""
``VGETMANTPS zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}, imm8``

``EVEX.512.66.0F3A.W0 26 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VGETMANTPD_XMM_K1Z_XMMM128B64_IMM8: Code = 3856 # type: ignore
"""
``VGETMANTPD xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8``

``EVEX.128.66.0F3A.W1 26 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VGETMANTPD_YMM_K1Z_YMMM256B64_IMM8: Code = 3857 # type: ignore
"""
``VGETMANTPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 26 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VGETMANTPD_ZMM_K1Z_ZMMM512B64_IMM8_SAE: Code = 3858 # type: ignore
"""
``VGETMANTPD zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}, imm8``

``EVEX.512.66.0F3A.W1 26 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VGETMANTSS_XMM_K1Z_XMM_XMMM32_IMM8_SAE: Code = 3859 # type: ignore
"""
``VGETMANTSS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}, imm8``

``EVEX.LIG.66.0F3A.W0 27 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VGETMANTSD_XMM_K1Z_XMM_XMMM64_IMM8_SAE: Code = 3860 # type: ignore
"""
``VGETMANTSD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}, imm8``

``EVEX.LIG.66.0F3A.W1 27 /r ib``

``AVX512F``

``16/32/64-bit``
"""
VEX_KSHIFTRB_KR_KR_IMM8: Code = 3861 # type: ignore
"""
``KSHIFTRB k1, k2, imm8``

``VEX.L0.66.0F3A.W0 30 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_KSHIFTRW_KR_KR_IMM8: Code = 3862 # type: ignore
"""
``KSHIFTRW k1, k2, imm8``

``VEX.L0.66.0F3A.W1 30 /r ib``

``AVX512F``

``16/32/64-bit``
"""
VEX_KSHIFTRD_KR_KR_IMM8: Code = 3863 # type: ignore
"""
``KSHIFTRD k1, k2, imm8``

``VEX.L0.66.0F3A.W0 31 /r ib``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KSHIFTRQ_KR_KR_IMM8: Code = 3864 # type: ignore
"""
``KSHIFTRQ k1, k2, imm8``

``VEX.L0.66.0F3A.W1 31 /r ib``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KSHIFTLB_KR_KR_IMM8: Code = 3865 # type: ignore
"""
``KSHIFTLB k1, k2, imm8``

``VEX.L0.66.0F3A.W0 32 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_KSHIFTLW_KR_KR_IMM8: Code = 3866 # type: ignore
"""
``KSHIFTLW k1, k2, imm8``

``VEX.L0.66.0F3A.W1 32 /r ib``

``AVX512F``

``16/32/64-bit``
"""
VEX_KSHIFTLD_KR_KR_IMM8: Code = 3867 # type: ignore
"""
``KSHIFTLD k1, k2, imm8``

``VEX.L0.66.0F3A.W0 33 /r ib``

``AVX512BW``

``16/32/64-bit``
"""
VEX_KSHIFTLQ_KR_KR_IMM8: Code = 3868 # type: ignore
"""
``KSHIFTLQ k1, k2, imm8``

``VEX.L0.66.0F3A.W1 33 /r ib``

``AVX512BW``

``16/32/64-bit``
"""
VEX_VINSERTI128_YMM_YMM_XMMM128_IMM8: Code = 3869 # type: ignore
"""
``VINSERTI128 ymm1, ymm2, xmm3/m128, imm8``

``VEX.256.66.0F3A.W0 38 /r ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VINSERTI32X4_YMM_K1Z_YMM_XMMM128_IMM8: Code = 3870 # type: ignore
"""
``VINSERTI32X4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8``

``EVEX.256.66.0F3A.W0 38 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VINSERTI32X4_ZMM_K1Z_ZMM_XMMM128_IMM8: Code = 3871 # type: ignore
"""
``VINSERTI32X4 zmm1 {k1}{z}, zmm2, xmm3/m128, imm8``

``EVEX.512.66.0F3A.W0 38 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VINSERTI64X2_YMM_K1Z_YMM_XMMM128_IMM8: Code = 3872 # type: ignore
"""
``VINSERTI64X2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8``

``EVEX.256.66.0F3A.W1 38 /r ib``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VINSERTI64X2_ZMM_K1Z_ZMM_XMMM128_IMM8: Code = 3873 # type: ignore
"""
``VINSERTI64X2 zmm1 {k1}{z}, zmm2, xmm3/m128, imm8``

``EVEX.512.66.0F3A.W1 38 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_VEXTRACTI128_XMMM128_YMM_IMM8: Code = 3874 # type: ignore
"""
``VEXTRACTI128 xmm1/m128, ymm2, imm8``

``VEX.256.66.0F3A.W0 39 /r ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VEXTRACTI32X4_XMMM128_K1Z_YMM_IMM8: Code = 3875 # type: ignore
"""
``VEXTRACTI32X4 xmm1/m128 {k1}{z}, ymm2, imm8``

``EVEX.256.66.0F3A.W0 39 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VEXTRACTI32X4_XMMM128_K1Z_ZMM_IMM8: Code = 3876 # type: ignore
"""
``VEXTRACTI32X4 xmm1/m128 {k1}{z}, zmm2, imm8``

``EVEX.512.66.0F3A.W0 39 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VEXTRACTI64X2_XMMM128_K1Z_YMM_IMM8: Code = 3877 # type: ignore
"""
``VEXTRACTI64X2 xmm1/m128 {k1}{z}, ymm2, imm8``

``EVEX.256.66.0F3A.W1 39 /r ib``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VEXTRACTI64X2_XMMM128_K1Z_ZMM_IMM8: Code = 3878 # type: ignore
"""
``VEXTRACTI64X2 xmm1/m128 {k1}{z}, zmm2, imm8``

``EVEX.512.66.0F3A.W1 39 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VINSERTI32X8_ZMM_K1Z_ZMM_YMMM256_IMM8: Code = 3879 # type: ignore
"""
``VINSERTI32X8 zmm1 {k1}{z}, zmm2, ymm3/m256, imm8``

``EVEX.512.66.0F3A.W0 3A /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VINSERTI64X4_ZMM_K1Z_ZMM_YMMM256_IMM8: Code = 3880 # type: ignore
"""
``VINSERTI64X4 zmm1 {k1}{z}, zmm2, ymm3/m256, imm8``

``EVEX.512.66.0F3A.W1 3A /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VEXTRACTI32X8_YMMM256_K1Z_ZMM_IMM8: Code = 3881 # type: ignore
"""
``VEXTRACTI32X8 ymm1/m256 {k1}{z}, zmm2, imm8``

``EVEX.512.66.0F3A.W0 3B /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VEXTRACTI64X4_YMMM256_K1Z_ZMM_IMM8: Code = 3882 # type: ignore
"""
``VEXTRACTI64X4 ymm1/m256 {k1}{z}, zmm2, imm8``

``EVEX.512.66.0F3A.W1 3B /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VPCMPUB_KR_K1_XMM_XMMM128_IMM8: Code = 3883 # type: ignore
"""
``VPCMPUB k1 {k2}, xmm2, xmm3/m128, imm8``

``EVEX.128.66.0F3A.W0 3E /r ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPUB_KR_K1_YMM_YMMM256_IMM8: Code = 3884 # type: ignore
"""
``VPCMPUB k1 {k2}, ymm2, ymm3/m256, imm8``

``EVEX.256.66.0F3A.W0 3E /r ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPUB_KR_K1_ZMM_ZMMM512_IMM8: Code = 3885 # type: ignore
"""
``VPCMPUB k1 {k2}, zmm2, zmm3/m512, imm8``

``EVEX.512.66.0F3A.W0 3E /r ib``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPUW_KR_K1_XMM_XMMM128_IMM8: Code = 3886 # type: ignore
"""
``VPCMPUW k1 {k2}, xmm2, xmm3/m128, imm8``

``EVEX.128.66.0F3A.W1 3E /r ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPUW_KR_K1_YMM_YMMM256_IMM8: Code = 3887 # type: ignore
"""
``VPCMPUW k1 {k2}, ymm2, ymm3/m256, imm8``

``EVEX.256.66.0F3A.W1 3E /r ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPUW_KR_K1_ZMM_ZMMM512_IMM8: Code = 3888 # type: ignore
"""
``VPCMPUW k1 {k2}, zmm2, zmm3/m512, imm8``

``EVEX.512.66.0F3A.W1 3E /r ib``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPB_KR_K1_XMM_XMMM128_IMM8: Code = 3889 # type: ignore
"""
``VPCMPB k1 {k2}, xmm2, xmm3/m128, imm8``

``EVEX.128.66.0F3A.W0 3F /r ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPB_KR_K1_YMM_YMMM256_IMM8: Code = 3890 # type: ignore
"""
``VPCMPB k1 {k2}, ymm2, ymm3/m256, imm8``

``EVEX.256.66.0F3A.W0 3F /r ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPB_KR_K1_ZMM_ZMMM512_IMM8: Code = 3891 # type: ignore
"""
``VPCMPB k1 {k2}, zmm2, zmm3/m512, imm8``

``EVEX.512.66.0F3A.W0 3F /r ib``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPW_KR_K1_XMM_XMMM128_IMM8: Code = 3892 # type: ignore
"""
``VPCMPW k1 {k2}, xmm2, xmm3/m128, imm8``

``EVEX.128.66.0F3A.W1 3F /r ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPW_KR_K1_YMM_YMMM256_IMM8: Code = 3893 # type: ignore
"""
``VPCMPW k1 {k2}, ymm2, ymm3/m256, imm8``

``EVEX.256.66.0F3A.W1 3F /r ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VPCMPW_KR_K1_ZMM_ZMMM512_IMM8: Code = 3894 # type: ignore
"""
``VPCMPW k1 {k2}, zmm2, zmm3/m512, imm8``

``EVEX.512.66.0F3A.W1 3F /r ib``

``AVX512BW``

``16/32/64-bit``
"""
DPPS_XMM_XMMM128_IMM8: Code = 3895 # type: ignore
"""
``DPPS xmm1, xmm2/m128, imm8``

``66 0F 3A 40 /r ib``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VDPPS_XMM_XMM_XMMM128_IMM8: Code = 3896 # type: ignore
"""
``VDPPS xmm1, xmm2, xmm3/m128, imm8``

``VEX.128.66.0F3A.WIG 40 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VDPPS_YMM_YMM_YMMM256_IMM8: Code = 3897 # type: ignore
"""
``VDPPS ymm1, ymm2, ymm3/m256, imm8``

``VEX.256.66.0F3A.WIG 40 /r ib``

``AVX``

``16/32/64-bit``
"""
DPPD_XMM_XMMM128_IMM8: Code = 3898 # type: ignore
"""
``DPPD xmm1, xmm2/m128, imm8``

``66 0F 3A 41 /r ib``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VDPPD_XMM_XMM_XMMM128_IMM8: Code = 3899 # type: ignore
"""
``VDPPD xmm1, xmm2, xmm3/m128, imm8``

``VEX.128.66.0F3A.WIG 41 /r ib``

``AVX``

``16/32/64-bit``
"""
MPSADBW_XMM_XMMM128_IMM8: Code = 3900 # type: ignore
"""
``MPSADBW xmm1, xmm2/m128, imm8``

``66 0F 3A 42 /r ib``

``SSE4.1``

``16/32/64-bit``
"""
VEX_VMPSADBW_XMM_XMM_XMMM128_IMM8: Code = 3901 # type: ignore
"""
``VMPSADBW xmm1, xmm2, xmm3/m128, imm8``

``VEX.128.66.0F3A.WIG 42 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VMPSADBW_YMM_YMM_YMMM256_IMM8: Code = 3902 # type: ignore
"""
``VMPSADBW ymm1, ymm2, ymm3/m256, imm8``

``VEX.256.66.0F3A.WIG 42 /r ib``

``AVX2``

``16/32/64-bit``
"""
EVEX_VDBPSADBW_XMM_K1Z_XMM_XMMM128_IMM8: Code = 3903 # type: ignore
"""
``VDBPSADBW xmm1 {k1}{z}, xmm2, xmm3/m128, imm8``

``EVEX.128.66.0F3A.W0 42 /r ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VDBPSADBW_YMM_K1Z_YMM_YMMM256_IMM8: Code = 3904 # type: ignore
"""
``VDBPSADBW ymm1 {k1}{z}, ymm2, ymm3/m256, imm8``

``EVEX.256.66.0F3A.W0 42 /r ib``

``AVX512VL and AVX512BW``

``16/32/64-bit``
"""
EVEX_VDBPSADBW_ZMM_K1Z_ZMM_ZMMM512_IMM8: Code = 3905 # type: ignore
"""
``VDBPSADBW zmm1 {k1}{z}, zmm2, zmm3/m512, imm8``

``EVEX.512.66.0F3A.W0 42 /r ib``

``AVX512BW``

``16/32/64-bit``
"""
EVEX_VSHUFI32X4_YMM_K1Z_YMM_YMMM256B32_IMM8: Code = 3906 # type: ignore
"""
``VSHUFI32X4 ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8``

``EVEX.256.66.0F3A.W0 43 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSHUFI32X4_ZMM_K1Z_ZMM_ZMMM512B32_IMM8: Code = 3907 # type: ignore
"""
``VSHUFI32X4 zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst, imm8``

``EVEX.512.66.0F3A.W0 43 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VSHUFI64X2_YMM_K1Z_YMM_YMMM256B64_IMM8: Code = 3908 # type: ignore
"""
``VSHUFI64X2 ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 43 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VSHUFI64X2_ZMM_K1Z_ZMM_ZMMM512B64_IMM8: Code = 3909 # type: ignore
"""
``VSHUFI64X2 zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8``

``EVEX.512.66.0F3A.W1 43 /r ib``

``AVX512F``

``16/32/64-bit``
"""
PCLMULQDQ_XMM_XMMM128_IMM8: Code = 3910 # type: ignore
"""
``PCLMULQDQ xmm1, xmm2/m128, imm8``

``66 0F 3A 44 /r ib``

``PCLMULQDQ``

``16/32/64-bit``
"""
VEX_VPCLMULQDQ_XMM_XMM_XMMM128_IMM8: Code = 3911 # type: ignore
"""
``VPCLMULQDQ xmm1, xmm2, xmm3/m128, imm8``

``VEX.128.66.0F3A.WIG 44 /r ib``

``PCLMULQDQ and AVX``

``16/32/64-bit``
"""
VEX_VPCLMULQDQ_YMM_YMM_YMMM256_IMM8: Code = 3912 # type: ignore
"""
``VPCLMULQDQ ymm1, ymm2, ymm3/m256, imm8``

``VEX.256.66.0F3A.WIG 44 /r ib``

``VPCLMULQDQ``

``16/32/64-bit``
"""
EVEX_VPCLMULQDQ_XMM_XMM_XMMM128_IMM8: Code = 3913 # type: ignore
"""
``VPCLMULQDQ xmm1, xmm2, xmm3/m128, imm8``

``EVEX.128.66.0F3A.WIG 44 /r ib``

``AVX512VL and VPCLMULQDQ``

``16/32/64-bit``
"""
EVEX_VPCLMULQDQ_YMM_YMM_YMMM256_IMM8: Code = 3914 # type: ignore
"""
``VPCLMULQDQ ymm1, ymm2, ymm3/m256, imm8``

``EVEX.256.66.0F3A.WIG 44 /r ib``

``AVX512VL and VPCLMULQDQ``

``16/32/64-bit``
"""
EVEX_VPCLMULQDQ_ZMM_ZMM_ZMMM512_IMM8: Code = 3915 # type: ignore
"""
``VPCLMULQDQ zmm1, zmm2, zmm3/m512, imm8``

``EVEX.512.66.0F3A.WIG 44 /r ib``

``AVX512F and VPCLMULQDQ``

``16/32/64-bit``
"""
VEX_VPERM2I128_YMM_YMM_YMMM256_IMM8: Code = 3916 # type: ignore
"""
``VPERM2I128 ymm1, ymm2, ymm3/m256, imm8``

``VEX.256.66.0F3A.W0 46 /r ib``

``AVX2``

``16/32/64-bit``
"""
VEX_VPERMIL2PS_XMM_XMM_XMMM128_XMM_IMM4: Code = 3917 # type: ignore
"""
``VPERMIL2PS xmm1, xmm2, xmm3/m128, xmm4, imm4``

``VEX.128.66.0F3A.W0 48 /r /is5``

``XOP``

``16/32/64-bit``
"""
VEX_VPERMIL2PS_YMM_YMM_YMMM256_YMM_IMM4: Code = 3918 # type: ignore
"""
``VPERMIL2PS ymm1, ymm2, ymm3/m256, ymm4, imm4``

``VEX.256.66.0F3A.W0 48 /r /is5``

``XOP``

``16/32/64-bit``
"""
VEX_VPERMIL2PS_XMM_XMM_XMM_XMMM128_IMM4: Code = 3919 # type: ignore
"""
``VPERMIL2PS xmm1, xmm2, xmm3, xmm4/m128, imm4``

``VEX.128.66.0F3A.W1 48 /r /is5``

``XOP``

``16/32/64-bit``
"""
VEX_VPERMIL2PS_YMM_YMM_YMM_YMMM256_IMM4: Code = 3920 # type: ignore
"""
``VPERMIL2PS ymm1, ymm2, ymm3, ymm4/m256, imm4``

``VEX.256.66.0F3A.W1 48 /r /is5``

``XOP``

``16/32/64-bit``
"""
VEX_VPERMIL2PD_XMM_XMM_XMMM128_XMM_IMM4: Code = 3921 # type: ignore
"""
``VPERMIL2PD xmm1, xmm2, xmm3/m128, xmm4, imm4``

``VEX.128.66.0F3A.W0 49 /r /is5``

``XOP``

``16/32/64-bit``
"""
VEX_VPERMIL2PD_YMM_YMM_YMMM256_YMM_IMM4: Code = 3922 # type: ignore
"""
``VPERMIL2PD ymm1, ymm2, ymm3/m256, ymm4, imm4``

``VEX.256.66.0F3A.W0 49 /r /is5``

``XOP``

``16/32/64-bit``
"""
VEX_VPERMIL2PD_XMM_XMM_XMM_XMMM128_IMM4: Code = 3923 # type: ignore
"""
``VPERMIL2PD xmm1, xmm2, xmm3, xmm4/m128, imm4``

``VEX.128.66.0F3A.W1 49 /r /is5``

``XOP``

``16/32/64-bit``
"""
VEX_VPERMIL2PD_YMM_YMM_YMM_YMMM256_IMM4: Code = 3924 # type: ignore
"""
``VPERMIL2PD ymm1, ymm2, ymm3, ymm4/m256, imm4``

``VEX.256.66.0F3A.W1 49 /r /is5``

``XOP``

``16/32/64-bit``
"""
VEX_VBLENDVPS_XMM_XMM_XMMM128_XMM: Code = 3925 # type: ignore
"""
``VBLENDVPS xmm1, xmm2, xmm3/m128, xmm4``

``VEX.128.66.0F3A.W0 4A /r /is4``

``AVX``

``16/32/64-bit``
"""
VEX_VBLENDVPS_YMM_YMM_YMMM256_YMM: Code = 3926 # type: ignore
"""
``VBLENDVPS ymm1, ymm2, ymm3/m256, ymm4``

``VEX.256.66.0F3A.W0 4A /r /is4``

``AVX``

``16/32/64-bit``
"""
VEX_VBLENDVPD_XMM_XMM_XMMM128_XMM: Code = 3927 # type: ignore
"""
``VBLENDVPD xmm1, xmm2, xmm3/m128, xmm4``

``VEX.128.66.0F3A.W0 4B /r /is4``

``AVX``

``16/32/64-bit``
"""
VEX_VBLENDVPD_YMM_YMM_YMMM256_YMM: Code = 3928 # type: ignore
"""
``VBLENDVPD ymm1, ymm2, ymm3/m256, ymm4``

``VEX.256.66.0F3A.W0 4B /r /is4``

``AVX``

``16/32/64-bit``
"""
VEX_VPBLENDVB_XMM_XMM_XMMM128_XMM: Code = 3929 # type: ignore
"""
``VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4``

``VEX.128.66.0F3A.W0 4C /r /is4``

``AVX``

``16/32/64-bit``
"""
VEX_VPBLENDVB_YMM_YMM_YMMM256_YMM: Code = 3930 # type: ignore
"""
``VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4``

``VEX.256.66.0F3A.W0 4C /r /is4``

``AVX2``

``16/32/64-bit``
"""
EVEX_VRANGEPS_XMM_K1Z_XMM_XMMM128B32_IMM8: Code = 3931 # type: ignore
"""
``VRANGEPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8``

``EVEX.128.66.0F3A.W0 50 /r ib``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VRANGEPS_YMM_K1Z_YMM_YMMM256B32_IMM8: Code = 3932 # type: ignore
"""
``VRANGEPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8``

``EVEX.256.66.0F3A.W0 50 /r ib``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VRANGEPS_ZMM_K1Z_ZMM_ZMMM512B32_IMM8_SAE: Code = 3933 # type: ignore
"""
``VRANGEPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{sae}, imm8``

``EVEX.512.66.0F3A.W0 50 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VRANGEPD_XMM_K1Z_XMM_XMMM128B64_IMM8: Code = 3934 # type: ignore
"""
``VRANGEPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8``

``EVEX.128.66.0F3A.W1 50 /r ib``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VRANGEPD_YMM_K1Z_YMM_YMMM256B64_IMM8: Code = 3935 # type: ignore
"""
``VRANGEPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 50 /r ib``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VRANGEPD_ZMM_K1Z_ZMM_ZMMM512B64_IMM8_SAE: Code = 3936 # type: ignore
"""
``VRANGEPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{sae}, imm8``

``EVEX.512.66.0F3A.W1 50 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VRANGESS_XMM_K1Z_XMM_XMMM32_IMM8_SAE: Code = 3937 # type: ignore
"""
``VRANGESS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}, imm8``

``EVEX.LIG.66.0F3A.W0 51 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VRANGESD_XMM_K1Z_XMM_XMMM64_IMM8_SAE: Code = 3938 # type: ignore
"""
``VRANGESD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}, imm8``

``EVEX.LIG.66.0F3A.W1 51 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VFIXUPIMMPS_XMM_K1Z_XMM_XMMM128B32_IMM8: Code = 3939 # type: ignore
"""
``VFIXUPIMMPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8``

``EVEX.128.66.0F3A.W0 54 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFIXUPIMMPS_YMM_K1Z_YMM_YMMM256B32_IMM8: Code = 3940 # type: ignore
"""
``VFIXUPIMMPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8``

``EVEX.256.66.0F3A.W0 54 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFIXUPIMMPS_ZMM_K1Z_ZMM_ZMMM512B32_IMM8_SAE: Code = 3941 # type: ignore
"""
``VFIXUPIMMPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{sae}, imm8``

``EVEX.512.66.0F3A.W0 54 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFIXUPIMMPD_XMM_K1Z_XMM_XMMM128B64_IMM8: Code = 3942 # type: ignore
"""
``VFIXUPIMMPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8``

``EVEX.128.66.0F3A.W1 54 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFIXUPIMMPD_YMM_K1Z_YMM_YMMM256B64_IMM8: Code = 3943 # type: ignore
"""
``VFIXUPIMMPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 54 /r ib``

``AVX512VL and AVX512F``

``16/32/64-bit``
"""
EVEX_VFIXUPIMMPD_ZMM_K1Z_ZMM_ZMMM512B64_IMM8_SAE: Code = 3944 # type: ignore
"""
``VFIXUPIMMPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{sae}, imm8``

``EVEX.512.66.0F3A.W1 54 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFIXUPIMMSS_XMM_K1Z_XMM_XMMM32_IMM8_SAE: Code = 3945 # type: ignore
"""
``VFIXUPIMMSS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}, imm8``

``EVEX.LIG.66.0F3A.W0 55 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VFIXUPIMMSD_XMM_K1Z_XMM_XMMM64_IMM8_SAE: Code = 3946 # type: ignore
"""
``VFIXUPIMMSD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}, imm8``

``EVEX.LIG.66.0F3A.W1 55 /r ib``

``AVX512F``

``16/32/64-bit``
"""
EVEX_VREDUCEPS_XMM_K1Z_XMMM128B32_IMM8: Code = 3947 # type: ignore
"""
``VREDUCEPS xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8``

``EVEX.128.66.0F3A.W0 56 /r ib``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VREDUCEPS_YMM_K1Z_YMMM256B32_IMM8: Code = 3948 # type: ignore
"""
``VREDUCEPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8``

``EVEX.256.66.0F3A.W0 56 /r ib``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VREDUCEPS_ZMM_K1Z_ZMMM512B32_IMM8_SAE: Code = 3949 # type: ignore
"""
``VREDUCEPS zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}, imm8``

``EVEX.512.66.0F3A.W0 56 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VREDUCEPD_XMM_K1Z_XMMM128B64_IMM8: Code = 3950 # type: ignore
"""
``VREDUCEPD xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8``

``EVEX.128.66.0F3A.W1 56 /r ib``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VREDUCEPD_YMM_K1Z_YMMM256B64_IMM8: Code = 3951 # type: ignore
"""
``VREDUCEPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 56 /r ib``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VREDUCEPD_ZMM_K1Z_ZMMM512B64_IMM8_SAE: Code = 3952 # type: ignore
"""
``VREDUCEPD zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}, imm8``

``EVEX.512.66.0F3A.W1 56 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VREDUCESS_XMM_K1Z_XMM_XMMM32_IMM8_SAE: Code = 3953 # type: ignore
"""
``VREDUCESS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}, imm8``

``EVEX.LIG.66.0F3A.W0 57 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VREDUCESD_XMM_K1Z_XMM_XMMM64_IMM8_SAE: Code = 3954 # type: ignore
"""
``VREDUCESD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}, imm8``

``EVEX.LIG.66.0F3A.W1 57 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_VFMADDSUBPS_XMM_XMM_XMMM128_XMM: Code = 3955 # type: ignore
"""
``VFMADDSUBPS xmm1, xmm2, xmm3/m128, xmm4``

``VEX.128.66.0F3A.W0 5C /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDSUBPS_YMM_YMM_YMMM256_YMM: Code = 3956 # type: ignore
"""
``VFMADDSUBPS ymm1, ymm2, ymm3/m256, ymm4``

``VEX.256.66.0F3A.W0 5C /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDSUBPS_XMM_XMM_XMM_XMMM128: Code = 3957 # type: ignore
"""
``VFMADDSUBPS xmm1, xmm2, xmm3, xmm4/m128``

``VEX.128.66.0F3A.W1 5C /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDSUBPS_YMM_YMM_YMM_YMMM256: Code = 3958 # type: ignore
"""
``VFMADDSUBPS ymm1, ymm2, ymm3, ymm4/m256``

``VEX.256.66.0F3A.W1 5C /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDSUBPD_XMM_XMM_XMMM128_XMM: Code = 3959 # type: ignore
"""
``VFMADDSUBPD xmm1, xmm2, xmm3/m128, xmm4``

``VEX.128.66.0F3A.W0 5D /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDSUBPD_YMM_YMM_YMMM256_YMM: Code = 3960 # type: ignore
"""
``VFMADDSUBPD ymm1, ymm2, ymm3/m256, ymm4``

``VEX.256.66.0F3A.W0 5D /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDSUBPD_XMM_XMM_XMM_XMMM128: Code = 3961 # type: ignore
"""
``VFMADDSUBPD xmm1, xmm2, xmm3, xmm4/m128``

``VEX.128.66.0F3A.W1 5D /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDSUBPD_YMM_YMM_YMM_YMMM256: Code = 3962 # type: ignore
"""
``VFMADDSUBPD ymm1, ymm2, ymm3, ymm4/m256``

``VEX.256.66.0F3A.W1 5D /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBADDPS_XMM_XMM_XMMM128_XMM: Code = 3963 # type: ignore
"""
``VFMSUBADDPS xmm1, xmm2, xmm3/m128, xmm4``

``VEX.128.66.0F3A.W0 5E /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBADDPS_YMM_YMM_YMMM256_YMM: Code = 3964 # type: ignore
"""
``VFMSUBADDPS ymm1, ymm2, ymm3/m256, ymm4``

``VEX.256.66.0F3A.W0 5E /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBADDPS_XMM_XMM_XMM_XMMM128: Code = 3965 # type: ignore
"""
``VFMSUBADDPS xmm1, xmm2, xmm3, xmm4/m128``

``VEX.128.66.0F3A.W1 5E /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBADDPS_YMM_YMM_YMM_YMMM256: Code = 3966 # type: ignore
"""
``VFMSUBADDPS ymm1, ymm2, ymm3, ymm4/m256``

``VEX.256.66.0F3A.W1 5E /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBADDPD_XMM_XMM_XMMM128_XMM: Code = 3967 # type: ignore
"""
``VFMSUBADDPD xmm1, xmm2, xmm3/m128, xmm4``

``VEX.128.66.0F3A.W0 5F /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBADDPD_YMM_YMM_YMMM256_YMM: Code = 3968 # type: ignore
"""
``VFMSUBADDPD ymm1, ymm2, ymm3/m256, ymm4``

``VEX.256.66.0F3A.W0 5F /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBADDPD_XMM_XMM_XMM_XMMM128: Code = 3969 # type: ignore
"""
``VFMSUBADDPD xmm1, xmm2, xmm3, xmm4/m128``

``VEX.128.66.0F3A.W1 5F /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBADDPD_YMM_YMM_YMM_YMMM256: Code = 3970 # type: ignore
"""
``VFMSUBADDPD ymm1, ymm2, ymm3, ymm4/m256``

``VEX.256.66.0F3A.W1 5F /r /is4``

``FMA4``

``16/32/64-bit``
"""
PCMPESTRM_XMM_XMMM128_IMM8: Code = 3971 # type: ignore
"""
``PCMPESTRM xmm1, xmm2/m128, imm8``

``66 0F 3A 60 /r ib``

``SSE4.2``

``16/32/64-bit``
"""
PCMPESTRM64_XMM_XMMM128_IMM8: Code = 3972 # type: ignore
"""
``PCMPESTRM64 xmm1, xmm2/m128, imm8``

``66 o64 0F 3A 60 /r ib``

``SSE4.2``

``64-bit``
"""
VEX_VPCMPESTRM_XMM_XMMM128_IMM8: Code = 3973 # type: ignore
"""
``VPCMPESTRM xmm1, xmm2/m128, imm8``

``VEX.128.66.0F3A.W0 60 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPCMPESTRM64_XMM_XMMM128_IMM8: Code = 3974 # type: ignore
"""
``VPCMPESTRM64 xmm1, xmm2/m128, imm8``

``VEX.128.66.0F3A.W1 60 /r ib``

``AVX``

``64-bit``
"""
PCMPESTRI_XMM_XMMM128_IMM8: Code = 3975 # type: ignore
"""
``PCMPESTRI xmm1, xmm2/m128, imm8``

``66 0F 3A 61 /r ib``

``SSE4.2``

``16/32/64-bit``
"""
PCMPESTRI64_XMM_XMMM128_IMM8: Code = 3976 # type: ignore
"""
``PCMPESTRI64 xmm1, xmm2/m128, imm8``

``66 o64 0F 3A 61 /r ib``

``SSE4.2``

``64-bit``
"""
VEX_VPCMPESTRI_XMM_XMMM128_IMM8: Code = 3977 # type: ignore
"""
``VPCMPESTRI xmm1, xmm2/m128, imm8``

``VEX.128.66.0F3A.W0 61 /r ib``

``AVX``

``16/32/64-bit``
"""
VEX_VPCMPESTRI64_XMM_XMMM128_IMM8: Code = 3978 # type: ignore
"""
``VPCMPESTRI64 xmm1, xmm2/m128, imm8``

``VEX.128.66.0F3A.W1 61 /r ib``

``AVX``

``64-bit``
"""
PCMPISTRM_XMM_XMMM128_IMM8: Code = 3979 # type: ignore
"""
``PCMPISTRM xmm1, xmm2/m128, imm8``

``66 0F 3A 62 /r ib``

``SSE4.2``

``16/32/64-bit``
"""
VEX_VPCMPISTRM_XMM_XMMM128_IMM8: Code = 3980 # type: ignore
"""
``VPCMPISTRM xmm1, xmm2/m128, imm8``

``VEX.128.66.0F3A.WIG 62 /r ib``

``AVX``

``16/32/64-bit``
"""
PCMPISTRI_XMM_XMMM128_IMM8: Code = 3981 # type: ignore
"""
``PCMPISTRI xmm1, xmm2/m128, imm8``

``66 0F 3A 63 /r ib``

``SSE4.2``

``16/32/64-bit``
"""
VEX_VPCMPISTRI_XMM_XMMM128_IMM8: Code = 3982 # type: ignore
"""
``VPCMPISTRI xmm1, xmm2/m128, imm8``

``VEX.128.66.0F3A.WIG 63 /r ib``

``AVX``

``16/32/64-bit``
"""
EVEX_VFPCLASSPS_KR_K1_XMMM128B32_IMM8: Code = 3983 # type: ignore
"""
``VFPCLASSPS k2 {k1}, xmm2/m128/m32bcst, imm8``

``EVEX.128.66.0F3A.W0 66 /r ib``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VFPCLASSPS_KR_K1_YMMM256B32_IMM8: Code = 3984 # type: ignore
"""
``VFPCLASSPS k2 {k1}, ymm2/m256/m32bcst, imm8``

``EVEX.256.66.0F3A.W0 66 /r ib``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VFPCLASSPS_KR_K1_ZMMM512B32_IMM8: Code = 3985 # type: ignore
"""
``VFPCLASSPS k2 {k1}, zmm2/m512/m32bcst, imm8``

``EVEX.512.66.0F3A.W0 66 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VFPCLASSPD_KR_K1_XMMM128B64_IMM8: Code = 3986 # type: ignore
"""
``VFPCLASSPD k2 {k1}, xmm2/m128/m64bcst, imm8``

``EVEX.128.66.0F3A.W1 66 /r ib``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VFPCLASSPD_KR_K1_YMMM256B64_IMM8: Code = 3987 # type: ignore
"""
``VFPCLASSPD k2 {k1}, ymm2/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 66 /r ib``

``AVX512VL and AVX512DQ``

``16/32/64-bit``
"""
EVEX_VFPCLASSPD_KR_K1_ZMMM512B64_IMM8: Code = 3988 # type: ignore
"""
``VFPCLASSPD k2 {k1}, zmm2/m512/m64bcst, imm8``

``EVEX.512.66.0F3A.W1 66 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VFPCLASSSS_KR_K1_XMMM32_IMM8: Code = 3989 # type: ignore
"""
``VFPCLASSSS k2 {k1}, xmm2/m32, imm8``

``EVEX.LIG.66.0F3A.W0 67 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
EVEX_VFPCLASSSD_KR_K1_XMMM64_IMM8: Code = 3990 # type: ignore
"""
``VFPCLASSSD k2 {k1}, xmm2/m64, imm8``

``EVEX.LIG.66.0F3A.W1 67 /r ib``

``AVX512DQ``

``16/32/64-bit``
"""
VEX_VFMADDPS_XMM_XMM_XMMM128_XMM: Code = 3991 # type: ignore
"""
``VFMADDPS xmm1, xmm2, xmm3/m128, xmm4``

``VEX.128.66.0F3A.W0 68 /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDPS_YMM_YMM_YMMM256_YMM: Code = 3992 # type: ignore
"""
``VFMADDPS ymm1, ymm2, ymm3/m256, ymm4``

``VEX.256.66.0F3A.W0 68 /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDPS_XMM_XMM_XMM_XMMM128: Code = 3993 # type: ignore
"""
``VFMADDPS xmm1, xmm2, xmm3, xmm4/m128``

``VEX.128.66.0F3A.W1 68 /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDPS_YMM_YMM_YMM_YMMM256: Code = 3994 # type: ignore
"""
``VFMADDPS ymm1, ymm2, ymm3, ymm4/m256``

``VEX.256.66.0F3A.W1 68 /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDPD_XMM_XMM_XMMM128_XMM: Code = 3995 # type: ignore
"""
``VFMADDPD xmm1, xmm2, xmm3/m128, xmm4``

``VEX.128.66.0F3A.W0 69 /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDPD_YMM_YMM_YMMM256_YMM: Code = 3996 # type: ignore
"""
``VFMADDPD ymm1, ymm2, ymm3/m256, ymm4``

``VEX.256.66.0F3A.W0 69 /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDPD_XMM_XMM_XMM_XMMM128: Code = 3997 # type: ignore
"""
``VFMADDPD xmm1, xmm2, xmm3, xmm4/m128``

``VEX.128.66.0F3A.W1 69 /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDPD_YMM_YMM_YMM_YMMM256: Code = 3998 # type: ignore
"""
``VFMADDPD ymm1, ymm2, ymm3, ymm4/m256``

``VEX.256.66.0F3A.W1 69 /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDSS_XMM_XMM_XMMM32_XMM: Code = 3999 # type: ignore
"""
``VFMADDSS xmm1, xmm2, xmm3/m32, xmm4``

``VEX.LIG.66.0F3A.W0 6A /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDSS_XMM_XMM_XMM_XMMM32: Code = 4000 # type: ignore
"""
``VFMADDSS xmm1, xmm2, xmm3, xmm4/m32``

``VEX.LIG.66.0F3A.W1 6A /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDSD_XMM_XMM_XMMM64_XMM: Code = 4001 # type: ignore
"""
``VFMADDSD xmm1, xmm2, xmm3/m64, xmm4``

``VEX.LIG.66.0F3A.W0 6B /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMADDSD_XMM_XMM_XMM_XMMM64: Code = 4002 # type: ignore
"""
``VFMADDSD xmm1, xmm2, xmm3, xmm4/m64``

``VEX.LIG.66.0F3A.W1 6B /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBPS_XMM_XMM_XMMM128_XMM: Code = 4003 # type: ignore
"""
``VFMSUBPS xmm1, xmm2, xmm3/m128, xmm4``

``VEX.128.66.0F3A.W0 6C /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBPS_YMM_YMM_YMMM256_YMM: Code = 4004 # type: ignore
"""
``VFMSUBPS ymm1, ymm2, ymm3/m256, ymm4``

``VEX.256.66.0F3A.W0 6C /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBPS_XMM_XMM_XMM_XMMM128: Code = 4005 # type: ignore
"""
``VFMSUBPS xmm1, xmm2, xmm3, xmm4/m128``

``VEX.128.66.0F3A.W1 6C /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBPS_YMM_YMM_YMM_YMMM256: Code = 4006 # type: ignore
"""
``VFMSUBPS ymm1, ymm2, ymm3, ymm4/m256``

``VEX.256.66.0F3A.W1 6C /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBPD_XMM_XMM_XMMM128_XMM: Code = 4007 # type: ignore
"""
``VFMSUBPD xmm1, xmm2, xmm3/m128, xmm4``

``VEX.128.66.0F3A.W0 6D /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBPD_YMM_YMM_YMMM256_YMM: Code = 4008 # type: ignore
"""
``VFMSUBPD ymm1, ymm2, ymm3/m256, ymm4``

``VEX.256.66.0F3A.W0 6D /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBPD_XMM_XMM_XMM_XMMM128: Code = 4009 # type: ignore
"""
``VFMSUBPD xmm1, xmm2, xmm3, xmm4/m128``

``VEX.128.66.0F3A.W1 6D /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBPD_YMM_YMM_YMM_YMMM256: Code = 4010 # type: ignore
"""
``VFMSUBPD ymm1, ymm2, ymm3, ymm4/m256``

``VEX.256.66.0F3A.W1 6D /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBSS_XMM_XMM_XMMM32_XMM: Code = 4011 # type: ignore
"""
``VFMSUBSS xmm1, xmm2, xmm3/m32, xmm4``

``VEX.LIG.66.0F3A.W0 6E /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBSS_XMM_XMM_XMM_XMMM32: Code = 4012 # type: ignore
"""
``VFMSUBSS xmm1, xmm2, xmm3, xmm4/m32``

``VEX.LIG.66.0F3A.W1 6E /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBSD_XMM_XMM_XMMM64_XMM: Code = 4013 # type: ignore
"""
``VFMSUBSD xmm1, xmm2, xmm3/m64, xmm4``

``VEX.LIG.66.0F3A.W0 6F /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFMSUBSD_XMM_XMM_XMM_XMMM64: Code = 4014 # type: ignore
"""
``VFMSUBSD xmm1, xmm2, xmm3, xmm4/m64``

``VEX.LIG.66.0F3A.W1 6F /r /is4``

``FMA4``

``16/32/64-bit``
"""
EVEX_VPSHLDW_XMM_K1Z_XMM_XMMM128_IMM8: Code = 4015 # type: ignore
"""
``VPSHLDW xmm1 {k1}{z}, xmm2, xmm3/m128, imm8``

``EVEX.128.66.0F3A.W1 70 /r ib``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHLDW_YMM_K1Z_YMM_YMMM256_IMM8: Code = 4016 # type: ignore
"""
``VPSHLDW ymm1 {k1}{z}, ymm2, ymm3/m256, imm8``

``EVEX.256.66.0F3A.W1 70 /r ib``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHLDW_ZMM_K1Z_ZMM_ZMMM512_IMM8: Code = 4017 # type: ignore
"""
``VPSHLDW zmm1 {k1}{z}, zmm2, zmm3/m512, imm8``

``EVEX.512.66.0F3A.W1 70 /r ib``

``AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHLDD_XMM_K1Z_XMM_XMMM128B32_IMM8: Code = 4018 # type: ignore
"""
``VPSHLDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8``

``EVEX.128.66.0F3A.W0 71 /r ib``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHLDD_YMM_K1Z_YMM_YMMM256B32_IMM8: Code = 4019 # type: ignore
"""
``VPSHLDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8``

``EVEX.256.66.0F3A.W0 71 /r ib``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHLDD_ZMM_K1Z_ZMM_ZMMM512B32_IMM8: Code = 4020 # type: ignore
"""
``VPSHLDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst, imm8``

``EVEX.512.66.0F3A.W0 71 /r ib``

``AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHLDQ_XMM_K1Z_XMM_XMMM128B64_IMM8: Code = 4021 # type: ignore
"""
``VPSHLDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8``

``EVEX.128.66.0F3A.W1 71 /r ib``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHLDQ_YMM_K1Z_YMM_YMMM256B64_IMM8: Code = 4022 # type: ignore
"""
``VPSHLDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 71 /r ib``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHLDQ_ZMM_K1Z_ZMM_ZMMM512B64_IMM8: Code = 4023 # type: ignore
"""
``VPSHLDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8``

``EVEX.512.66.0F3A.W1 71 /r ib``

``AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHRDW_XMM_K1Z_XMM_XMMM128_IMM8: Code = 4024 # type: ignore
"""
``VPSHRDW xmm1 {k1}{z}, xmm2, xmm3/m128, imm8``

``EVEX.128.66.0F3A.W1 72 /r ib``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHRDW_YMM_K1Z_YMM_YMMM256_IMM8: Code = 4025 # type: ignore
"""
``VPSHRDW ymm1 {k1}{z}, ymm2, ymm3/m256, imm8``

``EVEX.256.66.0F3A.W1 72 /r ib``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHRDW_ZMM_K1Z_ZMM_ZMMM512_IMM8: Code = 4026 # type: ignore
"""
``VPSHRDW zmm1 {k1}{z}, zmm2, zmm3/m512, imm8``

``EVEX.512.66.0F3A.W1 72 /r ib``

``AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHRDD_XMM_K1Z_XMM_XMMM128B32_IMM8: Code = 4027 # type: ignore
"""
``VPSHRDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8``

``EVEX.128.66.0F3A.W0 73 /r ib``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHRDD_YMM_K1Z_YMM_YMMM256B32_IMM8: Code = 4028 # type: ignore
"""
``VPSHRDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8``

``EVEX.256.66.0F3A.W0 73 /r ib``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHRDD_ZMM_K1Z_ZMM_ZMMM512B32_IMM8: Code = 4029 # type: ignore
"""
``VPSHRDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst, imm8``

``EVEX.512.66.0F3A.W0 73 /r ib``

``AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHRDQ_XMM_K1Z_XMM_XMMM128B64_IMM8: Code = 4030 # type: ignore
"""
``VPSHRDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8``

``EVEX.128.66.0F3A.W1 73 /r ib``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHRDQ_YMM_K1Z_YMM_YMMM256B64_IMM8: Code = 4031 # type: ignore
"""
``VPSHRDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 73 /r ib``

``AVX512VL and AVX512_VBMI2``

``16/32/64-bit``
"""
EVEX_VPSHRDQ_ZMM_K1Z_ZMM_ZMMM512B64_IMM8: Code = 4032 # type: ignore
"""
``VPSHRDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8``

``EVEX.512.66.0F3A.W1 73 /r ib``

``AVX512_VBMI2``

``16/32/64-bit``
"""
VEX_VFNMADDPS_XMM_XMM_XMMM128_XMM: Code = 4033 # type: ignore
"""
``VFNMADDPS xmm1, xmm2, xmm3/m128, xmm4``

``VEX.128.66.0F3A.W0 78 /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMADDPS_YMM_YMM_YMMM256_YMM: Code = 4034 # type: ignore
"""
``VFNMADDPS ymm1, ymm2, ymm3/m256, ymm4``

``VEX.256.66.0F3A.W0 78 /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMADDPS_XMM_XMM_XMM_XMMM128: Code = 4035 # type: ignore
"""
``VFNMADDPS xmm1, xmm2, xmm3, xmm4/m128``

``VEX.128.66.0F3A.W1 78 /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMADDPS_YMM_YMM_YMM_YMMM256: Code = 4036 # type: ignore
"""
``VFNMADDPS ymm1, ymm2, ymm3, ymm4/m256``

``VEX.256.66.0F3A.W1 78 /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMADDPD_XMM_XMM_XMMM128_XMM: Code = 4037 # type: ignore
"""
``VFNMADDPD xmm1, xmm2, xmm3/m128, xmm4``

``VEX.128.66.0F3A.W0 79 /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMADDPD_YMM_YMM_YMMM256_YMM: Code = 4038 # type: ignore
"""
``VFNMADDPD ymm1, ymm2, ymm3/m256, ymm4``

``VEX.256.66.0F3A.W0 79 /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMADDPD_XMM_XMM_XMM_XMMM128: Code = 4039 # type: ignore
"""
``VFNMADDPD xmm1, xmm2, xmm3, xmm4/m128``

``VEX.128.66.0F3A.W1 79 /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMADDPD_YMM_YMM_YMM_YMMM256: Code = 4040 # type: ignore
"""
``VFNMADDPD ymm1, ymm2, ymm3, ymm4/m256``

``VEX.256.66.0F3A.W1 79 /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMADDSS_XMM_XMM_XMMM32_XMM: Code = 4041 # type: ignore
"""
``VFNMADDSS xmm1, xmm2, xmm3/m32, xmm4``

``VEX.LIG.66.0F3A.W0 7A /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMADDSS_XMM_XMM_XMM_XMMM32: Code = 4042 # type: ignore
"""
``VFNMADDSS xmm1, xmm2, xmm3, xmm4/m32``

``VEX.LIG.66.0F3A.W1 7A /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMADDSD_XMM_XMM_XMMM64_XMM: Code = 4043 # type: ignore
"""
``VFNMADDSD xmm1, xmm2, xmm3/m64, xmm4``

``VEX.LIG.66.0F3A.W0 7B /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMADDSD_XMM_XMM_XMM_XMMM64: Code = 4044 # type: ignore
"""
``VFNMADDSD xmm1, xmm2, xmm3, xmm4/m64``

``VEX.LIG.66.0F3A.W1 7B /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMSUBPS_XMM_XMM_XMMM128_XMM: Code = 4045 # type: ignore
"""
``VFNMSUBPS xmm1, xmm2, xmm3/m128, xmm4``

``VEX.128.66.0F3A.W0 7C /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMSUBPS_YMM_YMM_YMMM256_YMM: Code = 4046 # type: ignore
"""
``VFNMSUBPS ymm1, ymm2, ymm3/m256, ymm4``

``VEX.256.66.0F3A.W0 7C /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMSUBPS_XMM_XMM_XMM_XMMM128: Code = 4047 # type: ignore
"""
``VFNMSUBPS xmm1, xmm2, xmm3, xmm4/m128``

``VEX.128.66.0F3A.W1 7C /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMSUBPS_YMM_YMM_YMM_YMMM256: Code = 4048 # type: ignore
"""
``VFNMSUBPS ymm1, ymm2, ymm3, ymm4/m256``

``VEX.256.66.0F3A.W1 7C /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMSUBPD_XMM_XMM_XMMM128_XMM: Code = 4049 # type: ignore
"""
``VFNMSUBPD xmm1, xmm2, xmm3/m128, xmm4``

``VEX.128.66.0F3A.W0 7D /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMSUBPD_YMM_YMM_YMMM256_YMM: Code = 4050 # type: ignore
"""
``VFNMSUBPD ymm1, ymm2, ymm3/m256, ymm4``

``VEX.256.66.0F3A.W0 7D /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMSUBPD_XMM_XMM_XMM_XMMM128: Code = 4051 # type: ignore
"""
``VFNMSUBPD xmm1, xmm2, xmm3, xmm4/m128``

``VEX.128.66.0F3A.W1 7D /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMSUBPD_YMM_YMM_YMM_YMMM256: Code = 4052 # type: ignore
"""
``VFNMSUBPD ymm1, ymm2, ymm3, ymm4/m256``

``VEX.256.66.0F3A.W1 7D /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMSUBSS_XMM_XMM_XMMM32_XMM: Code = 4053 # type: ignore
"""
``VFNMSUBSS xmm1, xmm2, xmm3/m32, xmm4``

``VEX.LIG.66.0F3A.W0 7E /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMSUBSS_XMM_XMM_XMM_XMMM32: Code = 4054 # type: ignore
"""
``VFNMSUBSS xmm1, xmm2, xmm3, xmm4/m32``

``VEX.LIG.66.0F3A.W1 7E /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMSUBSD_XMM_XMM_XMMM64_XMM: Code = 4055 # type: ignore
"""
``VFNMSUBSD xmm1, xmm2, xmm3/m64, xmm4``

``VEX.LIG.66.0F3A.W0 7F /r /is4``

``FMA4``

``16/32/64-bit``
"""
VEX_VFNMSUBSD_XMM_XMM_XMM_XMMM64: Code = 4056 # type: ignore
"""
``VFNMSUBSD xmm1, xmm2, xmm3, xmm4/m64``

``VEX.LIG.66.0F3A.W1 7F /r /is4``

``FMA4``

``16/32/64-bit``
"""
SHA1RNDS4_XMM_XMMM128_IMM8: Code = 4057 # type: ignore
"""
``SHA1RNDS4 xmm1, xmm2/m128, imm8``

``NP 0F 3A CC /r ib``

``SHA``

``16/32/64-bit``
"""
GF2P8AFFINEQB_XMM_XMMM128_IMM8: Code = 4058 # type: ignore
"""
``GF2P8AFFINEQB xmm1, xmm2/m128, imm8``

``66 0F 3A CE /r ib``

``GFNI``

``16/32/64-bit``
"""
VEX_VGF2P8AFFINEQB_XMM_XMM_XMMM128_IMM8: Code = 4059 # type: ignore
"""
``VGF2P8AFFINEQB xmm1, xmm2, xmm3/m128, imm8``

``VEX.128.66.0F3A.W1 CE /r ib``

``AVX and GFNI``

``16/32/64-bit``
"""
VEX_VGF2P8AFFINEQB_YMM_YMM_YMMM256_IMM8: Code = 4060 # type: ignore
"""
``VGF2P8AFFINEQB ymm1, ymm2, ymm3/m256, imm8``

``VEX.256.66.0F3A.W1 CE /r ib``

``AVX and GFNI``

``16/32/64-bit``
"""
EVEX_VGF2P8AFFINEQB_XMM_K1Z_XMM_XMMM128B64_IMM8: Code = 4061 # type: ignore
"""
``VGF2P8AFFINEQB xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8``

``EVEX.128.66.0F3A.W1 CE /r ib``

``AVX512VL and GFNI``

``16/32/64-bit``
"""
EVEX_VGF2P8AFFINEQB_YMM_K1Z_YMM_YMMM256B64_IMM8: Code = 4062 # type: ignore
"""
``VGF2P8AFFINEQB ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 CE /r ib``

``AVX512VL and GFNI``

``16/32/64-bit``
"""
EVEX_VGF2P8AFFINEQB_ZMM_K1Z_ZMM_ZMMM512B64_IMM8: Code = 4063 # type: ignore
"""
``VGF2P8AFFINEQB zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8``

``EVEX.512.66.0F3A.W1 CE /r ib``

``AVX512F and GFNI``

``16/32/64-bit``
"""
GF2P8AFFINEINVQB_XMM_XMMM128_IMM8: Code = 4064 # type: ignore
"""
``GF2P8AFFINEINVQB xmm1, xmm2/m128, imm8``

``66 0F 3A CF /r ib``

``GFNI``

``16/32/64-bit``
"""
VEX_VGF2P8AFFINEINVQB_XMM_XMM_XMMM128_IMM8: Code = 4065 # type: ignore
"""
``VGF2P8AFFINEINVQB xmm1, xmm2, xmm3/m128, imm8``

``VEX.128.66.0F3A.W1 CF /r ib``

``AVX and GFNI``

``16/32/64-bit``
"""
VEX_VGF2P8AFFINEINVQB_YMM_YMM_YMMM256_IMM8: Code = 4066 # type: ignore
"""
``VGF2P8AFFINEINVQB ymm1, ymm2, ymm3/m256, imm8``

``VEX.256.66.0F3A.W1 CF /r ib``

``AVX and GFNI``

``16/32/64-bit``
"""
EVEX_VGF2P8AFFINEINVQB_XMM_K1Z_XMM_XMMM128B64_IMM8: Code = 4067 # type: ignore
"""
``VGF2P8AFFINEINVQB xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8``

``EVEX.128.66.0F3A.W1 CF /r ib``

``AVX512VL and GFNI``

``16/32/64-bit``
"""
EVEX_VGF2P8AFFINEINVQB_YMM_K1Z_YMM_YMMM256B64_IMM8: Code = 4068 # type: ignore
"""
``VGF2P8AFFINEINVQB ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8``

``EVEX.256.66.0F3A.W1 CF /r ib``

``AVX512VL and GFNI``

``16/32/64-bit``
"""
EVEX_VGF2P8AFFINEINVQB_ZMM_K1Z_ZMM_ZMMM512B64_IMM8: Code = 4069 # type: ignore
"""
``VGF2P8AFFINEINVQB zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8``

``EVEX.512.66.0F3A.W1 CF /r ib``

``AVX512F and GFNI``

``16/32/64-bit``
"""
AESKEYGENASSIST_XMM_XMMM128_IMM8: Code = 4070 # type: ignore
"""
``AESKEYGENASSIST xmm1, xmm2/m128, imm8``

``66 0F 3A DF /r ib``

``AES``

``16/32/64-bit``
"""
VEX_VAESKEYGENASSIST_XMM_XMMM128_IMM8: Code = 4071 # type: ignore
"""
``VAESKEYGENASSIST xmm1, xmm2/m128, imm8``

``VEX.128.66.0F3A.WIG DF /r ib``

``AES and AVX``

``16/32/64-bit``
"""
VEX_RORX_R32_RM32_IMM8: Code = 4072 # type: ignore
"""
``RORX r32, r/m32, imm8``

``VEX.LZ.F2.0F3A.W0 F0 /r ib``

``BMI2``

``16/32/64-bit``
"""
VEX_RORX_R64_RM64_IMM8: Code = 4073 # type: ignore
"""
``RORX r64, r/m64, imm8``

``VEX.LZ.F2.0F3A.W1 F0 /r ib``

``BMI2``

``64-bit``
"""
XOP_VPMACSSWW_XMM_XMM_XMMM128_XMM: Code = 4074 # type: ignore
"""
``VPMACSSWW xmm1, xmm2, xmm3/m128, xmm4``

``XOP.128.X8.W0 85 /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPMACSSWD_XMM_XMM_XMMM128_XMM: Code = 4075 # type: ignore
"""
``VPMACSSWD xmm1, xmm2, xmm3/m128, xmm4``

``XOP.128.X8.W0 86 /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPMACSSDQL_XMM_XMM_XMMM128_XMM: Code = 4076 # type: ignore
"""
``VPMACSSDQL xmm1, xmm2, xmm3/m128, xmm4``

``XOP.128.X8.W0 87 /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPMACSSDD_XMM_XMM_XMMM128_XMM: Code = 4077 # type: ignore
"""
``VPMACSSDD xmm1, xmm2, xmm3/m128, xmm4``

``XOP.128.X8.W0 8E /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPMACSSDQH_XMM_XMM_XMMM128_XMM: Code = 4078 # type: ignore
"""
``VPMACSSDQH xmm1, xmm2, xmm3/m128, xmm4``

``XOP.128.X8.W0 8F /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPMACSWW_XMM_XMM_XMMM128_XMM: Code = 4079 # type: ignore
"""
``VPMACSWW xmm1, xmm2, xmm3/m128, xmm4``

``XOP.128.X8.W0 95 /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPMACSWD_XMM_XMM_XMMM128_XMM: Code = 4080 # type: ignore
"""
``VPMACSWD xmm1, xmm2, xmm3/m128, xmm4``

``XOP.128.X8.W0 96 /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPMACSDQL_XMM_XMM_XMMM128_XMM: Code = 4081 # type: ignore
"""
``VPMACSDQL xmm1, xmm2, xmm3/m128, xmm4``

``XOP.128.X8.W0 97 /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPMACSDD_XMM_XMM_XMMM128_XMM: Code = 4082 # type: ignore
"""
``VPMACSDD xmm1, xmm2, xmm3/m128, xmm4``

``XOP.128.X8.W0 9E /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPMACSDQH_XMM_XMM_XMMM128_XMM: Code = 4083 # type: ignore
"""
``VPMACSDQH xmm1, xmm2, xmm3/m128, xmm4``

``XOP.128.X8.W0 9F /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPCMOV_XMM_XMM_XMMM128_XMM: Code = 4084 # type: ignore
"""
``VPCMOV xmm1, xmm2, xmm3/m128, xmm4``

``XOP.128.X8.W0 A2 /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPCMOV_YMM_YMM_YMMM256_YMM: Code = 4085 # type: ignore
"""
``VPCMOV ymm1, ymm2, ymm3/m256, ymm4``

``XOP.256.X8.W0 A2 /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPCMOV_XMM_XMM_XMM_XMMM128: Code = 4086 # type: ignore
"""
``VPCMOV xmm1, xmm2, xmm3, xmm4/m128``

``XOP.128.X8.W1 A2 /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPCMOV_YMM_YMM_YMM_YMMM256: Code = 4087 # type: ignore
"""
``VPCMOV ymm1, ymm2, ymm3, ymm4/m256``

``XOP.256.X8.W1 A2 /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPPERM_XMM_XMM_XMMM128_XMM: Code = 4088 # type: ignore
"""
``VPPERM xmm1, xmm2, xmm3/m128, xmm4``

``XOP.128.X8.W0 A3 /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPPERM_XMM_XMM_XMM_XMMM128: Code = 4089 # type: ignore
"""
``VPPERM xmm1, xmm2, xmm3, xmm4/m128``

``XOP.128.X8.W1 A3 /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPMADCSSWD_XMM_XMM_XMMM128_XMM: Code = 4090 # type: ignore
"""
``VPMADCSSWD xmm1, xmm2, xmm3/m128, xmm4``

``XOP.128.X8.W0 A6 /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPMADCSWD_XMM_XMM_XMMM128_XMM: Code = 4091 # type: ignore
"""
``VPMADCSWD xmm1, xmm2, xmm3/m128, xmm4``

``XOP.128.X8.W0 B6 /r /is4``

``XOP``

``16/32/64-bit``
"""
XOP_VPROTB_XMM_XMMM128_IMM8: Code = 4092 # type: ignore
"""
``VPROTB xmm1, xmm2/m128, imm8``

``XOP.128.X8.W0 C0 /r ib``

``XOP``

``16/32/64-bit``
"""
XOP_VPROTW_XMM_XMMM128_IMM8: Code = 4093 # type: ignore
"""
``VPROTW xmm1, xmm2/m128, imm8``

``XOP.128.X8.W0 C1 /r ib``

``XOP``

``16/32/64-bit``
"""
XOP_VPROTD_XMM_XMMM128_IMM8: Code = 4094 # type: ignore
"""
``VPROTD xmm1, xmm2/m128, imm8``

``XOP.128.X8.W0 C2 /r ib``

``XOP``

``16/32/64-bit``
"""
XOP_VPROTQ_XMM_XMMM128_IMM8: Code = 4095 # type: ignore
"""
``VPROTQ xmm1, xmm2/m128, imm8``

``XOP.128.X8.W0 C3 /r ib``

``XOP``

``16/32/64-bit``
"""
XOP_VPCOMB_XMM_XMM_XMMM128_IMM8: Code = 4096 # type: ignore
"""
``VPCOMB xmm1, xmm2, xmm3/m128, imm8``

``XOP.128.X8.W0 CC /r ib``

``XOP``

``16/32/64-bit``
"""
XOP_VPCOMW_XMM_XMM_XMMM128_IMM8: Code = 4097 # type: ignore
"""
``VPCOMW xmm1, xmm2, xmm3/m128, imm8``

``XOP.128.X8.W0 CD /r ib``

``XOP``

``16/32/64-bit``
"""
XOP_VPCOMD_XMM_XMM_XMMM128_IMM8: Code = 4098 # type: ignore
"""
``VPCOMD xmm1, xmm2, xmm3/m128, imm8``

``XOP.128.X8.W0 CE /r ib``

``XOP``

``16/32/64-bit``
"""
XOP_VPCOMQ_XMM_XMM_XMMM128_IMM8: Code = 4099 # type: ignore
"""
``VPCOMQ xmm1, xmm2, xmm3/m128, imm8``

``XOP.128.X8.W0 CF /r ib``

``XOP``

``16/32/64-bit``
"""
XOP_VPCOMUB_XMM_XMM_XMMM128_IMM8: Code = 4100 # type: ignore
"""
``VPCOMUB xmm1, xmm2, xmm3/m128, imm8``

``XOP.128.X8.W0 EC /r ib``

``XOP``

``16/32/64-bit``
"""
XOP_VPCOMUW_XMM_XMM_XMMM128_IMM8: Code = 4101 # type: ignore
"""
``VPCOMUW xmm1, xmm2, xmm3/m128, imm8``

``XOP.128.X8.W0 ED /r ib``

``XOP``

``16/32/64-bit``
"""
XOP_VPCOMUD_XMM_XMM_XMMM128_IMM8: Code = 4102 # type: ignore
"""
``VPCOMUD xmm1, xmm2, xmm3/m128, imm8``

``XOP.128.X8.W0 EE /r ib``

``XOP``

``16/32/64-bit``
"""
XOP_VPCOMUQ_XMM_XMM_XMMM128_IMM8: Code = 4103 # type: ignore
"""
``VPCOMUQ xmm1, xmm2, xmm3/m128, imm8``

``XOP.128.X8.W0 EF /r ib``

``XOP``

``16/32/64-bit``
"""
XOP_BLCFILL_R32_RM32: Code = 4104 # type: ignore
"""
``BLCFILL r32, r/m32``

``XOP.L0.X9.W0 01 /1``

``TBM``

``16/32/64-bit``
"""
XOP_BLCFILL_R64_RM64: Code = 4105 # type: ignore
"""
``BLCFILL r64, r/m64``

``XOP.L0.X9.W1 01 /1``

``TBM``

``64-bit``
"""
XOP_BLSFILL_R32_RM32: Code = 4106 # type: ignore
"""
``BLSFILL r32, r/m32``

``XOP.L0.X9.W0 01 /2``

``TBM``

``16/32/64-bit``
"""
XOP_BLSFILL_R64_RM64: Code = 4107 # type: ignore
"""
``BLSFILL r64, r/m64``

``XOP.L0.X9.W1 01 /2``

``TBM``

``64-bit``
"""
XOP_BLCS_R32_RM32: Code = 4108 # type: ignore
"""
``BLCS r32, r/m32``

``XOP.L0.X9.W0 01 /3``

``TBM``

``16/32/64-bit``
"""
XOP_BLCS_R64_RM64: Code = 4109 # type: ignore
"""
``BLCS r64, r/m64``

``XOP.L0.X9.W1 01 /3``

``TBM``

``64-bit``
"""
XOP_TZMSK_R32_RM32: Code = 4110 # type: ignore
"""
``TZMSK r32, r/m32``

``XOP.L0.X9.W0 01 /4``

``TBM``

``16/32/64-bit``
"""
XOP_TZMSK_R64_RM64: Code = 4111 # type: ignore
"""
``TZMSK r64, r/m64``

``XOP.L0.X9.W1 01 /4``

``TBM``

``64-bit``
"""
XOP_BLCIC_R32_RM32: Code = 4112 # type: ignore
"""
``BLCIC r32, r/m32``

``XOP.L0.X9.W0 01 /5``

``TBM``

``16/32/64-bit``
"""
XOP_BLCIC_R64_RM64: Code = 4113 # type: ignore
"""
``BLCIC r64, r/m64``

``XOP.L0.X9.W1 01 /5``

``TBM``

``64-bit``
"""
XOP_BLSIC_R32_RM32: Code = 4114 # type: ignore
"""
``BLSIC r32, r/m32``

``XOP.L0.X9.W0 01 /6``

``TBM``

``16/32/64-bit``
"""
XOP_BLSIC_R64_RM64: Code = 4115 # type: ignore
"""
``BLSIC r64, r/m64``

``XOP.L0.X9.W1 01 /6``

``TBM``

``64-bit``
"""
XOP_T1MSKC_R32_RM32: Code = 4116 # type: ignore
"""
``T1MSKC r32, r/m32``

``XOP.L0.X9.W0 01 /7``

``TBM``

``16/32/64-bit``
"""
XOP_T1MSKC_R64_RM64: Code = 4117 # type: ignore
"""
``T1MSKC r64, r/m64``

``XOP.L0.X9.W1 01 /7``

``TBM``

``64-bit``
"""
XOP_BLCMSK_R32_RM32: Code = 4118 # type: ignore
"""
``BLCMSK r32, r/m32``

``XOP.L0.X9.W0 02 /1``

``TBM``

``16/32/64-bit``
"""
XOP_BLCMSK_R64_RM64: Code = 4119 # type: ignore
"""
``BLCMSK r64, r/m64``

``XOP.L0.X9.W1 02 /1``

``TBM``

``64-bit``
"""
XOP_BLCI_R32_RM32: Code = 4120 # type: ignore
"""
``BLCI r32, r/m32``

``XOP.L0.X9.W0 02 /6``

``TBM``

``16/32/64-bit``
"""
XOP_BLCI_R64_RM64: Code = 4121 # type: ignore
"""
``BLCI r64, r/m64``

``XOP.L0.X9.W1 02 /6``

``TBM``

``64-bit``
"""
XOP_LLWPCB_R32: Code = 4122 # type: ignore
"""
``LLWPCB r32``

``XOP.L0.X9.W0 12 /0``

``LWP``

``16/32/64-bit``
"""
XOP_LLWPCB_R64: Code = 4123 # type: ignore
"""
``LLWPCB r64``

``XOP.L0.X9.W1 12 /0``

``LWP``

``64-bit``
"""
XOP_SLWPCB_R32: Code = 4124 # type: ignore
"""
``SLWPCB r32``

``XOP.L0.X9.W0 12 /1``

``LWP``

``16/32/64-bit``
"""
XOP_SLWPCB_R64: Code = 4125 # type: ignore
"""
``SLWPCB r64``

``XOP.L0.X9.W1 12 /1``

``LWP``

``64-bit``
"""
XOP_VFRCZPS_XMM_XMMM128: Code = 4126 # type: ignore
"""
``VFRCZPS xmm1, xmm2/m128``

``XOP.128.X9.W0 80 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VFRCZPS_YMM_YMMM256: Code = 4127 # type: ignore
"""
``VFRCZPS ymm1, ymm2/m256``

``XOP.256.X9.W0 80 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VFRCZPD_XMM_XMMM128: Code = 4128 # type: ignore
"""
``VFRCZPD xmm1, xmm2/m128``

``XOP.128.X9.W0 81 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VFRCZPD_YMM_YMMM256: Code = 4129 # type: ignore
"""
``VFRCZPD ymm1, ymm2/m256``

``XOP.256.X9.W0 81 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VFRCZSS_XMM_XMMM32: Code = 4130 # type: ignore
"""
``VFRCZSS xmm1, xmm2/m32``

``XOP.128.X9.W0 82 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VFRCZSD_XMM_XMMM64: Code = 4131 # type: ignore
"""
``VFRCZSD xmm1, xmm2/m64``

``XOP.128.X9.W0 83 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPROTB_XMM_XMMM128_XMM: Code = 4132 # type: ignore
"""
``VPROTB xmm1, xmm2/m128, xmm3``

``XOP.128.X9.W0 90 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPROTB_XMM_XMM_XMMM128: Code = 4133 # type: ignore
"""
``VPROTB xmm1, xmm2, xmm3/m128``

``XOP.128.X9.W1 90 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPROTW_XMM_XMMM128_XMM: Code = 4134 # type: ignore
"""
``VPROTW xmm1, xmm2/m128, xmm3``

``XOP.128.X9.W0 91 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPROTW_XMM_XMM_XMMM128: Code = 4135 # type: ignore
"""
``VPROTW xmm1, xmm2, xmm3/m128``

``XOP.128.X9.W1 91 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPROTD_XMM_XMMM128_XMM: Code = 4136 # type: ignore
"""
``VPROTD xmm1, xmm2/m128, xmm3``

``XOP.128.X9.W0 92 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPROTD_XMM_XMM_XMMM128: Code = 4137 # type: ignore
"""
``VPROTD xmm1, xmm2, xmm3/m128``

``XOP.128.X9.W1 92 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPROTQ_XMM_XMMM128_XMM: Code = 4138 # type: ignore
"""
``VPROTQ xmm1, xmm2/m128, xmm3``

``XOP.128.X9.W0 93 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPROTQ_XMM_XMM_XMMM128: Code = 4139 # type: ignore
"""
``VPROTQ xmm1, xmm2, xmm3/m128``

``XOP.128.X9.W1 93 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPSHLB_XMM_XMMM128_XMM: Code = 4140 # type: ignore
"""
``VPSHLB xmm1, xmm2/m128, xmm3``

``XOP.128.X9.W0 94 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPSHLB_XMM_XMM_XMMM128: Code = 4141 # type: ignore
"""
``VPSHLB xmm1, xmm2, xmm3/m128``

``XOP.128.X9.W1 94 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPSHLW_XMM_XMMM128_XMM: Code = 4142 # type: ignore
"""
``VPSHLW xmm1, xmm2/m128, xmm3``

``XOP.128.X9.W0 95 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPSHLW_XMM_XMM_XMMM128: Code = 4143 # type: ignore
"""
``VPSHLW xmm1, xmm2, xmm3/m128``

``XOP.128.X9.W1 95 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPSHLD_XMM_XMMM128_XMM: Code = 4144 # type: ignore
"""
``VPSHLD xmm1, xmm2/m128, xmm3``

``XOP.128.X9.W0 96 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPSHLD_XMM_XMM_XMMM128: Code = 4145 # type: ignore
"""
``VPSHLD xmm1, xmm2, xmm3/m128``

``XOP.128.X9.W1 96 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPSHLQ_XMM_XMMM128_XMM: Code = 4146 # type: ignore
"""
``VPSHLQ xmm1, xmm2/m128, xmm3``

``XOP.128.X9.W0 97 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPSHLQ_XMM_XMM_XMMM128: Code = 4147 # type: ignore
"""
``VPSHLQ xmm1, xmm2, xmm3/m128``

``XOP.128.X9.W1 97 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPSHAB_XMM_XMMM128_XMM: Code = 4148 # type: ignore
"""
``VPSHAB xmm1, xmm2/m128, xmm3``

``XOP.128.X9.W0 98 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPSHAB_XMM_XMM_XMMM128: Code = 4149 # type: ignore
"""
``VPSHAB xmm1, xmm2, xmm3/m128``

``XOP.128.X9.W1 98 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPSHAW_XMM_XMMM128_XMM: Code = 4150 # type: ignore
"""
``VPSHAW xmm1, xmm2/m128, xmm3``

``XOP.128.X9.W0 99 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPSHAW_XMM_XMM_XMMM128: Code = 4151 # type: ignore
"""
``VPSHAW xmm1, xmm2, xmm3/m128``

``XOP.128.X9.W1 99 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPSHAD_XMM_XMMM128_XMM: Code = 4152 # type: ignore
"""
``VPSHAD xmm1, xmm2/m128, xmm3``

``XOP.128.X9.W0 9A /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPSHAD_XMM_XMM_XMMM128: Code = 4153 # type: ignore
"""
``VPSHAD xmm1, xmm2, xmm3/m128``

``XOP.128.X9.W1 9A /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPSHAQ_XMM_XMMM128_XMM: Code = 4154 # type: ignore
"""
``VPSHAQ xmm1, xmm2/m128, xmm3``

``XOP.128.X9.W0 9B /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPSHAQ_XMM_XMM_XMMM128: Code = 4155 # type: ignore
"""
``VPSHAQ xmm1, xmm2, xmm3/m128``

``XOP.128.X9.W1 9B /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPHADDBW_XMM_XMMM128: Code = 4156 # type: ignore
"""
``VPHADDBW xmm1, xmm2/m128``

``XOP.128.X9.W0 C1 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPHADDBD_XMM_XMMM128: Code = 4157 # type: ignore
"""
``VPHADDBD xmm1, xmm2/m128``

``XOP.128.X9.W0 C2 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPHADDBQ_XMM_XMMM128: Code = 4158 # type: ignore
"""
``VPHADDBQ xmm1, xmm2/m128``

``XOP.128.X9.W0 C3 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPHADDWD_XMM_XMMM128: Code = 4159 # type: ignore
"""
``VPHADDWD xmm1, xmm2/m128``

``XOP.128.X9.W0 C6 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPHADDWQ_XMM_XMMM128: Code = 4160 # type: ignore
"""
``VPHADDWQ xmm1, xmm2/m128``

``XOP.128.X9.W0 C7 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPHADDDQ_XMM_XMMM128: Code = 4161 # type: ignore
"""
``VPHADDDQ xmm1, xmm2/m128``

``XOP.128.X9.W0 CB /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPHADDUBW_XMM_XMMM128: Code = 4162 # type: ignore
"""
``VPHADDUBW xmm1, xmm2/m128``

``XOP.128.X9.W0 D1 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPHADDUBD_XMM_XMMM128: Code = 4163 # type: ignore
"""
``VPHADDUBD xmm1, xmm2/m128``

``XOP.128.X9.W0 D2 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPHADDUBQ_XMM_XMMM128: Code = 4164 # type: ignore
"""
``VPHADDUBQ xmm1, xmm2/m128``

``XOP.128.X9.W0 D3 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPHADDUWD_XMM_XMMM128: Code = 4165 # type: ignore
"""
``VPHADDUWD xmm1, xmm2/m128``

``XOP.128.X9.W0 D6 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPHADDUWQ_XMM_XMMM128: Code = 4166 # type: ignore
"""
``VPHADDUWQ xmm1, xmm2/m128``

``XOP.128.X9.W0 D7 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPHADDUDQ_XMM_XMMM128: Code = 4167 # type: ignore
"""
``VPHADDUDQ xmm1, xmm2/m128``

``XOP.128.X9.W0 DB /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPHSUBBW_XMM_XMMM128: Code = 4168 # type: ignore
"""
``VPHSUBBW xmm1, xmm2/m128``

``XOP.128.X9.W0 E1 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPHSUBWD_XMM_XMMM128: Code = 4169 # type: ignore
"""
``VPHSUBWD xmm1, xmm2/m128``

``XOP.128.X9.W0 E2 /r``

``XOP``

``16/32/64-bit``
"""
XOP_VPHSUBDQ_XMM_XMMM128: Code = 4170 # type: ignore
"""
``VPHSUBDQ xmm1, xmm2/m128``

``XOP.128.X9.W0 E3 /r``

``XOP``

``16/32/64-bit``
"""
XOP_BEXTR_R32_RM32_IMM32: Code = 4171 # type: ignore
"""
``BEXTR r32, r/m32, imm32``

``XOP.L0.XA.W0 10 /r id``

``TBM``

``16/32/64-bit``
"""
XOP_BEXTR_R64_RM64_IMM32: Code = 4172 # type: ignore
"""
``BEXTR r64, r/m64, imm32``

``XOP.L0.XA.W1 10 /r id``

``TBM``

``64-bit``
"""
XOP_LWPINS_R32_RM32_IMM32: Code = 4173 # type: ignore
"""
``LWPINS r32, r/m32, imm32``

``XOP.L0.XA.W0 12 /0 id``

``LWP``

``16/32/64-bit``
"""
XOP_LWPINS_R64_RM32_IMM32: Code = 4174 # type: ignore
"""
``LWPINS r64, r/m32, imm32``

``XOP.L0.XA.W1 12 /0 id``

``LWP``

``64-bit``
"""
XOP_LWPVAL_R32_RM32_IMM32: Code = 4175 # type: ignore
"""
``LWPVAL r32, r/m32, imm32``

``XOP.L0.XA.W0 12 /1 id``

``LWP``

``16/32/64-bit``
"""
XOP_LWPVAL_R64_RM32_IMM32: Code = 4176 # type: ignore
"""
``LWPVAL r64, r/m32, imm32``

``XOP.L0.XA.W1 12 /1 id``

``LWP``

``64-bit``
"""
D3NOW_PI2FW_MM_MMM64: Code = 4177 # type: ignore
"""
``PI2FW mm, mm/m64``

``0F 0F /r 0C``

``3DNOWEXT``

``16/32/64-bit``
"""
D3NOW_PI2FD_MM_MMM64: Code = 4178 # type: ignore
"""
``PI2FD mm, mm/m64``

``0F 0F /r 0D``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PF2IW_MM_MMM64: Code = 4179 # type: ignore
"""
``PF2IW mm, mm/m64``

``0F 0F /r 1C``

``3DNOWEXT``

``16/32/64-bit``
"""
D3NOW_PF2ID_MM_MMM64: Code = 4180 # type: ignore
"""
``PF2ID mm, mm/m64``

``0F 0F /r 1D``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PFRCPV_MM_MMM64: Code = 4181 # type: ignore
"""
``PFRCPV mm, mm/m64``

``0F 0F /r 86``

``AMD Geode GX/LX``

``16/32-bit``
"""
D3NOW_PFRSQRTV_MM_MMM64: Code = 4182 # type: ignore
"""
``PFRSQRTV mm, mm/m64``

``0F 0F /r 87``

``AMD Geode GX/LX``

``16/32-bit``
"""
D3NOW_PFNACC_MM_MMM64: Code = 4183 # type: ignore
"""
``PFNACC mm, mm/m64``

``0F 0F /r 8A``

``3DNOWEXT``

``16/32/64-bit``
"""
D3NOW_PFPNACC_MM_MMM64: Code = 4184 # type: ignore
"""
``PFPNACC mm, mm/m64``

``0F 0F /r 8E``

``3DNOWEXT``

``16/32/64-bit``
"""
D3NOW_PFCMPGE_MM_MMM64: Code = 4185 # type: ignore
"""
``PFCMPGE mm, mm/m64``

``0F 0F /r 90``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PFMIN_MM_MMM64: Code = 4186 # type: ignore
"""
``PFMIN mm, mm/m64``

``0F 0F /r 94``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PFRCP_MM_MMM64: Code = 4187 # type: ignore
"""
``PFRCP mm, mm/m64``

``0F 0F /r 96``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PFRSQRT_MM_MMM64: Code = 4188 # type: ignore
"""
``PFRSQRT mm, mm/m64``

``0F 0F /r 97``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PFSUB_MM_MMM64: Code = 4189 # type: ignore
"""
``PFSUB mm, mm/m64``

``0F 0F /r 9A``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PFADD_MM_MMM64: Code = 4190 # type: ignore
"""
``PFADD mm, mm/m64``

``0F 0F /r 9E``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PFCMPGT_MM_MMM64: Code = 4191 # type: ignore
"""
``PFCMPGT mm, mm/m64``

``0F 0F /r A0``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PFMAX_MM_MMM64: Code = 4192 # type: ignore
"""
``PFMAX mm, mm/m64``

``0F 0F /r A4``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PFRCPIT1_MM_MMM64: Code = 4193 # type: ignore
"""
``PFRCPIT1 mm, mm/m64``

``0F 0F /r A6``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PFRSQIT1_MM_MMM64: Code = 4194 # type: ignore
"""
``PFRSQIT1 mm, mm/m64``

``0F 0F /r A7``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PFSUBR_MM_MMM64: Code = 4195 # type: ignore
"""
``PFSUBR mm, mm/m64``

``0F 0F /r AA``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PFACC_MM_MMM64: Code = 4196 # type: ignore
"""
``PFACC mm, mm/m64``

``0F 0F /r AE``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PFCMPEQ_MM_MMM64: Code = 4197 # type: ignore
"""
``PFCMPEQ mm, mm/m64``

``0F 0F /r B0``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PFMUL_MM_MMM64: Code = 4198 # type: ignore
"""
``PFMUL mm, mm/m64``

``0F 0F /r B4``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PFRCPIT2_MM_MMM64: Code = 4199 # type: ignore
"""
``PFRCPIT2 mm, mm/m64``

``0F 0F /r B6``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PMULHRW_MM_MMM64: Code = 4200 # type: ignore
"""
``PMULHRW mm, mm/m64``

``0F 0F /r B7``

``3DNOW``

``16/32/64-bit``
"""
D3NOW_PSWAPD_MM_MMM64: Code = 4201 # type: ignore
"""
``PSWAPD mm, mm/m64``

``0F 0F /r BB``

``3DNOWEXT``

``16/32/64-bit``
"""
D3NOW_PAVGUSB_MM_MMM64: Code = 4202 # type: ignore
"""
``PAVGUSB mm, mm/m64``

``0F 0F /r BF``

``3DNOW``

``16/32/64-bit``
"""
RMPADJUST: Code = 4203 # type: ignore
"""
``RMPADJUST``

``F3 0F 01 FE``

``SEV-SNP``

``64-bit``
"""
RMPUPDATE: Code = 4204 # type: ignore
"""
``RMPUPDATE``

``F2 0F 01 FE``

``SEV-SNP``

``64-bit``
"""
PSMASH: Code = 4205 # type: ignore
"""
``PSMASH``

``F3 0F 01 FF``

``SEV-SNP``

``64-bit``
"""
PVALIDATEW: Code = 4206 # type: ignore
"""
``PVALIDATE``

``a16 F2 0F 01 FF``

``SEV-SNP``

``16/32-bit``
"""
PVALIDATED: Code = 4207 # type: ignore
"""
``PVALIDATE``

``a32 F2 0F 01 FF``

``SEV-SNP``

``16/32/64-bit``
"""
PVALIDATEQ: Code = 4208 # type: ignore
"""
``PVALIDATE``

``a64 F2 0F 01 FF``

``SEV-SNP``

``64-bit``
"""
SERIALIZE: Code = 4209 # type: ignore
"""
``SERIALIZE``

``NP 0F 01 E8``

``SERIALIZE``

``16/32/64-bit``
"""
XSUSLDTRK: Code = 4210 # type: ignore
"""
``XSUSLDTRK``

``F2 0F 01 E8``

``TSXLDTRK``

``16/32/64-bit``
"""
XRESLDTRK: Code = 4211 # type: ignore
"""
``XRESLDTRK``

``F2 0F 01 E9``

``TSXLDTRK``

``16/32/64-bit``
"""
INVLPGBW: Code = 4212 # type: ignore
"""
``INVLPGB``

``a16 NP 0F 01 FE``

``INVLPGB``

``16/32-bit``
"""
INVLPGBD: Code = 4213 # type: ignore
"""
``INVLPGB``

``a32 NP 0F 01 FE``

``INVLPGB``

``16/32/64-bit``
"""
INVLPGBQ: Code = 4214 # type: ignore
"""
``INVLPGB``

``a64 NP 0F 01 FE``

``INVLPGB``

``64-bit``
"""
TLBSYNC: Code = 4215 # type: ignore
"""
``TLBSYNC``

``NP 0F 01 FF``

``INVLPGB``

``16/32/64-bit``
"""
PREFETCHRESERVED3_M8: Code = 4216 # type: ignore
"""
``PREFETCHW m8``

``0F 0D /3``

``PREFETCHW``

``16/32/64-bit``
"""
PREFETCHRESERVED4_M8: Code = 4217 # type: ignore
"""
``PREFETCH m8``

``0F 0D /4``

``PREFETCHW``

``16/32/64-bit``
"""
PREFETCHRESERVED5_M8: Code = 4218 # type: ignore
"""
``PREFETCH m8``

``0F 0D /5``

``PREFETCHW``

``16/32/64-bit``
"""
PREFETCHRESERVED6_M8: Code = 4219 # type: ignore
"""
``PREFETCH m8``

``0F 0D /6``

``PREFETCHW``

``16/32/64-bit``
"""
PREFETCHRESERVED7_M8: Code = 4220 # type: ignore
"""
``PREFETCH m8``

``0F 0D /7``

``PREFETCHW``

``16/32/64-bit``
"""
UD0: Code = 4221 # type: ignore
"""
``UD0``

``0F FF``

``286+``

``16/32/64-bit``
"""
VMGEXIT: Code = 4222 # type: ignore
"""
``VMGEXIT``

``F3 0F 01 D9``

``SEV-ES``

``16/32/64-bit``
"""
GETSECQ: Code = 4223 # type: ignore
"""
``GETSECQ``

``NP o64 0F 37``

``SMX``

``64-bit``
"""
VEX_LDTILECFG_M512: Code = 4224 # type: ignore
"""
``LDTILECFG m512``

``VEX.128.0F38.W0 49 !(11):000:bbb``

``AMX-TILE``

``64-bit``
"""
VEX_TILERELEASE: Code = 4225 # type: ignore
"""
``TILERELEASE``

``VEX.128.0F38.W0 49 C0``

``AMX-TILE``

``64-bit``
"""
VEX_STTILECFG_M512: Code = 4226 # type: ignore
"""
``STTILECFG m512``

``VEX.128.66.0F38.W0 49 !(11):000:bbb``

``AMX-TILE``

``64-bit``
"""
VEX_TILEZERO_TMM: Code = 4227 # type: ignore
"""
``TILEZERO tmm1``

``VEX.128.F2.0F38.W0 49 11:rrr:000``

``AMX-TILE``

``64-bit``
"""
VEX_TILELOADDT1_TMM_SIBMEM: Code = 4228 # type: ignore
"""
``TILELOADDT1 tmm1, sibmem``

``VEX.128.66.0F38.W0 4B !(11):rrr:100``

``AMX-TILE``

``64-bit``
"""
VEX_TILESTORED_SIBMEM_TMM: Code = 4229 # type: ignore
"""
``TILESTORED sibmem, tmm1``

``VEX.128.F3.0F38.W0 4B !(11):rrr:100``

``AMX-TILE``

``64-bit``
"""
VEX_TILELOADD_TMM_SIBMEM: Code = 4230 # type: ignore
"""
``TILELOADD tmm1, sibmem``

``VEX.128.F2.0F38.W0 4B !(11):rrr:100``

``AMX-TILE``

``64-bit``
"""
VEX_TDPBF16PS_TMM_TMM_TMM: Code = 4231 # type: ignore
"""
``TDPBF16PS tmm1, tmm2, tmm3``

``VEX.128.F3.0F38.W0 5C 11:rrr:bbb``

``AMX-BF16``

``64-bit``
"""
VEX_TDPBUUD_TMM_TMM_TMM: Code = 4232 # type: ignore
"""
``TDPBUUD tmm1, tmm2, tmm3``

``VEX.128.0F38.W0 5E 11:rrr:bbb``

``AMX-INT8``

``64-bit``
"""
VEX_TDPBUSD_TMM_TMM_TMM: Code = 4233 # type: ignore
"""
``TDPBUSD tmm1, tmm2, tmm3``

``VEX.128.66.0F38.W0 5E 11:rrr:bbb``

``AMX-INT8``

``64-bit``
"""
VEX_TDPBSUD_TMM_TMM_TMM: Code = 4234 # type: ignore
"""
``TDPBSUD tmm1, tmm2, tmm3``

``VEX.128.F3.0F38.W0 5E 11:rrr:bbb``

``AMX-INT8``

``64-bit``
"""
VEX_TDPBSSD_TMM_TMM_TMM: Code = 4235 # type: ignore
"""
``TDPBSSD tmm1, tmm2, tmm3``

``VEX.128.F2.0F38.W0 5E 11:rrr:bbb``

``AMX-INT8``

``64-bit``
"""
FNSTDW_AX: Code = 4236 # type: ignore
"""
``FNSTDW AX``

``DF E1``

``387 SL``

``16/32-bit``
"""
FNSTSG_AX: Code = 4237 # type: ignore
"""
``FNSTSG AX``

``DF E2``

``387 SL``

``16/32-bit``
"""
RDSHR_RM32: Code = 4238 # type: ignore
"""
``RDSHR r/m32``

``0F 36 /0``

``Cyrix 6x86MX, M II, III``

``16/32-bit``
"""
WRSHR_RM32: Code = 4239 # type: ignore
"""
``WRSHR r/m32``

``0F 37 /0``

``Cyrix 6x86MX, M II, III``

``16/32-bit``
"""
SMINT: Code = 4240 # type: ignore
"""
``SMINT``

``0F 38``

``Cyrix 6x86MX+, AMD Geode GX/LX``

``16/32-bit``
"""
DMINT: Code = 4241 # type: ignore
"""
``DMINT``

``0F 39``

``AMD Geode GX/LX``

``16/32-bit``
"""
RDM: Code = 4242 # type: ignore
"""
``RDM``

``0F 3A``

``AMD Geode GX/LX``

``16/32-bit``
"""
SVDC_M80_SREG: Code = 4243 # type: ignore
"""
``SVDC m80, Sreg``

``0F 78 /r``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
RSDC_SREG_M80: Code = 4244 # type: ignore
"""
``RSDC Sreg, m80``

``0F 79 /r``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
SVLDT_M80: Code = 4245 # type: ignore
"""
``SVLDT m80``

``0F 7A /0``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
RSLDT_M80: Code = 4246 # type: ignore
"""
``RSLDT m80``

``0F 7B /0``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
SVTS_M80: Code = 4247 # type: ignore
"""
``SVTS m80``

``0F 7C /0``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
RSTS_M80: Code = 4248 # type: ignore
"""
``RSTS m80``

``0F 7D /0``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
SMINT_0F7E: Code = 4249 # type: ignore
"""
``SMINT``

``0F 7E``

``Cyrix 6x86 or earlier``

``16/32-bit``
"""
BB0_RESET: Code = 4250 # type: ignore
"""
``BB0_RESET``

``0F 3A``

``Cyrix MediaGX, GXm, GXLV, GX1``

``16/32-bit``
"""
BB1_RESET: Code = 4251 # type: ignore
"""
``BB1_RESET``

``0F 3B``

``Cyrix MediaGX, GXm, GXLV, GX1``

``16/32-bit``
"""
CPU_WRITE: Code = 4252 # type: ignore
"""
``CPU_WRITE``

``0F 3C``

``Cyrix MediaGX, GXm, GXLV, GX1``

``16/32-bit``
"""
CPU_READ: Code = 4253 # type: ignore
"""
``CPU_READ``

``0F 3D``

``Cyrix MediaGX, GXm, GXLV, GX1``

``16/32-bit``
"""
ALTINST: Code = 4254 # type: ignore
"""
``ALTINST``

``0F 3F``

``Centaur AIS``

``16/32-bit``
"""
PAVEB_MM_MMM64: Code = 4255 # type: ignore
"""
``PAVEB mm, mm/m64``

``0F 50 /r``

``CYRIX_EMMI``

``16/32-bit``
"""
PADDSIW_MM_MMM64: Code = 4256 # type: ignore
"""
``PADDSIW mm, mm/m64``

``0F 51 /r``

``CYRIX_EMMI``

``16/32-bit``
"""
PMAGW_MM_MMM64: Code = 4257 # type: ignore
"""
``PMAGW mm, mm/m64``

``0F 52 /r``

``CYRIX_EMMI``

``16/32-bit``
"""
PDISTIB_MM_M64: Code = 4258 # type: ignore
"""
``PDISTIB mm, m64``

``0F 54 /r``

``CYRIX_EMMI``

``16/32-bit``
"""
PSUBSIW_MM_MMM64: Code = 4259 # type: ignore
"""
``PSUBSIW mm, mm/m64``

``0F 55 /r``

``CYRIX_EMMI``

``16/32-bit``
"""
PMVZB_MM_M64: Code = 4260 # type: ignore
"""
``PMVZB mm, m64``

``0F 58 /r``

``CYRIX_EMMI``

``16/32-bit``
"""
PMULHRW_MM_MMM64: Code = 4261 # type: ignore
"""
``PMULHRW mm, mm/m64``

``0F 59 /r``

``CYRIX_EMMI``

``16/32-bit``
"""
PMVNZB_MM_M64: Code = 4262 # type: ignore
"""
``PMVNZB mm, m64``

``0F 5A /r``

``CYRIX_EMMI``

``16/32-bit``
"""
PMVLZB_MM_M64: Code = 4263 # type: ignore
"""
``PMVLZB mm, m64``

``0F 5B /r``

``CYRIX_EMMI``

``16/32-bit``
"""
PMVGEZB_MM_M64: Code = 4264 # type: ignore
"""
``PMVGEZB mm, m64``

``0F 5C /r``

``CYRIX_EMMI``

``16/32-bit``
"""
PMULHRIW_MM_MMM64: Code = 4265 # type: ignore
"""
``PMULHRIW mm, mm/m64``

``0F 5D /r``

``CYRIX_EMMI``

``16/32-bit``
"""
PMACHRIW_MM_M64: Code = 4266 # type: ignore
"""
``PMACHRIW mm, m64``

``0F 5E /r``

``CYRIX_EMMI``

``16/32-bit``
"""
CYRIX_D9D7: Code = 4267 # type: ignore
"""
``UNDOC``

``D9 D7``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
CYRIX_D9E2: Code = 4268 # type: ignore
"""
``UNDOC``

``D9 E2``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
FTSTP: Code = 4269 # type: ignore
"""
``FTSTP``

``D9 E6``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
CYRIX_D9E7: Code = 4270 # type: ignore
"""
``UNDOC``

``D9 E7``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
FRINT2: Code = 4271 # type: ignore
"""
``FRINT2``

``DB FC``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
FRICHOP: Code = 4272 # type: ignore
"""
``FRICHOP``

``DD FC``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
CYRIX_DED8: Code = 4273 # type: ignore
"""
``UNDOC``

``DE D8``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
CYRIX_DEDA: Code = 4274 # type: ignore
"""
``UNDOC``

``DE DA``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
CYRIX_DEDC: Code = 4275 # type: ignore
"""
``UNDOC``

``DE DC``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
CYRIX_DEDD: Code = 4276 # type: ignore
"""
``UNDOC``

``DE DD``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
CYRIX_DEDE: Code = 4277 # type: ignore
"""
``UNDOC``

``DE DE``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
FRINEAR: Code = 4278 # type: ignore
"""
``FRINEAR``

``DF FC``

``Cyrix, AMD Geode GX/LX``

``16/32-bit``
"""
TDCALL: Code = 4279 # type: ignore
"""
``TDCALL``

``66 0F 01 CC``

``TDX``

``16/32/64-bit``
"""
SEAMRET: Code = 4280 # type: ignore
"""
``SEAMRET``

``66 0F 01 CD``

``TDX``

``64-bit``
"""
SEAMOPS: Code = 4281 # type: ignore
"""
``SEAMOPS``

``66 0F 01 CE``

``TDX``

``64-bit``
"""
SEAMCALL: Code = 4282 # type: ignore
"""
``SEAMCALL``

``66 0F 01 CF``

``TDX``

``64-bit``
"""
AESENCWIDE128KL_M384: Code = 4283 # type: ignore
"""
``AESENCWIDE128KL m384, <XMM0-7>``

``F3 0F 38 D8 !(11):000:bbb``

``AESKLE and WIDE_KL``

``16/32/64-bit``
"""
AESDECWIDE128KL_M384: Code = 4284 # type: ignore
"""
``AESDECWIDE128KL m384, <XMM0-7>``

``F3 0F 38 D8 !(11):001:bbb``

``AESKLE and WIDE_KL``

``16/32/64-bit``
"""
AESENCWIDE256KL_M512: Code = 4285 # type: ignore
"""
``AESENCWIDE256KL m512, <XMM0-7>``

``F3 0F 38 D8 !(11):010:bbb``

``AESKLE and WIDE_KL``

``16/32/64-bit``
"""
AESDECWIDE256KL_M512: Code = 4286 # type: ignore
"""
``AESDECWIDE256KL m512, <XMM0-7>``

``F3 0F 38 D8 !(11):011:bbb``

``AESKLE and WIDE_KL``

``16/32/64-bit``
"""
LOADIWKEY_XMM_XMM: Code = 4287 # type: ignore
"""
``LOADIWKEY xmm1, xmm2, <EAX>, <XMM0>``

``F3 0F 38 DC 11:rrr:bbb``

``KL``

``16/32/64-bit``
"""
AESENC128KL_XMM_M384: Code = 4288 # type: ignore
"""
``AESENC128KL xmm, m384``

``F3 0F 38 DC !(11):rrr:bbb``

``AESKLE``

``16/32/64-bit``
"""
AESDEC128KL_XMM_M384: Code = 4289 # type: ignore
"""
``AESDEC128KL xmm, m384``

``F3 0F 38 DD !(11):rrr:bbb``

``AESKLE``

``16/32/64-bit``
"""
AESENC256KL_XMM_M512: Code = 4290 # type: ignore
"""
``AESENC256KL xmm, m512``

``F3 0F 38 DE !(11):rrr:bbb``

``AESKLE``

``16/32/64-bit``
"""
AESDEC256KL_XMM_M512: Code = 4291 # type: ignore
"""
``AESDEC256KL xmm, m512``

``F3 0F 38 DF !(11):rrr:bbb``

``AESKLE``

``16/32/64-bit``
"""
ENCODEKEY128_R32_R32: Code = 4292 # type: ignore
"""
``ENCODEKEY128 r32, r32, <XMM0-2>, <XMM4-6>``

``F3 0F 38 FA 11:rrr:bbb``

``AESKLE``

``16/32/64-bit``
"""
ENCODEKEY256_R32_R32: Code = 4293 # type: ignore
"""
``ENCODEKEY256 r32, r32, <XMM0-6>``

``F3 0F 38 FB 11:rrr:bbb``

``AESKLE``

``16/32/64-bit``
"""
VEX_VBROADCASTSS_XMM_XMM: Code = 4294 # type: ignore
"""
``VBROADCASTSS xmm1, xmm2``

``VEX.128.66.0F38.W0 18 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VBROADCASTSS_YMM_XMM: Code = 4295 # type: ignore
"""
``VBROADCASTSS ymm1, xmm2``

``VEX.256.66.0F38.W0 18 /r``

``AVX2``

``16/32/64-bit``
"""
VEX_VBROADCASTSD_YMM_XMM: Code = 4296 # type: ignore
"""
``VBROADCASTSD ymm1, xmm2``

``VEX.256.66.0F38.W0 19 /r``

``AVX2``

``16/32/64-bit``
"""
VMGEXIT_F2: Code = 4297 # type: ignore
"""
``VMGEXIT``

``F2 0F 01 D9``

``SEV-ES``

``16/32/64-bit``
"""
UIRET: Code = 4298 # type: ignore
"""
``UIRET``

``F3 0F 01 EC``

``UINTR``

``64-bit``
"""
TESTUI: Code = 4299 # type: ignore
"""
``TESTUI``

``F3 0F 01 ED``

``UINTR``

``64-bit``
"""
CLUI: Code = 4300 # type: ignore
"""
``CLUI``

``F3 0F 01 EE``

``UINTR``

``64-bit``
"""
STUI: Code = 4301 # type: ignore
"""
``STUI``

``F3 0F 01 EF``

``UINTR``

``64-bit``
"""
SENDUIPI_R64: Code = 4302 # type: ignore
"""
``SENDUIPI r64``

``F3 0F C7 /6``

``UINTR``

``64-bit``
"""
HRESET_IMM8: Code = 4303 # type: ignore
"""
``HRESET imm8, <EAX>``

``F3 0F 3A F0 C0 ib``

``HRESET``

``16/32/64-bit``
"""
VEX_VPDPBUSD_XMM_XMM_XMMM128: Code = 4304 # type: ignore
"""
``VPDPBUSD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 50 /r``

``AVX-VNNI``

``16/32/64-bit``
"""
VEX_VPDPBUSD_YMM_YMM_YMMM256: Code = 4305 # type: ignore
"""
``VPDPBUSD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 50 /r``

``AVX-VNNI``

``16/32/64-bit``
"""
VEX_VPDPBUSDS_XMM_XMM_XMMM128: Code = 4306 # type: ignore
"""
``VPDPBUSDS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 51 /r``

``AVX-VNNI``

``16/32/64-bit``
"""
VEX_VPDPBUSDS_YMM_YMM_YMMM256: Code = 4307 # type: ignore
"""
``VPDPBUSDS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 51 /r``

``AVX-VNNI``

``16/32/64-bit``
"""
VEX_VPDPWSSD_XMM_XMM_XMMM128: Code = 4308 # type: ignore
"""
``VPDPWSSD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 52 /r``

``AVX-VNNI``

``16/32/64-bit``
"""
VEX_VPDPWSSD_YMM_YMM_YMMM256: Code = 4309 # type: ignore
"""
``VPDPWSSD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 52 /r``

``AVX-VNNI``

``16/32/64-bit``
"""
VEX_VPDPWSSDS_XMM_XMM_XMMM128: Code = 4310 # type: ignore
"""
``VPDPWSSDS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 53 /r``

``AVX-VNNI``

``16/32/64-bit``
"""
VEX_VPDPWSSDS_YMM_YMM_YMMM256: Code = 4311 # type: ignore
"""
``VPDPWSSDS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 53 /r``

``AVX-VNNI``

``16/32/64-bit``
"""
CCS_HASH_16: Code = 4312 # type: ignore
"""
``CCS_HASH``

``a16 F3 0F A6 E8``

``PADLOCK_GMI``

``16/32-bit``
"""
CCS_HASH_32: Code = 4313 # type: ignore
"""
``CCS_HASH``

``a32 F3 0F A6 E8``

``PADLOCK_GMI``

``16/32/64-bit``
"""
CCS_HASH_64: Code = 4314 # type: ignore
"""
``CCS_HASH``

``a64 F3 0F A6 E8``

``PADLOCK_GMI``

``64-bit``
"""
CCS_ENCRYPT_16: Code = 4315 # type: ignore
"""
``CCS_ENCRYPT``

``a16 F3 0F A7 F0``

``PADLOCK_GMI``

``16/32-bit``
"""
CCS_ENCRYPT_32: Code = 4316 # type: ignore
"""
``CCS_ENCRYPT``

``a32 F3 0F A7 F0``

``PADLOCK_GMI``

``16/32/64-bit``
"""
CCS_ENCRYPT_64: Code = 4317 # type: ignore
"""
``CCS_ENCRYPT``

``a64 F3 0F A7 F0``

``PADLOCK_GMI``

``64-bit``
"""
LKGS_RM16: Code = 4318 # type: ignore
"""
``LKGS r/m16``

``o16 F2 0F 00 /6``

``LKGS``

``64-bit``
"""
LKGS_R32M16: Code = 4319 # type: ignore
"""
``LKGS r32/m16``

``o32 F2 0F 00 /6``

``LKGS``

``64-bit``
"""
LKGS_R64M16: Code = 4320 # type: ignore
"""
``LKGS r64/m16``

``F2 o64 0F 00 /6``

``LKGS``

``64-bit``
"""
ERETU: Code = 4321 # type: ignore
"""
``ERETU``

``F3 0F 01 CA``

``FRED``

``64-bit``
"""
ERETS: Code = 4322 # type: ignore
"""
``ERETS``

``F2 0F 01 CA``

``FRED``

``64-bit``
"""
EVEX_VADDPH_XMM_K1Z_XMM_XMMM128B16: Code = 4323 # type: ignore
"""
``VADDPH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.MAP5.W0 58 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VADDPH_YMM_K1Z_YMM_YMMM256B16: Code = 4324 # type: ignore
"""
``VADDPH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.MAP5.W0 58 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VADDPH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4325 # type: ignore
"""
``VADDPH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.MAP5.W0 58 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VADDSH_XMM_K1Z_XMM_XMMM16_ER: Code = 4326 # type: ignore
"""
``VADDSH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.F3.MAP5.W0 58 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCMPPH_KR_K1_XMM_XMMM128B16_IMM8: Code = 4327 # type: ignore
"""
``VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8``

``EVEX.128.0F3A.W0 C2 /r ib``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCMPPH_KR_K1_YMM_YMMM256B16_IMM8: Code = 4328 # type: ignore
"""
``VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8``

``EVEX.256.0F3A.W0 C2 /r ib``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCMPPH_KR_K1_ZMM_ZMMM512B16_IMM8_SAE: Code = 4329 # type: ignore
"""
``VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8``

``EVEX.512.0F3A.W0 C2 /r ib``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCMPSH_KR_K1_XMM_XMMM16_IMM8_SAE: Code = 4330 # type: ignore
"""
``VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8``

``EVEX.LIG.F3.0F3A.W0 C2 /r ib``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCOMISH_XMM_XMMM16_SAE: Code = 4331 # type: ignore
"""
``VCOMISH xmm1, xmm2/m16{sae}``

``EVEX.LIG.MAP5.W0 2F /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTDQ2PH_XMM_K1Z_XMMM128B32: Code = 4332 # type: ignore
"""
``VCVTDQ2PH xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.MAP5.W0 5B /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTDQ2PH_XMM_K1Z_YMMM256B32: Code = 4333 # type: ignore
"""
``VCVTDQ2PH xmm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.MAP5.W0 5B /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTDQ2PH_YMM_K1Z_ZMMM512B32_ER: Code = 4334 # type: ignore
"""
``VCVTDQ2PH ymm1 {k1}{z}, zmm2/m512/m32bcst{er}``

``EVEX.512.MAP5.W0 5B /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPD2PH_XMM_K1Z_XMMM128B64: Code = 4335 # type: ignore
"""
``VCVTPD2PH xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.66.MAP5.W1 5A /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPD2PH_XMM_K1Z_YMMM256B64: Code = 4336 # type: ignore
"""
``VCVTPD2PH xmm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.66.MAP5.W1 5A /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPD2PH_XMM_K1Z_ZMMM512B64_ER: Code = 4337 # type: ignore
"""
``VCVTPD2PH xmm1 {k1}{z}, zmm2/m512/m64bcst{er}``

``EVEX.512.66.MAP5.W1 5A /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2DQ_XMM_K1Z_XMMM64B16: Code = 4338 # type: ignore
"""
``VCVTPH2DQ xmm1 {k1}{z}, xmm2/m64/m16bcst``

``EVEX.128.66.MAP5.W0 5B /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2DQ_YMM_K1Z_XMMM128B16: Code = 4339 # type: ignore
"""
``VCVTPH2DQ ymm1 {k1}{z}, xmm2/m128/m16bcst``

``EVEX.256.66.MAP5.W0 5B /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2DQ_ZMM_K1Z_YMMM256B16_ER: Code = 4340 # type: ignore
"""
``VCVTPH2DQ zmm1 {k1}{z}, ymm2/m256/m16bcst{er}``

``EVEX.512.66.MAP5.W0 5B /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2PD_XMM_K1Z_XMMM32B16: Code = 4341 # type: ignore
"""
``VCVTPH2PD xmm1 {k1}{z}, xmm2/m32/m16bcst``

``EVEX.128.MAP5.W0 5A /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2PD_YMM_K1Z_XMMM64B16: Code = 4342 # type: ignore
"""
``VCVTPH2PD ymm1 {k1}{z}, xmm2/m64/m16bcst``

``EVEX.256.MAP5.W0 5A /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2PD_ZMM_K1Z_XMMM128B16_SAE: Code = 4343 # type: ignore
"""
``VCVTPH2PD zmm1 {k1}{z}, xmm2/m128/m16bcst{sae}``

``EVEX.512.MAP5.W0 5A /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2PSX_XMM_K1Z_XMMM64B16: Code = 4344 # type: ignore
"""
``VCVTPH2PSX xmm1 {k1}{z}, xmm2/m64/m16bcst``

``EVEX.128.66.MAP6.W0 13 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2PSX_YMM_K1Z_XMMM128B16: Code = 4345 # type: ignore
"""
``VCVTPH2PSX ymm1 {k1}{z}, xmm2/m128/m16bcst``

``EVEX.256.66.MAP6.W0 13 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2PSX_ZMM_K1Z_YMMM256B16_SAE: Code = 4346 # type: ignore
"""
``VCVTPH2PSX zmm1 {k1}{z}, ymm2/m256/m16bcst{sae}``

``EVEX.512.66.MAP6.W0 13 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2QQ_XMM_K1Z_XMMM32B16: Code = 4347 # type: ignore
"""
``VCVTPH2QQ xmm1 {k1}{z}, xmm2/m32/m16bcst``

``EVEX.128.66.MAP5.W0 7B /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2QQ_YMM_K1Z_XMMM64B16: Code = 4348 # type: ignore
"""
``VCVTPH2QQ ymm1 {k1}{z}, xmm2/m64/m16bcst``

``EVEX.256.66.MAP5.W0 7B /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2QQ_ZMM_K1Z_XMMM128B16_ER: Code = 4349 # type: ignore
"""
``VCVTPH2QQ zmm1 {k1}{z}, xmm2/m128/m16bcst{er}``

``EVEX.512.66.MAP5.W0 7B /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2UDQ_XMM_K1Z_XMMM64B16: Code = 4350 # type: ignore
"""
``VCVTPH2UDQ xmm1 {k1}{z}, xmm2/m64/m16bcst``

``EVEX.128.MAP5.W0 79 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2UDQ_YMM_K1Z_XMMM128B16: Code = 4351 # type: ignore
"""
``VCVTPH2UDQ ymm1 {k1}{z}, xmm2/m128/m16bcst``

``EVEX.256.MAP5.W0 79 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2UDQ_ZMM_K1Z_YMMM256B16_ER: Code = 4352 # type: ignore
"""
``VCVTPH2UDQ zmm1 {k1}{z}, ymm2/m256/m16bcst{er}``

``EVEX.512.MAP5.W0 79 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2UQQ_XMM_K1Z_XMMM32B16: Code = 4353 # type: ignore
"""
``VCVTPH2UQQ xmm1 {k1}{z}, xmm2/m32/m16bcst``

``EVEX.128.66.MAP5.W0 79 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2UQQ_YMM_K1Z_XMMM64B16: Code = 4354 # type: ignore
"""
``VCVTPH2UQQ ymm1 {k1}{z}, xmm2/m64/m16bcst``

``EVEX.256.66.MAP5.W0 79 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2UQQ_ZMM_K1Z_XMMM128B16_ER: Code = 4355 # type: ignore
"""
``VCVTPH2UQQ zmm1 {k1}{z}, xmm2/m128/m16bcst{er}``

``EVEX.512.66.MAP5.W0 79 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2UW_XMM_K1Z_XMMM128B16: Code = 4356 # type: ignore
"""
``VCVTPH2UW xmm1 {k1}{z}, xmm2/m128/m16bcst``

``EVEX.128.MAP5.W0 7D /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2UW_YMM_K1Z_YMMM256B16: Code = 4357 # type: ignore
"""
``VCVTPH2UW ymm1 {k1}{z}, ymm2/m256/m16bcst``

``EVEX.256.MAP5.W0 7D /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2UW_ZMM_K1Z_ZMMM512B16_ER: Code = 4358 # type: ignore
"""
``VCVTPH2UW zmm1 {k1}{z}, zmm2/m512/m16bcst{er}``

``EVEX.512.MAP5.W0 7D /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2W_XMM_K1Z_XMMM128B16: Code = 4359 # type: ignore
"""
``VCVTPH2W xmm1 {k1}{z}, xmm2/m128/m16bcst``

``EVEX.128.66.MAP5.W0 7D /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2W_YMM_K1Z_YMMM256B16: Code = 4360 # type: ignore
"""
``VCVTPH2W ymm1 {k1}{z}, ymm2/m256/m16bcst``

``EVEX.256.66.MAP5.W0 7D /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPH2W_ZMM_K1Z_ZMMM512B16_ER: Code = 4361 # type: ignore
"""
``VCVTPH2W zmm1 {k1}{z}, zmm2/m512/m16bcst{er}``

``EVEX.512.66.MAP5.W0 7D /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPS2PHX_XMM_K1Z_XMMM128B32: Code = 4362 # type: ignore
"""
``VCVTPS2PHX xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.66.MAP5.W0 1D /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPS2PHX_XMM_K1Z_YMMM256B32: Code = 4363 # type: ignore
"""
``VCVTPS2PHX xmm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.66.MAP5.W0 1D /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTPS2PHX_YMM_K1Z_ZMMM512B32_ER: Code = 4364 # type: ignore
"""
``VCVTPS2PHX ymm1 {k1}{z}, zmm2/m512/m32bcst{er}``

``EVEX.512.66.MAP5.W0 1D /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTQQ2PH_XMM_K1Z_XMMM128B64: Code = 4365 # type: ignore
"""
``VCVTQQ2PH xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.MAP5.W1 5B /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTQQ2PH_XMM_K1Z_YMMM256B64: Code = 4366 # type: ignore
"""
``VCVTQQ2PH xmm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.MAP5.W1 5B /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTQQ2PH_XMM_K1Z_ZMMM512B64_ER: Code = 4367 # type: ignore
"""
``VCVTQQ2PH xmm1 {k1}{z}, zmm2/m512/m64bcst{er}``

``EVEX.512.MAP5.W1 5B /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTSD2SH_XMM_K1Z_XMM_XMMM64_ER: Code = 4368 # type: ignore
"""
``VCVTSD2SH xmm1 {k1}{z}, xmm2, xmm3/m64{er}``

``EVEX.LIG.F2.MAP5.W1 5A /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTSH2SD_XMM_K1Z_XMM_XMMM16_SAE: Code = 4369 # type: ignore
"""
``VCVTSH2SD xmm1 {k1}{z}, xmm2, xmm3/m16{sae}``

``EVEX.LIG.F3.MAP5.W0 5A /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTSH2SI_R32_XMMM16_ER: Code = 4370 # type: ignore
"""
``VCVTSH2SI r32, xmm1/m16{er}``

``EVEX.LIG.F3.MAP5.W0 2D /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTSH2SI_R64_XMMM16_ER: Code = 4371 # type: ignore
"""
``VCVTSH2SI r64, xmm1/m16{er}``

``EVEX.LIG.F3.MAP5.W1 2D /r``

``AVX512-FP16``

``64-bit``
"""
EVEX_VCVTSH2SS_XMM_K1Z_XMM_XMMM16_SAE: Code = 4372 # type: ignore
"""
``VCVTSH2SS xmm1 {k1}{z}, xmm2, xmm3/m16{sae}``

``EVEX.LIG.MAP6.W0 13 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTSH2USI_R32_XMMM16_ER: Code = 4373 # type: ignore
"""
``VCVTSH2USI r32, xmm1/m16{er}``

``EVEX.LIG.F3.MAP5.W0 79 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTSH2USI_R64_XMMM16_ER: Code = 4374 # type: ignore
"""
``VCVTSH2USI r64, xmm1/m16{er}``

``EVEX.LIG.F3.MAP5.W1 79 /r``

``AVX512-FP16``

``64-bit``
"""
EVEX_VCVTSI2SH_XMM_XMM_RM32_ER: Code = 4375 # type: ignore
"""
``VCVTSI2SH xmm1, xmm2, r/m32{er}``

``EVEX.LIG.F3.MAP5.W0 2A /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTSI2SH_XMM_XMM_RM64_ER: Code = 4376 # type: ignore
"""
``VCVTSI2SH xmm1, xmm2, r/m64{er}``

``EVEX.LIG.F3.MAP5.W1 2A /r``

``AVX512-FP16``

``64-bit``
"""
EVEX_VCVTSS2SH_XMM_K1Z_XMM_XMMM32_ER: Code = 4377 # type: ignore
"""
``VCVTSS2SH xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.MAP5.W0 1D /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2DQ_XMM_K1Z_XMMM64B16: Code = 4378 # type: ignore
"""
``VCVTTPH2DQ xmm1 {k1}{z}, xmm2/m64/m16bcst``

``EVEX.128.F3.MAP5.W0 5B /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2DQ_YMM_K1Z_XMMM128B16: Code = 4379 # type: ignore
"""
``VCVTTPH2DQ ymm1 {k1}{z}, xmm2/m128/m16bcst``

``EVEX.256.F3.MAP5.W0 5B /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2DQ_ZMM_K1Z_YMMM256B16_SAE: Code = 4380 # type: ignore
"""
``VCVTTPH2DQ zmm1 {k1}{z}, ymm2/m256/m16bcst{sae}``

``EVEX.512.F3.MAP5.W0 5B /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2QQ_XMM_K1Z_XMMM32B16: Code = 4381 # type: ignore
"""
``VCVTTPH2QQ xmm1 {k1}{z}, xmm2/m32/m16bcst``

``EVEX.128.66.MAP5.W0 7A /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2QQ_YMM_K1Z_XMMM64B16: Code = 4382 # type: ignore
"""
``VCVTTPH2QQ ymm1 {k1}{z}, xmm2/m64/m16bcst``

``EVEX.256.66.MAP5.W0 7A /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2QQ_ZMM_K1Z_XMMM128B16_SAE: Code = 4383 # type: ignore
"""
``VCVTTPH2QQ zmm1 {k1}{z}, xmm2/m128/m16bcst{sae}``

``EVEX.512.66.MAP5.W0 7A /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2UDQ_XMM_K1Z_XMMM64B16: Code = 4384 # type: ignore
"""
``VCVTTPH2UDQ xmm1 {k1}{z}, xmm2/m64/m16bcst``

``EVEX.128.MAP5.W0 78 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2UDQ_YMM_K1Z_XMMM128B16: Code = 4385 # type: ignore
"""
``VCVTTPH2UDQ ymm1 {k1}{z}, xmm2/m128/m16bcst``

``EVEX.256.MAP5.W0 78 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2UDQ_ZMM_K1Z_YMMM256B16_SAE: Code = 4386 # type: ignore
"""
``VCVTTPH2UDQ zmm1 {k1}{z}, ymm2/m256/m16bcst{sae}``

``EVEX.512.MAP5.W0 78 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2UQQ_XMM_K1Z_XMMM32B16: Code = 4387 # type: ignore
"""
``VCVTTPH2UQQ xmm1 {k1}{z}, xmm2/m32/m16bcst``

``EVEX.128.66.MAP5.W0 78 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2UQQ_YMM_K1Z_XMMM64B16: Code = 4388 # type: ignore
"""
``VCVTTPH2UQQ ymm1 {k1}{z}, xmm2/m64/m16bcst``

``EVEX.256.66.MAP5.W0 78 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2UQQ_ZMM_K1Z_XMMM128B16_SAE: Code = 4389 # type: ignore
"""
``VCVTTPH2UQQ zmm1 {k1}{z}, xmm2/m128/m16bcst{sae}``

``EVEX.512.66.MAP5.W0 78 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2UW_XMM_K1Z_XMMM128B16: Code = 4390 # type: ignore
"""
``VCVTTPH2UW xmm1 {k1}{z}, xmm2/m128/m16bcst``

``EVEX.128.MAP5.W0 7C /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2UW_YMM_K1Z_YMMM256B16: Code = 4391 # type: ignore
"""
``VCVTTPH2UW ymm1 {k1}{z}, ymm2/m256/m16bcst``

``EVEX.256.MAP5.W0 7C /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2UW_ZMM_K1Z_ZMMM512B16_SAE: Code = 4392 # type: ignore
"""
``VCVTTPH2UW zmm1 {k1}{z}, zmm2/m512/m16bcst{sae}``

``EVEX.512.MAP5.W0 7C /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2W_XMM_K1Z_XMMM128B16: Code = 4393 # type: ignore
"""
``VCVTTPH2W xmm1 {k1}{z}, xmm2/m128/m16bcst``

``EVEX.128.66.MAP5.W0 7C /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2W_YMM_K1Z_YMMM256B16: Code = 4394 # type: ignore
"""
``VCVTTPH2W ymm1 {k1}{z}, ymm2/m256/m16bcst``

``EVEX.256.66.MAP5.W0 7C /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTPH2W_ZMM_K1Z_ZMMM512B16_SAE: Code = 4395 # type: ignore
"""
``VCVTTPH2W zmm1 {k1}{z}, zmm2/m512/m16bcst{sae}``

``EVEX.512.66.MAP5.W0 7C /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTSH2SI_R32_XMMM16_SAE: Code = 4396 # type: ignore
"""
``VCVTTSH2SI r32, xmm1/m16{sae}``

``EVEX.LIG.F3.MAP5.W0 2C /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTSH2SI_R64_XMMM16_SAE: Code = 4397 # type: ignore
"""
``VCVTTSH2SI r64, xmm1/m16{sae}``

``EVEX.LIG.F3.MAP5.W1 2C /r``

``AVX512-FP16``

``64-bit``
"""
EVEX_VCVTTSH2USI_R32_XMMM16_SAE: Code = 4398 # type: ignore
"""
``VCVTTSH2USI r32, xmm1/m16{sae}``

``EVEX.LIG.F3.MAP5.W0 78 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTTSH2USI_R64_XMMM16_SAE: Code = 4399 # type: ignore
"""
``VCVTTSH2USI r64, xmm1/m16{sae}``

``EVEX.LIG.F3.MAP5.W1 78 /r``

``AVX512-FP16``

``64-bit``
"""
EVEX_VCVTUDQ2PH_XMM_K1Z_XMMM128B32: Code = 4400 # type: ignore
"""
``VCVTUDQ2PH xmm1 {k1}{z}, xmm2/m128/m32bcst``

``EVEX.128.F2.MAP5.W0 7A /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTUDQ2PH_XMM_K1Z_YMMM256B32: Code = 4401 # type: ignore
"""
``VCVTUDQ2PH xmm1 {k1}{z}, ymm2/m256/m32bcst``

``EVEX.256.F2.MAP5.W0 7A /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTUDQ2PH_YMM_K1Z_ZMMM512B32_ER: Code = 4402 # type: ignore
"""
``VCVTUDQ2PH ymm1 {k1}{z}, zmm2/m512/m32bcst{er}``

``EVEX.512.F2.MAP5.W0 7A /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTUQQ2PH_XMM_K1Z_XMMM128B64: Code = 4403 # type: ignore
"""
``VCVTUQQ2PH xmm1 {k1}{z}, xmm2/m128/m64bcst``

``EVEX.128.F2.MAP5.W1 7A /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTUQQ2PH_XMM_K1Z_YMMM256B64: Code = 4404 # type: ignore
"""
``VCVTUQQ2PH xmm1 {k1}{z}, ymm2/m256/m64bcst``

``EVEX.256.F2.MAP5.W1 7A /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTUQQ2PH_XMM_K1Z_ZMMM512B64_ER: Code = 4405 # type: ignore
"""
``VCVTUQQ2PH xmm1 {k1}{z}, zmm2/m512/m64bcst{er}``

``EVEX.512.F2.MAP5.W1 7A /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTUSI2SH_XMM_XMM_RM32_ER: Code = 4406 # type: ignore
"""
``VCVTUSI2SH xmm1, xmm2, r/m32{er}``

``EVEX.LIG.F3.MAP5.W0 7B /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTUSI2SH_XMM_XMM_RM64_ER: Code = 4407 # type: ignore
"""
``VCVTUSI2SH xmm1, xmm2, r/m64{er}``

``EVEX.LIG.F3.MAP5.W1 7B /r``

``AVX512-FP16``

``64-bit``
"""
EVEX_VCVTUW2PH_XMM_K1Z_XMMM128B16: Code = 4408 # type: ignore
"""
``VCVTUW2PH xmm1 {k1}{z}, xmm2/m128/m16bcst``

``EVEX.128.F2.MAP5.W0 7D /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTUW2PH_YMM_K1Z_YMMM256B16: Code = 4409 # type: ignore
"""
``VCVTUW2PH ymm1 {k1}{z}, ymm2/m256/m16bcst``

``EVEX.256.F2.MAP5.W0 7D /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTUW2PH_ZMM_K1Z_ZMMM512B16_ER: Code = 4410 # type: ignore
"""
``VCVTUW2PH zmm1 {k1}{z}, zmm2/m512/m16bcst{er}``

``EVEX.512.F2.MAP5.W0 7D /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTW2PH_XMM_K1Z_XMMM128B16: Code = 4411 # type: ignore
"""
``VCVTW2PH xmm1 {k1}{z}, xmm2/m128/m16bcst``

``EVEX.128.F3.MAP5.W0 7D /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTW2PH_YMM_K1Z_YMMM256B16: Code = 4412 # type: ignore
"""
``VCVTW2PH ymm1 {k1}{z}, ymm2/m256/m16bcst``

``EVEX.256.F3.MAP5.W0 7D /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VCVTW2PH_ZMM_K1Z_ZMMM512B16_ER: Code = 4413 # type: ignore
"""
``VCVTW2PH zmm1 {k1}{z}, zmm2/m512/m16bcst{er}``

``EVEX.512.F3.MAP5.W0 7D /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VDIVPH_XMM_K1Z_XMM_XMMM128B16: Code = 4414 # type: ignore
"""
``VDIVPH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.MAP5.W0 5E /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VDIVPH_YMM_K1Z_YMM_YMMM256B16: Code = 4415 # type: ignore
"""
``VDIVPH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.MAP5.W0 5E /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VDIVPH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4416 # type: ignore
"""
``VDIVPH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.MAP5.W0 5E /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VDIVSH_XMM_K1Z_XMM_XMMM16_ER: Code = 4417 # type: ignore
"""
``VDIVSH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.F3.MAP5.W0 5E /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFCMADDCPH_XMM_K1Z_XMM_XMMM128B32: Code = 4418 # type: ignore
"""
``VFCMADDCPH xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.F2.MAP6.W0 56 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFCMADDCPH_YMM_K1Z_YMM_YMMM256B32: Code = 4419 # type: ignore
"""
``VFCMADDCPH ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.F2.MAP6.W0 56 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFCMADDCPH_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 4420 # type: ignore
"""
``VFCMADDCPH zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.F2.MAP6.W0 56 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADDCPH_XMM_K1Z_XMM_XMMM128B32: Code = 4421 # type: ignore
"""
``VFMADDCPH xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.F3.MAP6.W0 56 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADDCPH_YMM_K1Z_YMM_YMMM256B32: Code = 4422 # type: ignore
"""
``VFMADDCPH ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.F3.MAP6.W0 56 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADDCPH_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 4423 # type: ignore
"""
``VFMADDCPH zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.F3.MAP6.W0 56 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFCMADDCSH_XMM_K1Z_XMM_XMMM32_ER: Code = 4424 # type: ignore
"""
``VFCMADDCSH xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.F2.MAP6.W0 57 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADDCSH_XMM_K1Z_XMM_XMMM32_ER: Code = 4425 # type: ignore
"""
``VFMADDCSH xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.F3.MAP6.W0 57 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFCMULCPH_XMM_K1Z_XMM_XMMM128B32: Code = 4426 # type: ignore
"""
``VFCMULCPH xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.F2.MAP6.W0 D6 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFCMULCPH_YMM_K1Z_YMM_YMMM256B32: Code = 4427 # type: ignore
"""
``VFCMULCPH ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.F2.MAP6.W0 D6 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFCMULCPH_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 4428 # type: ignore
"""
``VFCMULCPH zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.F2.MAP6.W0 D6 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMULCPH_XMM_K1Z_XMM_XMMM128B32: Code = 4429 # type: ignore
"""
``VFMULCPH xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst``

``EVEX.128.F3.MAP6.W0 D6 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMULCPH_YMM_K1Z_YMM_YMMM256B32: Code = 4430 # type: ignore
"""
``VFMULCPH ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst``

``EVEX.256.F3.MAP6.W0 D6 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMULCPH_ZMM_K1Z_ZMM_ZMMM512B32_ER: Code = 4431 # type: ignore
"""
``VFMULCPH zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}``

``EVEX.512.F3.MAP6.W0 D6 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFCMULCSH_XMM_K1Z_XMM_XMMM32_ER: Code = 4432 # type: ignore
"""
``VFCMULCSH xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.F2.MAP6.W0 D7 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMULCSH_XMM_K1Z_XMM_XMMM32_ER: Code = 4433 # type: ignore
"""
``VFMULCSH xmm1 {k1}{z}, xmm2, xmm3/m32{er}``

``EVEX.LIG.F3.MAP6.W0 D7 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADDSUB132PH_XMM_K1Z_XMM_XMMM128B16: Code = 4434 # type: ignore
"""
``VFMADDSUB132PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 96 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADDSUB132PH_YMM_K1Z_YMM_YMMM256B16: Code = 4435 # type: ignore
"""
``VFMADDSUB132PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 96 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADDSUB132PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4436 # type: ignore
"""
``VFMADDSUB132PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 96 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADDSUB213PH_XMM_K1Z_XMM_XMMM128B16: Code = 4437 # type: ignore
"""
``VFMADDSUB213PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 A6 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADDSUB213PH_YMM_K1Z_YMM_YMMM256B16: Code = 4438 # type: ignore
"""
``VFMADDSUB213PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 A6 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADDSUB213PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4439 # type: ignore
"""
``VFMADDSUB213PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 A6 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADDSUB231PH_XMM_K1Z_XMM_XMMM128B16: Code = 4440 # type: ignore
"""
``VFMADDSUB231PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 B6 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADDSUB231PH_YMM_K1Z_YMM_YMMM256B16: Code = 4441 # type: ignore
"""
``VFMADDSUB231PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 B6 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADDSUB231PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4442 # type: ignore
"""
``VFMADDSUB231PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 B6 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUBADD132PH_XMM_K1Z_XMM_XMMM128B16: Code = 4443 # type: ignore
"""
``VFMSUBADD132PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 97 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUBADD132PH_YMM_K1Z_YMM_YMMM256B16: Code = 4444 # type: ignore
"""
``VFMSUBADD132PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 97 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUBADD132PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4445 # type: ignore
"""
``VFMSUBADD132PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 97 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUBADD213PH_XMM_K1Z_XMM_XMMM128B16: Code = 4446 # type: ignore
"""
``VFMSUBADD213PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 A7 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUBADD213PH_YMM_K1Z_YMM_YMMM256B16: Code = 4447 # type: ignore
"""
``VFMSUBADD213PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 A7 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUBADD213PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4448 # type: ignore
"""
``VFMSUBADD213PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 A7 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUBADD231PH_XMM_K1Z_XMM_XMMM128B16: Code = 4449 # type: ignore
"""
``VFMSUBADD231PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 B7 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUBADD231PH_YMM_K1Z_YMM_YMMM256B16: Code = 4450 # type: ignore
"""
``VFMSUBADD231PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 B7 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUBADD231PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4451 # type: ignore
"""
``VFMSUBADD231PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 B7 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADD132PH_XMM_K1Z_XMM_XMMM128B16: Code = 4452 # type: ignore
"""
``VFMADD132PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 98 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADD132PH_YMM_K1Z_YMM_YMMM256B16: Code = 4453 # type: ignore
"""
``VFMADD132PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 98 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADD132PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4454 # type: ignore
"""
``VFMADD132PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 98 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADD213PH_XMM_K1Z_XMM_XMMM128B16: Code = 4455 # type: ignore
"""
``VFMADD213PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 A8 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADD213PH_YMM_K1Z_YMM_YMMM256B16: Code = 4456 # type: ignore
"""
``VFMADD213PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 A8 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADD213PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4457 # type: ignore
"""
``VFMADD213PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 A8 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADD231PH_XMM_K1Z_XMM_XMMM128B16: Code = 4458 # type: ignore
"""
``VFMADD231PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 B8 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADD231PH_YMM_K1Z_YMM_YMMM256B16: Code = 4459 # type: ignore
"""
``VFMADD231PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 B8 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADD231PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4460 # type: ignore
"""
``VFMADD231PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 B8 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMADD132PH_XMM_K1Z_XMM_XMMM128B16: Code = 4461 # type: ignore
"""
``VFNMADD132PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 9C /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMADD132PH_YMM_K1Z_YMM_YMMM256B16: Code = 4462 # type: ignore
"""
``VFNMADD132PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 9C /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMADD132PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4463 # type: ignore
"""
``VFNMADD132PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 9C /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMADD213PH_XMM_K1Z_XMM_XMMM128B16: Code = 4464 # type: ignore
"""
``VFNMADD213PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 AC /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMADD213PH_YMM_K1Z_YMM_YMMM256B16: Code = 4465 # type: ignore
"""
``VFNMADD213PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 AC /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMADD213PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4466 # type: ignore
"""
``VFNMADD213PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 AC /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMADD231PH_XMM_K1Z_XMM_XMMM128B16: Code = 4467 # type: ignore
"""
``VFNMADD231PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 BC /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMADD231PH_YMM_K1Z_YMM_YMMM256B16: Code = 4468 # type: ignore
"""
``VFNMADD231PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 BC /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMADD231PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4469 # type: ignore
"""
``VFNMADD231PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 BC /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADD132SH_XMM_K1Z_XMM_XMMM16_ER: Code = 4470 # type: ignore
"""
``VFMADD132SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.66.MAP6.W0 99 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADD213SH_XMM_K1Z_XMM_XMMM16_ER: Code = 4471 # type: ignore
"""
``VFMADD213SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.66.MAP6.W0 A9 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMADD231SH_XMM_K1Z_XMM_XMMM16_ER: Code = 4472 # type: ignore
"""
``VFMADD231SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.66.MAP6.W0 B9 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMADD132SH_XMM_K1Z_XMM_XMMM16_ER: Code = 4473 # type: ignore
"""
``VFNMADD132SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.66.MAP6.W0 9D /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMADD213SH_XMM_K1Z_XMM_XMMM16_ER: Code = 4474 # type: ignore
"""
``VFNMADD213SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.66.MAP6.W0 AD /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMADD231SH_XMM_K1Z_XMM_XMMM16_ER: Code = 4475 # type: ignore
"""
``VFNMADD231SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.66.MAP6.W0 BD /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUB132PH_XMM_K1Z_XMM_XMMM128B16: Code = 4476 # type: ignore
"""
``VFMSUB132PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 9A /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUB132PH_YMM_K1Z_YMM_YMMM256B16: Code = 4477 # type: ignore
"""
``VFMSUB132PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 9A /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUB132PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4478 # type: ignore
"""
``VFMSUB132PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 9A /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUB213PH_XMM_K1Z_XMM_XMMM128B16: Code = 4479 # type: ignore
"""
``VFMSUB213PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 AA /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUB213PH_YMM_K1Z_YMM_YMMM256B16: Code = 4480 # type: ignore
"""
``VFMSUB213PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 AA /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUB213PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4481 # type: ignore
"""
``VFMSUB213PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 AA /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUB231PH_XMM_K1Z_XMM_XMMM128B16: Code = 4482 # type: ignore
"""
``VFMSUB231PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 BA /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUB231PH_YMM_K1Z_YMM_YMMM256B16: Code = 4483 # type: ignore
"""
``VFMSUB231PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 BA /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUB231PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4484 # type: ignore
"""
``VFMSUB231PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 BA /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMSUB132PH_XMM_K1Z_XMM_XMMM128B16: Code = 4485 # type: ignore
"""
``VFNMSUB132PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 9E /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMSUB132PH_YMM_K1Z_YMM_YMMM256B16: Code = 4486 # type: ignore
"""
``VFNMSUB132PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 9E /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMSUB132PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4487 # type: ignore
"""
``VFNMSUB132PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 9E /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMSUB213PH_XMM_K1Z_XMM_XMMM128B16: Code = 4488 # type: ignore
"""
``VFNMSUB213PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 AE /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMSUB213PH_YMM_K1Z_YMM_YMMM256B16: Code = 4489 # type: ignore
"""
``VFNMSUB213PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 AE /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMSUB213PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4490 # type: ignore
"""
``VFNMSUB213PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 AE /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMSUB231PH_XMM_K1Z_XMM_XMMM128B16: Code = 4491 # type: ignore
"""
``VFNMSUB231PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 BE /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMSUB231PH_YMM_K1Z_YMM_YMMM256B16: Code = 4492 # type: ignore
"""
``VFNMSUB231PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 BE /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMSUB231PH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4493 # type: ignore
"""
``VFNMSUB231PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 BE /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUB132SH_XMM_K1Z_XMM_XMMM16_ER: Code = 4494 # type: ignore
"""
``VFMSUB132SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.66.MAP6.W0 9B /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUB213SH_XMM_K1Z_XMM_XMMM16_ER: Code = 4495 # type: ignore
"""
``VFMSUB213SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.66.MAP6.W0 AB /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFMSUB231SH_XMM_K1Z_XMM_XMMM16_ER: Code = 4496 # type: ignore
"""
``VFMSUB231SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.66.MAP6.W0 BB /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMSUB132SH_XMM_K1Z_XMM_XMMM16_ER: Code = 4497 # type: ignore
"""
``VFNMSUB132SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.66.MAP6.W0 9F /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMSUB213SH_XMM_K1Z_XMM_XMMM16_ER: Code = 4498 # type: ignore
"""
``VFNMSUB213SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.66.MAP6.W0 AF /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFNMSUB231SH_XMM_K1Z_XMM_XMMM16_ER: Code = 4499 # type: ignore
"""
``VFNMSUB231SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.66.MAP6.W0 BF /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFPCLASSPH_KR_K1_XMMM128B16_IMM8: Code = 4500 # type: ignore
"""
``VFPCLASSPH k1 {k2}, xmm2/m128/m16bcst, imm8``

``EVEX.128.0F3A.W0 66 /r ib``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFPCLASSPH_KR_K1_YMMM256B16_IMM8: Code = 4501 # type: ignore
"""
``VFPCLASSPH k1 {k2}, ymm2/m256/m16bcst, imm8``

``EVEX.256.0F3A.W0 66 /r ib``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFPCLASSPH_KR_K1_ZMMM512B16_IMM8: Code = 4502 # type: ignore
"""
``VFPCLASSPH k1 {k2}, zmm2/m512/m16bcst, imm8``

``EVEX.512.0F3A.W0 66 /r ib``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VFPCLASSSH_KR_K1_XMMM16_IMM8: Code = 4503 # type: ignore
"""
``VFPCLASSSH k1 {k2}, xmm2/m16, imm8``

``EVEX.LIG.0F3A.W0 67 /r ib``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VGETEXPPH_XMM_K1Z_XMMM128B16: Code = 4504 # type: ignore
"""
``VGETEXPPH xmm1 {k1}{z}, xmm2/m128/m16bcst``

``EVEX.128.66.MAP6.W0 42 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VGETEXPPH_YMM_K1Z_YMMM256B16: Code = 4505 # type: ignore
"""
``VGETEXPPH ymm1 {k1}{z}, ymm2/m256/m16bcst``

``EVEX.256.66.MAP6.W0 42 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VGETEXPPH_ZMM_K1Z_ZMMM512B16_SAE: Code = 4506 # type: ignore
"""
``VGETEXPPH zmm1 {k1}{z}, zmm2/m512/m16bcst{sae}``

``EVEX.512.66.MAP6.W0 42 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VGETEXPSH_XMM_K1Z_XMM_XMMM16_SAE: Code = 4507 # type: ignore
"""
``VGETEXPSH xmm1 {k1}{z}, xmm2, xmm3/m16{sae}``

``EVEX.LIG.66.MAP6.W0 43 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VGETMANTPH_XMM_K1Z_XMMM128B16_IMM8: Code = 4508 # type: ignore
"""
``VGETMANTPH xmm1 {k1}{z}, xmm2/m128/m16bcst, imm8``

``EVEX.128.0F3A.W0 26 /r ib``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VGETMANTPH_YMM_K1Z_YMMM256B16_IMM8: Code = 4509 # type: ignore
"""
``VGETMANTPH ymm1 {k1}{z}, ymm2/m256/m16bcst, imm8``

``EVEX.256.0F3A.W0 26 /r ib``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VGETMANTPH_ZMM_K1Z_ZMMM512B16_IMM8_SAE: Code = 4510 # type: ignore
"""
``VGETMANTPH zmm1 {k1}{z}, zmm2/m512/m16bcst{sae}, imm8``

``EVEX.512.0F3A.W0 26 /r ib``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VGETMANTSH_XMM_K1Z_XMM_XMMM16_IMM8_SAE: Code = 4511 # type: ignore
"""
``VGETMANTSH xmm1 {k1}{z}, xmm2, xmm3/m16{sae}, imm8``

``EVEX.LIG.0F3A.W0 27 /r ib``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMAXPH_XMM_K1Z_XMM_XMMM128B16: Code = 4512 # type: ignore
"""
``VMAXPH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.MAP5.W0 5F /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMAXPH_YMM_K1Z_YMM_YMMM256B16: Code = 4513 # type: ignore
"""
``VMAXPH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.MAP5.W0 5F /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMAXPH_ZMM_K1Z_ZMM_ZMMM512B16_SAE: Code = 4514 # type: ignore
"""
``VMAXPH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{sae}``

``EVEX.512.MAP5.W0 5F /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMAXSH_XMM_K1Z_XMM_XMMM16_SAE: Code = 4515 # type: ignore
"""
``VMAXSH xmm1 {k1}{z}, xmm2, xmm3/m16{sae}``

``EVEX.LIG.F3.MAP5.W0 5F /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMINPH_XMM_K1Z_XMM_XMMM128B16: Code = 4516 # type: ignore
"""
``VMINPH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.MAP5.W0 5D /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMINPH_YMM_K1Z_YMM_YMMM256B16: Code = 4517 # type: ignore
"""
``VMINPH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.MAP5.W0 5D /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMINPH_ZMM_K1Z_ZMM_ZMMM512B16_SAE: Code = 4518 # type: ignore
"""
``VMINPH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{sae}``

``EVEX.512.MAP5.W0 5D /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMINSH_XMM_K1Z_XMM_XMMM16_SAE: Code = 4519 # type: ignore
"""
``VMINSH xmm1 {k1}{z}, xmm2, xmm3/m16{sae}``

``EVEX.LIG.F3.MAP5.W0 5D /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMOVSH_XMM_K1Z_M16: Code = 4520 # type: ignore
"""
``VMOVSH xmm1 {k1}{z}, m16``

``EVEX.LIG.F3.MAP5.W0 10 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMOVSH_M16_K1_XMM: Code = 4521 # type: ignore
"""
``VMOVSH m16 {k1}, xmm1``

``EVEX.LIG.F3.MAP5.W0 11 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMOVSH_XMM_K1Z_XMM_XMM: Code = 4522 # type: ignore
"""
``VMOVSH xmm1 {k1}{z}, xmm2, xmm3``

``EVEX.LIG.F3.MAP5.W0 10 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMOVSH_XMM_K1Z_XMM_XMM_MAP5_11: Code = 4523 # type: ignore
"""
``VMOVSH xmm1 {k1}{z}, xmm2, xmm3``

``EVEX.LIG.F3.MAP5.W0 11 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMOVW_XMM_R32M16: Code = 4524 # type: ignore
"""
``VMOVW xmm1, r32/m16``

``EVEX.128.66.MAP5.W0 6E /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMOVW_XMM_R64M16: Code = 4525 # type: ignore
"""
``VMOVW xmm1, r64/m16``

``EVEX.128.66.MAP5.W1 6E /r``

``AVX512-FP16``

``64-bit``
"""
EVEX_VMOVW_R32M16_XMM: Code = 4526 # type: ignore
"""
``VMOVW r32/m16, xmm1``

``EVEX.128.66.MAP5.W0 7E /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMOVW_R64M16_XMM: Code = 4527 # type: ignore
"""
``VMOVW r64/m16, xmm1``

``EVEX.128.66.MAP5.W1 7E /r``

``AVX512-FP16``

``64-bit``
"""
EVEX_VMULPH_XMM_K1Z_XMM_XMMM128B16: Code = 4528 # type: ignore
"""
``VMULPH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.MAP5.W0 59 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMULPH_YMM_K1Z_YMM_YMMM256B16: Code = 4529 # type: ignore
"""
``VMULPH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.MAP5.W0 59 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMULPH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4530 # type: ignore
"""
``VMULPH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.MAP5.W0 59 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VMULSH_XMM_K1Z_XMM_XMMM16_ER: Code = 4531 # type: ignore
"""
``VMULSH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.F3.MAP5.W0 59 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VRCPPH_XMM_K1Z_XMMM128B16: Code = 4532 # type: ignore
"""
``VRCPPH xmm1 {k1}{z}, xmm2/m128/m16bcst``

``EVEX.128.66.MAP6.W0 4C /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VRCPPH_YMM_K1Z_YMMM256B16: Code = 4533 # type: ignore
"""
``VRCPPH ymm1 {k1}{z}, ymm2/m256/m16bcst``

``EVEX.256.66.MAP6.W0 4C /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VRCPPH_ZMM_K1Z_ZMMM512B16: Code = 4534 # type: ignore
"""
``VRCPPH zmm1 {k1}{z}, zmm2/m512/m16bcst``

``EVEX.512.66.MAP6.W0 4C /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VRCPSH_XMM_K1Z_XMM_XMMM16: Code = 4535 # type: ignore
"""
``VRCPSH xmm1 {k1}{z}, xmm2, xmm3/m16``

``EVEX.LIG.66.MAP6.W0 4D /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VREDUCEPH_XMM_K1Z_XMMM128B16_IMM8: Code = 4536 # type: ignore
"""
``VREDUCEPH xmm1 {k1}{z}, xmm2/m128/m16bcst, imm8``

``EVEX.128.0F3A.W0 56 /r ib``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VREDUCEPH_YMM_K1Z_YMMM256B16_IMM8: Code = 4537 # type: ignore
"""
``VREDUCEPH ymm1 {k1}{z}, ymm2/m256/m16bcst, imm8``

``EVEX.256.0F3A.W0 56 /r ib``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VREDUCEPH_ZMM_K1Z_ZMMM512B16_IMM8_SAE: Code = 4538 # type: ignore
"""
``VREDUCEPH zmm1 {k1}{z}, zmm2/m512/m16bcst{sae}, imm8``

``EVEX.512.0F3A.W0 56 /r ib``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VREDUCESH_XMM_K1Z_XMM_XMMM16_IMM8_SAE: Code = 4539 # type: ignore
"""
``VREDUCESH xmm1 {k1}{z}, xmm2, xmm3/m16{sae}, imm8``

``EVEX.LIG.0F3A.W0 57 /r ib``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VRNDSCALEPH_XMM_K1Z_XMMM128B16_IMM8: Code = 4540 # type: ignore
"""
``VRNDSCALEPH xmm1 {k1}{z}, xmm2/m128/m16bcst, imm8``

``EVEX.128.0F3A.W0 08 /r ib``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VRNDSCALEPH_YMM_K1Z_YMMM256B16_IMM8: Code = 4541 # type: ignore
"""
``VRNDSCALEPH ymm1 {k1}{z}, ymm2/m256/m16bcst, imm8``

``EVEX.256.0F3A.W0 08 /r ib``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VRNDSCALEPH_ZMM_K1Z_ZMMM512B16_IMM8_SAE: Code = 4542 # type: ignore
"""
``VRNDSCALEPH zmm1 {k1}{z}, zmm2/m512/m16bcst{sae}, imm8``

``EVEX.512.0F3A.W0 08 /r ib``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VRNDSCALESH_XMM_K1Z_XMM_XMMM16_IMM8_SAE: Code = 4543 # type: ignore
"""
``VRNDSCALESH xmm1 {k1}{z}, xmm2, xmm3/m16{sae}, imm8``

``EVEX.LIG.0F3A.W0 0A /r ib``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VRSQRTPH_XMM_K1Z_XMMM128B16: Code = 4544 # type: ignore
"""
``VRSQRTPH xmm1 {k1}{z}, xmm2/m128/m16bcst``

``EVEX.128.66.MAP6.W0 4E /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VRSQRTPH_YMM_K1Z_YMMM256B16: Code = 4545 # type: ignore
"""
``VRSQRTPH ymm1 {k1}{z}, ymm2/m256/m16bcst``

``EVEX.256.66.MAP6.W0 4E /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VRSQRTPH_ZMM_K1Z_ZMMM512B16: Code = 4546 # type: ignore
"""
``VRSQRTPH zmm1 {k1}{z}, zmm2/m512/m16bcst``

``EVEX.512.66.MAP6.W0 4E /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VRSQRTSH_XMM_K1Z_XMM_XMMM16: Code = 4547 # type: ignore
"""
``VRSQRTSH xmm1 {k1}{z}, xmm2, xmm3/m16``

``EVEX.LIG.66.MAP6.W0 4F /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VSCALEFPH_XMM_K1Z_XMM_XMMM128B16: Code = 4548 # type: ignore
"""
``VSCALEFPH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.66.MAP6.W0 2C /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VSCALEFPH_YMM_K1Z_YMM_YMMM256B16: Code = 4549 # type: ignore
"""
``VSCALEFPH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.66.MAP6.W0 2C /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VSCALEFPH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4550 # type: ignore
"""
``VSCALEFPH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.66.MAP6.W0 2C /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VSCALEFSH_XMM_K1Z_XMM_XMMM16_ER: Code = 4551 # type: ignore
"""
``VSCALEFSH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.66.MAP6.W0 2D /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VSQRTPH_XMM_K1Z_XMMM128B16: Code = 4552 # type: ignore
"""
``VSQRTPH xmm1 {k1}{z}, xmm2/m128/m16bcst``

``EVEX.128.MAP5.W0 51 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VSQRTPH_YMM_K1Z_YMMM256B16: Code = 4553 # type: ignore
"""
``VSQRTPH ymm1 {k1}{z}, ymm2/m256/m16bcst``

``EVEX.256.MAP5.W0 51 /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VSQRTPH_ZMM_K1Z_ZMMM512B16_ER: Code = 4554 # type: ignore
"""
``VSQRTPH zmm1 {k1}{z}, zmm2/m512/m16bcst{er}``

``EVEX.512.MAP5.W0 51 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VSQRTSH_XMM_K1Z_XMM_XMMM16_ER: Code = 4555 # type: ignore
"""
``VSQRTSH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.F3.MAP5.W0 51 /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VSUBPH_XMM_K1Z_XMM_XMMM128B16: Code = 4556 # type: ignore
"""
``VSUBPH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst``

``EVEX.128.MAP5.W0 5C /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VSUBPH_YMM_K1Z_YMM_YMMM256B16: Code = 4557 # type: ignore
"""
``VSUBPH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst``

``EVEX.256.MAP5.W0 5C /r``

``AVX512VL and AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VSUBPH_ZMM_K1Z_ZMM_ZMMM512B16_ER: Code = 4558 # type: ignore
"""
``VSUBPH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}``

``EVEX.512.MAP5.W0 5C /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VSUBSH_XMM_K1Z_XMM_XMMM16_ER: Code = 4559 # type: ignore
"""
``VSUBSH xmm1 {k1}{z}, xmm2, xmm3/m16{er}``

``EVEX.LIG.F3.MAP5.W0 5C /r``

``AVX512-FP16``

``16/32/64-bit``
"""
EVEX_VUCOMISH_XMM_XMMM16_SAE: Code = 4560 # type: ignore
"""
``VUCOMISH xmm1, xmm2/m16{sae}``

``EVEX.LIG.MAP5.W0 2E /r``

``AVX512-FP16``

``16/32/64-bit``
"""
RDUDBG: Code = 4561 # type: ignore
"""
``RDUDBG``

``0F 0E``

``UDBG``

``16/32/64-bit``
"""
WRUDBG: Code = 4562 # type: ignore
"""
``WRUDBG``

``0F 0F``

``UDBG``

``16/32/64-bit``
"""
VEX_KNC_JKZD_KR_REL8_64: Code = 4563 # type: ignore
"""
``JKZD k1, rel8``

``VEX.128.W0 74 cb``

``KNC``

``64-bit``
"""
VEX_KNC_JKNZD_KR_REL8_64: Code = 4564 # type: ignore
"""
``JKNZD k1, rel8``

``VEX.128.W0 75 cb``

``KNC``

``64-bit``
"""
VEX_KNC_VPREFETCHNTA_M8: Code = 4565 # type: ignore
"""
``VPREFETCHNTA m8``

``VEX.128.0F.WIG 18 /0``

``KNC``

``64-bit``
"""
VEX_KNC_VPREFETCH0_M8: Code = 4566 # type: ignore
"""
``VPREFETCH0 m8``

``VEX.128.0F.WIG 18 /1``

``KNC``

``64-bit``
"""
VEX_KNC_VPREFETCH1_M8: Code = 4567 # type: ignore
"""
``VPREFETCH1 m8``

``VEX.128.0F.WIG 18 /2``

``KNC``

``64-bit``
"""
VEX_KNC_VPREFETCH2_M8: Code = 4568 # type: ignore
"""
``VPREFETCH2 m8``

``VEX.128.0F.WIG 18 /3``

``KNC``

``64-bit``
"""
VEX_KNC_VPREFETCHENTA_M8: Code = 4569 # type: ignore
"""
``VPREFETCHENTA m8``

``VEX.128.0F.WIG 18 /4``

``KNC``

``64-bit``
"""
VEX_KNC_VPREFETCHE0_M8: Code = 4570 # type: ignore
"""
``VPREFETCHE0 m8``

``VEX.128.0F.WIG 18 /5``

``KNC``

``64-bit``
"""
VEX_KNC_VPREFETCHE1_M8: Code = 4571 # type: ignore
"""
``VPREFETCHE1 m8``

``VEX.128.0F.WIG 18 /6``

``KNC``

``64-bit``
"""
VEX_KNC_VPREFETCHE2_M8: Code = 4572 # type: ignore
"""
``VPREFETCHE2 m8``

``VEX.128.0F.WIG 18 /7``

``KNC``

``64-bit``
"""
VEX_KNC_KAND_KR_KR: Code = 4573 # type: ignore
"""
``KAND k1, k2``

``VEX.128.0F.W0 41 /r``

``KNC``

``64-bit``
"""
VEX_KNC_KANDN_KR_KR: Code = 4574 # type: ignore
"""
``KANDN k1, k2``

``VEX.128.0F.W0 42 /r``

``KNC``

``64-bit``
"""
VEX_KNC_KANDNR_KR_KR: Code = 4575 # type: ignore
"""
``KANDNR k1, k2``

``VEX.128.0F.W0 43 /r``

``KNC``

``64-bit``
"""
VEX_KNC_KNOT_KR_KR: Code = 4576 # type: ignore
"""
``KNOT k1, k2``

``VEX.128.0F.W0 44 /r``

``KNC``

``64-bit``
"""
VEX_KNC_KOR_KR_KR: Code = 4577 # type: ignore
"""
``KOR k1, k2``

``VEX.128.0F.W0 45 /r``

``KNC``

``64-bit``
"""
VEX_KNC_KXNOR_KR_KR: Code = 4578 # type: ignore
"""
``KXNOR k1, k2``

``VEX.128.0F.W0 46 /r``

``KNC``

``64-bit``
"""
VEX_KNC_KXOR_KR_KR: Code = 4579 # type: ignore
"""
``KXOR k1, k2``

``VEX.128.0F.W0 47 /r``

``KNC``

``64-bit``
"""
VEX_KNC_KMERGE2L1H_KR_KR: Code = 4580 # type: ignore
"""
``KMERGE2L1H k1, k2``

``VEX.128.0F.W0 48 /r``

``KNC``

``64-bit``
"""
VEX_KNC_KMERGE2L1L_KR_KR: Code = 4581 # type: ignore
"""
``KMERGE2L1L k1, k2``

``VEX.128.0F.W0 49 /r``

``KNC``

``64-bit``
"""
VEX_KNC_JKZD_KR_REL32_64: Code = 4582 # type: ignore
"""
``JKZD k1, rel32``

``VEX.128.0F.W0 84 cd``

``KNC``

``64-bit``
"""
VEX_KNC_JKNZD_KR_REL32_64: Code = 4583 # type: ignore
"""
``JKNZD k1, rel32``

``VEX.128.0F.W0 85 cd``

``KNC``

``64-bit``
"""
VEX_KNC_KMOV_KR_KR: Code = 4584 # type: ignore
"""
``KMOV k1, k2``

``VEX.128.0F.W0 90 /r``

``KNC``

``64-bit``
"""
VEX_KNC_KMOV_KR_R32: Code = 4585 # type: ignore
"""
``KMOV k1, r32``

``VEX.128.0F.W0 92 /r``

``KNC``

``64-bit``
"""
VEX_KNC_KMOV_R32_KR: Code = 4586 # type: ignore
"""
``KMOV r32, k1``

``VEX.128.0F.W0 93 /r``

``KNC``

``64-bit``
"""
VEX_KNC_KCONCATH_R64_KR_KR: Code = 4587 # type: ignore
"""
``KCONCATH r64, k1, k2``

``VEX.128.0F.W0 95 /r``

``KNC``

``64-bit``
"""
VEX_KNC_KCONCATL_R64_KR_KR: Code = 4588 # type: ignore
"""
``KCONCATL r64, k1, k2``

``VEX.128.0F.W0 97 /r``

``KNC``

``64-bit``
"""
VEX_KNC_KORTEST_KR_KR: Code = 4589 # type: ignore
"""
``KORTEST k1, k2``

``VEX.128.0F.W0 98 /r``

``KNC``

``64-bit``
"""
VEX_KNC_DELAY_R32: Code = 4590 # type: ignore
"""
``DELAY r32``

``VEX.128.F3.0F.W0 AE /6``

``KNC``

``64-bit``
"""
VEX_KNC_DELAY_R64: Code = 4591 # type: ignore
"""
``DELAY r64``

``VEX.128.F3.0F.W1 AE /6``

``KNC``

``64-bit``
"""
VEX_KNC_SPFLT_R32: Code = 4592 # type: ignore
"""
``SPFLT r32``

``VEX.128.F2.0F.W0 AE /6``

``KNC``

``64-bit``
"""
VEX_KNC_SPFLT_R64: Code = 4593 # type: ignore
"""
``SPFLT r64``

``VEX.128.F2.0F.W1 AE /6``

``KNC``

``64-bit``
"""
VEX_KNC_CLEVICT1_M8: Code = 4594 # type: ignore
"""
``CLEVICT1 m8``

``VEX.128.F3.0F.WIG AE /7``

``KNC``

``64-bit``
"""
VEX_KNC_CLEVICT0_M8: Code = 4595 # type: ignore
"""
``CLEVICT0 m8``

``VEX.128.F2.0F.WIG AE /7``

``KNC``

``64-bit``
"""
VEX_KNC_POPCNT_R32_R32: Code = 4596 # type: ignore
"""
``POPCNT r32, r32``

``VEX.128.F3.0F.W0 B8 /r``

``KNC``

``64-bit``
"""
VEX_KNC_POPCNT_R64_R64: Code = 4597 # type: ignore
"""
``POPCNT r64, r64``

``VEX.128.F3.0F.W1 B8 /r``

``KNC``

``64-bit``
"""
VEX_KNC_TZCNT_R32_R32: Code = 4598 # type: ignore
"""
``TZCNT r32, r32``

``VEX.128.F3.0F.W0 BC /r``

``KNC``

``64-bit``
"""
VEX_KNC_TZCNT_R64_R64: Code = 4599 # type: ignore
"""
``TZCNT r64, r64``

``VEX.128.F3.0F.W1 BC /r``

``KNC``

``64-bit``
"""
VEX_KNC_TZCNTI_R32_R32: Code = 4600 # type: ignore
"""
``TZCNTI r32, r32``

``VEX.128.F2.0F.W0 BC /r``

``KNC``

``64-bit``
"""
VEX_KNC_TZCNTI_R64_R64: Code = 4601 # type: ignore
"""
``TZCNTI r64, r64``

``VEX.128.F2.0F.W1 BC /r``

``KNC``

``64-bit``
"""
VEX_KNC_LZCNT_R32_R32: Code = 4602 # type: ignore
"""
``LZCNT r32, r32``

``VEX.128.F3.0F.W0 BD /r``

``KNC``

``64-bit``
"""
VEX_KNC_LZCNT_R64_R64: Code = 4603 # type: ignore
"""
``LZCNT r64, r64``

``VEX.128.F3.0F.W1 BD /r``

``KNC``

``64-bit``
"""
VEX_KNC_UNDOC_R32_RM32_128_F3_0F38_W0_F0: Code = 4604 # type: ignore
"""
``UNDOC r32, r/m32``

``VEX.128.F3.0F38.W0 F0 /r``

``KNC``

``64-bit``
"""
VEX_KNC_UNDOC_R64_RM64_128_F3_0F38_W1_F0: Code = 4605 # type: ignore
"""
``UNDOC r64, r/m64``

``VEX.128.F3.0F38.W1 F0 /r``

``KNC``

``64-bit``
"""
VEX_KNC_UNDOC_R32_RM32_128_F2_0F38_W0_F0: Code = 4606 # type: ignore
"""
``UNDOC r32, r/m32``

``VEX.128.F2.0F38.W0 F0 /r``

``KNC``

``64-bit``
"""
VEX_KNC_UNDOC_R64_RM64_128_F2_0F38_W1_F0: Code = 4607 # type: ignore
"""
``UNDOC r64, r/m64``

``VEX.128.F2.0F38.W1 F0 /r``

``KNC``

``64-bit``
"""
VEX_KNC_UNDOC_R32_RM32_128_F2_0F38_W0_F1: Code = 4608 # type: ignore
"""
``UNDOC r32, r/m32``

``VEX.128.F2.0F38.W0 F1 /r``

``KNC``

``64-bit``
"""
VEX_KNC_UNDOC_R64_RM64_128_F2_0F38_W1_F1: Code = 4609 # type: ignore
"""
``UNDOC r64, r/m64``

``VEX.128.F2.0F38.W1 F1 /r``

``KNC``

``64-bit``
"""
VEX_KNC_KEXTRACT_KR_R64_IMM8: Code = 4610 # type: ignore
"""
``KEXTRACT k1, r64, imm8``

``VEX.128.66.0F3A.W0 3E /r ib``

``KNC``

``64-bit``
"""
MVEX_VPREFETCHNTA_M: Code = 4611 # type: ignore
"""
``VPREFETCHNTA m``

``MVEX.512.0F.WIG 18 /0``

``KNC``

``64-bit``
"""
MVEX_VPREFETCH0_M: Code = 4612 # type: ignore
"""
``VPREFETCH0 m``

``MVEX.512.0F.WIG 18 /1``

``KNC``

``64-bit``
"""
MVEX_VPREFETCH1_M: Code = 4613 # type: ignore
"""
``VPREFETCH1 m``

``MVEX.512.0F.WIG 18 /2``

``KNC``

``64-bit``
"""
MVEX_VPREFETCH2_M: Code = 4614 # type: ignore
"""
``VPREFETCH2 m``

``MVEX.512.0F.WIG 18 /3``

``KNC``

``64-bit``
"""
MVEX_VPREFETCHENTA_M: Code = 4615 # type: ignore
"""
``VPREFETCHENTA m``

``MVEX.512.0F.WIG 18 /4``

``KNC``

``64-bit``
"""
MVEX_VPREFETCHE0_M: Code = 4616 # type: ignore
"""
``VPREFETCHE0 m``

``MVEX.512.0F.WIG 18 /5``

``KNC``

``64-bit``
"""
MVEX_VPREFETCHE1_M: Code = 4617 # type: ignore
"""
``VPREFETCHE1 m``

``MVEX.512.0F.WIG 18 /6``

``KNC``

``64-bit``
"""
MVEX_VPREFETCHE2_M: Code = 4618 # type: ignore
"""
``VPREFETCHE2 m``

``MVEX.512.0F.WIG 18 /7``

``KNC``

``64-bit``
"""
MVEX_VMOVAPS_ZMM_K1_ZMMMT: Code = 4619 # type: ignore
"""
``VMOVAPS zmm1 {k1}, Sf32(zmm2/mt)``

``MVEX.512.0F.W0 28 /r``

``KNC``

``64-bit``
"""
MVEX_VMOVAPD_ZMM_K1_ZMMMT: Code = 4620 # type: ignore
"""
``VMOVAPD zmm1 {k1}, Sf64(zmm2/mt)``

``MVEX.512.66.0F.W1 28 /r``

``KNC``

``64-bit``
"""
MVEX_VMOVAPS_MT_K1_ZMM: Code = 4621 # type: ignore
"""
``VMOVAPS mt {k1}, Df32(zmm1)``

``MVEX.512.0F.W0 29 /r``

``KNC``

``64-bit``
"""
MVEX_VMOVAPD_MT_K1_ZMM: Code = 4622 # type: ignore
"""
``VMOVAPD mt {k1}, Df64(zmm1)``

``MVEX.512.66.0F.W1 29 /r``

``KNC``

``64-bit``
"""
MVEX_VMOVNRAPD_M_K1_ZMM: Code = 4623 # type: ignore
"""
``VMOVNRAPD m {k1}, Df64(zmm1)``

``MVEX.512.F3.0F.W1.EH0 29 /r``

``KNC``

``64-bit``
"""
MVEX_VMOVNRNGOAPD_M_K1_ZMM: Code = 4624 # type: ignore
"""
``VMOVNRNGOAPD m {k1}, Df64(zmm1)``

``MVEX.512.F3.0F.W1.EH1 29 /r``

``KNC``

``64-bit``
"""
MVEX_VMOVNRAPS_M_K1_ZMM: Code = 4625 # type: ignore
"""
``VMOVNRAPS m {k1}, Df32(zmm1)``

``MVEX.512.F2.0F.W0.EH0 29 /r``

``KNC``

``64-bit``
"""
MVEX_VMOVNRNGOAPS_M_K1_ZMM: Code = 4626 # type: ignore
"""
``VMOVNRNGOAPS m {k1}, Df32(zmm1)``

``MVEX.512.F2.0F.W0.EH1 29 /r``

``KNC``

``64-bit``
"""
MVEX_VADDPS_ZMM_K1_ZMM_ZMMMT: Code = 4627 # type: ignore
"""
``VADDPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.0F.W0 58 /r``

``KNC``

``64-bit``
"""
MVEX_VADDPD_ZMM_K1_ZMM_ZMMMT: Code = 4628 # type: ignore
"""
``VADDPD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F.W1 58 /r``

``KNC``

``64-bit``
"""
MVEX_VMULPS_ZMM_K1_ZMM_ZMMMT: Code = 4629 # type: ignore
"""
``VMULPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.0F.W0 59 /r``

``KNC``

``64-bit``
"""
MVEX_VMULPD_ZMM_K1_ZMM_ZMMMT: Code = 4630 # type: ignore
"""
``VMULPD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F.W1 59 /r``

``KNC``

``64-bit``
"""
MVEX_VCVTPS2PD_ZMM_K1_ZMMMT: Code = 4631 # type: ignore
"""
``VCVTPS2PD zmm1 {k1}, Sf32(zmm2/mt)``

``MVEX.512.0F.W0 5A /r``

``KNC``

``64-bit``
"""
MVEX_VCVTPD2PS_ZMM_K1_ZMMMT: Code = 4632 # type: ignore
"""
``VCVTPD2PS zmm1 {k1}, Sf64(zmm2/mt)``

``MVEX.512.66.0F.W1 5A /r``

``KNC``

``64-bit``
"""
MVEX_VSUBPS_ZMM_K1_ZMM_ZMMMT: Code = 4633 # type: ignore
"""
``VSUBPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.0F.W0 5C /r``

``KNC``

``64-bit``
"""
MVEX_VSUBPD_ZMM_K1_ZMM_ZMMMT: Code = 4634 # type: ignore
"""
``VSUBPD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F.W1 5C /r``

``KNC``

``64-bit``
"""
MVEX_VPCMPGTD_KR_K1_ZMM_ZMMMT: Code = 4635 # type: ignore
"""
``VPCMPGTD k2 {k1}, zmm1, Si32(zmm2/mt)``

``MVEX.NDS.512.66.0F.W0 66 /r``

``KNC``

``64-bit``
"""
MVEX_VMOVDQA32_ZMM_K1_ZMMMT: Code = 4636 # type: ignore
"""
``VMOVDQA32 zmm1 {k1}, Si32(zmm2/mt)``

``MVEX.512.66.0F.W0 6F /r``

``KNC``

``64-bit``
"""
MVEX_VMOVDQA64_ZMM_K1_ZMMMT: Code = 4637 # type: ignore
"""
``VMOVDQA64 zmm1 {k1}, Si64(zmm2/mt)``

``MVEX.512.66.0F.W1 6F /r``

``KNC``

``64-bit``
"""
MVEX_VPSHUFD_ZMM_K1_ZMMMT_IMM8: Code = 4638 # type: ignore
"""
``VPSHUFD zmm1 {k1}, zmm2/mt, imm8``

``MVEX.512.66.0F.W0 70 /r ib``

``KNC``

``64-bit``
"""
MVEX_VPSRLD_ZMM_K1_ZMMMT_IMM8: Code = 4639 # type: ignore
"""
``VPSRLD zmm1 {k1}, Si32(zmm2/mt), imm8``

``MVEX.NDD.512.66.0F.W0 72 /2 ib``

``KNC``

``64-bit``
"""
MVEX_VPSRAD_ZMM_K1_ZMMMT_IMM8: Code = 4640 # type: ignore
"""
``VPSRAD zmm1 {k1}, Si32(zmm2/mt), imm8``

``MVEX.NDD.512.66.0F.W0 72 /4 ib``

``KNC``

``64-bit``
"""
MVEX_VPSLLD_ZMM_K1_ZMMMT_IMM8: Code = 4641 # type: ignore
"""
``VPSLLD zmm1 {k1}, Si32(zmm2/mt), imm8``

``MVEX.NDD.512.66.0F.W0 72 /6 ib``

``KNC``

``64-bit``
"""
MVEX_VPCMPEQD_KR_K1_ZMM_ZMMMT: Code = 4642 # type: ignore
"""
``VPCMPEQD k2 {k1}, zmm1, Si32(zmm2/mt)``

``MVEX.NDS.512.66.0F.W0 76 /r``

``KNC``

``64-bit``
"""
MVEX_VCVTUDQ2PD_ZMM_K1_ZMMMT: Code = 4643 # type: ignore
"""
``VCVTUDQ2PD zmm1 {k1}, Si32(zmm2/mt)``

``MVEX.512.F3.0F.W0 7A /r``

``KNC``

``64-bit``
"""
MVEX_VMOVDQA32_MT_K1_ZMM: Code = 4644 # type: ignore
"""
``VMOVDQA32 mt {k1}, Di32(zmm1)``

``MVEX.512.66.0F.W0 7F /r``

``KNC``

``64-bit``
"""
MVEX_VMOVDQA64_MT_K1_ZMM: Code = 4645 # type: ignore
"""
``VMOVDQA64 mt {k1}, Di64(zmm1)``

``MVEX.512.66.0F.W1 7F /r``

``KNC``

``64-bit``
"""
MVEX_CLEVICT1_M: Code = 4646 # type: ignore
"""
``CLEVICT1 m``

``MVEX.512.F3.0F.WIG AE /7``

``KNC``

``64-bit``
"""
MVEX_CLEVICT0_M: Code = 4647 # type: ignore
"""
``CLEVICT0 m``

``MVEX.512.F2.0F.WIG AE /7``

``KNC``

``64-bit``
"""
MVEX_VCMPPS_KR_K1_ZMM_ZMMMT_IMM8: Code = 4648 # type: ignore
"""
``VCMPPS k2 {k1}, zmm1, Sf32(zmm2/mt), imm8``

``MVEX.NDS.512.0F.W0 C2 /r ib``

``KNC``

``64-bit``
"""
MVEX_VCMPPD_KR_K1_ZMM_ZMMMT_IMM8: Code = 4649 # type: ignore
"""
``VCMPPD k2 {k1}, zmm1, Sf64(zmm2/mt), imm8``

``MVEX.NDS.512.66.0F.W1 C2 /r ib``

``KNC``

``64-bit``
"""
MVEX_VPANDD_ZMM_K1_ZMM_ZMMMT: Code = 4650 # type: ignore
"""
``VPANDD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F.W0 DB /r``

``KNC``

``64-bit``
"""
MVEX_VPANDQ_ZMM_K1_ZMM_ZMMMT: Code = 4651 # type: ignore
"""
``VPANDQ zmm1 {k1}, zmm2, Si64(zmm3/mt)``

``MVEX.NDS.512.66.0F.W1 DB /r``

``KNC``

``64-bit``
"""
MVEX_VPANDND_ZMM_K1_ZMM_ZMMMT: Code = 4652 # type: ignore
"""
``VPANDND zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F.W0 DF /r``

``KNC``

``64-bit``
"""
MVEX_VPANDNQ_ZMM_K1_ZMM_ZMMMT: Code = 4653 # type: ignore
"""
``VPANDNQ zmm1 {k1}, zmm2, Si64(zmm3/mt)``

``MVEX.NDS.512.66.0F.W1 DF /r``

``KNC``

``64-bit``
"""
MVEX_VCVTDQ2PD_ZMM_K1_ZMMMT: Code = 4654 # type: ignore
"""
``VCVTDQ2PD zmm1 {k1}, Si32(zmm2/mt)``

``MVEX.512.F3.0F.W0 E6 /r``

``KNC``

``64-bit``
"""
MVEX_VPORD_ZMM_K1_ZMM_ZMMMT: Code = 4655 # type: ignore
"""
``VPORD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F.W0 EB /r``

``KNC``

``64-bit``
"""
MVEX_VPORQ_ZMM_K1_ZMM_ZMMMT: Code = 4656 # type: ignore
"""
``VPORQ zmm1 {k1}, zmm2, Si64(zmm3/mt)``

``MVEX.NDS.512.66.0F.W1 EB /r``

``KNC``

``64-bit``
"""
MVEX_VPXORD_ZMM_K1_ZMM_ZMMMT: Code = 4657 # type: ignore
"""
``VPXORD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F.W0 EF /r``

``KNC``

``64-bit``
"""
MVEX_VPXORQ_ZMM_K1_ZMM_ZMMMT: Code = 4658 # type: ignore
"""
``VPXORQ zmm1 {k1}, zmm2, Si64(zmm3/mt)``

``MVEX.NDS.512.66.0F.W1 EF /r``

``KNC``

``64-bit``
"""
MVEX_VPSUBD_ZMM_K1_ZMM_ZMMMT: Code = 4659 # type: ignore
"""
``VPSUBD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F.W0 FA /r``

``KNC``

``64-bit``
"""
MVEX_VPADDD_ZMM_K1_ZMM_ZMMMT: Code = 4660 # type: ignore
"""
``VPADDD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F.W0 FE /r``

``KNC``

``64-bit``
"""
MVEX_VBROADCASTSS_ZMM_K1_MT: Code = 4661 # type: ignore
"""
``VBROADCASTSS zmm1 {k1}, Uf32(mt)``

``MVEX.512.66.0F38.W0 18 /r``

``KNC``

``64-bit``
"""
MVEX_VBROADCASTSD_ZMM_K1_MT: Code = 4662 # type: ignore
"""
``VBROADCASTSD zmm1 {k1}, Uf64(mt)``

``MVEX.512.66.0F38.W1 19 /r``

``KNC``

``64-bit``
"""
MVEX_VBROADCASTF32X4_ZMM_K1_MT: Code = 4663 # type: ignore
"""
``VBROADCASTF32X4 zmm1 {k1}, Uf32(mt)``

``MVEX.512.66.0F38.W0 1A /r``

``KNC``

``64-bit``
"""
MVEX_VBROADCASTF64X4_ZMM_K1_MT: Code = 4664 # type: ignore
"""
``VBROADCASTF64X4 zmm1 {k1}, Uf64(mt)``

``MVEX.512.66.0F38.W1 1B /r``

``KNC``

``64-bit``
"""
MVEX_VPTESTMD_KR_K1_ZMM_ZMMMT: Code = 4665 # type: ignore
"""
``VPTESTMD k2 {k1}, zmm1, Si32(zmm2/mt)``

``MVEX.NDS.512.66.0F38.W0 27 /r``

``KNC``

``64-bit``
"""
MVEX_VPERMD_ZMM_K1_ZMM_ZMMMT: Code = 4666 # type: ignore
"""
``VPERMD zmm1 {k1}, zmm2, zmm3/mt``

``MVEX.NDS.512.66.0F38.W0 36 /r``

``KNC``

``64-bit``
"""
MVEX_VPMINSD_ZMM_K1_ZMM_ZMMMT: Code = 4667 # type: ignore
"""
``VPMINSD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 39 /r``

``KNC``

``64-bit``
"""
MVEX_VPMINUD_ZMM_K1_ZMM_ZMMMT: Code = 4668 # type: ignore
"""
``VPMINUD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 3B /r``

``KNC``

``64-bit``
"""
MVEX_VPMAXSD_ZMM_K1_ZMM_ZMMMT: Code = 4669 # type: ignore
"""
``VPMAXSD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 3D /r``

``KNC``

``64-bit``
"""
MVEX_VPMAXUD_ZMM_K1_ZMM_ZMMMT: Code = 4670 # type: ignore
"""
``VPMAXUD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 3F /r``

``KNC``

``64-bit``
"""
MVEX_VPMULLD_ZMM_K1_ZMM_ZMMMT: Code = 4671 # type: ignore
"""
``VPMULLD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 40 /r``

``KNC``

``64-bit``
"""
MVEX_VGETEXPPS_ZMM_K1_ZMMMT: Code = 4672 # type: ignore
"""
``VGETEXPPS zmm1 {k1}, Sf32(zmm2/mt)``

``MVEX.512.66.0F38.W0 42 /r``

``KNC``

``64-bit``
"""
MVEX_VGETEXPPD_ZMM_K1_ZMMMT: Code = 4673 # type: ignore
"""
``VGETEXPPD zmm1 {k1}, Sf64(zmm2/mt)``

``MVEX.512.66.0F38.W1 42 /r``

``KNC``

``64-bit``
"""
MVEX_VPSRLVD_ZMM_K1_ZMM_ZMMMT: Code = 4674 # type: ignore
"""
``VPSRLVD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 45 /r``

``KNC``

``64-bit``
"""
MVEX_VPSRAVD_ZMM_K1_ZMM_ZMMMT: Code = 4675 # type: ignore
"""
``VPSRAVD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 46 /r``

``KNC``

``64-bit``
"""
MVEX_VPSLLVD_ZMM_K1_ZMM_ZMMMT: Code = 4676 # type: ignore
"""
``VPSLLVD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 47 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMMMT_512_66_0F38_W0_48: Code = 4677 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2/mt``

``MVEX.512.66.0F38.W0 48 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMMMT_512_66_0F38_W0_49: Code = 4678 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2/mt``

``MVEX.512.66.0F38.W0 49 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMMMT_512_66_0F38_W0_4A: Code = 4679 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2/mt``

``MVEX.512.66.0F38.W0 4A /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMMMT_512_66_0F38_W0_4B: Code = 4680 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2/mt``

``MVEX.512.66.0F38.W0 4B /r``

``KNC``

``64-bit``
"""
MVEX_VADDNPS_ZMM_K1_ZMM_ZMMMT: Code = 4681 # type: ignore
"""
``VADDNPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 50 /r``

``KNC``

``64-bit``
"""
MVEX_VADDNPD_ZMM_K1_ZMM_ZMMMT: Code = 4682 # type: ignore
"""
``VADDNPD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 50 /r``

``KNC``

``64-bit``
"""
MVEX_VGMAXABSPS_ZMM_K1_ZMM_ZMMMT: Code = 4683 # type: ignore
"""
``VGMAXABSPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 51 /r``

``KNC``

``64-bit``
"""
MVEX_VGMINPS_ZMM_K1_ZMM_ZMMMT: Code = 4684 # type: ignore
"""
``VGMINPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 52 /r``

``KNC``

``64-bit``
"""
MVEX_VGMINPD_ZMM_K1_ZMM_ZMMMT: Code = 4685 # type: ignore
"""
``VGMINPD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 52 /r``

``KNC``

``64-bit``
"""
MVEX_VGMAXPS_ZMM_K1_ZMM_ZMMMT: Code = 4686 # type: ignore
"""
``VGMAXPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 53 /r``

``KNC``

``64-bit``
"""
MVEX_VGMAXPD_ZMM_K1_ZMM_ZMMMT: Code = 4687 # type: ignore
"""
``VGMAXPD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 53 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMM_ZMMMT_512_66_0F38_W0_54: Code = 4688 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2, zmm3/mt``

``MVEX.NDS.512.66.0F38.W0 54 /r``

``KNC``

``64-bit``
"""
MVEX_VFIXUPNANPS_ZMM_K1_ZMM_ZMMMT: Code = 4689 # type: ignore
"""
``VFIXUPNANPS zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 55 /r``

``KNC``

``64-bit``
"""
MVEX_VFIXUPNANPD_ZMM_K1_ZMM_ZMMMT: Code = 4690 # type: ignore
"""
``VFIXUPNANPD zmm1 {k1}, zmm2, Si64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 55 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMM_ZMMMT_512_66_0F38_W0_56: Code = 4691 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2, zmm3/mt``

``MVEX.NDS.512.66.0F38.W0 56 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMM_ZMMMT_512_66_0F38_W0_57: Code = 4692 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2, zmm3/mt``

``MVEX.NDS.512.66.0F38.W0 57 /r``

``KNC``

``64-bit``
"""
MVEX_VPBROADCASTD_ZMM_K1_MT: Code = 4693 # type: ignore
"""
``VPBROADCASTD zmm1 {k1}, Ui32(mt)``

``MVEX.512.66.0F38.W0 58 /r``

``KNC``

``64-bit``
"""
MVEX_VPBROADCASTQ_ZMM_K1_MT: Code = 4694 # type: ignore
"""
``VPBROADCASTQ zmm1 {k1}, Ui64(mt)``

``MVEX.512.66.0F38.W1 59 /r``

``KNC``

``64-bit``
"""
MVEX_VBROADCASTI32X4_ZMM_K1_MT: Code = 4695 # type: ignore
"""
``VBROADCASTI32X4 zmm1 {k1}, Ui32(mt)``

``MVEX.512.66.0F38.W0 5A /r``

``KNC``

``64-bit``
"""
MVEX_VBROADCASTI64X4_ZMM_K1_MT: Code = 4696 # type: ignore
"""
``VBROADCASTI64X4 zmm1 {k1}, Ui64(mt)``

``MVEX.512.66.0F38.W1 5B /r``

``KNC``

``64-bit``
"""
MVEX_VPADCD_ZMM_K1_KR_ZMMMT: Code = 4697 # type: ignore
"""
``VPADCD zmm1 {k1}, k2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 5C /r``

``KNC``

``64-bit``
"""
MVEX_VPADDSETCD_ZMM_K1_KR_ZMMMT: Code = 4698 # type: ignore
"""
``VPADDSETCD zmm1 {k1}, k2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 5D /r``

``KNC``

``64-bit``
"""
MVEX_VPSBBD_ZMM_K1_KR_ZMMMT: Code = 4699 # type: ignore
"""
``VPSBBD zmm1 {k1}, k2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 5E /r``

``KNC``

``64-bit``
"""
MVEX_VPSUBSETBD_ZMM_K1_KR_ZMMMT: Code = 4700 # type: ignore
"""
``VPSUBSETBD zmm1 {k1}, k2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 5F /r``

``KNC``

``64-bit``
"""
MVEX_VPBLENDMD_ZMM_K1_ZMM_ZMMMT: Code = 4701 # type: ignore
"""
``VPBLENDMD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 64 /r``

``KNC``

``64-bit``
"""
MVEX_VPBLENDMQ_ZMM_K1_ZMM_ZMMMT: Code = 4702 # type: ignore
"""
``VPBLENDMQ zmm1 {k1}, zmm2, Si64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 64 /r``

``KNC``

``64-bit``
"""
MVEX_VBLENDMPS_ZMM_K1_ZMM_ZMMMT: Code = 4703 # type: ignore
"""
``VBLENDMPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 65 /r``

``KNC``

``64-bit``
"""
MVEX_VBLENDMPD_ZMM_K1_ZMM_ZMMMT: Code = 4704 # type: ignore
"""
``VBLENDMPD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 65 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMM_ZMMMT_512_66_0F38_W0_67: Code = 4705 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2, zmm3/mt``

``MVEX.NDS.512.66.0F38.W0 67 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMMMT_512_66_0F38_W0_68: Code = 4706 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2/mt``

``MVEX.512.66.0F38.W0 68 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMMMT_512_66_0F38_W0_69: Code = 4707 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2/mt``

``MVEX.512.66.0F38.W0 69 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMMMT_512_66_0F38_W0_6A: Code = 4708 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2/mt``

``MVEX.512.66.0F38.W0 6A /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMMMT_512_66_0F38_W0_6B: Code = 4709 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2/mt``

``MVEX.512.66.0F38.W0 6B /r``

``KNC``

``64-bit``
"""
MVEX_VPSUBRD_ZMM_K1_ZMM_ZMMMT: Code = 4710 # type: ignore
"""
``VPSUBRD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 6C /r``

``KNC``

``64-bit``
"""
MVEX_VSUBRPS_ZMM_K1_ZMM_ZMMMT: Code = 4711 # type: ignore
"""
``VSUBRPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 6D /r``

``KNC``

``64-bit``
"""
MVEX_VSUBRPD_ZMM_K1_ZMM_ZMMMT: Code = 4712 # type: ignore
"""
``VSUBRPD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 6D /r``

``KNC``

``64-bit``
"""
MVEX_VPSBBRD_ZMM_K1_KR_ZMMMT: Code = 4713 # type: ignore
"""
``VPSBBRD zmm1 {k1}, k2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 6E /r``

``KNC``

``64-bit``
"""
MVEX_VPSUBRSETBD_ZMM_K1_KR_ZMMMT: Code = 4714 # type: ignore
"""
``VPSUBRSETBD zmm1 {k1}, k2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 6F /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMM_ZMMMT_512_66_0F38_W0_70: Code = 4715 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2, zmm3/mt``

``MVEX.NDS.512.66.0F38.W0 70 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMM_ZMMMT_512_66_0F38_W0_71: Code = 4716 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2, zmm3/mt``

``MVEX.NDS.512.66.0F38.W0 71 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMM_ZMMMT_512_66_0F38_W0_72: Code = 4717 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2, zmm3/mt``

``MVEX.NDS.512.66.0F38.W0 72 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMM_ZMMMT_512_66_0F38_W0_73: Code = 4718 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2, zmm3/mt``

``MVEX.NDS.512.66.0F38.W0 73 /r``

``KNC``

``64-bit``
"""
MVEX_VPCMPLTD_KR_K1_ZMM_ZMMMT: Code = 4719 # type: ignore
"""
``VPCMPLTD k2 {k1}, zmm1, Si32(zmm2/mt)``

``MVEX.NDS.512.66.0F38.W0 74 /r``

``KNC``

``64-bit``
"""
MVEX_VSCALEPS_ZMM_K1_ZMM_ZMMMT: Code = 4720 # type: ignore
"""
``VSCALEPS zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 84 /r``

``KNC``

``64-bit``
"""
MVEX_VPMULHUD_ZMM_K1_ZMM_ZMMMT: Code = 4721 # type: ignore
"""
``VPMULHUD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 86 /r``

``KNC``

``64-bit``
"""
MVEX_VPMULHD_ZMM_K1_ZMM_ZMMMT: Code = 4722 # type: ignore
"""
``VPMULHD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 87 /r``

``KNC``

``64-bit``
"""
MVEX_VPGATHERDD_ZMM_K1_MVT: Code = 4723 # type: ignore
"""
``VPGATHERDD zmm1 {k1}, Ui32(mvt)``

``MVEX.512.66.0F38.W0 90 /vsib``

``KNC``

``64-bit``
"""
MVEX_VPGATHERDQ_ZMM_K1_MVT: Code = 4724 # type: ignore
"""
``VPGATHERDQ zmm1 {k1}, Ui64(mvt)``

``MVEX.512.66.0F38.W1 90 /vsib``

``KNC``

``64-bit``
"""
MVEX_VGATHERDPS_ZMM_K1_MVT: Code = 4725 # type: ignore
"""
``VGATHERDPS zmm1 {k1}, Uf32(mvt)``

``MVEX.512.66.0F38.W0 92 /vsib``

``KNC``

``64-bit``
"""
MVEX_VGATHERDPD_ZMM_K1_MVT: Code = 4726 # type: ignore
"""
``VGATHERDPD zmm1 {k1}, Uf64(mvt)``

``MVEX.512.66.0F38.W1 92 /vsib``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMM_ZMMMT_512_66_0F38_W0_94: Code = 4727 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2, zmm3/mt``

``MVEX.NDS.512.66.0F38.W0 94 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMM_ZMMMT_512_66_0F38_W1_94: Code = 4728 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2, zmm3/mt``

``MVEX.NDS.512.66.0F38.W1 94 /r``

``KNC``

``64-bit``
"""
MVEX_VFMADD132PS_ZMM_K1_ZMM_ZMMMT: Code = 4729 # type: ignore
"""
``VFMADD132PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 98 /r``

``KNC``

``64-bit``
"""
MVEX_VFMADD132PD_ZMM_K1_ZMM_ZMMMT: Code = 4730 # type: ignore
"""
``VFMADD132PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 98 /r``

``KNC``

``64-bit``
"""
MVEX_VFMSUB132PS_ZMM_K1_ZMM_ZMMMT: Code = 4731 # type: ignore
"""
``VFMSUB132PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 9A /r``

``KNC``

``64-bit``
"""
MVEX_VFMSUB132PD_ZMM_K1_ZMM_ZMMMT: Code = 4732 # type: ignore
"""
``VFMSUB132PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 9A /r``

``KNC``

``64-bit``
"""
MVEX_VFNMADD132PS_ZMM_K1_ZMM_ZMMMT: Code = 4733 # type: ignore
"""
``VFNMADD132PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 9C /r``

``KNC``

``64-bit``
"""
MVEX_VFNMADD132PD_ZMM_K1_ZMM_ZMMMT: Code = 4734 # type: ignore
"""
``VFNMADD132PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 9C /r``

``KNC``

``64-bit``
"""
MVEX_VFNMSUB132PS_ZMM_K1_ZMM_ZMMMT: Code = 4735 # type: ignore
"""
``VFNMSUB132PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 9E /r``

``KNC``

``64-bit``
"""
MVEX_VFNMSUB132PD_ZMM_K1_ZMM_ZMMMT: Code = 4736 # type: ignore
"""
``VFNMSUB132PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 9E /r``

``KNC``

``64-bit``
"""
MVEX_VPSCATTERDD_MVT_K1_ZMM: Code = 4737 # type: ignore
"""
``VPSCATTERDD mvt {k1}, Di32(zmm1)``

``MVEX.512.66.0F38.W0 A0 /vsib``

``KNC``

``64-bit``
"""
MVEX_VPSCATTERDQ_MVT_K1_ZMM: Code = 4738 # type: ignore
"""
``VPSCATTERDQ mvt {k1}, Di64(zmm1)``

``MVEX.512.66.0F38.W1 A0 /vsib``

``KNC``

``64-bit``
"""
MVEX_VSCATTERDPS_MVT_K1_ZMM: Code = 4739 # type: ignore
"""
``VSCATTERDPS mvt {k1}, Df32(zmm1)``

``MVEX.512.66.0F38.W0 A2 /vsib``

``KNC``

``64-bit``
"""
MVEX_VSCATTERDPD_MVT_K1_ZMM: Code = 4740 # type: ignore
"""
``VSCATTERDPD mvt {k1}, Df64(zmm1)``

``MVEX.512.66.0F38.W1 A2 /vsib``

``KNC``

``64-bit``
"""
MVEX_VFMADD233PS_ZMM_K1_ZMM_ZMMMT: Code = 4741 # type: ignore
"""
``VFMADD233PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 A4 /r``

``KNC``

``64-bit``
"""
MVEX_VFMADD213PS_ZMM_K1_ZMM_ZMMMT: Code = 4742 # type: ignore
"""
``VFMADD213PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 A8 /r``

``KNC``

``64-bit``
"""
MVEX_VFMADD213PD_ZMM_K1_ZMM_ZMMMT: Code = 4743 # type: ignore
"""
``VFMADD213PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 A8 /r``

``KNC``

``64-bit``
"""
MVEX_VFMSUB213PS_ZMM_K1_ZMM_ZMMMT: Code = 4744 # type: ignore
"""
``VFMSUB213PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 AA /r``

``KNC``

``64-bit``
"""
MVEX_VFMSUB213PD_ZMM_K1_ZMM_ZMMMT: Code = 4745 # type: ignore
"""
``VFMSUB213PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 AA /r``

``KNC``

``64-bit``
"""
MVEX_VFNMADD213PS_ZMM_K1_ZMM_ZMMMT: Code = 4746 # type: ignore
"""
``VFNMADD213PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 AC /r``

``KNC``

``64-bit``
"""
MVEX_VFNMADD213PD_ZMM_K1_ZMM_ZMMMT: Code = 4747 # type: ignore
"""
``VFNMADD213PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 AC /r``

``KNC``

``64-bit``
"""
MVEX_VFNMSUB213PS_ZMM_K1_ZMM_ZMMMT: Code = 4748 # type: ignore
"""
``VFNMSUB213PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 AE /r``

``KNC``

``64-bit``
"""
MVEX_VFNMSUB213PD_ZMM_K1_ZMM_ZMMMT: Code = 4749 # type: ignore
"""
``VFNMSUB213PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 AE /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_MVT_512_66_0F38_W0_B0: Code = 4750 # type: ignore
"""
``UNDOC zmm1 {k1}, mvt``

``MVEX.512.66.0F38.W0 B0 /vsib``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_MVT_512_66_0F38_W0_B2: Code = 4751 # type: ignore
"""
``UNDOC zmm1 {k1}, mvt``

``MVEX.512.66.0F38.W0 B2 /vsib``

``KNC``

``64-bit``
"""
MVEX_VPMADD233D_ZMM_K1_ZMM_ZMMMT: Code = 4752 # type: ignore
"""
``VPMADD233D zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 B4 /r``

``KNC``

``64-bit``
"""
MVEX_VPMADD231D_ZMM_K1_ZMM_ZMMMT: Code = 4753 # type: ignore
"""
``VPMADD231D zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 B5 /r``

``KNC``

``64-bit``
"""
MVEX_VFMADD231PS_ZMM_K1_ZMM_ZMMMT: Code = 4754 # type: ignore
"""
``VFMADD231PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 B8 /r``

``KNC``

``64-bit``
"""
MVEX_VFMADD231PD_ZMM_K1_ZMM_ZMMMT: Code = 4755 # type: ignore
"""
``VFMADD231PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 B8 /r``

``KNC``

``64-bit``
"""
MVEX_VFMSUB231PS_ZMM_K1_ZMM_ZMMMT: Code = 4756 # type: ignore
"""
``VFMSUB231PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 BA /r``

``KNC``

``64-bit``
"""
MVEX_VFMSUB231PD_ZMM_K1_ZMM_ZMMMT: Code = 4757 # type: ignore
"""
``VFMSUB231PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 BA /r``

``KNC``

``64-bit``
"""
MVEX_VFNMADD231PS_ZMM_K1_ZMM_ZMMMT: Code = 4758 # type: ignore
"""
``VFNMADD231PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 BC /r``

``KNC``

``64-bit``
"""
MVEX_VFNMADD231PD_ZMM_K1_ZMM_ZMMMT: Code = 4759 # type: ignore
"""
``VFNMADD231PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 BC /r``

``KNC``

``64-bit``
"""
MVEX_VFNMSUB231PS_ZMM_K1_ZMM_ZMMMT: Code = 4760 # type: ignore
"""
``VFNMSUB231PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 BE /r``

``KNC``

``64-bit``
"""
MVEX_VFNMSUB231PD_ZMM_K1_ZMM_ZMMMT: Code = 4761 # type: ignore
"""
``VFNMSUB231PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W1 BE /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_MVT_512_66_0F38_W0_C0: Code = 4762 # type: ignore
"""
``UNDOC zmm1 {k1}, mvt``

``MVEX.512.66.0F38.W0 C0 /vsib``

``KNC``

``64-bit``
"""
MVEX_VGATHERPF0HINTDPS_MVT_K1: Code = 4763 # type: ignore
"""
``VGATHERPF0HINTDPS Uf32(mvt) {k1}``

``MVEX.512.66.0F38.W0 C6 /0 /vsib``

``KNC``

``64-bit``
"""
MVEX_VGATHERPF0HINTDPD_MVT_K1: Code = 4764 # type: ignore
"""
``VGATHERPF0HINTDPD Uf64(mvt) {k1}``

``MVEX.512.66.0F38.W1 C6 /0 /vsib``

``KNC``

``64-bit``
"""
MVEX_VGATHERPF0DPS_MVT_K1: Code = 4765 # type: ignore
"""
``VGATHERPF0DPS Uf32(mvt) {k1}``

``MVEX.512.66.0F38.W0 C6 /1 /vsib``

``KNC``

``64-bit``
"""
MVEX_VGATHERPF1DPS_MVT_K1: Code = 4766 # type: ignore
"""
``VGATHERPF1DPS Uf32(mvt) {k1}``

``MVEX.512.66.0F38.W0 C6 /2 /vsib``

``KNC``

``64-bit``
"""
MVEX_VSCATTERPF0HINTDPS_MVT_K1: Code = 4767 # type: ignore
"""
``VSCATTERPF0HINTDPS Uf32(mvt) {k1}``

``MVEX.512.66.0F38.W0 C6 /4 /vsib``

``KNC``

``64-bit``
"""
MVEX_VSCATTERPF0HINTDPD_MVT_K1: Code = 4768 # type: ignore
"""
``VSCATTERPF0HINTDPD Uf64(mvt) {k1}``

``MVEX.512.66.0F38.W1 C6 /4 /vsib``

``KNC``

``64-bit``
"""
MVEX_VSCATTERPF0DPS_MVT_K1: Code = 4769 # type: ignore
"""
``VSCATTERPF0DPS Uf32(mvt) {k1}``

``MVEX.512.66.0F38.W0 C6 /5 /vsib``

``KNC``

``64-bit``
"""
MVEX_VSCATTERPF1DPS_MVT_K1: Code = 4770 # type: ignore
"""
``VSCATTERPF1DPS Uf32(mvt) {k1}``

``MVEX.512.66.0F38.W0 C6 /6 /vsib``

``KNC``

``64-bit``
"""
MVEX_VEXP223PS_ZMM_K1_ZMMMT: Code = 4771 # type: ignore
"""
``VEXP223PS zmm1 {k1}, zmm2/mt``

``MVEX.512.66.0F38.W0 C8 /r``

``KNC``

``64-bit``
"""
MVEX_VLOG2PS_ZMM_K1_ZMMMT: Code = 4772 # type: ignore
"""
``VLOG2PS zmm1 {k1}, zmm2/mt``

``MVEX.512.66.0F38.W0 C9 /r``

``KNC``

``64-bit``
"""
MVEX_VRCP23PS_ZMM_K1_ZMMMT: Code = 4773 # type: ignore
"""
``VRCP23PS zmm1 {k1}, zmm2/mt``

``MVEX.512.66.0F38.W0 CA /r``

``KNC``

``64-bit``
"""
MVEX_VRSQRT23PS_ZMM_K1_ZMMMT: Code = 4774 # type: ignore
"""
``VRSQRT23PS zmm1 {k1}, zmm2/mt``

``MVEX.512.66.0F38.W0 CB /r``

``KNC``

``64-bit``
"""
MVEX_VADDSETSPS_ZMM_K1_ZMM_ZMMMT: Code = 4775 # type: ignore
"""
``VADDSETSPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 CC /r``

``KNC``

``64-bit``
"""
MVEX_VPADDSETSD_ZMM_K1_ZMM_ZMMMT: Code = 4776 # type: ignore
"""
``VPADDSETSD zmm1 {k1}, zmm2, Si32(zmm3/mt)``

``MVEX.NDS.512.66.0F38.W0 CD /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMM_ZMMMT_512_66_0F38_W0_CE: Code = 4777 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2, zmm3/mt``

``MVEX.NDS.512.66.0F38.W0 CE /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMM_ZMMMT_512_66_0F38_W1_CE: Code = 4778 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2, zmm3/mt``

``MVEX.NDS.512.66.0F38.W1 CE /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMM_ZMMMT_512_66_0F38_W0_CF: Code = 4779 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2, zmm3/mt``

``MVEX.NDS.512.66.0F38.W0 CF /r``

``KNC``

``64-bit``
"""
MVEX_VLOADUNPACKLD_ZMM_K1_MT: Code = 4780 # type: ignore
"""
``VLOADUNPACKLD zmm1 {k1}, Ui32(mt)``

``MVEX.512.0F38.W0 D0 /r``

``KNC``

``64-bit``
"""
MVEX_VLOADUNPACKLQ_ZMM_K1_MT: Code = 4781 # type: ignore
"""
``VLOADUNPACKLQ zmm1 {k1}, Ui64(mt)``

``MVEX.512.0F38.W1 D0 /r``

``KNC``

``64-bit``
"""
MVEX_VPACKSTORELD_MT_K1_ZMM: Code = 4782 # type: ignore
"""
``VPACKSTORELD mt {k1}, Di32(zmm1)``

``MVEX.512.66.0F38.W0 D0 /r``

``KNC``

``64-bit``
"""
MVEX_VPACKSTORELQ_MT_K1_ZMM: Code = 4783 # type: ignore
"""
``VPACKSTORELQ mt {k1}, Di64(zmm1)``

``MVEX.512.66.0F38.W1 D0 /r``

``KNC``

``64-bit``
"""
MVEX_VLOADUNPACKLPS_ZMM_K1_MT: Code = 4784 # type: ignore
"""
``VLOADUNPACKLPS zmm1 {k1}, Uf32(mt)``

``MVEX.512.0F38.W0 D1 /r``

``KNC``

``64-bit``
"""
MVEX_VLOADUNPACKLPD_ZMM_K1_MT: Code = 4785 # type: ignore
"""
``VLOADUNPACKLPD zmm1 {k1}, Uf64(mt)``

``MVEX.512.0F38.W1 D1 /r``

``KNC``

``64-bit``
"""
MVEX_VPACKSTORELPS_MT_K1_ZMM: Code = 4786 # type: ignore
"""
``VPACKSTORELPS mt {k1}, Df32(zmm1)``

``MVEX.512.66.0F38.W0 D1 /r``

``KNC``

``64-bit``
"""
MVEX_VPACKSTORELPD_MT_K1_ZMM: Code = 4787 # type: ignore
"""
``VPACKSTORELPD mt {k1}, Df64(zmm1)``

``MVEX.512.66.0F38.W1 D1 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMMMT_512_0F38_W0_D2: Code = 4788 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2/mt``

``MVEX.512.0F38.W0 D2 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMMMT_512_66_0F38_W0_D2: Code = 4789 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2/mt``

``MVEX.512.66.0F38.W0 D2 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMMMT_512_0F38_W0_D3: Code = 4790 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2/mt``

``MVEX.512.0F38.W0 D3 /r``

``KNC``

``64-bit``
"""
MVEX_VLOADUNPACKHD_ZMM_K1_MT: Code = 4791 # type: ignore
"""
``VLOADUNPACKHD zmm1 {k1}, Ui32(mt)``

``MVEX.512.0F38.W0 D4 /r``

``KNC``

``64-bit``
"""
MVEX_VLOADUNPACKHQ_ZMM_K1_MT: Code = 4792 # type: ignore
"""
``VLOADUNPACKHQ zmm1 {k1}, Ui64(mt)``

``MVEX.512.0F38.W1 D4 /r``

``KNC``

``64-bit``
"""
MVEX_VPACKSTOREHD_MT_K1_ZMM: Code = 4793 # type: ignore
"""
``VPACKSTOREHD mt {k1}, Di32(zmm1)``

``MVEX.512.66.0F38.W0 D4 /r``

``KNC``

``64-bit``
"""
MVEX_VPACKSTOREHQ_MT_K1_ZMM: Code = 4794 # type: ignore
"""
``VPACKSTOREHQ mt {k1}, Di64(zmm1)``

``MVEX.512.66.0F38.W1 D4 /r``

``KNC``

``64-bit``
"""
MVEX_VLOADUNPACKHPS_ZMM_K1_MT: Code = 4795 # type: ignore
"""
``VLOADUNPACKHPS zmm1 {k1}, Uf32(mt)``

``MVEX.512.0F38.W0 D5 /r``

``KNC``

``64-bit``
"""
MVEX_VLOADUNPACKHPD_ZMM_K1_MT: Code = 4796 # type: ignore
"""
``VLOADUNPACKHPD zmm1 {k1}, Uf64(mt)``

``MVEX.512.0F38.W1 D5 /r``

``KNC``

``64-bit``
"""
MVEX_VPACKSTOREHPS_MT_K1_ZMM: Code = 4797 # type: ignore
"""
``VPACKSTOREHPS mt {k1}, Df32(zmm1)``

``MVEX.512.66.0F38.W0 D5 /r``

``KNC``

``64-bit``
"""
MVEX_VPACKSTOREHPD_MT_K1_ZMM: Code = 4798 # type: ignore
"""
``VPACKSTOREHPD mt {k1}, Df64(zmm1)``

``MVEX.512.66.0F38.W1 D5 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMMMT_512_0F38_W0_D6: Code = 4799 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2/mt``

``MVEX.512.0F38.W0 D6 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMMMT_512_66_0F38_W0_D6: Code = 4800 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2/mt``

``MVEX.512.66.0F38.W0 D6 /r``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMMMT_512_0F38_W0_D7: Code = 4801 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2/mt``

``MVEX.512.0F38.W0 D7 /r``

``KNC``

``64-bit``
"""
MVEX_VALIGND_ZMM_K1_ZMM_ZMMMT_IMM8: Code = 4802 # type: ignore
"""
``VALIGND zmm1 {k1}, zmm2, zmm3/mt, imm8``

``MVEX.NDS.512.66.0F3A.W0 03 /r ib``

``KNC``

``64-bit``
"""
MVEX_VPERMF32X4_ZMM_K1_ZMMMT_IMM8: Code = 4803 # type: ignore
"""
``VPERMF32X4 zmm1 {k1}, zmm2/mt, imm8``

``MVEX.512.66.0F3A.W0 07 /r ib``

``KNC``

``64-bit``
"""
MVEX_VPCMPUD_KR_K1_ZMM_ZMMMT_IMM8: Code = 4804 # type: ignore
"""
``VPCMPUD k2 {k1}, zmm1, Si32(zmm2/mt), imm8``

``MVEX.NDS.512.66.0F3A.W0 1E /r ib``

``KNC``

``64-bit``
"""
MVEX_VPCMPD_KR_K1_ZMM_ZMMMT_IMM8: Code = 4805 # type: ignore
"""
``VPCMPD k2 {k1}, zmm1, Si32(zmm2/mt), imm8``

``MVEX.NDS.512.66.0F3A.W0 1F /r ib``

``KNC``

``64-bit``
"""
MVEX_VGETMANTPS_ZMM_K1_ZMMMT_IMM8: Code = 4806 # type: ignore
"""
``VGETMANTPS zmm1 {k1}, Sf32(zmm2/mt), imm8``

``MVEX.512.66.0F3A.W0 26 /r ib``

``KNC``

``64-bit``
"""
MVEX_VGETMANTPD_ZMM_K1_ZMMMT_IMM8: Code = 4807 # type: ignore
"""
``VGETMANTPD zmm1 {k1}, Sf64(zmm2/mt), imm8``

``MVEX.512.66.0F3A.W1 26 /r ib``

``KNC``

``64-bit``
"""
MVEX_VRNDFXPNTPS_ZMM_K1_ZMMMT_IMM8: Code = 4808 # type: ignore
"""
``VRNDFXPNTPS zmm1 {k1}, Sf32(zmm2/mt), imm8``

``MVEX.512.66.0F3A.W0 52 /r ib``

``KNC``

``64-bit``
"""
MVEX_VRNDFXPNTPD_ZMM_K1_ZMMMT_IMM8: Code = 4809 # type: ignore
"""
``VRNDFXPNTPD zmm1 {k1}, Sf64(zmm2/mt), imm8``

``MVEX.512.66.0F3A.W1 52 /r ib``

``KNC``

``64-bit``
"""
MVEX_VCVTFXPNTUDQ2PS_ZMM_K1_ZMMMT_IMM8: Code = 4810 # type: ignore
"""
``VCVTFXPNTUDQ2PS zmm1 {k1}, Si32(zmm2/mt), imm8``

``MVEX.512.0F3A.W0 CA /r ib``

``KNC``

``64-bit``
"""
MVEX_VCVTFXPNTPS2UDQ_ZMM_K1_ZMMMT_IMM8: Code = 4811 # type: ignore
"""
``VCVTFXPNTPS2UDQ zmm1 {k1}, Sf32(zmm2/mt), imm8``

``MVEX.512.66.0F3A.W0 CA /r ib``

``KNC``

``64-bit``
"""
MVEX_VCVTFXPNTPD2UDQ_ZMM_K1_ZMMMT_IMM8: Code = 4812 # type: ignore
"""
``VCVTFXPNTPD2UDQ zmm1 {k1}, Sf64(zmm2/mt), imm8``

``MVEX.512.F2.0F3A.W1 CA /r ib``

``KNC``

``64-bit``
"""
MVEX_VCVTFXPNTDQ2PS_ZMM_K1_ZMMMT_IMM8: Code = 4813 # type: ignore
"""
``VCVTFXPNTDQ2PS zmm1 {k1}, Si32(zmm2/mt), imm8``

``MVEX.512.0F3A.W0 CB /r ib``

``KNC``

``64-bit``
"""
MVEX_VCVTFXPNTPS2DQ_ZMM_K1_ZMMMT_IMM8: Code = 4814 # type: ignore
"""
``VCVTFXPNTPS2DQ zmm1 {k1}, Sf32(zmm2/mt), imm8``

``MVEX.512.66.0F3A.W0 CB /r ib``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMMMT_IMM8_512_66_0F3A_W0_D0: Code = 4815 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2/mt, imm8``

``MVEX.512.66.0F3A.W0 D0 /r ib``

``KNC``

``64-bit``
"""
MVEX_UNDOC_ZMM_K1_ZMMMT_IMM8_512_66_0F3A_W0_D1: Code = 4816 # type: ignore
"""
``UNDOC zmm1 {k1}, zmm2/mt, imm8``

``MVEX.512.66.0F3A.W0 D1 /r ib``

``KNC``

``64-bit``
"""
MVEX_VCVTFXPNTPD2DQ_ZMM_K1_ZMMMT_IMM8: Code = 4817 # type: ignore
"""
``VCVTFXPNTPD2DQ zmm1 {k1}, Sf64(zmm2/mt), imm8``

``MVEX.512.F2.0F3A.W1 E6 /r ib``

``KNC``

``64-bit``
"""
VIA_UNDOC_F30FA6F0_16: Code = 4818 # type: ignore
"""
``UNDOC``

``a16 F3 0F A6 F0``

``PADLOCK_UNDOC``

``16/32-bit``
"""
VIA_UNDOC_F30FA6F0_32: Code = 4819 # type: ignore
"""
``UNDOC``

``a32 F3 0F A6 F0``

``PADLOCK_UNDOC``

``16/32/64-bit``
"""
VIA_UNDOC_F30FA6F0_64: Code = 4820 # type: ignore
"""
``UNDOC``

``a64 F3 0F A6 F0``

``PADLOCK_UNDOC``

``64-bit``
"""
VIA_UNDOC_F30FA6F8_16: Code = 4821 # type: ignore
"""
``UNDOC``

``a16 F3 0F A6 F8``

``PADLOCK_UNDOC``

``16/32-bit``
"""
VIA_UNDOC_F30FA6F8_32: Code = 4822 # type: ignore
"""
``UNDOC``

``a32 F3 0F A6 F8``

``PADLOCK_UNDOC``

``16/32/64-bit``
"""
VIA_UNDOC_F30FA6F8_64: Code = 4823 # type: ignore
"""
``UNDOC``

``a64 F3 0F A6 F8``

``PADLOCK_UNDOC``

``64-bit``
"""
XSHA512_16: Code = 4824 # type: ignore
"""
``XSHA512``

``a16 F3 0F A6 E0``

``PADLOCK_PHE``

``16/32-bit``
"""
XSHA512_32: Code = 4825 # type: ignore
"""
``XSHA512``

``a32 F3 0F A6 E0``

``PADLOCK_PHE``

``16/32/64-bit``
"""
XSHA512_64: Code = 4826 # type: ignore
"""
``XSHA512``

``a64 F3 0F A6 E0``

``PADLOCK_PHE``

``64-bit``
"""
XSTORE_ALT_16: Code = 4827 # type: ignore
"""
``XSTORE_ALT``

``a16 F3 0F A7 F8``

``PADLOCK_RNG``

``16/32-bit``
"""
XSTORE_ALT_32: Code = 4828 # type: ignore
"""
``XSTORE_ALT``

``a32 F3 0F A7 F8``

``PADLOCK_RNG``

``16/32/64-bit``
"""
XSTORE_ALT_64: Code = 4829 # type: ignore
"""
``XSTORE_ALT``

``a64 F3 0F A7 F8``

``PADLOCK_RNG``

``64-bit``
"""
XSHA512_ALT_16: Code = 4830 # type: ignore
"""
``XSHA512_ALT``

``a16 F3 0F A6 D8``

``PADLOCK_PHE``

``16/32-bit``
"""
XSHA512_ALT_32: Code = 4831 # type: ignore
"""
``XSHA512_ALT``

``a32 F3 0F A6 D8``

``PADLOCK_PHE``

``16/32/64-bit``
"""
XSHA512_ALT_64: Code = 4832 # type: ignore
"""
``XSHA512_ALT``

``a64 F3 0F A6 D8``

``PADLOCK_PHE``

``64-bit``
"""
ZERO_BYTES: Code = 4833 # type: ignore
"""
A zero-sized instruction. Can be used as a label.
"""
WRMSRNS: Code = 4834 # type: ignore
"""
``WRMSRNS``

``NP 0F 01 C6``

``WRMSRNS``

``16/32/64-bit``
"""
WRMSRLIST: Code = 4835 # type: ignore
"""
``WRMSRLIST``

``F3 0F 01 C6``

``MSRLIST``

``64-bit``
"""
RDMSRLIST: Code = 4836 # type: ignore
"""
``RDMSRLIST``

``F2 0F 01 C6``

``MSRLIST``

``64-bit``
"""
RMPQUERY: Code = 4837 # type: ignore
"""
``RMPQUERY``

``F3 0F 01 FD``

``RMPQUERY``

``64-bit``
"""
PREFETCHIT1_M8: Code = 4838 # type: ignore
"""
``PREFETCHIT1 m8``

``0F 18 /6``

``PREFETCHITI``

``16/32/64-bit``
"""
PREFETCHIT0_M8: Code = 4839 # type: ignore
"""
``PREFETCHIT0 m8``

``0F 18 /7``

``PREFETCHITI``

``16/32/64-bit``
"""
AADD_M32_R32: Code = 4840 # type: ignore
"""
``AADD m32, r32``

``NP 0F 38 FC !(11):rrr:bbb``

``RAO-INT``

``16/32/64-bit``
"""
AADD_M64_R64: Code = 4841 # type: ignore
"""
``AADD m64, r64``

``NP o64 0F 38 FC !(11):rrr:bbb``

``RAO-INT``

``64-bit``
"""
AAND_M32_R32: Code = 4842 # type: ignore
"""
``AAND m32, r32``

``66 0F 38 FC !(11):rrr:bbb``

``RAO-INT``

``16/32/64-bit``
"""
AAND_M64_R64: Code = 4843 # type: ignore
"""
``AAND m64, r64``

``66 o64 0F 38 FC !(11):rrr:bbb``

``RAO-INT``

``64-bit``
"""
AXOR_M32_R32: Code = 4844 # type: ignore
"""
``AXOR m32, r32``

``F3 0F 38 FC !(11):rrr:bbb``

``RAO-INT``

``16/32/64-bit``
"""
AXOR_M64_R64: Code = 4845 # type: ignore
"""
``AXOR m64, r64``

``F3 o64 0F 38 FC !(11):rrr:bbb``

``RAO-INT``

``64-bit``
"""
AOR_M32_R32: Code = 4846 # type: ignore
"""
``AOR m32, r32``

``F2 0F 38 FC !(11):rrr:bbb``

``RAO-INT``

``16/32/64-bit``
"""
AOR_M64_R64: Code = 4847 # type: ignore
"""
``AOR m64, r64``

``F2 o64 0F 38 FC !(11):rrr:bbb``

``RAO-INT``

``64-bit``
"""
VEX_VPDPBUUD_XMM_XMM_XMMM128: Code = 4848 # type: ignore
"""
``VPDPBUUD xmm1, xmm2, xmm3/m128``

``VEX.128.0F38.W0 50 /r``

``AVX-VNNI-INT8``

``16/32/64-bit``
"""
VEX_VPDPBUUD_YMM_YMM_YMMM256: Code = 4849 # type: ignore
"""
``VPDPBUUD ymm1, ymm2, ymm3/m256``

``VEX.256.0F38.W0 50 /r``

``AVX-VNNI-INT8``

``16/32/64-bit``
"""
VEX_VPDPBSUD_XMM_XMM_XMMM128: Code = 4850 # type: ignore
"""
``VPDPBSUD xmm1, xmm2, xmm3/m128``

``VEX.128.F3.0F38.W0 50 /r``

``AVX-VNNI-INT8``

``16/32/64-bit``
"""
VEX_VPDPBSUD_YMM_YMM_YMMM256: Code = 4851 # type: ignore
"""
``VPDPBSUD ymm1, ymm2, ymm3/m256``

``VEX.256.F3.0F38.W0 50 /r``

``AVX-VNNI-INT8``

``16/32/64-bit``
"""
VEX_VPDPBSSD_XMM_XMM_XMMM128: Code = 4852 # type: ignore
"""
``VPDPBSSD xmm1, xmm2, xmm3/m128``

``VEX.128.F2.0F38.W0 50 /r``

``AVX-VNNI-INT8``

``16/32/64-bit``
"""
VEX_VPDPBSSD_YMM_YMM_YMMM256: Code = 4853 # type: ignore
"""
``VPDPBSSD ymm1, ymm2, ymm3/m256``

``VEX.256.F2.0F38.W0 50 /r``

``AVX-VNNI-INT8``

``16/32/64-bit``
"""
VEX_VPDPBUUDS_XMM_XMM_XMMM128: Code = 4854 # type: ignore
"""
``VPDPBUUDS xmm1, xmm2, xmm3/m128``

``VEX.128.0F38.W0 51 /r``

``AVX-VNNI-INT8``

``16/32/64-bit``
"""
VEX_VPDPBUUDS_YMM_YMM_YMMM256: Code = 4855 # type: ignore
"""
``VPDPBUUDS ymm1, ymm2, ymm3/m256``

``VEX.256.0F38.W0 51 /r``

``AVX-VNNI-INT8``

``16/32/64-bit``
"""
VEX_VPDPBSUDS_XMM_XMM_XMMM128: Code = 4856 # type: ignore
"""
``VPDPBSUDS xmm1, xmm2, xmm3/m128``

``VEX.128.F3.0F38.W0 51 /r``

``AVX-VNNI-INT8``

``16/32/64-bit``
"""
VEX_VPDPBSUDS_YMM_YMM_YMMM256: Code = 4857 # type: ignore
"""
``VPDPBSUDS ymm1, ymm2, ymm3/m256``

``VEX.256.F3.0F38.W0 51 /r``

``AVX-VNNI-INT8``

``16/32/64-bit``
"""
VEX_VPDPBSSDS_XMM_XMM_XMMM128: Code = 4858 # type: ignore
"""
``VPDPBSSDS xmm1, xmm2, xmm3/m128``

``VEX.128.F2.0F38.W0 51 /r``

``AVX-VNNI-INT8``

``16/32/64-bit``
"""
VEX_VPDPBSSDS_YMM_YMM_YMMM256: Code = 4859 # type: ignore
"""
``VPDPBSSDS ymm1, ymm2, ymm3/m256``

``VEX.256.F2.0F38.W0 51 /r``

``AVX-VNNI-INT8``

``16/32/64-bit``
"""
VEX_TDPFP16PS_TMM_TMM_TMM: Code = 4860 # type: ignore
"""
``TDPFP16PS tmm1, tmm2, tmm3``

``VEX.128.F2.0F38.W0 5C 11:rrr:bbb``

``AMX-FP16``

``64-bit``
"""
VEX_VCVTNEPS2BF16_XMM_XMMM128: Code = 4861 # type: ignore
"""
``VCVTNEPS2BF16 xmm1, xmm2/m128``

``VEX.128.F3.0F38.W0 72 /r``

``AVX-NE-CONVERT``

``16/32/64-bit``
"""
VEX_VCVTNEPS2BF16_XMM_YMMM256: Code = 4862 # type: ignore
"""
``VCVTNEPS2BF16 xmm1, ymm2/m256``

``VEX.256.F3.0F38.W0 72 /r``

``AVX-NE-CONVERT``

``16/32/64-bit``
"""
VEX_VCVTNEOPH2PS_XMM_M128: Code = 4863 # type: ignore
"""
``VCVTNEOPH2PS xmm1, m128``

``VEX.128.0F38.W0 B0 !(11):rrr:bbb``

``AVX-NE-CONVERT``

``16/32/64-bit``
"""
VEX_VCVTNEOPH2PS_YMM_M256: Code = 4864 # type: ignore
"""
``VCVTNEOPH2PS ymm1, m256``

``VEX.256.0F38.W0 B0 !(11):rrr:bbb``

``AVX-NE-CONVERT``

``16/32/64-bit``
"""
VEX_VCVTNEEPH2PS_XMM_M128: Code = 4865 # type: ignore
"""
``VCVTNEEPH2PS xmm1, m128``

``VEX.128.66.0F38.W0 B0 !(11):rrr:bbb``

``AVX-NE-CONVERT``

``16/32/64-bit``
"""
VEX_VCVTNEEPH2PS_YMM_M256: Code = 4866 # type: ignore
"""
``VCVTNEEPH2PS ymm1, m256``

``VEX.256.66.0F38.W0 B0 !(11):rrr:bbb``

``AVX-NE-CONVERT``

``16/32/64-bit``
"""
VEX_VCVTNEEBF162PS_XMM_M128: Code = 4867 # type: ignore
"""
``VCVTNEEBF162PS xmm1, m128``

``VEX.128.F3.0F38.W0 B0 !(11):rrr:bbb``

``AVX-NE-CONVERT``

``16/32/64-bit``
"""
VEX_VCVTNEEBF162PS_YMM_M256: Code = 4868 # type: ignore
"""
``VCVTNEEBF162PS ymm1, m256``

``VEX.256.F3.0F38.W0 B0 !(11):rrr:bbb``

``AVX-NE-CONVERT``

``16/32/64-bit``
"""
VEX_VCVTNEOBF162PS_XMM_M128: Code = 4869 # type: ignore
"""
``VCVTNEOBF162PS xmm1, m128``

``VEX.128.F2.0F38.W0 B0 !(11):rrr:bbb``

``AVX-NE-CONVERT``

``16/32/64-bit``
"""
VEX_VCVTNEOBF162PS_YMM_M256: Code = 4870 # type: ignore
"""
``VCVTNEOBF162PS ymm1, m256``

``VEX.256.F2.0F38.W0 B0 !(11):rrr:bbb``

``AVX-NE-CONVERT``

``16/32/64-bit``
"""
VEX_VBCSTNESH2PS_XMM_M16: Code = 4871 # type: ignore
"""
``VBCSTNESH2PS xmm1, m16``

``VEX.128.66.0F38.W0 B1 !(11):rrr:bbb``

``AVX-NE-CONVERT``

``16/32/64-bit``
"""
VEX_VBCSTNESH2PS_YMM_M16: Code = 4872 # type: ignore
"""
``VBCSTNESH2PS ymm1, m16``

``VEX.256.66.0F38.W0 B1 !(11):rrr:bbb``

``AVX-NE-CONVERT``

``16/32/64-bit``
"""
VEX_VBCSTNEBF162PS_XMM_M16: Code = 4873 # type: ignore
"""
``VBCSTNEBF162PS xmm1, m16``

``VEX.128.F3.0F38.W0 B1 !(11):rrr:bbb``

``AVX-NE-CONVERT``

``16/32/64-bit``
"""
VEX_VBCSTNEBF162PS_YMM_M16: Code = 4874 # type: ignore
"""
``VBCSTNEBF162PS ymm1, m16``

``VEX.256.F3.0F38.W0 B1 !(11):rrr:bbb``

``AVX-NE-CONVERT``

``16/32/64-bit``
"""
VEX_VPMADD52LUQ_XMM_XMM_XMMM128: Code = 4875 # type: ignore
"""
``VPMADD52LUQ xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 B4 /r``

``AVX-IFMA``

``16/32/64-bit``
"""
VEX_VPMADD52LUQ_YMM_YMM_YMMM256: Code = 4876 # type: ignore
"""
``VPMADD52LUQ ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 B4 /r``

``AVX-IFMA``

``16/32/64-bit``
"""
VEX_VPMADD52HUQ_XMM_XMM_XMMM128: Code = 4877 # type: ignore
"""
``VPMADD52HUQ xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W1 B5 /r``

``AVX-IFMA``

``16/32/64-bit``
"""
VEX_VPMADD52HUQ_YMM_YMM_YMMM256: Code = 4878 # type: ignore
"""
``VPMADD52HUQ ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W1 B5 /r``

``AVX-IFMA``

``16/32/64-bit``
"""
VEX_CMPOXADD_M32_R32_R32: Code = 4879 # type: ignore
"""
``CMPOXADD m32, r32, r32``

``VEX.128.66.0F38.W0 E0 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPOXADD_M64_R64_R64: Code = 4880 # type: ignore
"""
``CMPOXADD m64, r64, r64``

``VEX.128.66.0F38.W1 E0 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPNOXADD_M32_R32_R32: Code = 4881 # type: ignore
"""
``CMPNOXADD m32, r32, r32``

``VEX.128.66.0F38.W0 E1 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPNOXADD_M64_R64_R64: Code = 4882 # type: ignore
"""
``CMPNOXADD m64, r64, r64``

``VEX.128.66.0F38.W1 E1 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPBXADD_M32_R32_R32: Code = 4883 # type: ignore
"""
``CMPBXADD m32, r32, r32``

``VEX.128.66.0F38.W0 E2 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPBXADD_M64_R64_R64: Code = 4884 # type: ignore
"""
``CMPBXADD m64, r64, r64``

``VEX.128.66.0F38.W1 E2 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPNBXADD_M32_R32_R32: Code = 4885 # type: ignore
"""
``CMPNBXADD m32, r32, r32``

``VEX.128.66.0F38.W0 E3 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPNBXADD_M64_R64_R64: Code = 4886 # type: ignore
"""
``CMPNBXADD m64, r64, r64``

``VEX.128.66.0F38.W1 E3 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPZXADD_M32_R32_R32: Code = 4887 # type: ignore
"""
``CMPZXADD m32, r32, r32``

``VEX.128.66.0F38.W0 E4 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPZXADD_M64_R64_R64: Code = 4888 # type: ignore
"""
``CMPZXADD m64, r64, r64``

``VEX.128.66.0F38.W1 E4 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPNZXADD_M32_R32_R32: Code = 4889 # type: ignore
"""
``CMPNZXADD m32, r32, r32``

``VEX.128.66.0F38.W0 E5 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPNZXADD_M64_R64_R64: Code = 4890 # type: ignore
"""
``CMPNZXADD m64, r64, r64``

``VEX.128.66.0F38.W1 E5 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPBEXADD_M32_R32_R32: Code = 4891 # type: ignore
"""
``CMPBEXADD m32, r32, r32``

``VEX.128.66.0F38.W0 E6 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPBEXADD_M64_R64_R64: Code = 4892 # type: ignore
"""
``CMPBEXADD m64, r64, r64``

``VEX.128.66.0F38.W1 E6 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPNBEXADD_M32_R32_R32: Code = 4893 # type: ignore
"""
``CMPNBEXADD m32, r32, r32``

``VEX.128.66.0F38.W0 E7 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPNBEXADD_M64_R64_R64: Code = 4894 # type: ignore
"""
``CMPNBEXADD m64, r64, r64``

``VEX.128.66.0F38.W1 E7 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPSXADD_M32_R32_R32: Code = 4895 # type: ignore
"""
``CMPSXADD m32, r32, r32``

``VEX.128.66.0F38.W0 E8 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPSXADD_M64_R64_R64: Code = 4896 # type: ignore
"""
``CMPSXADD m64, r64, r64``

``VEX.128.66.0F38.W1 E8 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPNSXADD_M32_R32_R32: Code = 4897 # type: ignore
"""
``CMPNSXADD m32, r32, r32``

``VEX.128.66.0F38.W0 E9 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPNSXADD_M64_R64_R64: Code = 4898 # type: ignore
"""
``CMPNSXADD m64, r64, r64``

``VEX.128.66.0F38.W1 E9 !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPPXADD_M32_R32_R32: Code = 4899 # type: ignore
"""
``CMPPXADD m32, r32, r32``

``VEX.128.66.0F38.W0 EA !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPPXADD_M64_R64_R64: Code = 4900 # type: ignore
"""
``CMPPXADD m64, r64, r64``

``VEX.128.66.0F38.W1 EA !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPNPXADD_M32_R32_R32: Code = 4901 # type: ignore
"""
``CMPNPXADD m32, r32, r32``

``VEX.128.66.0F38.W0 EB !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPNPXADD_M64_R64_R64: Code = 4902 # type: ignore
"""
``CMPNPXADD m64, r64, r64``

``VEX.128.66.0F38.W1 EB !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPLXADD_M32_R32_R32: Code = 4903 # type: ignore
"""
``CMPLXADD m32, r32, r32``

``VEX.128.66.0F38.W0 EC !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPLXADD_M64_R64_R64: Code = 4904 # type: ignore
"""
``CMPLXADD m64, r64, r64``

``VEX.128.66.0F38.W1 EC !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPNLXADD_M32_R32_R32: Code = 4905 # type: ignore
"""
``CMPNLXADD m32, r32, r32``

``VEX.128.66.0F38.W0 ED !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPNLXADD_M64_R64_R64: Code = 4906 # type: ignore
"""
``CMPNLXADD m64, r64, r64``

``VEX.128.66.0F38.W1 ED !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPLEXADD_M32_R32_R32: Code = 4907 # type: ignore
"""
``CMPLEXADD m32, r32, r32``

``VEX.128.66.0F38.W0 EE !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPLEXADD_M64_R64_R64: Code = 4908 # type: ignore
"""
``CMPLEXADD m64, r64, r64``

``VEX.128.66.0F38.W1 EE !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPNLEXADD_M32_R32_R32: Code = 4909 # type: ignore
"""
``CMPNLEXADD m32, r32, r32``

``VEX.128.66.0F38.W0 EF !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_CMPNLEXADD_M64_R64_R64: Code = 4910 # type: ignore
"""
``CMPNLEXADD m64, r64, r64``

``VEX.128.66.0F38.W1 EF !(11):rrr:bbb``

``CMPCCXADD``

``64-bit``
"""
VEX_TCMMRLFP16PS_TMM_TMM_TMM: Code = 4911 # type: ignore
"""
``TCMMRLFP16PS tmm1, tmm2, tmm3``

``VEX.128.0F38.W0 6C 11:rrr:bbb``

``AMX-COMPLEX``

``64-bit``
"""
VEX_TCMMIMFP16PS_TMM_TMM_TMM: Code = 4912 # type: ignore
"""
``TCMMIMFP16PS tmm1, tmm2, tmm3``

``VEX.128.66.0F38.W0 6C 11:rrr:bbb``

``AMX-COMPLEX``

``64-bit``
"""
PBNDKB: Code = 4913 # type: ignore
"""
``PBNDKB``

``NP 0F 01 C7``

``TSE``

``64-bit``
"""
VEX_VSHA512RNDS2_YMM_YMM_XMM: Code = 4914 # type: ignore
"""
``VSHA512RNDS2 ymm1, ymm2, xmm3``

``VEX.256.F2.0F38.W0 CB 11:rrr:bbb``

``AVX and SHA512``

``16/32/64-bit``
"""
VEX_VSHA512MSG1_YMM_XMM: Code = 4915 # type: ignore
"""
``VSHA512MSG1 ymm1, xmm2``

``VEX.256.F2.0F38.W0 CC 11:rrr:bbb``

``AVX and SHA512``

``16/32/64-bit``
"""
VEX_VSHA512MSG2_YMM_YMM: Code = 4916 # type: ignore
"""
``VSHA512MSG2 ymm1, ymm2``

``VEX.256.F2.0F38.W0 CD 11:rrr:bbb``

``AVX and SHA512``

``16/32/64-bit``
"""
VEX_VPDPWUUD_XMM_XMM_XMMM128: Code = 4917 # type: ignore
"""
``VPDPWUUD xmm1, xmm2, xmm3/m128``

``VEX.128.0F38.W0 D2 /r``

``AVX-VNNI-INT16``

``16/32/64-bit``
"""
VEX_VPDPWUUD_YMM_YMM_YMMM256: Code = 4918 # type: ignore
"""
``VPDPWUUD ymm1, ymm2, ymm3/m256``

``VEX.256.0F38.W0 D2 /r``

``AVX-VNNI-INT16``

``16/32/64-bit``
"""
VEX_VPDPWUSD_XMM_XMM_XMMM128: Code = 4919 # type: ignore
"""
``VPDPWUSD xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 D2 /r``

``AVX-VNNI-INT16``

``16/32/64-bit``
"""
VEX_VPDPWUSD_YMM_YMM_YMMM256: Code = 4920 # type: ignore
"""
``VPDPWUSD ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 D2 /r``

``AVX-VNNI-INT16``

``16/32/64-bit``
"""
VEX_VPDPWSUD_XMM_XMM_XMMM128: Code = 4921 # type: ignore
"""
``VPDPWSUD xmm1, xmm2, xmm3/m128``

``VEX.128.F3.0F38.W0 D2 /r``

``AVX-VNNI-INT16``

``16/32/64-bit``
"""
VEX_VPDPWSUD_YMM_YMM_YMMM256: Code = 4922 # type: ignore
"""
``VPDPWSUD ymm1, ymm2, ymm3/m256``

``VEX.256.F3.0F38.W0 D2 /r``

``AVX-VNNI-INT16``

``16/32/64-bit``
"""
VEX_VPDPWUUDS_XMM_XMM_XMMM128: Code = 4923 # type: ignore
"""
``VPDPWUUDS xmm1, xmm2, xmm3/m128``

``VEX.128.0F38.W0 D3 /r``

``AVX-VNNI-INT16``

``16/32/64-bit``
"""
VEX_VPDPWUUDS_YMM_YMM_YMMM256: Code = 4924 # type: ignore
"""
``VPDPWUUDS ymm1, ymm2, ymm3/m256``

``VEX.256.0F38.W0 D3 /r``

``AVX-VNNI-INT16``

``16/32/64-bit``
"""
VEX_VPDPWUSDS_XMM_XMM_XMMM128: Code = 4925 # type: ignore
"""
``VPDPWUSDS xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 D3 /r``

``AVX-VNNI-INT16``

``16/32/64-bit``
"""
VEX_VPDPWUSDS_YMM_YMM_YMMM256: Code = 4926 # type: ignore
"""
``VPDPWUSDS ymm1, ymm2, ymm3/m256``

``VEX.256.66.0F38.W0 D3 /r``

``AVX-VNNI-INT16``

``16/32/64-bit``
"""
VEX_VPDPWSUDS_XMM_XMM_XMMM128: Code = 4927 # type: ignore
"""
``VPDPWSUDS xmm1, xmm2, xmm3/m128``

``VEX.128.F3.0F38.W0 D3 /r``

``AVX-VNNI-INT16``

``16/32/64-bit``
"""
VEX_VPDPWSUDS_YMM_YMM_YMMM256: Code = 4928 # type: ignore
"""
``VPDPWSUDS ymm1, ymm2, ymm3/m256``

``VEX.256.F3.0F38.W0 D3 /r``

``AVX-VNNI-INT16``

``16/32/64-bit``
"""
VEX_VSM3MSG1_XMM_XMM_XMMM128: Code = 4929 # type: ignore
"""
``VSM3MSG1 xmm1, xmm2, xmm3/m128``

``VEX.128.0F38.W0 DA /r``

``AVX and SM3``

``16/32/64-bit``
"""
VEX_VSM3MSG2_XMM_XMM_XMMM128: Code = 4930 # type: ignore
"""
``VSM3MSG2 xmm1, xmm2, xmm3/m128``

``VEX.128.66.0F38.W0 DA /r``

``AVX and SM3``

``16/32/64-bit``
"""
VEX_VSM4KEY4_XMM_XMM_XMMM128: Code = 4931 # type: ignore
"""
``VSM4KEY4 xmm1, xmm2, xmm3/m128``

``VEX.128.F3.0F38.W0 DA /r``

``AVX and SM4``

``16/32/64-bit``
"""
VEX_VSM4KEY4_YMM_YMM_YMMM256: Code = 4932 # type: ignore
"""
``VSM4KEY4 ymm1, ymm2, ymm3/m256``

``VEX.256.F3.0F38.W0 DA /r``

``AVX and SM4``

``16/32/64-bit``
"""
VEX_VSM4RNDS4_XMM_XMM_XMMM128: Code = 4933 # type: ignore
"""
``VSM4RNDS4 xmm1, xmm2, xmm3/m128``

``VEX.128.F2.0F38.W0 DA /r``

``AVX and SM4``

``16/32/64-bit``
"""
VEX_VSM4RNDS4_YMM_YMM_YMMM256: Code = 4934 # type: ignore
"""
``VSM4RNDS4 ymm1, ymm2, ymm3/m256``

``VEX.256.F2.0F38.W0 DA /r``

``AVX and SM4``

``16/32/64-bit``
"""
VEX_VSM3RNDS2_XMM_XMM_XMMM128_IMM8: Code = 4935 # type: ignore
"""
``VSM3RNDS2 xmm1, xmm2, xmm3/m128, imm8``

``VEX.128.66.0F3A.W0 DE /r ib``

``AVX and SM3``

``16/32/64-bit``
"""
