# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221109

from .model_metrics import ModelMetrics
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PretrainedKeyValueExtractionModelDetails(ModelMetrics):
    """
    Possible pre-trained key value extraction model information..
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PretrainedKeyValueExtractionModelDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.ai_document.models.PretrainedKeyValueExtractionModelDetails.model_type` attribute
        of this class is ``PRE_TRAINED_KEY_VALUE_EXTRACTION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param model_type:
            The value to assign to the model_type property of this PretrainedKeyValueExtractionModelDetails.
            Allowed values for this property are: "KEY_VALUE_EXTRACTION", "DOCUMENT_CLASSIFICATION", "PRE_TRAINED_TEXT_EXTRACTION", "PRE_TRAINED_TABLE_EXTRACTION", "PRE_TRAINED_KEY_VALUE_EXTRACTION", "PRE_TRAINED_DOCUMENT_CLASSIFICATION", "PRE_TRAINED_DOCUMENT_ELEMENTS_EXTRACTION"
        :type model_type: str

        :param dataset_summary:
            The value to assign to the dataset_summary property of this PretrainedKeyValueExtractionModelDetails.
        :type dataset_summary: oci.ai_document.models.DatasetSummary

        """
        self.swagger_types = {
            'model_type': 'str',
            'dataset_summary': 'DatasetSummary'
        }
        self.attribute_map = {
            'model_type': 'modelType',
            'dataset_summary': 'datasetSummary'
        }
        self._model_type = None
        self._dataset_summary = None
        self._model_type = 'PRE_TRAINED_KEY_VALUE_EXTRACTION'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
