# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Landmark(object):
    """
    The landmark on the face.
    """

    #: A constant which can be used with the type property of a Landmark.
    #: This constant has a value of "LEFT_EYE"
    TYPE_LEFT_EYE = "LEFT_EYE"

    #: A constant which can be used with the type property of a Landmark.
    #: This constant has a value of "RIGHT_EYE"
    TYPE_RIGHT_EYE = "RIGHT_EYE"

    #: A constant which can be used with the type property of a Landmark.
    #: This constant has a value of "NOSE_TIP"
    TYPE_NOSE_TIP = "NOSE_TIP"

    #: A constant which can be used with the type property of a Landmark.
    #: This constant has a value of "LEFT_EDGE_OF_MOUTH"
    TYPE_LEFT_EDGE_OF_MOUTH = "LEFT_EDGE_OF_MOUTH"

    #: A constant which can be used with the type property of a Landmark.
    #: This constant has a value of "RIGHT_EDGE_OF_MOUTH"
    TYPE_RIGHT_EDGE_OF_MOUTH = "RIGHT_EDGE_OF_MOUTH"

    def __init__(self, **kwargs):
        """
        Initializes a new Landmark object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this Landmark.
            Allowed values for this property are: "LEFT_EYE", "RIGHT_EYE", "NOSE_TIP", "LEFT_EDGE_OF_MOUTH", "RIGHT_EDGE_OF_MOUTH", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param x:
            The value to assign to the x property of this Landmark.
        :type x: float

        :param y:
            The value to assign to the y property of this Landmark.
        :type y: float

        """
        self.swagger_types = {
            'type': 'str',
            'x': 'float',
            'y': 'float'
        }
        self.attribute_map = {
            'type': 'type',
            'x': 'x',
            'y': 'y'
        }
        self._type = None
        self._x = None
        self._y = None

    @property
    def type(self):
        """
        **[Required]** Gets the type of this Landmark.
        The face landmark type

        Allowed values for this property are: "LEFT_EYE", "RIGHT_EYE", "NOSE_TIP", "LEFT_EDGE_OF_MOUTH", "RIGHT_EDGE_OF_MOUTH", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this Landmark.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Landmark.
        The face landmark type


        :param type: The type of this Landmark.
        :type: str
        """
        allowed_values = ["LEFT_EYE", "RIGHT_EYE", "NOSE_TIP", "LEFT_EDGE_OF_MOUTH", "RIGHT_EDGE_OF_MOUTH"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def x(self):
        """
        **[Required]** Gets the x of this Landmark.
        The X-axis normalized coordinate.


        :return: The x of this Landmark.
        :rtype: float
        """
        return self._x

    @x.setter
    def x(self, x):
        """
        Sets the x of this Landmark.
        The X-axis normalized coordinate.


        :param x: The x of this Landmark.
        :type: float
        """
        self._x = x

    @property
    def y(self):
        """
        **[Required]** Gets the y of this Landmark.
        The Y-axis normalized coordinate.


        :return: The y of this Landmark.
        :rtype: float
        """
        return self._y

    @y.setter
    def y(self, y):
        """
        Sets the y of this Landmark.
        The Y-axis normalized coordinate.


        :param y: The y of this Landmark.
        :type: float
        """
        self._y = y

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
