# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DefaultError(object):
    """
    Error Information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DefaultError object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param code:
            The value to assign to the code property of this DefaultError.
        :type code: str

        :param message:
            The value to assign to the message property of this DefaultError.
        :type message: str

        """
        self.swagger_types = {
            'code': 'str',
            'message': 'str'
        }
        self.attribute_map = {
            'code': 'code',
            'message': 'message'
        }
        self._code = None
        self._message = None

    @property
    def code(self):
        """
        **[Required]** Gets the code of this DefaultError.
        A short error code that defines the error, meant for programmatic parsing.


        :return: The code of this DefaultError.
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """
        Sets the code of this DefaultError.
        A short error code that defines the error, meant for programmatic parsing.


        :param code: The code of this DefaultError.
        :type: str
        """
        self._code = code

    @property
    def message(self):
        """
        **[Required]** Gets the message of this DefaultError.
        A human-readable error string.


        :return: The message of this DefaultError.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this DefaultError.
        A human-readable error string.


        :param message: The message of this DefaultError.
        :type: str
        """
        self._message = message

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
