# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpstConfiguration(object):
    """
    Information about the UPST configuration.
    """

    #: A constant which can be used with the lifecycle_state property of a UpstConfiguration.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a UpstConfiguration.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a UpstConfiguration.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a UpstConfiguration.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a UpstConfiguration.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a UpstConfiguration.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new UpstConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vault_id:
            The value to assign to the vault_id property of this UpstConfiguration.
        :type vault_id: str

        :param master_encryption_key_id:
            The value to assign to the master_encryption_key_id property of this UpstConfiguration.
        :type master_encryption_key_id: str

        :param secret_id:
            The value to assign to the secret_id property of this UpstConfiguration.
        :type secret_id: str

        :param time_token_exchange_keytab_last_refreshed:
            The value to assign to the time_token_exchange_keytab_last_refreshed property of this UpstConfiguration.
        :type time_token_exchange_keytab_last_refreshed: datetime

        :param token_exchange_principal_name:
            The value to assign to the token_exchange_principal_name property of this UpstConfiguration.
        :type token_exchange_principal_name: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this UpstConfiguration.
            Allowed values for this property are: "CREATING", "ACTIVE", "DELETING", "INACTIVE", "UPDATING", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this UpstConfiguration.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this UpstConfiguration.
        :type time_updated: datetime

        :param keytab_content:
            The value to assign to the keytab_content property of this UpstConfiguration.
        :type keytab_content: str

        """
        self.swagger_types = {
            'vault_id': 'str',
            'master_encryption_key_id': 'str',
            'secret_id': 'str',
            'time_token_exchange_keytab_last_refreshed': 'datetime',
            'token_exchange_principal_name': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'keytab_content': 'str'
        }
        self.attribute_map = {
            'vault_id': 'vaultId',
            'master_encryption_key_id': 'masterEncryptionKeyId',
            'secret_id': 'secretId',
            'time_token_exchange_keytab_last_refreshed': 'timeTokenExchangeKeytabLastRefreshed',
            'token_exchange_principal_name': 'tokenExchangePrincipalName',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'keytab_content': 'keytabContent'
        }
        self._vault_id = None
        self._master_encryption_key_id = None
        self._secret_id = None
        self._time_token_exchange_keytab_last_refreshed = None
        self._token_exchange_principal_name = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None
        self._keytab_content = None

    @property
    def vault_id(self):
        """
        **[Required]** Gets the vault_id of this UpstConfiguration.
        The instance OCID of the node, which is the resource from which the node backup was acquired.


        :return: The vault_id of this UpstConfiguration.
        :rtype: str
        """
        return self._vault_id

    @vault_id.setter
    def vault_id(self, vault_id):
        """
        Sets the vault_id of this UpstConfiguration.
        The instance OCID of the node, which is the resource from which the node backup was acquired.


        :param vault_id: The vault_id of this UpstConfiguration.
        :type: str
        """
        self._vault_id = vault_id

    @property
    def master_encryption_key_id(self):
        """
        **[Required]** Gets the master_encryption_key_id of this UpstConfiguration.
        Master Encryption key used for encrypting token exchange keytab.


        :return: The master_encryption_key_id of this UpstConfiguration.
        :rtype: str
        """
        return self._master_encryption_key_id

    @master_encryption_key_id.setter
    def master_encryption_key_id(self, master_encryption_key_id):
        """
        Sets the master_encryption_key_id of this UpstConfiguration.
        Master Encryption key used for encrypting token exchange keytab.


        :param master_encryption_key_id: The master_encryption_key_id of this UpstConfiguration.
        :type: str
        """
        self._master_encryption_key_id = master_encryption_key_id

    @property
    def secret_id(self):
        """
        **[Required]** Gets the secret_id of this UpstConfiguration.
        Secret ID for token exchange keytab


        :return: The secret_id of this UpstConfiguration.
        :rtype: str
        """
        return self._secret_id

    @secret_id.setter
    def secret_id(self, secret_id):
        """
        Sets the secret_id of this UpstConfiguration.
        Secret ID for token exchange keytab


        :param secret_id: The secret_id of this UpstConfiguration.
        :type: str
        """
        self._secret_id = secret_id

    @property
    def time_token_exchange_keytab_last_refreshed(self):
        """
        **[Required]** Gets the time_token_exchange_keytab_last_refreshed of this UpstConfiguration.
        Time when the keytab for token exchange principal is last refreshed, shown as an RFC 3339 formatted datetime string.


        :return: The time_token_exchange_keytab_last_refreshed of this UpstConfiguration.
        :rtype: datetime
        """
        return self._time_token_exchange_keytab_last_refreshed

    @time_token_exchange_keytab_last_refreshed.setter
    def time_token_exchange_keytab_last_refreshed(self, time_token_exchange_keytab_last_refreshed):
        """
        Sets the time_token_exchange_keytab_last_refreshed of this UpstConfiguration.
        Time when the keytab for token exchange principal is last refreshed, shown as an RFC 3339 formatted datetime string.


        :param time_token_exchange_keytab_last_refreshed: The time_token_exchange_keytab_last_refreshed of this UpstConfiguration.
        :type: datetime
        """
        self._time_token_exchange_keytab_last_refreshed = time_token_exchange_keytab_last_refreshed

    @property
    def token_exchange_principal_name(self):
        """
        Gets the token_exchange_principal_name of this UpstConfiguration.
        Token exchange kerberos Principal name in cluster


        :return: The token_exchange_principal_name of this UpstConfiguration.
        :rtype: str
        """
        return self._token_exchange_principal_name

    @token_exchange_principal_name.setter
    def token_exchange_principal_name(self, token_exchange_principal_name):
        """
        Sets the token_exchange_principal_name of this UpstConfiguration.
        Token exchange kerberos Principal name in cluster


        :param token_exchange_principal_name: The token_exchange_principal_name of this UpstConfiguration.
        :type: str
        """
        self._token_exchange_principal_name = token_exchange_principal_name

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this UpstConfiguration.
        Lifecycle state of the UPST config

        Allowed values for this property are: "CREATING", "ACTIVE", "DELETING", "INACTIVE", "UPDATING", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this UpstConfiguration.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this UpstConfiguration.
        Lifecycle state of the UPST config


        :param lifecycle_state: The lifecycle_state of this UpstConfiguration.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "DELETING", "INACTIVE", "UPDATING", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this UpstConfiguration.
        Time when this UPST config was created, shown as an RFC 3339 formatted datetime string.


        :return: The time_created of this UpstConfiguration.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this UpstConfiguration.
        Time when this UPST config was created, shown as an RFC 3339 formatted datetime string.


        :param time_created: The time_created of this UpstConfiguration.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this UpstConfiguration.
        Time when this UPST config was updated, shown as an RFC 3339 formatted datetime string.


        :return: The time_updated of this UpstConfiguration.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this UpstConfiguration.
        Time when this UPST config was updated, shown as an RFC 3339 formatted datetime string.


        :param time_updated: The time_updated of this UpstConfiguration.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def keytab_content(self):
        """
        **[Required]** Gets the keytab_content of this UpstConfiguration.
        The kerberos keytab content used for creating identity propagation trust config, in base64 format


        :return: The keytab_content of this UpstConfiguration.
        :rtype: str
        """
        return self._keytab_content

    @keytab_content.setter
    def keytab_content(self, keytab_content):
        """
        Sets the keytab_content of this UpstConfiguration.
        The kerberos keytab content used for creating identity propagation trust config, in base64 format


        :param keytab_content: The keytab_content of this UpstConfiguration.
        :type: str
        """
        self._keytab_content = keytab_content

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
