# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OccmDemandSignalResourcePropertiesSummary(object):
    """
    A summary model for the Occm demand signal resource properties.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OccmDemandSignalResourcePropertiesSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param property_name:
            The value to assign to the property_name property of this OccmDemandSignalResourcePropertiesSummary.
        :type property_name: str

        :param property_value:
            The value to assign to the property_value property of this OccmDemandSignalResourcePropertiesSummary.
        :type property_value: str

        :param property_min_value:
            The value to assign to the property_min_value property of this OccmDemandSignalResourcePropertiesSummary.
        :type property_min_value: int

        :param property_max_value:
            The value to assign to the property_max_value property of this OccmDemandSignalResourcePropertiesSummary.
        :type property_max_value: int

        :param property_options:
            The value to assign to the property_options property of this OccmDemandSignalResourcePropertiesSummary.
        :type property_options: list[oci.capacity_management.models.OccmDemandSignalResourcePropertyOptionSummary]

        :param property_unit:
            The value to assign to the property_unit property of this OccmDemandSignalResourcePropertiesSummary.
        :type property_unit: str

        :param is_editable:
            The value to assign to the is_editable property of this OccmDemandSignalResourcePropertiesSummary.
        :type is_editable: bool

        """
        self.swagger_types = {
            'property_name': 'str',
            'property_value': 'str',
            'property_min_value': 'int',
            'property_max_value': 'int',
            'property_options': 'list[OccmDemandSignalResourcePropertyOptionSummary]',
            'property_unit': 'str',
            'is_editable': 'bool'
        }
        self.attribute_map = {
            'property_name': 'propertyName',
            'property_value': 'propertyValue',
            'property_min_value': 'propertyMinValue',
            'property_max_value': 'propertyMaxValue',
            'property_options': 'propertyOptions',
            'property_unit': 'propertyUnit',
            'is_editable': 'isEditable'
        }
        self._property_name = None
        self._property_value = None
        self._property_min_value = None
        self._property_max_value = None
        self._property_options = None
        self._property_unit = None
        self._is_editable = None

    @property
    def property_name(self):
        """
        **[Required]** Gets the property_name of this OccmDemandSignalResourcePropertiesSummary.
        The name of demand signal resource's property.


        :return: The property_name of this OccmDemandSignalResourcePropertiesSummary.
        :rtype: str
        """
        return self._property_name

    @property_name.setter
    def property_name(self, property_name):
        """
        Sets the property_name of this OccmDemandSignalResourcePropertiesSummary.
        The name of demand signal resource's property.


        :param property_name: The property_name of this OccmDemandSignalResourcePropertiesSummary.
        :type: str
        """
        self._property_name = property_name

    @property
    def property_value(self):
        """
        **[Required]** Gets the property_value of this OccmDemandSignalResourcePropertiesSummary.
        Default value of demand signal resource's property.


        :return: The property_value of this OccmDemandSignalResourcePropertiesSummary.
        :rtype: str
        """
        return self._property_value

    @property_value.setter
    def property_value(self, property_value):
        """
        Sets the property_value of this OccmDemandSignalResourcePropertiesSummary.
        Default value of demand signal resource's property.


        :param property_value: The property_value of this OccmDemandSignalResourcePropertiesSummary.
        :type: str
        """
        self._property_value = property_value

    @property
    def property_min_value(self):
        """
        Gets the property_min_value of this OccmDemandSignalResourcePropertiesSummary.
        The minimum value of demand signal resource's property. This is an optional parameter.


        :return: The property_min_value of this OccmDemandSignalResourcePropertiesSummary.
        :rtype: int
        """
        return self._property_min_value

    @property_min_value.setter
    def property_min_value(self, property_min_value):
        """
        Sets the property_min_value of this OccmDemandSignalResourcePropertiesSummary.
        The minimum value of demand signal resource's property. This is an optional parameter.


        :param property_min_value: The property_min_value of this OccmDemandSignalResourcePropertiesSummary.
        :type: int
        """
        self._property_min_value = property_min_value

    @property
    def property_max_value(self):
        """
        Gets the property_max_value of this OccmDemandSignalResourcePropertiesSummary.
        The maximum value of demand signal resource's property. This is an optional parameter.


        :return: The property_max_value of this OccmDemandSignalResourcePropertiesSummary.
        :rtype: int
        """
        return self._property_max_value

    @property_max_value.setter
    def property_max_value(self, property_max_value):
        """
        Sets the property_max_value of this OccmDemandSignalResourcePropertiesSummary.
        The maximum value of demand signal resource's property. This is an optional parameter.


        :param property_max_value: The property_max_value of this OccmDemandSignalResourcePropertiesSummary.
        :type: int
        """
        self._property_max_value = property_max_value

    @property
    def property_options(self):
        """
        Gets the property_options of this OccmDemandSignalResourcePropertiesSummary.
        Predefined options for demand signal resource's property. This is an optional parameter.


        :return: The property_options of this OccmDemandSignalResourcePropertiesSummary.
        :rtype: list[oci.capacity_management.models.OccmDemandSignalResourcePropertyOptionSummary]
        """
        return self._property_options

    @property_options.setter
    def property_options(self, property_options):
        """
        Sets the property_options of this OccmDemandSignalResourcePropertiesSummary.
        Predefined options for demand signal resource's property. This is an optional parameter.


        :param property_options: The property_options of this OccmDemandSignalResourcePropertiesSummary.
        :type: list[oci.capacity_management.models.OccmDemandSignalResourcePropertyOptionSummary]
        """
        self._property_options = property_options

    @property
    def property_unit(self):
        """
        Gets the property_unit of this OccmDemandSignalResourcePropertiesSummary.
        Unit for demand signal resource's property.


        :return: The property_unit of this OccmDemandSignalResourcePropertiesSummary.
        :rtype: str
        """
        return self._property_unit

    @property_unit.setter
    def property_unit(self, property_unit):
        """
        Sets the property_unit of this OccmDemandSignalResourcePropertiesSummary.
        Unit for demand signal resource's property.


        :param property_unit: The property_unit of this OccmDemandSignalResourcePropertiesSummary.
        :type: str
        """
        self._property_unit = property_unit

    @property
    def is_editable(self):
        """
        **[Required]** Gets the is_editable of this OccmDemandSignalResourcePropertiesSummary.
        This will indicate if demand signal resource's property is editable.


        :return: The is_editable of this OccmDemandSignalResourcePropertiesSummary.
        :rtype: bool
        """
        return self._is_editable

    @is_editable.setter
    def is_editable(self, is_editable):
        """
        Sets the is_editable of this OccmDemandSignalResourcePropertiesSummary.
        This will indicate if demand signal resource's property is editable.


        :param is_editable: The is_editable of this OccmDemandSignalResourcePropertiesSummary.
        :type: bool
        """
        self._is_editable = is_editable

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
