# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComputeHostConfigurationData(object):
    """
    Compute Host Configuration Data
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ComputeHostConfigurationData object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_last_apply:
            The value to assign to the time_last_apply property of this ComputeHostConfigurationData.
        :type time_last_apply: datetime

        :param check_details:
            The value to assign to the check_details property of this ComputeHostConfigurationData.
        :type check_details: oci.core.models.ComputeHostConfigurationCheckDetails

        """
        self.swagger_types = {
            'time_last_apply': 'datetime',
            'check_details': 'ComputeHostConfigurationCheckDetails'
        }
        self.attribute_map = {
            'time_last_apply': 'timeLastApply',
            'check_details': 'checkDetails'
        }
        self._time_last_apply = None
        self._check_details = None

    @property
    def time_last_apply(self):
        """
        Gets the time_last_apply of this ComputeHostConfigurationData.
        The time that was last applied.


        :return: The time_last_apply of this ComputeHostConfigurationData.
        :rtype: datetime
        """
        return self._time_last_apply

    @time_last_apply.setter
    def time_last_apply(self, time_last_apply):
        """
        Sets the time_last_apply of this ComputeHostConfigurationData.
        The time that was last applied.


        :param time_last_apply: The time_last_apply of this ComputeHostConfigurationData.
        :type: datetime
        """
        self._time_last_apply = time_last_apply

    @property
    def check_details(self):
        """
        Gets the check_details of this ComputeHostConfigurationData.

        :return: The check_details of this ComputeHostConfigurationData.
        :rtype: oci.core.models.ComputeHostConfigurationCheckDetails
        """
        return self._check_details

    @check_details.setter
    def check_details(self, check_details):
        """
        Sets the check_details of this ComputeHostConfigurationData.

        :param check_details: The check_details of this ComputeHostConfigurationData.
        :type: oci.core.models.ComputeHostConfigurationCheckDetails
        """
        self._check_details = check_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
