# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostGroupConfiguration(object):
    """
    Host group configuration
    """

    #: A constant which can be used with the recycle_level property of a HostGroupConfiguration.
    #: This constant has a value of "SKIP_RECYCLE"
    RECYCLE_LEVEL_SKIP_RECYCLE = "SKIP_RECYCLE"

    #: A constant which can be used with the recycle_level property of a HostGroupConfiguration.
    #: This constant has a value of "FULL_RECYCLE"
    RECYCLE_LEVEL_FULL_RECYCLE = "FULL_RECYCLE"

    def __init__(self, **kwargs):
        """
        Initializes a new HostGroupConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target:
            The value to assign to the target property of this HostGroupConfiguration.
        :type target: str

        :param firmware_bundle_id:
            The value to assign to the firmware_bundle_id property of this HostGroupConfiguration.
        :type firmware_bundle_id: str

        :param recycle_level:
            The value to assign to the recycle_level property of this HostGroupConfiguration.
            Allowed values for this property are: "SKIP_RECYCLE", "FULL_RECYCLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type recycle_level: str

        """
        self.swagger_types = {
            'target': 'str',
            'firmware_bundle_id': 'str',
            'recycle_level': 'str'
        }
        self.attribute_map = {
            'target': 'target',
            'firmware_bundle_id': 'firmwareBundleId',
            'recycle_level': 'recycleLevel'
        }
        self._target = None
        self._firmware_bundle_id = None
        self._recycle_level = None

    @property
    def target(self):
        """
        Gets the target of this HostGroupConfiguration.
        Either the platform name or compute shape that the configuration is targeting


        :return: The target of this HostGroupConfiguration.
        :rtype: str
        """
        return self._target

    @target.setter
    def target(self, target):
        """
        Sets the target of this HostGroupConfiguration.
        Either the platform name or compute shape that the configuration is targeting


        :param target: The target of this HostGroupConfiguration.
        :type: str
        """
        self._target = target

    @property
    def firmware_bundle_id(self):
        """
        Gets the firmware_bundle_id of this HostGroupConfiguration.
        The OCID for firmware bundle


        :return: The firmware_bundle_id of this HostGroupConfiguration.
        :rtype: str
        """
        return self._firmware_bundle_id

    @firmware_bundle_id.setter
    def firmware_bundle_id(self, firmware_bundle_id):
        """
        Sets the firmware_bundle_id of this HostGroupConfiguration.
        The OCID for firmware bundle


        :param firmware_bundle_id: The firmware_bundle_id of this HostGroupConfiguration.
        :type: str
        """
        self._firmware_bundle_id = firmware_bundle_id

    @property
    def recycle_level(self):
        """
        Gets the recycle_level of this HostGroupConfiguration.
        Preferred recycle level for hosts associated with the reservation config.
        * `SKIP_RECYCLE` - Skips host wipe.
        * `FULL_RECYCLE` - Does not skip host wipe. This is the default behavior.

        Allowed values for this property are: "SKIP_RECYCLE", "FULL_RECYCLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The recycle_level of this HostGroupConfiguration.
        :rtype: str
        """
        return self._recycle_level

    @recycle_level.setter
    def recycle_level(self, recycle_level):
        """
        Sets the recycle_level of this HostGroupConfiguration.
        Preferred recycle level for hosts associated with the reservation config.
        * `SKIP_RECYCLE` - Skips host wipe.
        * `FULL_RECYCLE` - Does not skip host wipe. This is the default behavior.


        :param recycle_level: The recycle_level of this HostGroupConfiguration.
        :type: str
        """
        allowed_values = ["SKIP_RECYCLE", "FULL_RECYCLE"]
        if not value_allowed_none_or_none_sentinel(recycle_level, allowed_values):
            recycle_level = 'UNKNOWN_ENUM_VALUE'
        self._recycle_level = recycle_level

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
