# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateReferentialRelationDetails(object):
    """
    A sensitive column is a resource corresponding to a database column that is considered sensitive.
    It's a subresource of sensitive data model resource and is always associated with a sensitive data model.
    Note that referential relationships are also managed as part of sensitive columns.
    """

    #: A constant which can be used with the relation_type property of a CreateReferentialRelationDetails.
    #: This constant has a value of "APP_DEFINED"
    RELATION_TYPE_APP_DEFINED = "APP_DEFINED"

    #: A constant which can be used with the relation_type property of a CreateReferentialRelationDetails.
    #: This constant has a value of "DB_DEFINED"
    RELATION_TYPE_DB_DEFINED = "DB_DEFINED"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateReferentialRelationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param relation_type:
            The value to assign to the relation_type property of this CreateReferentialRelationDetails.
            Allowed values for this property are: "APP_DEFINED", "DB_DEFINED"
        :type relation_type: str

        :param parent:
            The value to assign to the parent property of this CreateReferentialRelationDetails.
        :type parent: oci.data_safe.models.ColumnsInfo

        :param child:
            The value to assign to the child property of this CreateReferentialRelationDetails.
        :type child: oci.data_safe.models.ColumnsInfo

        :param is_sensitive:
            The value to assign to the is_sensitive property of this CreateReferentialRelationDetails.
        :type is_sensitive: bool

        """
        self.swagger_types = {
            'relation_type': 'str',
            'parent': 'ColumnsInfo',
            'child': 'ColumnsInfo',
            'is_sensitive': 'bool'
        }
        self.attribute_map = {
            'relation_type': 'relationType',
            'parent': 'parent',
            'child': 'child',
            'is_sensitive': 'isSensitive'
        }
        self._relation_type = None
        self._parent = None
        self._child = None
        self._is_sensitive = None

    @property
    def relation_type(self):
        """
        **[Required]** Gets the relation_type of this CreateReferentialRelationDetails.
        The type of referential relationship the sensitive column has with its parent.
        DB_DEFINED indicates that the relationship is defined in the database dictionary.
        APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.

        Allowed values for this property are: "APP_DEFINED", "DB_DEFINED"


        :return: The relation_type of this CreateReferentialRelationDetails.
        :rtype: str
        """
        return self._relation_type

    @relation_type.setter
    def relation_type(self, relation_type):
        """
        Sets the relation_type of this CreateReferentialRelationDetails.
        The type of referential relationship the sensitive column has with its parent.
        DB_DEFINED indicates that the relationship is defined in the database dictionary.
        APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.


        :param relation_type: The relation_type of this CreateReferentialRelationDetails.
        :type: str
        """
        allowed_values = ["APP_DEFINED", "DB_DEFINED"]
        if not value_allowed_none_or_none_sentinel(relation_type, allowed_values):
            raise ValueError(
                f"Invalid value for `relation_type`, must be None or one of {allowed_values}"
            )
        self._relation_type = relation_type

    @property
    def parent(self):
        """
        **[Required]** Gets the parent of this CreateReferentialRelationDetails.

        :return: The parent of this CreateReferentialRelationDetails.
        :rtype: oci.data_safe.models.ColumnsInfo
        """
        return self._parent

    @parent.setter
    def parent(self, parent):
        """
        Sets the parent of this CreateReferentialRelationDetails.

        :param parent: The parent of this CreateReferentialRelationDetails.
        :type: oci.data_safe.models.ColumnsInfo
        """
        self._parent = parent

    @property
    def child(self):
        """
        **[Required]** Gets the child of this CreateReferentialRelationDetails.

        :return: The child of this CreateReferentialRelationDetails.
        :rtype: oci.data_safe.models.ColumnsInfo
        """
        return self._child

    @child.setter
    def child(self, child):
        """
        Sets the child of this CreateReferentialRelationDetails.

        :param child: The child of this CreateReferentialRelationDetails.
        :type: oci.data_safe.models.ColumnsInfo
        """
        self._child = child

    @property
    def is_sensitive(self):
        """
        Gets the is_sensitive of this CreateReferentialRelationDetails.
        Add to sensitive data model if passed true. If false is passed, then the
        columns will not be added in the sensitive data model as sensitive columns and
        if sensitive type OCIDs are assigned to the columns, then the sensitive type
        OCIDs will not be retained.


        :return: The is_sensitive of this CreateReferentialRelationDetails.
        :rtype: bool
        """
        return self._is_sensitive

    @is_sensitive.setter
    def is_sensitive(self, is_sensitive):
        """
        Sets the is_sensitive of this CreateReferentialRelationDetails.
        Add to sensitive data model if passed true. If false is passed, then the
        columns will not be added in the sensitive data model as sensitive columns and
        if sensitive type OCIDs are assigned to the columns, then the sensitive type
        OCIDs will not be retained.


        :param is_sensitive: The is_sensitive of this CreateReferentialRelationDetails.
        :type: bool
        """
        self._is_sensitive = is_sensitive

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
