# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Exclude(object):
    """
    Criteria to exclude certain target databases from the target database group.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Exclude object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target_database_ids:
            The value to assign to the target_database_ids property of this Exclude.
        :type target_database_ids: list[str]

        """
        self.swagger_types = {
            'target_database_ids': 'list[str]'
        }
        self.attribute_map = {
            'target_database_ids': 'targetDatabaseIds'
        }
        self._target_database_ids = None

    @property
    def target_database_ids(self):
        """
        **[Required]** Gets the target_database_ids of this Exclude.
        The list of target database OCIDS, that should be excluded from the target database group (even if they match some of the other criteria).


        :return: The target_database_ids of this Exclude.
        :rtype: list[str]
        """
        return self._target_database_ids

    @target_database_ids.setter
    def target_database_ids(self, target_database_ids):
        """
        Sets the target_database_ids of this Exclude.
        The list of target database OCIDS, that should be excluded from the target database group (even if they match some of the other criteria).


        :param target_database_ids: The target_database_ids of this Exclude.
        :type: list[str]
        """
        self._target_database_ids = target_database_ids

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
