# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SensitiveTypesExport(object):
    """
    The resource represents sensitive types to be exported in Data Safe.
    """

    #: A constant which can be used with the lifecycle_state property of a SensitiveTypesExport.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a SensitiveTypesExport.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a SensitiveTypesExport.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a SensitiveTypesExport.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a SensitiveTypesExport.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a SensitiveTypesExport.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new SensitiveTypesExport object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this SensitiveTypesExport.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this SensitiveTypesExport.
        :type display_name: str

        :param description:
            The value to assign to the description property of this SensitiveTypesExport.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this SensitiveTypesExport.
        :type compartment_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this SensitiveTypesExport.
            Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this SensitiveTypesExport.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this SensitiveTypesExport.
        :type time_updated: datetime

        :param sensitive_type_ids_for_export:
            The value to assign to the sensitive_type_ids_for_export property of this SensitiveTypesExport.
        :type sensitive_type_ids_for_export: list[str]

        :param is_include_all_sensitive_types:
            The value to assign to the is_include_all_sensitive_types property of this SensitiveTypesExport.
        :type is_include_all_sensitive_types: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this SensitiveTypesExport.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this SensitiveTypesExport.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this SensitiveTypesExport.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'sensitive_type_ids_for_export': 'list[str]',
            'is_include_all_sensitive_types': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'sensitive_type_ids_for_export': 'sensitiveTypeIdsForExport',
            'is_include_all_sensitive_types': 'isIncludeAllSensitiveTypes',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None
        self._sensitive_type_ids_for_export = None
        self._is_include_all_sensitive_types = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this SensitiveTypesExport.
        The OCID of the sensitive types export.


        :return: The id of this SensitiveTypesExport.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SensitiveTypesExport.
        The OCID of the sensitive types export.


        :param id: The id of this SensitiveTypesExport.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this SensitiveTypesExport.
        The display name of the sensitive types export.


        :return: The display_name of this SensitiveTypesExport.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this SensitiveTypesExport.
        The display name of the sensitive types export.


        :param display_name: The display_name of this SensitiveTypesExport.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this SensitiveTypesExport.
        The description of the sensitive types export.


        :return: The description of this SensitiveTypesExport.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this SensitiveTypesExport.
        The description of the sensitive types export.


        :param description: The description of this SensitiveTypesExport.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this SensitiveTypesExport.
        The OCID of the compartment that contains the sensitive types export.


        :return: The compartment_id of this SensitiveTypesExport.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this SensitiveTypesExport.
        The OCID of the compartment that contains the sensitive types export.


        :param compartment_id: The compartment_id of this SensitiveTypesExport.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this SensitiveTypesExport.
        The current state of the sensitive types export.

        Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this SensitiveTypesExport.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this SensitiveTypesExport.
        The current state of the sensitive types export.


        :param lifecycle_state: The lifecycle_state of this SensitiveTypesExport.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this SensitiveTypesExport.
        The date and time the sensitive types export was created, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this SensitiveTypesExport.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this SensitiveTypesExport.
        The date and time the sensitive types export was created, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this SensitiveTypesExport.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this SensitiveTypesExport.
        The date and time the sensitive types export was last updated, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this SensitiveTypesExport.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this SensitiveTypesExport.
        The date and time the sensitive types export was last updated, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this SensitiveTypesExport.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def sensitive_type_ids_for_export(self):
        """
        Gets the sensitive_type_ids_for_export of this SensitiveTypesExport.
        The OCIDs of the sensitive types used to create sensitive types export.


        :return: The sensitive_type_ids_for_export of this SensitiveTypesExport.
        :rtype: list[str]
        """
        return self._sensitive_type_ids_for_export

    @sensitive_type_ids_for_export.setter
    def sensitive_type_ids_for_export(self, sensitive_type_ids_for_export):
        """
        Sets the sensitive_type_ids_for_export of this SensitiveTypesExport.
        The OCIDs of the sensitive types used to create sensitive types export.


        :param sensitive_type_ids_for_export: The sensitive_type_ids_for_export of this SensitiveTypesExport.
        :type: list[str]
        """
        self._sensitive_type_ids_for_export = sensitive_type_ids_for_export

    @property
    def is_include_all_sensitive_types(self):
        """
        **[Required]** Gets the is_include_all_sensitive_types of this SensitiveTypesExport.
        Indicates if all the existing user-defined sensitive types are used for export. If it's set to true, the
        sensitiveTypeIdsForExport attribute is ignored and all user-defined sensitive types are exported.


        :return: The is_include_all_sensitive_types of this SensitiveTypesExport.
        :rtype: bool
        """
        return self._is_include_all_sensitive_types

    @is_include_all_sensitive_types.setter
    def is_include_all_sensitive_types(self, is_include_all_sensitive_types):
        """
        Sets the is_include_all_sensitive_types of this SensitiveTypesExport.
        Indicates if all the existing user-defined sensitive types are used for export. If it's set to true, the
        sensitiveTypeIdsForExport attribute is ignored and all user-defined sensitive types are exported.


        :param is_include_all_sensitive_types: The is_include_all_sensitive_types of this SensitiveTypesExport.
        :type: bool
        """
        self._is_include_all_sensitive_types = is_include_all_sensitive_types

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this SensitiveTypesExport.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this SensitiveTypesExport.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this SensitiveTypesExport.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this SensitiveTypesExport.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this SensitiveTypesExport.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this SensitiveTypesExport.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this SensitiveTypesExport.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this SensitiveTypesExport.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this SensitiveTypesExport.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this SensitiveTypesExport.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this SensitiveTypesExport.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this SensitiveTypesExport.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
