# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .patch_instruction import PatchInstruction
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PatchRemoveMemberModels(PatchInstruction):
    """
    This will specify the list of source model group models that are not to be associated with the cloned model group.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PatchRemoveMemberModels object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.PatchRemoveMemberModels.operation` attribute
        of this class is ``REMOVE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param operation:
            The value to assign to the operation property of this PatchRemoveMemberModels.
            Allowed values for this property are: "INSERT", "REMOVE"
        :type operation: str

        :param values:
            The value to assign to the values property of this PatchRemoveMemberModels.
        :type values: list[oci.data_science.models.MemberModelDetails]

        """
        self.swagger_types = {
            'operation': 'str',
            'values': 'list[MemberModelDetails]'
        }
        self.attribute_map = {
            'operation': 'operation',
            'values': 'values'
        }
        self._operation = None
        self._values = None
        self._operation = 'REMOVE'

    @property
    def values(self):
        """
        **[Required]** Gets the values of this PatchRemoveMemberModels.
        Array of inference key and model OCID.


        :return: The values of this PatchRemoveMemberModels.
        :rtype: list[oci.data_science.models.MemberModelDetails]
        """
        return self._values

    @values.setter
    def values(self, values):
        """
        Sets the values of this PatchRemoveMemberModels.
        Array of inference key and model OCID.


        :param values: The values of this PatchRemoveMemberModels.
        :type: list[oci.data_science.models.MemberModelDetails]
        """
        self._values = values

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
