# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .pipeline_step_parameter_details import PipelineStepParameterDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PipelineDefaultStepParameterDetails(PipelineStepParameterDetails):
    """
    Pipeline Default step parameter details
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PipelineDefaultStepParameterDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.PipelineDefaultStepParameterDetails.parameter_type` attribute
        of this class is ``DEFAULT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param parameter_type:
            The value to assign to the parameter_type property of this PipelineDefaultStepParameterDetails.
            Allowed values for this property are: "DEFAULT"
        :type parameter_type: str

        :param output:
            The value to assign to the output property of this PipelineDefaultStepParameterDetails.
        :type output: oci.data_science.models.PipelineStepOutputParameterDetails

        """
        self.swagger_types = {
            'parameter_type': 'str',
            'output': 'PipelineStepOutputParameterDetails'
        }
        self.attribute_map = {
            'parameter_type': 'parameterType',
            'output': 'output'
        }
        self._parameter_type = None
        self._output = None
        self._parameter_type = 'DEFAULT'

    @property
    def output(self):
        """
        **[Required]** Gets the output of this PipelineDefaultStepParameterDetails.

        :return: The output of this PipelineDefaultStepParameterDetails.
        :rtype: oci.data_science.models.PipelineStepOutputParameterDetails
        """
        return self._output

    @output.setter
    def output(self, output):
        """
        Sets the output of this PipelineDefaultStepParameterDetails.

        :param output: The output of this PipelineDefaultStepParameterDetails.
        :type: oci.data_science.models.PipelineStepOutputParameterDetails
        """
        self._output = output

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
