# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseStorageSizeDetails(object):
    """
    The database storage size details. This database option is supported for the Exadata VM cluster on Exascale Infrastructure.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseStorageSizeDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param data_storage_size_in_gbs:
            The value to assign to the data_storage_size_in_gbs property of this DatabaseStorageSizeDetails.
        :type data_storage_size_in_gbs: int

        :param reco_storage_size_in_gbs:
            The value to assign to the reco_storage_size_in_gbs property of this DatabaseStorageSizeDetails.
        :type reco_storage_size_in_gbs: int

        """
        self.swagger_types = {
            'data_storage_size_in_gbs': 'int',
            'reco_storage_size_in_gbs': 'int'
        }
        self.attribute_map = {
            'data_storage_size_in_gbs': 'dataStorageSizeInGBs',
            'reco_storage_size_in_gbs': 'recoStorageSizeInGBs'
        }
        self._data_storage_size_in_gbs = None
        self._reco_storage_size_in_gbs = None

    @property
    def data_storage_size_in_gbs(self):
        """
        **[Required]** Gets the data_storage_size_in_gbs of this DatabaseStorageSizeDetails.
        The DATA storage size, in gigabytes, that is applicable for the database.


        :return: The data_storage_size_in_gbs of this DatabaseStorageSizeDetails.
        :rtype: int
        """
        return self._data_storage_size_in_gbs

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, data_storage_size_in_gbs):
        """
        Sets the data_storage_size_in_gbs of this DatabaseStorageSizeDetails.
        The DATA storage size, in gigabytes, that is applicable for the database.


        :param data_storage_size_in_gbs: The data_storage_size_in_gbs of this DatabaseStorageSizeDetails.
        :type: int
        """
        self._data_storage_size_in_gbs = data_storage_size_in_gbs

    @property
    def reco_storage_size_in_gbs(self):
        """
        **[Required]** Gets the reco_storage_size_in_gbs of this DatabaseStorageSizeDetails.
        The RECO storage size, in gigabytes, that is applicable for the database.


        :return: The reco_storage_size_in_gbs of this DatabaseStorageSizeDetails.
        :rtype: int
        """
        return self._reco_storage_size_in_gbs

    @reco_storage_size_in_gbs.setter
    def reco_storage_size_in_gbs(self, reco_storage_size_in_gbs):
        """
        Sets the reco_storage_size_in_gbs of this DatabaseStorageSizeDetails.
        The RECO storage size, in gigabytes, that is applicable for the database.


        :param reco_storage_size_in_gbs: The reco_storage_size_in_gbs of this DatabaseStorageSizeDetails.
        :type: int
        """
        self._reco_storage_size_in_gbs = reco_storage_size_in_gbs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
