# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RecoveryApplianceDetails(object):
    """
    Information about the recovery appliance configuration associated with the Autonomous Container Database.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RecoveryApplianceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param allocated_storage_size_in_gbs:
            The value to assign to the allocated_storage_size_in_gbs property of this RecoveryApplianceDetails.
        :type allocated_storage_size_in_gbs: int

        :param recovery_window_in_days:
            The value to assign to the recovery_window_in_days property of this RecoveryApplianceDetails.
        :type recovery_window_in_days: int

        :param time_recovery_appliance_details_updated:
            The value to assign to the time_recovery_appliance_details_updated property of this RecoveryApplianceDetails.
        :type time_recovery_appliance_details_updated: datetime

        """
        self.swagger_types = {
            'allocated_storage_size_in_gbs': 'int',
            'recovery_window_in_days': 'int',
            'time_recovery_appliance_details_updated': 'datetime'
        }
        self.attribute_map = {
            'allocated_storage_size_in_gbs': 'allocatedStorageSizeInGBs',
            'recovery_window_in_days': 'recoveryWindowInDays',
            'time_recovery_appliance_details_updated': 'timeRecoveryApplianceDetailsUpdated'
        }
        self._allocated_storage_size_in_gbs = None
        self._recovery_window_in_days = None
        self._time_recovery_appliance_details_updated = None

    @property
    def allocated_storage_size_in_gbs(self):
        """
        Gets the allocated_storage_size_in_gbs of this RecoveryApplianceDetails.
        The storage size of the backup destination allocated for an Autonomous Container Database to store backups on the recovery appliance, in GBs, rounded to the nearest integer.


        :return: The allocated_storage_size_in_gbs of this RecoveryApplianceDetails.
        :rtype: int
        """
        return self._allocated_storage_size_in_gbs

    @allocated_storage_size_in_gbs.setter
    def allocated_storage_size_in_gbs(self, allocated_storage_size_in_gbs):
        """
        Sets the allocated_storage_size_in_gbs of this RecoveryApplianceDetails.
        The storage size of the backup destination allocated for an Autonomous Container Database to store backups on the recovery appliance, in GBs, rounded to the nearest integer.


        :param allocated_storage_size_in_gbs: The allocated_storage_size_in_gbs of this RecoveryApplianceDetails.
        :type: int
        """
        self._allocated_storage_size_in_gbs = allocated_storage_size_in_gbs

    @property
    def recovery_window_in_days(self):
        """
        Gets the recovery_window_in_days of this RecoveryApplianceDetails.
        Number of days between the current and earliest point of recoverability covered by automatic backups.


        :return: The recovery_window_in_days of this RecoveryApplianceDetails.
        :rtype: int
        """
        return self._recovery_window_in_days

    @recovery_window_in_days.setter
    def recovery_window_in_days(self, recovery_window_in_days):
        """
        Sets the recovery_window_in_days of this RecoveryApplianceDetails.
        Number of days between the current and earliest point of recoverability covered by automatic backups.


        :param recovery_window_in_days: The recovery_window_in_days of this RecoveryApplianceDetails.
        :type: int
        """
        self._recovery_window_in_days = recovery_window_in_days

    @property
    def time_recovery_appliance_details_updated(self):
        """
        Gets the time_recovery_appliance_details_updated of this RecoveryApplianceDetails.
        The time when the recovery appliance details are updated.


        :return: The time_recovery_appliance_details_updated of this RecoveryApplianceDetails.
        :rtype: datetime
        """
        return self._time_recovery_appliance_details_updated

    @time_recovery_appliance_details_updated.setter
    def time_recovery_appliance_details_updated(self, time_recovery_appliance_details_updated):
        """
        Sets the time_recovery_appliance_details_updated of this RecoveryApplianceDetails.
        The time when the recovery appliance details are updated.


        :param time_recovery_appliance_details_updated: The time_recovery_appliance_details_updated of this RecoveryApplianceDetails.
        :type: datetime
        """
        self._time_recovery_appliance_details_updated = time_recovery_appliance_details_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
