# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SourceDatabaseDetails(object):
    """
    Source Autonomous AI Database details.
    """

    #: A constant which can be used with the db_workload property of a SourceDatabaseDetails.
    #: This constant has a value of "OLTP"
    DB_WORKLOAD_OLTP = "OLTP"

    #: A constant which can be used with the db_workload property of a SourceDatabaseDetails.
    #: This constant has a value of "DW"
    DB_WORKLOAD_DW = "DW"

    #: A constant which can be used with the db_workload property of a SourceDatabaseDetails.
    #: This constant has a value of "AJD"
    DB_WORKLOAD_AJD = "AJD"

    #: A constant which can be used with the db_workload property of a SourceDatabaseDetails.
    #: This constant has a value of "APEX"
    DB_WORKLOAD_APEX = "APEX"

    #: A constant which can be used with the db_workload property of a SourceDatabaseDetails.
    #: This constant has a value of "LH"
    DB_WORKLOAD_LH = "LH"

    def __init__(self, **kwargs):
        """
        Initializes a new SourceDatabaseDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param autonomous_vm_cluster_display_name:
            The value to assign to the autonomous_vm_cluster_display_name property of this SourceDatabaseDetails.
        :type autonomous_vm_cluster_display_name: str

        :param autonomous_container_database_name:
            The value to assign to the autonomous_container_database_name property of this SourceDatabaseDetails.
        :type autonomous_container_database_name: str

        :param autonomous_container_database_display_name:
            The value to assign to the autonomous_container_database_display_name property of this SourceDatabaseDetails.
        :type autonomous_container_database_display_name: str

        :param autonomous_container_database_customer_contacts:
            The value to assign to the autonomous_container_database_customer_contacts property of this SourceDatabaseDetails.
        :type autonomous_container_database_customer_contacts: list[oci.database.models.CustomerContact]

        :param autonomous_container_database_dst_file_version:
            The value to assign to the autonomous_container_database_dst_file_version property of this SourceDatabaseDetails.
        :type autonomous_container_database_dst_file_version: str

        :param autonomous_database_name:
            The value to assign to the autonomous_database_name property of this SourceDatabaseDetails.
        :type autonomous_database_name: str

        :param autonomous_database_customer_contacts:
            The value to assign to the autonomous_database_customer_contacts property of this SourceDatabaseDetails.
        :type autonomous_database_customer_contacts: list[oci.database.models.CustomerContact]

        :param db_workload:
            The value to assign to the db_workload property of this SourceDatabaseDetails.
            Allowed values for this property are: "OLTP", "DW", "AJD", "APEX", "LH", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type db_workload: str

        """
        self.swagger_types = {
            'autonomous_vm_cluster_display_name': 'str',
            'autonomous_container_database_name': 'str',
            'autonomous_container_database_display_name': 'str',
            'autonomous_container_database_customer_contacts': 'list[CustomerContact]',
            'autonomous_container_database_dst_file_version': 'str',
            'autonomous_database_name': 'str',
            'autonomous_database_customer_contacts': 'list[CustomerContact]',
            'db_workload': 'str'
        }
        self.attribute_map = {
            'autonomous_vm_cluster_display_name': 'autonomousVmClusterDisplayName',
            'autonomous_container_database_name': 'autonomousContainerDatabaseName',
            'autonomous_container_database_display_name': 'autonomousContainerDatabaseDisplayName',
            'autonomous_container_database_customer_contacts': 'autonomousContainerDatabaseCustomerContacts',
            'autonomous_container_database_dst_file_version': 'autonomousContainerDatabaseDstFileVersion',
            'autonomous_database_name': 'autonomousDatabaseName',
            'autonomous_database_customer_contacts': 'autonomousDatabaseCustomerContacts',
            'db_workload': 'dbWorkload'
        }
        self._autonomous_vm_cluster_display_name = None
        self._autonomous_container_database_name = None
        self._autonomous_container_database_display_name = None
        self._autonomous_container_database_customer_contacts = None
        self._autonomous_container_database_dst_file_version = None
        self._autonomous_database_name = None
        self._autonomous_database_customer_contacts = None
        self._db_workload = None

    @property
    def autonomous_vm_cluster_display_name(self):
        """
        Gets the autonomous_vm_cluster_display_name of this SourceDatabaseDetails.
        Autonomous VM cluster's user-friendly name.


        :return: The autonomous_vm_cluster_display_name of this SourceDatabaseDetails.
        :rtype: str
        """
        return self._autonomous_vm_cluster_display_name

    @autonomous_vm_cluster_display_name.setter
    def autonomous_vm_cluster_display_name(self, autonomous_vm_cluster_display_name):
        """
        Sets the autonomous_vm_cluster_display_name of this SourceDatabaseDetails.
        Autonomous VM cluster's user-friendly name.


        :param autonomous_vm_cluster_display_name: The autonomous_vm_cluster_display_name of this SourceDatabaseDetails.
        :type: str
        """
        self._autonomous_vm_cluster_display_name = autonomous_vm_cluster_display_name

    @property
    def autonomous_container_database_name(self):
        """
        Gets the autonomous_container_database_name of this SourceDatabaseDetails.
        Autonomous Container Database name.


        :return: The autonomous_container_database_name of this SourceDatabaseDetails.
        :rtype: str
        """
        return self._autonomous_container_database_name

    @autonomous_container_database_name.setter
    def autonomous_container_database_name(self, autonomous_container_database_name):
        """
        Sets the autonomous_container_database_name of this SourceDatabaseDetails.
        Autonomous Container Database name.


        :param autonomous_container_database_name: The autonomous_container_database_name of this SourceDatabaseDetails.
        :type: str
        """
        self._autonomous_container_database_name = autonomous_container_database_name

    @property
    def autonomous_container_database_display_name(self):
        """
        Gets the autonomous_container_database_display_name of this SourceDatabaseDetails.
        The user-provided name for the Autonomous Container Database.


        :return: The autonomous_container_database_display_name of this SourceDatabaseDetails.
        :rtype: str
        """
        return self._autonomous_container_database_display_name

    @autonomous_container_database_display_name.setter
    def autonomous_container_database_display_name(self, autonomous_container_database_display_name):
        """
        Sets the autonomous_container_database_display_name of this SourceDatabaseDetails.
        The user-provided name for the Autonomous Container Database.


        :param autonomous_container_database_display_name: The autonomous_container_database_display_name of this SourceDatabaseDetails.
        :type: str
        """
        self._autonomous_container_database_display_name = autonomous_container_database_display_name

    @property
    def autonomous_container_database_customer_contacts(self):
        """
        Gets the autonomous_container_database_customer_contacts of this SourceDatabaseDetails.
        Customer Contacts for the Autonomous Container Database. Setting this to an empty list removes all customer contacts.


        :return: The autonomous_container_database_customer_contacts of this SourceDatabaseDetails.
        :rtype: list[oci.database.models.CustomerContact]
        """
        return self._autonomous_container_database_customer_contacts

    @autonomous_container_database_customer_contacts.setter
    def autonomous_container_database_customer_contacts(self, autonomous_container_database_customer_contacts):
        """
        Sets the autonomous_container_database_customer_contacts of this SourceDatabaseDetails.
        Customer Contacts for the Autonomous Container Database. Setting this to an empty list removes all customer contacts.


        :param autonomous_container_database_customer_contacts: The autonomous_container_database_customer_contacts of this SourceDatabaseDetails.
        :type: list[oci.database.models.CustomerContact]
        """
        self._autonomous_container_database_customer_contacts = autonomous_container_database_customer_contacts

    @property
    def autonomous_container_database_dst_file_version(self):
        """
        Gets the autonomous_container_database_dst_file_version of this SourceDatabaseDetails.
        DST Time-Zone File version of the Autonomous Container Database.


        :return: The autonomous_container_database_dst_file_version of this SourceDatabaseDetails.
        :rtype: str
        """
        return self._autonomous_container_database_dst_file_version

    @autonomous_container_database_dst_file_version.setter
    def autonomous_container_database_dst_file_version(self, autonomous_container_database_dst_file_version):
        """
        Sets the autonomous_container_database_dst_file_version of this SourceDatabaseDetails.
        DST Time-Zone File version of the Autonomous Container Database.


        :param autonomous_container_database_dst_file_version: The autonomous_container_database_dst_file_version of this SourceDatabaseDetails.
        :type: str
        """
        self._autonomous_container_database_dst_file_version = autonomous_container_database_dst_file_version

    @property
    def autonomous_database_name(self):
        """
        Gets the autonomous_database_name of this SourceDatabaseDetails.
        Autonomous AI Database's name.


        :return: The autonomous_database_name of this SourceDatabaseDetails.
        :rtype: str
        """
        return self._autonomous_database_name

    @autonomous_database_name.setter
    def autonomous_database_name(self, autonomous_database_name):
        """
        Sets the autonomous_database_name of this SourceDatabaseDetails.
        Autonomous AI Database's name.


        :param autonomous_database_name: The autonomous_database_name of this SourceDatabaseDetails.
        :type: str
        """
        self._autonomous_database_name = autonomous_database_name

    @property
    def autonomous_database_customer_contacts(self):
        """
        Gets the autonomous_database_customer_contacts of this SourceDatabaseDetails.
        Customer Contacts for the Autonomous AI Database.


        :return: The autonomous_database_customer_contacts of this SourceDatabaseDetails.
        :rtype: list[oci.database.models.CustomerContact]
        """
        return self._autonomous_database_customer_contacts

    @autonomous_database_customer_contacts.setter
    def autonomous_database_customer_contacts(self, autonomous_database_customer_contacts):
        """
        Sets the autonomous_database_customer_contacts of this SourceDatabaseDetails.
        Customer Contacts for the Autonomous AI Database.


        :param autonomous_database_customer_contacts: The autonomous_database_customer_contacts of this SourceDatabaseDetails.
        :type: list[oci.database.models.CustomerContact]
        """
        self._autonomous_database_customer_contacts = autonomous_database_customer_contacts

    @property
    def db_workload(self):
        """
        Gets the db_workload of this SourceDatabaseDetails.
        The Autonomous AI Database workload type. The following values are valid:
        - OLTP - indicates an Autonomous AI Transaction Processing database
        - DW - indicates an Autonomous AI Lakehouse database
        - AJD - indicates an Autonomous AI JSON Database
        - APEX - indicates an Autonomous AI Database with the Oracle APEX AI Application Development workload type.
        - LH - indicates an Oracle Autonomous AI Lakehouse database


        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.

        Allowed values for this property are: "OLTP", "DW", "AJD", "APEX", "LH", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The db_workload of this SourceDatabaseDetails.
        :rtype: str
        """
        return self._db_workload

    @db_workload.setter
    def db_workload(self, db_workload):
        """
        Sets the db_workload of this SourceDatabaseDetails.
        The Autonomous AI Database workload type. The following values are valid:
        - OLTP - indicates an Autonomous AI Transaction Processing database
        - DW - indicates an Autonomous AI Lakehouse database
        - AJD - indicates an Autonomous AI JSON Database
        - APEX - indicates an Autonomous AI Database with the Oracle APEX AI Application Development workload type.
        - LH - indicates an Oracle Autonomous AI Lakehouse database


        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.


        :param db_workload: The db_workload of this SourceDatabaseDetails.
        :type: str
        """
        allowed_values = ["OLTP", "DW", "AJD", "APEX", "LH"]
        if not value_allowed_none_or_none_sentinel(db_workload, allowed_values):
            db_workload = 'UNKNOWN_ENUM_VALUE'
        self._db_workload = db_workload

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
