# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DataguardMetrics(object):
    """
    The Data Guard usage metrics for a single database.
    """

    #: A constant which can be used with the database_type property of a DataguardMetrics.
    #: This constant has a value of "EXTERNAL_SIDB"
    DATABASE_TYPE_EXTERNAL_SIDB = "EXTERNAL_SIDB"

    #: A constant which can be used with the database_type property of a DataguardMetrics.
    #: This constant has a value of "EXTERNAL_RAC"
    DATABASE_TYPE_EXTERNAL_RAC = "EXTERNAL_RAC"

    #: A constant which can be used with the database_type property of a DataguardMetrics.
    #: This constant has a value of "CLOUD_SIDB"
    DATABASE_TYPE_CLOUD_SIDB = "CLOUD_SIDB"

    #: A constant which can be used with the database_type property of a DataguardMetrics.
    #: This constant has a value of "CLOUD_RAC"
    DATABASE_TYPE_CLOUD_RAC = "CLOUD_RAC"

    #: A constant which can be used with the database_type property of a DataguardMetrics.
    #: This constant has a value of "SHARED"
    DATABASE_TYPE_SHARED = "SHARED"

    #: A constant which can be used with the database_type property of a DataguardMetrics.
    #: This constant has a value of "DEDICATED"
    DATABASE_TYPE_DEDICATED = "DEDICATED"

    #: A constant which can be used with the database_type property of a DataguardMetrics.
    #: This constant has a value of "CLOUD_AT_CUSTOMER"
    DATABASE_TYPE_CLOUD_AT_CUSTOMER = "CLOUD_AT_CUSTOMER"

    #: A constant which can be used with the database_sub_type property of a DataguardMetrics.
    #: This constant has a value of "CDB"
    DATABASE_SUB_TYPE_CDB = "CDB"

    #: A constant which can be used with the database_sub_type property of a DataguardMetrics.
    #: This constant has a value of "PDB"
    DATABASE_SUB_TYPE_PDB = "PDB"

    #: A constant which can be used with the database_sub_type property of a DataguardMetrics.
    #: This constant has a value of "NON_CDB"
    DATABASE_SUB_TYPE_NON_CDB = "NON_CDB"

    #: A constant which can be used with the database_sub_type property of a DataguardMetrics.
    #: This constant has a value of "ACD"
    DATABASE_SUB_TYPE_ACD = "ACD"

    #: A constant which can be used with the database_sub_type property of a DataguardMetrics.
    #: This constant has a value of "ADB"
    DATABASE_SUB_TYPE_ADB = "ADB"

    #: A constant which can be used with the deployment_type property of a DataguardMetrics.
    #: This constant has a value of "ONPREMISE"
    DEPLOYMENT_TYPE_ONPREMISE = "ONPREMISE"

    #: A constant which can be used with the deployment_type property of a DataguardMetrics.
    #: This constant has a value of "BM"
    DEPLOYMENT_TYPE_BM = "BM"

    #: A constant which can be used with the deployment_type property of a DataguardMetrics.
    #: This constant has a value of "VM"
    DEPLOYMENT_TYPE_VM = "VM"

    #: A constant which can be used with the deployment_type property of a DataguardMetrics.
    #: This constant has a value of "EXADATA"
    DEPLOYMENT_TYPE_EXADATA = "EXADATA"

    #: A constant which can be used with the deployment_type property of a DataguardMetrics.
    #: This constant has a value of "EXADATA_CC"
    DEPLOYMENT_TYPE_EXADATA_CC = "EXADATA_CC"

    #: A constant which can be used with the deployment_type property of a DataguardMetrics.
    #: This constant has a value of "AUTONOMOUS"
    DEPLOYMENT_TYPE_AUTONOMOUS = "AUTONOMOUS"

    #: A constant which can be used with the deployment_type property of a DataguardMetrics.
    #: This constant has a value of "EXADATA_XS"
    DEPLOYMENT_TYPE_EXADATA_XS = "EXADATA_XS"

    #: A constant which can be used with the workload_type property of a DataguardMetrics.
    #: This constant has a value of "OLTP"
    WORKLOAD_TYPE_OLTP = "OLTP"

    #: A constant which can be used with the workload_type property of a DataguardMetrics.
    #: This constant has a value of "DW"
    WORKLOAD_TYPE_DW = "DW"

    #: A constant which can be used with the workload_type property of a DataguardMetrics.
    #: This constant has a value of "AJD"
    WORKLOAD_TYPE_AJD = "AJD"

    #: A constant which can be used with the workload_type property of a DataguardMetrics.
    #: This constant has a value of "APEX"
    WORKLOAD_TYPE_APEX = "APEX"

    #: A constant which can be used with the db_role property of a DataguardMetrics.
    #: This constant has a value of "SNAPSHOT_STANDBY"
    DB_ROLE_SNAPSHOT_STANDBY = "SNAPSHOT_STANDBY"

    #: A constant which can be used with the db_role property of a DataguardMetrics.
    #: This constant has a value of "LOGICAL_STANDBY"
    DB_ROLE_LOGICAL_STANDBY = "LOGICAL_STANDBY"

    #: A constant which can be used with the db_role property of a DataguardMetrics.
    #: This constant has a value of "PHYSICAL_STANDBY"
    DB_ROLE_PHYSICAL_STANDBY = "PHYSICAL_STANDBY"

    #: A constant which can be used with the db_role property of a DataguardMetrics.
    #: This constant has a value of "PRIMARY"
    DB_ROLE_PRIMARY = "PRIMARY"

    #: A constant which can be used with the db_role property of a DataguardMetrics.
    #: This constant has a value of "FAR_SYNC"
    DB_ROLE_FAR_SYNC = "FAR_SYNC"

    def __init__(self, **kwargs):
        """
        Initializes a new DataguardMetrics object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param fast_start_fail_over:
            The value to assign to the fast_start_fail_over property of this DataguardMetrics.
        :type fast_start_fail_over: str

        :param protection_mode:
            The value to assign to the protection_mode property of this DataguardMetrics.
        :type protection_mode: str

        :param metrics:
            The value to assign to the metrics property of this DataguardMetrics.
        :type metrics: list[oci.database_management.models.HaMetricDefinition]

        :param stand_by_databases:
            The value to assign to the stand_by_databases property of this DataguardMetrics.
        :type stand_by_databases: list[oci.database_management.models.StandByDatabaseDataguardMetrics]

        :param db_id:
            The value to assign to the db_id property of this DataguardMetrics.
        :type db_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DataguardMetrics.
        :type compartment_id: str

        :param database_type:
            The value to assign to the database_type property of this DataguardMetrics.
            Allowed values for this property are: "EXTERNAL_SIDB", "EXTERNAL_RAC", "CLOUD_SIDB", "CLOUD_RAC", "SHARED", "DEDICATED", "CLOUD_AT_CUSTOMER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type database_type: str

        :param database_sub_type:
            The value to assign to the database_sub_type property of this DataguardMetrics.
            Allowed values for this property are: "CDB", "PDB", "NON_CDB", "ACD", "ADB", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type database_sub_type: str

        :param deployment_type:
            The value to assign to the deployment_type property of this DataguardMetrics.
            Allowed values for this property are: "ONPREMISE", "BM", "VM", "EXADATA", "EXADATA_CC", "AUTONOMOUS", "EXADATA_XS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type deployment_type: str

        :param database_version:
            The value to assign to the database_version property of this DataguardMetrics.
        :type database_version: str

        :param workload_type:
            The value to assign to the workload_type property of this DataguardMetrics.
            Allowed values for this property are: "OLTP", "DW", "AJD", "APEX", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type workload_type: str

        :param database_name:
            The value to assign to the database_name property of this DataguardMetrics.
        :type database_name: str

        :param database_id:
            The value to assign to the database_id property of this DataguardMetrics.
        :type database_id: str

        :param db_unique_name:
            The value to assign to the db_unique_name property of this DataguardMetrics.
        :type db_unique_name: str

        :param db_role:
            The value to assign to the db_role property of this DataguardMetrics.
            Allowed values for this property are: "SNAPSHOT_STANDBY", "LOGICAL_STANDBY", "PHYSICAL_STANDBY", "PRIMARY", "FAR_SYNC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type db_role: str

        """
        self.swagger_types = {
            'fast_start_fail_over': 'str',
            'protection_mode': 'str',
            'metrics': 'list[HaMetricDefinition]',
            'stand_by_databases': 'list[StandByDatabaseDataguardMetrics]',
            'db_id': 'str',
            'compartment_id': 'str',
            'database_type': 'str',
            'database_sub_type': 'str',
            'deployment_type': 'str',
            'database_version': 'str',
            'workload_type': 'str',
            'database_name': 'str',
            'database_id': 'str',
            'db_unique_name': 'str',
            'db_role': 'str'
        }
        self.attribute_map = {
            'fast_start_fail_over': 'fastStartFailOver',
            'protection_mode': 'protectionMode',
            'metrics': 'metrics',
            'stand_by_databases': 'standByDatabases',
            'db_id': 'dbId',
            'compartment_id': 'compartmentId',
            'database_type': 'databaseType',
            'database_sub_type': 'databaseSubType',
            'deployment_type': 'deploymentType',
            'database_version': 'databaseVersion',
            'workload_type': 'workloadType',
            'database_name': 'databaseName',
            'database_id': 'databaseId',
            'db_unique_name': 'dbUniqueName',
            'db_role': 'dbRole'
        }
        self._fast_start_fail_over = None
        self._protection_mode = None
        self._metrics = None
        self._stand_by_databases = None
        self._db_id = None
        self._compartment_id = None
        self._database_type = None
        self._database_sub_type = None
        self._deployment_type = None
        self._database_version = None
        self._workload_type = None
        self._database_name = None
        self._database_id = None
        self._db_unique_name = None
        self._db_role = None

    @property
    def fast_start_fail_over(self):
        """
        **[Required]** Gets the fast_start_fail_over of this DataguardMetrics.
        The Fast-Start Failover status of the primary database.


        :return: The fast_start_fail_over of this DataguardMetrics.
        :rtype: str
        """
        return self._fast_start_fail_over

    @fast_start_fail_over.setter
    def fast_start_fail_over(self, fast_start_fail_over):
        """
        Sets the fast_start_fail_over of this DataguardMetrics.
        The Fast-Start Failover status of the primary database.


        :param fast_start_fail_over: The fast_start_fail_over of this DataguardMetrics.
        :type: str
        """
        self._fast_start_fail_over = fast_start_fail_over

    @property
    def protection_mode(self):
        """
        **[Required]** Gets the protection_mode of this DataguardMetrics.
        The protection mode of the primary Database.


        :return: The protection_mode of this DataguardMetrics.
        :rtype: str
        """
        return self._protection_mode

    @protection_mode.setter
    def protection_mode(self, protection_mode):
        """
        Sets the protection_mode of this DataguardMetrics.
        The protection mode of the primary Database.


        :param protection_mode: The protection_mode of this DataguardMetrics.
        :type: str
        """
        self._protection_mode = protection_mode

    @property
    def metrics(self):
        """
        **[Required]** Gets the metrics of this DataguardMetrics.
        A list of primary or standby database metrics.


        :return: The metrics of this DataguardMetrics.
        :rtype: list[oci.database_management.models.HaMetricDefinition]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """
        Sets the metrics of this DataguardMetrics.
        A list of primary or standby database metrics.


        :param metrics: The metrics of this DataguardMetrics.
        :type: list[oci.database_management.models.HaMetricDefinition]
        """
        self._metrics = metrics

    @property
    def stand_by_databases(self):
        """
        **[Required]** Gets the stand_by_databases of this DataguardMetrics.
        A list of standby databases and their metrics


        :return: The stand_by_databases of this DataguardMetrics.
        :rtype: list[oci.database_management.models.StandByDatabaseDataguardMetrics]
        """
        return self._stand_by_databases

    @stand_by_databases.setter
    def stand_by_databases(self, stand_by_databases):
        """
        Sets the stand_by_databases of this DataguardMetrics.
        A list of standby databases and their metrics


        :param stand_by_databases: The stand_by_databases of this DataguardMetrics.
        :type: list[oci.database_management.models.StandByDatabaseDataguardMetrics]
        """
        self._stand_by_databases = stand_by_databases

    @property
    def db_id(self):
        """
        **[Required]** Gets the db_id of this DataguardMetrics.
        The `OCID`__ of the Managed Database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The db_id of this DataguardMetrics.
        :rtype: str
        """
        return self._db_id

    @db_id.setter
    def db_id(self, db_id):
        """
        Sets the db_id of this DataguardMetrics.
        The `OCID`__ of the Managed Database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param db_id: The db_id of this DataguardMetrics.
        :type: str
        """
        self._db_id = db_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DataguardMetrics.
        The `OCID`__ of the compartment where the Managed Database resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this DataguardMetrics.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DataguardMetrics.
        The `OCID`__ of the compartment where the Managed Database resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this DataguardMetrics.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def database_type(self):
        """
        **[Required]** Gets the database_type of this DataguardMetrics.
        The type of Oracle Database installation.

        Allowed values for this property are: "EXTERNAL_SIDB", "EXTERNAL_RAC", "CLOUD_SIDB", "CLOUD_RAC", "SHARED", "DEDICATED", "CLOUD_AT_CUSTOMER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The database_type of this DataguardMetrics.
        :rtype: str
        """
        return self._database_type

    @database_type.setter
    def database_type(self, database_type):
        """
        Sets the database_type of this DataguardMetrics.
        The type of Oracle Database installation.


        :param database_type: The database_type of this DataguardMetrics.
        :type: str
        """
        allowed_values = ["EXTERNAL_SIDB", "EXTERNAL_RAC", "CLOUD_SIDB", "CLOUD_RAC", "SHARED", "DEDICATED", "CLOUD_AT_CUSTOMER"]
        if not value_allowed_none_or_none_sentinel(database_type, allowed_values):
            database_type = 'UNKNOWN_ENUM_VALUE'
        self._database_type = database_type

    @property
    def database_sub_type(self):
        """
        **[Required]** Gets the database_sub_type of this DataguardMetrics.
        The subtype of the Oracle Database. Indicates whether the database is a Container Database,
        Pluggable Database, Non-container Database, Autonomous Database, or Autonomous Container Database.

        Allowed values for this property are: "CDB", "PDB", "NON_CDB", "ACD", "ADB", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The database_sub_type of this DataguardMetrics.
        :rtype: str
        """
        return self._database_sub_type

    @database_sub_type.setter
    def database_sub_type(self, database_sub_type):
        """
        Sets the database_sub_type of this DataguardMetrics.
        The subtype of the Oracle Database. Indicates whether the database is a Container Database,
        Pluggable Database, Non-container Database, Autonomous Database, or Autonomous Container Database.


        :param database_sub_type: The database_sub_type of this DataguardMetrics.
        :type: str
        """
        allowed_values = ["CDB", "PDB", "NON_CDB", "ACD", "ADB"]
        if not value_allowed_none_or_none_sentinel(database_sub_type, allowed_values):
            database_sub_type = 'UNKNOWN_ENUM_VALUE'
        self._database_sub_type = database_sub_type

    @property
    def deployment_type(self):
        """
        **[Required]** Gets the deployment_type of this DataguardMetrics.
        The infrastructure used to deploy the Oracle Database.

        Allowed values for this property are: "ONPREMISE", "BM", "VM", "EXADATA", "EXADATA_CC", "AUTONOMOUS", "EXADATA_XS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The deployment_type of this DataguardMetrics.
        :rtype: str
        """
        return self._deployment_type

    @deployment_type.setter
    def deployment_type(self, deployment_type):
        """
        Sets the deployment_type of this DataguardMetrics.
        The infrastructure used to deploy the Oracle Database.


        :param deployment_type: The deployment_type of this DataguardMetrics.
        :type: str
        """
        allowed_values = ["ONPREMISE", "BM", "VM", "EXADATA", "EXADATA_CC", "AUTONOMOUS", "EXADATA_XS"]
        if not value_allowed_none_or_none_sentinel(deployment_type, allowed_values):
            deployment_type = 'UNKNOWN_ENUM_VALUE'
        self._deployment_type = deployment_type

    @property
    def database_version(self):
        """
        Gets the database_version of this DataguardMetrics.
        The Oracle Database version.


        :return: The database_version of this DataguardMetrics.
        :rtype: str
        """
        return self._database_version

    @database_version.setter
    def database_version(self, database_version):
        """
        Sets the database_version of this DataguardMetrics.
        The Oracle Database version.


        :param database_version: The database_version of this DataguardMetrics.
        :type: str
        """
        self._database_version = database_version

    @property
    def workload_type(self):
        """
        Gets the workload_type of this DataguardMetrics.
        The workload type of the Autonomous Database.

        Allowed values for this property are: "OLTP", "DW", "AJD", "APEX", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The workload_type of this DataguardMetrics.
        :rtype: str
        """
        return self._workload_type

    @workload_type.setter
    def workload_type(self, workload_type):
        """
        Sets the workload_type of this DataguardMetrics.
        The workload type of the Autonomous Database.


        :param workload_type: The workload_type of this DataguardMetrics.
        :type: str
        """
        allowed_values = ["OLTP", "DW", "AJD", "APEX"]
        if not value_allowed_none_or_none_sentinel(workload_type, allowed_values):
            workload_type = 'UNKNOWN_ENUM_VALUE'
        self._workload_type = workload_type

    @property
    def database_name(self):
        """
        **[Required]** Gets the database_name of this DataguardMetrics.
        The display name of the Managed Database.


        :return: The database_name of this DataguardMetrics.
        :rtype: str
        """
        return self._database_name

    @database_name.setter
    def database_name(self, database_name):
        """
        Sets the database_name of this DataguardMetrics.
        The display name of the Managed Database.


        :param database_name: The database_name of this DataguardMetrics.
        :type: str
        """
        self._database_name = database_name

    @property
    def database_id(self):
        """
        Gets the database_id of this DataguardMetrics.
        The database ID of the Managed Database. Every database had its own ID and that value is captured here.


        :return: The database_id of this DataguardMetrics.
        :rtype: str
        """
        return self._database_id

    @database_id.setter
    def database_id(self, database_id):
        """
        Sets the database_id of this DataguardMetrics.
        The database ID of the Managed Database. Every database had its own ID and that value is captured here.


        :param database_id: The database_id of this DataguardMetrics.
        :type: str
        """
        self._database_id = database_id

    @property
    def db_unique_name(self):
        """
        Gets the db_unique_name of this DataguardMetrics.
        The database unique name of the Managed Database.


        :return: The db_unique_name of this DataguardMetrics.
        :rtype: str
        """
        return self._db_unique_name

    @db_unique_name.setter
    def db_unique_name(self, db_unique_name):
        """
        Sets the db_unique_name of this DataguardMetrics.
        The database unique name of the Managed Database.


        :param db_unique_name: The db_unique_name of this DataguardMetrics.
        :type: str
        """
        self._db_unique_name = db_unique_name

    @property
    def db_role(self):
        """
        **[Required]** Gets the db_role of this DataguardMetrics.
        The database role of the Managed Database.

        Allowed values for this property are: "SNAPSHOT_STANDBY", "LOGICAL_STANDBY", "PHYSICAL_STANDBY", "PRIMARY", "FAR_SYNC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The db_role of this DataguardMetrics.
        :rtype: str
        """
        return self._db_role

    @db_role.setter
    def db_role(self, db_role):
        """
        Sets the db_role of this DataguardMetrics.
        The database role of the Managed Database.


        :param db_role: The db_role of this DataguardMetrics.
        :type: str
        """
        allowed_values = ["SNAPSHOT_STANDBY", "LOGICAL_STANDBY", "PHYSICAL_STANDBY", "PRIMARY", "FAR_SYNC"]
        if not value_allowed_none_or_none_sentinel(db_role, allowed_values):
            db_role = 'UNKNOWN_ENUM_VALUE'
        self._db_role = db_role

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
