# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManagedMySqlDatabaseOutboundReplicationCollection(object):
    """
    The collection of outbound replication records of a MySQL server.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ManagedMySqlDatabaseOutboundReplicationCollection object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param outbound_replications_count:
            The value to assign to the outbound_replications_count property of this ManagedMySqlDatabaseOutboundReplicationCollection.
        :type outbound_replications_count: int

        :param items:
            The value to assign to the items property of this ManagedMySqlDatabaseOutboundReplicationCollection.
        :type items: list[oci.database_management.models.ManagedMySqlDatabaseOutboundReplicationSummary]

        """
        self.swagger_types = {
            'outbound_replications_count': 'int',
            'items': 'list[ManagedMySqlDatabaseOutboundReplicationSummary]'
        }
        self.attribute_map = {
            'outbound_replications_count': 'outboundReplicationsCount',
            'items': 'items'
        }
        self._outbound_replications_count = None
        self._items = None

    @property
    def outbound_replications_count(self):
        """
        Gets the outbound_replications_count of this ManagedMySqlDatabaseOutboundReplicationCollection.
        The number of outbound replications from the MySQL server.


        :return: The outbound_replications_count of this ManagedMySqlDatabaseOutboundReplicationCollection.
        :rtype: int
        """
        return self._outbound_replications_count

    @outbound_replications_count.setter
    def outbound_replications_count(self, outbound_replications_count):
        """
        Sets the outbound_replications_count of this ManagedMySqlDatabaseOutboundReplicationCollection.
        The number of outbound replications from the MySQL server.


        :param outbound_replications_count: The outbound_replications_count of this ManagedMySqlDatabaseOutboundReplicationCollection.
        :type: int
        """
        self._outbound_replications_count = outbound_replications_count

    @property
    def items(self):
        """
        **[Required]** Gets the items of this ManagedMySqlDatabaseOutboundReplicationCollection.
        The list of ManagedMySqlDatabaseOutboundReplicationSummary records.


        :return: The items of this ManagedMySqlDatabaseOutboundReplicationCollection.
        :rtype: list[oci.database_management.models.ManagedMySqlDatabaseOutboundReplicationSummary]
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this ManagedMySqlDatabaseOutboundReplicationCollection.
        The list of ManagedMySqlDatabaseOutboundReplicationSummary records.


        :param items: The items of this ManagedMySqlDatabaseOutboundReplicationCollection.
        :type: list[oci.database_management.models.ManagedMySqlDatabaseOutboundReplicationSummary]
        """
        self._items = items

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
