# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201005

from .validate_database_tools_identity_credential_result import ValidateDatabaseToolsIdentityCredentialResult
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ValidateDatabaseToolsIdentityCredentialOracleDatabaseResourcePrincipalResult(ValidateDatabaseToolsIdentityCredentialResult):
    """
    The Database Tools identity validate credentials result for the Oracle Database resource principal identity type.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ValidateDatabaseToolsIdentityCredentialOracleDatabaseResourcePrincipalResult object with values from keyword arguments. The default value of the :py:attr:`~oci.database_tools.models.ValidateDatabaseToolsIdentityCredentialOracleDatabaseResourcePrincipalResult.type` attribute
        of this class is ``ORACLE_DATABASE_RESOURCE_PRINCIPAL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ValidateDatabaseToolsIdentityCredentialOracleDatabaseResourcePrincipalResult.
            Allowed values for this property are: "ORACLE_DATABASE_RESOURCE_PRINCIPAL"
        :type type: str

        :param code:
            The value to assign to the code property of this ValidateDatabaseToolsIdentityCredentialOracleDatabaseResourcePrincipalResult.
        :type code: str

        :param message:
            The value to assign to the message property of this ValidateDatabaseToolsIdentityCredentialOracleDatabaseResourcePrincipalResult.
        :type message: str

        :param cause:
            The value to assign to the cause property of this ValidateDatabaseToolsIdentityCredentialOracleDatabaseResourcePrincipalResult.
        :type cause: str

        :param action:
            The value to assign to the action property of this ValidateDatabaseToolsIdentityCredentialOracleDatabaseResourcePrincipalResult.
        :type action: str

        """
        self.swagger_types = {
            'type': 'str',
            'code': 'str',
            'message': 'str',
            'cause': 'str',
            'action': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'code': 'code',
            'message': 'message',
            'cause': 'cause',
            'action': 'action'
        }
        self._type = None
        self._code = None
        self._message = None
        self._cause = None
        self._action = None
        self._type = 'ORACLE_DATABASE_RESOURCE_PRINCIPAL'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
