# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OracleDbGcpIdentityConnector(object):
    """
    This resource is used to create and manage a GCP Identity Connector for Oracle Database running on Oracle Exadata Database Service on Dedicated Infrastructure (ExaDB-D).
    The Identity Connector enables secure communication between Oracle Cloud and Google Cloud services.
    """

    #: A constant which can be used with the gcp_identity_connectivity_status property of a OracleDbGcpIdentityConnector.
    #: This constant has a value of "CONNECTED"
    GCP_IDENTITY_CONNECTIVITY_STATUS_CONNECTED = "CONNECTED"

    #: A constant which can be used with the gcp_identity_connectivity_status property of a OracleDbGcpIdentityConnector.
    #: This constant has a value of "DISCONNECTED"
    GCP_IDENTITY_CONNECTIVITY_STATUS_DISCONNECTED = "DISCONNECTED"

    #: A constant which can be used with the gcp_identity_connectivity_status property of a OracleDbGcpIdentityConnector.
    #: This constant has a value of "PARTIALLY_CONNECTED"
    GCP_IDENTITY_CONNECTIVITY_STATUS_PARTIALLY_CONNECTED = "PARTIALLY_CONNECTED"

    #: A constant which can be used with the gcp_identity_connectivity_status property of a OracleDbGcpIdentityConnector.
    #: This constant has a value of "UNKNOWN"
    GCP_IDENTITY_CONNECTIVITY_STATUS_UNKNOWN = "UNKNOWN"

    #: A constant which can be used with the lifecycle_state property of a OracleDbGcpIdentityConnector.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a OracleDbGcpIdentityConnector.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a OracleDbGcpIdentityConnector.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a OracleDbGcpIdentityConnector.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a OracleDbGcpIdentityConnector.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a OracleDbGcpIdentityConnector.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new OracleDbGcpIdentityConnector object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OracleDbGcpIdentityConnector.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this OracleDbGcpIdentityConnector.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this OracleDbGcpIdentityConnector.
        :type compartment_id: str

        :param issuer_url:
            The value to assign to the issuer_url property of this OracleDbGcpIdentityConnector.
        :type issuer_url: str

        :param project_id:
            The value to assign to the project_id property of this OracleDbGcpIdentityConnector.
        :type project_id: str

        :param resource_id:
            The value to assign to the resource_id property of this OracleDbGcpIdentityConnector.
        :type resource_id: str

        :param gcp_location:
            The value to assign to the gcp_location property of this OracleDbGcpIdentityConnector.
        :type gcp_location: str

        :param gcp_workload_identity_pool_id:
            The value to assign to the gcp_workload_identity_pool_id property of this OracleDbGcpIdentityConnector.
        :type gcp_workload_identity_pool_id: str

        :param gcp_workload_identity_provider_id:
            The value to assign to the gcp_workload_identity_provider_id property of this OracleDbGcpIdentityConnector.
        :type gcp_workload_identity_provider_id: str

        :param gcp_resource_service_agent_id:
            The value to assign to the gcp_resource_service_agent_id property of this OracleDbGcpIdentityConnector.
        :type gcp_resource_service_agent_id: str

        :param gcp_nodes:
            The value to assign to the gcp_nodes property of this OracleDbGcpIdentityConnector.
        :type gcp_nodes: list[oci.dbmulticloud.models.GcpNodes]

        :param gcp_identity_connectivity_status:
            The value to assign to the gcp_identity_connectivity_status property of this OracleDbGcpIdentityConnector.
            Allowed values for this property are: "CONNECTED", "DISCONNECTED", "PARTIALLY_CONNECTED", "UNKNOWN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type gcp_identity_connectivity_status: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OracleDbGcpIdentityConnector.
            Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_state_details:
            The value to assign to the lifecycle_state_details property of this OracleDbGcpIdentityConnector.
        :type lifecycle_state_details: str

        :param time_created:
            The value to assign to the time_created property of this OracleDbGcpIdentityConnector.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this OracleDbGcpIdentityConnector.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this OracleDbGcpIdentityConnector.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this OracleDbGcpIdentityConnector.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this OracleDbGcpIdentityConnector.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'issuer_url': 'str',
            'project_id': 'str',
            'resource_id': 'str',
            'gcp_location': 'str',
            'gcp_workload_identity_pool_id': 'str',
            'gcp_workload_identity_provider_id': 'str',
            'gcp_resource_service_agent_id': 'str',
            'gcp_nodes': 'list[GcpNodes]',
            'gcp_identity_connectivity_status': 'str',
            'lifecycle_state': 'str',
            'lifecycle_state_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'issuer_url': 'issuerUrl',
            'project_id': 'projectId',
            'resource_id': 'resourceId',
            'gcp_location': 'gcpLocation',
            'gcp_workload_identity_pool_id': 'gcpWorkloadIdentityPoolId',
            'gcp_workload_identity_provider_id': 'gcpWorkloadIdentityProviderId',
            'gcp_resource_service_agent_id': 'gcpResourceServiceAgentId',
            'gcp_nodes': 'gcpNodes',
            'gcp_identity_connectivity_status': 'gcpIdentityConnectivityStatus',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_state_details': 'lifecycleStateDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._issuer_url = None
        self._project_id = None
        self._resource_id = None
        self._gcp_location = None
        self._gcp_workload_identity_pool_id = None
        self._gcp_workload_identity_provider_id = None
        self._gcp_resource_service_agent_id = None
        self._gcp_nodes = None
        self._gcp_identity_connectivity_status = None
        self._lifecycle_state = None
        self._lifecycle_state_details = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this OracleDbGcpIdentityConnector.
        The `OCID`__ of the Oracle DB GCP Identity Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this OracleDbGcpIdentityConnector.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OracleDbGcpIdentityConnector.
        The `OCID`__ of the Oracle DB GCP Identity Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this OracleDbGcpIdentityConnector.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this OracleDbGcpIdentityConnector.
        Oracle DB GCP Identity Connector resource name.


        :return: The display_name of this OracleDbGcpIdentityConnector.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this OracleDbGcpIdentityConnector.
        Oracle DB GCP Identity Connector resource name.


        :param display_name: The display_name of this OracleDbGcpIdentityConnector.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this OracleDbGcpIdentityConnector.
        The `OCID`__ of the compartment that contains the Oracle DB GCP Identity Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this OracleDbGcpIdentityConnector.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this OracleDbGcpIdentityConnector.
        The `OCID`__ of the compartment that contains the Oracle DB GCP Identity Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this OracleDbGcpIdentityConnector.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def issuer_url(self):
        """
        **[Required]** Gets the issuer_url of this OracleDbGcpIdentityConnector.
        OIDC token issuer Url.


        :return: The issuer_url of this OracleDbGcpIdentityConnector.
        :rtype: str
        """
        return self._issuer_url

    @issuer_url.setter
    def issuer_url(self, issuer_url):
        """
        Sets the issuer_url of this OracleDbGcpIdentityConnector.
        OIDC token issuer Url.


        :param issuer_url: The issuer_url of this OracleDbGcpIdentityConnector.
        :type: str
        """
        self._issuer_url = issuer_url

    @property
    def project_id(self):
        """
        **[Required]** Gets the project_id of this OracleDbGcpIdentityConnector.
        Project id of the customer project.


        :return: The project_id of this OracleDbGcpIdentityConnector.
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """
        Sets the project_id of this OracleDbGcpIdentityConnector.
        Project id of the customer project.


        :param project_id: The project_id of this OracleDbGcpIdentityConnector.
        :type: str
        """
        self._project_id = project_id

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this OracleDbGcpIdentityConnector.
        The `OCID`__ of the GCP VM Cluster resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The resource_id of this OracleDbGcpIdentityConnector.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this OracleDbGcpIdentityConnector.
        The `OCID`__ of the GCP VM Cluster resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param resource_id: The resource_id of this OracleDbGcpIdentityConnector.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def gcp_location(self):
        """
        **[Required]** Gets the gcp_location of this OracleDbGcpIdentityConnector.
        GCP Location.


        :return: The gcp_location of this OracleDbGcpIdentityConnector.
        :rtype: str
        """
        return self._gcp_location

    @gcp_location.setter
    def gcp_location(self, gcp_location):
        """
        Sets the gcp_location of this OracleDbGcpIdentityConnector.
        GCP Location.


        :param gcp_location: The gcp_location of this OracleDbGcpIdentityConnector.
        :type: str
        """
        self._gcp_location = gcp_location

    @property
    def gcp_workload_identity_pool_id(self):
        """
        **[Required]** Gets the gcp_workload_identity_pool_id of this OracleDbGcpIdentityConnector.
        The ID of the cloud GCP Workload Identity Pool.


        :return: The gcp_workload_identity_pool_id of this OracleDbGcpIdentityConnector.
        :rtype: str
        """
        return self._gcp_workload_identity_pool_id

    @gcp_workload_identity_pool_id.setter
    def gcp_workload_identity_pool_id(self, gcp_workload_identity_pool_id):
        """
        Sets the gcp_workload_identity_pool_id of this OracleDbGcpIdentityConnector.
        The ID of the cloud GCP Workload Identity Pool.


        :param gcp_workload_identity_pool_id: The gcp_workload_identity_pool_id of this OracleDbGcpIdentityConnector.
        :type: str
        """
        self._gcp_workload_identity_pool_id = gcp_workload_identity_pool_id

    @property
    def gcp_workload_identity_provider_id(self):
        """
        **[Required]** Gets the gcp_workload_identity_provider_id of this OracleDbGcpIdentityConnector.
        The ID of the GCP Workload Identity Provider.


        :return: The gcp_workload_identity_provider_id of this OracleDbGcpIdentityConnector.
        :rtype: str
        """
        return self._gcp_workload_identity_provider_id

    @gcp_workload_identity_provider_id.setter
    def gcp_workload_identity_provider_id(self, gcp_workload_identity_provider_id):
        """
        Sets the gcp_workload_identity_provider_id of this OracleDbGcpIdentityConnector.
        The ID of the GCP Workload Identity Provider.


        :param gcp_workload_identity_provider_id: The gcp_workload_identity_provider_id of this OracleDbGcpIdentityConnector.
        :type: str
        """
        self._gcp_workload_identity_provider_id = gcp_workload_identity_provider_id

    @property
    def gcp_resource_service_agent_id(self):
        """
        **[Required]** Gets the gcp_resource_service_agent_id of this OracleDbGcpIdentityConnector.
        The ID of the GCP resource service agent.


        :return: The gcp_resource_service_agent_id of this OracleDbGcpIdentityConnector.
        :rtype: str
        """
        return self._gcp_resource_service_agent_id

    @gcp_resource_service_agent_id.setter
    def gcp_resource_service_agent_id(self, gcp_resource_service_agent_id):
        """
        Sets the gcp_resource_service_agent_id of this OracleDbGcpIdentityConnector.
        The ID of the GCP resource service agent.


        :param gcp_resource_service_agent_id: The gcp_resource_service_agent_id of this OracleDbGcpIdentityConnector.
        :type: str
        """
        self._gcp_resource_service_agent_id = gcp_resource_service_agent_id

    @property
    def gcp_nodes(self):
        """
        Gets the gcp_nodes of this OracleDbGcpIdentityConnector.
        List of All VMs where GCP Identity Connector is configured for this VMCluster.


        :return: The gcp_nodes of this OracleDbGcpIdentityConnector.
        :rtype: list[oci.dbmulticloud.models.GcpNodes]
        """
        return self._gcp_nodes

    @gcp_nodes.setter
    def gcp_nodes(self, gcp_nodes):
        """
        Sets the gcp_nodes of this OracleDbGcpIdentityConnector.
        List of All VMs where GCP Identity Connector is configured for this VMCluster.


        :param gcp_nodes: The gcp_nodes of this OracleDbGcpIdentityConnector.
        :type: list[oci.dbmulticloud.models.GcpNodes]
        """
        self._gcp_nodes = gcp_nodes

    @property
    def gcp_identity_connectivity_status(self):
        """
        Gets the gcp_identity_connectivity_status of this OracleDbGcpIdentityConnector.
        The current Connectivity status of GCP Identity Connector resource.

        Allowed values for this property are: "CONNECTED", "DISCONNECTED", "PARTIALLY_CONNECTED", "UNKNOWN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The gcp_identity_connectivity_status of this OracleDbGcpIdentityConnector.
        :rtype: str
        """
        return self._gcp_identity_connectivity_status

    @gcp_identity_connectivity_status.setter
    def gcp_identity_connectivity_status(self, gcp_identity_connectivity_status):
        """
        Sets the gcp_identity_connectivity_status of this OracleDbGcpIdentityConnector.
        The current Connectivity status of GCP Identity Connector resource.


        :param gcp_identity_connectivity_status: The gcp_identity_connectivity_status of this OracleDbGcpIdentityConnector.
        :type: str
        """
        allowed_values = ["CONNECTED", "DISCONNECTED", "PARTIALLY_CONNECTED", "UNKNOWN"]
        if not value_allowed_none_or_none_sentinel(gcp_identity_connectivity_status, allowed_values):
            gcp_identity_connectivity_status = 'UNKNOWN_ENUM_VALUE'
        self._gcp_identity_connectivity_status = gcp_identity_connectivity_status

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this OracleDbGcpIdentityConnector.
        The current lifecycle state of the GCP Identity Connector resource.

        Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this OracleDbGcpIdentityConnector.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this OracleDbGcpIdentityConnector.
        The current lifecycle state of the GCP Identity Connector resource.


        :param lifecycle_state: The lifecycle_state of this OracleDbGcpIdentityConnector.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_state_details(self):
        """
        Gets the lifecycle_state_details of this OracleDbGcpIdentityConnector.
        Description of the current lifecycle state in more detail.


        :return: The lifecycle_state_details of this OracleDbGcpIdentityConnector.
        :rtype: str
        """
        return self._lifecycle_state_details

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, lifecycle_state_details):
        """
        Sets the lifecycle_state_details of this OracleDbGcpIdentityConnector.
        Description of the current lifecycle state in more detail.


        :param lifecycle_state_details: The lifecycle_state_details of this OracleDbGcpIdentityConnector.
        :type: str
        """
        self._lifecycle_state_details = lifecycle_state_details

    @property
    def time_created(self):
        """
        Gets the time_created of this OracleDbGcpIdentityConnector.
        Time when the Oracle DB GCP Identity Connector resource was created expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this OracleDbGcpIdentityConnector.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this OracleDbGcpIdentityConnector.
        Time when the Oracle DB GCP Identity Connector resource was created expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this OracleDbGcpIdentityConnector.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this OracleDbGcpIdentityConnector.
        Time when the Oracle DB GCP Identity Connector resource was last modified expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this OracleDbGcpIdentityConnector.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this OracleDbGcpIdentityConnector.
        Time when the Oracle DB GCP Identity Connector resource was last modified expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this OracleDbGcpIdentityConnector.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this OracleDbGcpIdentityConnector.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this OracleDbGcpIdentityConnector.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this OracleDbGcpIdentityConnector.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this OracleDbGcpIdentityConnector.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this OracleDbGcpIdentityConnector.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this OracleDbGcpIdentityConnector.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this OracleDbGcpIdentityConnector.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this OracleDbGcpIdentityConnector.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this OracleDbGcpIdentityConnector.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this OracleDbGcpIdentityConnector.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this OracleDbGcpIdentityConnector.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this OracleDbGcpIdentityConnector.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
