# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220618


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDesktopPoolPrivateAccessDetails(object):
    """
    The details of the desktop's private access network connectivity to be set up for the desktop pool.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDesktopPoolPrivateAccessDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param subnet_id:
            The value to assign to the subnet_id property of this CreateDesktopPoolPrivateAccessDetails.
        :type subnet_id: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this CreateDesktopPoolPrivateAccessDetails.
        :type nsg_ids: list[str]

        :param private_ip:
            The value to assign to the private_ip property of this CreateDesktopPoolPrivateAccessDetails.
        :type private_ip: str

        """
        self.swagger_types = {
            'subnet_id': 'str',
            'nsg_ids': 'list[str]',
            'private_ip': 'str'
        }
        self.attribute_map = {
            'subnet_id': 'subnetId',
            'nsg_ids': 'nsgIds',
            'private_ip': 'privateIp'
        }
        self._subnet_id = None
        self._nsg_ids = None
        self._private_ip = None

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this CreateDesktopPoolPrivateAccessDetails.
        The `OCID`__ of the subnet in the customer VCN where the
        connectivity will be established.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this CreateDesktopPoolPrivateAccessDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreateDesktopPoolPrivateAccessDetails.
        The `OCID`__ of the subnet in the customer VCN where the
        connectivity will be established.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this CreateDesktopPoolPrivateAccessDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this CreateDesktopPoolPrivateAccessDetails.
        A list of network security groups for the private access.


        :return: The nsg_ids of this CreateDesktopPoolPrivateAccessDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this CreateDesktopPoolPrivateAccessDetails.
        A list of network security groups for the private access.


        :param nsg_ids: The nsg_ids of this CreateDesktopPoolPrivateAccessDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def private_ip(self):
        """
        Gets the private_ip of this CreateDesktopPoolPrivateAccessDetails.
        The IPv4 address from the provided OCI subnet which needs to be assigned to the VNIC. If not provided, it will
        be auto-assigned with an available IPv4 address from the subnet.


        :return: The private_ip of this CreateDesktopPoolPrivateAccessDetails.
        :rtype: str
        """
        return self._private_ip

    @private_ip.setter
    def private_ip(self, private_ip):
        """
        Sets the private_ip of this CreateDesktopPoolPrivateAccessDetails.
        The IPv4 address from the provided OCI subnet which needs to be assigned to the VNIC. If not provided, it will
        be auto-assigned with an available IPv4 address from the subnet.


        :param private_ip: The private_ip of this CreateDesktopPoolPrivateAccessDetails.
        :type: str
        """
        self._private_ip = private_ip

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
