# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SourceVolumeToDestinationEncryptionKeyMapping(object):
    """
    The source volume ID to destination customer managed vault and encryption key ID mapping for a volume group.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SourceVolumeToDestinationEncryptionKeyMapping object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_volume_id:
            The value to assign to the source_volume_id property of this SourceVolumeToDestinationEncryptionKeyMapping.
        :type source_volume_id: str

        :param destination_encryption_key:
            The value to assign to the destination_encryption_key property of this SourceVolumeToDestinationEncryptionKeyMapping.
        :type destination_encryption_key: oci.disaster_recovery.models.VaultAndEncryptionKey

        """
        self.swagger_types = {
            'source_volume_id': 'str',
            'destination_encryption_key': 'VaultAndEncryptionKey'
        }
        self.attribute_map = {
            'source_volume_id': 'sourceVolumeId',
            'destination_encryption_key': 'destinationEncryptionKey'
        }
        self._source_volume_id = None
        self._destination_encryption_key = None

    @property
    def source_volume_id(self):
        """
        **[Required]** Gets the source_volume_id of this SourceVolumeToDestinationEncryptionKeyMapping.
        The OCID of the source boot volume or block volume.

         Example: `ocid1.volume.oc1..uniqueID`


        :return: The source_volume_id of this SourceVolumeToDestinationEncryptionKeyMapping.
        :rtype: str
        """
        return self._source_volume_id

    @source_volume_id.setter
    def source_volume_id(self, source_volume_id):
        """
        Sets the source_volume_id of this SourceVolumeToDestinationEncryptionKeyMapping.
        The OCID of the source boot volume or block volume.

         Example: `ocid1.volume.oc1..uniqueID`


        :param source_volume_id: The source_volume_id of this SourceVolumeToDestinationEncryptionKeyMapping.
        :type: str
        """
        self._source_volume_id = source_volume_id

    @property
    def destination_encryption_key(self):
        """
        **[Required]** Gets the destination_encryption_key of this SourceVolumeToDestinationEncryptionKeyMapping.

        :return: The destination_encryption_key of this SourceVolumeToDestinationEncryptionKeyMapping.
        :rtype: oci.disaster_recovery.models.VaultAndEncryptionKey
        """
        return self._destination_encryption_key

    @destination_encryption_key.setter
    def destination_encryption_key(self, destination_encryption_key):
        """
        Sets the destination_encryption_key of this SourceVolumeToDestinationEncryptionKeyMapping.

        :param destination_encryption_key: The destination_encryption_key of this SourceVolumeToDestinationEncryptionKeyMapping.
        :type: oci.disaster_recovery.models.VaultAndEncryptionKey
        """
        self._destination_encryption_key = destination_encryption_key

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
