# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20171215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KerberosKeytabEntry(object):
    """
    Details of each keytab entry read from the keytab file.
    """

    #: A constant which can be used with the encryption_type property of a KerberosKeytabEntry.
    #: This constant has a value of "AES128_CTS_HMAC_SHA256_128"
    ENCRYPTION_TYPE_AES128_CTS_HMAC_SHA256_128 = "AES128_CTS_HMAC_SHA256_128"

    #: A constant which can be used with the encryption_type property of a KerberosKeytabEntry.
    #: This constant has a value of "AES256_CTS_HMAC_SHA384_192"
    ENCRYPTION_TYPE_AES256_CTS_HMAC_SHA384_192 = "AES256_CTS_HMAC_SHA384_192"

    #: A constant which can be used with the encryption_type property of a KerberosKeytabEntry.
    #: This constant has a value of "AES128_CTS_HMAC_SHA1_96"
    ENCRYPTION_TYPE_AES128_CTS_HMAC_SHA1_96 = "AES128_CTS_HMAC_SHA1_96"

    #: A constant which can be used with the encryption_type property of a KerberosKeytabEntry.
    #: This constant has a value of "AES256_CTS_HMAC_SHA1_96"
    ENCRYPTION_TYPE_AES256_CTS_HMAC_SHA1_96 = "AES256_CTS_HMAC_SHA1_96"

    def __init__(self, **kwargs):
        """
        Initializes a new KerberosKeytabEntry object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param principal:
            The value to assign to the principal property of this KerberosKeytabEntry.
        :type principal: str

        :param encryption_type:
            The value to assign to the encryption_type property of this KerberosKeytabEntry.
            Allowed values for this property are: "AES128_CTS_HMAC_SHA256_128", "AES256_CTS_HMAC_SHA384_192", "AES128_CTS_HMAC_SHA1_96", "AES256_CTS_HMAC_SHA1_96", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type encryption_type: str

        :param key_version_number:
            The value to assign to the key_version_number property of this KerberosKeytabEntry.
        :type key_version_number: int

        """
        self.swagger_types = {
            'principal': 'str',
            'encryption_type': 'str',
            'key_version_number': 'int'
        }
        self.attribute_map = {
            'principal': 'principal',
            'encryption_type': 'encryptionType',
            'key_version_number': 'keyVersionNumber'
        }
        self._principal = None
        self._encryption_type = None
        self._key_version_number = None

    @property
    def principal(self):
        """
        **[Required]** Gets the principal of this KerberosKeytabEntry.
        Keytab principal.


        :return: The principal of this KerberosKeytabEntry.
        :rtype: str
        """
        return self._principal

    @principal.setter
    def principal(self, principal):
        """
        Sets the principal of this KerberosKeytabEntry.
        Keytab principal.


        :param principal: The principal of this KerberosKeytabEntry.
        :type: str
        """
        self._principal = principal

    @property
    def encryption_type(self):
        """
        **[Required]** Gets the encryption_type of this KerberosKeytabEntry.
        Encryption type with with keytab was generated.
        Secure: aes128-cts-hmac-sha256-128
        Secure: aes256-cts-hmac-sha384-192
        Less Secure: aes128-cts-hmac-sha1-96
        Less Secure: aes256-cts-hmac-sha1-96

        Allowed values for this property are: "AES128_CTS_HMAC_SHA256_128", "AES256_CTS_HMAC_SHA384_192", "AES128_CTS_HMAC_SHA1_96", "AES256_CTS_HMAC_SHA1_96", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The encryption_type of this KerberosKeytabEntry.
        :rtype: str
        """
        return self._encryption_type

    @encryption_type.setter
    def encryption_type(self, encryption_type):
        """
        Sets the encryption_type of this KerberosKeytabEntry.
        Encryption type with with keytab was generated.
        Secure: aes128-cts-hmac-sha256-128
        Secure: aes256-cts-hmac-sha384-192
        Less Secure: aes128-cts-hmac-sha1-96
        Less Secure: aes256-cts-hmac-sha1-96


        :param encryption_type: The encryption_type of this KerberosKeytabEntry.
        :type: str
        """
        allowed_values = ["AES128_CTS_HMAC_SHA256_128", "AES256_CTS_HMAC_SHA384_192", "AES128_CTS_HMAC_SHA1_96", "AES256_CTS_HMAC_SHA1_96"]
        if not value_allowed_none_or_none_sentinel(encryption_type, allowed_values):
            encryption_type = 'UNKNOWN_ENUM_VALUE'
        self._encryption_type = encryption_type

    @property
    def key_version_number(self):
        """
        **[Required]** Gets the key_version_number of this KerberosKeytabEntry.
        Kerberos KVNO (key version number) for key in keytab entry.


        :return: The key_version_number of this KerberosKeytabEntry.
        :rtype: int
        """
        return self._key_version_number

    @key_version_number.setter
    def key_version_number(self, key_version_number):
        """
        Sets the key_version_number of this KerberosKeytabEntry.
        Kerberos KVNO (key version number) for key in keytab entry.


        :param key_version_number: The key_version_number of this KerberosKeytabEntry.
        :type: int
        """
        self._key_version_number = key_version_number

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
