# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CatalogItem(object):
    """
    A description of a CatalogItem resource.

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to
    an administrator. If you're an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm
    """

    #: A constant which can be used with the config_source_type property of a CatalogItem.
    #: This constant has a value of "PAR_CATALOG_SOURCE"
    CONFIG_SOURCE_TYPE_PAR_CATALOG_SOURCE = "PAR_CATALOG_SOURCE"

    #: A constant which can be used with the config_source_type property of a CatalogItem.
    #: This constant has a value of "GIT_CATALOG_SOURCE"
    CONFIG_SOURCE_TYPE_GIT_CATALOG_SOURCE = "GIT_CATALOG_SOURCE"

    #: A constant which can be used with the config_source_type property of a CatalogItem.
    #: This constant has a value of "MARKETPLACE_CATALOG_SOURCE"
    CONFIG_SOURCE_TYPE_MARKETPLACE_CATALOG_SOURCE = "MARKETPLACE_CATALOG_SOURCE"

    #: A constant which can be used with the config_source_type property of a CatalogItem.
    #: This constant has a value of "STACK_TEMPLATE_CATALOG_SOURCE"
    CONFIG_SOURCE_TYPE_STACK_TEMPLATE_CATALOG_SOURCE = "STACK_TEMPLATE_CATALOG_SOURCE"

    #: A constant which can be used with the package_type property of a CatalogItem.
    #: This constant has a value of "TF_PACKAGE"
    PACKAGE_TYPE_TF_PACKAGE = "TF_PACKAGE"

    #: A constant which can be used with the package_type property of a CatalogItem.
    #: This constant has a value of "NON_TF_PACKAGE"
    PACKAGE_TYPE_NON_TF_PACKAGE = "NON_TF_PACKAGE"

    #: A constant which can be used with the package_type property of a CatalogItem.
    #: This constant has a value of "CONFIG_FILE"
    PACKAGE_TYPE_CONFIG_FILE = "CONFIG_FILE"

    #: A constant which can be used with the lifecycle_state property of a CatalogItem.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a CatalogItem.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a CatalogItem.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a CatalogItem.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a CatalogItem.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a CatalogItem.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new CatalogItem object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CatalogItem.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CatalogItem.
        :type compartment_id: str

        :param config_source_type:
            The value to assign to the config_source_type property of this CatalogItem.
            Allowed values for this property are: "PAR_CATALOG_SOURCE", "GIT_CATALOG_SOURCE", "MARKETPLACE_CATALOG_SOURCE", "STACK_TEMPLATE_CATALOG_SOURCE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type config_source_type: str

        :param should_list_public_items:
            The value to assign to the should_list_public_items property of this CatalogItem.
        :type should_list_public_items: bool

        :param description:
            The value to assign to the description property of this CatalogItem.
        :type description: str

        :param catalog_source_payload:
            The value to assign to the catalog_source_payload property of this CatalogItem.
        :type catalog_source_payload: oci.fleet_apps_management.models.CatalogSourcePayload

        :param catalog_result_payload:
            The value to assign to the catalog_result_payload property of this CatalogItem.
        :type catalog_result_payload: oci.fleet_apps_management.models.CatalogResultPayload

        :param listing_id:
            The value to assign to the listing_id property of this CatalogItem.
        :type listing_id: str

        :param listing_version:
            The value to assign to the listing_version property of this CatalogItem.
        :type listing_version: str

        :param display_name:
            The value to assign to the display_name property of this CatalogItem.
        :type display_name: str

        :param version_description:
            The value to assign to the version_description property of this CatalogItem.
        :type version_description: str

        :param short_description:
            The value to assign to the short_description property of this CatalogItem.
        :type short_description: str

        :param package_type:
            The value to assign to the package_type property of this CatalogItem.
            Allowed values for this property are: "TF_PACKAGE", "NON_TF_PACKAGE", "CONFIG_FILE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type package_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this CatalogItem.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this CatalogItem.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this CatalogItem.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this CatalogItem.
        :type time_updated: datetime

        :param time_released:
            The value to assign to the time_released property of this CatalogItem.
        :type time_released: datetime

        :param time_backfill_last_checked:
            The value to assign to the time_backfill_last_checked property of this CatalogItem.
        :type time_backfill_last_checked: datetime

        :param time_last_checked:
            The value to assign to the time_last_checked property of this CatalogItem.
        :type time_last_checked: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CatalogItem.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CatalogItem.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this CatalogItem.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'config_source_type': 'str',
            'should_list_public_items': 'bool',
            'description': 'str',
            'catalog_source_payload': 'CatalogSourcePayload',
            'catalog_result_payload': 'CatalogResultPayload',
            'listing_id': 'str',
            'listing_version': 'str',
            'display_name': 'str',
            'version_description': 'str',
            'short_description': 'str',
            'package_type': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'time_released': 'datetime',
            'time_backfill_last_checked': 'datetime',
            'time_last_checked': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'config_source_type': 'configSourceType',
            'should_list_public_items': 'shouldListPublicItems',
            'description': 'description',
            'catalog_source_payload': 'catalogSourcePayload',
            'catalog_result_payload': 'catalogResultPayload',
            'listing_id': 'listingId',
            'listing_version': 'listingVersion',
            'display_name': 'displayName',
            'version_description': 'versionDescription',
            'short_description': 'shortDescription',
            'package_type': 'packageType',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'time_released': 'timeReleased',
            'time_backfill_last_checked': 'timeBackfillLastChecked',
            'time_last_checked': 'timeLastChecked',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._config_source_type = None
        self._should_list_public_items = None
        self._description = None
        self._catalog_source_payload = None
        self._catalog_result_payload = None
        self._listing_id = None
        self._listing_version = None
        self._display_name = None
        self._version_description = None
        self._short_description = None
        self._package_type = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._time_released = None
        self._time_backfill_last_checked = None
        self._time_last_checked = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this CatalogItem.
        The `OCID`__ of the catalog.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this CatalogItem.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CatalogItem.
        The `OCID`__ of the catalog.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this CatalogItem.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CatalogItem.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CatalogItem.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CatalogItem.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CatalogItem.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def config_source_type(self):
        """
        **[Required]** Gets the config_source_type of this CatalogItem.
        Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.

        Allowed values for this property are: "PAR_CATALOG_SOURCE", "GIT_CATALOG_SOURCE", "MARKETPLACE_CATALOG_SOURCE", "STACK_TEMPLATE_CATALOG_SOURCE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The config_source_type of this CatalogItem.
        :rtype: str
        """
        return self._config_source_type

    @config_source_type.setter
    def config_source_type(self, config_source_type):
        """
        Sets the config_source_type of this CatalogItem.
        Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.


        :param config_source_type: The config_source_type of this CatalogItem.
        :type: str
        """
        allowed_values = ["PAR_CATALOG_SOURCE", "GIT_CATALOG_SOURCE", "MARKETPLACE_CATALOG_SOURCE", "STACK_TEMPLATE_CATALOG_SOURCE"]
        if not value_allowed_none_or_none_sentinel(config_source_type, allowed_values):
            config_source_type = 'UNKNOWN_ENUM_VALUE'
        self._config_source_type = config_source_type

    @property
    def should_list_public_items(self):
        """
        Gets the should_list_public_items of this CatalogItem.
        The indicator to append Public Items from the root compartment to any query, when set to TRUE.


        :return: The should_list_public_items of this CatalogItem.
        :rtype: bool
        """
        return self._should_list_public_items

    @should_list_public_items.setter
    def should_list_public_items(self, should_list_public_items):
        """
        Sets the should_list_public_items of this CatalogItem.
        The indicator to append Public Items from the root compartment to any query, when set to TRUE.


        :param should_list_public_items: The should_list_public_items of this CatalogItem.
        :type: bool
        """
        self._should_list_public_items = should_list_public_items

    @property
    def description(self):
        """
        **[Required]** Gets the description of this CatalogItem.
        Description about the catalog item.


        :return: The description of this CatalogItem.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CatalogItem.
        Description about the catalog item.


        :param description: The description of this CatalogItem.
        :type: str
        """
        self._description = description

    @property
    def catalog_source_payload(self):
        """
        Gets the catalog_source_payload of this CatalogItem.

        :return: The catalog_source_payload of this CatalogItem.
        :rtype: oci.fleet_apps_management.models.CatalogSourcePayload
        """
        return self._catalog_source_payload

    @catalog_source_payload.setter
    def catalog_source_payload(self, catalog_source_payload):
        """
        Sets the catalog_source_payload of this CatalogItem.

        :param catalog_source_payload: The catalog_source_payload of this CatalogItem.
        :type: oci.fleet_apps_management.models.CatalogSourcePayload
        """
        self._catalog_source_payload = catalog_source_payload

    @property
    def catalog_result_payload(self):
        """
        Gets the catalog_result_payload of this CatalogItem.

        :return: The catalog_result_payload of this CatalogItem.
        :rtype: oci.fleet_apps_management.models.CatalogResultPayload
        """
        return self._catalog_result_payload

    @catalog_result_payload.setter
    def catalog_result_payload(self, catalog_result_payload):
        """
        Sets the catalog_result_payload of this CatalogItem.

        :param catalog_result_payload: The catalog_result_payload of this CatalogItem.
        :type: oci.fleet_apps_management.models.CatalogResultPayload
        """
        self._catalog_result_payload = catalog_result_payload

    @property
    def listing_id(self):
        """
        **[Required]** Gets the listing_id of this CatalogItem.
        The catalog listing Id.


        :return: The listing_id of this CatalogItem.
        :rtype: str
        """
        return self._listing_id

    @listing_id.setter
    def listing_id(self, listing_id):
        """
        Sets the listing_id of this CatalogItem.
        The catalog listing Id.


        :param listing_id: The listing_id of this CatalogItem.
        :type: str
        """
        self._listing_id = listing_id

    @property
    def listing_version(self):
        """
        **[Required]** Gets the listing_version of this CatalogItem.
        The catalog package version.


        :return: The listing_version of this CatalogItem.
        :rtype: str
        """
        return self._listing_version

    @listing_version.setter
    def listing_version(self, listing_version):
        """
        Sets the listing_version of this CatalogItem.
        The catalog package version.


        :param listing_version: The listing_version of this CatalogItem.
        :type: str
        """
        self._listing_version = listing_version

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CatalogItem.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this CatalogItem.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CatalogItem.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this CatalogItem.
        :type: str
        """
        self._display_name = display_name

    @property
    def version_description(self):
        """
        Gets the version_description of this CatalogItem.
        Version description about the catalog item.


        :return: The version_description of this CatalogItem.
        :rtype: str
        """
        return self._version_description

    @version_description.setter
    def version_description(self, version_description):
        """
        Sets the version_description of this CatalogItem.
        Version description about the catalog item.


        :param version_description: The version_description of this CatalogItem.
        :type: str
        """
        self._version_description = version_description

    @property
    def short_description(self):
        """
        Gets the short_description of this CatalogItem.
        Short description about the catalog item.


        :return: The short_description of this CatalogItem.
        :rtype: str
        """
        return self._short_description

    @short_description.setter
    def short_description(self, short_description):
        """
        Sets the short_description of this CatalogItem.
        Short description about the catalog item.


        :param short_description: The short_description of this CatalogItem.
        :type: str
        """
        self._short_description = short_description

    @property
    def package_type(self):
        """
        **[Required]** Gets the package_type of this CatalogItem.
        Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.

        Allowed values for this property are: "TF_PACKAGE", "NON_TF_PACKAGE", "CONFIG_FILE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The package_type of this CatalogItem.
        :rtype: str
        """
        return self._package_type

    @package_type.setter
    def package_type(self, package_type):
        """
        Sets the package_type of this CatalogItem.
        Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.


        :param package_type: The package_type of this CatalogItem.
        :type: str
        """
        allowed_values = ["TF_PACKAGE", "NON_TF_PACKAGE", "CONFIG_FILE"]
        if not value_allowed_none_or_none_sentinel(package_type, allowed_values):
            package_type = 'UNKNOWN_ENUM_VALUE'
        self._package_type = package_type

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this CatalogItem.
        The current state of the CatalogItem.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this CatalogItem.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this CatalogItem.
        The current state of the CatalogItem.


        :param lifecycle_state: The lifecycle_state of this CatalogItem.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        **[Required]** Gets the lifecycle_details of this CatalogItem.
        The details of lifecycle state CatalogItem.


        :return: The lifecycle_details of this CatalogItem.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this CatalogItem.
        The details of lifecycle state CatalogItem.


        :param lifecycle_details: The lifecycle_details of this CatalogItem.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this CatalogItem.
        The date and time the CatalogItem was created, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this CatalogItem.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this CatalogItem.
        The date and time the CatalogItem was created, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this CatalogItem.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this CatalogItem.
        The date and time the CatalogItem was updated, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this CatalogItem.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this CatalogItem.
        The date and time the CatalogItem was updated, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this CatalogItem.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def time_released(self):
        """
        Gets the time_released of this CatalogItem.
        The date and time the CatalogItem was released, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_released of this CatalogItem.
        :rtype: datetime
        """
        return self._time_released

    @time_released.setter
    def time_released(self, time_released):
        """
        Sets the time_released of this CatalogItem.
        The date and time the CatalogItem was released, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_released: The time_released of this CatalogItem.
        :type: datetime
        """
        self._time_released = time_released

    @property
    def time_backfill_last_checked(self):
        """
        Gets the time_backfill_last_checked of this CatalogItem.
        The date and time the CatalogItem was last checked by backfill job, in the format defined by
        `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_backfill_last_checked of this CatalogItem.
        :rtype: datetime
        """
        return self._time_backfill_last_checked

    @time_backfill_last_checked.setter
    def time_backfill_last_checked(self, time_backfill_last_checked):
        """
        Sets the time_backfill_last_checked of this CatalogItem.
        The date and time the CatalogItem was last checked by backfill job, in the format defined by
        `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_backfill_last_checked: The time_backfill_last_checked of this CatalogItem.
        :type: datetime
        """
        self._time_backfill_last_checked = time_backfill_last_checked

    @property
    def time_last_checked(self):
        """
        Gets the time_last_checked of this CatalogItem.
        The date and time the CatalogItem was last checked, in the format defined by
        `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_last_checked of this CatalogItem.
        :rtype: datetime
        """
        return self._time_last_checked

    @time_last_checked.setter
    def time_last_checked(self, time_last_checked):
        """
        Sets the time_last_checked of this CatalogItem.
        The date and time the CatalogItem was last checked, in the format defined by
        `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_last_checked: The time_last_checked of this CatalogItem.
        :type: datetime
        """
        self._time_last_checked = time_last_checked

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CatalogItem.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CatalogItem.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CatalogItem.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CatalogItem.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CatalogItem.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CatalogItem.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CatalogItem.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CatalogItem.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this CatalogItem.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this CatalogItem.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this CatalogItem.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this CatalogItem.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
