# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .catalog_source_payload import CatalogSourcePayload
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CatalogParSourceConfig(CatalogSourcePayload):
    """
    Catalog par source config.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CatalogParSourceConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.CatalogParSourceConfig.config_source_type` attribute
        of this class is ``PAR_CATALOG_SOURCE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_source_type:
            The value to assign to the config_source_type property of this CatalogParSourceConfig.
        :type config_source_type: str

        :param working_directory:
            The value to assign to the working_directory property of this CatalogParSourceConfig.
        :type working_directory: str

        :param namespace_name:
            The value to assign to the namespace_name property of this CatalogParSourceConfig.
        :type namespace_name: str

        :param bucket_name:
            The value to assign to the bucket_name property of this CatalogParSourceConfig.
        :type bucket_name: str

        :param object_name:
            The value to assign to the object_name property of this CatalogParSourceConfig.
        :type object_name: str

        :param access_uri:
            The value to assign to the access_uri property of this CatalogParSourceConfig.
        :type access_uri: str

        :param time_expires:
            The value to assign to the time_expires property of this CatalogParSourceConfig.
        :type time_expires: datetime

        """
        self.swagger_types = {
            'config_source_type': 'str',
            'working_directory': 'str',
            'namespace_name': 'str',
            'bucket_name': 'str',
            'object_name': 'str',
            'access_uri': 'str',
            'time_expires': 'datetime'
        }
        self.attribute_map = {
            'config_source_type': 'configSourceType',
            'working_directory': 'workingDirectory',
            'namespace_name': 'namespaceName',
            'bucket_name': 'bucketName',
            'object_name': 'objectName',
            'access_uri': 'accessUri',
            'time_expires': 'timeExpires'
        }
        self._config_source_type = None
        self._working_directory = None
        self._namespace_name = None
        self._bucket_name = None
        self._object_name = None
        self._access_uri = None
        self._time_expires = None
        self._config_source_type = 'PAR_CATALOG_SOURCE'

    @property
    def namespace_name(self):
        """
        Gets the namespace_name of this CatalogParSourceConfig.
        nameSpace


        :return: The namespace_name of this CatalogParSourceConfig.
        :rtype: str
        """
        return self._namespace_name

    @namespace_name.setter
    def namespace_name(self, namespace_name):
        """
        Sets the namespace_name of this CatalogParSourceConfig.
        nameSpace


        :param namespace_name: The namespace_name of this CatalogParSourceConfig.
        :type: str
        """
        self._namespace_name = namespace_name

    @property
    def bucket_name(self):
        """
        Gets the bucket_name of this CatalogParSourceConfig.
        bucket name


        :return: The bucket_name of this CatalogParSourceConfig.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this CatalogParSourceConfig.
        bucket name


        :param bucket_name: The bucket_name of this CatalogParSourceConfig.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def object_name(self):
        """
        Gets the object_name of this CatalogParSourceConfig.
        object name


        :return: The object_name of this CatalogParSourceConfig.
        :rtype: str
        """
        return self._object_name

    @object_name.setter
    def object_name(self, object_name):
        """
        Sets the object_name of this CatalogParSourceConfig.
        object name


        :param object_name: The object_name of this CatalogParSourceConfig.
        :type: str
        """
        self._object_name = object_name

    @property
    def access_uri(self):
        """
        Gets the access_uri of this CatalogParSourceConfig.
        access uri


        :return: The access_uri of this CatalogParSourceConfig.
        :rtype: str
        """
        return self._access_uri

    @access_uri.setter
    def access_uri(self, access_uri):
        """
        Sets the access_uri of this CatalogParSourceConfig.
        access uri


        :param access_uri: The access_uri of this CatalogParSourceConfig.
        :type: str
        """
        self._access_uri = access_uri

    @property
    def time_expires(self):
        """
        Gets the time_expires of this CatalogParSourceConfig.
        The date and time expires, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_expires of this CatalogParSourceConfig.
        :rtype: datetime
        """
        return self._time_expires

    @time_expires.setter
    def time_expires(self, time_expires):
        """
        Sets the time_expires of this CatalogParSourceConfig.
        The date and time expires, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_expires: The time_expires of this CatalogParSourceConfig.
        :type: datetime
        """
        self._time_expires = time_expires

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
