# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComplianceDetailTarget(object):
    """
    Details of the Target.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ComplianceDetailTarget object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target_id:
            The value to assign to the target_id property of this ComplianceDetailTarget.
        :type target_id: str

        :param target_name:
            The value to assign to the target_name property of this ComplianceDetailTarget.
        :type target_name: str

        :param version:
            The value to assign to the version property of this ComplianceDetailTarget.
        :type version: str

        """
        self.swagger_types = {
            'target_id': 'str',
            'target_name': 'str',
            'version': 'str'
        }
        self.attribute_map = {
            'target_id': 'targetId',
            'target_name': 'targetName',
            'version': 'version'
        }
        self._target_id = None
        self._target_name = None
        self._version = None

    @property
    def target_id(self):
        """
        **[Required]** Gets the target_id of this ComplianceDetailTarget.
        Target Identifier.


        :return: The target_id of this ComplianceDetailTarget.
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """
        Sets the target_id of this ComplianceDetailTarget.
        Target Identifier.


        :param target_id: The target_id of this ComplianceDetailTarget.
        :type: str
        """
        self._target_id = target_id

    @property
    def target_name(self):
        """
        **[Required]** Gets the target_name of this ComplianceDetailTarget.
        Target Name.


        :return: The target_name of this ComplianceDetailTarget.
        :rtype: str
        """
        return self._target_name

    @target_name.setter
    def target_name(self, target_name):
        """
        Sets the target_name of this ComplianceDetailTarget.
        Target Name.


        :param target_name: The target_name of this ComplianceDetailTarget.
        :type: str
        """
        self._target_name = target_name

    @property
    def version(self):
        """
        Gets the version of this ComplianceDetailTarget.
        Current version.


        :return: The version of this ComplianceDetailTarget.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ComplianceDetailTarget.
        Current version.


        :param version: The version of this ComplianceDetailTarget.
        :type: str
        """
        self._version = version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
