# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .patch_selection_details import PatchSelectionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PatchReleaseDateSelectionDetails(PatchSelectionDetails):
    """
    Days since patch release date details.
    If you set the policy rule by selecting this option and entering the number of days since release, Fleet Application Management calculates the number of days passed after the release date and reports the product as noncompliant if the days exceed the number provided in Days since release
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PatchReleaseDateSelectionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.PatchReleaseDateSelectionDetails.selection_type` attribute
        of this class is ``PATCH_RELEASE_DATE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param selection_type:
            The value to assign to the selection_type property of this PatchReleaseDateSelectionDetails.
            Allowed values for this property are: "PATCH_LEVEL", "PATCH_NAME", "PATCH_RELEASE_DATE"
        :type selection_type: str

        :param days_since_release:
            The value to assign to the days_since_release property of this PatchReleaseDateSelectionDetails.
        :type days_since_release: int

        """
        self.swagger_types = {
            'selection_type': 'str',
            'days_since_release': 'int'
        }
        self.attribute_map = {
            'selection_type': 'selectionType',
            'days_since_release': 'daysSinceRelease'
        }
        self._selection_type = None
        self._days_since_release = None
        self._selection_type = 'PATCH_RELEASE_DATE'

    @property
    def days_since_release(self):
        """
        **[Required]** Gets the days_since_release of this PatchReleaseDateSelectionDetails.
        Days passed since patch release.


        :return: The days_since_release of this PatchReleaseDateSelectionDetails.
        :rtype: int
        """
        return self._days_since_release

    @days_since_release.setter
    def days_since_release(self, days_since_release):
        """
        Sets the days_since_release of this PatchReleaseDateSelectionDetails.
        Days passed since patch release.


        :param days_since_release: The days_since_release of this PatchReleaseDateSelectionDetails.
        :type: int
        """
        self._days_since_release = days_since_release

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
