# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .gi_fleet_discovery_filter import GiFleetDiscoveryFilter
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GiFreeformTagsFilter(GiFleetDiscoveryFilter):
    """
    Freeform tags to include in the discovery.
    """

    #: A constant which can be used with the operator property of a GiFreeformTagsFilter.
    #: This constant has a value of "AND"
    OPERATOR_AND = "AND"

    #: A constant which can be used with the operator property of a GiFreeformTagsFilter.
    #: This constant has a value of "OR"
    OPERATOR_OR = "OR"

    def __init__(self, **kwargs):
        """
        Initializes a new GiFreeformTagsFilter object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.GiFreeformTagsFilter.type` attribute
        of this class is ``FREEFORM_TAG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this GiFreeformTagsFilter.
            Allowed values for this property are: "COMPARTMENT_ID", "VERSION", "FREEFORM_TAG", "DEFINED_TAG", "RESOURCE_ID"
        :type type: str

        :param mode:
            The value to assign to the mode property of this GiFreeformTagsFilter.
            Allowed values for this property are: "INCLUDE", "EXCLUDE"
        :type mode: str

        :param tags:
            The value to assign to the tags property of this GiFreeformTagsFilter.
        :type tags: list[oci.fleet_software_update.models.FreeformTagFilterEntry]

        :param operator:
            The value to assign to the operator property of this GiFreeformTagsFilter.
            Allowed values for this property are: "AND", "OR"
        :type operator: str

        """
        self.swagger_types = {
            'type': 'str',
            'mode': 'str',
            'tags': 'list[FreeformTagFilterEntry]',
            'operator': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'mode': 'mode',
            'tags': 'tags',
            'operator': 'operator'
        }
        self._type = None
        self._mode = None
        self._tags = None
        self._operator = None
        self._type = 'FREEFORM_TAG'

    @property
    def tags(self):
        """
        **[Required]** Gets the tags of this GiFreeformTagsFilter.
        Freeform tags to include in the discovery.


        :return: The tags of this GiFreeformTagsFilter.
        :rtype: list[oci.fleet_software_update.models.FreeformTagFilterEntry]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this GiFreeformTagsFilter.
        Freeform tags to include in the discovery.


        :param tags: The tags of this GiFreeformTagsFilter.
        :type: list[oci.fleet_software_update.models.FreeformTagFilterEntry]
        """
        self._tags = tags

    @property
    def operator(self):
        """
        Gets the operator of this GiFreeformTagsFilter.
        Type of join for each element in this filter.

        Allowed values for this property are: "AND", "OR"


        :return: The operator of this GiFreeformTagsFilter.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator):
        """
        Sets the operator of this GiFreeformTagsFilter.
        Type of join for each element in this filter.


        :param operator: The operator of this GiFreeformTagsFilter.
        :type: str
        """
        allowed_values = ["AND", "OR"]
        if not value_allowed_none_or_none_sentinel(operator, allowed_values):
            raise ValueError(
                f"Invalid value for `operator`, must be None or one of {allowed_values}"
            )
        self._operator = operator

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
