# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201

from .failure_destination_details import FailureDestinationDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class QueueFailureDestinationDetails(FailureDestinationDetails):
    """
    The destination queue or channel in the Queue service to which to send the response of the failed detached function invocation.

    Example: `{\"kind\": \"QUEUE\", \"queueId\": \"queue_OCID\", \"channelId\": \"channel_Id\"}`
    """

    def __init__(self, **kwargs):
        """
        Initializes a new QueueFailureDestinationDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.functions.models.QueueFailureDestinationDetails.kind` attribute
        of this class is ``QUEUE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param kind:
            The value to assign to the kind property of this QueueFailureDestinationDetails.
            Allowed values for this property are: "NOTIFICATION", "QUEUE", "STREAM", "NONE"
        :type kind: str

        :param queue_id:
            The value to assign to the queue_id property of this QueueFailureDestinationDetails.
        :type queue_id: str

        :param channel_id:
            The value to assign to the channel_id property of this QueueFailureDestinationDetails.
        :type channel_id: str

        """
        self.swagger_types = {
            'kind': 'str',
            'queue_id': 'str',
            'channel_id': 'str'
        }
        self.attribute_map = {
            'kind': 'kind',
            'queue_id': 'queueId',
            'channel_id': 'channelId'
        }
        self._kind = None
        self._queue_id = None
        self._channel_id = None
        self._kind = 'QUEUE'

    @property
    def queue_id(self):
        """
        **[Required]** Gets the queue_id of this QueueFailureDestinationDetails.
        The `OCID`__ of the queue.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The queue_id of this QueueFailureDestinationDetails.
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id):
        """
        Sets the queue_id of this QueueFailureDestinationDetails.
        The `OCID`__ of the queue.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param queue_id: The queue_id of this QueueFailureDestinationDetails.
        :type: str
        """
        self._queue_id = queue_id

    @property
    def channel_id(self):
        """
        Gets the channel_id of this QueueFailureDestinationDetails.
        The ID of the channel in the queue.


        :return: The channel_id of this QueueFailureDestinationDetails.
        :rtype: str
        """
        return self._channel_id

    @channel_id.setter
    def channel_id(self, channel_id):
        """
        Sets the channel_id of this QueueFailureDestinationDetails.
        The ID of the channel in the queue.


        :param channel_id: The channel_id of this QueueFailureDestinationDetails.
        :type: str
        """
        self._channel_id = channel_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
