# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EndpointSummary(object):
    """
    Summary information for an endpoint resource.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new EndpointSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this EndpointSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this EndpointSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this EndpointSummary.
        :type description: str

        :param model_id:
            The value to assign to the model_id property of this EndpointSummary.
        :type model_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this EndpointSummary.
        :type compartment_id: str

        :param dedicated_ai_cluster_id:
            The value to assign to the dedicated_ai_cluster_id property of this EndpointSummary.
        :type dedicated_ai_cluster_id: str

        :param generative_ai_private_endpoint_id:
            The value to assign to the generative_ai_private_endpoint_id property of this EndpointSummary.
        :type generative_ai_private_endpoint_id: str

        :param time_created:
            The value to assign to the time_created property of this EndpointSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this EndpointSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this EndpointSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this EndpointSummary.
        :type lifecycle_details: str

        :param content_moderation_config:
            The value to assign to the content_moderation_config property of this EndpointSummary.
        :type content_moderation_config: oci.generative_ai.models.ContentModerationConfig

        :param freeform_tags:
            The value to assign to the freeform_tags property of this EndpointSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this EndpointSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this EndpointSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'model_id': 'str',
            'compartment_id': 'str',
            'dedicated_ai_cluster_id': 'str',
            'generative_ai_private_endpoint_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'content_moderation_config': 'ContentModerationConfig',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'model_id': 'modelId',
            'compartment_id': 'compartmentId',
            'dedicated_ai_cluster_id': 'dedicatedAiClusterId',
            'generative_ai_private_endpoint_id': 'generativeAiPrivateEndpointId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'content_moderation_config': 'contentModerationConfig',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._model_id = None
        self._compartment_id = None
        self._dedicated_ai_cluster_id = None
        self._generative_ai_private_endpoint_id = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._content_moderation_config = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this EndpointSummary.
        An OCID that uniquely identifies this endpoint resource.


        :return: The id of this EndpointSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EndpointSummary.
        An OCID that uniquely identifies this endpoint resource.


        :param id: The id of this EndpointSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this EndpointSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :return: The display_name of this EndpointSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this EndpointSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :param display_name: The display_name of this EndpointSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this EndpointSummary.
        An optional description of the endpoint.


        :return: The description of this EndpointSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this EndpointSummary.
        An optional description of the endpoint.


        :param description: The description of this EndpointSummary.
        :type: str
        """
        self._description = description

    @property
    def model_id(self):
        """
        **[Required]** Gets the model_id of this EndpointSummary.
        The OCID of the model that's used to create this endpoint.


        :return: The model_id of this EndpointSummary.
        :rtype: str
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """
        Sets the model_id of this EndpointSummary.
        The OCID of the model that's used to create this endpoint.


        :param model_id: The model_id of this EndpointSummary.
        :type: str
        """
        self._model_id = model_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this EndpointSummary.
        The compartment OCID to create the endpoint in.


        :return: The compartment_id of this EndpointSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this EndpointSummary.
        The compartment OCID to create the endpoint in.


        :param compartment_id: The compartment_id of this EndpointSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def dedicated_ai_cluster_id(self):
        """
        **[Required]** Gets the dedicated_ai_cluster_id of this EndpointSummary.
        The OCID of the dedicated AI cluster on which a model will be deployed to.


        :return: The dedicated_ai_cluster_id of this EndpointSummary.
        :rtype: str
        """
        return self._dedicated_ai_cluster_id

    @dedicated_ai_cluster_id.setter
    def dedicated_ai_cluster_id(self, dedicated_ai_cluster_id):
        """
        Sets the dedicated_ai_cluster_id of this EndpointSummary.
        The OCID of the dedicated AI cluster on which a model will be deployed to.


        :param dedicated_ai_cluster_id: The dedicated_ai_cluster_id of this EndpointSummary.
        :type: str
        """
        self._dedicated_ai_cluster_id = dedicated_ai_cluster_id

    @property
    def generative_ai_private_endpoint_id(self):
        """
        Gets the generative_ai_private_endpoint_id of this EndpointSummary.
        The OCID of the Generative AI private endpoint to which this endpoint is attached to.


        :return: The generative_ai_private_endpoint_id of this EndpointSummary.
        :rtype: str
        """
        return self._generative_ai_private_endpoint_id

    @generative_ai_private_endpoint_id.setter
    def generative_ai_private_endpoint_id(self, generative_ai_private_endpoint_id):
        """
        Sets the generative_ai_private_endpoint_id of this EndpointSummary.
        The OCID of the Generative AI private endpoint to which this endpoint is attached to.


        :param generative_ai_private_endpoint_id: The generative_ai_private_endpoint_id of this EndpointSummary.
        :type: str
        """
        self._generative_ai_private_endpoint_id = generative_ai_private_endpoint_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this EndpointSummary.
        The date and time that the endpoint was created in the format of an RFC3339 datetime string.


        :return: The time_created of this EndpointSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this EndpointSummary.
        The date and time that the endpoint was created in the format of an RFC3339 datetime string.


        :param time_created: The time_created of this EndpointSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this EndpointSummary.
        The date and time the endpoint was updated in the format of n RFC3339 datetime string.


        :return: The time_updated of this EndpointSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this EndpointSummary.
        The date and time the endpoint was updated in the format of n RFC3339 datetime string.


        :param time_updated: The time_updated of this EndpointSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this EndpointSummary.
        The current state of the endpoint.

        Allowed values are:
        - ACTIVE
        - CREATING
        - UPDATING
        - DELETING
        - DELETED
        - FAILED


        :return: The lifecycle_state of this EndpointSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this EndpointSummary.
        The current state of the endpoint.

        Allowed values are:
        - ACTIVE
        - CREATING
        - UPDATING
        - DELETING
        - DELETED
        - FAILED


        :param lifecycle_state: The lifecycle_state of this EndpointSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this EndpointSummary.
        A message describing the current state with detail that can provide actionable information.


        :return: The lifecycle_details of this EndpointSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this EndpointSummary.
        A message describing the current state with detail that can provide actionable information.


        :param lifecycle_details: The lifecycle_details of this EndpointSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def content_moderation_config(self):
        """
        Gets the content_moderation_config of this EndpointSummary.

        :return: The content_moderation_config of this EndpointSummary.
        :rtype: oci.generative_ai.models.ContentModerationConfig
        """
        return self._content_moderation_config

    @content_moderation_config.setter
    def content_moderation_config(self, content_moderation_config):
        """
        Sets the content_moderation_config of this EndpointSummary.

        :param content_moderation_config: The content_moderation_config of this EndpointSummary.
        :type: oci.generative_ai.models.ContentModerationConfig
        """
        self._content_moderation_config = content_moderation_config

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this EndpointSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this EndpointSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this EndpointSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this EndpointSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this EndpointSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this EndpointSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this EndpointSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this EndpointSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this EndpointSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this EndpointSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this EndpointSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this EndpointSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
