# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OutputConfig(object):
    """
    Configuration to store results generated by agent.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OutputConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param output_location:
            The value to assign to the output_location property of this OutputConfig.
        :type output_location: oci.generative_ai_agent.models.OutputLocation

        :param retention_period_in_minutes:
            The value to assign to the retention_period_in_minutes property of this OutputConfig.
        :type retention_period_in_minutes: int

        """
        self.swagger_types = {
            'output_location': 'OutputLocation',
            'retention_period_in_minutes': 'int'
        }
        self.attribute_map = {
            'output_location': 'outputLocation',
            'retention_period_in_minutes': 'retentionPeriodInMinutes'
        }
        self._output_location = None
        self._retention_period_in_minutes = None

    @property
    def output_location(self):
        """
        **[Required]** Gets the output_location of this OutputConfig.

        :return: The output_location of this OutputConfig.
        :rtype: oci.generative_ai_agent.models.OutputLocation
        """
        return self._output_location

    @output_location.setter
    def output_location(self, output_location):
        """
        Sets the output_location of this OutputConfig.

        :param output_location: The output_location of this OutputConfig.
        :type: oci.generative_ai_agent.models.OutputLocation
        """
        self._output_location = output_location

    @property
    def retention_period_in_minutes(self):
        """
        Gets the retention_period_in_minutes of this OutputConfig.
        Retention duration of the output data.


        :return: The retention_period_in_minutes of this OutputConfig.
        :rtype: int
        """
        return self._retention_period_in_minutes

    @retention_period_in_minutes.setter
    def retention_period_in_minutes(self, retention_period_in_minutes):
        """
        Sets the retention_period_in_minutes of this OutputConfig.
        Retention duration of the output data.


        :param retention_period_in_minutes: The retention_period_in_minutes of this OutputConfig.
        :type: int
        """
        self._retention_period_in_minutes = retention_period_in_minutes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
