# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TokenLikelihood(object):
    """
    An object that contains the returned token and its corresponding likelihood.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TokenLikelihood object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param token:
            The value to assign to the token property of this TokenLikelihood.
        :type token: str

        :param likelihood:
            The value to assign to the likelihood property of this TokenLikelihood.
        :type likelihood: float

        """
        self.swagger_types = {
            'token': 'str',
            'likelihood': 'float'
        }
        self.attribute_map = {
            'token': 'token',
            'likelihood': 'likelihood'
        }
        self._token = None
        self._likelihood = None

    @property
    def token(self):
        """
        Gets the token of this TokenLikelihood.
        A word, part of a word, or a punctuation.

        For example, apple is a token and friendship is made up of two tokens, friend and ship. When you run a model, you can set the maximum number of output tokens. Estimate three tokens per word.


        :return: The token of this TokenLikelihood.
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """
        Sets the token of this TokenLikelihood.
        A word, part of a word, or a punctuation.

        For example, apple is a token and friendship is made up of two tokens, friend and ship. When you run a model, you can set the maximum number of output tokens. Estimate three tokens per word.


        :param token: The token of this TokenLikelihood.
        :type: str
        """
        self._token = token

    @property
    def likelihood(self):
        """
        Gets the likelihood of this TokenLikelihood.
        The likelihood of this token during generation.


        :return: The likelihood of this TokenLikelihood.
        :rtype: float
        """
        return self._likelihood

    @likelihood.setter
    def likelihood(self, likelihood):
        """
        Sets the likelihood of this TokenLikelihood.
        The likelihood of this token during generation.


        :param likelihood: The likelihood of this TokenLikelihood.
        :type: float
        """
        self._likelihood = likelihood

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
