# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateBackupScheduleDetails(object):
    """
    Defines the backup schedule details for create operation.
    """

    #: A constant which can be used with the frequency_backup_scheduled property of a CreateBackupScheduleDetails.
    #: This constant has a value of "DAILY"
    FREQUENCY_BACKUP_SCHEDULED_DAILY = "DAILY"

    #: A constant which can be used with the frequency_backup_scheduled property of a CreateBackupScheduleDetails.
    #: This constant has a value of "WEEKLY"
    FREQUENCY_BACKUP_SCHEDULED_WEEKLY = "WEEKLY"

    #: A constant which can be used with the frequency_backup_scheduled property of a CreateBackupScheduleDetails.
    #: This constant has a value of "MONTHLY"
    FREQUENCY_BACKUP_SCHEDULED_MONTHLY = "MONTHLY"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateBackupScheduleDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_backup_scheduled:
            The value to assign to the time_backup_scheduled property of this CreateBackupScheduleDetails.
        :type time_backup_scheduled: datetime

        :param frequency_backup_scheduled:
            The value to assign to the frequency_backup_scheduled property of this CreateBackupScheduleDetails.
            Allowed values for this property are: "DAILY", "WEEKLY", "MONTHLY"
        :type frequency_backup_scheduled: str

        :param bucket_name:
            The value to assign to the bucket_name property of this CreateBackupScheduleDetails.
        :type bucket_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateBackupScheduleDetails.
        :type compartment_id: str

        :param namespace_name:
            The value to assign to the namespace_name property of this CreateBackupScheduleDetails.
        :type namespace_name: str

        :param is_metadata_only:
            The value to assign to the is_metadata_only property of this CreateBackupScheduleDetails.
        :type is_metadata_only: bool

        """
        self.swagger_types = {
            'time_backup_scheduled': 'datetime',
            'frequency_backup_scheduled': 'str',
            'bucket_name': 'str',
            'compartment_id': 'str',
            'namespace_name': 'str',
            'is_metadata_only': 'bool'
        }
        self.attribute_map = {
            'time_backup_scheduled': 'timeBackupScheduled',
            'frequency_backup_scheduled': 'frequencyBackupScheduled',
            'bucket_name': 'bucketName',
            'compartment_id': 'compartmentId',
            'namespace_name': 'namespaceName',
            'is_metadata_only': 'isMetadataOnly'
        }
        self._time_backup_scheduled = None
        self._frequency_backup_scheduled = None
        self._bucket_name = None
        self._compartment_id = None
        self._namespace_name = None
        self._is_metadata_only = None

    @property
    def time_backup_scheduled(self):
        """
        **[Required]** Gets the time_backup_scheduled of this CreateBackupScheduleDetails.
        The start timestamp for the deployment backup schedule. The format is defined by
        `RFC3339`__, such as `2024-10-25T18:19:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_backup_scheduled of this CreateBackupScheduleDetails.
        :rtype: datetime
        """
        return self._time_backup_scheduled

    @time_backup_scheduled.setter
    def time_backup_scheduled(self, time_backup_scheduled):
        """
        Sets the time_backup_scheduled of this CreateBackupScheduleDetails.
        The start timestamp for the deployment backup schedule. The format is defined by
        `RFC3339`__, such as `2024-10-25T18:19:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :param time_backup_scheduled: The time_backup_scheduled of this CreateBackupScheduleDetails.
        :type: datetime
        """
        self._time_backup_scheduled = time_backup_scheduled

    @property
    def frequency_backup_scheduled(self):
        """
        **[Required]** Gets the frequency_backup_scheduled of this CreateBackupScheduleDetails.
        The frequency of the deployment backup schedule. Frequency can be DAILY, WEEKLY or MONTHLY.

        Allowed values for this property are: "DAILY", "WEEKLY", "MONTHLY"


        :return: The frequency_backup_scheduled of this CreateBackupScheduleDetails.
        :rtype: str
        """
        return self._frequency_backup_scheduled

    @frequency_backup_scheduled.setter
    def frequency_backup_scheduled(self, frequency_backup_scheduled):
        """
        Sets the frequency_backup_scheduled of this CreateBackupScheduleDetails.
        The frequency of the deployment backup schedule. Frequency can be DAILY, WEEKLY or MONTHLY.


        :param frequency_backup_scheduled: The frequency_backup_scheduled of this CreateBackupScheduleDetails.
        :type: str
        """
        allowed_values = ["DAILY", "WEEKLY", "MONTHLY"]
        if not value_allowed_none_or_none_sentinel(frequency_backup_scheduled, allowed_values):
            raise ValueError(
                f"Invalid value for `frequency_backup_scheduled`, must be None or one of {allowed_values}"
            )
        self._frequency_backup_scheduled = frequency_backup_scheduled

    @property
    def bucket_name(self):
        """
        **[Required]** Gets the bucket_name of this CreateBackupScheduleDetails.
        Name of the bucket where the object is to be uploaded in the object storage


        :return: The bucket_name of this CreateBackupScheduleDetails.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this CreateBackupScheduleDetails.
        Name of the bucket where the object is to be uploaded in the object storage


        :param bucket_name: The bucket_name of this CreateBackupScheduleDetails.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateBackupScheduleDetails.
        The `OCID`__ of the compartment being referenced.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateBackupScheduleDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateBackupScheduleDetails.
        The `OCID`__ of the compartment being referenced.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateBackupScheduleDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def namespace_name(self):
        """
        **[Required]** Gets the namespace_name of this CreateBackupScheduleDetails.
        Name of namespace that serves as a container for all of your buckets


        :return: The namespace_name of this CreateBackupScheduleDetails.
        :rtype: str
        """
        return self._namespace_name

    @namespace_name.setter
    def namespace_name(self, namespace_name):
        """
        Sets the namespace_name of this CreateBackupScheduleDetails.
        Name of namespace that serves as a container for all of your buckets


        :param namespace_name: The namespace_name of this CreateBackupScheduleDetails.
        :type: str
        """
        self._namespace_name = namespace_name

    @property
    def is_metadata_only(self):
        """
        **[Required]** Gets the is_metadata_only of this CreateBackupScheduleDetails.
        Parameter to allow users to create backup without trails


        :return: The is_metadata_only of this CreateBackupScheduleDetails.
        :rtype: bool
        """
        return self._is_metadata_only

    @is_metadata_only.setter
    def is_metadata_only(self, is_metadata_only):
        """
        Sets the is_metadata_only of this CreateBackupScheduleDetails.
        Parameter to allow users to create backup without trails


        :param is_metadata_only: The is_metadata_only of this CreateBackupScheduleDetails.
        :type: bool
        """
        self._is_metadata_only = is_metadata_only

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
