# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IcebergCatalogSummary(object):
    """
    Summary of the catalog of given type used in an Iceberg connection.
    """

    #: A constant which can be used with the catalog_type property of a IcebergCatalogSummary.
    #: This constant has a value of "GLUE"
    CATALOG_TYPE_GLUE = "GLUE"

    #: A constant which can be used with the catalog_type property of a IcebergCatalogSummary.
    #: This constant has a value of "HADOOP"
    CATALOG_TYPE_HADOOP = "HADOOP"

    #: A constant which can be used with the catalog_type property of a IcebergCatalogSummary.
    #: This constant has a value of "NESSIE"
    CATALOG_TYPE_NESSIE = "NESSIE"

    #: A constant which can be used with the catalog_type property of a IcebergCatalogSummary.
    #: This constant has a value of "POLARIS"
    CATALOG_TYPE_POLARIS = "POLARIS"

    #: A constant which can be used with the catalog_type property of a IcebergCatalogSummary.
    #: This constant has a value of "REST"
    CATALOG_TYPE_REST = "REST"

    def __init__(self, **kwargs):
        """
        Initializes a new IcebergCatalogSummary object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.golden_gate.models.GlueIcebergCatalogSummary`
        * :class:`~oci.golden_gate.models.NessieIcebergCatalogSummary`
        * :class:`~oci.golden_gate.models.PolarisIcebergCatalogSummary`
        * :class:`~oci.golden_gate.models.RestIcebergCatalogSummary`
        * :class:`~oci.golden_gate.models.HadoopIcebergCatalogSummary`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param catalog_type:
            The value to assign to the catalog_type property of this IcebergCatalogSummary.
            Allowed values for this property are: "GLUE", "HADOOP", "NESSIE", "POLARIS", "REST", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type catalog_type: str

        """
        self.swagger_types = {
            'catalog_type': 'str'
        }
        self.attribute_map = {
            'catalog_type': 'catalogType'
        }
        self._catalog_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['catalogType']

        if type == 'GLUE':
            return 'GlueIcebergCatalogSummary'

        if type == 'NESSIE':
            return 'NessieIcebergCatalogSummary'

        if type == 'POLARIS':
            return 'PolarisIcebergCatalogSummary'

        if type == 'REST':
            return 'RestIcebergCatalogSummary'

        if type == 'HADOOP':
            return 'HadoopIcebergCatalogSummary'
        else:
            return 'IcebergCatalogSummary'

    @property
    def catalog_type(self):
        """
        **[Required]** Gets the catalog_type of this IcebergCatalogSummary.
        The catalog type.

        Allowed values for this property are: "GLUE", "HADOOP", "NESSIE", "POLARIS", "REST", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The catalog_type of this IcebergCatalogSummary.
        :rtype: str
        """
        return self._catalog_type

    @catalog_type.setter
    def catalog_type(self, catalog_type):
        """
        Sets the catalog_type of this IcebergCatalogSummary.
        The catalog type.


        :param catalog_type: The catalog_type of this IcebergCatalogSummary.
        :type: str
        """
        allowed_values = ["GLUE", "HADOOP", "NESSIE", "POLARIS", "REST"]
        if not value_allowed_none_or_none_sentinel(catalog_type, allowed_values):
            catalog_type = 'UNKNOWN_ENUM_VALUE'
        self._catalog_type = catalog_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
