# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407

from .connection import Connection
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OracleAiDataPlatformConnection(Connection):
    """
    Represents the metadata of an Oracle AI Data Platform Connection.
    """

    #: A constant which can be used with the technology_type property of a OracleAiDataPlatformConnection.
    #: This constant has a value of "ORACLE_AI_DATA_PLATFORM"
    TECHNOLOGY_TYPE_ORACLE_AI_DATA_PLATFORM = "ORACLE_AI_DATA_PLATFORM"

    def __init__(self, **kwargs):
        """
        Initializes a new OracleAiDataPlatformConnection object with values from keyword arguments. The default value of the :py:attr:`~oci.golden_gate.models.OracleAiDataPlatformConnection.connection_type` attribute
        of this class is ``ORACLE_AI_DATA_PLATFORM`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connection_type:
            The value to assign to the connection_type property of this OracleAiDataPlatformConnection.
            Allowed values for this property are: "GOLDENGATE", "KAFKA", "KAFKA_SCHEMA_REGISTRY", "MYSQL", "JAVA_MESSAGE_SERVICE", "MICROSOFT_SQLSERVER", "OCI_OBJECT_STORAGE", "ORACLE", "AZURE_DATA_LAKE_STORAGE", "POSTGRESQL", "AZURE_SYNAPSE_ANALYTICS", "SNOWFLAKE", "AMAZON_S3", "HDFS", "ORACLE_AI_DATA_PLATFORM", "ORACLE_NOSQL", "MONGODB", "AMAZON_KINESIS", "AMAZON_REDSHIFT", "DB2", "REDIS", "ELASTICSEARCH", "GENERIC", "GOOGLE_CLOUD_STORAGE", "GOOGLE_BIGQUERY", "DATABRICKS", "GOOGLE_PUBSUB", "MICROSOFT_FABRIC", "ICEBERG", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type connection_type: str

        :param id:
            The value to assign to the id property of this OracleAiDataPlatformConnection.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this OracleAiDataPlatformConnection.
        :type display_name: str

        :param description:
            The value to assign to the description property of this OracleAiDataPlatformConnection.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this OracleAiDataPlatformConnection.
        :type compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this OracleAiDataPlatformConnection.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this OracleAiDataPlatformConnection.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this OracleAiDataPlatformConnection.
        :type system_tags: dict(str, dict(str, object))

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OracleAiDataPlatformConnection.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this OracleAiDataPlatformConnection.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this OracleAiDataPlatformConnection.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this OracleAiDataPlatformConnection.
        :type time_updated: datetime

        :param locks:
            The value to assign to the locks property of this OracleAiDataPlatformConnection.
        :type locks: list[oci.golden_gate.models.ResourceLock]

        :param vault_id:
            The value to assign to the vault_id property of this OracleAiDataPlatformConnection.
        :type vault_id: str

        :param key_id:
            The value to assign to the key_id property of this OracleAiDataPlatformConnection.
        :type key_id: str

        :param ingress_ips:
            The value to assign to the ingress_ips property of this OracleAiDataPlatformConnection.
        :type ingress_ips: list[oci.golden_gate.models.IngressIpDetails]

        :param nsg_ids:
            The value to assign to the nsg_ids property of this OracleAiDataPlatformConnection.
        :type nsg_ids: list[str]

        :param subnet_id:
            The value to assign to the subnet_id property of this OracleAiDataPlatformConnection.
        :type subnet_id: str

        :param routing_method:
            The value to assign to the routing_method property of this OracleAiDataPlatformConnection.
            Allowed values for this property are: "SHARED_SERVICE_ENDPOINT", "SHARED_DEPLOYMENT_ENDPOINT", "DEDICATED_ENDPOINT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type routing_method: str

        :param does_use_secret_ids:
            The value to assign to the does_use_secret_ids property of this OracleAiDataPlatformConnection.
        :type does_use_secret_ids: bool

        :param subscription_id:
            The value to assign to the subscription_id property of this OracleAiDataPlatformConnection.
        :type subscription_id: str

        :param cluster_placement_group_id:
            The value to assign to the cluster_placement_group_id property of this OracleAiDataPlatformConnection.
        :type cluster_placement_group_id: str

        :param security_attributes:
            The value to assign to the security_attributes property of this OracleAiDataPlatformConnection.
        :type security_attributes: dict(str, dict(str, object))

        :param technology_type:
            The value to assign to the technology_type property of this OracleAiDataPlatformConnection.
            Allowed values for this property are: "ORACLE_AI_DATA_PLATFORM", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type technology_type: str

        :param connection_url:
            The value to assign to the connection_url property of this OracleAiDataPlatformConnection.
        :type connection_url: str

        :param tenancy_id:
            The value to assign to the tenancy_id property of this OracleAiDataPlatformConnection.
        :type tenancy_id: str

        :param region:
            The value to assign to the region property of this OracleAiDataPlatformConnection.
        :type region: str

        :param user_id:
            The value to assign to the user_id property of this OracleAiDataPlatformConnection.
        :type user_id: str

        :param private_key_file_secret_id:
            The value to assign to the private_key_file_secret_id property of this OracleAiDataPlatformConnection.
        :type private_key_file_secret_id: str

        :param private_key_passphrase_secret_id:
            The value to assign to the private_key_passphrase_secret_id property of this OracleAiDataPlatformConnection.
        :type private_key_passphrase_secret_id: str

        :param public_key_fingerprint:
            The value to assign to the public_key_fingerprint property of this OracleAiDataPlatformConnection.
        :type public_key_fingerprint: str

        :param should_use_resource_principal:
            The value to assign to the should_use_resource_principal property of this OracleAiDataPlatformConnection.
        :type should_use_resource_principal: bool

        """
        self.swagger_types = {
            'connection_type': 'str',
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'locks': 'list[ResourceLock]',
            'vault_id': 'str',
            'key_id': 'str',
            'ingress_ips': 'list[IngressIpDetails]',
            'nsg_ids': 'list[str]',
            'subnet_id': 'str',
            'routing_method': 'str',
            'does_use_secret_ids': 'bool',
            'subscription_id': 'str',
            'cluster_placement_group_id': 'str',
            'security_attributes': 'dict(str, dict(str, object))',
            'technology_type': 'str',
            'connection_url': 'str',
            'tenancy_id': 'str',
            'region': 'str',
            'user_id': 'str',
            'private_key_file_secret_id': 'str',
            'private_key_passphrase_secret_id': 'str',
            'public_key_fingerprint': 'str',
            'should_use_resource_principal': 'bool'
        }
        self.attribute_map = {
            'connection_type': 'connectionType',
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'locks': 'locks',
            'vault_id': 'vaultId',
            'key_id': 'keyId',
            'ingress_ips': 'ingressIps',
            'nsg_ids': 'nsgIds',
            'subnet_id': 'subnetId',
            'routing_method': 'routingMethod',
            'does_use_secret_ids': 'doesUseSecretIds',
            'subscription_id': 'subscriptionId',
            'cluster_placement_group_id': 'clusterPlacementGroupId',
            'security_attributes': 'securityAttributes',
            'technology_type': 'technologyType',
            'connection_url': 'connectionUrl',
            'tenancy_id': 'tenancyId',
            'region': 'region',
            'user_id': 'userId',
            'private_key_file_secret_id': 'privateKeyFileSecretId',
            'private_key_passphrase_secret_id': 'privateKeyPassphraseSecretId',
            'public_key_fingerprint': 'publicKeyFingerprint',
            'should_use_resource_principal': 'shouldUseResourcePrincipal'
        }
        self._connection_type = None
        self._id = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._locks = None
        self._vault_id = None
        self._key_id = None
        self._ingress_ips = None
        self._nsg_ids = None
        self._subnet_id = None
        self._routing_method = None
        self._does_use_secret_ids = None
        self._subscription_id = None
        self._cluster_placement_group_id = None
        self._security_attributes = None
        self._technology_type = None
        self._connection_url = None
        self._tenancy_id = None
        self._region = None
        self._user_id = None
        self._private_key_file_secret_id = None
        self._private_key_passphrase_secret_id = None
        self._public_key_fingerprint = None
        self._should_use_resource_principal = None
        self._connection_type = 'ORACLE_AI_DATA_PLATFORM'

    @property
    def technology_type(self):
        """
        **[Required]** Gets the technology_type of this OracleAiDataPlatformConnection.
        The Oracle AI Data Platform technology type.

        Allowed values for this property are: "ORACLE_AI_DATA_PLATFORM", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The technology_type of this OracleAiDataPlatformConnection.
        :rtype: str
        """
        return self._technology_type

    @technology_type.setter
    def technology_type(self, technology_type):
        """
        Sets the technology_type of this OracleAiDataPlatformConnection.
        The Oracle AI Data Platform technology type.


        :param technology_type: The technology_type of this OracleAiDataPlatformConnection.
        :type: str
        """
        allowed_values = ["ORACLE_AI_DATA_PLATFORM"]
        if not value_allowed_none_or_none_sentinel(technology_type, allowed_values):
            technology_type = 'UNKNOWN_ENUM_VALUE'
        self._technology_type = technology_type

    @property
    def connection_url(self):
        """
        **[Required]** Gets the connection_url of this OracleAiDataPlatformConnection.
        Connection URL.
        It must start with 'jdbc:spark://'


        :return: The connection_url of this OracleAiDataPlatformConnection.
        :rtype: str
        """
        return self._connection_url

    @connection_url.setter
    def connection_url(self, connection_url):
        """
        Sets the connection_url of this OracleAiDataPlatformConnection.
        Connection URL.
        It must start with 'jdbc:spark://'


        :param connection_url: The connection_url of this OracleAiDataPlatformConnection.
        :type: str
        """
        self._connection_url = connection_url

    @property
    def tenancy_id(self):
        """
        Gets the tenancy_id of this OracleAiDataPlatformConnection.
        The `OCID`__ of the related OCI tenancy.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The tenancy_id of this OracleAiDataPlatformConnection.
        :rtype: str
        """
        return self._tenancy_id

    @tenancy_id.setter
    def tenancy_id(self, tenancy_id):
        """
        Sets the tenancy_id of this OracleAiDataPlatformConnection.
        The `OCID`__ of the related OCI tenancy.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param tenancy_id: The tenancy_id of this OracleAiDataPlatformConnection.
        :type: str
        """
        self._tenancy_id = tenancy_id

    @property
    def region(self):
        """
        Gets the region of this OracleAiDataPlatformConnection.
        The name of the region. e.g.: us-ashburn-1
        If the region is not provided, backend will default to the default region.


        :return: The region of this OracleAiDataPlatformConnection.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this OracleAiDataPlatformConnection.
        The name of the region. e.g.: us-ashburn-1
        If the region is not provided, backend will default to the default region.


        :param region: The region of this OracleAiDataPlatformConnection.
        :type: str
        """
        self._region = region

    @property
    def user_id(self):
        """
        Gets the user_id of this OracleAiDataPlatformConnection.
        The `OCID`__ of the OCI user who will access the Object Storage.
        The user must have write access to the bucket they want to connect to.
        If the user is not provided, backend will default to the user who is calling the API endpoint.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The user_id of this OracleAiDataPlatformConnection.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this OracleAiDataPlatformConnection.
        The `OCID`__ of the OCI user who will access the Object Storage.
        The user must have write access to the bucket they want to connect to.
        If the user is not provided, backend will default to the user who is calling the API endpoint.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param user_id: The user_id of this OracleAiDataPlatformConnection.
        :type: str
        """
        self._user_id = user_id

    @property
    def private_key_file_secret_id(self):
        """
        Gets the private_key_file_secret_id of this OracleAiDataPlatformConnection.
        The `OCID`__ of the Secret that stores the content of the private key file (PEM file) corresponding to the API key of the fingerprint.
        See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm
        Note: When provided, 'privateKeyFile' field must not be provided.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The private_key_file_secret_id of this OracleAiDataPlatformConnection.
        :rtype: str
        """
        return self._private_key_file_secret_id

    @private_key_file_secret_id.setter
    def private_key_file_secret_id(self, private_key_file_secret_id):
        """
        Sets the private_key_file_secret_id of this OracleAiDataPlatformConnection.
        The `OCID`__ of the Secret that stores the content of the private key file (PEM file) corresponding to the API key of the fingerprint.
        See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm
        Note: When provided, 'privateKeyFile' field must not be provided.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param private_key_file_secret_id: The private_key_file_secret_id of this OracleAiDataPlatformConnection.
        :type: str
        """
        self._private_key_file_secret_id = private_key_file_secret_id

    @property
    def private_key_passphrase_secret_id(self):
        """
        Gets the private_key_passphrase_secret_id of this OracleAiDataPlatformConnection.
        The `OCID`__ of the Secret that stores the passphrase of the private key.
        Note: When provided, 'privateKeyPassphrase' field must not be provided.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The private_key_passphrase_secret_id of this OracleAiDataPlatformConnection.
        :rtype: str
        """
        return self._private_key_passphrase_secret_id

    @private_key_passphrase_secret_id.setter
    def private_key_passphrase_secret_id(self, private_key_passphrase_secret_id):
        """
        Sets the private_key_passphrase_secret_id of this OracleAiDataPlatformConnection.
        The `OCID`__ of the Secret that stores the passphrase of the private key.
        Note: When provided, 'privateKeyPassphrase' field must not be provided.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param private_key_passphrase_secret_id: The private_key_passphrase_secret_id of this OracleAiDataPlatformConnection.
        :type: str
        """
        self._private_key_passphrase_secret_id = private_key_passphrase_secret_id

    @property
    def public_key_fingerprint(self):
        """
        Gets the public_key_fingerprint of this OracleAiDataPlatformConnection.
        The fingerprint of the API Key of the user specified by the userId.
        See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm


        :return: The public_key_fingerprint of this OracleAiDataPlatformConnection.
        :rtype: str
        """
        return self._public_key_fingerprint

    @public_key_fingerprint.setter
    def public_key_fingerprint(self, public_key_fingerprint):
        """
        Sets the public_key_fingerprint of this OracleAiDataPlatformConnection.
        The fingerprint of the API Key of the user specified by the userId.
        See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm


        :param public_key_fingerprint: The public_key_fingerprint of this OracleAiDataPlatformConnection.
        :type: str
        """
        self._public_key_fingerprint = public_key_fingerprint

    @property
    def should_use_resource_principal(self):
        """
        Gets the should_use_resource_principal of this OracleAiDataPlatformConnection.
        Specifies that the user intends to authenticate to the instance using a resource principal.
        Default: false


        :return: The should_use_resource_principal of this OracleAiDataPlatformConnection.
        :rtype: bool
        """
        return self._should_use_resource_principal

    @should_use_resource_principal.setter
    def should_use_resource_principal(self, should_use_resource_principal):
        """
        Sets the should_use_resource_principal of this OracleAiDataPlatformConnection.
        Specifies that the user intends to authenticate to the instance using a resource principal.
        Default: false


        :param should_use_resource_principal: The should_use_resource_principal of this OracleAiDataPlatformConnection.
        :type: bool
        """
        self._should_use_resource_principal = should_use_resource_principal

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
