# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IdentitySettingsPOSIXGid(object):
    """
    A list of Posix Gid settings.

    **Added In:** 17.4.6

    **SCIM++ Properties:**
    - caseExact: false
    - multiValued: false
    - required: false
    - type: complex
    - uniqueness: none
    """

    def __init__(self, **kwargs):
        """
        Initializes a new IdentitySettingsPOSIXGid object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param manual_assignment_starts_from:
            The value to assign to the manual_assignment_starts_from property of this IdentitySettingsPOSIXGid.
        :type manual_assignment_starts_from: int

        :param manual_assignment_ends_at:
            The value to assign to the manual_assignment_ends_at property of this IdentitySettingsPOSIXGid.
        :type manual_assignment_ends_at: int

        """
        self.swagger_types = {
            'manual_assignment_starts_from': 'int',
            'manual_assignment_ends_at': 'int'
        }
        self.attribute_map = {
            'manual_assignment_starts_from': 'manualAssignmentStartsFrom',
            'manual_assignment_ends_at': 'manualAssignmentEndsAt'
        }
        self._manual_assignment_starts_from = None
        self._manual_assignment_ends_at = None

    @property
    def manual_assignment_starts_from(self):
        """
        Gets the manual_assignment_starts_from of this IdentitySettingsPOSIXGid.
        The number from which the Posix Gid Manual assignment starts.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The manual_assignment_starts_from of this IdentitySettingsPOSIXGid.
        :rtype: int
        """
        return self._manual_assignment_starts_from

    @manual_assignment_starts_from.setter
    def manual_assignment_starts_from(self, manual_assignment_starts_from):
        """
        Sets the manual_assignment_starts_from of this IdentitySettingsPOSIXGid.
        The number from which the Posix Gid Manual assignment starts.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param manual_assignment_starts_from: The manual_assignment_starts_from of this IdentitySettingsPOSIXGid.
        :type: int
        """
        self._manual_assignment_starts_from = manual_assignment_starts_from

    @property
    def manual_assignment_ends_at(self):
        """
        Gets the manual_assignment_ends_at of this IdentitySettingsPOSIXGid.
        The number at which the Posix Gid Manual assignment ends.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The manual_assignment_ends_at of this IdentitySettingsPOSIXGid.
        :rtype: int
        """
        return self._manual_assignment_ends_at

    @manual_assignment_ends_at.setter
    def manual_assignment_ends_at(self, manual_assignment_ends_at):
        """
        Sets the manual_assignment_ends_at of this IdentitySettingsPOSIXGid.
        The number at which the Posix Gid Manual assignment ends.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param manual_assignment_ends_at: The manual_assignment_ends_at of this IdentitySettingsPOSIXGid.
        :type: int
        """
        self._manual_assignment_ends_at = manual_assignment_ends_at

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
