# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531

from .configure_iot_domain_data_access_details import ConfigureIotDomainDataAccessDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApexDataAccessDetails(ConfigureIotDomainDataAccessDetails):
    """
    This contains configuration for apex data access.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ApexDataAccessDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.iot.models.ApexDataAccessDetails.type` attribute
        of this class is ``APEX`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ApexDataAccessDetails.
            Allowed values for this property are: "DIRECT", "ORDS", "APEX"
        :type type: str

        :param db_workspace_admin_initial_password:
            The value to assign to the db_workspace_admin_initial_password property of this ApexDataAccessDetails.
        :type db_workspace_admin_initial_password: str

        """
        self.swagger_types = {
            'type': 'str',
            'db_workspace_admin_initial_password': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'db_workspace_admin_initial_password': 'dbWorkspaceAdminInitialPassword'
        }
        self._type = None
        self._db_workspace_admin_initial_password = None
        self._type = 'APEX'

    @property
    def db_workspace_admin_initial_password(self):
        """
        **[Required]** Gets the db_workspace_admin_initial_password of this ApexDataAccessDetails.
        Initial admin password for APEX workspace associated with the IoT domain.


        :return: The db_workspace_admin_initial_password of this ApexDataAccessDetails.
        :rtype: str
        """
        return self._db_workspace_admin_initial_password

    @db_workspace_admin_initial_password.setter
    def db_workspace_admin_initial_password(self, db_workspace_admin_initial_password):
        """
        Sets the db_workspace_admin_initial_password of this ApexDataAccessDetails.
        Initial admin password for APEX workspace associated with the IoT domain.


        :param db_workspace_admin_initial_password: The db_workspace_admin_initial_password of this ApexDataAccessDetails.
        :type: str
        """
        self._db_workspace_admin_initial_password = db_workspace_admin_initial_password

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
