# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FleetErrorAggregationSummary(object):
    """
    High level view of fleet error aggregations.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FleetErrorAggregationSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param healthy_fleet_count:
            The value to assign to the healthy_fleet_count property of this FleetErrorAggregationSummary.
        :type healthy_fleet_count: int

        :param fleet_error_aggregations:
            The value to assign to the fleet_error_aggregations property of this FleetErrorAggregationSummary.
        :type fleet_error_aggregations: list[oci.jms.models.FleetErrorAggregation]

        """
        self.swagger_types = {
            'healthy_fleet_count': 'int',
            'fleet_error_aggregations': 'list[FleetErrorAggregation]'
        }
        self.attribute_map = {
            'healthy_fleet_count': 'healthyFleetCount',
            'fleet_error_aggregations': 'fleetErrorAggregations'
        }
        self._healthy_fleet_count = None
        self._fleet_error_aggregations = None

    @property
    def healthy_fleet_count(self):
        """
        **[Required]** Gets the healthy_fleet_count of this FleetErrorAggregationSummary.
        Count of fleets with no problems.


        :return: The healthy_fleet_count of this FleetErrorAggregationSummary.
        :rtype: int
        """
        return self._healthy_fleet_count

    @healthy_fleet_count.setter
    def healthy_fleet_count(self, healthy_fleet_count):
        """
        Sets the healthy_fleet_count of this FleetErrorAggregationSummary.
        Count of fleets with no problems.


        :param healthy_fleet_count: The healthy_fleet_count of this FleetErrorAggregationSummary.
        :type: int
        """
        self._healthy_fleet_count = healthy_fleet_count

    @property
    def fleet_error_aggregations(self):
        """
        **[Required]** Gets the fleet_error_aggregations of this FleetErrorAggregationSummary.
        List of fleet error aggregations.


        :return: The fleet_error_aggregations of this FleetErrorAggregationSummary.
        :rtype: list[oci.jms.models.FleetErrorAggregation]
        """
        return self._fleet_error_aggregations

    @fleet_error_aggregations.setter
    def fleet_error_aggregations(self, fleet_error_aggregations):
        """
        Sets the fleet_error_aggregations of this FleetErrorAggregationSummary.
        List of fleet error aggregations.


        :param fleet_error_aggregations: The fleet_error_aggregations of this FleetErrorAggregationSummary.
        :type: list[oci.jms.models.FleetErrorAggregation]
        """
        self._fleet_error_aggregations = fleet_error_aggregations

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
