# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LibraryApplicationUsageSummary(object):
    """
    Summary of an application where a given library was detected statically and/or dynamically. Contains the count of managed instances where the library was detected with this application.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LibraryApplicationUsageSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param application_key:
            The value to assign to the application_key property of this LibraryApplicationUsageSummary.
        :type application_key: str

        :param application_name:
            The value to assign to the application_name property of this LibraryApplicationUsageSummary.
        :type application_name: str

        :param managed_instance_count:
            The value to assign to the managed_instance_count property of this LibraryApplicationUsageSummary.
        :type managed_instance_count: int

        :param last_detected_dynamically:
            The value to assign to the last_detected_dynamically property of this LibraryApplicationUsageSummary.
        :type last_detected_dynamically: datetime

        :param first_seen_in_classpath:
            The value to assign to the first_seen_in_classpath property of this LibraryApplicationUsageSummary.
        :type first_seen_in_classpath: datetime

        :param last_seen_in_classpath:
            The value to assign to the last_seen_in_classpath property of this LibraryApplicationUsageSummary.
        :type last_seen_in_classpath: datetime

        """
        self.swagger_types = {
            'application_key': 'str',
            'application_name': 'str',
            'managed_instance_count': 'int',
            'last_detected_dynamically': 'datetime',
            'first_seen_in_classpath': 'datetime',
            'last_seen_in_classpath': 'datetime'
        }
        self.attribute_map = {
            'application_key': 'applicationKey',
            'application_name': 'applicationName',
            'managed_instance_count': 'managedInstanceCount',
            'last_detected_dynamically': 'lastDetectedDynamically',
            'first_seen_in_classpath': 'firstSeenInClasspath',
            'last_seen_in_classpath': 'lastSeenInClasspath'
        }
        self._application_key = None
        self._application_name = None
        self._managed_instance_count = None
        self._last_detected_dynamically = None
        self._first_seen_in_classpath = None
        self._last_seen_in_classpath = None

    @property
    def application_key(self):
        """
        **[Required]** Gets the application_key of this LibraryApplicationUsageSummary.
        The internal identifier of a Java application.


        :return: The application_key of this LibraryApplicationUsageSummary.
        :rtype: str
        """
        return self._application_key

    @application_key.setter
    def application_key(self, application_key):
        """
        Sets the application_key of this LibraryApplicationUsageSummary.
        The internal identifier of a Java application.


        :param application_key: The application_key of this LibraryApplicationUsageSummary.
        :type: str
        """
        self._application_key = application_key

    @property
    def application_name(self):
        """
        **[Required]** Gets the application_name of this LibraryApplicationUsageSummary.
        The displayed name of the Java application.


        :return: The application_name of this LibraryApplicationUsageSummary.
        :rtype: str
        """
        return self._application_name

    @application_name.setter
    def application_name(self, application_name):
        """
        Sets the application_name of this LibraryApplicationUsageSummary.
        The displayed name of the Java application.


        :param application_name: The application_name of this LibraryApplicationUsageSummary.
        :type: str
        """
        self._application_name = application_name

    @property
    def managed_instance_count(self):
        """
        **[Required]** Gets the managed_instance_count of this LibraryApplicationUsageSummary.
        The count of managed instances wherein the specified library was detected.


        :return: The managed_instance_count of this LibraryApplicationUsageSummary.
        :rtype: int
        """
        return self._managed_instance_count

    @managed_instance_count.setter
    def managed_instance_count(self, managed_instance_count):
        """
        Sets the managed_instance_count of this LibraryApplicationUsageSummary.
        The count of managed instances wherein the specified library was detected.


        :param managed_instance_count: The managed_instance_count of this LibraryApplicationUsageSummary.
        :type: int
        """
        self._managed_instance_count = managed_instance_count

    @property
    def last_detected_dynamically(self):
        """
        **[Required]** Gets the last_detected_dynamically of this LibraryApplicationUsageSummary.
        The date and time a library or Java package was _last_ detected in a dynamic library scan.


        :return: The last_detected_dynamically of this LibraryApplicationUsageSummary.
        :rtype: datetime
        """
        return self._last_detected_dynamically

    @last_detected_dynamically.setter
    def last_detected_dynamically(self, last_detected_dynamically):
        """
        Sets the last_detected_dynamically of this LibraryApplicationUsageSummary.
        The date and time a library or Java package was _last_ detected in a dynamic library scan.


        :param last_detected_dynamically: The last_detected_dynamically of this LibraryApplicationUsageSummary.
        :type: datetime
        """
        self._last_detected_dynamically = last_detected_dynamically

    @property
    def first_seen_in_classpath(self):
        """
        **[Required]** Gets the first_seen_in_classpath of this LibraryApplicationUsageSummary.
        The timestamp of the first time the specified library was detected in classpath.


        :return: The first_seen_in_classpath of this LibraryApplicationUsageSummary.
        :rtype: datetime
        """
        return self._first_seen_in_classpath

    @first_seen_in_classpath.setter
    def first_seen_in_classpath(self, first_seen_in_classpath):
        """
        Sets the first_seen_in_classpath of this LibraryApplicationUsageSummary.
        The timestamp of the first time the specified library was detected in classpath.


        :param first_seen_in_classpath: The first_seen_in_classpath of this LibraryApplicationUsageSummary.
        :type: datetime
        """
        self._first_seen_in_classpath = first_seen_in_classpath

    @property
    def last_seen_in_classpath(self):
        """
        **[Required]** Gets the last_seen_in_classpath of this LibraryApplicationUsageSummary.
        The timestamp of the last time the specified library was detected in classpath.


        :return: The last_seen_in_classpath of this LibraryApplicationUsageSummary.
        :rtype: datetime
        """
        return self._last_seen_in_classpath

    @last_seen_in_classpath.setter
    def last_seen_in_classpath(self, last_seen_in_classpath):
        """
        Sets the last_seen_in_classpath of this LibraryApplicationUsageSummary.
        The timestamp of the last time the specified library was detected in classpath.


        :param last_seen_in_classpath: The last_seen_in_classpath of this LibraryApplicationUsageSummary.
        :type: datetime
        """
        self._last_seen_in_classpath = last_seen_in_classpath

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
