# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ScanLibraryUsageDetails(object):
    """
    The list of managed instances to scan.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ScanLibraryUsageDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param managed_instance_ids:
            The value to assign to the managed_instance_ids property of this ScanLibraryUsageDetails.
        :type managed_instance_ids: list[str]

        :param is_dynamic_scan:
            The value to assign to the is_dynamic_scan property of this ScanLibraryUsageDetails.
        :type is_dynamic_scan: bool

        :param dynamic_scan_duration_in_minutes:
            The value to assign to the dynamic_scan_duration_in_minutes property of this ScanLibraryUsageDetails.
        :type dynamic_scan_duration_in_minutes: int

        """
        self.swagger_types = {
            'managed_instance_ids': 'list[str]',
            'is_dynamic_scan': 'bool',
            'dynamic_scan_duration_in_minutes': 'int'
        }
        self.attribute_map = {
            'managed_instance_ids': 'managedInstanceIds',
            'is_dynamic_scan': 'isDynamicScan',
            'dynamic_scan_duration_in_minutes': 'dynamicScanDurationInMinutes'
        }
        self._managed_instance_ids = None
        self._is_dynamic_scan = None
        self._dynamic_scan_duration_in_minutes = None

    @property
    def managed_instance_ids(self):
        """
        Gets the managed_instance_ids of this ScanLibraryUsageDetails.
        The list of `OCIDs`__ of managed instances to scan.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The managed_instance_ids of this ScanLibraryUsageDetails.
        :rtype: list[str]
        """
        return self._managed_instance_ids

    @managed_instance_ids.setter
    def managed_instance_ids(self, managed_instance_ids):
        """
        Sets the managed_instance_ids of this ScanLibraryUsageDetails.
        The list of `OCIDs`__ of managed instances to scan.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param managed_instance_ids: The managed_instance_ids of this ScanLibraryUsageDetails.
        :type: list[str]
        """
        self._managed_instance_ids = managed_instance_ids

    @property
    def is_dynamic_scan(self):
        """
        Gets the is_dynamic_scan of this ScanLibraryUsageDetails.
        Indicates whether the scan is dynamic or static.


        :return: The is_dynamic_scan of this ScanLibraryUsageDetails.
        :rtype: bool
        """
        return self._is_dynamic_scan

    @is_dynamic_scan.setter
    def is_dynamic_scan(self, is_dynamic_scan):
        """
        Sets the is_dynamic_scan of this ScanLibraryUsageDetails.
        Indicates whether the scan is dynamic or static.


        :param is_dynamic_scan: The is_dynamic_scan of this ScanLibraryUsageDetails.
        :type: bool
        """
        self._is_dynamic_scan = is_dynamic_scan

    @property
    def dynamic_scan_duration_in_minutes(self):
        """
        Gets the dynamic_scan_duration_in_minutes of this ScanLibraryUsageDetails.
        The duration of the dynamic scan in minutes.


        :return: The dynamic_scan_duration_in_minutes of this ScanLibraryUsageDetails.
        :rtype: int
        """
        return self._dynamic_scan_duration_in_minutes

    @dynamic_scan_duration_in_minutes.setter
    def dynamic_scan_duration_in_minutes(self, dynamic_scan_duration_in_minutes):
        """
        Sets the dynamic_scan_duration_in_minutes of this ScanLibraryUsageDetails.
        The duration of the dynamic scan in minutes.


        :param dynamic_scan_duration_in_minutes: The dynamic_scan_duration_in_minutes of this ScanLibraryUsageDetails.
        :type: int
        """
        self._dynamic_scan_duration_in_minutes = dynamic_scan_duration_in_minutes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
