# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UncorrelatedPackageManagedInstanceUsageSummary(object):
    """
    Summary of a managed instance where a given uncorrelated package was detected. Contains the count of application where the package was detected with this application.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UncorrelatedPackageManagedInstanceUsageSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param managed_instance_id:
            The value to assign to the managed_instance_id property of this UncorrelatedPackageManagedInstanceUsageSummary.
        :type managed_instance_id: str

        :param hostname:
            The value to assign to the hostname property of this UncorrelatedPackageManagedInstanceUsageSummary.
        :type hostname: str

        :param application_count:
            The value to assign to the application_count property of this UncorrelatedPackageManagedInstanceUsageSummary.
        :type application_count: int

        :param last_detected_dynamically:
            The value to assign to the last_detected_dynamically property of this UncorrelatedPackageManagedInstanceUsageSummary.
        :type last_detected_dynamically: datetime

        """
        self.swagger_types = {
            'managed_instance_id': 'str',
            'hostname': 'str',
            'application_count': 'int',
            'last_detected_dynamically': 'datetime'
        }
        self.attribute_map = {
            'managed_instance_id': 'managedInstanceId',
            'hostname': 'hostname',
            'application_count': 'applicationCount',
            'last_detected_dynamically': 'lastDetectedDynamically'
        }
        self._managed_instance_id = None
        self._hostname = None
        self._application_count = None
        self._last_detected_dynamically = None

    @property
    def managed_instance_id(self):
        """
        **[Required]** Gets the managed_instance_id of this UncorrelatedPackageManagedInstanceUsageSummary.
        The `OCID`__ of the related managed instance.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The managed_instance_id of this UncorrelatedPackageManagedInstanceUsageSummary.
        :rtype: str
        """
        return self._managed_instance_id

    @managed_instance_id.setter
    def managed_instance_id(self, managed_instance_id):
        """
        Sets the managed_instance_id of this UncorrelatedPackageManagedInstanceUsageSummary.
        The `OCID`__ of the related managed instance.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param managed_instance_id: The managed_instance_id of this UncorrelatedPackageManagedInstanceUsageSummary.
        :type: str
        """
        self._managed_instance_id = managed_instance_id

    @property
    def hostname(self):
        """
        **[Required]** Gets the hostname of this UncorrelatedPackageManagedInstanceUsageSummary.
        The hostname of the managed instance.


        :return: The hostname of this UncorrelatedPackageManagedInstanceUsageSummary.
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """
        Sets the hostname of this UncorrelatedPackageManagedInstanceUsageSummary.
        The hostname of the managed instance.


        :param hostname: The hostname of this UncorrelatedPackageManagedInstanceUsageSummary.
        :type: str
        """
        self._hostname = hostname

    @property
    def application_count(self):
        """
        **[Required]** Gets the application_count of this UncorrelatedPackageManagedInstanceUsageSummary.
        The count of applications wherein the specified library was detected.


        :return: The application_count of this UncorrelatedPackageManagedInstanceUsageSummary.
        :rtype: int
        """
        return self._application_count

    @application_count.setter
    def application_count(self, application_count):
        """
        Sets the application_count of this UncorrelatedPackageManagedInstanceUsageSummary.
        The count of applications wherein the specified library was detected.


        :param application_count: The application_count of this UncorrelatedPackageManagedInstanceUsageSummary.
        :type: int
        """
        self._application_count = application_count

    @property
    def last_detected_dynamically(self):
        """
        **[Required]** Gets the last_detected_dynamically of this UncorrelatedPackageManagedInstanceUsageSummary.
        The date and time a library or Java package was _last_ detected in a dynamic library scan.


        :return: The last_detected_dynamically of this UncorrelatedPackageManagedInstanceUsageSummary.
        :rtype: datetime
        """
        return self._last_detected_dynamically

    @last_detected_dynamically.setter
    def last_detected_dynamically(self, last_detected_dynamically):
        """
        Sets the last_detected_dynamically of this UncorrelatedPackageManagedInstanceUsageSummary.
        The date and time a library or Java package was _last_ detected in a dynamic library scan.


        :param last_detected_dynamically: The last_detected_dynamically of this UncorrelatedPackageManagedInstanceUsageSummary.
        :type: datetime
        """
        self._last_detected_dynamically = last_detected_dynamically

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
