# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UncorrelatedPackageUsageSummary(object):
    """
    Summary of an uncorrelated package.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UncorrelatedPackageUsageSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param package_name:
            The value to assign to the package_name property of this UncorrelatedPackageUsageSummary.
        :type package_name: str

        :param managed_instance_count:
            The value to assign to the managed_instance_count property of this UncorrelatedPackageUsageSummary.
        :type managed_instance_count: int

        :param application_count:
            The value to assign to the application_count property of this UncorrelatedPackageUsageSummary.
        :type application_count: int

        :param last_detected_dynamically:
            The value to assign to the last_detected_dynamically property of this UncorrelatedPackageUsageSummary.
        :type last_detected_dynamically: datetime

        """
        self.swagger_types = {
            'package_name': 'str',
            'managed_instance_count': 'int',
            'application_count': 'int',
            'last_detected_dynamically': 'datetime'
        }
        self.attribute_map = {
            'package_name': 'packageName',
            'managed_instance_count': 'managedInstanceCount',
            'application_count': 'applicationCount',
            'last_detected_dynamically': 'lastDetectedDynamically'
        }
        self._package_name = None
        self._managed_instance_count = None
        self._application_count = None
        self._last_detected_dynamically = None

    @property
    def package_name(self):
        """
        **[Required]** Gets the package_name of this UncorrelatedPackageUsageSummary.
        The name of the package.


        :return: The package_name of this UncorrelatedPackageUsageSummary.
        :rtype: str
        """
        return self._package_name

    @package_name.setter
    def package_name(self, package_name):
        """
        Sets the package_name of this UncorrelatedPackageUsageSummary.
        The name of the package.


        :param package_name: The package_name of this UncorrelatedPackageUsageSummary.
        :type: str
        """
        self._package_name = package_name

    @property
    def managed_instance_count(self):
        """
        **[Required]** Gets the managed_instance_count of this UncorrelatedPackageUsageSummary.
        The count of managed instances wherein the specified package was detected.


        :return: The managed_instance_count of this UncorrelatedPackageUsageSummary.
        :rtype: int
        """
        return self._managed_instance_count

    @managed_instance_count.setter
    def managed_instance_count(self, managed_instance_count):
        """
        Sets the managed_instance_count of this UncorrelatedPackageUsageSummary.
        The count of managed instances wherein the specified package was detected.


        :param managed_instance_count: The managed_instance_count of this UncorrelatedPackageUsageSummary.
        :type: int
        """
        self._managed_instance_count = managed_instance_count

    @property
    def application_count(self):
        """
        **[Required]** Gets the application_count of this UncorrelatedPackageUsageSummary.
        The count of applications wherein the specified package was detected.


        :return: The application_count of this UncorrelatedPackageUsageSummary.
        :rtype: int
        """
        return self._application_count

    @application_count.setter
    def application_count(self, application_count):
        """
        Sets the application_count of this UncorrelatedPackageUsageSummary.
        The count of applications wherein the specified package was detected.


        :param application_count: The application_count of this UncorrelatedPackageUsageSummary.
        :type: int
        """
        self._application_count = application_count

    @property
    def last_detected_dynamically(self):
        """
        **[Required]** Gets the last_detected_dynamically of this UncorrelatedPackageUsageSummary.
        The date and time a library or Java package was _last_ detected in a dynamic library scan.


        :return: The last_detected_dynamically of this UncorrelatedPackageUsageSummary.
        :rtype: datetime
        """
        return self._last_detected_dynamically

    @last_detected_dynamically.setter
    def last_detected_dynamically(self, last_detected_dynamically):
        """
        Sets the last_detected_dynamically of this UncorrelatedPackageUsageSummary.
        The date and time a library or Java package was _last_ detected in a dynamic library scan.


        :param last_detected_dynamically: The last_detected_dynamically of this UncorrelatedPackageUsageSummary.
        :type: datetime
        """
        self._last_detected_dynamically = last_detected_dynamically

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
