# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TemplateParams(object):
    """
    Template key value params which can store template details like macro name and its parameter.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TemplateParams object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key_field:
            The value to assign to the key_field property of this TemplateParams.
        :type key_field: str

        :param value_field:
            The value to assign to the value_field property of this TemplateParams.
        :type value_field: str

        """
        self.swagger_types = {
            'key_field': 'str',
            'value_field': 'str'
        }
        self.attribute_map = {
            'key_field': 'keyField',
            'value_field': 'valueField'
        }
        self._key_field = None
        self._value_field = None

    @property
    def key_field(self):
        """
        **[Required]** Gets the key_field of this TemplateParams.
        Contains macro parameter's names.


        :return: The key_field of this TemplateParams.
        :rtype: str
        """
        return self._key_field

    @key_field.setter
    def key_field(self, key_field):
        """
        Sets the key_field of this TemplateParams.
        Contains macro parameter's names.


        :param key_field: The key_field of this TemplateParams.
        :type: str
        """
        self._key_field = key_field

    @property
    def value_field(self):
        """
        **[Required]** Gets the value_field of this TemplateParams.
        Contains macro parameter's value.


        :return: The value_field of this TemplateParams.
        :rtype: str
        """
        return self._value_field

    @value_field.setter
    def value_field(self, value_field):
        """
        Sets the value_field of this TemplateParams.
        Contains macro parameter's value.


        :param value_field: The value_field of this TemplateParams.
        :type: str
        """
        self._value_field = value_field

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
