# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201

from .create_listing_revision_attachment_details import CreateListingRevisionAttachmentDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateSupportedServiceAttachment(CreateListingRevisionAttachmentDetails):
    """
    Supported service attachment for the listing revision.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateSupportedServiceAttachment object with values from keyword arguments. The default value of the :py:attr:`~oci.marketplace_publisher.models.CreateSupportedServiceAttachment.attachment_type` attribute
        of this class is ``SUPPORTED_SERVICES`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param listing_revision_id:
            The value to assign to the listing_revision_id property of this CreateSupportedServiceAttachment.
        :type listing_revision_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateSupportedServiceAttachment.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateSupportedServiceAttachment.
        :type description: str

        :param attachment_type:
            The value to assign to the attachment_type property of this CreateSupportedServiceAttachment.
        :type attachment_type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateSupportedServiceAttachment.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateSupportedServiceAttachment.
        :type defined_tags: dict(str, dict(str, object))

        :param service_name:
            The value to assign to the service_name property of this CreateSupportedServiceAttachment.
        :type service_name: str

        :param url:
            The value to assign to the url property of this CreateSupportedServiceAttachment.
        :type url: str

        :param type:
            The value to assign to the type property of this CreateSupportedServiceAttachment.
        :type type: str

        """
        self.swagger_types = {
            'listing_revision_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'attachment_type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'service_name': 'str',
            'url': 'str',
            'type': 'str'
        }
        self.attribute_map = {
            'listing_revision_id': 'listingRevisionId',
            'display_name': 'displayName',
            'description': 'description',
            'attachment_type': 'attachmentType',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'service_name': 'serviceName',
            'url': 'url',
            'type': 'type'
        }
        self._listing_revision_id = None
        self._display_name = None
        self._description = None
        self._attachment_type = None
        self._freeform_tags = None
        self._defined_tags = None
        self._service_name = None
        self._url = None
        self._type = None
        self._attachment_type = 'SUPPORTED_SERVICES'

    @property
    def service_name(self):
        """
        **[Required]** Gets the service_name of this CreateSupportedServiceAttachment.
        Name of the service


        :return: The service_name of this CreateSupportedServiceAttachment.
        :rtype: str
        """
        return self._service_name

    @service_name.setter
    def service_name(self, service_name):
        """
        Sets the service_name of this CreateSupportedServiceAttachment.
        Name of the service


        :param service_name: The service_name of this CreateSupportedServiceAttachment.
        :type: str
        """
        self._service_name = service_name

    @property
    def url(self):
        """
        Gets the url of this CreateSupportedServiceAttachment.
        Optional url to service information


        :return: The url of this CreateSupportedServiceAttachment.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this CreateSupportedServiceAttachment.
        Optional url to service information


        :param url: The url of this CreateSupportedServiceAttachment.
        :type: str
        """
        self._url = url

    @property
    def type(self):
        """
        **[Required]** Gets the type of this CreateSupportedServiceAttachment.
        Type of the service


        :return: The type of this CreateSupportedServiceAttachment.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CreateSupportedServiceAttachment.
        Type of the service


        :param type: The type of this CreateSupportedServiceAttachment.
        :type: str
        """
        self._type = type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
