# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MachineImagePackageDetails(object):
    """
    Replicated Machine Image package information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MachineImagePackageDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compute_image_id:
            The value to assign to the compute_image_id property of this MachineImagePackageDetails.
        :type compute_image_id: str

        :param compute_app_catalog_id:
            The value to assign to the compute_app_catalog_id property of this MachineImagePackageDetails.
        :type compute_app_catalog_id: str

        :param compute_package_version:
            The value to assign to the compute_package_version property of this MachineImagePackageDetails.
        :type compute_package_version: str

        """
        self.swagger_types = {
            'compute_image_id': 'str',
            'compute_app_catalog_id': 'str',
            'compute_package_version': 'str'
        }
        self.attribute_map = {
            'compute_image_id': 'computeImageId',
            'compute_app_catalog_id': 'computeAppCatalogId',
            'compute_package_version': 'computePackageVersion'
        }
        self._compute_image_id = None
        self._compute_app_catalog_id = None
        self._compute_package_version = None

    @property
    def compute_image_id(self):
        """
        Gets the compute_image_id of this MachineImagePackageDetails.
        Replicated Image OCID.


        :return: The compute_image_id of this MachineImagePackageDetails.
        :rtype: str
        """
        return self._compute_image_id

    @compute_image_id.setter
    def compute_image_id(self, compute_image_id):
        """
        Sets the compute_image_id of this MachineImagePackageDetails.
        Replicated Image OCID.


        :param compute_image_id: The compute_image_id of this MachineImagePackageDetails.
        :type: str
        """
        self._compute_image_id = compute_image_id

    @property
    def compute_app_catalog_id(self):
        """
        Gets the compute_app_catalog_id of this MachineImagePackageDetails.
        Replicated Images App Catalog Listing OCID.


        :return: The compute_app_catalog_id of this MachineImagePackageDetails.
        :rtype: str
        """
        return self._compute_app_catalog_id

    @compute_app_catalog_id.setter
    def compute_app_catalog_id(self, compute_app_catalog_id):
        """
        Sets the compute_app_catalog_id of this MachineImagePackageDetails.
        Replicated Images App Catalog Listing OCID.


        :param compute_app_catalog_id: The compute_app_catalog_id of this MachineImagePackageDetails.
        :type: str
        """
        self._compute_app_catalog_id = compute_app_catalog_id

    @property
    def compute_package_version(self):
        """
        Gets the compute_package_version of this MachineImagePackageDetails.
        Replicated Images Package version.


        :return: The compute_package_version of this MachineImagePackageDetails.
        :rtype: str
        """
        return self._compute_package_version

    @compute_package_version.setter
    def compute_package_version(self, compute_package_version):
        """
        Sets the compute_package_version of this MachineImagePackageDetails.
        Replicated Images Package version.


        :param compute_package_version: The compute_package_version of this MachineImagePackageDetails.
        :type: str
        """
        self._compute_package_version = compute_package_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
