# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828

from .cloud_service_provider_metadata_item import CloudServiceProviderMetadataItem
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AwsCloudServiceProviderMetadataItem(CloudServiceProviderMetadataItem):
    """
    Aws Cloud Service Provider metadata item.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AwsCloudServiceProviderMetadataItem object with values from keyword arguments. The default value of the :py:attr:`~oci.multicloud.models.AwsCloudServiceProviderMetadataItem.subscription_type` attribute
        of this class is ``ORACLEDBATAWS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param region:
            The value to assign to the region property of this AwsCloudServiceProviderMetadataItem.
        :type region: str

        :param resource_anchor_name:
            The value to assign to the resource_anchor_name property of this AwsCloudServiceProviderMetadataItem.
        :type resource_anchor_name: str

        :param resource_anchor_uri:
            The value to assign to the resource_anchor_uri property of this AwsCloudServiceProviderMetadataItem.
        :type resource_anchor_uri: str

        :param subscription_type:
            The value to assign to the subscription_type property of this AwsCloudServiceProviderMetadataItem.
            Allowed values for this property are: "ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"
        :type subscription_type: str

        :param account_id:
            The value to assign to the account_id property of this AwsCloudServiceProviderMetadataItem.
        :type account_id: str

        """
        self.swagger_types = {
            'region': 'str',
            'resource_anchor_name': 'str',
            'resource_anchor_uri': 'str',
            'subscription_type': 'str',
            'account_id': 'str'
        }
        self.attribute_map = {
            'region': 'region',
            'resource_anchor_name': 'resourceAnchorName',
            'resource_anchor_uri': 'resourceAnchorUri',
            'subscription_type': 'subscriptionType',
            'account_id': 'accountId'
        }
        self._region = None
        self._resource_anchor_name = None
        self._resource_anchor_uri = None
        self._subscription_type = None
        self._account_id = None
        self._subscription_type = 'ORACLEDBATAWS'

    @property
    def account_id(self):
        """
        **[Required]** Gets the account_id of this AwsCloudServiceProviderMetadataItem.
        AWS accountId that was used for creating this resource anchor resource.


        :return: The account_id of this AwsCloudServiceProviderMetadataItem.
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """
        Sets the account_id of this AwsCloudServiceProviderMetadataItem.
        AWS accountId that was used for creating this resource anchor resource.


        :param account_id: The account_id of this AwsCloudServiceProviderMetadataItem.
        :type: str
        """
        self._account_id = account_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
