# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciNetworkMetadata(object):
    """
    Oracle Cloud Infrastructure network anchor related meta data items
    """

    #: A constant which can be used with the network_anchor_connection_status property of a OciNetworkMetadata.
    #: This constant has a value of "CONNECTED"
    NETWORK_ANCHOR_CONNECTION_STATUS_CONNECTED = "CONNECTED"

    #: A constant which can be used with the network_anchor_connection_status property of a OciNetworkMetadata.
    #: This constant has a value of "DISCONNECTED"
    NETWORK_ANCHOR_CONNECTION_STATUS_DISCONNECTED = "DISCONNECTED"

    #: A constant which can be used with the network_anchor_connection_status property of a OciNetworkMetadata.
    #: This constant has a value of "CONNECTING"
    NETWORK_ANCHOR_CONNECTION_STATUS_CONNECTING = "CONNECTING"

    #: A constant which can be used with the network_anchor_connection_status property of a OciNetworkMetadata.
    #: This constant has a value of "ACTIVE"
    NETWORK_ANCHOR_CONNECTION_STATUS_ACTIVE = "ACTIVE"

    #: A constant which can be used with the network_anchor_connection_status property of a OciNetworkMetadata.
    #: This constant has a value of "ERROR"
    NETWORK_ANCHOR_CONNECTION_STATUS_ERROR = "ERROR"

    #: A constant which can be used with the network_anchor_connection_status property of a OciNetworkMetadata.
    #: This constant has a value of "UPDATING"
    NETWORK_ANCHOR_CONNECTION_STATUS_UPDATING = "UPDATING"

    #: A constant which can be used with the network_anchor_connection_status property of a OciNetworkMetadata.
    #: This constant has a value of "NEEDS_ATTENTION"
    NETWORK_ANCHOR_CONNECTION_STATUS_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the network_anchor_connection_status property of a OciNetworkMetadata.
    #: This constant has a value of "FAILED"
    NETWORK_ANCHOR_CONNECTION_STATUS_FAILED = "FAILED"

    #: A constant which can be used with the network_anchor_connection_status property of a OciNetworkMetadata.
    #: This constant has a value of "DELETING"
    NETWORK_ANCHOR_CONNECTION_STATUS_DELETING = "DELETING"

    #: A constant which can be used with the network_anchor_connection_status property of a OciNetworkMetadata.
    #: This constant has a value of "DELETED"
    NETWORK_ANCHOR_CONNECTION_STATUS_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new OciNetworkMetadata object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param network_anchor_connection_status:
            The value to assign to the network_anchor_connection_status property of this OciNetworkMetadata.
            Allowed values for this property are: "CONNECTED", "DISCONNECTED", "CONNECTING", "ACTIVE", "ERROR", "UPDATING", "NEEDS_ATTENTION", "FAILED", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type network_anchor_connection_status: str

        :param vcn:
            The value to assign to the vcn property of this OciNetworkMetadata.
        :type vcn: oci.multicloud.models.OciVcn

        :param dns:
            The value to assign to the dns property of this OciNetworkMetadata.
        :type dns: oci.multicloud.models.OciDns

        :param subnets:
            The value to assign to the subnets property of this OciNetworkMetadata.
        :type subnets: list[oci.multicloud.models.OciNetworkSubnet]

        :param dns_listening_endpoint_ip_address:
            The value to assign to the dns_listening_endpoint_ip_address property of this OciNetworkMetadata.
        :type dns_listening_endpoint_ip_address: str

        :param dns_forwarding_endpoint_ip_address:
            The value to assign to the dns_forwarding_endpoint_ip_address property of this OciNetworkMetadata.
        :type dns_forwarding_endpoint_ip_address: str

        :param dns_forwarding_config:
            The value to assign to the dns_forwarding_config property of this OciNetworkMetadata.
        :type dns_forwarding_config: list[dict(str, str)]

        """
        self.swagger_types = {
            'network_anchor_connection_status': 'str',
            'vcn': 'OciVcn',
            'dns': 'OciDns',
            'subnets': 'list[OciNetworkSubnet]',
            'dns_listening_endpoint_ip_address': 'str',
            'dns_forwarding_endpoint_ip_address': 'str',
            'dns_forwarding_config': 'list[dict(str, str)]'
        }
        self.attribute_map = {
            'network_anchor_connection_status': 'networkAnchorConnectionStatus',
            'vcn': 'vcn',
            'dns': 'dns',
            'subnets': 'subnets',
            'dns_listening_endpoint_ip_address': 'dnsListeningEndpointIpAddress',
            'dns_forwarding_endpoint_ip_address': 'dnsForwardingEndpointIpAddress',
            'dns_forwarding_config': 'dnsForwardingConfig'
        }
        self._network_anchor_connection_status = None
        self._vcn = None
        self._dns = None
        self._subnets = None
        self._dns_listening_endpoint_ip_address = None
        self._dns_forwarding_endpoint_ip_address = None
        self._dns_forwarding_config = None

    @property
    def network_anchor_connection_status(self):
        """
        **[Required]** Gets the network_anchor_connection_status of this OciNetworkMetadata.
        This can be merge to lifecycleState
        CONNECTED - Partner and CSI information is assigned and MulticloudLink provisioned.
        DISCONNECTED - Only partner cloud information is assigned.
        CONNECTING - Oracle Cloud Infrastructure information is assigned and the control plane is provisioning resources.
        ACTIVE - Network anchor is connected and resources (VNICs) exist within a subnet.
        ERROR - DRG attach fails during connection.
        FAILED - Network anchor creation failed
        NEEDS_ATTENTION - Network anchor is in temporary bad state
        UPDATING - Network anchor is getting updated.
        DELETING - Network anchor is getting deleted
        DELETED - A connected network anchor is deleted.

        Allowed values for this property are: "CONNECTED", "DISCONNECTED", "CONNECTING", "ACTIVE", "ERROR", "UPDATING", "NEEDS_ATTENTION", "FAILED", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The network_anchor_connection_status of this OciNetworkMetadata.
        :rtype: str
        """
        return self._network_anchor_connection_status

    @network_anchor_connection_status.setter
    def network_anchor_connection_status(self, network_anchor_connection_status):
        """
        Sets the network_anchor_connection_status of this OciNetworkMetadata.
        This can be merge to lifecycleState
        CONNECTED - Partner and CSI information is assigned and MulticloudLink provisioned.
        DISCONNECTED - Only partner cloud information is assigned.
        CONNECTING - Oracle Cloud Infrastructure information is assigned and the control plane is provisioning resources.
        ACTIVE - Network anchor is connected and resources (VNICs) exist within a subnet.
        ERROR - DRG attach fails during connection.
        FAILED - Network anchor creation failed
        NEEDS_ATTENTION - Network anchor is in temporary bad state
        UPDATING - Network anchor is getting updated.
        DELETING - Network anchor is getting deleted
        DELETED - A connected network anchor is deleted.


        :param network_anchor_connection_status: The network_anchor_connection_status of this OciNetworkMetadata.
        :type: str
        """
        allowed_values = ["CONNECTED", "DISCONNECTED", "CONNECTING", "ACTIVE", "ERROR", "UPDATING", "NEEDS_ATTENTION", "FAILED", "DELETING", "DELETED"]
        if not value_allowed_none_or_none_sentinel(network_anchor_connection_status, allowed_values):
            network_anchor_connection_status = 'UNKNOWN_ENUM_VALUE'
        self._network_anchor_connection_status = network_anchor_connection_status

    @property
    def vcn(self):
        """
        Gets the vcn of this OciNetworkMetadata.

        :return: The vcn of this OciNetworkMetadata.
        :rtype: oci.multicloud.models.OciVcn
        """
        return self._vcn

    @vcn.setter
    def vcn(self, vcn):
        """
        Sets the vcn of this OciNetworkMetadata.

        :param vcn: The vcn of this OciNetworkMetadata.
        :type: oci.multicloud.models.OciVcn
        """
        self._vcn = vcn

    @property
    def dns(self):
        """
        Gets the dns of this OciNetworkMetadata.

        :return: The dns of this OciNetworkMetadata.
        :rtype: oci.multicloud.models.OciDns
        """
        return self._dns

    @dns.setter
    def dns(self, dns):
        """
        Sets the dns of this OciNetworkMetadata.

        :param dns: The dns of this OciNetworkMetadata.
        :type: oci.multicloud.models.OciDns
        """
        self._dns = dns

    @property
    def subnets(self):
        """
        Gets the subnets of this OciNetworkMetadata.
        Network subnets


        :return: The subnets of this OciNetworkMetadata.
        :rtype: list[oci.multicloud.models.OciNetworkSubnet]
        """
        return self._subnets

    @subnets.setter
    def subnets(self, subnets):
        """
        Sets the subnets of this OciNetworkMetadata.
        Network subnets


        :param subnets: The subnets of this OciNetworkMetadata.
        :type: list[oci.multicloud.models.OciNetworkSubnet]
        """
        self._subnets = subnets

    @property
    def dns_listening_endpoint_ip_address(self):
        """
        Gets the dns_listening_endpoint_ip_address of this OciNetworkMetadata.
        The DNS Listener Endpoint Address.


        :return: The dns_listening_endpoint_ip_address of this OciNetworkMetadata.
        :rtype: str
        """
        return self._dns_listening_endpoint_ip_address

    @dns_listening_endpoint_ip_address.setter
    def dns_listening_endpoint_ip_address(self, dns_listening_endpoint_ip_address):
        """
        Sets the dns_listening_endpoint_ip_address of this OciNetworkMetadata.
        The DNS Listener Endpoint Address.


        :param dns_listening_endpoint_ip_address: The dns_listening_endpoint_ip_address of this OciNetworkMetadata.
        :type: str
        """
        self._dns_listening_endpoint_ip_address = dns_listening_endpoint_ip_address

    @property
    def dns_forwarding_endpoint_ip_address(self):
        """
        Gets the dns_forwarding_endpoint_ip_address of this OciNetworkMetadata.
        The DNS Listener Forwarding Address.


        :return: The dns_forwarding_endpoint_ip_address of this OciNetworkMetadata.
        :rtype: str
        """
        return self._dns_forwarding_endpoint_ip_address

    @dns_forwarding_endpoint_ip_address.setter
    def dns_forwarding_endpoint_ip_address(self, dns_forwarding_endpoint_ip_address):
        """
        Sets the dns_forwarding_endpoint_ip_address of this OciNetworkMetadata.
        The DNS Listener Forwarding Address.


        :param dns_forwarding_endpoint_ip_address: The dns_forwarding_endpoint_ip_address of this OciNetworkMetadata.
        :type: str
        """
        self._dns_forwarding_endpoint_ip_address = dns_forwarding_endpoint_ip_address

    @property
    def dns_forwarding_config(self):
        """
        Gets the dns_forwarding_config of this OciNetworkMetadata.
        DNS forward configuration


        :return: The dns_forwarding_config of this OciNetworkMetadata.
        :rtype: list[dict(str, str)]
        """
        return self._dns_forwarding_config

    @dns_forwarding_config.setter
    def dns_forwarding_config(self, dns_forwarding_config):
        """
        Sets the dns_forwarding_config of this OciNetworkMetadata.
        DNS forward configuration


        :param dns_forwarding_config: The dns_forwarding_config of this OciNetworkMetadata.
        :type: list[dict(str, str)]
        """
        self._dns_forwarding_config = dns_forwarding_config

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
